/*
 Highcharts Gantt JS v11.0.0 (2023-04-26)

 Tree Grid

 (c) 2016-2021 Jon Arild Nygard

 License: www.highcharts.com/license
*/
'use strict';(function(g){"object"===typeof module&&module.exports?(g["default"]=g,module.exports=g):"function"===typeof define&&define.amd?define("highcharts/modules/treegrid",["highcharts"],function(z){g(z);g.Highcharts=z;return g}):g("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(g){function z(g,v,t,K){g.hasOwnProperty(v)||(g[v]=K.apply(null,t),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:v,module:g[v]}})))}g=g?g._modules:
{};z(g,"Core/Axis/BrokenAxis.js",[g["Core/Axis/Stacking/StackItem.js"],g["Core/Utilities.js"]],function(g,v){const {addEvent:t,find:K,fireEvent:E,isArray:B,isNumber:p,pick:u}=v;var w;(function(a){function y(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function F(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function q(){const k=this.brokenAxis;if(k&&k.hasBreaks){const b=this.tickPositions,a=this.tickPositions.info,d=[];for(let a=
0;a<b.length;a++)k.isInAnyBreak(b[a])||d.push(b[a]);this.tickPositions=d;this.tickPositions.info=a}}function c(){this.brokenAxis||(this.brokenAxis=new D(this))}function H(){const {isDirty:k,options:{connectNulls:b},points:a,xAxis:d,yAxis:c}=this;if(k){let e=a.length;for(;e--;){const k=a[e],C=!(null===k.y&&!1===b)&&(d&&d.brokenAxis&&d.brokenAxis.isInAnyBreak(k.x,!0)||c&&c.brokenAxis&&c.brokenAxis.isInAnyBreak(k.y,!0));k.visible=C?!1:!1!==k.options.visible}}}function l(){this.drawBreaks(this.xAxis,
["x"]);this.drawBreaks(this.yAxis,u(this.pointArrayMap,["y"]))}function f(k,a){const b=this,d=b.points;let c,e,n,x;if(k&&k.brokenAxis&&k.brokenAxis.hasBreaks){const C=k.brokenAxis;a.forEach(function(a){c=C&&C.breakArray||[];e=k.isXAxis?k.min:u(b.options.threshold,k.min);d.forEach(function(d){x=u(d["stack"+a.toUpperCase()],d[a]);c.forEach(function(a){if(p(e)&&p(x)){n=!1;if(e<a.from&&x>a.to||e>a.from&&x<a.from)n="pointBreak";else if(e<a.from&&x>a.from&&x<a.to||e>a.from&&x>a.to&&x<a.from)n="pointInBreak";
n&&E(k,n,{point:d,brk:a})}})})})}}function m(){var a=this.currentDataGrouping,b=a&&a.gapSize;a=this.points.slice();const c=this.yAxis;let d=this.options.gapSize,f=a.length-1;var e;if(d&&0<f)for("value"!==this.options.gapUnit&&(d*=this.basePointRange),b&&b>d&&b>=this.basePointRange&&(d=b);f--;)e&&!1!==e.visible||(e=a[f+1]),b=a[f],!1!==e.visible&&!1!==b.visible&&(e.x-b.x>d&&(e=(b.x+e.x)/2,a.splice(f+1,0,{isNull:!0,x:e}),c.stacking&&this.options.stacking&&(e=c.stacking.stacks[this.stackKey][e]=new g(c,
c.options.stackLabels,!1,e,this.stack),e.total=0)),e=b);return this.getGraphPath(a)}const r=[];a.compose=function(a,b){v.pushUnique(r,a)&&(a.keepProps.push("brokenAxis"),t(a,"init",c),t(a,"afterInit",y),t(a,"afterSetTickPositions",q),t(a,"afterSetOptions",F));if(v.pushUnique(r,b)){const a=b.prototype;a.drawBreaks=f;a.gappedPath=m;t(b,"afterGeneratePoints",H);t(b,"afterRender",l)}return a};class D{static isInBreak(a,b){const c=a.repeat||Infinity,d=a.from,k=a.to-a.from;b=b>=d?(b-d)%c:c-(d-b)%c;return a.inclusive?
b<=k:b<k&&0!==b}static lin2Val(a){var b=this.brokenAxis;b=b&&b.breakArray;if(!b||!p(a))return a;let c,d;for(d=0;d<b.length&&!(c=b[d],c.from>=a);d++)c.to<a?a+=c.len:D.isInBreak(c,a)&&(a+=c.len);return a}static val2Lin(a){var b=this.brokenAxis;b=b&&b.breakArray;if(!b||!p(a))return a;let c=a,d,f;for(f=0;f<b.length;f++)if(d=b[f],d.to<=a)c-=d.len;else if(d.from>=a)break;else if(D.isInBreak(d,a)){c-=a-d.from;break}return c}constructor(a){this.hasBreaks=!1;this.axis=a}findBreakAt(a,b){return K(b,function(b){return b.from<
a&&a<b.to})}isInAnyBreak(a,b){const c=this.axis,d=c.options.breaks||[];let f=d.length,e,n,x;if(f&&p(a)){for(;f--;)D.isInBreak(d[f],a)&&(e=!0,n||(n=u(d[f].showPoints,!c.isXAxis)));x=e&&b?e&&!n:e}return x}setBreaks(a,b){const c=this,d=c.axis,f=B(a)&&!!a.length;d.isDirty=c.hasBreaks!==f;c.hasBreaks=f;d.options.breaks=d.userOptions.breaks=a;d.forceRedraw=!0;d.series.forEach(function(a){a.isDirty=!0});f||d.val2lin!==D.val2Lin||(delete d.val2lin,delete d.lin2val);f&&(d.userOptions.ordinal=!1,d.lin2val=
D.lin2Val,d.val2lin=D.val2Lin,d.setExtremes=function(a,b,f,G,m){if(c.hasBreaks){const d=this.options.breaks||[];let e;for(;e=c.findBreakAt(a,d);)a=e.to;for(;e=c.findBreakAt(b,d);)b=e.from;b<a&&(b=a)}d.constructor.prototype.setExtremes.call(this,a,b,f,G,m)},d.setAxisTranslation=function(){d.constructor.prototype.setAxisTranslation.call(this);c.unitLength=void 0;if(c.hasBreaks){const a=d.options.breaks||[],b=[],f=[],G=u(d.pointRangePadding,0);let m=0,q,r,k=d.userMin||d.min,l=d.userMax||d.max,h,A;a.forEach(function(h){r=
h.repeat||Infinity;p(k)&&p(l)&&(D.isInBreak(h,k)&&(k+=h.to%r-k%r),D.isInBreak(h,l)&&(l-=l%r-h.from%r))});a.forEach(function(a){h=a.from;r=a.repeat||Infinity;if(p(k)&&p(l)){for(;h-r>k;)h-=r;for(;h<k;)h+=r;for(A=h;A<l;A+=r)b.push({value:A,move:"in"}),b.push({value:A+a.to-a.from,move:"out",size:a.breakSize})}});b.sort(function(h,a){return h.value===a.value?("in"===h.move?0:1)-("in"===a.move?0:1):h.value-a.value});q=0;h=k;b.forEach(function(a){q+="in"===a.move?1:-1;1===q&&"in"===a.move&&(h=a.value);0===
q&&p(h)&&(f.push({from:h,to:a.value,len:a.value-h-(a.size||0)}),m+=a.value-h-(a.size||0))});c.breakArray=f;p(k)&&p(l)&&p(d.min)&&(c.unitLength=l-k-m+G,E(d,"afterBreaks"),d.staticScale?d.transA=d.staticScale:c.unitLength&&(d.transA*=(l-d.min+G)/c.unitLength),G&&(d.minPixelPadding=d.transA*(d.minPointOffset||0)),d.min=k,d.max=l)}});u(b,!0)&&d.chart.redraw()}}a.Additions=D})(w||(w={}));return w});z(g,"Core/Axis/GridAxis.js",[g["Core/Axis/Axis.js"],g["Core/Globals.js"],g["Core/Utilities.js"]],function(g,
v,t){function E(a,A){const h={width:0,height:0};A.forEach(function(A){A=a[A];let c,b;t.isObject(A,!0)&&(b=t.isObject(A.label,!0)?A.label:{},A=b.getBBox?b.getBBox().height:0,b.textStr&&!n(b.textPxLength)&&(b.textPxLength=b.getBBox().width),c=n(b.textPxLength)?Math.round(b.textPxLength):0,b.textStr&&(c=Math.round(b.getBBox().width)),h.height=Math.max(A,h.height),h.width=Math.max(c,h.width))});"treegrid"===this.options.type&&this.treeGrid&&this.treeGrid.mapOfPosToGridNode&&(h.width+=this.options.labels.indentation*
((this.treeGrid.mapOfPosToGridNode[-1].height||0)-1));return h}function z(){const {grid:a}=this;(a&&a.columns||[]).forEach(function(a){a.getOffset()})}function B(a){if(!0===(this.options.grid||{}).enabled){const {axisTitle:b,height:A,horiz:c,left:d,offset:e,opposite:f,options:n,top:m,width:r}=this;var h=this.tickSize();const k=b&&b.getBBox().width,x=n.title.x,l=n.title.y,q=G(n.title.margin,c?5:10),H=b?this.chart.renderer.fontMetrics(b).f:0;h=(c?m+A:d)+(c?1:-1)*(f?-1:1)*(h?h[0]/2:0)+(this.side===I.bottom?
H:0);a.titlePosition.x=c?d-(k||0)/2-q+x:h+(f?r:0)+e+x;a.titlePosition.y=c?h-(f?A:0)+(f?H:-H)/2+e+l:m-q+l}}function p(){const {chart:a,options:{grid:b={}},userOptions:c}=this;if(b.enabled){var e=this.options;e.labels.align=G(e.labels.align,"center");this.categories||(e.showLastLabel=!1);this.labelRotation=0;e.labels.rotation=0}if(b.columns){e=this.grid.columns=[];let h=this.grid.columnIndex=0;for(;++h<b.columns.length;){var f=x(c,b.columns[b.columns.length-h-1],{linkedTo:0,type:"category",scrollbar:{enabled:!1}});
delete f.grid.columns;f=new g(this.chart,f);f.grid.isColumn=!0;f.grid.columnIndex=h;d(a.axes,f);d(a[this.coll],f);e.push(f)}}}function u(){var a=this.grid,b=this.options;if(!0===(b.grid||{}).enabled){var c=this.min||0;const h=this.max||0;this.maxLabelDimensions=this.getMaxLabelDimensions(this.ticks,this.tickPositions);this.rightWall&&this.rightWall.destroy();if(this.grid&&this.grid.isOuterAxis()&&this.axisLine){var d=b.lineWidth;if(d){d=this.getLinePath(d);var e=d[0],f=d[1],n=((this.tickSize("tick")||
[1])[0]-1)*(this.side===I.top||this.side===I.left?-1:1);"M"===e[0]&&"L"===f[0]&&(this.horiz?(e[2]+=n,f[2]+=n):(e[1]+=n,f[1]+=n));!this.horiz&&this.chart.marginRight&&(e=[e,["L",this.left,e[2]||0]],n=["L",this.chart.chartWidth-this.chart.marginRight,this.toPixels(h+this.tickmarkOffset)],f=[["M",f[1]||0,this.toPixels(h+this.tickmarkOffset)],n],this.grid.upperBorder||0===c%1||(this.grid.upperBorder=this.grid.renderBorder(e)),this.grid.upperBorder&&(this.grid.upperBorder.attr({stroke:b.lineColor,"stroke-width":b.lineWidth}),
this.grid.upperBorder.animate({d:e})),this.grid.lowerBorder||0===h%1||(this.grid.lowerBorder=this.grid.renderBorder(f)),this.grid.lowerBorder&&(this.grid.lowerBorder.attr({stroke:b.lineColor,"stroke-width":b.lineWidth}),this.grid.lowerBorder.animate({d:f})));this.grid.axisLineExtra?(this.grid.axisLineExtra.attr({stroke:b.lineColor,"stroke-width":b.lineWidth}),this.grid.axisLineExtra.animate({d})):this.grid.axisLineExtra=this.grid.renderBorder(d);this.axisLine[this.showAxis?"show":"hide"]()}}(a&&a.columns||
[]).forEach(a=>a.render());if(!this.horiz&&this.chart.hasRendered&&(this.scrollbar||this.linkedParent&&this.linkedParent.scrollbar)){a=this.tickmarkOffset;b=this.tickPositions[this.tickPositions.length-1];d=this.tickPositions[0];let e,f;for(;(e=this.hiddenLabels.pop())&&e.element;)e.show();for(;(f=this.hiddenMarks.pop())&&f.element;)f.show();(e=this.ticks[d].label)&&(c-d>a?this.hiddenLabels.push(e.hide()):e.show());(e=this.ticks[b].label)&&(b-h>a?this.hiddenLabels.push(e.hide()):e.show());(c=this.ticks[b].mark)&&
b-h<a&&0<b-h&&this.ticks[b].isLast&&this.hiddenMarks.push(c.hide())}}}function w(){const a=this.tickPositions&&this.tickPositions.info,b=this.options,c=this.userOptions.labels||{};(b.grid||{}).enabled&&(this.horiz?(this.series.forEach(a=>{a.options.pointRange=0}),a&&b.dateTimeLabelFormats&&b.labels&&!C(c.align)&&(!1===b.dateTimeLabelFormats[a.unitName].range||1<a.count)&&(b.labels.align="left",C(c.x)||(b.labels.x=3))):"treegrid"!==this.options.type&&this.grid&&this.grid.columns&&(this.minPointOffset=
this.tickInterval))}function a(a){const h=this.options;a=a.userOptions;const b=h&&t.isObject(h.grid,!0)?h.grid:{};let c;!0===b.enabled&&(c=x(!0,{className:"highcharts-grid-axis "+(a.className||""),dateTimeLabelFormats:{hour:{list:["%H:%M","%H"]},day:{list:["%A, %e. %B","%a, %e. %b","%E"]},week:{list:["Week %W","W%W"]},month:{list:["%B","%b","%o"]}},grid:{borderWidth:1},labels:{padding:2,style:{fontSize:"0.9em"}},margin:0,title:{text:null,reserveSpace:!1,rotation:0},units:[["millisecond",[1,10,100]],
["second",[1,10]],["minute",[1,5,15]],["hour",[1,6]],["day",[1]],["week",[1]],["month",[1]],["year",null]]},a),"xAxis"===this.coll&&(C(a.linkedTo)&&!C(a.tickPixelInterval)&&(c.tickPixelInterval=350),C(a.tickPixelInterval)||!C(a.linkedTo)||C(a.tickPositioner)||C(a.tickInterval)||(c.tickPositioner=function(a,h){var b=this.linkedParent&&this.linkedParent.tickPositions&&this.linkedParent.tickPositions.info;if(b){var e=c.units||[];let f;var d=1;let A="year";for(let a=0;a<e.length;a++){const h=e[a];if(h&&
h[0]===b.unitName){f=a;break}}(e=n(f)&&e[f+1])?(A=e[0]||"year",d=(d=e[1])&&d[0]||1):"year"===b.unitName&&(d=10*b.count);b=N[A];this.tickInterval=b*d;return this.chart.time.getTimeTicks({unitRange:b,count:d,unitName:A},a,h,this.options.startOfWeek)}})),x(!0,this.options,c),this.horiz&&(h.minPadding=G(a.minPadding,0),h.maxPadding=G(a.maxPadding,0)),n(h.grid.borderWidth)&&(h.tickWidth=h.lineWidth=b.borderWidth))}function y(a){a=(a=a.userOptions)&&a.grid||{};const h=a.columns;a.enabled&&h&&x(!0,this.options,
h[h.length-1])}function F(){(this.grid.columns||[]).forEach(a=>a.setScale())}function q(a){const {horiz:h,maxLabelDimensions:b,options:{grid:c={}}}=this;if(c.enabled&&b){var d=2*this.options.labels.distance;d=h?c.cellHeight||d+b.height:d+b.width;e(a.tickSize)?a.tickSize[0]=d:a.tickSize=[d,0]}}function c(){this.axes.forEach(a=>{(a.grid&&a.grid.columns||[]).forEach(a=>{a.setAxisSize();a.setAxisTranslation()})})}function H(a){const {grid:h}=this;(h.columns||[]).forEach(h=>h.destroy(a.keepEvents));h.columns=
void 0}function l(a){a=a.userOptions||{};const h=a.grid||{};h.enabled&&C(h.borderColor)&&(a.tickColor=a.lineColor=h.borderColor);this.grid||(this.grid=new P(this));this.hiddenLabels=[];this.hiddenMarks=[]}function f(a){var h=this.label;const b=this.axis;var c=b.reversed,e=b.chart,d=b.options.grid||{};const f=b.options.labels,G=f.align;var m=I[b.side],r=a.tickmarkOffset,k=b.tickPositions;const x=this.pos-r;k=n(k[a.index+1])?k[a.index+1]-r:(b.max||0)+r;var l=b.tickSize("tick");r=l?l[0]:0;l=l?l[1]/2:
0;if(!0===d.enabled){let n;"top"===m?(d=b.top+b.offset,n=d-r):"bottom"===m?(n=e.chartHeight-b.bottom+b.offset,d=n+r):(d=b.top+b.len-(b.translate(c?k:x)||0),n=b.top+b.len-(b.translate(c?x:k)||0));"right"===m?(m=e.chartWidth-b.right+b.offset,c=m+r):"left"===m?(c=b.left+b.offset,m=c-r):(m=Math.round(b.left+(b.translate(c?k:x)||0))-l,c=Math.min(Math.round(b.left+(b.translate(c?x:k)||0))-l,b.left+b.len));this.slotWidth=c-m;a.pos.x="left"===G?m:"right"===G?c:m+(c-m)/2;a.pos.y=n+(d-n)/2;h&&(e=e.renderer.fontMetrics(h),
h=h.getBBox().height,a.pos.y=f.useHTML?a.pos.y+(e.b+-(h/2)):a.pos.y+((e.b-(e.h-e.f))/2+-((Math.round(h/e.h)-1)*e.h/2)));a.pos.x+=b.horiz&&f.x||0}}function m(a){const {axis:b,value:h}=a;if(b.options.grid&&b.options.grid.enabled){var c=b.tickPositions;const e=(b.linkedParent||b).series[0],d=h===c[0];c=h===c[c.length-1];const f=e&&J(e.options.data,function(a){return a[b.isXAxis?"x":"y"]===h});let n;f&&e.is("gantt")&&(n=x(f),v.seriesTypes.gantt.prototype.pointClass.setGanttPointAliases(n));a.isFirst=
d;a.isLast=c;a.point=n}}function r(){const a=this.options,b=this.categories,c=this.tickPositions,e=c[0],d=c[c.length-1],f=this.linkedParent&&this.linkedParent.min||this.min,n=this.linkedParent&&this.linkedParent.max||this.max,m=this.tickInterval;!0!==(a.grid||{}).enabled||b||!this.horiz&&!this.isLinked||(e<f&&e+m>f&&!a.startOnTick&&(c[0]=f),d>n&&d-m<n&&!a.endOnTick&&(c[c.length-1]=n))}function D(a){const {options:{grid:b={}}}=this;return!0===b.enabled&&this.categories?this.tickInterval:a.apply(this,
Array.prototype.slice.call(arguments,1))}const {dateFormats:k}=v,{addEvent:b,defined:C,erase:d,find:J,isArray:e,isNumber:n,merge:x,pick:G,timeUnits:N,wrap:O}=t;var I;(function(a){a[a.top=0]="top";a[a.right=1]="right";a[a.bottom=2]="bottom";a[a.left=3]="left"})(I||(I={}));const L=[];class P{constructor(a){this.axis=a}isOuterAxis(){const a=this.axis,b=a.grid.columnIndex,c=a.linkedParent&&a.linkedParent.grid.columns||a.grid.columns,e=b?a.linkedParent:a;let d=-1,f=0;(a.chart[a.coll]||[]).forEach((b,c)=>
{b.side!==a.side||b.options.isInternal||(f=c,b===e&&(d=c))});return f===d&&(n(b)?c.length===b:!0)}renderBorder(a){const b=this.axis,c=b.chart.renderer,e=b.options;a=c.path(a).addClass("highcharts-axis-line").add(b.axisBorder);c.styledMode||a.attr({stroke:e.lineColor,"stroke-width":e.lineWidth,zIndex:7});return a}}k.E=function(a){return this.dateFormat("%a",a,!0).charAt(0)};k.W=function(a){const b=this,c=new this.Date(a);["Hours","Milliseconds","Minutes","Seconds"].forEach(function(a){b.set(a,c,0)});
var e=(this.get("Day",c)+6)%7;a=new this.Date(c.valueOf());this.set("Date",a,this.get("Date",c)-e+3);e=new this.Date(this.get("FullYear",a),0,1);4!==this.get("Day",e)&&(this.set("Month",c,0),this.set("Date",c,1+(11-this.get("Day",e))%7));return(1+Math.floor((a.valueOf()-e.valueOf())/6048E5)).toString()};"";return{compose:function(e,d,n){t.pushUnique(L,e)&&(e.keepProps.push("grid"),e.prototype.getMaxLabelDimensions=E,O(e.prototype,"unsquish",D),b(e,"init",l),b(e,"afterGetOffset",z),b(e,"afterGetTitlePosition",
B),b(e,"afterInit",p),b(e,"afterRender",u),b(e,"afterSetAxisTranslation",w),b(e,"afterSetOptions",a),b(e,"afterSetOptions",y),b(e,"afterSetScale",F),b(e,"afterTickSize",q),b(e,"trimTicks",r),b(e,"destroy",H));t.pushUnique(L,d)&&b(d,"afterSetChartSize",c);t.pushUnique(L,n)&&(b(n,"afterGetLabelPosition",f),b(n,"labelFormat",m));return e}}});z(g,"Gantt/Tree.js",[g["Core/Utilities.js"]],function(g){const {extend:v,isNumber:t,pick:E}=g,z=function(g,u){const p=g.reduce(function(a,g){const p=E(g.parent,
"");"undefined"===typeof a[p]&&(a[p]=[]);a[p].push(g);return a},{});Object.keys(p).forEach(function(a,g){const y=p[a];""!==a&&-1===u.indexOf(a)&&(y.forEach(function(a){g[""].push(a)}),delete g[a])});return p},B=function(g,u,w,a,y,F){let q=0,c=0,H=F&&F.after;var l=F&&F.before;u={data:a,depth:w-1,id:g,level:w,parent:u};let f,m;"function"===typeof l&&l(u,F);l=(y[g]||[]).map(function(a){const l=B(a.id,g,w+1,a,y,F),k=a.start;a=!0===a.milestone?k:a.end;f=!t(f)||k<f?k:f;m=!t(m)||a>m?a:m;q=q+1+l.descendants;
c=Math.max(l.height+1,c);return l});a&&(a.start=E(a.start,f),a.end=E(a.end,m));v(u,{children:l,descendants:q,height:c});"function"===typeof H&&H(u,F);return u};return{getListOfParents:z,getNode:B,getTree:function(g,u){const p=g.map(function(a){return a.id});g=z(g,p);return B("",null,1,null,g,u)}}});z(g,"Core/Axis/TreeGrid/TreeGridTick.js",[g["Core/Utilities.js"]],function(g){function v(){this.treeGrid||(this.treeGrid=new F(this))}function t(a,c){a=a.treeGrid;const g=!a.labelIcon,l=c.renderer;var f=
c.xy;const m=c.options,r=m.width||0,q=m.height||0;var k=f.x-r/2-(m.padding||0);f=f.y-q/2;const b=c.collapsed?90:180,p=c.show&&u(f);let d=a.labelIcon;d||(a.labelIcon=d=l.path(l.symbols[m.type](m.x||0,m.y||0,r,q)).addClass("highcharts-label-icon").add(c.group));d[p?"show":"hide"]();l.styledMode||d.attr({cursor:"pointer",fill:w(c.color,"#666666"),"stroke-width":1,stroke:m.lineColor,strokeWidth:m.lineWidth||0});d[g?"attr":"animate"]({translateX:k,translateY:f,rotation:b})}function E(a,c,g,l,f,m,r,y,k){var b=
w(this.options&&this.options.labels,m);m=this.pos;var q=this.axis;const d="treegrid"===q.options.type;a=a.apply(this,[c,g,l,f,b,r,y,k]);d&&(c=b&&p(b.symbol,!0)?b.symbol:{},b=b&&u(b.indentation)?b.indentation:0,m=(m=(q=q.treeGrid.mapOfPosToGridNode)&&q[m])&&m.depth||1,a.x+=(c.width||0)+2*(c.padding||0)+(m-1)*b);return a}function z(a){const c=this;var g=c.pos,l=c.axis;const f=c.label;var m=l.treeGrid.mapOfPosToGridNode,r=l.options;const q=w(c.options&&c.options.labels,r&&r.labels);var k=q&&p(q.symbol,
!0)?q.symbol:{};const b=(m=m&&m[g])&&m.depth;r="treegrid"===r.type;const y=-1<l.tickPositions.indexOf(g);g=l.chart.styledMode;r&&m&&f&&f.element&&f.addClass("highcharts-treegrid-node-level-"+b);a.apply(c,Array.prototype.slice.call(arguments,1));r&&f&&f.element&&m&&m.descendants&&0<m.descendants&&(l=l.treeGrid.isCollapsed(m),t(c,{color:!g&&f.styles&&f.styles.color||"",collapsed:l,group:f.parentGroup,options:k,renderer:f.renderer,show:y,xy:f.xy}),k="highcharts-treegrid-node-"+(l?"expanded":"collapsed"),
f.addClass("highcharts-treegrid-node-"+(l?"collapsed":"expanded")).removeClass(k),g||f.css({cursor:"pointer"}),[f,c.treeGrid.labelIcon].forEach(a=>{a&&!a.attachedTreeGridEvents&&(B(a.element,"mouseover",function(){f.addClass("highcharts-treegrid-node-active");f.renderer.styledMode||f.css({textDecoration:"underline"})}),B(a.element,"mouseout",function(){{const a=p(q.style)?q.style:{};f.removeClass("highcharts-treegrid-node-active");f.renderer.styledMode||f.css({textDecoration:a.textDecoration})}}),
B(a.element,"click",function(){c.treeGrid.toggleCollapse()}),a.attachedTreeGridEvents=!0)}))}const {addEvent:B,isObject:p,isNumber:u,pick:w,wrap:a}=g,y=[];class F{static compose(q){g.pushUnique(y,q)&&(B(q,"init",v),a(q.prototype,"getLabelPosition",E),a(q.prototype,"renderLabel",z),q.prototype.collapse=function(a){this.treeGrid.collapse(a)},q.prototype.expand=function(a){this.treeGrid.expand(a)},q.prototype.toggleCollapse=function(a){this.treeGrid.toggleCollapse(a)})}constructor(a){this.tick=a}collapse(a){var c=
this.tick;const g=c.axis,l=g.brokenAxis;l&&g.treeGrid.mapOfPosToGridNode&&(c=g.treeGrid.collapse(g.treeGrid.mapOfPosToGridNode[c.pos]),l.setBreaks(c,w(a,!0)))}destroy(){this.labelIcon&&this.labelIcon.destroy()}expand(a){var c=this.tick;const g=c.axis,l=g.brokenAxis;l&&g.treeGrid.mapOfPosToGridNode&&(c=g.treeGrid.expand(g.treeGrid.mapOfPosToGridNode[c.pos]),l.setBreaks(c,w(a,!0)))}toggleCollapse(a){var c=this.tick;const g=c.axis,l=g.brokenAxis;l&&g.treeGrid.mapOfPosToGridNode&&(c=g.treeGrid.toggleCollapse(g.treeGrid.mapOfPosToGridNode[c.pos]),
l.setBreaks(c,w(a,!0)))}}return F});z(g,"Series/TreeUtilities.js",[g["Core/Color/Color.js"],g["Core/Utilities.js"]],function(g,v){function t(a,g){var p=g.before;const q=g.idRoot,c=g.mapIdToNode[q],y=g.points[a.i],l=y&&y.options||{},f=[];let m=0;a.levelDynamic=a.level-(!1!==g.levelIsConstant?0:c.level);a.name=w(y&&y.name,"");a.visible=q===a.id||!0===g.visible;"function"===typeof p&&(a=p(a,g));a.children.forEach((c,l)=>{const k=z({},g);z(k,{index:l,siblings:a.children.length,visible:a.visible});c=t(c,
k);f.push(c);c.visible&&(m+=c.val)});p=w(l.value,m);a.visible=0<=p&&(0<m||a.visible);a.children=f;a.childrenTotal=m;a.isLeaf=a.visible&&!m;a.val=p;return a}const {extend:z,isArray:E,isNumber:B,isObject:p,merge:u,pick:w}=v;return{getColor:function(a,p){const y=p.index;var q=p.mapOptionsToLevel;const c=p.parentColor,u=p.parentColorIndex,l=p.series;var f=p.colors;const m=p.siblings;var r=l.points,t=l.chart.options.chart;let k;var b;let v;if(a){r=r[a.i];a=q[a.level]||{};if(q=r&&a.colorByPoint){k=r.index%
(f?f.length:t.colorCount);var d=f&&f[k]}if(!l.chart.styledMode){f=r&&r.options.color;t=a&&a.color;if(b=c)b=(b=a&&a.colorVariation)&&"brightness"===b.key&&y&&m?g.parse(c).brighten(y/m*b.to).get():c;b=w(f,t,d,b,l.color)}v=w(r&&r.options.colorIndex,a&&a.colorIndex,k,u,p.colorIndex)}return{color:b,colorIndex:v}},getLevelOptions:function(a){let g={},t,q,c;if(p(a)){c=B(a.from)?a.from:1;var v=a.levels;q={};t=p(a.defaults)?a.defaults:{};E(v)&&(q=v.reduce((a,f)=>{let g,l;p(f)&&B(f.level)&&(l=u({},f),g=w(l.levelIsConstant,
t.levelIsConstant),delete l.levelIsConstant,delete l.level,f=f.level+(g?0:c-1),p(a[f])?u(!0,a[f],l):a[f]=l);return a},{}));v=B(a.to)?a.to:1;for(a=0;a<=v;a++)g[a]=u({},t,p(q[a])?q[a]:{})}return g},setTreeValues:t,updateRootId:function(a){if(p(a)){var g=p(a.options)?a.options:{};g=w(a.rootNode,g.rootId,"");p(a.userOptions)&&(a.userOptions.rootId=g);a.rootNode=g}return g}}});z(g,"Core/Axis/TreeGrid/TreeGridAxis.js",[g["Core/Axis/BrokenAxis.js"],g["Core/Axis/GridAxis.js"],g["Gantt/Tree.js"],g["Core/Axis/TreeGrid/TreeGridTick.js"],
g["Series/TreeUtilities.js"],g["Core/Utilities.js"]],function(g,v,t,z,M,B){function p(a,b){const c=a.collapseEnd||0;a=a.collapseStart||0;c>=b&&(a-=.5);return{from:a,to:c,showPoints:!1}}function u(a,b,c){const e=[],d=[],f={},g="boolean"===typeof b?b:!1;let n={},l=-1;a=t.getTree(a,{after:function(a){a=n[a.pos];let b=0,c=0;a.children.forEach(function(a){c+=(a.descendants||0)+1;b=Math.max((a.height||0)+1,b)});a.descendants=c;a.height=b;a.collapsed&&d.push(a)},before:function(a){const b=m(a.data,!0)?a.data:
{},c=r(b.name)?b.name:"";var d=f[a.parent];d=m(d,!0)?n[d.pos]:null;var h=function(a){return a.name===c};let k;g&&m(d,!0)&&(k=H(d.children,h))?(h=k.pos,k.nodes.push(a)):h=l++;n[h]||(n[h]=k={depth:d?d.depth+1:0,name:c,id:b.id,nodes:[a],children:[],pos:h},-1!==h&&e.push(c),m(d,!0)&&d.children.push(k));r(a.id)&&(f[a.id]=a);k&&!0===b.collapsed&&(k.collapsed=!0);a.pos=h}});n=function(a,b){const c=function(a,e,d){let f=e+(-1===e?0:b-1);const g=(f-e)/2,h=e+g;a.nodes.forEach(function(a){const b=a.data;m(b,
!0)&&(b.y=e+(b.seriesIndex||0),delete b.seriesIndex);a.pos=h});d[h]=a;a.pos=h;a.tickmarkOffset=g+.5;a.collapseStart=f+.5;a.children.forEach(function(a){c(a,f+1,d);f=(a.collapseEnd||0)-.5});a.collapseEnd=f+.5;return d};return c(a["-1"],-1,{})}(n,c);return{categories:e,mapOfIdToNode:f,mapOfPosToGridNode:n,collapsedNodes:d,tree:a}}function w(a){a.target.axes.filter(function(a){return"treegrid"===a.options.type}).forEach(function(b){var c=b.options||{};const e=c.labels,d=c.uniqueNames;c=c.max;let g=0,
n;if(!b.treeGrid.mapOfPosToGridNode||b.series.some(function(a){return!a.hasRendered||a.isDirtyData||a.isDirty})){n=b.series.reduce(function(a,b){b.visible&&((b.options.data||[]).forEach(function(c){b.options.keys&&b.options.keys.length&&(c=b.pointClass.prototype.optionsToObject.call({series:b},c),b.pointClass.setGanttPointAliases(c));m(c,!0)&&(c.seriesIndex=g,a.push(c))}),!0===d&&g++);return a},[]);if(c&&n.length<c)for(let a=n.length;a<=c;a++)n.push({name:a+"\u200b"});c=u(n,d||!1,!0===d?g:1);b.categories=
c.categories;b.treeGrid.mapOfPosToGridNode=c.mapOfPosToGridNode;b.hasNames=!0;b.treeGrid.tree=c.tree;b.series.forEach(function(a){const b=(a.options.data||[]).map(function(b){f(b)&&a.options.keys&&a.options.keys.length&&n.forEach(function(a){0<=b.indexOf(a.x)&&0<=b.indexOf(a.x2)&&(b=a)});return m(b,!0)?D(b):b});a.visible&&a.setData(b,!1)});b.treeGrid.mapOptionsToLevel=q({defaults:e,from:1,levels:e&&e.levels,to:b.treeGrid.tree&&b.treeGrid.tree.height});"beforeRender"===a.type&&(b.treeGrid.collapsedNodes=
c.collapsedNodes)}})}function a(a,b){var c=this.treeGrid.mapOptionsToLevel||{};const e=this.ticks;let f=e[b],g,n;"treegrid"===this.options.type&&this.treeGrid.mapOfPosToGridNode?(n=this.treeGrid.mapOfPosToGridNode[b],(c=c[n.depth])&&(g={labels:c}),!f&&d?e[b]=new d(this,b,void 0,void 0,{category:n.name,tickmarkOffset:n.tickmarkOffset,options:g}):(f.parameters.category=n.name,f.options=g,f.addLabel())):a.apply(this,Array.prototype.slice.call(arguments,1))}function y(a,b,d){const e=this,f="treegrid"===
d.type;e.treeGrid||(e.treeGrid=new J(e));f&&(c(b,"beforeRender",w),c(b,"beforeRedraw",w),c(b,"addSeries",function(a){a.options.data&&(a=u(a.options.data,d.uniqueNames||!1,1),e.treeGrid.collapsedNodes=(e.treeGrid.collapsedNodes||[]).concat(a.collapsedNodes))}),c(e,"foundExtremes",function(){e.treeGrid.collapsedNodes&&e.treeGrid.collapsedNodes.forEach(function(a){const b=e.treeGrid.collapse(a);e.brokenAxis&&(e.brokenAxis.setBreaks(b,!1),e.treeGrid.collapsedNodes&&(e.treeGrid.collapsedNodes=e.treeGrid.collapsedNodes.filter(b=>
a.collapseStart!==b.collapseStart||a.collapseEnd!==b.collapseEnd)))})}),c(e,"afterBreaks",function(){"yAxis"===e.coll&&!e.staticScale&&e.chart.options.chart.height&&(e.isDirty=!0)}),d=D({grid:{enabled:!0},labels:{align:"left",levels:[{level:void 0},{level:1,style:{fontWeight:"bold"}}],symbol:{type:"triangle",x:-5,y:-5,height:10,width:10,padding:5}},uniqueNames:!1},d,{reversed:!0,grid:{columns:void 0}}));a.apply(e,[b,d]);f&&(e.hasNames=!0,e.options.showLastLabel=!0)}function E(a){const b=this.options;
"treegrid"===b.type?(this.min=k(this.userMin,b.min,this.dataMin),this.max=k(this.userMax,b.max,this.dataMax),l(this,"foundExtremes"),this.setAxisTranslation(),this.tickmarkOffset=.5,this.tickInterval=1,this.tickPositions=this.treeGrid.mapOfPosToGridNode?this.treeGrid.getTickPositions():[]):a.apply(this,Array.prototype.slice.call(arguments,1))}const {getLevelOptions:q}=M,{addEvent:c,find:H,fireEvent:l,isArray:f,isObject:m,isString:r,merge:D,pick:k,wrap:b}=B,C=[];let d;class J{static compose(c,f,l,
k){if(B.pushUnique(C,c)){-1===c.keepProps.indexOf("treeGrid")&&c.keepProps.push("treeGrid");const e=c.prototype;b(e,"generateTick",a);b(e,"init",y);b(e,"setTickInterval",E);e.utils={getNode:t.getNode}}B.pushUnique(C,k)&&(d||(d=k));v.compose(c,f,k);g.compose(c,l);z.compose(k);return c}constructor(a){this.axis=a}setCollapsedStatus(a){const b=this.axis,c=b.chart;b.series.forEach(function(b){const e=b.options.data;if(a.id&&e){const d=c.get(a.id);b=e[b.data.indexOf(d)];d&&b&&(d.collapsed=a.collapsed,b.collapsed=
a.collapsed)}})}collapse(a){const b=this.axis,c=b.options.breaks||[],e=p(a,b.max);c.push(e);a.collapsed=!0;b.treeGrid.setCollapsedStatus(a);return c}expand(a){const b=this.axis,c=b.options.breaks||[],e=p(a,b.max);a.collapsed=!1;b.treeGrid.setCollapsedStatus(a);return c.reduce(function(a,b){b.to===e.to&&b.from===e.from||a.push(b);return a},[])}getTickPositions(){const a=this.axis,b=Math.floor(a.min/a.tickInterval)*a.tickInterval,c=Math.ceil(a.max/a.tickInterval)*a.tickInterval;return Object.keys(a.treeGrid.mapOfPosToGridNode||
{}).reduce(function(e,d){d=+d;!(d>=b&&d<=c)||a.brokenAxis&&a.brokenAxis.isInAnyBreak(d)||e.push(d);return e},[])}isCollapsed(a){const b=this.axis,c=b.options.breaks||[],e=p(a,b.max);return c.some(function(a){return a.from===e.from&&a.to===e.to})}toggleCollapse(a){return this.isCollapsed(a)?this.expand(a):this.collapse(a)}}return J});z(g,"masters/modules/treegrid.src.js",[g["Core/Globals.js"],g["Core/Axis/TreeGrid/TreeGridAxis.js"]],function(g,v){v.compose(g.Axis,g.Chart,g.Series,g.Tick)})});
//# sourceMappingURL=treegrid.js.map