/*
 Highcharts JS v11.0.0 (2023-04-26)
 Treegraph chart series type

  (c) 2010-2022 Pawel Lysy Grzegorz Blachlinski

 License: www.highcharts.com/license
*/
'use strict';(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/treegraph",["highcharts","highcharts/modules/treemap"],function(h){b(h);b.Highcharts=h;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function h(b,f,a,c){b.hasOwnProperty(f)||(b[f]=c.apply(null,a),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:f,
module:b[f]}})))}b=b?b._modules:{};h(b,"Series/PathUtilities.js",[],function(){function b(b,a){const c=[];for(let g=0;g<b.length;g++){const k=b[g][1],l=b[g][2];if("number"===typeof k&&"number"===typeof l)if(0===g)c.push(["M",k,l]);else if(g===b.length-1)c.push(["L",k,l]);else if(a){var e=b[g-1],d=b[g+1];if(e&&d){const b=e[1];e=e[2];const g=d[1];d=d[2];if("number"===typeof b&&"number"===typeof g&&"number"===typeof e&&"number"===typeof d&&b!==g&&e!==d){const f=b<g?1:-1,t=e<d?1:-1;c.push(["L",k-f*Math.min(Math.abs(k-
b),a),l-t*Math.min(Math.abs(l-e),a)],["C",k,l,k,l,k+f*Math.min(Math.abs(k-g),a),l+t*Math.min(Math.abs(l-d),a)])}}}else c.push(["L",k,l])}return c}return{applyRadius:b,getLinkPath:{"default":function(f){const {x1:a,y1:c,x2:e,y2:d,width:g=0,inverted:k=!1,radius:l,parentVisible:t}=f;f=[["M",a,c],["L",a,c],["C",a,c,a,d,a,d],["L",a,d],["C",a,c,a,d,a,d],["L",a,d]];return t?b([["M",a,c],["L",a+g*(k?-.5:.5),c],["L",a+g*(k?-.5:.5),d],["L",e,d]],l):f},straight:function(b){const {x1:a,y1:c,x2:e,y2:d,width:g=
0,inverted:k=!1,parentVisible:l}=b;return l?[["M",a,c],["L",a+g*(k?-1:1),d],["L",e,d]]:[["M",a,c],["L",a,d],["L",a,d]]},curved:function(b){const {x1:a,y1:c,x2:e,y2:d,offset:g=0,width:k=0,inverted:l=!1,parentVisible:f}=b;return f?[["M",a,c],["C",a+g,c,a-g+k*(l?-1:1),d,a+k*(l?-1:1),d],["L",e,d]]:[["M",a,c],["C",a,c,a,d,a,d],["L",e,d]]}}}});h(b,"Series/Treegraph/TreegraphNode.js",[b["Core/Series/SeriesRegistry.js"]],function(b){({seriesTypes:{treemap:{prototype:{NodeClass:b}}}}=b);class f extends b{constructor(){super(...arguments);
this.change=this.shift=this.mod=0;this.children=[];this.preX=0;this.collapsed=this.wasVisited=this.hidden=!1}nextLeft(){return this.getLeftMostChild()||this.thread}nextRight(){return this.getRightMostChild()||this.thread}getAncestor(a,c){return a.ancestor.children[0]===this.children[0]?a.ancestor:c}getLeftMostSibling(){const a=this.getParent();if(a)for(const c of a.children)if(c&&c.point.visible)return c}hasChildren(){const a=this.children;for(let c=0;c<a.length;c++)if(a[c].point.visible)return!0;
return!1}getLeftSibling(){var a=this.getParent();if(a){a=a.children;for(let c=this.relativeXPosition-1;0<=c;c--)if(a[c]&&a[c].point.visible)return a[c]}}getLeftMostChild(){const a=this.children;for(let c=0;c<a.length;c++)if(a[c].point.visible)return a[c]}getRightMostChild(){const a=this.children;for(let c=a.length-1;0<=c;c--)if(a[c].point.visible)return a[c]}getParent(){return this.parentNode}getFirstChild(){const a=this.children;for(let c=0;c<a.length;c++)if(a[c].point.visible)return a[c]}}return f});
h(b,"Series/Treegraph/TreegraphPoint.js",[b["Core/Series/Point.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,f,a){({seriesTypes:{treemap:{prototype:{pointClass:f}}}}=f);const {addEvent:c,fireEvent:e,merge:d,pick:g}=a;class k extends f{constructor(){super(...arguments);this.options=void 0;this.isLink=!1;this.node=this.series=void 0;this.setState=b.prototype.setState}draw(){super.draw.apply(this,arguments);let a=this.graphic;a&&a.animate({visibility:this.visible?"inherit":
"hidden"});this.renderCollapseButton()}renderCollapseButton(){var a=this.series;const c=this.graphic&&this.graphic.parentGroup;a=d(a.options.collapseButton,(a.mapOptionsToLevel[this.node.level||0]||{}).collapseButton,this.options.collapseButton);const {width:b,height:e,shape:g,style:k}=a,f=this.series.chart;if(this.shapeArgs)if(this.collapseButtonOptions=a,this.collapseButton)if(this.node.children.length&&a.enabled){const {x:c,y:d}=this.getCollapseBtnPosition(a);this.collapseButton.attr({text:this.collapsed?
"+":"-",rotation:f.inverted?90:0,rotationOriginX:b/2,rotationOriginY:e/2}).animate({x:c,y:d,opacity:!this.visible||a.onlyOnHover&&"hover"!==this.state&&!this.collapsed?0:1})}else this.collapseButton.destroy(),delete this.collapseButton;else if(this.node.children.length&&a.enabled){var {x:h,y:z}=this.getCollapseBtnPosition(a),u=a.fillColor||this.color||"#cccccc";this.collapseButton=f.renderer.label(this.collapsed?"+":"-",h,z,g).attr({height:e-4,width:b-4,padding:2,fill:u,rotation:f.inverted?90:0,rotationOriginX:b/
2,rotationOriginY:e/2,stroke:a.lineColor||"#ffffff","stroke-width":a.lineWidth,"text-align":"center",align:"center",zIndex:1}).addClass("highcharts-tracker").addClass("highcharts-collapse-button").removeClass("highcharts-no-tooltip").css(d({color:"string"===typeof u?f.renderer.getContrast(u):"#333333"},k)).add(c);this.collapseButton.element.point=this;a.onlyOnHover&&!this.collapsed&&this.collapseButton.attr({opacity:0})}}toggleCollapse(a){this.collapsed=g(a,!this.collapsed);e(this.series,"toggleCollapse");
this.series.redraw()}destroy(){this.collapseButton&&(this.collapseButton.destroy(),delete this.collapseButton,this.collapseButton=void 0);super.destroy.apply(this,arguments)}getCollapseBtnPosition(a){const c=this.series.chart.inverted,d=a.width,b=a.height,{x:e=0,y:g=0,width:k=0,height:f=0}=this.shapeArgs||{};return{x:e+a.x+(c?.3*-b:k+-.3*d),y:g+f/2-b/2+a.y}}}c(k,"mouseOut",function(){const a=this.collapseButton,c=this.collapseButtonOptions;a&&c&&c.onlyOnHover&&!this.collapsed&&a.animate({opacity:0})});
c(k,"mouseOver",function(){this.collapseButton&&this.collapseButton.animate({opacity:1},this.series.options.states&&this.series.options.states.hover&&this.series.options.states.hover.animation)});c(k,"click",function(){this.toggleCollapse()});return k});h(b,"Series/Treegraph/TreegraphLink.js",[b["Core/Series/Point.js"],b["Core/Utilities.js"],b["Core/Series/SeriesRegistry.js"]],function(b,f,a){const {pick:c,extend:e}=f;({seriesTypes:{column:{prototype:{pointClass:f}}}}=a);class d extends f{constructor(){super(...arguments);
this.isLink=!0;this.node={};this.formatPrefix="link";this.dataLabelOnNull=!0}init(a,c,d,b){const e=super.init.apply(this,arguments);this.formatPrefix="link";this.dataLabelOnNull=!0;b&&(e.fromNode=b.node.parentNode.point,e.visible=b.visible,e.toNode=b,this.id=e.toNode.id+"-"+e.fromNode.id);return e}update(a,d,f,h){const g={id:this.id,formatPrefix:this.formatPrefix};b.prototype.update.call(this,a,this.isLink?!1:d,f,h);this.visible=this.toNode.visible;e(this,g);c(d,!0)&&this.series.chart.redraw(f)}}
return d});h(b,"Series/Treegraph/TreegraphLayout.js",[b["Series/Treegraph/TreegraphNode.js"]],function(b){class f{static createDummyNode(a,c,e,d){d=new b;d.id=a.id+"-"+e;d.ancestor=a;d.children.push(c);d.parent=a.id;d.parentNode=a;d.point=c.point;d.level=c.level-e;d.relativeXPosition=c.relativeXPosition;d.visible=c.visible;a.children[c.relativeXPosition]=d;c.oldParentNode=a;c.relativeXPosition=0;c.parentNode=d;c.parent=d.id;return d}calculatePositions(a){const c=a.nodeList;this.resetValues(c);if(a=
a.tree)this.calculateRelativeX(a,0),this.beforeLayout(c),this.firstWalk(a),this.secondWalk(a,-a.preX),this.afterLayout(c)}beforeLayout(a){for(const c of a){a=0;for(let b of c.children){if(b&&1<b.level-c.level){let d=b.level-c.level-1;for(;0<d;)b=f.createDummyNode(c,b,d,a),d--}++a}}}resetValues(a){for(const c of a)c.mod=0,c.ancestor=c,c.shift=0,c.thread=void 0,c.change=0,c.preX=0}calculateRelativeX(a,c){const b=a.children;for(let a=0,c=b.length;a<c;++a)this.calculateRelativeX(b[a],a);a.relativeXPosition=
c}firstWalk(a){if(a.hasChildren()){var c=a.getLeftMostChild();for(var b of a.children)this.firstWalk(b),c=this.apportion(b,c);this.executeShifts(a);c=a.getLeftMostChild();b=a.getRightMostChild();b=(c.preX+b.preX)/2;(c=a.getLeftSibling())?(a.preX=c.preX+1,a.mod=a.preX-b):a.preX=b}else(c=a.getLeftSibling())?(a.preX=c.preX+1,a.mod=a.preX):a.preX=0}secondWalk(a,c){a.yPosition=a.preX+c;a.xPosition=a.level;for(const b of a.children)this.secondWalk(b,c+a.mod)}executeShifts(a){let c=0,b=0;for(let d=a.children.length-
1;0<=d;d--){const e=a.children[d];e.preX+=c;e.mod+=c;b+=e.change;c+=e.shift+b}}apportion(a,c){var b=a.getLeftSibling();if(b){let d=a,e=a,f=d.getLeftMostSibling(),l=d.mod,h=e.mod,v=b.mod,q=f.mod;for(;b&&b.nextRight()&&d&&d.nextLeft();){b=b.nextRight();f=f.nextLeft();d=d.nextLeft();e=e.nextRight();e.ancestor=a;const g=b.preX+v-(d.preX+l)+1;0<g&&(this.moveSubtree(a.getAncestor(b,c),a,g),l+=g,h+=g);v+=b.mod;l+=d.mod;q+=f.mod;h+=e.mod}b&&b.nextRight()&&!e.nextRight()&&(e.thread=b.nextRight(),e.mod+=v-
h);d&&d.nextLeft()&&!f.nextLeft()&&(f.thread=d.nextLeft(),f.mod+=l-q);c=a}return c}moveSubtree(a,c,b){const d=c.relativeXPosition-a.relativeXPosition;c.change-=b/d;c.shift+=b;c.preX+=b;c.mod+=b;a.change+=b/d}afterLayout(a){for(const c of a)c.oldParentNode&&(c.relativeXPosition=c.parentNode.relativeXPosition,c.parent=c.oldParentNode.parent,c.parentNode=c.oldParentNode,delete c.oldParentNode.children[c.relativeXPosition],c.oldParentNode.children[c.relativeXPosition]=c,c.oldParentNode=void 0)}}return f});
h(b,"Series/Treegraph/TreegraphSeriesDefaults.js",[],function(){return{reversed:!1,marker:{radius:10,lineWidth:0,symbol:"circle",fillOpacity:1,states:{}},link:{color:"#666666",lineWidth:1,radius:10,cursor:"default",type:"curved"},collapseButton:{onlyOnHover:!0,enabled:!0,lineWidth:1,x:0,y:0,height:18,width:18,shape:"circle",style:{cursor:"pointer",fontWeight:"bold",fontSize:"1em"}},tooltip:{linkFormat:"{point.fromNode.id} \u2192 {point.toNode.id}",pointFormat:"{point.id}"},dataLabels:{defer:!0,linkTextPath:{attributes:{startOffset:"50%"}},
enabled:!0,linkFormatter:()=>"",style:{textOverflow:"none"}}}});h(b,"Series/Treegraph/TreegraphSeries.js",[b["Series/PathUtilities.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Renderer/SVG/SVGRenderer.js"],b["Series/Treegraph/TreegraphNode.js"],b["Series/Treegraph/TreegraphPoint.js"],b["Series/TreeUtilities.js"],b["Core/Utilities.js"],b["Series/Treegraph/TreegraphLink.js"],b["Series/Treegraph/TreegraphLayout.js"],b["Series/Treegraph/TreegraphSeriesDefaults.js"]],function(b,f,a,c,e,d,g,k,l,h){const {getLinkPath:v}=
b,{series:{prototype:q},seriesTypes:{treemap:t,column:A}}=f,{prototype:{symbols:E}}=a,{getLevelOptions:z}=d,{extend:F,merge:u,pick:w,relativeLength:B,splat:G}=g;class y extends t{constructor(){super(...arguments);this.tree=this.nodeMap=this.layoutModifier=this.points=this.options=this.data=void 0;this.nodeList=[];this.layoutAlgorythm=void 0;this.links=[];this.mapOptionsToLevel=void 0}init(){super.init.apply(this,arguments);this.layoutAlgorythm=new l}getLayoutModifiers(){var a=this.chart;const c=this,
b=a.plotSizeX,d=a.plotSizeY;let e=Infinity,f=-Infinity,g=Infinity,k=-Infinity,l=0,h=0,D=0,r=0;this.points.forEach(a=>{const p=a.node;a=u(this.options.marker,(c.mapOptionsToLevel[a.node.level]||{}).marker,a.options.marker);var m=B(a.radius||0,Math.min(b,d)),n=a.symbol;const C="circle"!==n&&a.height?B(a.height,d):2*m;m="circle"!==n&&a.width?B(a.width,b):2*m;p.nodeSizeX=m;p.nodeSizeY=C;p.xPosition<=e&&(e=p.xPosition,n=a.lineWidth||0,h=Math.max(m+n,h));p.xPosition>=f&&(f=p.xPosition,n=a.lineWidth||0,
l=Math.max(m+n,l));p.yPosition<=g&&(g=p.yPosition,n=a.lineWidth||0,r=Math.max(C+n,r));p.yPosition>=k&&(k=p.yPosition,n=a.lineWidth||0,D=Math.max(C+n,D))});a=k===g?1:(d-(r+D)/2)/(k-g);const H=f===e?1:(b-(l+l)/2)/(f-e);return{ax:H,bx:f===e?b/2:-H*e+h/2,ay:a,by:k===g?d/2:-a*g+r/2}}getLinks(){const a=this,c=[];this.data.forEach((b,d)=>{d=a.mapOptionsToLevel[b.node.level||0]||{};b.node.parent?(d=u(d,b.options),!b.linkToParent||b.linkToParent.destroyed?(d=(new a.LinkClass).init(a,d,void 0,b),b.linkToParent=
d):b.linkToParent.update({collapsed:d.collapsed},!1),b.linkToParent.index=c.push(b.linkToParent)-1):b.linkToParent&&(a.links.splice(b.linkToParent.index),b.linkToParent.destroy(),delete b.linkToParent)});return c}buildTree(a,c,b,d,e){const m=this.points[c];b=m&&m.level||b;return super.buildTree.call(this,a,c,b,d,e)}markerAttribs(){return{}}setCollapsedStatus(a,c){const b=a.point;b&&(b.collapsed=w(b.collapsed,(this.mapOptionsToLevel[a.level]||{}).collapsed),b.visible=c,c=!1===c?!1:!b.collapsed);a.children.forEach(a=>
{this.setCollapsedStatus(a,c)})}drawTracker(){A.prototype.drawTracker.apply(this,arguments);A.prototype.drawTracker.call(this,this.links)}translate(){const a=this.options;let c=d.updateRootId(this),b;q.translate.call(this);const e=this.tree=this.getTree();b=this.nodeMap[c];""===c||b&&b.children.length||(this.setRootNode("",!1),c=this.rootNode,b=this.nodeMap[c]);this.mapOptionsToLevel=z({from:b.level+1,levels:a.levels,to:e.height,defaults:{levelIsConstant:this.options.levelIsConstant,colorByPoint:a.colorByPoint}});
this.setCollapsedStatus(e,!0);this.links=this.getLinks();this.setTreeValues(e);this.layoutAlgorythm.calculatePositions(this);this.layoutModifier=this.getLayoutModifiers();this.points.forEach(a=>{this.translateNode(a)});this.points.forEach(a=>{a.linkToParent&&this.translateLink(a.linkToParent)});a.colorByPoint||this.setColorRecursive(this.tree)}translateLink(a){var c=a.fromNode;const b=a.toNode,d=this.options.link.lineWidth,e=Math.round(d)%2/2;var f=w(this.options.link.curveFactor,.5);const m=w(a.options.link&&
a.options.link.type,this.options.link.type);if(c.shapeArgs&&b.shapeArgs){var g=c.shapeArgs.width||0;const p=this.chart.inverted,k=Math.floor((c.shapeArgs.y||0)+(c.shapeArgs.height||0)/2)+e,l=Math.floor((b.shapeArgs.y||0)+(b.shapeArgs.height||0)/2)+e;let n=Math.floor((c.shapeArgs.x||0)+g)+e,h=Math.floor(b.shapeArgs.x||0)+e;p&&(n-=g,h+=b.shapeArgs.width||0);c=b.node.xPosition-c.node.xPosition;a.shapeType="path";g=(Math.abs(h-n)+g)/c-g;f=g*f*(p?-1:1);a.plotX=Math.floor((h+n)/2)+e;a.plotY=l;a.shapeArgs=
{d:v[m]({x1:n,y1:k,x2:h,y2:l,width:g,offset:f,inverted:p,parentVisible:b.visible,radius:this.options.link.radius})};a.dlBox={x:(n+h)/2,y:(k+l)/2,height:d,width:0};a.tooltipPos=p?[(this.chart.plotSizeY||0)-a.dlBox.y,(this.chart.plotSizeX||0)-a.dlBox.x]:[a.dlBox.x,a.dlBox.y]}}drawNodeLabels(a){const c=this.mapOptionsToLevel;let b,d;for(const e of a)d=c[e.node.level],b={style:{}},d&&d.dataLabels&&(b=u(b,d.dataLabels),this._hasPointLabels=!0),e.shapeArgs&&!G(this.options.dataLabels)[0].style.width&&(b.style.width=
e.shapeArgs.width,e.dataLabel&&e.dataLabel.css({width:e.shapeArgs.width+"px"})),e.dlOptions=u(b,e.options.dataLabels);q.drawDataLabels.call(this,a)}alignDataLabel(a,c){const b=a.visible;a.visible=!0;super.alignDataLabel.apply(this,arguments);c.animate({opacity:!1===b?0:1});a.visible=b}drawDataLabels(){this.options.dataLabels&&(this.options.dataLabels=G(this.options.dataLabels),this.drawNodeLabels(this.points),q.drawDataLabels.call(this,this.links))}destroy(){if(this.links){for(const a of this.links)a.destroy();
this.links.length=0}return q.destroy.apply(this,arguments)}pointAttribs(a,b){var c=this.mapOptionsToLevel[a.node.level||0]||{};const d=a.options,e=c.states&&c.states[b]||{};a.options.marker=u(this.options.marker,c.marker,a.options.marker);const f=w(e.link&&e.link.color,d.link&&d.link.color,c.link&&c.link.color,this.options.link&&this.options.link.color);c=w(e.link&&e.link.lineWidth,d.link&&d.link.lineWidth,c.link&&c.link.lineWidth,this.options.link&&this.options.link.lineWidth);b=q.pointAttribs.call(this,
a,b);a.isLink&&(b.stroke=f,b["stroke-width"]=c,delete b.fill);a.visible||(b.opacity=0);return b}drawPoints(){t.prototype.drawPoints.apply(this,arguments);A.prototype.drawPoints.call(this,this.links)}translateNode(a){const c=this.chart;var b=a.node;const d=c.plotSizeY,e=c.plotSizeX,{ax:f,bx:g,ay:k,by:l}=this.layoutModifier;var h=f*b.xPosition+g,m=k*b.yPosition+l,r=this.mapOptionsToLevel[b.level]||{};const t=u(this.options.marker,r.marker,a.options.marker).symbol,q=b.nodeSizeY,x=b.nodeSizeX,v=this.options.reversed;
h=b.x=c.inverted?e-x/2-h:h-x/2;b=b.y=v?m-q/2:d-m-q/2;r=w(a.options.borderRadius,r.borderRadius,this.options.borderRadius);a.shapeType="path";if(!a.visible&&a.linkToParent){if(m=a.linkToParent.fromNode){const {x:b=0,y:c=0,width:d=0,height:e=0}=m.shapeArgs||{};a.shapeArgs||(a.shapeArgs={});F(a.shapeArgs,{d:E[t||"circle"](b,c,d,e,r?{r}:void 0),x:b,y:c});a.plotX=m.plotX;a.plotY=m.plotY}}else a.plotX=h,a.plotY=b,a.shapeArgs={d:E[t||"circle"](h,b,x,q,r?{r}:void 0),x:h,y:b,width:x,height:q,cursor:a.node.isLeaf?
"default":"pointer"};a.tooltipPos=c.inverted?[d-b-q/2,e-h-x/2]:[h+x/2,b]}}y.defaultOptions=u(t.defaultOptions,h);F(y.prototype,{pointClass:e,NodeClass:c,LinkClass:k});f.registerSeriesType("treegraph",y);"";return y});h(b,"masters/modules/treegraph.src.js",[],function(){})});
//# sourceMappingURL=treegraph.js.map