/*
 Highcharts JS v11.0.0 (2023-04-26)

 Timeline series

 (c) 2010-2021 Highsoft AS
 Author: Daniel Studencki

 License: www.highcharts.com/license
*/
'use strict';(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/timeline",["highcharts"],function(c){b(c);b.Highcharts=c;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function c(b,g,c,t){b.hasOwnProperty(g)||(b[g]=t.apply(null,c),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:g,module:b[g]}})))}b=b?b._modules:
{};c(b,"Series/Timeline/TimelinePoint.js",[b["Core/Series/Point.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,c,r){const {series:g,seriesTypes:{pie:{prototype:{pointClass:q}}}}=c,{defined:u,isNumber:y,merge:m,objectEach:l,pick:p}=r;class v extends g.prototype.pointClass{constructor(){super(...arguments);this.series=this.options=void 0}alignConnector(){let b=this.series,h=this.connector,f=this.dataLabel,c=this.dataLabel.options=m(b.options.dataLabels,this.options.dataLabels);
var e=this.series.chart,a=h.getBBox(),d=a.x+f.translateX;a=a.y+f.translateY;e.inverted?a-=f.options.connectorWidth/2:d+=f.options.connectorWidth/2;e=e.isInsidePlot(d,a);h[e?"animate":"attr"]({d:this.getConnectorPath()});h.addClass(`highcharts-color-${this.colorIndex}`);b.chart.styledMode||h.attr({stroke:c.connectorColor||this.color,"stroke-width":c.connectorWidth,opacity:f[u(f.newOpacity)?"newOpacity":"opacity"]})}drawConnector(){const b=this.series;this.connector||(this.connector=b.chart.renderer.path(this.getConnectorPath()).attr({zIndex:-1}).add(this.dataLabel));
this.series.chart.isInsidePlot(this.dataLabel.x,this.dataLabel.y)&&this.alignConnector()}getConnectorPath(){let b=this.series.chart,h=this.series.xAxis.len,f=b.inverted,c=f?"x2":"y2",e=this.dataLabel,a=e.targetPosition,d={x1:this.plotX,y1:this.plotY,x2:this.plotX,y2:y(a.y)?a.y:e.y},k=(e.alignAttr||e)[c[0]]<this.series.yAxis.len/2;f&&(d={x1:this.plotY,y1:h-this.plotX,x2:a.x||e.x,y2:h-this.plotX});k&&(d[c]+=e[f?"width":"height"]);l(d,function(a,b){d[b]-=(e.alignAttr||e)[b[0]]});return b.renderer.crispLine([["M",
d.x1,d.y1],["L",d.x2,d.y2]],e.options.connectorWidth)}init(){const b=super.init.apply(this,arguments);b.name=p(b.name,"Event");b.y=1;return b}isValid(){return null!==this.options.y}setState(){const b=super.setState;this.isNull||b.apply(this,arguments)}setVisible(b,c){const f=this.series;c=p(c,f.options.ignoreHiddenPoint);q.prototype.setVisible.call(this,b,!1);f.processData();c&&f.chart.redraw()}applyOptions(c,h){c=b.prototype.optionsToObject.call(this,c);this.userDLOptions=m(this.userDLOptions,c.dataLabels);
return super.applyOptions(c,h)}}return v});c(b,"Series/Timeline/TimelineSeriesDefaults.js",[],function(){"";return{colorByPoint:!0,stickyTracking:!1,ignoreHiddenPoint:!0,legendType:"point",lineWidth:4,tooltip:{headerFormat:'<span style="color:{point.color}">\u25cf</span> <span style="font-size: 0.8em"> {point.key}</span><br/>',pointFormat:"{point.description}"},states:{hover:{lineWidthPlus:0}},dataLabels:{enabled:!0,allowOverlap:!0,alternate:!0,backgroundColor:"#ffffff",borderWidth:1,borderColor:"#999999",
borderRadius:3,color:"#333333",connectorWidth:1,distance:100,formatter:function(){let b;b=this.series.chart.styledMode?'<span class="highcharts-color-'+this.point.colorIndex+'">\u25cf </span>':'<span style="color:'+this.point.color+'">\u25cf </span>';return b+='<span class="highcharts-strong">'+(this.key||"")+"</span><br/>"+(this.point.label||"")},style:{textOutline:"none",fontWeight:"normal",fontSize:"0.8em"},shadow:!1,verticalAlign:"middle"},marker:{enabledThreshold:0,symbol:"square",radius:6,lineWidth:2,
height:15},showInLegend:!1,colorKey:"x"}});c(b,"Series/Timeline/TimelineSeries.js",[b["Core/Legend/LegendSymbol.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Renderer/SVG/SVGElement.js"],b["Series/Timeline/TimelinePoint.js"],b["Series/Timeline/TimelineSeriesDefaults.js"],b["Core/Utilities.js"]],function(b,c,r,t,x,u){const {seriesTypes:{column:g,line:m}}=c,{addEvent:l,arrayMax:p,arrayMin:v,defined:q,extend:h,merge:f,pick:w}=u;class e extends m{constructor(){super(...arguments);this.visibilityMap=
this.userOptions=this.points=this.options=this.data=void 0}alignDataLabel(a,d,b,c){var k=this.chart.inverted,n=this.visibilityMap.filter(function(a){return a}),e=this.visiblePointsCount,f=n.indexOf(a);n=this.options.dataLabels;let h=a.userDLOptions||{};f=n.alternate?f&&f!==e-1?2:1.5:1;let g;e=Math.floor(this.xAxis.len/e);let l=d.padding;a.visible&&(g=Math.abs(h.x||a.options.dataLabels.x),k?(k=2*(g-l)-a.itemHeight/2,k={width:k+"px",textOverflow:d.width/k*d.height/2>e*f?"ellipsis":"none"}):k={width:(h.width||
n.width||e*f-2*l)+"px"},d.css(k),this.chart.styledMode||d.shadow(n.shadow));super.alignDataLabel.apply(this,arguments)}bindAxes(){const a=this;super.bindAxes.call(a);["xAxis","yAxis"].forEach(function(d){"xAxis"!==d||a[d].userOptions.type||(a[d].categories=a[d].hasNames=!0)})}distributeDL(){const a=this,d=a.options.dataLabels;let b=1;if(d){const c=d.distance||0;a.points.forEach(k=>{k.options.dataLabels=f({[a.chart.inverted?"x":"y"]:d.alternate&&b%2?-c:c},k.userDLOptions);b++})}}generatePoints(){const a=
this;super.generatePoints.apply(a);a.points.forEach(function(b,c){b.applyOptions({x:a.xData[c]},a.xData[c])})}getVisibilityMap(){return(this.data.length?this.data:this.userOptions.data).map(function(a){return a&&!1!==a.visible&&!a.isNull?a:!1})}getXExtremes(a){const b=this;a=a.filter(function(a,d){return b.points[d].isValid()&&b.points[d].visible});return{min:v(a),max:p(a)}}init(){const a=this;super.init.apply(a,arguments);a.eventsToUnbind.push(l(a,"afterTranslate",function(){let b,c=Number.MAX_VALUE;
a.points.forEach(function(a){a.isInside=a.isInside&&a.visible;a.visible&&!a.isNull&&(q(b)&&(c=Math.min(c,Math.abs(a.plotX-b))),b=a.plotX)});a.closestPointRangePx=c}));a.eventsToUnbind.push(l(a,"drawDataLabels",function(){a.distributeDL()}));a.eventsToUnbind.push(l(a,"afterDrawDataLabels",function(){let b;a.points.forEach(function(a){if(b=a.dataLabel)return b.animate=function(a){this.targetPosition&&(this.targetPosition=a);return r.prototype.animate.apply(this,arguments)},b.targetPosition||(b.targetPosition=
{}),a.drawConnector()})}));a.eventsToUnbind.push(l(a.chart,"afterHideOverlappingLabel",function(){a.points.forEach(function(a){a.connector&&a.dataLabel&&a.dataLabel.oldOpacity!==a.dataLabel.newOpacity&&a.alignConnector()})}))}markerAttribs(a,b){var c=this.options.marker;let d=a.marker||{},e=d.symbol||c.symbol,f=w(d.width,c.width,this.closestPointRangePx),h=w(d.height,c.height),g=0;if(this.xAxis.dateTime)return super.markerAttribs.call(this,a,b);b&&(c=c.states[b]||{},b=d.states&&d.states[b]||{},g=
w(b.radius,c.radius,g+(c.radiusPlus||0)));a.hasImage=e&&0===e.indexOf("url");a={x:Math.floor(a.plotX)-f/2-g/2,y:a.plotY-h/2-g/2,width:f+g,height:h+g};return this.chart.inverted?{y:a.x&&a.width&&this.xAxis.len-a.x-a.width,x:a.y&&a.y,width:a.height,height:a.width}:a}processData(){let a=0,b;this.visibilityMap=this.getVisibilityMap();this.visibilityMap.forEach(function(b){b&&a++});this.visiblePointsCount=a;for(b=0;b<this.xData.length;b++)this.yData[b]=1;super.processData.call(this,arguments)}}e.defaultOptions=
f(m.defaultOptions,x);h(e.prototype,{drawLegendSymbol:b.drawRectangle,drawTracker:g.prototype.drawTracker,pointClass:t,trackerGroups:["markerGroup","dataLabelsGroup"]});c.registerSeriesType("timeline",e);"";return e});c(b,"masters/modules/timeline.src.js",[],function(){})});
//# sourceMappingURL=timeline.js.map