/*
 Highstock JS v11.0.0 (2023-04-26)

 Highcharts Stock as a plugin for Highcharts

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(B){a(B);a.Highcharts=B;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function B(a,p,E,w){a.hasOwnProperty(p)||(a[p]=w.apply(null,E),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:p,module:a[p]}})))}a=a?a._modules:
{};B(a,"Core/Axis/BrokenAxis.js",[a["Core/Axis/Stacking/StackItem.js"],a["Core/Utilities.js"]],function(a,p){const {addEvent:r,find:w,fireEvent:H,isArray:C,isNumber:v,pick:u}=p;var t;(function(c){function l(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function h(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function d(){const d=this.brokenAxis;if(d&&d.hasBreaks){const c=this.tickPositions,y=this.tickPositions.info,m=[];for(let n=
0;n<c.length;n++)d.isInAnyBreak(c[n])||m.push(c[n]);this.tickPositions=m;this.tickPositions.info=y}}function g(){this.brokenAxis||(this.brokenAxis=new x(this))}function t(){const {isDirty:d,options:{connectNulls:c},points:a,xAxis:m,yAxis:n}=this;if(d){let k=a.length;for(;k--;){const b=a[k],e=!(null===b.y&&!1===c)&&(m&&m.brokenAxis&&m.brokenAxis.isInAnyBreak(b.x,!0)||n&&n.brokenAxis&&n.brokenAxis.isInAnyBreak(b.y,!0));b.visible=e?!1:!1!==b.options.visible}}}function D(){this.drawBreaks(this.xAxis,
["x"]);this.drawBreaks(this.yAxis,u(this.pointArrayMap,["y"]))}function A(d,c){const a=this,m=a.points;let n,k,b,e;if(d&&d.brokenAxis&&d.brokenAxis.hasBreaks){const f=d.brokenAxis;c.forEach(function(q){n=f&&f.breakArray||[];k=d.isXAxis?d.min:u(a.options.threshold,d.min);m.forEach(function(f){e=u(f["stack"+q.toUpperCase()],f[q]);n.forEach(function(q){if(v(k)&&v(e)){b=!1;if(k<q.from&&e>q.to||k>q.from&&e<q.from)b="pointBreak";else if(k<q.from&&e>q.from&&e<q.to||k>q.from&&e>q.to&&e<q.from)b="pointInBreak";
b&&H(d,b,{point:f,brk:q})}})})})}}function J(){var d=this.currentDataGrouping,c=d&&d.gapSize;d=this.points.slice();const g=this.yAxis;let m=this.options.gapSize,n=d.length-1;var k;if(m&&0<n)for("value"!==this.options.gapUnit&&(m*=this.basePointRange),c&&c>m&&c>=this.basePointRange&&(m=c);n--;)k&&!1!==k.visible||(k=d[n+1]),c=d[n],!1!==k.visible&&!1!==c.visible&&(k.x-c.x>m&&(k=(c.x+k.x)/2,d.splice(n+1,0,{isNull:!0,x:k}),g.stacking&&this.options.stacking&&(k=g.stacking.stacks[this.stackKey][k]=new a(g,
g.options.stackLabels,!1,k,this.stack),k.total=0)),k=c);return this.getGraphPath(d)}const Q=[];c.compose=function(c,a){p.pushUnique(Q,c)&&(c.keepProps.push("brokenAxis"),r(c,"init",g),r(c,"afterInit",l),r(c,"afterSetTickPositions",d),r(c,"afterSetOptions",h));if(p.pushUnique(Q,a)){const c=a.prototype;c.drawBreaks=A;c.gappedPath=J;r(a,"afterGeneratePoints",t);r(a,"afterRender",D)}return c};class x{static isInBreak(c,d){const a=c.repeat||Infinity,m=c.from,n=c.to-c.from;d=d>=m?(d-m)%a:a-(m-d)%a;return c.inclusive?
d<=n:d<n&&0!==d}static lin2Val(c){var d=this.brokenAxis;d=d&&d.breakArray;if(!d||!v(c))return c;let a,m;for(m=0;m<d.length&&!(a=d[m],a.from>=c);m++)a.to<c?c+=a.len:x.isInBreak(a,c)&&(c+=a.len);return c}static val2Lin(c){var d=this.brokenAxis;d=d&&d.breakArray;if(!d||!v(c))return c;let a=c,m,n;for(n=0;n<d.length;n++)if(m=d[n],m.to<=c)a-=m.len;else if(m.from>=c)break;else if(x.isInBreak(m,c)){a-=c-m.from;break}return a}constructor(c){this.hasBreaks=!1;this.axis=c}findBreakAt(c,d){return w(d,function(d){return d.from<
c&&c<d.to})}isInAnyBreak(c,d){const a=this.axis,m=a.options.breaks||[];let n=m.length,k,b,e;if(n&&v(c)){for(;n--;)x.isInBreak(m[n],c)&&(k=!0,b||(b=u(m[n].showPoints,!a.isXAxis)));e=k&&d?k&&!b:k}return e}setBreaks(c,d){const a=this,m=a.axis,n=C(c)&&!!c.length;m.isDirty=a.hasBreaks!==n;a.hasBreaks=n;m.options.breaks=m.userOptions.breaks=c;m.forceRedraw=!0;m.series.forEach(function(k){k.isDirty=!0});n||m.val2lin!==x.val2Lin||(delete m.val2lin,delete m.lin2val);n&&(m.userOptions.ordinal=!1,m.lin2val=
x.lin2Val,m.val2lin=x.val2Lin,m.setExtremes=function(k,b,e,f,q){if(a.hasBreaks){const e=this.options.breaks||[];let f;for(;f=a.findBreakAt(k,e);)k=f.to;for(;f=a.findBreakAt(b,e);)b=f.from;b<k&&(b=k)}m.constructor.prototype.setExtremes.call(this,k,b,e,f,q)},m.setAxisTranslation=function(){m.constructor.prototype.setAxisTranslation.call(this);a.unitLength=void 0;if(a.hasBreaks){const k=m.options.breaks||[],b=[],e=[],f=u(m.pointRangePadding,0);let q=0,n,I,c=m.userMin||m.min,d=m.userMax||m.max,F,z;k.forEach(function(b){I=
b.repeat||Infinity;v(c)&&v(d)&&(x.isInBreak(b,c)&&(c+=b.to%I-c%I),x.isInBreak(b,d)&&(d-=d%I-b.from%I))});k.forEach(function(e){F=e.from;I=e.repeat||Infinity;if(v(c)&&v(d)){for(;F-I>c;)F-=I;for(;F<c;)F+=I;for(z=F;z<d;z+=I)b.push({value:z,move:"in"}),b.push({value:z+e.to-e.from,move:"out",size:e.breakSize})}});b.sort(function(b,e){return b.value===e.value?("in"===b.move?0:1)-("in"===e.move?0:1):b.value-e.value});n=0;F=c;b.forEach(function(b){n+="in"===b.move?1:-1;1===n&&"in"===b.move&&(F=b.value);0===
n&&v(F)&&(e.push({from:F,to:b.value,len:b.value-F-(b.size||0)}),q+=b.value-F-(b.size||0))});a.breakArray=e;v(c)&&v(d)&&v(m.min)&&(a.unitLength=d-c-q+f,H(m,"afterBreaks"),m.staticScale?m.transA=m.staticScale:a.unitLength&&(m.transA*=(d-m.min+f)/a.unitLength),f&&(m.minPixelPadding=m.transA*(m.minPointOffset||0)),m.min=c,m.max=d)}});u(d,!0)&&m.chart.redraw()}}c.Additions=x})(t||(t={}));return t});B(a,"masters/modules/broken-axis.src.js",[a["Core/Globals.js"],a["Core/Axis/BrokenAxis.js"]],function(a,
p){p.compose(a.Axis,a.Series)});B(a,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}});B(a,"Extensions/DataGrouping/ApproximationDefaults.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Core/Utilities.js"]],function(a,p){function r(c){const a=c.length;c=w(c);t(c)&&a&&(c=v(c/a));return c}function w(c){let a=c.length,h;if(!a&&c.hasNulls)h=null;else if(a)for(h=0;a--;)h+=c[a];return h}const {arrayMax:H,arrayMin:C,correctFloat:v,extend:u,isNumber:t}=p;p={average:r,
averages:function(){const c=[];[].forEach.call(arguments,function(a){c.push(r(a))});return"undefined"===typeof c[0]?void 0:c},close:function(c){return c.length?c[c.length-1]:c.hasNulls?null:void 0},high:function(c){return c.length?H(c):c.hasNulls?null:void 0},hlc:function(c,l,h){c=a.high(c);l=a.low(l);h=a.close(h);if(t(c)||t(l)||t(h))return[c,l,h]},low:function(c){return c.length?C(c):c.hasNulls?null:void 0},ohlc:function(c,l,h,d){c=a.open(c);l=a.high(l);h=a.low(h);d=a.close(d);if(t(c)||t(l)||t(h)||
t(d))return[c,l,h,d]},open:function(c){return c.length?c[0]:c.hasNulls?null:void 0},range:function(c,l){c=a.low(c);l=a.high(l);if(t(c)||t(l))return[c,l];if(null===c&&null===l)return null},sum:w};u(a,p);return p});B(a,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %e %b, %H:%M:%S.%L","%A, %e %b, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %e %b, %H:%M:%S","%A, %e %b, %H:%M:%S","-%H:%M:%S"],minute:["%A, %e %b, %H:%M",
"%A, %e %b, %H:%M","-%H:%M"],hour:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],day:["%A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],week:["Week from %A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",
[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}});B(a,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Utilities.js"]],function(a,p){function r(c){const d=this,a=d.series;a.forEach(function(c){c.groupPixelWidth=void 0});a.forEach(function(a){a.groupPixelWidth=d.getGroupPixelWidth&&d.getGroupPixelWidth();
a.groupPixelWidth&&(a.hasProcessed=!0);a.applyGrouping(!!c.hasExtremesChanged)})}function w(){const d=this.series;let g=d.length,h=0,D=!1,A,J;for(;g--;)if(J=d[g].options.dataGrouping)if(h=Math.max(h,c(J.groupPixelWidth,a.common.groupPixelWidth)),A=(d[g].processedXData||d[g].data).length,d[g].groupPixelWidth||A>this.chart.plotSizeX/h||A&&J.forced)D=!0;return D?h:0}function H(){this.series.forEach(function(c){c.hasProcessed=!1})}function C(d,a){let g;a=c(a,!0);d||(d={forced:!1,units:null});if(this instanceof
h)for(g=this.series.length;g--;)this.series[g].update({dataGrouping:d},!1);else this.chart.options.series.forEach(function(c){c.dataGrouping="boolean"===typeof d?d:t(d,c.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0);a&&this.chart.redraw()}const {addEvent:v,extend:u,merge:t,pick:c}=p,l=[];let h;return{compose:function(c){h=c;p.pushUnique(l,c)&&(v(c,"afterSetScale",H),v(c,"postProcessData",r),u(c.prototype,{applyGrouping:r,getGroupPixelWidth:w,setDataGrouping:C}))}}});B(a,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",
[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Axis/DateTimeAxis.js"],a["Core/Defaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,p,E,w,H,C){function r(c){var a=this.chart,n=this.options.dataGrouping,k=!1!==this.allowDG&&n&&x(n.enabled,a.options.isStock),b=this.visible||!a.options.chart.ignoreHiddenSeries;const e=this.currentDataGrouping;var f=!1;k&&!this.requireSorting&&(this.requireSorting=f=!0);
c=!1===!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!c)||!k;f&&(this.requireSorting=!1);if(!c){this.destroyGroupedData();c=n.groupAll?this.xData:this.processedXData;k=n.groupAll?this.yData:this.processedYData;var q=a.plotSizeX;f=this.xAxis;var M=f.options.ordinal,I=this.groupPixelWidth,L;let m;if(I&&c&&c.length&&q){this.isDirty=m=!0;this.points=null;var O=f.getExtremes();var F=O.min;O=O.max;M=M&&f.ordinal&&f.ordinal.getGroupIntervalFactor(F,O,this)||1;q=f.getTimeTicks(E.Additions.prototype.normalizeTimeTickInterval(I*
(O-F)/q*M,n.units||p.units),Math.min(F,c[0]),Math.max(O,c[c.length-1]),f.options.startOfWeek,c,this.closestPointRange);I=d.groupData.apply(this,[c,k,q,n.approximation]);c=I.groupedXData;k=I.groupedYData;M=0;n&&n.smoothed&&c.length&&(n.firstAnchor="firstPoint",n.anchor="middle",n.lastAnchor="lastPoint",D(32,!1,a,{"dataGrouping.smoothed":"use dataGrouping.anchor"}));a=c;var z=O,K=this.options.dataGrouping;O=this.currentDataGrouping&&this.currentDataGrouping.gapSize;if(K&&this.xData&&O&&this.groupMap){F=
a.length-1;var g=K.anchor;const b=x(K.firstAnchor,g);K=x(K.lastAnchor,g);if(g&&"start"!==g){var A=O*{middle:.5,end:1}[g];for(g=a.length-1;g--&&0<g;)a[g]+=A}b&&"start"!==b&&this.xData[0]>=a[0]&&(g=this.groupMap[0].start,A=this.groupMap[0].length,J(g)&&J(A)&&(L=g+(A-1)),a[0]={middle:a[0]+.5*O,end:a[0]+O,firstPoint:this.xData[0],lastPoint:L&&this.xData[L]}[b]);K&&"start"!==K&&O&&a[F]>=z-O&&(L=this.groupMap[this.groupMap.length-1].start,a[F]={middle:a[F]+.5*O,end:a[F]+O,firstPoint:L&&this.xData[L],lastPoint:this.xData[this.xData.length-
1]}[K])}for(L=1;L<q.length;L++)q.info.segmentStarts&&-1!==q.info.segmentStarts.indexOf(L)||(M=Math.max(q[L]-q[L-1],M));O=q.info;O.gapSize=M;this.closestPointRange=q.info.totalRange;this.groupMap=I.groupMap;if(b){b=f;L=c;if(P(L[0])&&J(b.min)&&J(b.dataMin)&&L[0]<b.min){if(!P(b.options.min)&&b.min<=b.dataMin||b.min===b.dataMin)b.min=Math.min(L[0],b.min);b.dataMin=Math.min(L[0],b.dataMin)}if(P(L[L.length-1])&&J(b.max)&&J(b.dataMax)&&L[L.length-1]>b.max){if(!P(b.options.max)&&J(b.dataMax)&&b.max>=b.dataMax||
b.max===b.dataMax)b.max=Math.max(L[L.length-1],b.max);b.dataMax=Math.max(L[L.length-1],b.dataMax)}}n.groupAll&&(this.allGroupedData=k,n=this.cropData(c,k,f.min,f.max,1),c=n.xData,k=n.yData,this.cropStart=n.start);this.processedXData=c;this.processedYData=k}else this.groupMap=null;this.hasGroupedData=m;this.currentDataGrouping=O;this.preventGraphAnimation=(e&&e.totalRange)!==(O&&O.totalRange)}}function u(){this.groupedData&&(this.groupedData.forEach(function(c,a){c&&(this.groupedData[a]=c.destroy?
c.destroy():null)},this),this.groupedData.length=0)}function t(){y.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null}function c(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")?"sum":"average"}function l(c,d,n,k){const b=this,e=b.data,f=b.options&&b.options.data,q=[],M=[],I=[],L=c.length,m=!!d,F=[],z=b.pointArrayMap,g=z&&z.length,D=["x"].concat(z||["y"]),A=this.options.dataGrouping&&this.options.dataGrouping.groupAll;
let h=0,l=0;k="function"===typeof k?k:k&&a[k]?a[k]:a[b.getDGApproximation&&b.getDGApproximation()||"average"];if(g)for(var t=z.length;t--;)F.push([]);else F.push([]);t=g||1;for(let a=0;a<=L;a++)if(!(c[a]<n[0])){for(;"undefined"!==typeof n[h+1]&&c[a]>=n[h+1]||a===L;){var x=n[h];b.dataGroupInfo={start:A?l:b.cropStart+l,length:F[0].length};var y=k.apply(b,F);b.pointClass&&!P(b.dataGroupInfo.options)&&(b.dataGroupInfo.options=Q(b.pointClass.prototype.optionsToObject.call({series:b},b.options.data[b.cropStart+
l])),D.forEach(function(e){delete b.dataGroupInfo.options[e]}));"undefined"!==typeof y&&(q.push(x),M.push(y),I.push(b.dataGroupInfo));l=a;for(x=0;x<t;x++)F[x].length=0,F[x].hasNulls=!1;h+=1;if(a===L)break}if(a===L)break;if(z){x=b.options.dataGrouping&&b.options.dataGrouping.groupAll?a:b.cropStart+a;x=e&&e[x]||b.pointClass.prototype.applyOptions.apply({series:b},[f[x]]);for(let b=0;b<g;b++)y=x[z[b]],J(y)?F[b].push(y):null===y&&(F[b].hasNulls=!0)}else x=m?d[a]:null,J(x)?F[0].push(x):null===x&&(F[0].hasNulls=
!0)}return{groupedXData:q,groupedYData:M,groupMap:I}}function h(c){c=c.options;const a=this.type,n=this.chart.options.plotOptions,k=this.useCommonDataGrouping&&p.common,b=p.seriesSpecific;let e=w.defaultOptions.plotOptions[a].dataGrouping;if(n&&(b[a]||k)){const f=this.chart.rangeSelector;e||(e=Q(p.common,b[a]));c.dataGrouping=Q(k,e,n.series&&n.series.dataGrouping,n[a].dataGrouping,this.userOptions.dataGrouping,!c.isInternal&&f&&J(f.selected)&&f.buttonOptions[f.selected].dataGrouping)}}const {series:{prototype:d}}=
H,{addEvent:g,defined:P,error:D,extend:A,isNumber:J,merge:Q,pick:x}=C,y=d.generatePoints,N=[];return{compose:function(a){const d=a.prototype.pointClass;C.pushUnique(N,d)&&g(d,"update",function(){if(this.dataGroup)return D(24,!1,this.series.chart),!1});C.pushUnique(N,a)&&(g(a,"afterSetOptions",h),g(a,"destroy",u),A(a.prototype,{applyGrouping:r,destroyGroupedData:u,generatePoints:t,getDGApproximation:c,groupData:l}))},groupData:l}});B(a,"Extensions/DataGrouping/DataGrouping.js",[a["Extensions/DataGrouping/DataGroupingAxisComposition.js"],
a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],a["Core/FormatUtilities.js"],a["Core/Utilities.js"]],function(a,p,E,w,H){function r(a){const d=this.chart,g=d.time,h=a.labelConfig,D=h.series;var A=D.tooltipOptions,l=D.options.dataGrouping;const r=D.xAxis;var x=A.xDateFormat;let y,u,G=A[a.isFooter?"footerFormat":"headerFormat"];r&&"datetime"===r.options.type&&l&&c(h.key)&&(u=D.currentDataGrouping,l=l.dateTimeLabelFormats||p.common.dateTimeLabelFormats,
u?(A=l[u.unitName],1===u.count?x=A[0]:(x=A[1],y=A[2])):!x&&l&&r.dateTime&&(x=r.dateTime.getXDateFormat(h.x,A.dateTimeLabelFormats)),x=g.dateFormat(x,h.key),y&&(x+=g.dateFormat(y,h.key+u.totalRange-1)),D.chart.styledMode&&(G=this.styledModeFormat(G)),a.text=v(G,{point:t(h.point,{key:x}),series:D},d),a.preventDefault())}const {format:v}=w,{addEvent:u,extend:t,isNumber:c}=H,l=[];w={compose:function(c,d,g){a.compose(c);E.compose(d);g&&H.pushUnique(l,g)&&u(g,"headerFormatter",r)},groupData:E.groupData};
"";"";return w});B(a,"masters/modules/datagrouping.src.js",[a["Core/Globals.js"],a["Extensions/DataGrouping/ApproximationDefaults.js"],a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGrouping.js"]],function(a,p,E,w){a.dataGrouping={approximationDefaults:p,approximations:E};w.compose(a.Axis,a.Series,a.Tooltip)});B(a,"Series/DataModifyComposition.js",[a["Core/Axis/Axis.js"],a["Core/Series/Point.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,p,
E,w){const {prototype:{tooltipFormatter:r}}=p,{addEvent:C,arrayMax:v,arrayMin:u,correctFloat:t,defined:c,isArray:l,isNumber:h,isString:d,pick:g}=w;var P;(function(a){function D(b,f,q){this.isXAxis||(this.series.forEach(function(e){"compare"===b&&"boolean"!==typeof f?e.setCompare(f,!1):"cumulative"!==b||d(f)||e.setCumulative(f,!1)}),g(q,!0)&&this.chart.redraw())}function J(b){const e=this,{numberFormatter:q}=e.series.chart,k=function(f){b=b.replace("{point."+f+"}",(0<e[f]&&"change"===f?"+":"")+q(e[f],
g(e.series.tooltipOptions.changeDecimals,2)))};c(e.change)&&k("change");c(e.cumulativeSum)&&k("cumulativeSum");return r.apply(this,[b])}function P(){const e=this.options.compare;let f;if("percent"===e||"value"===e||this.options.cumulative)f=new b(this),"percent"===e||"value"===e?f.initCompare(e):f.initCumulative();this.dataModify=f}function x(e){e=e.dataExtremes;const f=e.activeYData;if(this.dataModify&&e){let q;this.options.compare?q=[this.dataModify.modifyValue(e.dataMin),this.dataModify.modifyValue(e.dataMax)]:
this.options.cumulative&&l(f)&&2<=f.length&&(q=b.getCumulativeExtremes(f));q&&(e.dataMin=u(q),e.dataMax=v(q))}}function y(b,f){this.options.compare=this.userOptions.compare=b;this.update({},g(f,!0));!this.dataModify||"value"!==b&&"percent"!==b?this.points.forEach(b=>{delete b.change}):this.dataModify.initCompare(b)}function p(){if(this.xAxis&&this.processedYData&&this.dataModify){const b=this.processedXData,f=this.processedYData,q=f.length,k=!0===this.options.compareStart?0:1;let a=-1,c;this.pointArrayMap&&
(a=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(c=0;c<q-k;c++){const e=f[c]&&-1<a?f[c][a]:f[c];if(h(e)&&0!==e&&b[c+k]>=(this.xAxis.min||0)){this.dataModify.compareValue=e;break}}}}function G(b,f){this.setModifier("compare",b,f)}function m(b,f){b=g(b,!1);this.options.cumulative=this.userOptions.cumulative=b;this.update({},g(f,!0));this.dataModify?this.dataModify.initCumulative():this.points.forEach(b=>{delete b.cumulativeSum})}function n(b,f){this.setModifier("cumulative",
b,f)}const k=[];a.compose=function(b,f,q){if(w.pushUnique(k,b)){const e=b.prototype;e.setCompare=y;e.setCumulative=m;C(b,"afterInit",P);C(b,"afterGetExtremes",x);C(b,"afterProcessData",p)}w.pushUnique(k,f)&&(f=f.prototype,f.setCompare=G,f.setModifier=D,f.setCumulative=n);w.pushUnique(k,q)&&(q.prototype.tooltipFormatter=J);return b};class b{constructor(b){this.series=b}modifyValue(){return 0}static getCumulativeExtremes(b){let e=Infinity,q=-Infinity;b.reduce((b,f)=>{f=b+f;e=Math.min(e,f,b);q=Math.max(q,
f,b);return f});return[e,q]}initCompare(b){this.modifyValue=function(e,q){null===e&&(e=0);const f=this.compareValue;return"undefined"!==typeof e&&"undefined"!==typeof f?(e="value"===b?e-f:e/f*100-(100===this.series.options.compareBase?0:100),"undefined"!==typeof q&&(q=this.series.points[q])&&(q.change=e),e):0}}initCumulative(){this.modifyValue=function(b,f){null===b&&(b=0);if(void 0!==b&&void 0!==f){const e=0<f?this.series.points[f-1]:null;e&&e.cumulativeSum&&(b=t(e.cumulativeSum+b));if(f=this.series.points[f])f.cumulativeSum=
b;return b}return 0}}}a.Additions=b})(P||(P={}));"";return P});B(a,"Core/Axis/NavigatorAxisComposition.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,p){function r(){this.navigatorAxis||(this.navigatorAxis=new h(this))}function w(a){var c=this.chart.options,d=c.navigator;const D=this.navigatorAxis,A=c.chart.zooming.pinchType,h=c.rangeSelector;c=c.chart.zooming.type;this.isXAxis&&(d&&d.enabled||h&&h.enabled)&&("y"===c?a.zoomed=!1:(!H&&"xy"===c||H&&"xy"===A)&&this.options.range&&(d=D.previousZoom,
u(a.newMin)?D.previousZoom=[this.min,this.max]:d&&(a.newMin=d[0],a.newMax=d[1],D.previousZoom=void 0)));"undefined"!==typeof a.zoomed&&a.preventDefault()}const {isTouchDevice:H}=a,{addEvent:C,correctFloat:v,defined:u,isNumber:t,pick:c}=p,l=[];class h{static compose(a){p.pushUnique(l,a)&&(a.keepProps.push("navigatorAxis"),C(a,"init",r),C(a,"zoom",w))}constructor(a){this.axis=a}destroy(){this.axis=void 0}toFixedRange(a,g,h,D){var d=this.axis,l=d.chart;a=c(h,d.translate(a,!0,!d.horiz));g=c(D,d.translate(g,
!0,!d.horiz));l=l&&l.fixedRange;d=(d.pointRange||0)/2;const r=l&&(g-a)/l;u(h)||(a=v(a+d));u(D)||(g=v(g-d));.7<r&&1.3>r&&(D?a=g-l:g=a+l);t(a)&&t(g)||(a=g=void 0);return{min:a,max:g}}}return h});B(a,"Stock/Navigator/NavigatorDefaults.js",[a["Core/Color/Color.js"],a["Core/Series/SeriesRegistry.js"]],function(a,p){({parse:a}=a);({seriesTypes:p}=p);p={height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",
borderColor:"#999999"},maskFill:a("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:"undefined"===typeof p.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,
12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},
yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}};"";return p});B(a,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(a,p,E,w,H={}){a=H.width?H.width/2:E;p=Math.round(a/3)+.5;w=H.height||w;return[["M",-a-1,.5],["L",a,.5],["L",a,w+.5],["L",-a-1,w+.5],["L",-a-1,.5],["M",-p,4],["L",-p,w-3],["M",p-1,4],["L",p-1,w-3]]}}});
B(a,"Stock/Navigator/NavigatorComposition.js",[a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxisComposition.js"],a["Stock/Navigator/NavigatorDefaults.js"],a["Stock/Navigator/NavigatorSymbols.js"],a["Core/Renderer/RendererRegistry.js"],a["Core/Utilities.js"]],function(a,p,E,w,H,C,v){function u(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function t(){var a;const b=this.legend,e=this.navigator;let f,q,c;if(e){f=b&&b.options;q=e.xAxis;c=e.yAxis;const {scrollbarHeight:k,
scrollButtonSize:n}=e;this.inverted?(e.left=e.opposite?this.chartWidth-k-e.height:this.spacing[3]+k,e.top=this.plotTop+n):(e.left=G(q.left,this.plotLeft+n),e.top=e.navigatorOptions.top||this.chartHeight-e.height-k-((null===(a=this.scrollbar)||void 0===a?void 0:a.options.margin)||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(f&&"bottom"===f.verticalAlign&&"proximate"!==f.layout&&f.enabled&&!f.floating?b.legendHeight+G(f.margin,10):0)-(this.titleOffset?
this.titleOffset[2]:0));q&&c&&(this.inverted?q.options.left=c.options.left=e.left:q.options.top=c.options.top=e.top,q.setAxisSize(),c.setAxisSize())}}function c(a){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new n(this),G(a.redraw,!0)&&this.redraw(a.animation))}function l(){const a=this.options;if(a.navigator.enabled||a.scrollbar.enabled)this.scroller=this.navigator=new n(this)}function h(){const a=this.options,b=a.navigator,
e=a.rangeSelector;if((b&&b.enabled||e&&e.enabled)&&(!J&&"x"===a.chart.zooming.type||J&&"x"===a.chart.zooming.pinchType))return!1}function d(a){const b=a.navigator;b&&a.xAxis[0]&&(a=a.xAxis[0].getExtremes(),b.render(a.min,a.max))}function g(a){const b=a.options.navigator||{},e=a.options.scrollbar||{};this.navigator||this.scroller||!b.enabled&&!e.enabled||(N(!0,this.options.navigator,b),N(!0,this.options.scrollbar,e),delete a.options.navigator,delete a.options.scrollbar)}function r(){this.chart.navigator&&
!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}const {defaultOptions:D,setOptions:A}=a,{isTouchDevice:J}=p,{getRendererType:Q}=C,{addEvent:x,extend:y,merge:N,pick:G}=v,m=[];let n;return{compose:function(a,b,e,f){E.compose(a);n=e;v.pushUnique(m,b)&&(b.prototype.callbacks.push(d),x(b,"afterAddSeries",u),x(b,"afterSetChartSize",t),x(b,"afterUpdate",c),x(b,"beforeRender",l),x(b,"beforeShowResetZoom",h),x(b,"update",g));v.pushUnique(m,f)&&x(f,"afterUpdate",r);v.pushUnique(m,Q)&&
y(Q().prototype.symbols,H);v.pushUnique(m,A)&&y(D,{navigator:w})}}});B(a,"Core/Axis/ScrollbarAxis.js",[a["Core/Utilities.js"]],function(a){const {addEvent:p,defined:r,pick:w}=a,H=[];class C{static compose(v,u){if(!a.pushUnique(H,v))return v;const t=a=>{const c=w(a.options&&a.options.min,a.min),h=w(a.options&&a.options.max,a.max);return{axisMin:c,axisMax:h,scrollMin:r(a.dataMin)?Math.min(c,a.min,a.dataMin,w(a.threshold,Infinity)):c,scrollMax:r(a.dataMax)?Math.max(h,a.max,a.dataMax,w(a.threshold,-Infinity)):
h}};p(v,"afterInit",function(){const a=this;a.options&&a.options.scrollbar&&a.options.scrollbar.enabled&&(a.options.scrollbar.vertical=!a.horiz,a.options.startOnTick=a.options.endOnTick=!1,a.scrollbar=new u(a.chart.renderer,a.options.scrollbar,a.chart),p(a.scrollbar,"changed",function(c){let {axisMin:h,axisMax:d,scrollMin:g,scrollMax:l}=t(a);var D=l-g;let A;r(h)&&r(d)&&(a.horiz&&!a.reversed||!a.horiz&&a.reversed?(A=g+D*this.to,D=g+D*this.from):(A=g+D*(1-this.from),D=g+D*(1-this.to)),this.shouldUpdateExtremes(c.DOMType)?
a.setExtremes(D,A,!0,"mousemove"!==c.DOMType&&"touchmove"!==c.DOMType,c):this.setRange(this.from,this.to))}))});p(v,"afterRender",function(){let {scrollMin:a,scrollMax:l}=t(this),h=this.scrollbar;var d=this.axisTitleMargin+(this.titleOffset||0),g=this.chart.scrollbarsOffsets;let u=this.options.margin||0;h&&(this.horiz?(this.opposite||(g[1]+=d),h.position(this.left,this.top+this.height+2+g[1]-(this.opposite?u:0),this.width,this.height),this.opposite||(g[1]+=u),d=1):(this.opposite&&(g[0]+=d),h.position(h.options.opposite?
this.left+this.width+2+g[0]-(this.opposite?0:u):this.opposite?0:u,this.top,this.width,this.height),this.opposite&&(g[0]+=u),d=0),g[d]+=h.size+(h.options.margin||0),isNaN(a)||isNaN(l)||!r(this.min)||!r(this.max)||this.min===this.max?h.setRange(0,1):(g=(this.min-a)/(l-a),d=(this.max-a)/(l-a),this.horiz&&!this.reversed||!this.horiz&&this.reversed?h.setRange(g,d):h.setRange(1-d,1-g)))});p(v,"afterGetOffset",function(){const a=this.scrollbar;var l=a&&!a.options.opposite;l=this.horiz?2:l?3:1;a&&(this.chart.scrollbarsOffsets=
[0,0],this.chart.axisOffset[l]+=a.size+(a.options.margin||0))});return v}}return C});B(a,"Stock/Scrollbar/ScrollbarDefaults.js",[a["Core/Globals.js"]],function(a){return{height:10,barBorderRadius:5,buttonBorderRadius:0,buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",
trackBackgroundColor:"none",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}});B(a,"Stock/Scrollbar/Scrollbar.js",[a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/ScrollbarAxis.js"],a["Stock/Scrollbar/ScrollbarDefaults.js"],a["Core/Utilities.js"]],function(a,p,E,w,H){const {defaultOptions:r}=a,{addEvent:v,correctFloat:u,defined:t,destroyObjectProperties:c,fireEvent:l,merge:h,pick:d,removeEvent:g}=H;class P{static compose(a){E.compose(a,P)}static swapXY(a,c){c&&a.forEach(a=>
{const c=a.length;let d;for(let g=0;g<c;g+=2)d=a[g+1],"number"===typeof d&&(a[g+1]=a[g+2],a[g+2]=d)});return a}constructor(a,c,d){this._events=[];this.chart=void 0;this.from=this.chartY=this.chartX=0;this.scrollbar=this.renderer=this.options=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=void 0;this.trackBorderWidth=1;this.userOptions=void 0;this.y=this.x=
0;this.init(a,c,d)}addEvents(){var a=this.options.inverted?[1,0]:[0,1];const c=this.scrollbarButtons,d=this.scrollbarGroup.element,g=this.track.element,h=this.mouseDownHandler.bind(this),l=this.mouseMoveHandler.bind(this),t=this.mouseUpHandler.bind(this);a=[[c[a[0]].element,"click",this.buttonToMinClick.bind(this)],[c[a[1]].element,"click",this.buttonToMaxClick.bind(this)],[g,"click",this.trackClick.bind(this)],[d,"mousedown",h],[d.ownerDocument,"mousemove",l],[d.ownerDocument,"mouseup",t]];p.hasTouch&&
a.push([d,"touchstart",h],[d.ownerDocument,"touchmove",l],[d.ownerDocument,"touchend",t]);a.forEach(function(a){v.apply(null,a)});this._events=a}buttonToMaxClick(a){const c=(this.to-this.from)*d(this.options.step,.2);this.updatePosition(this.from+c,this.to+c);l(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})}buttonToMinClick(a){const c=u(this.to-this.from)*d(this.options.step,.2);this.updatePosition(u(this.from-c),u(this.to-c));l(this,"changed",{from:this.from,to:this.to,
trigger:"scrollbar",DOMEvent:a})}cursorToScrollbarPosition(a){var c=this.options;c=c.minWidth>this.calculatedWidth?c.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/(this.barWidth-c),chartY:(a.chartY-this.y-this.yOffset)/(this.barWidth-c)}}destroy(){const a=this,d=a.chart.scroller;a.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(c){a[c]&&a[c].destroy&&(a[c]=a[c].destroy())});d&&a===d.scrollbar&&(d.scrollbar=null,c(d.scrollbarButtons))}drawScrollbarButton(a){const c=
this.renderer,d=this.scrollbarButtons,g=this.options,h=this.size;var l=c.g().add(this.group);d.push(l);g.buttonsEnabled&&(l=c.rect().addClass("highcharts-scrollbar-button").add(l),this.chart.styledMode||l.attr({stroke:g.buttonBorderColor,"stroke-width":g.buttonBorderWidth,fill:g.buttonBackgroundColor}),l.attr(l.crisp({x:-.5,y:-.5,width:h+1,height:h+1,r:g.buttonBorderRadius},l.strokeWidth())),a=c.path(P.swapXY([["M",h/2+(a?-1:1),h/2-3],["L",h/2+(a?-1:1),h/2+3],["L",h/2+(a?2:-2),h/2]],g.vertical)).addClass("highcharts-scrollbar-arrow").add(d[a]),
this.chart.styledMode||a.attr({fill:g.buttonArrowColor}))}init(a,c,g){this.scrollbarButtons=[];this.renderer=a;this.userOptions=c;this.options=h(w,r.scrollbar,c);this.options.margin=d(this.options.margin,10);this.chart=g;this.size=d(this.options.size,this.options.height);c.enabled&&(this.render(),this.addEvents())}mouseDownHandler(a){a=this.chart.pointer.normalize(a);a=this.cursorToScrollbarPosition(a);this.chartX=a.chartX;this.chartY=a.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=
!0}mouseMoveHandler(a){var c=this.chart.pointer.normalize(a),d=this.options.vertical?"chartY":"chartX";const g=this.initPositions||[];!this.grabbedCenter||a.touches&&0===a.touches[0][d]||(c=this.cursorToScrollbarPosition(c)[d],d=this[d],d=c-d,this.hasDragged=!0,this.updatePosition(g[0]+d,g[1]+d),this.hasDragged&&l(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a}))}mouseUpHandler(a){this.hasDragged&&l(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",
DOMType:a.type,DOMEvent:a});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null}position(a,c,d,g){const {buttonsEnabled:h,margin:l=0,vertical:t}=this.options,u=this.rendered?"animate":"attr";let m=g,n=0;this.group.show();this.x=a;this.y=c+this.trackBorderWidth;this.width=d;this.height=g;this.xOffset=m;this.yOffset=n;t?(this.width=this.yOffset=d=this.size,this.xOffset=m=0,this.yOffset=n=h?this.size:0,this.barWidth=g-(h?2*d:0),this.x=a+=l):(this.height=g=this.size,this.xOffset=m=h?this.size:
0,this.barWidth=d-(h?2*g:0),this.y+=l);this.group[u]({translateX:a,translateY:this.y});this.track[u]({width:d,height:g});this.scrollbarButtons[1][u]({translateX:t?0:d-m,translateY:t?g-n:0})}removeEvents(){this._events.forEach(function(a){g.apply(null,a)});this._events.length=0}render(){const a=this.renderer,c=this.options,d=this.size,g=this.chart.styledMode,h=a.g("scrollbar").attr({zIndex:c.zIndex}).hide().add();this.group=h;this.track=a.rect().addClass("highcharts-scrollbar-track").attr({r:c.trackBorderRadius||
0,height:d,width:d}).add(h);g||this.track.attr({fill:c.trackBackgroundColor,stroke:c.trackBorderColor,"stroke-width":c.trackBorderWidth});const l=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-l%2/2,y:-l%2/2});this.scrollbarGroup=a.g().add(h);this.scrollbar=a.rect().addClass("highcharts-scrollbar-thumb").attr({height:d-l,width:d-l,r:c.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=a.path(P.swapXY([["M",-3,d/4],["L",-3,2*d/3],["M",0,d/4],["L",0,2*d/3],["M",3,
d/4],["L",3,2*d/3]],c.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);g||(this.scrollbar.attr({fill:c.barBackgroundColor,stroke:c.barBorderColor,"stroke-width":c.barBorderWidth}),this.scrollbarRifles.attr({stroke:c.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)}setRange(a,c){const d=this.options,
g=d.vertical;var h=d.minWidth,l=this.barWidth;const r=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(t(l)){var p=l*Math.min(c,1);a=Math.max(a,0);var m=Math.ceil(l*a);this.calculatedWidth=p=u(p-m);p<h&&(m=(l-h+p)*a,p=h);h=Math.floor(m+this.xOffset+this.yOffset);l=p/2-.5;this.from=a;this.to=c;g?(this.scrollbarGroup[r]({translateY:h}),this.scrollbar[r]({height:p}),this.scrollbarRifles[r]({translateY:l}),this.scrollbarTop=h,this.scrollbarLeft=
0):(this.scrollbarGroup[r]({translateX:h}),this.scrollbar[r]({width:p}),this.scrollbarRifles[r]({translateX:l}),this.scrollbarLeft=h,this.scrollbarTop=0);12>=p?this.scrollbarRifles.hide():this.scrollbarRifles.show();!1===d.showFull&&(0>=a&&1<=c?this.group.hide():this.group.show());this.rendered=!0}}shouldUpdateExtremes(a){return d(this.options.liveRedraw,p.svg&&!p.isTouchDevice&&!this.chart.boosted)||"mouseup"===a||"touchend"===a||!t(a)}trackClick(a){const c=this.chart.pointer.normalize(a),d=this.to-
this.from,g=this.y+this.scrollbarTop,h=this.x+this.scrollbarLeft;this.options.vertical&&c.chartY>g||!this.options.vertical&&c.chartX>h?this.updatePosition(this.from+d,this.to+d):this.updatePosition(this.from-d,this.to-d);l(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})}update(a){this.destroy();this.init(this.chart.renderer,h(!0,this.options,a),this.chart)}updatePosition(a,c){1<c&&(a=u(1-u(c-a)),c=1);0>a&&(c=u(c-a),a=0);this.from=a;this.to=c}}P.defaultOptions=w;r.scrollbar=
h(!0,P.defaultOptions,r.scrollbar);return P});B(a,"Stock/Navigator/Navigator.js",[a["Core/Axis/Axis.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxisComposition.js"],a["Stock/Navigator/NavigatorComposition.js"],a["Stock/Scrollbar/Scrollbar.js"],a["Core/Utilities.js"]],function(a,p,E,w,H,C,v){function u(b,...e){e=[].filter.call(e,y);if(e.length)return Math[b].apply(0,e)}const {defaultOptions:t}=p,{hasTouch:c,isTouchDevice:l}=E,{addEvent:h,clamp:d,correctFloat:g,defined:r,destroyObjectProperties:D,
erase:A,extend:J,find:B,isArray:x,isNumber:y,merge:N,pick:G,removeEvent:m,splat:n}=v;class k{static compose(b,e,a){H.compose(b,e,k,a)}constructor(b){this.rendered=this.range=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.scrollbarHeight=0;this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.scrollButtonSize=
void 0;this.init(b)}drawHandle(b,e,a,c){const f=this.navigatorOptions.handles.height;this.handles[e][c](a?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(b,10)+.5-f)}:{translateX:Math.round(this.left+parseInt(b,10)),translateY:Math.round(this.top+this.height/2-f/2-1)})}drawOutline(b,e,a,c){const f=this.navigatorOptions.maskInside;var q=this.outline.strokeWidth();const n=q/2;var k=q%2/2;const d=this.scrollButtonSize,g=this.size,h=this.top;q=this.height;const m=
h-n,l=h+q;let t=this.left;a?(a=h+e+k,e=h+b+k,k=[["M",t+q,h-d-k],["L",t+q,a],["L",t,a],["M",t,e],["L",t+q,e],["L",t+q,h+g+d]],f&&k.push(["M",t+q,a-n],["L",t+q,e+n])):(t-=d,b+=t+d-k,e+=t+d-k,k=[["M",t,m],["L",b,m],["L",b,l],["M",e,l],["L",e,m],["L",t+g+2*d,h+n]],f&&k.push(["M",b-n,m],["L",e+n,m]));this.outline[c]({d:k})}drawMasks(b,a,f,c){const e=this.left,q=this.top,n=this.height;let k,d,g,h;f?(g=[e,e,e],h=[q,q+b,q+a],d=[n,n,n],k=[b,a-b,this.size-a]):(g=[e,e+b,e+a],h=[q,q,q],d=[b,a-b,this.size-a],
k=[n,n,n]);this.shades.forEach((b,a)=>{b[c]({x:g[a],y:h[a],width:d[a],height:k[a]})})}renderElements(){const b=this,a=b.navigatorOptions,f=a.maskInside,q=b.chart,c=q.renderer,n={cursor:q.inverted?"ns-resize":"ew-resize"},k=b.navigatorGroup=c.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!f,f,!f].forEach((e,f)=>{const d=c.rect().addClass("highcharts-navigator-mask"+(1===f?"-inside":"-outside")).add(k);q.styledMode||(d.attr({fill:e?a.maskFill:"rgba(0,0,0,0)"}),1===f&&d.css(n));b.shades[f]=
d});b.outline=c.path().addClass("highcharts-navigator-outline").add(k);q.styledMode||b.outline.attr({"stroke-width":a.outlineWidth,stroke:a.outlineColor});if(a.handles&&a.handles.enabled){const e=a.handles,{height:f,width:d}=e;[0,1].forEach(a=>{b.handles[a]=c.symbol(e.symbols[a],-d/2-1,0,d,f,e);q.inverted&&b.handles[a].attr({rotation:90,rotationOriginX:Math.floor(-d/2),rotationOriginY:(f+d)/2});b.handles[a].attr({zIndex:7-a}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left",
"right"][a]).add(k);q.styledMode||b.handles[a].attr({fill:e.backgroundColor,stroke:e.borderColor,"stroke-width":e.lineWidth}).css(n)})}}update(b){(this.series||[]).forEach(b=>{b.baseSeries&&delete b.baseSeries.navigatorSeries});this.destroy();N(!0,this.chart.options.navigator,b);this.init(this.chart)}render(b,a,f,c){var e=this.chart;const q=this.xAxis,n=q.pointRange||0;var k=q.navigatorAxis.fake?e.xAxis[0]:q;const h=this.navigatorEnabled;var m=this.rendered,l=e.inverted;const t=e.xAxis[0].minRange,
u=e.xAxis[0].options.maxRange,p=this.scrollButtonSize;let x=this.scrollbarHeight,v;if(!this.hasDragged||r(f)){b=g(b-n/2);a=g(a+n/2);if(!y(b)||!y(a))if(m)f=0,c=G(q.width,k.width);else return;this.left=G(q.left,e.plotLeft+p+(l?e.plotWidth:0));var A=this.size=v=G(q.len,(l?e.plotHeight:e.plotWidth)-2*p);e=l?x:v+2*p;f=G(f,q.toPixels(b,!0));c=G(c,q.toPixels(a,!0));y(f)&&Infinity!==Math.abs(f)||(f=0,c=e);b=q.toValue(f,!0);a=q.toValue(c,!0);var w=Math.abs(g(a-b));w<t?this.grabbedLeft?f=q.toPixels(a-t-n,!0):
this.grabbedRight&&(c=q.toPixels(b+t+n,!0)):r(u)&&g(w-n)>u&&(this.grabbedLeft?f=q.toPixels(a-u-n,!0):this.grabbedRight&&(c=q.toPixels(b+u+n,!0)));this.zoomedMax=d(Math.max(f,c),0,A);this.zoomedMin=d(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(f,c),0,A);this.range=this.zoomedMax-this.zoomedMin;A=Math.round(this.zoomedMax);f=Math.round(this.zoomedMin);h&&(this.navigatorGroup.attr({visibility:"inherit"}),m=m&&!this.hasDragged?"animate":"attr",this.drawMasks(f,A,l,m),this.drawOutline(f,A,
l,m),this.navigatorOptions.handles.enabled&&(this.drawHandle(f,0,l,m),this.drawHandle(A,1,l,m)));this.scrollbar&&(l?(l=this.top-p,k=this.left-x+(h||!k.opposite?0:(k.titleOffset||0)+k.axisTitleMargin),x=v+2*p):(l=this.top+(h?this.height:-x),k=this.left-p),this.scrollbar.position(k,l,e,x),this.scrollbar.setRange(this.zoomedMin/(v||1),this.zoomedMax/(v||1)));this.rendered=!0}}addMouseEvents(){const b=this,a=b.chart,f=a.container;let q=[],n,k;b.mouseMoveHandler=n=function(a){b.onMouseMove(a)};b.mouseUpHandler=
k=function(a){b.onMouseUp(a)};q=b.getPartsEvents("mousedown");q.push(h(a.renderTo,"mousemove",n),h(f.ownerDocument,"mouseup",k));c&&(q.push(h(a.renderTo,"touchmove",n),h(f.ownerDocument,"touchend",k)),q.concat(b.getPartsEvents("touchstart")));b.eventsToUnbind=q;b.series&&b.series[0]&&q.push(h(b.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))}getPartsEvents(b){const a=this,f=[];["shades","handles"].forEach(function(e){a[e].forEach(function(c,q){f.push(h(c.element,
b,function(b){a[e+"Mousedown"](b,q)}))})});return f}shadesMousedown(b,a){b=this.chart.pointer.normalize(b);const e=this.chart,c=this.xAxis,n=this.zoomedMin,k=this.size,d=this.range;let g=this.left,h=b.chartX,m,l;e.inverted&&(h=b.chartY,g=this.top);1===a?(this.grabbedCenter=h,this.fixedWidth=d,this.dragOffset=h-n):(b=h-g-d/2,0===a?b=Math.max(0,b):2===a&&b+d>=k&&(b=k-d,this.reversedExtremes?(b-=d,l=this.getUnionExtremes().dataMin):m=this.getUnionExtremes().dataMax),b!==n&&(this.fixedWidth=d,a=c.navigatorAxis.toFixedRange(b,
b+d,l,m),r(a.min)&&e.xAxis[0].setExtremes(Math.min(a.min,a.max),Math.max(a.min,a.max),!0,null,{trigger:"navigator"})))}handlesMousedown(b,a){this.chart.pointer.normalize(b);b=this.chart;const e=b.xAxis[0],c=this.reversedExtremes;0===a?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=c?e.min:e.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=c?e.max:e.min);b.fixedRange=null}onMouseMove(b){const a=this;var f=a.chart;const c=a.navigatorSize,n=a.range,
k=a.dragOffset,d=f.inverted;let g=a.left;b.touches&&0===b.touches[0].pageX||(b=f.pointer.normalize(b),f=b.chartX,d&&(g=a.top,f=b.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,f-g,a.otherHandlePos)):a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,f-g)):a.grabbedCenter&&(a.hasDragged=!0,f<k?f=k:f>c+k-n&&(f=c+k-n),a.render(0,0,f-k,f-k+n)),a.hasDragged&&a.scrollbar&&G(a.scrollbar.options.liveRedraw,!l&&!this.chart.boosted)&&(b.DOMType=b.type,setTimeout(function(){a.onMouseUp(b)},0)))}onMouseUp(b){var a=
this.chart,f=this.xAxis,c=this.scrollbar;const n=b.DOMEvent||b,k=a.inverted,d=this.rendered&&!this.hasDragged?"animate":"attr";let g,h;(!this.hasDragged||c&&c.hasDragged)&&"scrollbar"!==b.trigger||(c=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?g=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(h=this.fixedExtreme),this.zoomedMax===this.size&&(h=this.reversedExtremes?c.dataMin:c.dataMax),0===this.zoomedMin&&(g=this.reversedExtremes?c.dataMax:c.dataMin),f=f.navigatorAxis.toFixedRange(this.zoomedMin,
this.zoomedMax,g,h),r(f.min)&&a.xAxis[0].setExtremes(Math.min(f.min,f.max),Math.max(f.min,f.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:n}));"mousemove"!==b.DOMType&&"touchmove"!==b.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&y(this.zoomedMin)&&y(this.zoomedMax)&&(a=Math.round(this.zoomedMin),b=Math.round(this.zoomedMax),
this.shades&&this.drawMasks(a,b,k,d),this.outline&&this.drawOutline(a,b,k,d),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(a,0,k,d),this.drawHandle(b,1,k,d)))}removeEvents(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(b){b()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()}removeBaseSeriesEvents(){const b=this.baseSeries||[];this.navigatorEnabled&&b[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&b.forEach(function(b){m(b,
"updatedData",this.updatedDataHandler)},this),b[0].xAxis&&m(b[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))}init(b){var e=b.options,f=e.navigator||{},c=f.enabled,n=e.scrollbar||{},k=n.enabled;e=c&&f.height||0;var d=k&&n.height||0;const g=n.buttonsEnabled&&d||0;this.handles=[];this.shades=[];this.chart=b;this.setBaseSeries();this.height=e;this.scrollbarHeight=d;this.scrollButtonSize=g;this.scrollbarEnabled=k;this.navigatorEnabled=c;this.navigatorOptions=f;this.scrollbarOptions=n;this.opposite=
G(f.opposite,!(c||!b.inverted));const m=this;c=m.baseSeries;n=b.xAxis.length;k=b.yAxis.length;d=c&&c[0]&&c[0].xAxis||b.xAxis[0]||{options:{}};b.isDirtyBox=!0;m.navigatorEnabled?(m.xAxis=new a(b,N({breaks:d.options.breaks,ordinal:d.options.ordinal},f.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:n,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},b.inverted?{offsets:[g,0,-g,0],width:e}:{offsets:[0,
-g,0,g],height:e})),m.yAxis=new a(b,N(f.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:k,isInternal:!0,reversed:G(f.yAxis&&f.yAxis.reversed,b.yAxis[0]&&b.yAxis[0].reversed,!1),zoomEnabled:!1},b.inverted?{width:e}:{height:e})),c||f.series.data?m.updateNavigatorSeries(!1):0===b.series.length&&(m.unbindRedraw=h(b,"beforeRedraw",function(){0<b.series.length&&!m.series&&(m.setBaseSeries(),m.unbindRedraw())})),m.reversedExtremes=b.inverted&&!m.xAxis.reversed||!b.inverted&&m.xAxis.reversed,m.renderElements(),
m.addMouseEvents()):(m.xAxis={chart:b,navigatorAxis:{fake:!0},translate:function(a,e){var f=b.xAxis[0];const c=f.getExtremes(),n=f.len-2*g,k=u("min",f.options.min,c.dataMin);f=u("max",f.options.max,c.dataMax)-k;return e?a*f/n+k:n*(a-k)/f},toPixels:function(b){return this.translate(b)},toValue:function(b){return this.translate(b,!0)}},m.xAxis.navigatorAxis.axis=m.xAxis,m.xAxis.navigatorAxis.toFixedRange=w.prototype.toFixedRange.bind(m.xAxis.navigatorAxis));b.options.scrollbar.enabled&&(f=N(b.options.scrollbar,
{vertical:b.inverted}),!y(f.margin)&&m.navigatorEnabled&&(f.margin=b.inverted?-3:3),b.scrollbar=m.scrollbar=new C(b.renderer,f,b),h(m.scrollbar,"changed",function(b){var a=m.size;const e=a*this.to;a*=this.from;m.hasDragged=m.scrollbar.hasDragged;m.render(0,0,a,e);this.shouldUpdateExtremes(b.DOMType)&&setTimeout(function(){m.onMouseUp(b)})}));m.addBaseSeriesEvents();m.addChartEvents()}getUnionExtremes(b){const a=this.chart.xAxis[0],f=this.xAxis,c=f.options,n=a.options;let k;b&&null===a.dataMin||(k=
{dataMin:G(c&&c.min,u("min",n.min,a.dataMin,f.dataMin,f.min)),dataMax:G(c&&c.max,u("max",n.max,a.dataMax,f.dataMax,f.max))});return k}setBaseSeries(b,a){const e=this.chart,c=this.baseSeries=[];b=b||e.options&&e.options.navigator.baseSeries||(e.series.length?B(e.series,b=>!b.options.isInternal).index:0);(e.series||[]).forEach((a,e)=>{a.options.isInternal||!a.options.showInNavigator&&(e!==b&&a.options.id!==b||!1===a.options.showInNavigator)||c.push(a)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,
a)}updateNavigatorSeries(b,a){const e=this,c=e.chart,k=e.baseSeries,d={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},g=e.series=(e.series||[]).filter(b=>{const a=b.baseSeries;return 0>k.indexOf(a)?(a&&(m(a,"updatedData",e.updatedDataHandler),delete a.navigatorSeries),b.chart&&b.destroy(),!1):!0});let h,l,z=e.navigatorOptions.series,K;k&&k.length&&
k.forEach(b=>{const f=b.navigatorSeries;var q=J({color:b.color,visible:b.visible},x(z)?t.navigator.series:z);f&&!1===e.navigatorOptions.adaptToUpdatedData||(d.name="Navigator "+k.length,h=b.options||{},K=h.navigatorOptions||{},q.dataLabels=n(q.dataLabels),l=N(h,d,q,K),l.pointRange=G(q.pointRange,K.pointRange,t.plotOptions[l.type||"line"].pointRange),q=K.data||q.data,e.hasNavigatorData=e.hasNavigatorData||!!q,l.data=q||h.data&&h.data.slice(0),f&&f.options?f.update(l,a):(b.navigatorSeries=c.initSeries(l),
b.navigatorSeries.baseSeries=b,g.push(b.navigatorSeries)))});if(z.data&&(!k||!k.length)||x(z))e.hasNavigatorData=!1,z=n(z),z.forEach((b,a)=>{d.name="Navigator "+(g.length+1);l=N(t.navigator.series,{color:c.series[a]&&!c.series[a].options.isInternal&&c.series[a].color||c.options.colors[a]||c.options.colors[0]},d,b);l.data=b.data;l.data&&(e.hasNavigatorData=!0,g.push(c.initSeries(l)))});b&&this.addBaseSeriesEvents()}addBaseSeriesEvents(){const b=this,a=b.baseSeries||[];a[0]&&a[0].xAxis&&a[0].eventsToUnbind.push(h(a[0].xAxis,
"foundExtremes",this.modifyBaseAxisExtremes));a.forEach(a=>{a.eventsToUnbind.push(h(a,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)}));a.eventsToUnbind.push(h(a,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)}));!1!==this.navigatorOptions.adaptToUpdatedData&&a.xAxis&&a.eventsToUnbind.push(h(a,"updatedData",this.updatedDataHandler));a.eventsToUnbind.push(h(a,"remove",function(){this.navigatorSeries&&(A(b.series,this.navigatorSeries),r(this.navigatorSeries.options)&&
this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})}getBaseSeriesMin(b){return this.baseSeries.reduce(function(b,a){return Math.min(b,a.xData&&a.xData.length?a.xData[0]:b)},b)}modifyNavigatorAxisExtremes(){const b=this.xAxis;if("undefined"!==typeof b.getExtremes){const a=this.getUnionExtremes(!0);!a||a.dataMin===b.min&&a.dataMax===b.max||(b.min=a.dataMin,b.max=a.dataMax)}}modifyBaseAxisExtremes(){const b=this.chart.navigator;var a=this.getExtremes();const f=a.dataMin,c=a.dataMax;a=a.max-
a.min;const k=b.stickToMin,n=b.stickToMax,d=G(this.options.overscroll,0),g=b.series&&b.series[0],m=!!this.setExtremes;let h,l;this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger||(k&&(l=f,h=l+a),n&&(h=c+d,k||(l=Math.max(f,h-a,b.getBaseSeriesMin(g&&g.xData?g.xData[0]:-Number.MAX_VALUE)))),m&&(k||n)&&y(l)&&(this.min=this.userMin=l,this.max=this.userMax=h));b.stickToMin=b.stickToMax=null}updatedDataHandler(){const b=this.chart.navigator,a=this.navigatorSeries;b.stickToMax=G(this.chart.options.navigator&&
this.chart.options.navigator.stickToMax,b.reversedExtremes?0===Math.round(b.zoomedMin):Math.round(b.zoomedMax)>=Math.round(b.size));b.stickToMin=b.shouldStickToMin(this,b);a&&!b.hasNavigatorData&&(a.options.pointStart=this.xData[0],a.setData(this.options.data,!1,null,!1))}shouldStickToMin(b,a){a=a.getBaseSeriesMin(b.xData[0]);var e=b.xAxis;b=e.max;const c=e.min;e=e.options.range;return y(b)&&y(c)?e&&0<b-a?b-a<e:c<=a:!1}addChartEvents(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(h(this.chart,
"redraw",function(){const b=this.navigator,a=b&&(b.baseSeries&&b.baseSeries[0]&&b.baseSeries[0].xAxis||this.xAxis[0]);a&&b.render(a.min,a.max)}),h(this.chart,"getMargins",function(){let b=this.navigator,a=b.opposite?"plotTop":"marginBottom";this.inverted&&(a=b.opposite?"marginRight":"plotLeft");this[a]=(this[a]||0)+(b.navigatorEnabled||!this.inverted?b.height+b.scrollbarHeight:0)+b.navigatorOptions.margin}))}destroy(){this.removeEvents();this.xAxis&&(A(this.chart.xAxis,this.xAxis),A(this.chart.axes,
this.xAxis));this.yAxis&&(A(this.chart.yAxis,this.yAxis),A(this.chart.axes,this.yAxis));(this.series||[]).forEach(b=>{b.destroy&&b.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(b=>{this[b]&&this[b].destroy&&this[b].destroy();this[b]=null});[this.handles].forEach(b=>{D(b)})}}return k});B(a,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",
rangeSelectorTo:"\u2192"},rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%e %b %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,
y:0},inputStyle:{color:"#334eff",cursor:"pointer",fontSize:"0.8em"},labelStyle:{color:"#666666",fontSize:"0.8em"}}}});B(a,"Stock/RangeSelector/RangeSelectorComposition.js",[a["Core/Defaults.js"],a["Stock/RangeSelector/RangeSelectorDefaults.js"],a["Core/Utilities.js"]],function(a,p,E){function r(){const a=this.range,c=a.type,k=this.max,b=this.chart.time,e=function(a,e){const f="year"===c?"FullYear":"Month",k=new b.Date(a),n=b.get(f,k);b.set(f,k,n+e);n===b.get(f,k)&&b.set("Date",k,0);return k.getTime()-
a};let f,d;J(a)?(f=k-a,d=a):a&&(f=k+e(k,-(a.count||1)),this.chart&&(this.chart.fixedRange=k-f));const g=x(this.dataMin,Number.MIN_VALUE);J(f)||(f=g);f<=g&&(f=g,"undefined"===typeof d&&(d=e(f,a.count)),this.newMax=Math.min(f+d,x(this.dataMax,Number.MAX_VALUE)));J(k)?!J(a)&&a&&a._offsetMin&&(f+=a._offsetMin):f=void 0;return f}function H(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new G(this))}function C(){var a=this.axes;const c=this.rangeSelector;c&&(J(c.deferredYTDClick)&&
(c.clickButton(c.deferredYTDClick),delete c.deferredYTDClick),a.forEach(a=>{a.updateNames();a.setScale()}),this.getAxisMargins(),c.render(),a=c.options.verticalAlign,c.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))}function v(a){let c,k,b,e;const f=a.rangeSelector,d=()=>{f&&(c=a.xAxis[0].getExtremes(),k=a.legend,e=f&&f.options.verticalAlign,J(c.min)&&f.render(c.min,c.max),k.display&&"top"===e&&e===k.options.verticalAlign&&(b=B(a.spacingBox),b.y=
"vertical"===k.options.layout?a.plotTop:b.y+f.getHeight(),k.group.placed=!1,k.align(b)))};f&&(A(y,b=>b[0]===a)||y.push([a,[g(a.xAxis[0],"afterSetExtremes",function(a){f&&f.render(a.min,a.max)}),g(a,"redraw",d)]]),d())}function u(){for(let a=0,c=y.length;a<c;++a){const c=y[a];if(c[0]===this){c[1].forEach(a=>a());y.splice(a,1);break}}}function t(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}function c(){var a=this.rangeSelector;
a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}function l(a){var c=a.options.rangeSelector;a=this.extraBottomMargin;const k=this.extraTopMargin;let b=this.rangeSelector;c&&c.enabled&&!P(b)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=b=new G(this));this.extraTopMargin=this.extraBottomMargin=!1;b&&(v(this),c=c&&c.verticalAlign||b.options&&b.options.verticalAlign,b.options.floating||
("bottom"===c?this.extraBottomMargin=!0:"middle"!==c&&(this.extraTopMargin=!0)),this.extraBottomMargin!==a||this.extraTopMargin!==k)&&(this.isDirtyBox=!0)}const {defaultOptions:h,setOptions:d}=a,{addEvent:g,defined:P,extend:D,find:A,isNumber:J,merge:B,pick:x}=E,y=[],N=[];let G;return{compose:function(a,n,k){G=k;E.pushUnique(N,a)&&(a.prototype.minFromRange=r);E.pushUnique(N,n)&&(g(n,"afterGetContainer",H),g(n,"beforeRender",C),g(n,"destroy",u),g(n,"getMargins",t),g(n,"render",c),g(n,"update",l),n.prototype.callbacks.push(v));
E.pushUnique(N,d)&&(D(h,{rangeSelector:p.rangeSelector}),D(h.lang,p.lang))}}});B(a,"Stock/RangeSelector/RangeSelector.js",[a["Core/Axis/Axis.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Stock/RangeSelector/RangeSelectorComposition.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,p,E,w,H,C){function r(a){if(-1!==a.indexOf("%L"))return"text";const c="aAdewbBmoyY".split("").some(b=>-1!==a.indexOf("%"+b)),b="HkIlMS".split("").some(b=>-1!==a.indexOf("%"+b));return c&&
b?"datetime-local":c?"date":b?"time":"text"}const {defaultOptions:u}=p,{addEvent:t,createElement:c,css:l,defined:h,destroyObjectProperties:d,discardElement:g,extend:P,fireEvent:D,isNumber:A,merge:J,objectEach:B,pad:x,pick:y,pInt:N,splat:G}=C;class m{static compose(a,c){w.compose(a,c,m)}constructor(a){this.buttons=void 0;this.buttonOptions=m.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=a;this.init(a)}clickButton(c,k){const b=this.chart,e=this.buttonOptions[c],
f=b.xAxis[0];var d=b.scroller&&b.scroller.getUnionExtremes()||f||{},n=e.type;const g=e.dataGrouping;let l=d.dataMin,m=d.dataMax,F,z=f&&Math.round(Math.min(f.max,y(m,f.max))),K;d=e._range;let u,p,r,x=!0;if(null!==l&&null!==m){b.fixedRange=d;this.setSelected(c);g&&(this.forcedDataGrouping=!0,a.prototype.setDataGrouping.call(f||{chart:this.chart},g,!1),this.frozenStates=e.preserveDataGrouping);if("month"===n||"year"===n)f?(n={range:e,max:z,chart:b,dataMin:l,dataMax:m},F=f.minFromRange.call(n),A(n.newMax)&&
(z=n.newMax),x=!1):d=e;else if(d)F=Math.max(z-d,l),z=Math.min(F+d,m),x=!1;else if("ytd"===n)if(f){if("undefined"===typeof m||"undefined"===typeof l)l=Number.MAX_VALUE,m=Number.MIN_VALUE,b.series.forEach(a=>{if(a=a.xData)l=Math.min(a[0],l),m=Math.max(a[a.length-1],m)}),k=!1;n=this.getYTDExtremes(m,l,b.time.useUTC);F=u=n.min;z=n.max}else{this.deferredYTDClick=c;return}else"all"===n&&f&&(b.navigator&&b.navigator.baseSeries[0]&&(b.navigator.baseSeries[0].xAxis.options.range=void 0),F=l,z=m);x&&e._offsetMin&&
h(F)&&(F+=e._offsetMin);e._offsetMax&&h(z)&&(z+=e._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=c+1);f?f.setExtremes(F,z,y(k,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:e}):(K=G(b.options.xAxis)[0],r=K.range,K.range=d,p=K.min,K.min=u,t(b,"load",function(){K.range=r;K.min=p}));D(this,"afterBtnClick")}}setSelected(a){this.selected=this.options.selected=a}init(a){const c=this,b=a.options.rangeSelector,e=b.buttons||c.defaultButtons.slice(),f=b.selected,d=function(){const a=
c.minInput,b=c.maxInput;a&&a.blur&&D(a,"blur");b&&b.blur&&D(b,"blur")};c.chart=a;c.options=b;c.buttons=[];c.buttonOptions=e;this.eventsToUnbind=[];this.eventsToUnbind.push(t(a.container,"mousedown",d));this.eventsToUnbind.push(t(a,"resize",d));e.forEach(c.computeButtonRange);"undefined"!==typeof f&&e[f]&&this.clickButton(f,!1);this.eventsToUnbind.push(t(a,"load",function(){a.xAxis&&a.xAxis[0]&&t(a.xAxis[0],"setExtremes",function(b){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==b.trigger&&
"updatedData"!==b.trigger&&c.forcedDataGrouping&&!c.frozenStates&&this.setDataGrouping(!1,!1)})}))}updateButtonStates(){const a=this;var c=this.chart;const b=this.dropdown,e=c.xAxis[0],f=Math.round(e.max-e.min),d=!e.hasVisibleSeries,g=c.scroller&&c.scroller.getUnionExtremes()||e,h=g.dataMin,l=g.dataMax;c=a.getYTDExtremes(l,h,c.time.useUTC);const m=c.min,t=c.max,z=a.selected,K=a.options.allButtonsEnabled,u=a.buttons;let p=A(z);a.buttonOptions.forEach((c,k)=>{var n=c._range,q=c.type,g=c.count||1;const M=
u[k],I=c._offsetMax-c._offsetMin,F=k===z,L=n>l-h,r=n<e.minRange;c=0;let x=!1,O=!1;n=n===f;("month"===q||"year"===q)&&f+36E5>=864E5*{month:28,year:365}[q]*g-I&&f-36E5<=864E5*{month:31,year:366}[q]*g+I?n=!0:"ytd"===q?(n=t-m+I===f,x=!F):"all"===q&&(n=e.max-e.min>=l-h,O=!F&&p&&n);q=!K&&(L||r||O||d);g=F&&n||n&&!p&&!x||F&&a.frozenStates;q?c=3:g&&(p=!0,c=2);M.state!==c&&(M.setState(c),b&&(b.options[k+1].disabled=q,2===c&&(b.selectedIndex=k+1)),0===c&&z===k&&a.setSelected())})}computeButtonRange(a){const c=
a.type,b=a.count||1,e={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(e[c])a._range=e[c]*b;else if("month"===c||"year"===c)a._range=864E5*{month:30,year:365}[c]*b;a._offsetMin=y(a.offsetMin,0);a._offsetMax=y(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin}getInputValue(a){a="min"===a?this.minInput:this.maxInput;const c=this.chart.options.rangeSelector,b=this.chart.time;return a?("text"===a.type&&c.inputDateParser||this.defaultInputDateParser)(a.value,b.useUTC,b):0}setInputValue(a,
c){const b=this.options,e=this.chart.time,f="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:this.maxDateBox;if(f){var d=f.getAttribute("data-hc-time");d=h(d)?Number(d):void 0;h(c)&&(h(d)&&f.setAttribute("data-hc-time-previous",d),f.setAttribute("data-hc-time",c),d=c);f.value=e.dateFormat(this.inputTypeFormats[f.type]||b.inputEditDateFormat,d);a&&a.attr({text:e.dateFormat(b.inputDateFormat,d)})}}setInputExtremes(a,c,b){if(a="min"===a?this.minInput:this.maxInput){const e=this.inputTypeFormats[a.type],
f=this.chart.time;e&&(c=f.dateFormat(e,c),a.min!==c&&(a.min=c),b=f.dateFormat(e,b),a.max!==b&&(a.max=b))}}showInput(a){const c="min"===a?this.minDateBox:this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&c&&this.inputGroup){const b="text"===a.type,{translateX:e,translateY:f}=this.inputGroup,{inputBoxWidth:d}=this.options;l(a,{width:b?c.width+(d?-2:20)+"px":"auto",height:c.height-2+"px",border:"2px solid silver"});b&&d?l(a,{left:e+c.x+"px",top:f+"px"}):l(a,{left:Math.min(Math.round(c.x+
e-(a.offsetWidth-c.width)/2),this.chart.chartWidth-a.offsetWidth)+"px",top:f-(a.offsetHeight-c.height)/2+"px"})}}hideInput(a){(a="min"===a?this.minInput:this.maxInput)&&l(a,{top:"-9999em",border:0,width:"1px",height:"1px"})}defaultInputDateParser(a,c,b){var e=a.split("/").join("-").split(" ").join("T");-1===e.indexOf("T")&&(e+="T00:00");if(c)e+="Z";else{var f;if(f=E.isSafari)f=e,f=!(6<f.length&&(f.lastIndexOf("-")===f.length-6||f.lastIndexOf("+")===f.length-6));f&&(f=(new Date(e)).getTimezoneOffset()/
60,e+=0>=f?`+${x(-f)}:00`:`-${x(f)}:00`)}e=Date.parse(e);A(e)||(a=a.split("-"),e=Date.UTC(N(a[0]),N(a[1])-1,N(a[2])));b&&c&&A(e)&&(e+=b.getTimezoneOffset(e));return e}drawInput(a){function d(){const {maxInput:c,minInput:e}=q,f=b.xAxis[0];var d=b.scroller&&b.scroller.xAxis?b.scroller.xAxis:f;const k=d.dataMin;d=d.dataMax;let n=q.getInputValue(a);n!==Number(z.getAttribute("data-hc-time-previous"))&&A(n)&&(z.setAttribute("data-hc-time-previous",n),m&&c&&A(k)?n>Number(c.getAttribute("data-hc-time"))?
n=void 0:n<k&&(n=k):e&&A(d)&&(n<Number(e.getAttribute("data-hc-time"))?n=void 0:n>d&&(n=d)),"undefined"!==typeof n&&f.setExtremes(m?n:f.min,m?f.max:n,void 0,void 0,{trigger:"rangeSelectorInput"}))}const {chart:b,div:e,inputGroup:f}=this,q=this,g=b.renderer.style||{};var n=b.renderer;const h=b.options.rangeSelector,m="min"===a;var t=u.lang[m?"rangeSelectorFrom":"rangeSelectorTo"]||"";t=n.label(t,0).addClass("highcharts-range-label").attr({padding:t?2:0,height:t?h.inputBoxHeight:0}).add(f);n=n.label("",
0).addClass("highcharts-range-input").attr({padding:2,width:h.inputBoxWidth,height:h.inputBoxHeight,"text-align":"center"}).on("click",function(){q.showInput(a);q[a+"Input"].focus()});b.styledMode||n.attr({stroke:h.inputBoxBorderColor,"stroke-width":1});n.add(f);const z=c("input",{name:a,className:"highcharts-range-selector"},void 0,e);z.setAttribute("type",r(h.inputDateFormat||"%e %b %Y"));b.styledMode||(t.css(J(g,h.labelStyle)),n.css(J({color:"#333333"},g,h.inputStyle)),l(z,P({position:"absolute",
border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:g.fontSize,fontFamily:g.fontFamily,top:"-9999em"},h.inputStyle)));z.onfocus=()=>{q.showInput(a)};z.onblur=()=>{z===E.doc.activeElement&&d();q.hideInput(a);q.setInputValue(a);z.blur()};let K=!1;z.onchange=()=>{K||(d(),q.hideInput(a),z.blur())};z.onkeypress=a=>{13===a.keyCode&&d()};z.onkeydown=a=>{K=!0;38!==a.keyCode&&40!==a.keyCode||d()};z.onkeyup=()=>{K=!1};return{dateBox:n,input:z,label:t}}getPosition(){var a=
this.chart;const c=a.options.rangeSelector;a="top"===c.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+c.buttonPosition.y,inputTop:a+c.inputPosition.y-10}}getYTDExtremes(a,c,b){const e=this.chart.time;var f=new e.Date(a);const d=e.get("FullYear",f);b=b?e.Date.UTC(d,0,1):+new e.Date(d,0,1);c=Math.max(c,b);f=f.getTime();return{max:Math.min(a||f,f),min:c}}render(a,d){var b=this.chart,e=b.renderer;const f=b.container;var k=b.options;const g=k.rangeSelector,n=y(k.chart.style&&k.chart.style.zIndex,
0)+1;k=g.inputEnabled;if(!1!==g.enabled){this.rendered||(this.group=e.g("range-selector-group").attr({zIndex:7}).add(),this.div=c("div",void 0,{position:"relative",height:0,zIndex:n}),this.buttonOptions.length&&this.renderButtons(),f.parentNode&&f.parentNode.insertBefore(this.div,f),k&&(this.inputGroup=e.g("input-group").add(this.group),e=this.drawInput("min"),this.minDateBox=e.dateBox,this.minLabel=e.label,this.minInput=e.input,e=this.drawInput("max"),this.maxDateBox=e.dateBox,this.maxLabel=e.label,
this.maxInput=e.input));if(k&&(this.setInputValue("min",a),this.setInputValue("max",d),a=b.scroller&&b.scroller.getUnionExtremes()||b.xAxis[0]||{},h(a.dataMin)&&h(a.dataMax)&&(b=b.xAxis[0].minRange||0,this.setInputExtremes("min",a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-b),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+b,a.dataMax)),this.inputGroup)){let a=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(b=>{if(b){const {width:c}=b.getBBox();
c&&(b.attr({x:a}),a+=c+g.inputSpacing)}})}this.alignElements();this.rendered=!0}}renderButtons(){const {buttons:a,chart:d,options:b}=this,e=u.lang,f=d.renderer,q=J(b.buttonTheme),g=q&&q.states,h=q.width||28;delete q.width;delete q.states;this.buttonGroup=f.g("range-selector-buttons").add(this.group);const l=this.dropdown=c("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);t(l,"touchstart",()=>{l.style.fontSize=
"16px"});[[E.isMS?"mouseover":"mouseenter"],[E.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(([b,c])=>{t(l,b,()=>{const e=a[this.currentButtonIndex()];e&&D(e.element,c||b)})});this.zoomText=f.label(e&&e.rangeSelectorZoom||"",0).attr({padding:b.buttonTheme.padding,height:b.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(b.labelStyle),q["stroke-width"]=y(q["stroke-width"],0));c("option",{textContent:this.zoomText.textStr,
disabled:!0},void 0,l);this.buttonOptions.forEach((b,e)=>{c("option",{textContent:b.title||b.text},void 0,l);a[e]=f.button(b.text,0,0,a=>{const c=b.events&&b.events.click;let f;c&&(f=c.call(b,a));!1!==f&&this.clickButton(e);this.isActive=!0},q,g&&g.hover,g&&g.select,g&&g.disabled).attr({"text-align":"center",width:h}).add(this.buttonGroup);b.title&&a[e].attr("title",b.title)})}alignElements(){const {buttonGroup:a,buttons:c,chart:b,group:e,inputGroup:f,options:d,zoomText:g}=this;var h=b.options;const l=
h.exporting&&!1!==h.exporting.enabled&&h.navigation&&h.navigation.buttonOptions,{buttonPosition:m,inputPosition:t,verticalAlign:z}=d;h=(a,c)=>l&&this.titleCollision(b)&&"top"===z&&"right"===c.align&&c.y-a.getBBox().height-12<(l.y||0)+(l.height||0)+b.spacing[0]?-40:0;var u=b.plotLeft;if(e&&m&&t){var p=m.x-b.spacing[3];if(a){this.positionButtons();if(!this.initialButtonGroupWidth){let a=0;g&&(a+=g.getBBox().width+5);c.forEach((b,e)=>{a+=b.width;e!==c.length-1&&(a+=d.buttonSpacing)});this.initialButtonGroupWidth=
a}u-=b.spacing[3];this.updateButtonStates();var r=h(a,m);this.alignButtonGroup(r);e.placed=a.placed=b.hasLoaded}r=0;f&&(r=h(f,t),"left"===t.align?p=u:"right"===t.align&&(p=-Math.max(b.axisOffset[1],-r)),f.align({y:t.y,width:f.getBBox().width,align:t.align,x:t.x+p-2},!0,b.spacingBox),f.placed=b.hasLoaded);this.handleCollision(r);e.align({verticalAlign:z},!0,b.spacingBox);h=e.alignAttr.translateY;u=e.getBBox().height+20;p=0;"bottom"===z&&(p=(p=b.legend&&b.legend.options)&&"bottom"===p.verticalAlign&&
p.enabled&&!p.floating?b.legend.legendHeight+y(p.margin,10):0,u=u+p-20,p=h-u-(d.floating?0:d.y)-(b.titleOffset?b.titleOffset[2]:0)-10);if("top"===z)d.floating&&(p=0),b.titleOffset&&b.titleOffset[0]&&(p=b.titleOffset[0]),p+=b.margin[0]-b.spacing[0]||0;else if("middle"===z)if(t.y===m.y)p=h;else if(t.y||m.y)p=0>t.y||0>m.y?p-Math.min(t.y,m.y):h-u;e.translate(d.x,d.y+Math.floor(p));const {minInput:k,maxInput:q,dropdown:n}=this;d.inputEnabled&&k&&q&&(k.style.marginTop=e.translateY+"px",q.style.marginTop=
e.translateY+"px");n&&(n.style.marginTop=e.translateY+"px")}}alignButtonGroup(a,c){const {chart:b,options:e,buttonGroup:f}=this,{buttonPosition:d}=e,k=b.plotLeft-b.spacing[3];let g=d.x-b.spacing[3];"right"===d.align?g+=a-k:"center"===d.align&&(g-=k/2);f&&f.align({y:d.y,width:y(c,this.initialButtonGroupWidth),align:d.align,x:g},!0,b.spacingBox)}positionButtons(){const {buttons:a,chart:c,options:b,zoomText:e}=this,f=c.hasLoaded?"animate":"attr",{buttonPosition:d}=b,g=c.plotLeft;let h=g;e&&"hidden"!==
e.visibility&&(e[f]({x:y(g+d.x,g)}),h+=d.x+e.getBBox().width+5);for(let c=0,e=this.buttonOptions.length;c<e;++c)if("hidden"!==a[c].visibility)a[c][f]({x:h}),h+=a[c].width+b.buttonSpacing;else a[c][f]({x:g})}handleCollision(a){const {chart:c,buttonGroup:b,inputGroup:e}=this,{buttonPosition:f,dropdown:d,inputPosition:g}=this.options,h=()=>{let a=0;this.buttons.forEach(b=>{b=b.getBBox();b.width>a&&(a=b.width)});return a},n=c=>{if(e&&b){const d=e.alignAttr.translateX+e.alignOptions.x-a+e.getBBox().x+
2,k=e.alignOptions.width,q=b.alignAttr.translateX+b.getBBox().x;return q+c>d&&d+k>q&&f.y<g.y+e.getBBox().height}return!1},l=()=>{e&&b&&e.attr({translateX:e.alignAttr.translateX+(c.axisOffset[1]>=-a?0:-a),translateY:e.alignAttr.translateY+b.getBBox().height+10})};if(b){if("always"===d){this.collapseButtons(a);n(h())&&l();return}"never"===d&&this.expandButtons()}e&&b?g.align===f.align||n(this.initialButtonGroupWidth+20)?"responsive"===d?(this.collapseButtons(a),n(h())&&l()):l():"responsive"===d&&this.expandButtons():
b&&"responsive"===d&&(this.initialButtonGroupWidth>c.plotWidth?this.collapseButtons(a):this.expandButtons())}collapseButtons(a){const {buttons:c,buttonOptions:b,chart:e,dropdown:f,options:d,zoomText:g}=this,h=e.userOptions.rangeSelector&&e.userOptions.rangeSelector.buttonTheme||{},n=a=>({text:a?`${a} \u25be`:"\u25be",width:"auto",paddingLeft:y(d.buttonTheme.paddingLeft,h.padding,8),paddingRight:y(d.buttonTheme.paddingRight,h.padding,8)});g&&g.hide();let l=!1;b.forEach((a,b)=>{b=c[b];2!==b.state?b.hide():
(b.show(),b.attr(n(a.text)),l=!0)});l||(f&&(f.selectedIndex=0),c[0].show(),c[0].attr(n(this.zoomText&&this.zoomText.textStr)));const {align:m}=d.buttonPosition;this.positionButtons();"right"!==m&&"center"!==m||this.alignButtonGroup(a,c[this.currentButtonIndex()].getBBox().width);this.showDropdown()}expandButtons(){const {buttons:a,buttonOptions:c,options:b,zoomText:e}=this;this.hideDropdown();e&&e.show();c.forEach((c,e)=>{e=a[e];e.show();e.attr({text:c.text,width:b.buttonTheme.width||28,paddingLeft:y(b.buttonTheme.paddingLeft,
"unset"),paddingRight:y(b.buttonTheme.paddingRight,"unset")});2>e.state&&e.setState(0)});this.positionButtons()}currentButtonIndex(){const {dropdown:a}=this;return a&&0<a.selectedIndex?a.selectedIndex-1:0}showDropdown(){const {buttonGroup:a,buttons:c,chart:b,dropdown:e}=this;if(a&&e){const {translateX:f,translateY:d}=a,k=c[this.currentButtonIndex()].getBBox();l(e,{left:b.plotLeft+f+"px",top:d+.5+"px",width:k.width+"px",height:k.height+"px"});this.hasVisibleDropdown=!0}}hideDropdown(){const {dropdown:a}=
this;a&&(l(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)}getHeight(){var a=this.options,c=this.group;const b=a.y,e=a.buttonPosition.y,f=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=c?c.getBBox(!0).height+13+b:0;c=Math.min(f,e);if(0>f&&0>e||0<f&&0<e)a+=Math.abs(c);return a}titleCollision(a){return!(a.options.title.text||a.options.subtitle.text)}update(a){const c=this.chart;J(!0,c.options.rangeSelector,a);this.destroy();this.init(c);this.render()}destroy(){const a=
this,c=a.minInput,b=a.maxInput;a.eventsToUnbind&&(a.eventsToUnbind.forEach(a=>a()),a.eventsToUnbind=void 0);d(a.buttons);c&&(c.onfocus=c.onblur=c.onchange=null);b&&(b.onfocus=b.onblur=b.onchange=null);B(a,function(b,c){b&&"chart"!==c&&(b instanceof H?b.destroy():b instanceof window.HTMLElement&&g(b));b!==m.prototype[c]&&(a[c]=null)},this)}}P(m.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,
text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"}});"";return m});B(a,"Core/Axis/OrdinalAxis.js",[a["Core/Axis/Axis.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,p,E,w){const {addEvent:r,correctFloat:C,css:v,defined:u,error:t,pick:c,timeUnits:l}=
w,h=[];var d;(function(a){function d(a,c,f,d,k=[],g=0,h){const b={},e=this.options.tickPixelInterval;var q=this.chart.time,n=[],m;let p;let r;var I=0;let M=[],x=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!k||3>k.length||"undefined"===typeof c)return q.getTimeTicks.apply(q,arguments);const v=k.length;for(m=0;m<v;m++){r=m&&k[m-1]>f;k[m]<c&&(I=m);if(m===v-1||k[m+1]-k[m]>5*g||r){if(k[m]>x){for(p=q.getTimeTicks(a,k[I],k[m],d);p.length&&p[0]<=x;)p.shift();p.length&&(x=p[p.length-
1]);n.push(M.length);M=M.concat(p)}I=m+1}if(r)break}if(p){k=p.info;if(h&&k.unitRange<=l.hour){m=M.length-1;for(I=1;I<m;I++)if(q.dateFormat("%d",M[I])!==q.dateFormat("%d",M[I-1])){b[M[I]]="day";var y=!0}y&&(b[M[0]]="day");k.higherRanks=b}k.segmentStarts=n;M.info=k}else t(12,!1,this.chart);if(h&&u(e)){I=M.length;q=[];y=[];let a;for(m=I;m--;)n=this.translate(M[m]),a&&(y[m]=a-n),q[m]=a=n;y.sort();y=y[Math.floor(y.length/2)];y<.6*e&&(y=null);m=M[I-1]>f?I-1:I;for(a=void 0;m--;)n=q[m],I=Math.abs(a-n),a&&
I<.8*e&&(null===y||I<.8*y)?(b[M[m]]&&!b[M[m+1]]?(I=m+1,a=n):I=m,M.splice(I,1)):a=n}return M}function g(a){const b=this.ordinal.positions;if(!b)return a;let c=b.length-1,d;0>a?a=b[0]:a>c?a=b[c]:(c=Math.floor(a),d=a-c);return"undefined"!==typeof d&&"undefined"!==typeof b[c]?b[c]+(d?d*(b[c+1]-b[c]):0):a}function A(a){var b=this.ordinal,c=b.positions;if(!c)return a;var d=(a-(this.old?this.old.min:this.min))*(this.old?this.old.transA:this.transA)+this.minPixelPadding;0<d&&d<this.left+this.len||(b.extendedOrdinalPositions||
(b.extendedOrdinalPositions=b.getExtendedPositions()),c=b.extendedOrdinalPositions);if(c&&c.length){a=b.getIndexOfPoint(d,c);b=C(a%1);if(0<=a&&a<c.length-1)return c[Math.floor(a)]+b*(c[Math.ceil(a)]-c[Math.floor(a)]);b=c.length;d=c[0];c=c[b-1];const e=(c-d)/(b-1);return 0>a?d+e*a:c+e*(a-b)}return a}function H(b,c){const e=a.Additions.findIndexOf(b,c,!0);return b[e]===c?e:e+(c-b[e])/(b[e+1]-b[e])}function B(){this.ordinal||(this.ordinal=new a.Additions(this))}function x(){this.isXAxis&&u(this.options.overscroll)&&
this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&u(this.userMin)&&(this.min+=this.options.overscroll))}function y(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)}function N(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))}
function G(a){const b=this.xAxis[0],c=b.options.overscroll,d=a.originalEvent.chartX,k=this.options.chart.panning;let g=!1;if(k&&"y"!==k.type&&b.options.ordinal&&b.series.length){var h=this.mouseDownX;const a=b.getExtremes(),e=a.dataMax,f=a.min,k=a.max;var m=this.hoverPoints,l=b.closestPointRange||b.ordinal&&b.ordinal.overscrollPointsRange;h=(h-d)/(b.translationSlope*(b.ordinal.slope||l));l=b.ordinal.getExtendedPositions();var n={ordinal:{positions:l,extendedOrdinalPositions:l}};l=b.index2val;const q=
b.val2lin;let t;n.ordinal.positions?1<Math.abs(h)&&(m&&m.forEach(function(a){a.setState()}),0>h?(m=n,t=b.ordinal.positions?b:n):(m=b.ordinal.positions?b:n,t=n),n=t.ordinal.positions,e>n[n.length-1]&&n.push(e),this.fixedRange=k-f,h=b.navigatorAxis.toFixedRange(void 0,void 0,l.apply(m,[q.apply(m,[f,!0])+h]),l.apply(t,[q.apply(t,[k,!0])+h])),h.min>=Math.min(a.dataMin,f)&&h.max<=Math.max(e,k)+c&&b.setExtremes(h.min,h.max,!0,!1,{trigger:"pan"}),this.mouseDownX=d,v(this.container,{cursor:"move"})):g=!0}else g=
!0;g||k&&/y/.test(k.type)?c&&(b.max=b.dataMax+c):a.preventDefault()}function m(){const a=this.xAxis;a&&a.options.ordinal&&(delete a.ordinal.index,delete a.ordinal.extendedOrdinalPositions)}function n(a,c){const b=this.ordinal;var e=b.positions;let d=b.slope,k=b.extendedOrdinalPositions;if(!e)return a;var g=e.length;if(e[0]<=a&&e[g-1]>=a)a=H(e,a);else{k||(k=b.getExtendedPositions&&b.getExtendedPositions(),b.extendedOrdinalPositions=k);if(!k||!k.length)return a;g=k.length;d||(d=(k[g-1]-k[0])/g);e=H(k,
e[0]);a=a>=k[0]&&a<=k[g-1]?H(k,a)-e:a<k[0]?-e-(k[0]-a)/d:(a-k[g-1])/d+g-e}return c?a:d*(a||0)+b.offset}a.compose=function(a,c,f){if(w.pushUnique(h,a)){const b=a.prototype;b.getTimeTicks=d;b.index2val=g;b.lin2val=A;b.val2lin=n;b.ordinal2lin=b.val2lin;r(a,"afterInit",B);r(a,"foundExtremes",x);r(a,"afterSetScale",y);r(a,"initialAxisTranslation",N)}w.pushUnique(h,f)&&r(f,"pan",G);w.pushUnique(h,c)&&r(c,"updatedData",m);return a};class k{constructor(a){this.index={};this.axis=a}beforeSetTickPositions(){const a=
this.axis,e=a.ordinal;var d=a.getExtremes();const k=d.min;var g=d.max;const h=a.isXAxis&&!!a.options.breaks;d=a.options.ordinal;const m=a.chart.options.chart.ignoreHiddenSeries;let l,n;var t;let p=[],u=Number.MAX_VALUE,r=!1,x=!1,y=!1;if(d||h){let b=0;a.series.forEach(function(a,e){n=[];0<e&&"highcharts-navigator-series"!==a.options.id&&1<a.processedXData.length&&(x=b!==a.processedXData[1]-a.processedXData[0]);b=a.processedXData[1]-a.processedXData[0];a.boosted&&(y=a.boosted);if(!(m&&!1===a.visible||
!1===a.takeOrdinalPosition&&!h)&&(p=p.concat(a.processedXData),l=p.length,p.sort(function(a,b){return a-b}),u=Math.min(u,c(a.closestPointRange,u)),l)){for(e=0;e<l-1;)p[e]!==p[e+1]&&n.push(p[e+1]),e++;n[0]!==p[0]&&n.unshift(p[0]);p=n}});x&&y&&(p.pop(),p.shift());l=p.length;if(2<l){var v=p[1]-p[0];for(t=l-1;t--&&!r;)p[t+1]-p[t]!==v&&(r=!0);!a.options.keepOrdinalPadding&&(p[0]-k>v||g-p[p.length-1]>v)&&(r=!0)}else a.options.overscroll&&(2===l?u=p[1]-p[0]:1===l?(u=a.options.overscroll,p=[p[0],p[0]+u]):
u=e.overscrollPointsRange);r||a.forceOrdinal?(a.options.overscroll&&(e.overscrollPointsRange=u,p=p.concat(e.getOverscrollPositions())),e.positions=p,v=a.ordinal2lin(Math.max(k,p[0]),!0),t=Math.max(a.ordinal2lin(Math.min(g,p[p.length-1]),!0),1),e.slope=g=(g-k)/(t-v),e.offset=k-v*g):(e.overscrollPointsRange=c(a.closestPointRange,e.overscrollPointsRange),e.positions=a.ordinal.slope=e.offset=void 0)}a.isOrdinal=d&&r;e.groupIntervalFactor=null}static findIndexOf(a,c,d){let b=0,e=a.length-1,f;for(;b<e;)f=
Math.ceil((b+e)/2),a[f]<=c?b=f:e=f-1;return a[b]===c?b:d?b:-1}getExtendedPositions(){const a=this,c=a.axis,d=c.constructor.prototype,k=c.chart,g=c.series[0].currentDataGrouping,h=g?g.count+g.unitName:"raw",l=c.options.overscroll,n=c.getExtremes();let m,t=void 0,u=a.index;u||(u=a.index={});u[h]||(m={series:[],chart:k,forceOrdinal:!1,getExtremes:function(){return{min:n.dataMin,max:n.dataMax+l}},getGroupPixelWidth:d.getGroupPixelWidth,getTimeTicks:d.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},
ordinal2lin:d.ordinal2lin,getIndexOfPoint:d.getIndexOfPoint,val2lin:d.val2lin},m.ordinal.axis=m,c.series.forEach(function(b){t={xAxis:m,xData:b.xData.slice(),chart:k,destroyGroupedData:p.noop,getProcessedData:E.prototype.getProcessedData,applyGrouping:E.prototype.applyGrouping};t.xData=t.xData.concat(a.getOverscrollPositions());t.options={dataGrouping:g?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[g.unitName,[g.count]]]}:{enabled:!1}};
m.series.push(t);b.processData.apply(t)}),t.closestPointRange!==t.basePointRange&&t.currentDataGrouping&&(m.forceOrdinal=!0),c.ordinal.beforeSetTickPositions.apply({axis:m}),u[h]=m.ordinal.positions);return u[h]}getGroupIntervalFactor(a,c,d){d=d.processedXData;const b=d.length;var e=[];var f=this.groupIntervalFactor;if(!f){for(f=0;f<b-1;f++)e[f]=d[f+1]-d[f];e.sort(function(a,b){return a-b});e=e[Math.floor(b/2)];a=Math.max(a,d[0]);c=Math.min(c,d[b-1]);this.groupIntervalFactor=f=b*e/(c-a)}return f}getIndexOfPoint(a,
d){const b=this.axis,e=this.positions?this.positions[0]:0;let g=b.series[0].points&&b.series[0].points[0]&&b.series[0].points[0].plotX||b.minPixelPadding;1<b.series.length&&b.series.forEach(function(a){a.points&&u(a.points[0])&&u(a.points[0].plotX)&&a.points[0].plotX<g&&a.points[0].plotX>=c(b.min,-Infinity)&&(g=a.points[0].plotX)});a=(a-g)/(b.translationSlope*(this.slope||b.closestPointRange||this.overscrollPointsRange));return k.findIndexOf(d,e)+a}getOverscrollPositions(){const a=this.axis,c=a.options.overscroll,
d=this.overscrollPointsRange,k=[];let g=a.dataMax;if(u(d))for(;g<=a.dataMax+c;)g+=d,k.push(g);return k}postProcessTickInterval(a){const b=this.axis,c=this.slope;return c?b.options.breaks?b.closestPointRange||a:a/(c/b.closestPointRange):a}}a.Additions=k})(d||(d={}));return d});B(a,"Series/HLC/HLCPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){({column:{prototype:{pointClass:a}}}=a.seriesTypes);class p extends a{constructor(){super(...arguments);this.series=this.plotClose=this.options=this.low=
this.high=this.close=void 0}}return p});B(a,"Series/HLC/HLCSeriesDefaults.js",[],function(){"";return{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}});B(a,"Series/HLC/HLCSeries.js",[a["Series/HLC/HLCPoint.js"],a["Series/HLC/HLCSeriesDefaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],
function(a,p,E,w){const {column:r}=E.seriesTypes,{extend:C,merge:v}=w;class u extends r{constructor(){super(...arguments);this.yData=this.points=this.options=this.data=void 0}extendStem(a,c,l){const h=a[0];a=a[1];"number"===typeof h[2]&&(h[2]=Math.max(l+c,h[2]));"number"===typeof a[2]&&(a[2]=Math.min(l-c,a[2]))}getPointPath(a,c){c=c.strokeWidth();const l=a.series,h=c%2/2,d=Math.round(a.plotX)-h,g=Math.round(a.shapeArgs.width/2),p=[["M",d,Math.round(a.yBottom)],["L",d,Math.round(a.plotHigh)]];null!==
a.close&&(a=Math.round(a.plotClose)+h,p.push(["M",d,a],["L",d+g,a]),l.extendStem(p,c/2,a));return p}drawSinglePoint(a){var c=a.series;const l=c.chart;let h=a.graphic;"undefined"!==typeof a.plotY&&(h||(a.graphic=h=l.renderer.path().add(c.group)),l.styledMode||h.attr(c.pointAttribs(a,a.selected&&"select")),c=c.getPointPath(a,h),h[h?"animate":"attr"]({d:c}).addClass(a.getClassName(),!0))}drawPoints(){this.points.forEach(this.drawSinglePoint)}init(){super.init.apply(this,arguments);this.options.stacking=
void 0}pointAttribs(a,c){a=super.pointAttribs.call(this,a,c);delete a.fill;return a}toYData(a){return[a.high,a.low,a.close]}translate(){const a=this,c=a.yAxis,l=this.pointArrayMap&&this.pointArrayMap.slice()||[],h=l.map(a=>`plot${a.charAt(0).toUpperCase()+a.slice(1)}`);h.push("yBottom");l.push("low");super.translate.apply(a);a.points.forEach(function(d){l.forEach(function(g,l){g=d[g];null!==g&&(a.dataModify&&(g=a.dataModify.modifyValue(g)),d[h[l]]=c.toPixels(g,!0))});d.tooltipPos[1]=d.plotHigh+c.pos-
a.chart.plotTop})}}u.defaultOptions=v(r.defaultOptions,p);C(u.prototype,{pointClass:a,animate:null,directTouch:!1,pointArrayMap:["high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});E.registerSeriesType("hlc",u);return u});B(a,"Series/OHLC/OHLCPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){({seriesTypes:{hlc:a}}=a);class p extends a.prototype.pointClass{constructor(){super(...arguments);this.series=this.plotOpen=this.options=this.open=
void 0}getClassName(){return super.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")}resolveUpColor(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)}resolveColor(){super.resolveColor();this.resolveUpColor()}getZone(){const a=super.getZone();this.resolveUpColor();return a}applyOptions(){super.applyOptions.apply(this,arguments);this.resolveColor&&this.resolveColor();return this}}return p});
B(a,"Series/OHLC/OHLCSeriesDefaults.js",[],function(){"";return{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'}}});B(a,"Series/OHLC/OHLCSeries.js",[a["Series/OHLC/OHLCPoint.js"],a["Series/OHLC/OHLCSeriesDefaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,p,E,w){function r(a){a=a.options;const c=a.dataGrouping;c&&a.useOhlcData&&
"highcharts-navigator-series"!==a.id&&(c.approximation="ohlc")}function C(a){a=a.options;a.useOhlcData&&"highcharts-navigator-series"!==a.id&&t(this,{pointValKey:h.prototype.pointValKey,pointArrayMap:h.prototype.pointArrayMap,toYData:h.prototype.toYData})}const {seriesTypes:{hlc:v}}=E,{addEvent:u,extend:t,merge:c}=w,l=[];class h extends v{constructor(){super(...arguments);this.points=this.options=this.data=void 0}static compose(a,...c){w.pushUnique(l,a)&&(u(a,"afterSetOptions",r),u(a,"init",C))}getPointPath(a,
c){const d=super.getPointPath(a,c);c=c.strokeWidth();const g=c%2/2,h=Math.round(a.plotX)-g,l=Math.round(a.shapeArgs.width/2);null!==a.open&&(a=Math.round(a.plotOpen)+g,d.push(["M",h,a],["L",h-l,a]),super.extendStem(d,c/2,a));return d}pointAttribs(a,c){c=super.pointAttribs.call(this,a,c);const d=this.options;delete c.fill;!a.options.color&&d.upColor&&a.open<a.close&&(c.stroke=d.upColor);return c}toYData(a){return[a.open,a.high,a.low,a.close]}}h.defaultOptions=c(v.defaultOptions,p);t(h.prototype,{pointClass:a,
pointArrayMap:["open","high","low","close"]});E.registerSeriesType("ohlc",h);return h});B(a,"Series/Candlestick/CandlestickSeriesDefaults.js",[a["Core/Defaults.js"],a["Core/Utilities.js"]],function(a,p){"";return{states:{hover:{lineWidth:2}},threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}});B(a,"Series/Candlestick/CandlestickSeries.js",[a["Series/Candlestick/CandlestickSeriesDefaults.js"],a["Core/Defaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],
function(a,p,E,w){({defaultOptions:p}=p);const {column:r,ohlc:C}=E.seriesTypes;({merge:w}=w);class v extends C{constructor(){super(...arguments);this.points=this.options=this.data=void 0}pointAttribs(a,p){const c=r.prototype.pointAttribs.call(this,a,p),l=this.options,h=a.open<a.close,d=l.lineColor||this.color,g=a.color||this.color;c["stroke-width"]=l.lineWidth;c.fill=a.options.color||(h?l.upColor||g:g);c.stroke=a.options.lineColor||(h?l.upLineColor||d:d);p&&(a=l.states[p],c.fill=a.color||c.fill,c.stroke=
a.lineColor||c.stroke,c["stroke-width"]=a.lineWidth||c["stroke-width"]);return c}drawPoints(){var a=this.points;const p=this.chart,c=this.yAxis.reversed;for(const g of a){a=g.graphic;var l=void 0,h=void 0;let t,u;var d=void 0;let r,v;const w=!a;"undefined"!==typeof g.plotY&&(a||(g.graphic=a=p.renderer.path().add(this.group)),this.chart.styledMode||a.attr(this.pointAttribs(g,g.selected&&"select")).shadow(this.options.shadow),d=a.strokeWidth()%2/2,r=Math.round(g.plotX)-d,l=g.plotOpen,h=g.plotClose,
t=Math.min(l,h),l=Math.max(l,h),v=Math.round(g.shapeArgs.width/2),h=c?l!==g.yBottom:Math.round(t)!==Math.round(g.plotHigh),u=c?Math.round(t)!==Math.round(g.plotHigh):l!==g.yBottom,t=Math.round(t)+d,l=Math.round(l)+d,d=[],d.push(["M",r-v,l],["L",r-v,t],["L",r+v,t],["L",r+v,l],["Z"],["M",r,t],["L",r,h?Math.round(c?g.yBottom:g.plotHigh):t],["M",r,l],["L",r,u?Math.round(c?g.plotHigh:g.yBottom):l]),a[w?"attr":"animate"]({d}).addClass(g.getClassName(),!0))}}}v.defaultOptions=w(C.defaultOptions,p.plotOptions,
{tooltip:C.defaultOptions.tooltip},a);E.registerSeriesType("candlestick",v);return v});B(a,"Series/Flags/FlagsPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,p){({column:{prototype:{pointClass:a}}}=a.seriesTypes);const {isNumber:r}=p;class w extends a{constructor(){super(...arguments);this.series=this.options=void 0;this.ttBelow=!1}isValid(){return r(this.y)||"undefined"===typeof this.y}hasNewShapeType(){const a=this.options.shape||this.series.options.shape;return this.graphic&&
a&&a!==this.graphic.symbolKey}}return w});B(a,"Series/Flags/FlagsSeriesDefaults.js",[],function(){"";return{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd3ff"}},style:{fontSize:"0.7em",fontWeight:"bold"}}});B(a,"Series/Flags/FlagsSymbols.js",[a["Core/Renderer/RendererRegistry.js"]],function(a){var p;(function(p){function r(a,p,
t,c,l){const h=l&&l.anchorX||a;l=l&&l.anchorY||p;const d=this.circle(h-1,l-1,2,2);d.push(["M",h,l],["L",a,p+c],["L",a,p],["L",a+t,p],["L",a+t,p+c],["L",a,p+c],["Z"]);return d}function E(a,p){a[p+"pin"]=function(t,c,l,h,d){const g=d&&d.anchorX;d=d&&d.anchorY;let r;"circle"===p&&h>l&&(t-=Math.round((h-l)/2),l=h);r=a[p](t,c,l,h);if(g&&d){let u=g;"circle"===p?u=t+l/2:(t=r[0],l=r[1],"M"===t[0]&&"L"===l[0]&&(u=(t[1]+l[1])/2));r.push(["M",u,c>d?c:c+h],["L",g,d]);r=r.concat(a.circle(g-1,d-1,2,2))}return r}}
const C=[];p.compose=function(p){-1===C.indexOf(p)&&(C.push(p),p=p.prototype.symbols,p.flag=r,E(p,"circle"),E(p,"square"));p=a.getRendererType();C.indexOf(p)&&C.push(p)}})(p||(p={}));return p});B(a,"Series/OnSeriesComposition.js",[a["Series/Column/ColumnSeries.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,p,E){const {prototype:r}=a,{prototype:B}=p,{defined:C,stableSort:v}=E;var u;(function(a){function c(a){return B.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||
this,a)}function l(){r.translate.apply(this);const a=this;var c=a.options,h=a.chart;const l=a.points;var p=c.onSeries;const t=(p=p&&h.get(p))&&p.options.step,u=p&&p.points,x=h.inverted,y=a.xAxis,w=a.yAxis;h=l.length-1;let G;c=c.onKey||"y";let m=u&&u.length,n=0,k,b,e,f;if(p&&p.visible&&m){n=(p.pointXOffset||0)+(p.barW||0)/2;var q=p.currentDataGrouping;b=u[m-1].x+(q?q.totalRange:0);v(l,(a,b)=>a.x-b.x);for(c="plot"+c[0].toUpperCase()+c.substr(1);m--&&l[h]&&!(k=u[m],q=l[h],q.y=k.y,k.x<=q.x&&"undefined"!==
typeof k[c]&&(q.x<=b&&(q.plotY=k[c],k.x<q.x&&!t&&(e=u[m+1])&&"undefined"!==typeof e[c]&&(f=(q.x-k.x)/(e.x-k.x),q.plotY+=f*(e[c]-k[c]),q.y+=f*(e.y-k.y))),h--,m++,0>h)););}l.forEach((b,c)=>{let e;b.plotX+=n;if("undefined"===typeof b.plotY||x)0<=b.plotX&&b.plotX<=y.len?x?(b.plotY=y.translate(b.x,0,1,0,1),b.plotX=C(b.y)?w.translate(b.y,0,0,0,1):0):b.plotY=(y.opposite?0:a.yAxis.len)+y.offset:b.shapeArgs={};(G=l[c-1])&&G.plotX===b.plotX&&("undefined"===typeof G.stackIndex&&(G.stackIndex=0),e=G.stackIndex+
1);b.stackIndex=e});this.onSeries=p}const h=[];a.compose=function(a){if(E.pushUnique(h,a)){const d=a.prototype;d.getPlotBox=c;d.translate=l}return a};a.getPlotBox=c;a.translate=l})(u||(u={}));return u});B(a,"Series/Flags/FlagsSeries.js",[a["Series/Flags/FlagsPoint.js"],a["Series/Flags/FlagsSeriesDefaults.js"],a["Series/Flags/FlagsSymbols.js"],a["Core/Globals.js"],a["Series/OnSeriesComposition.js"],a["Core/Renderer/RendererUtilities.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Renderer/SVG/SVGElement.js"],
a["Core/Utilities.js"]],function(a,p,E,w,B,C,v,u,t){({noop:w}=w);const {distribute:c}=C,{series:l,seriesTypes:{column:h}}=v,{addEvent:d,defined:g,extend:r,merge:D,objectEach:A,wrap:H}=t;class Q extends h{constructor(){super(...arguments);this.points=this.options=this.data=void 0}animate(a){a&&this.setClip()}drawPoints(){var a=this.points,d=this.chart;const h=d.renderer,l=d.inverted,m=this.options,n=m.y,k=this.yAxis,b={},e=[];let f,p;let t,r;let v,w,F;for(t=a.length;t--;){r=a[t];w=(l?r.plotY:r.plotX)>
this.xAxis.len;f=r.plotX;var z=r.stackIndex;var K=r.options.shape||m.shape;p=r.plotY;"undefined"!==typeof p&&(p=r.plotY+n-("undefined"!==typeof z&&z*m.stackDistance));r.anchorX=z?void 0:r.plotX;v=z?void 0:r.plotY;F="flag"!==K;z=r.graphic;"undefined"!==typeof p&&0<=f&&!w?(z&&r.hasNewShapeType()&&(z=z.destroy()),z||(z=r.graphic=h.label("",null,null,K,null,null,m.useHTML).addClass("highcharts-point").add(this.markerGroup),r.graphic.div&&(r.graphic.div.point=r),z.isNew=!0),z.attr({align:F?"center":"left",
width:m.width,height:m.height,"text-align":m.textAlign}),d.styledMode||z.attr(this.pointAttribs(r)).css(D(m.style,r.style)).shadow(m.shadow),0<f&&(f-=z.strokeWidth()%2),K={y:p,anchorY:v},m.allowOverlapX&&(K.x=f,K.anchorX=r.anchorX),z.attr({text:r.options.title||m.title||"A"})[z.isNew?"attr":"animate"](K),m.allowOverlapX||(b[r.plotX]?b[r.plotX].size=Math.max(b[r.plotX].size,z.width):b[r.plotX]={align:F?.5:0,size:z.width,target:f,anchorX:f}),r.tooltipPos=[f,p+k.pos-d.plotTop]):z&&(r.graphic=z.destroy())}if(!m.allowOverlapX){let f=
100;A(b,function(a){a.plotX=a.anchorX;e.push(a);f=Math.max(a.size,f)});c(e,l?k.len:this.xAxis.len,f);for(const c of a)d=c.plotX,(d=(a=c.graphic)&&b[d])&&a&&(g(d.pos)?a[a.isNew?"attr":"animate"]({x:d.pos+(d.align||0)*d.size,anchorX:c.anchorX}).show().isNew=!1:a.hide().isNew=!0)}m.useHTML&&this.markerGroup&&H(this.markerGroup,"on",function(a){return u.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})}drawTracker(){const a=this.points;super.drawTracker();for(const c of a){const g=
c.graphic;g&&(c.unbindMouseOver&&c.unbindMouseOver(),c.unbindMouseOver=d(g.element,"mouseover",function(){0<c.stackIndex&&!c.raised&&(c._y=g.y,g.attr({y:c._y-8}),c.raised=!0);for(const d of a)d!==c&&d.raised&&d.graphic&&(d.graphic.attr({y:d._y}),d.raised=!1)}))}}pointAttribs(a,c){const d=this.options,g=a&&a.color||this.color;let h=d.lineColor,l=a&&a.lineWidth;a=a&&a.fillColor||d.fillColor;c&&(a=d.states[c].fillColor,h=d.states[c].lineColor,l=d.states[c].lineWidth);return{fill:a||g,stroke:h||g,"stroke-width":l||
d.lineWidth||0}}setClip(){l.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])}}Q.compose=E.compose;Q.defaultOptions=D(h.defaultOptions,p);B.compose(Q);r(Q.prototype,{allowDG:!1,forceCrop:!0,invertible:!1,noSharedTooltip:!0,pointClass:a,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],buildKDTree:w,init:l.prototype.init});v.registerSeriesType("flags",Q);"";return Q});
B(a,"Core/Chart/StockChart.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/FormatUtilities.js"],a["Core/Defaults.js"],a["Stock/Navigator/NavigatorDefaults.js"],a["Stock/RangeSelector/RangeSelectorDefaults.js"],a["Stock/Scrollbar/ScrollbarDefaults.js"],a["Core/Series/Series.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,p,B,w,H,C,v,u,t,c){function l(a,b){return"xAxis"===a?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},
showLastLabel:!0}:"yAxis"===a?{labels:{y:-2},opposite:G(b.opposite,!0),showLastLabel:!(!b.categories&&"category"!==b.type),title:{text:null}}:{}}function h(a,b){return"xAxis"===a?(a={type:"datetime",categories:void 0},G(b.navigator&&b.navigator.enabled,H.enabled,!0)&&(a.startOnTick=!1,a.endOnTick=!1),a):{}}const {format:d}=B,{getOptions:g}=w,{addEvent:r,clamp:D,defined:A,extend:E,find:Q,isNumber:x,isString:y,merge:N,pick:G,splat:m}=c;class n extends p{init(a,b){const c=g(),d=a.xAxis,k=a.yAxis;var n=
G(a.navigator&&a.navigator.enabled,H.enabled,!0);a.xAxis=a.yAxis=void 0;n=N({chart:{panning:{enabled:!0,type:"x"},zooming:{pinchType:"x"}},navigator:{enabled:n},scrollbar:{enabled:G(v.enabled,!0)},rangeSelector:{enabled:G(C.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:G(c.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},a,{isStock:!0});a.xAxis=d;a.yAxis=k;n.xAxis=m(a.xAxis||{}).map(function(b,d){return N(l("xAxis",b),c.xAxis,c.xAxis&&c.xAxis[d],b,h("xAxis",a))});n.yAxis=m(a.yAxis||
{}).map(function(a,b){return N(l("yAxis",a),c.yAxis,c.yAxis&&c.yAxis[b],a)});super.init(n,b)}createAxis(a,b){b.axis=N(l(a,b.axis),b.axis,h(a,this.userOptions));return super.createAxis(a,b)}}(function(a){a.stockChart=function(b,c,d){return new a(b,c,d)}})(n||(n={}));r(u,"setOptions",function(a){let b;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?b={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(b={marker:{enabled:!1,radius:2}}),b&&(a.plotOptions[this.type]=N(a.plotOptions[this.type],
b)))});r(a,"autoLabelAlign",function(a){const {chart:b,options:c}=this,d=b._labelPanes=b._labelPanes||{},k=c.labels;if(b.options.isStock&&"yAxis"===this.coll){const b=c.top+","+c.height;!d[b]&&k.enabled&&(15===k.distance&&1===this.side&&(k.distance=0),"undefined"===typeof k.align&&(k.align="right"),d[b]=this,a.align="right",a.preventDefault())}});r(a,"destroy",function(){const a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});
r(a,"getPlotLinePath",function(a){function b(a){const b="xAxis"===a?"yAxis":"xAxis";a=c.options[b];return x(a)?[g[b][a]]:y(a)?[g.get(a)]:d.map(function(a){return a[b]})}let c=this,d=this.isLinked&&!this.series?this.linkedParent.series:this.series,g=c.chart,k=g.renderer,h=c.left,l=c.top,n,m,p,r,t=[],u=[],v,w,B=a.translatedValue,E=a.value,C=a.force,H;if(g.options.isStock&&!1!==a.acrossPanes&&"xAxis"===c.coll||"yAxis"===c.coll)a.preventDefault(),u=b(c.coll),v=c.isXAxis?g.yAxis:g.xAxis,v.forEach(function(a){if(A(a.options.id)?
-1===a.options.id.indexOf("navigator"):1){var b=a.isXAxis?"yAxis":"xAxis";b=A(a.options[b])?g[b][a.options[b]]:g[b][0];c===b&&u.push(a)}}),w=u.length?[]:[c.isXAxis?g.yAxis[0]:g.xAxis[0]],u.forEach(function(a){-1!==w.indexOf(a)||Q(w,function(b){return b.pos===a.pos&&b.len===a.len})||w.push(a)}),H=G(B,c.translate(E,void 0,void 0,a.old)),x(H)&&(c.horiz?w.forEach(function(a){let b;m=a.pos;r=m+a.len;n=p=Math.round(H+c.transB);"pass"!==C&&(n<h||n>h+c.width)&&(C?n=p=D(n,h,h+c.width):b=!0);b||t.push(["M",
n,m],["L",p,r])}):w.forEach(function(a){let b;n=a.pos;p=n+a.len;m=r=Math.round(l+c.height-H);"pass"!==C&&(m<l||m>l+c.height)&&(C?m=r=D(m,l,l+c.height):b=!0);b||t.push(["M",n,m],["L",p,r])})),a.path=0<t.length?k.crispPolyLine(t,a.lineWidth||1):null});t.prototype.crispPolyLine=function(a,b){for(let c=0;c<a.length;c+=2){const d=a[c],e=a[c+1];d[1]===e[1]&&(d[1]=e[1]=Math.round(d[1])-b%2/2);d[2]===e[2]&&(d[2]=e[2]=Math.round(d[2])+b%2/2)}return a};r(a,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=
this.crossLabel.hide())});r(a,"afterDrawCrosshair",function(a){var b,c;if(this.crosshair&&this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&x(this.min)&&x(this.max)){var f=this.chart,g=this.logarithmic,h=this.crosshair.label,k=this.horiz,l=this.opposite,n=this.left,m=this.top,p=this.width,r=this.crossLabel,t=h.format,u="",v="inside"===this.options.tickPosition,w=!1!==this.crosshair.snap,y=0,A=a.e||this.cross&&this.cross.e;a=a.point;var B=this.min,C=this.max;g&&(B=g.lin2log(B),C=g.lin2log(C));
g=k?"center":l?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";r||(r=this.crossLabel=f.renderer.label("",0,void 0,h.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(a&&a.series?a.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:h.align||g,padding:G(h.padding,8),r:G(h.borderRadius,3),zIndex:2}).add(this.labelGroup),f.styledMode||r.attr({fill:h.backgroundColor||a&&a.series&&a.series.color||"#666666",stroke:h.borderColor||
"","stroke-width":h.borderWidth||0}).css(E({color:"#ffffff",fontWeight:"normal",fontSize:"0.7em",textAlign:"center"},h.style||{})));k?(p=w?(a.plotX||0)+n:A.chartX,m+=l?0:this.height):(p=n+this.offset+(l?p:0),m=w?(a.plotY||0)+m:A.chartY);t||h.formatter||(this.dateTime&&(u="%b %d, %Y"),t="{value"+(u?":"+u:"")+"}");u=w?this.isXAxis?a.x:a.y:this.toValue(k?A.chartX:A.chartY);w=a&&a.series?a.series.isPointInside(a):x(u)&&u>B&&u<C;A="";t?A=d(t,{value:u},f):h.formatter&&x(u)&&(A=h.formatter.call(this,u));
r.attr({text:A,x:p,y:m,visibility:w?"inherit":"hidden"});h=r.getBBox();!x(r.x)||k||l||(p=r.x-h.width/2);if(x(r.y))if(k){if(v&&!l||!v&&l)m=r.y-h.height}else m=r.y-h.height/2;k?(b=n-h.x,c=n+this.width-h.x):(b="left"===this.labelAlign?n:0,c="right"===this.labelAlign?n+this.width:f.chartWidth);r.translateX<b&&(y=b-r.translateX);r.translateX+h.width>=c&&(y=-(r.translateX+h.width-c));r.attr({x:p+y,y:m,anchorX:k?p:this.opposite?0:f.chartWidth,anchorY:k?this.opposite?f.chartHeight:0:m+h.height/2})}});u.prototype.forceCropping=
function(){const a=this.chart,b=this.options.dataGrouping;return!1!==this.allowDG&&b&&G(b.enabled,a.options.isStock)};r(p,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(N(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({}),delete a.scrollbar)});return n});B(a,"masters/modules/stock.src.js",[a["Core/Globals.js"],a["Series/DataModifyComposition.js"],a["Stock/Navigator/Navigator.js"],a["Stock/RangeSelector/RangeSelector.js"],a["Stock/Scrollbar/Scrollbar.js"],a["Core/Axis/OrdinalAxis.js"],
a["Series/OHLC/OHLCSeries.js"],a["Series/Flags/FlagsSeries.js"],a["Core/Chart/StockChart.js"]],function(a,p,B,w,H,C,v,u,t){a.Navigator=B;a.RangeSelector=w;a.Scrollbar=H;a.StockChart=a.stockChart=t.stockChart;p.compose(a.Series,a.Axis,a.Point);u.compose(a.Renderer);B.compose(a.Axis,a.Chart,a.Series);v.compose(a.Series);C.compose(a.Axis,a.Series,a.Chart);w.compose(a.Axis,a.Chart);H.compose(a.Axis)})});
//# sourceMappingURL=stock.js.map