/*
 Highcharts JS v11.0.0 (2023-04-26)

 Sonification module

 (c) 2010-2022 Highsoft AS
 Author: ystein Moseng

 License: www.highcharts.com/license
*/
'use strict';(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/sonification",["highcharts"],function(v){b(v);b.Highcharts=v;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function v(b,r,h,l){b.hasOwnProperty(r)||(b[r]=l.apply(null,h),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:r,module:b[r]}})))}b=b?
b._modules:{};v(b,"Extensions/Sonification/Options.js",[],function(){"";return{sonification:{enabled:!0,duration:6E3,afterSeriesWait:700,updateInterval:200,masterVolume:.7,order:"sequential",showTooltip:!0,showCrosshair:!0,pointGrouping:{enabled:!0,groupTimespan:15,algorithm:"minmax",prop:"y"},defaultInstrumentOptions:{roundToMusicalNotes:!0,instrument:"piano",mapping:{time:"x",pan:"x",noteDuration:200,pitch:{mapTo:"y",min:"c2",max:"c6",within:"yAxis"},gapBetweenNotes:100}},defaultSpeechOptions:{language:"en-US",
mapping:{time:"x",rate:1.3,volume:.4},pointGrouping:{algorithm:"last"}}},exporting:{menuItemDefinitions:{downloadMIDI:{textKey:"downloadMIDI",onclick:function(){this.sonification&&this.sonification.downloadMIDI()}},playAsSound:{textKey:"playAsSound",onclick:function(){const b=this.sonification;b&&b.isPlaying()?b.cancel():this.sonify()}}}},lang:{downloadMIDI:"Download MIDI",playAsSound:"Play as sound"}}});v(b,"Extensions/Sonification/SynthPatch.js",[b["Core/Utilities.js"]],function(b){function r(a,
c){return(.2414*a-.2414)*Math.log(c)+(3.5-1.7*a)/1.8}function h(a,c,e){a.gain.cancelScheduledValues(c);a.gain.setTargetAtTime(e,c,t.stopRampTime/4);a.gain.setValueAtTime(e,c+t.stopRampTime)}function l(a,c,e,f,d=1){c="attack"===c;const w=f.gain;w.cancelScheduledValues(e);a.length?(1<a[0].t&&a.unshift({t:0,vol:c?0:1}),a.forEach((c,f)=>{f=a[f-1];w.setTargetAtTime(c.vol*d,e+(f?f.t/1E3+t.stopRampTime:0),Math.max(f?(c.t-f.t)/1E3:0,t.stopRampTime)/2)})):h(f,e,c?d:0)}const {clamp:y,defined:n,pick:d}=b;class A{constructor(a,
c){this.pulseWidth=Math.min(Math.max(0,c.pulseWidth||.5));const e=()=>new OscillatorNode(a,{type:"sawtooth",detune:c.detune,frequency:Math.max(1,c.frequency||350)});this.sawOscA=e();this.sawOscB=e();this.phaseInverter=new GainNode(a,{gain:-1});this.masterGain=new GainNode(a);this.delayNode=new DelayNode(a,{delayTime:this.pulseWidth/this.sawOscA.frequency.value});this.sawOscA.connect(this.masterGain);this.sawOscB.connect(this.phaseInverter);this.phaseInverter.connect(this.delayNode);this.delayNode.connect(this.masterGain)}connect(a){this.masterGain.connect(a)}getFrequencyFacade(){const a=
this;return{cancelScheduledValues(c){a.sawOscA.frequency.cancelScheduledValues(c);a.sawOscB.frequency.cancelScheduledValues(c);a.delayNode.delayTime.cancelScheduledValues(c);return a.sawOscA.frequency},setValueAtTime(c,e){this.cancelScheduledValues(e);a.sawOscA.frequency.setValueAtTime(c,e);a.sawOscB.frequency.setValueAtTime(c,e);a.delayNode.delayTime.setValueAtTime(Math.round(1E4*a.pulseWidth/c)/1E4,e);return a.sawOscA.frequency},setTargetAtTime(c,e,f){this.cancelScheduledValues(e);a.sawOscA.frequency.setTargetAtTime(c,
e,f);a.sawOscB.frequency.setTargetAtTime(c,e,f);a.delayNode.delayTime.setTargetAtTime(Math.round(1E4*a.pulseWidth/c)/1E4,e,f);return a.sawOscA.frequency}}}getPWMTarget(){return this.delayNode.delayTime}start(){this.sawOscA.start();this.sawOscB.start()}stop(a){this.sawOscA.stop(a);this.sawOscB.stop(a)}}class g{constructor(a,c,e){this.audioContext=a;this.options=c;this.fmOscillatorIx=c.fmOscillator;this.vmOscillatorIx=c.vmOscillator;this.createSoundSource();this.createGain();this.createFilters();this.createVolTracking();
e&&this.connect(e)}connect(a){[this.lowpassNode,this.highpassNode,this.volTrackingNode,this.vmNode,this.gainNode,this.whiteNoise,this.pulseNode,this.oscNode].reduce((a,e)=>e?(e.connect(a),e):a,a)}start(){this.oscNode&&this.oscNode.start();this.whiteNoise&&this.whiteNoise.start();this.pulseNode&&this.pulseNode.start()}stopAtTime(a){this.oscNode&&this.oscNode.stop(a);this.whiteNoise&&this.whiteNoise.stop(a);this.pulseNode&&this.pulseNode.stop(a)}setFreqAtTime(a,c,e=0){var f=this.options;c=y(d(f.fixedFrequency,
c)*(f.freqMultiplier||1),0,21E3);f=this.getOscTarget();const w=e/5E3;f&&(f.cancelScheduledValues(a),e&&.01<a-(this.lastUpdateTime||-1)?(f.setTargetAtTime(c,a,w),f.setValueAtTime(c,a+w)):f.setValueAtTime(c,a));this.scheduleVolTrackingChange(c,a,e);this.scheduleFilterTrackingChange(c,a,e);this.lastUpdateTime=a}getFMTarget(){return this.oscNode&&this.oscNode.detune||this.whiteNoise&&this.whiteNoise.detune||this.pulseNode&&this.pulseNode.getPWMTarget()}getVMTarget(){return this.vmNode&&this.vmNode.gain}runEnvelopeAtTime(a,
c){this.gainNode&&l(("attack"===a?this.options.attackEnvelope:this.options.releaseEnvelope)||[],a,c,this.gainNode,this.options.volume)}cancelScheduled(){this.gainNode&&this.gainNode.gain.cancelScheduledValues(this.audioContext.currentTime);const a=this.getOscTarget();a&&a.cancelScheduledValues(0);this.lowpassNode&&this.lowpassNode.frequency.cancelScheduledValues(0);this.highpassNode&&this.highpassNode.frequency.cancelScheduledValues(0);this.volTrackingNode&&this.volTrackingNode.gain.cancelScheduledValues(0)}scheduleVolTrackingChange(a,
c,e){this.volTrackingNode&&(a=r(this.options.volumePitchTrackingMultiplier||1,a),e=e?e/1E3:t.stopRampTime,this.volTrackingNode.gain.cancelScheduledValues(c),this.volTrackingNode.gain.setTargetAtTime(a,c,e/5),this.volTrackingNode.gain.setValueAtTime(a,c+e))}scheduleFilterTrackingChange(a,c,e){const f=this.options,d=e?e/1E3:t.stopRampTime;e=(e,f)=>{const w=r(f.frequencyPitchTrackingMultiplier||1,a);f=y((f.frequency||1E3)*w,0,21E3);e.frequency.cancelScheduledValues(c);e.frequency.setTargetAtTime(f,c,
d/5);e.frequency.setValueAtTime(f,c+d)};this.lowpassNode&&f.lowpass&&e(this.lowpassNode,f.lowpass);this.highpassNode&&f.highpass&&e(this.highpassNode,f.highpass)}createGain(){const a=this.options;if(n(a.volume)||a.attackEnvelope&&a.attackEnvelope.length||a.releaseEnvelope&&a.releaseEnvelope.length)this.gainNode=new GainNode(this.audioContext,{gain:d(a.volume,1)});this.vmNode=new GainNode(this.audioContext)}createSoundSource(){var a=this.options,c=this.audioContext,e=(a.fixedFrequency||0)*(a.freqMultiplier||
1);if("whitenoise"===a.type){e=2*c.sampleRate;a=c.createBuffer(1,e,c.sampleRate);const f=a.getChannelData(0);for(let a=0;a<e;++a)f[a]=1.2*Math.random()-.6;c=this.whiteNoise=c.createBufferSource();c.buffer=a;c.loop=!0}else"pulse"===a.type?this.pulseNode=new A(c,{detune:a.detune,pulseWidth:a.pulseWidth,frequency:e}):this.oscNode=new OscillatorNode(c,{type:a.type||"sine",detune:a.detune,frequency:e})}createFilters(){const a=this.options;a.lowpass&&a.lowpass.frequency&&(this.lowpassNode=new BiquadFilterNode(this.audioContext,
{type:"lowpass",Q:a.lowpass.Q||1,frequency:a.lowpass.frequency}));a.highpass&&a.highpass.frequency&&(this.highpassNode=new BiquadFilterNode(this.audioContext,{type:"highpass",Q:a.highpass.Q||1,frequency:a.highpass.frequency}))}createVolTracking(){const a=this.options;a.volumePitchTrackingMultiplier&&1!==a.volumePitchTrackingMultiplier&&(this.volTrackingNode=new GainNode(this.audioContext,{gain:1}))}getOscTarget(){return this.oscNode?this.oscNode.frequency:this.pulseNode&&this.pulseNode.getFrequencyFacade()}}
class t{constructor(a,c){this.audioContext=a;this.options=c;this.eqNodes=[];this.midiInstrument=c.midiInstrument||1;this.outputNode=new GainNode(a,{gain:0});this.createEqChain(this.outputNode);const e=this.eqNodes.length?this.eqNodes[0]:this.outputNode;this.oscillators=(this.options.oscillators||[]).map(c=>new g(a,c,n(c.fmOscillator)||n(c.vmOscillator)?void 0:e));this.oscillators.forEach(a=>{if(n(a.fmOscillatorIx)){var c=this.oscillators[a.fmOscillatorIx];c&&(c=c.getFMTarget())&&a.connect(c)}n(a.vmOscillatorIx)&&
(c=this.oscillators[a.vmOscillatorIx])&&(c=c.getVMTarget())&&a.connect(c)})}startSilently(){this.outputNode.gain.value=0;this.oscillators.forEach(a=>a.start())}stop(){const a=this.audioContext.currentTime,c=a+t.stopRampTime;h(this.outputNode,a,0);this.oscillators.forEach(a=>a.stopAtTime(c));this.outputNode.disconnect()}silenceAtTime(a){!a&&.01>this.outputNode.gain.value?this.outputNode.gain.value=0:this.releaseAtTime((a||0)+this.audioContext.currentTime)}mute(){this.cancelScheduled();h(this.outputNode,
this.audioContext.currentTime,0)}playFreqAtTime(a,c,e){const f=(a||0)+this.audioContext.currentTime,d=this.options;this.oscillators.forEach(a=>{a.setFreqAtTime(f,c,d.noteGlideDuration);a.runEnvelopeAtTime("attack",f)});l(d.masterAttackEnvelope||[],"attack",f,this.outputNode,d.masterVolume);e&&this.releaseAtTime(f+e/1E3)}cancelScheduled(){this.outputNode.gain.cancelScheduledValues(this.audioContext.currentTime);this.oscillators.forEach(a=>a.cancelScheduled())}connect(a){return this.outputNode.connect(a)}createEqChain(a){this.eqNodes=
(this.options.eq||[]).map(a=>new BiquadFilterNode(this.audioContext,Object.assign({type:"peaking"},a)));this.eqNodes.reduceRight((a,e)=>{e.connect(a);return e},a)}releaseAtTime(a){let c=0;this.oscillators.forEach(e=>{const d=e.options.releaseEnvelope;d&&d.length&&(c=Math.max(c,d[d.length-1].t),e.runEnvelopeAtTime("release",a))});const e=this.options.masterReleaseEnvelope||[];e.length&&(l(e,"release",a,this.outputNode,this.options.masterVolume),c=Math.max(c,e[e.length-1].t));h(this.outputNode,a+c/
1E3,0)}}t.stopRampTime=.012;"";return t});v(b,"Extensions/Sonification/InstrumentPresets.js",[],function(){"";return{piano:{masterVolume:.45,masterAttackEnvelope:[{t:1,vol:.71},{t:40,vol:.79},{t:82,vol:.64},{t:147,vol:.29},{t:260,vol:.15},{t:417,vol:.05},{t:589,vol:0}],eq:[{frequency:200,Q:.7,gain:6},{frequency:450,gain:6},{frequency:1300,gain:2},{frequency:2600,Q:.8,gain:8},{frequency:3500,Q:.8,gain:6},{frequency:6200,Q:.8,gain:10},{frequency:8E3,gain:-23},{frequency:1E4,Q:.4,gain:-12}],oscillators:[{type:"pulse",
volume:.5,pulseWidth:.55,volumePitchTrackingMultiplier:.1,lowpass:{frequency:4.5,frequencyPitchTrackingMultiplier:900,Q:-2},highpass:{frequency:270},attackEnvelope:[{t:1,vol:1}],releaseEnvelope:[{t:1,vol:1},{t:282,vol:.64},{t:597,vol:0}]},{type:"whitenoise",volume:.8,lowpass:{frequency:400},highpass:{frequency:300},attackEnvelope:[{t:1,vol:1},{t:19,vol:0}]}]},plucked:{masterVolume:.5,midiInstrument:25,masterAttackEnvelope:[{t:1,vol:.71},{t:4,vol:.71},{t:31,vol:.4},{t:109,vol:.12},{t:234,vol:.04},
{t:442,vol:0}],eq:[{frequency:800,gain:-8},{frequency:1400,Q:4,gain:4},{frequency:1600,gain:-14},{frequency:2200,gain:-8},{frequency:3600,gain:-2},{frequency:6400,Q:2,gain:-6}],oscillators:[{type:"sawtooth",volume:.9,volumePitchTrackingMultiplier:.6,highpass:{frequency:100},lowpass:{frequency:8E3},releaseEnvelope:[{t:1,vol:1},{t:315,vol:.56},{t:550,vol:0}]}]},flute:{masterVolume:1.1,midiInstrument:74,noteGlideDuration:30,masterAttackEnvelope:[{t:0,vol:0},{t:29,vol:1},{t:76,vol:.48},{t:600,vol:.36}],
masterReleaseEnvelope:[{t:1,vol:.36},{t:24,vol:.15},{t:119,vol:0}],eq:[{frequency:150,Q:.6,gain:-10},{frequency:500,gain:4},{frequency:1100,gain:-4},{frequency:2200,gain:-14},{frequency:5E3,gain:8},{frequency:6400,gain:10},{frequency:8E3,gain:12},{frequency:10800,gain:8}],oscillators:[{type:"triangle",volume:1,volumePitchTrackingMultiplier:.4,lowpass:{frequency:12,frequencyPitchTrackingMultiplier:100},highpass:{frequency:200}},{type:"sine",fixedFrequency:5,volume:.2,vmOscillator:0,attackEnvelope:[{t:1,
vol:1},{t:48,vol:0},{t:225,vol:.05},{t:600,vol:.77}]},{type:"whitenoise",volume:.13,lowpass:{frequency:9E3,Q:3},highpass:{frequency:6E3,Q:3},vmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:26,vol:1},{t:93,vol:.8}]}]},lead:{masterVolume:1,midiInstrument:20,masterAttackEnvelope:[{t:1,vol:.81},{t:98,vol:.5},{t:201,vol:.18},{t:377,vol:.04},{t:586,vol:0},{t:586,vol:0}],eq:[{frequency:200,gain:-6},{frequency:400,gain:-8},{frequency:800,Q:.5,gain:-10},{frequency:1200,gain:4},{frequency:3600,gain:-4},{frequency:4200,
gain:-12},{frequency:7400,gain:-14},{frequency:1E4,gain:2}],oscillators:[{type:"triangle",volume:1.1,volumePitchTrackingMultiplier:.6,lowpass:{frequency:5E3},highpass:{frequency:100}},{type:"sawtooth",volume:.4,lowpass:{frequency:7E3},highpass:{frequency:800,Q:6},releaseEnvelope:[{t:0,vol:.99},{t:200,vol:.83},{t:495,vol:0}]}]},vibraphone:{masterVolume:1,midiInstrument:12,masterAttackEnvelope:[{t:1,vol:0},{t:10,vol:.63},{t:82,vol:.64},{t:149,vol:.26},{t:600,vol:0}],eq:[{frequency:200,Q:.8,gain:-12},
{frequency:400,gain:-4},{frequency:1600,Q:.5,gain:6},{frequency:2200,Q:.5,gain:6},{frequency:6400,gain:4},{frequency:12800,gain:4}],oscillators:[{type:"sine",volume:1.5,volumePitchTrackingMultiplier:1e-7,attackEnvelope:[{t:1,vol:1}],releaseEnvelope:[{t:1,vol:1},{t:146,vol:.39},{t:597,vol:0}]},{type:"whitenoise",volume:.03,volumePitchTrackingMultiplier:.0001,lowpass:{frequency:900},highpass:{frequency:800},attackEnvelope:[{t:1,vol:1},{t:9,vol:0}]},{type:"sine",freqMultiplier:4,volume:.15,volumePitchTrackingMultiplier:.0001},
{type:"sine",fixedFrequency:3,volume:6,fmOscillator:0,releaseEnvelope:[{t:1,vol:1},{t:190,vol:.41},{t:600,vol:0}]},{type:"sine",fixedFrequency:6,volume:3,fmOscillator:2},{type:"sine",freqMultiplier:9,volume:.0005,volumePitchTrackingMultiplier:.0001,releaseEnvelope:[{t:1,vol:.97},{t:530,vol:0}]}]},saxophone:{masterVolume:1,midiInstrument:67,noteGlideDuration:10,masterAttackEnvelope:[{t:1,vol:.57},{t:35,vol:1},{t:87,vol:.84},{t:111,vol:.6},{t:296,vol:.49},{t:600,vol:.58}],masterReleaseEnvelope:[{t:1,
vol:.58},{t:47,vol:.16},{t:119,vol:0}],eq:[{frequency:200,gain:-2},{frequency:600,gain:2},{frequency:800,gain:-10},{frequency:1100,gain:-2},{frequency:2200,gain:-2},{frequency:3500,gain:10},{frequency:12800,gain:4}],oscillators:[{type:"sawtooth",volume:.45,volumePitchTrackingMultiplier:.06,lowpass:{frequency:18,frequencyPitchTrackingMultiplier:200},highpass:{frequency:300}},{type:"whitenoise",fixedFrequency:1,volume:.4,highpass:{frequency:7E3},vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:51,vol:1},
{t:86,vol:.84},{t:500,vol:.78}]},{type:"sine",fixedFrequency:4,volume:2,fmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:15,vol:.94},{t:79,vol:1},{t:172,vol:.47},{t:500,vol:.26}]},{type:"sine",fixedFrequency:7,volume:6,fmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:25,vol:.99},{t:85,vol:0},{t:85,vol:0},{t:387,vol:.02},{t:511,vol:.43},{t:600,vol:0}]}]},trumpet:{masterVolume:.3,midiInstrument:57,noteGlideDuration:40,masterAttackEnvelope:[{t:1,vol:0},{t:17,vol:1},{t:42,vol:.85},{t:76,vol:1},{t:202,vol:.65},
{t:226,vol:.86},{t:282,vol:.63}],masterReleaseEnvelope:[{t:1,vol:.62},{t:34,vol:.14},{t:63,vol:.21},{t:96,vol:0}],eq:[{frequency:200,Q:.6,gain:10},{frequency:600,Q:.5,gain:6},{frequency:1500,Q:.7,gain:14},{frequency:3200,Q:2,gain:8},{frequency:3800,Q:.8,gain:10},{frequency:6200,gain:12},{frequency:8400,gain:-20},{frequency:12800,Q:.5,gain:-18}],oscillators:[{type:"sawtooth",volume:.15,pulseWidth:.5,volumePitchTrackingMultiplier:.5,lowpass:{frequency:1900,Q:3}},{type:"sine",fixedFrequency:6,volume:.2,
vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:102,vol:.13},{t:556,vol:.24}]},{type:"whitenoise",volume:.45,highpass:{frequency:7E3,Q:9},vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:89,vol:.51},{t:577,vol:.29}]},{type:"sine",fixedFrequency:5.7,volume:20,fmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:89,vol:1},{t:137,vol:.46},{t:283,vol:.15},{t:600,vol:.28}]}]},sawsynth:{masterVolume:.3,midiInstrument:51,noteGlideDuration:40,masterAttackEnvelope:[{t:0,vol:.6},{t:9,vol:1},{t:102,vol:.48}],eq:[{frequency:200,
gain:-6}],oscillators:[{type:"sawtooth",volume:.4,volumePitchTrackingMultiplier:.3},{type:"sawtooth",volume:.4,detune:11,volumePitchTrackingMultiplier:.3},{type:"sawtooth",volume:.4,detune:-11,volumePitchTrackingMultiplier:.3}]},basic1:{masterVolume:1,noteGlideDuration:0,masterReleaseEnvelope:[{t:1,vol:.36},{t:24,vol:.15},{t:119,vol:0}],eq:[{frequency:150,Q:.6,gain:-12},{frequency:1100,gain:-2},{frequency:2200,gain:-16},{frequency:5E3,gain:8},{frequency:6400,gain:10},{frequency:8E3,gain:12},{frequency:10800,
gain:8}],oscillators:[{type:"triangle",volume:1,volumePitchTrackingMultiplier:.05,lowpass:{frequency:17,frequencyPitchTrackingMultiplier:100},highpass:{frequency:200}},{type:"whitenoise",volume:.04,lowpass:{frequency:9E3,Q:3},highpass:{frequency:6E3,Q:3},vmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:26,vol:1},{t:71,vol:.73}]}]},basic2:{masterVolume:.3,eq:[{frequency:200,Q:.7,gain:6},{frequency:450,gain:2},{frequency:1300,gain:-2},{frequency:2600,Q:.8,gain:6},{frequency:3500,Q:.8,gain:6},{frequency:6200,
Q:.8,gain:10},{frequency:8E3,gain:-18},{frequency:1E4,Q:.4,gain:-12}],oscillators:[{type:"pulse",volume:.4,pulseWidth:.55,volumePitchTrackingMultiplier:.1,lowpass:{frequency:4.5,frequencyPitchTrackingMultiplier:900,Q:-2},highpass:{frequency:270}}]},chord:{masterVolume:1,masterAttackEnvelope:[{t:1,vol:.79},{t:27,vol:.86},{t:62,vol:.81},{t:150,vol:.35},{t:408,vol:.04},{t:600,vol:0}],eq:[{frequency:200,gain:-8},{frequency:600,Q:2,gain:4},{frequency:800,gain:-10},{frequency:1600,gain:-2},{frequency:2200,
gain:-6},{frequency:3600,Q:.7,gain:-2},{frequency:6400,gain:6},{frequency:12800,gain:6}],oscillators:[{type:"triangle",volume:1.1,volumePitchTrackingMultiplier:.05,lowpass:{frequency:8E3},highpass:{frequency:100},releaseEnvelope:[{t:1,vol:1},{t:315,vol:.56},{t:540,vol:0}]},{type:"triangle",freqMultiplier:1.17,volume:.4,volumePitchTrackingMultiplier:.07,lowpass:{frequency:5E3},highpass:{frequency:100},releaseEnvelope:[{t:0,vol:1},{t:476,vol:0}]},{type:"triangle",freqMultiplier:1.58333,volume:.7,volumePitchTrackingMultiplier:.02,
highpass:{frequency:200},releaseEnvelope:[{t:0,vol:1},{t:422,vol:.56},{t:577,vol:0}]},{type:"sine",fixedFrequency:10,volume:4,fmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:157,vol:.65}]},{type:"sine",fixedFrequency:5,volume:.3,vmOscillator:2,attackEnvelope:[{t:1,vol:1},{t:155,vol:.91},{t:289,vol:.78}]}]},wobble:{masterVolume:.9,masterReleaseEnvelope:[{t:1,vol:.36},{t:24,vol:.15},{t:119,vol:0}],eq:[{frequency:150,Q:.6,gain:-12},{frequency:1100,gain:-2},{frequency:2200,gain:-16},{frequency:5E3,gain:8},
{frequency:6400,gain:10},{frequency:8E3,gain:12},{frequency:10800,gain:8}],oscillators:[{type:"triangle",volume:.9,volumePitchTrackingMultiplier:.1,lowpass:{frequency:17,frequencyPitchTrackingMultiplier:100},highpass:{frequency:200}},{type:"whitenoise",volume:.04,lowpass:{frequency:9E3,Q:3},highpass:{frequency:6E3,Q:3},vmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:26,vol:1},{t:71,vol:.73}]},{type:"sine",freqMultiplier:.011,volume:30,fmOscillator:0}]},sine:{masterVolume:1,oscillators:[{type:"sine",
volumePitchTrackingMultiplier:.07}]},sineGlide:{masterVolume:1,noteGlideDuration:100,oscillators:[{type:"sine",volumePitchTrackingMultiplier:.07}]},triangle:{masterVolume:.5,oscillators:[{type:"triangle",volume:1,volumePitchTrackingMultiplier:.07}]},sawtooth:{masterVolume:.25,midiInstrument:82,oscillators:[{type:"sawtooth",volume:.3,volumePitchTrackingMultiplier:.07}]},square:{masterVolume:.3,midiInstrument:81,oscillators:[{type:"square",volume:.2,volumePitchTrackingMultiplier:.07}]},chop:{masterVolume:1,
midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:44,vol:0}],oscillators:[{type:"whitenoise",volume:1,lowpass:{frequency:600},highpass:{frequency:200}}]},shaker:{masterVolume:.4,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:44,vol:0}],oscillators:[{type:"whitenoise",volume:1,lowpass:{frequency:6500},highpass:{frequency:5E3}}]},step:{masterVolume:1,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:44,vol:0}],eq:[{frequency:200,gain:-1},{frequency:400,gain:-14},{frequency:800,
gain:8},{frequency:1E3,Q:5,gain:-24},{frequency:1600,gain:8},{frequency:2200,gain:-10},{frequency:5400,gain:4},{frequency:12800,gain:-36}],oscillators:[{type:"whitenoise",volume:1.5,lowpass:{frequency:300},highpass:{frequency:100,Q:6}}]},kick:{masterVolume:.55,masterAttackEnvelope:[{t:1,vol:.8},{t:15,vol:1},{t:45,vol:.35},{t:121,vol:.11},{t:242,vol:0}],eq:[{frequency:50,gain:6},{frequency:400,gain:-18},{frequency:1600,gain:18}],oscillators:[{type:"triangle",fixedFrequency:90,volume:1,lowpass:{frequency:300},
attackEnvelope:[{t:1,vol:1},{t:6,vol:1},{t:45,vol:.01}]},{type:"whitenoise",volume:.4,lowpass:{frequency:200},attackEnvelope:[{t:1,vol:1},{t:30,vol:0}]},{type:"triangle",freqMultiplier:.1,volume:1,lowpass:{frequency:200}}]},shortnote:{masterVolume:.8,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:15,vol:0}],eq:[{frequency:400,gain:-4},{frequency:800,gain:-12},{frequency:2400,gain:4},{frequency:7200,gain:-20},{frequency:1E3,Q:5,gain:-12},{frequency:5400,gain:-32},{frequency:12800,gain:-14}],
oscillators:[{type:"sawtooth",volume:.6,lowpass:{frequency:1E3}},{type:"whitenoise",volume:.2,lowpass:{frequency:1E4},highpass:{frequency:7E3},attackEnvelope:[{t:1,vol:1},{t:10,vol:0}]},{type:"whitenoise",volume:1.3,lowpass:{frequency:700,Q:4},highpass:{frequency:250}}]},noise:{masterVolume:.3,midiInstrument:122,oscillators:[{type:"whitenoise"}]},filteredNoise:{masterVolume:.3,midiInstrument:122,eq:[{frequency:1600,gain:-8},{frequency:2200,gain:-4}],oscillators:[{type:"whitenoise",lowpass:{frequency:5,
frequencyPitchTrackingMultiplier:1300,Q:6},highpass:{frequency:5,frequencyPitchTrackingMultiplier:300,Q:6}}]},wind:{masterVolume:.75,midiInstrument:122,noteGlideDuration:150,masterReleaseEnvelope:[{t:0,vol:1},{t:124,vol:.24},{t:281,vol:0}],oscillators:[{type:"whitenoise",volume:1,lowpass:{frequency:100,frequencyPitchTrackingMultiplier:6,Q:23},highpass:{frequency:170,frequencyPitchTrackingMultiplier:6}},{type:"sine",freqMultiplier:.016,volume:1E3,fmOscillator:0}]}}});v(b,"Extensions/Sonification/SonificationInstrument.js",
[b["Extensions/Sonification/SynthPatch.js"],b["Extensions/Sonification/InstrumentPresets.js"],b["Core/Utilities.js"]],function(b,r,h){const {defined:l,extend:y}=h;class n{constructor(d,A,g){this.audioContext=d;this.curParams={};this.midiTrackName=g.midiTrackName;this.masterVolNode=new GainNode(d);this.masterVolNode.connect(A);this.volumeNode=new GainNode(d);this.createNodesFromCapabilities(y({pan:!0},g.capabilities||{}));this.connectCapabilityNodes(this.volumeNode,this.masterVolNode);this.synthPatch=
new b(d,"string"===typeof g.synthPatch?r[g.synthPatch]:g.synthPatch);this.midiInstrument=this.synthPatch.midiInstrument||1;this.synthPatch.startSilently();this.synthPatch.connect(this.volumeNode)}setMasterVolume(d){this.masterVolNode.gain.setTargetAtTime(d,0,n.rampTime)}scheduleEventAtTime(d,b){const g=y(this.curParams,b);b=l(b.frequency)?b.frequency:l(b.note)?n.musicalNoteToFrequency(b.note):220;l(b)&&this.synthPatch.playFreqAtTime(d,b,g.noteDuration);(l(g.tremoloDepth)||l(g.tremoloSpeed))&&this.setTremoloAtTime(d,
g.tremoloDepth,g.tremoloSpeed);l(g.pan)&&this.setPanAtTime(d,g.pan);l(g.volume)&&this.setVolumeAtTime(d,g.volume);(l(g.lowpassFreq)||l(g.lowpassResonance))&&this.setFilterAtTime("lowpass",d,g.lowpassFreq,g.lowpassResonance);(l(g.highpassFreq)||l(g.highpassResonance))&&this.setFilterAtTime("highpass",d,g.highpassFreq,g.highpassResonance)}silenceAtTime(d){this.synthPatch.silenceAtTime(d)}cancel(){this.synthPatch.mute();[this.tremoloDepth&&this.tremoloDepth.gain,this.tremoloOsc&&this.tremoloOsc.frequency,
this.lowpassNode&&this.lowpassNode.frequency,this.lowpassNode&&this.lowpassNode.Q,this.highpassNode&&this.highpassNode.frequency,this.highpassNode&&this.highpassNode.Q,this.panNode&&this.panNode.pan,this.volumeNode.gain].forEach(d=>d&&d.cancelScheduledValues(0))}destroy(){this.cancel();this.synthPatch.stop();this.tremoloOsc&&this.tremoloOsc.stop();[this.tremoloDepth,this.tremoloOsc,this.lowpassNode,this.highpassNode,this.panNode,this.volumeNode,this.masterVolNode].forEach(d=>d&&d.disconnect())}setPanAtTime(d,
b){this.panNode&&this.panNode.pan.setTargetAtTime(b,d+this.audioContext.currentTime,n.rampTime)}setFilterAtTime(d,b,g,t){d=this[d+"Node"];b=this.audioContext.currentTime+b;d&&(l(t)&&d.Q.setTargetAtTime(t,b,n.rampTime),l(g)&&d.frequency.setTargetAtTime(g,b,n.rampTime))}setVolumeAtTime(d,b){this.volumeNode&&this.volumeNode.gain.setTargetAtTime(b,d+this.audioContext.currentTime,n.rampTime)}setTremoloAtTime(d,b,g){d=this.audioContext.currentTime+d;this.tremoloDepth&&l(b)&&this.tremoloDepth.gain.setTargetAtTime(b,
d,n.rampTime);this.tremoloOsc&&l(g)&&this.tremoloOsc.frequency.setTargetAtTime(15*g,d,n.rampTime)}createNodesFromCapabilities(d){const b=this.audioContext;d.pan&&(this.panNode=new StereoPannerNode(b));d.tremolo&&(this.tremoloOsc=new OscillatorNode(b,{type:"sine",frequency:3}),this.tremoloDepth=new GainNode(b),this.tremoloOsc.connect(this.tremoloDepth),this.tremoloDepth.connect(this.masterVolNode.gain),this.tremoloOsc.start());d.filters&&(this.lowpassNode=new BiquadFilterNode(b,{type:"lowpass",frequency:2E4}),
this.highpassNode=new BiquadFilterNode(b,{type:"highpass",frequency:0}))}connectCapabilityNodes(d,b){[this.panNode,this.lowpassNode,this.highpassNode,d].reduce((d,b)=>b?(b.connect(d),b):d,b)}static noteStringToC0Distance(d){var b=d.match(/^([a-g][#b]?)([0-8])$/i),g=b?b[1]:"a";d=g[0].toLowerCase();g=g[1];b=b?parseInt(b[2],10):4;return({c:0,d:2,e:4,f:5,g:7,a:9,b:11}[d]||0)+("#"===g?1:"b"===g?-1:0)+12*b}static musicalNoteToFrequency(b){b="string"===typeof b?this.noteStringToC0Distance(b):b;return 16.3516*
Math.pow(2,Math.min(b,107)/12)}}n.rampTime=b.stopRampTime/4;"";return n});v(b,"Extensions/Sonification/SonificationSpeaker.js",[b["Core/Utilities.js"]],function(b){const {pick:r}=b;class h{constructor(b){this.options=b;this.masterVolume=1;this.synthesis=window.speechSynthesis;"undefined"!==typeof speechSynthesis.onvoiceschanged&&(speechSynthesis.onvoiceschanged=this.setVoice.bind(this));this.setVoice();this.scheduled=[]}say(b,h){this.synthesis&&(this.synthesis.cancel(),b=new SpeechSynthesisUtterance(b),
this.voice&&(b.voice=this.voice),b.rate=h&&h.rate||this.options.rate||1,b.pitch=h&&h.pitch||this.options.pitch||1,b.volume=r(h&&h.volume,this.options.volume,1)*this.masterVolume,this.synthesis.speak(b))}sayAtTime(b,h,n){this.scheduled.push(setTimeout(this.say.bind(this,h,n),b))}cancel(){this.scheduled.forEach(clearTimeout);this.scheduled=[];this.synthesis.cancel()}destroy(){this.cancel()}setMasterVolume(b){this.masterVolume=b}setVoice(){if(this.synthesis){const b=this.options.name,h=this.options.language||
"en-US",n=this.synthesis.getVoices(),d=n.length;let r;for(let g=0;g<d;++g){if(b&&n[g].name===b){this.voice=n[g];return}if(!r&&n[g].lang===h&&(r=n[g],!b))break}this.voice=r}}}"";return h});v(b,"Extensions/Sonification/TimelineChannel.js",[],function(){class b{constructor(b,h,l=!1,y,n){this.type=b;this.engine=h;this.showPlayMarker=l;this.muted=n;this.events=y||[]}addEvent(b){var h=this.events[this.events.length-1];if(h&&b.time<h.time){for(h=this.events.length;h--&&this.events[h].time>b.time;);this.events.splice(h+
1,0,b)}else this.events.push(b);return b}mute(){this.muted=!0}unmute(){this.muted=!1}cancel(){this.engine.cancel()}destroy(){this.engine.destroy()}}"";return b});v(b,"Extensions/Sonification/MIDI.js",[b["Extensions/Sonification/SonificationInstrument.js"],b["Core/Utilities.js"]],function(b,r){const {pick:h}=r,l=b=>[77,84,104,100,0,0,0,6,0,1<b?1:0,b>>>8&255,b>>>0&255,1,244],y=[0,255,81,3,7,161,32],n=b=>{let a=b&127;const c=[];for(;b>>=7;)a<<=8,a|=b&127|128;for(;;)if(c.push(a&255),a&128)a>>=8;else break;
return c},d=d=>{let a,c;const e=[],f=a=>{let c=e.length;for(;c--&&e[c].timeMS>a.timeMS;);e.splice(c+1,0,a)};d.forEach(e=>{var d=e.instrumentEventOptions||{};const g=e.time;var w=c=h(d.noteDuration,c);e=w&&e.time+w;w=[{valMap:a=>64+63*a&127,data:{10:d.pan,92:d.tremoloDepth,93:d.tremoloSpeed}},{valMap:a=>127*a/2E4&127,data:{74:d.lowpassFreq,75:d.highpassFreq}},{valMap:a=>63*Math.min(18,Math.max(-18,a))/18+63&127,data:{71:d.lowpassResonance,76:d.highpassResonance}}];const t=a=void 0===d.volume?h(a,127):
127*d.volume&127,k=d.frequency;d=d.note||0;d=12+(k?Math.round(12*Math.log(k)/Math.LN2-48.37632):"string"===typeof d?b.noteStringToC0Distance(d):d)&127;w.forEach(a=>Object.keys(a.data).forEach(c=>{const b=a.data[c];void 0!==b&&f({timeMS:g,type:"CTRL_CHG",data:[176,parseInt(c,10),a.valMap(b)]})}));e&&(f({timeMS:g,type:"NON",data:[144,d,t]}),f({timeMS:e,type:"NOF",data:[128,d,t]}))});return e},A=(b,a)=>{const c=[];a&&c.push(0,192,a&127);if(b){a=[];for(let c=0;c<b.length;++c){const d=b.charCodeAt(c);
128>d&&a.push(d)}return c.concat([0,255,3],n(a.length),a)}return c},g=(b,a,c,e)=>{let f=0;c=A(c,e);b=d(b).reduce((a,c)=>{const b=n(c.timeMS-f);f=c.timeMS;return a.concat(b,c.data)},[]);e=[0,255,47,0];const g=(a?y.length:0)+c.length+b.length+e.length;return[77,84,114,107,g>>>24&255,g>>>16&255,g>>>8&255,g>>>0&255].concat(a?y:[],c,b,e)};return function(b){b=b.filter(a=>!!a.events.length);const a=b.length,c=1<a;return new Uint8Array(l(c?a+1:a).concat(c?g([],!0):[],b.reduce((a,b)=>{const d=b.engine;return a.concat(g(b.events,
!c,d.midiTrackName,d.midiInstrument))},[])))}});v(b,"Extensions/DownloadURL.js",[b["Core/Globals.js"]],function(b){const {isSafari:r}=b,h=b.win,l=h.document,y=h.URL||h.webkitURL||h,n=b.dataURLtoBlob=function(b){if((b=b.replace(/filename=.*;/,"").match(/data:([^;]*)(;base64)?,([0-9A-Za-z+/]+)/))&&3<b.length&&h.atob&&h.ArrayBuffer&&h.Uint8Array&&h.Blob&&y.createObjectURL){const g=h.atob(b[3]);var d=new h.ArrayBuffer(g.length);d=new h.Uint8Array(d);for(let b=0;b<d.length;++b)d[b]=g.charCodeAt(b);b=new h.Blob([d],
{type:b[1]});return y.createObjectURL(b)}};b=b.downloadURL=function(b,y){var d=h.navigator;const t=l.createElement("a");if("string"===typeof b||b instanceof String||!d.msSaveOrOpenBlob){b=`${b}`;d=/Edge\/\d+/.test(d.userAgent);if(r&&"string"===typeof b&&0===b.indexOf("data:application/pdf")||d||2E6<b.length)if(b=n(b)||"",!b)throw Error("Failed to convert to blob");if("undefined"!==typeof t.download)t.href=b,t.download=y,l.body.appendChild(t),t.click(),l.body.removeChild(t);else try{const a=h.open(b,
"chart");if("undefined"===typeof a||null===a)throw Error("Failed to open window");}catch(a){h.location.href=b}}else d.msSaveOrOpenBlob(b,y)};return{dataURLtoBlob:n,downloadURL:b}});v(b,"Extensions/Sonification/SonificationTimeline.js",[b["Extensions/Sonification/TimelineChannel.js"],b["Extensions/Sonification/MIDI.js"],b["Extensions/DownloadURL.js"],b["Core/Utilities.js"]],function(b,r,h,l){function y(a,c){c=c.map(b=>{b.cancel();return{channel:b,filteredEvents:b.muted?[]:b.events.filter(a)}});const d=
c.reduce((a,b)=>Math.min(a,b.filteredEvents.length?b.filteredEvents[0].time:Infinity),Infinity);return c.map(a=>new b(a.channel.type,a.channel.engine,a.channel.showPlayMarker,a.filteredEvents.map(a=>g(a,{time:a.time-d})),a.channel.muted))}const {downloadURL:n}=h,{defined:d,find:v,merge:g}=l;class t{constructor(a,b){this.chart=b;this.isPlaying=this.isPaused=!1;this.channels=[];this.scheduledCallbacks=[];this.resumeFromTime=this.playTimestamp=0;this.options=a||{}}addChannel(a,c,d=!1,f){if("instrument"===
a&&!c.scheduleEventAtTime||"speech"===a&&!c.sayAtTime)throw Error("Highcharts Sonification: Invalid channel engine.");a=new b(a,c,d,f);this.channels.push(a);return a}play(a,b=!0,d=!0,f){this.isPlaying?this.cancel():this.clearScheduledCallbacks();this.playTimestamp=Date.now();this.resumeFromTime=0;this.isPaused=!1;this.isPlaying=!0;const c=this.options.skipThreshold||2,e=this.options.onPlay,g=this.options.showTooltip,h=this.options.showCrosshair;a=a?y(a,this.playingChannels||this.channels):this.channels;
const n=a=>Object.keys(a.speechOptions||{}).concat(Object.keys(a.instrumentEventOptions||{})).join(),k=[];b&&(this.playingChannels=a);e&&e({chart:this.chart,timeline:this});let q=0;a.forEach(a=>{if(!a.muted){var b=a.events.length,d=-Infinity,e=-Infinity,f="";q=Math.max(a.events[b-1]&&a.events[b-1].time||0,q);for(let m=0;m<b;++m){const p=a.events[m];var u=n(p);if(u===f&&p.time-e<c)continue;f=u;e=p.time;"instrument"===a.type?a.engine.scheduleEventAtTime(p.time/1E3,p.instrumentEventOptions||{}):a.engine.sayAtTime(p.time,
p.message||"",p.speechOptions||{});const x=p.relatedPoint,z=x&&x.series&&x.series.chart;u=p.callback||x&&(g||h)&&!1!==a.showPlayMarker&&(50<p.time-d||m===b-1);x&&k.push(x);u&&(this.scheduledCallbacks.push(setTimeout(()=>{p.callback&&p.callback();if(x){if(h){const a=x.series;a&&a.xAxis&&a.xAxis.crosshair&&a.xAxis.drawCrosshair(void 0,x);a&&a.yAxis&&a.yAxis.crosshair&&a.yAxis.drawCrosshair(void 0,x)}if(g&&!(z&&z.hoverPoints&&1<z.hoverPoints.length&&v(z.hoverPoints,a=>a===x)&&x.onMouseOver))x.onMouseOver()}},
p.time)),d=p.time)}}});const E=this.options.onEnd,l=this.options.onStop;this.scheduledCallbacks.push(setTimeout(()=>{const a=this.chart,b={chart:a,timeline:this,pointsPlayed:k};this.isPlaying=!1;d&&this.resetPlayState();l&&l(b);E&&E(b);f&&f(b);if(a){a.tooltip&&a.tooltip.hide(0);if(a.hoverSeries)a.hoverSeries.onMouseOut();a.axes.forEach(a=>a.hideCrosshair())}},q+250));this.resumeFromTime=b?q:this.getLength()}pause(){this.isPaused=!0;this.cancel();return this.resumeFromTime=Date.now()-this.playTimestamp-
10}getCurrentTime(){return this.isPlaying?Date.now()-this.playTimestamp:this.resumeFromTime}getLength(){return this.channels.reduce((a,b)=>(b=b.events[b.events.length-1])?Math.max(b.time,a):a,0)}resume(){if(this.playingChannels){const a=this.resumeFromTime-50;this.play(b=>b.time>a,!1,!1);this.playTimestamp-=a}else this.play(void 0,!1,!1)}anchorPlayMoment(a,b){this.isPlaying&&this.pause();let c=0;this.play((b,d,e)=>{(d=a(b,d,e))&&b.time>c&&(c=b.time);return d},!1,!1,b);this.playingChannels=this.playingChannels||
this.channels;this.isPaused=!0;this.isPlaying=!1;this.resumeFromTime=c}playAdjacent(a,b,d,f){this.isPlaying&&this.pause();const c=this.resumeFromTime,e=this.channels.reduce((b,d)=>{d=f?d.events.filter(f):d.events;let e=0,k=d.length;for(;e<k;){const f=e+k>>1,g=d[f].time,h=g-c;0<h?(a&&g<b&&(b=g),k=f):0>h?(!a&&g>b&&(b=g),e=f+1):a?e=f+1:k=f}return b},a?Infinity:-Infinity);Infinity===e||-Infinity===e?d&&d({chart:this.chart,timeline:this,attemptedNext:a}):this.anchorPlayMoment((b,d,g)=>{const k=a?b.time>
c&&b.time<=e+.02:b.time<c&&b.time>=e-.02;return f?k&&f(b,d,g):k},b)}playClosestToPropValue(a,b,e,f,g){let c=Infinity,h=null;(this.playingChannels||this.channels).forEach(e=>{e=e.events;let f=e.length;for(;f--;){var k=e[f];if(g?g(k,f,e)&&k.relatedPoint:k.relatedPoint)k=e[f].relatedPoint[a],k=d(k)&&Math.abs(b-k),!1!==k&&k<c&&(c=k,h=e[f])}});h?(this.play(a=>!!(h&&a.time<h.time+1&&a.time>h.time-1&&a.relatedPoint===h.relatedPoint),!1,!1,e),this.playingChannels=this.playingChannels||this.channels,this.isPaused=
!0,this.isPlaying=!1,this.resumeFromTime=h.time):f&&f({chart:this.chart,timeline:this})}getEventsForPoint(a){return this.channels.reduce((b,d)=>{d=d.events.filter(b=>b.relatedPoint===a);return b.concat(d)},[])}playSegment(a,b){var c=Infinity,d=-Infinity;this.channels.forEach(a=>{a.events.length&&(c=Math.min(a.events[0].time,c),d=Math.max(a.events[a.events.length-1].time,d))});if(Infinity>c){const e=(d-c)/100,f=c+a*e,g=f+e;this.channels.some(a=>{a=a.events;let b=0,c=a.length;for(;b<c;){const d=b+c>>
1,e=a[d].time;if(e<f)b=d+1;else if(e>g)c=d;else return!0}return!1})&&(this.play(a=>a.time>=f&&a.time<=g,!1,!1,b),this.playingChannels=this.playingChannels||this.channels,this.isPaused=!0,this.isPlaying=!1,this.resumeFromTime=g)}}getLastPlayedPoint(a){const b=this.getCurrentTime();let d=Infinity,f=null;(this.playingChannels||this.channels).forEach(c=>{c=c.events.filter((c,d,e)=>!(!(c.relatedPoint&&c.time<=b)||a&&!a(c,d,e)));if(c=c[c.length-1]){const a=Math.abs(c.time-b);a<d&&(d=a,f=c.relatedPoint)}});
return f}reset(){this.isPlaying&&this.cancel();this.resetPlayState()}cancel(){const a=this.options.onStop;a&&a({chart:this.chart,timeline:this});this.isPlaying=!1;this.channels.forEach(a=>a.cancel());this.playingChannels&&this.playingChannels!==this.channels&&this.playingChannels.forEach(a=>a.cancel());this.clearScheduledCallbacks();this.resumeFromTime=0}destroy(){this.cancel();this.playingChannels&&this.playingChannels!==this.channels&&this.playingChannels.forEach(a=>a.destroy());this.channels.forEach(a=>
a.destroy())}setMasterVolume(a){this.channels.forEach(b=>b.engine.setMasterVolume(a))}getMIDIData(){return r(this.channels.filter(a=>"instrument"===a.type))}downloadMIDI(a){var b=this.getMIDIData();a=(a||this.chart&&this.chart.options.title&&this.chart.options.title.text||"chart")+".mid";b=new Blob([b],{type:"application/octet-stream"});b=window.URL.createObjectURL(b);n(b,a);window.URL.revokeObjectURL(b)}resetPlayState(){delete this.playingChannels;this.playTimestamp=this.resumeFromTime=0;this.isPaused=
!1}clearScheduledCallbacks(){this.scheduledCallbacks.forEach(clearTimeout);this.scheduledCallbacks=[]}}"";return t});v(b,"Extensions/Sonification/TimelineFromChart.js",[b["Extensions/Sonification/SonificationTimeline.js"],b["Extensions/Sonification/SonificationInstrument.js"],b["Extensions/Sonification/SonificationSpeaker.js"],b["Core/Utilities.js"],b["Core/FormatUtilities.js"]],function(b,r,h,l,y){function n(a,b){let c;if(b){c=a[b];if("number"===typeof c)return c;c=G(b,a)}return"number"===typeof c?
c:void 0}function d(a,b,c){a=a.series;const d=b.length,e=c.length,u=a=>a.reduce((a,b)=>{a[b]={min:Infinity,max:-Infinity};a;return a},{}),m=(a,b,c)=>{let d=b[c];void 0===d&&(d=G(c,b));"number"===typeof d&&(a[c].min=Math.min(a[c].min,d),a[c].max=Math.max(a[c].max,d))},f=u(b);let g=a.length;const k=Array(g);for(;g--;){const p=u(c);var h=a[g].options;if(!a[g].visible||h&&h.sonification&&!1===h.sonification.enabled)continue;h=a[g].points||[];let x=h.length;for(;x--;){let a=d;for(;a--;)m(f,h[x],b[a]);
for(a=e;a--;)m(p,h[x],c[a])}k[g]=p}return{globalExtremes:f,seriesExtremes:k}}function v(a){const b=a.options.sonification||{},c=b.defaultSpeechOptions&&b.defaultSpeechOptions.mapping||{},e=[],p={},g=(a,b)=>{null!==b?(e[b]=e[b]||{},e[b][a]=!0):p[a]=!0},m={},f={},k=(a,b,c)=>{var d=a=>"-"===a.charAt(0)?a.slice(1):a;if("string"===typeof b&&"text"!==a)"pitch"===a&&/^([a-g][#b]?)[0-8]$/i.test(b)||("time"===a&&(f[b]=!0,g(b,c)),m[d(b)]=!0);else if(b&&b.mapTo&&"string"===typeof b.mapTo){d=d(b.mapTo);"time"===
a&&g(d,c);if("time"===a||"series"===b.within)f[d]=!0;m[d]=!0}else-1<["tremolo","lowpass","highpass"].indexOf(a)&&"object"===typeof b&&Object.keys(b).forEach(a=>k(a,b[a],c))},h=(a,b)=>{Object.keys(a).forEach(c=>k(c,a[c],b))},q=a=>a.forEach(a=>{m[a.valueProp||"x"]=f[a.valueProp||"x"]=!0});h((b.defaultInstrumentOptions||{}).mapping||{time:"x",pitch:"y"},null);h(c,null);q(b.globalContextTracks||[]);const n=Object.keys(p).length;a.series.forEach(a=>{const b=a.options.sonification;if(a.visible&&(!b||!1!==
b.enabled)&&(n&&(e[a.index]=D(p)),b)){const c=(b.defaultInstrumentOptions||{}).mapping,d=(b.defaultSpeechOptions||{}).mapping;c&&h(c,a.index);d&&h(d,a.index);q(b.contextTracks||[]);(b.tracks||[]).concat(b.contextTracks||[]).forEach(b=>{b.mapping&&h(b.mapping,a.index)})}});return Object.assign({seriesTimeProps:e},d(a,Object.keys(m),Object.keys(f)))}function g(a,b,c,d,e){var f=b.max-b.min;if(0>=f)return c.min;const g=c.max-c.min;f=g*(a-b.min)/f;e&&(e=0<b.min?a=>Math.log(a)/Math.LOG10E:a=>{var b=Math.abs(a);
10>b&&(b+=(10-b)/10);b=Math.log(b)/Math.LN10;return 0>a?-b:b},f=e(b.min),f=g*(e(a)-f)/(e(b.max)-f));return k(d?c.max-f:c.min+f,c.min,c.max)}function t(a,b,c,d,e,f){if("number"===typeof e)return e;if("function"===typeof e)return e(E({time:0},a));var k=e,h=d.mapFunction;let u=d.min,m=d.max;var p=d.within;let x;"object"===typeof e&&(k=e.mapTo,h=e.mapFunction||h,u=C(e.min,u),m=C(e.max,m),p=e.within||d.within,x=e.scale);if(!k)return null;(d="-"===k.charAt(0))&&(k=k.slice(1));var z=a.value;const H="value"===
k&&void 0!==z&&f;if(!H){z=e.value;if(void 0===z){if(!a.point)return null;z=a.point[k]}void 0===z&&(z=G(k,a.point))}if("number"!==typeof z||null===z)return null;e=null;a.point&&("xAxis"===p||"yAxis"===p?(a=a.point.series[p])&&q(a.dataMin)&&q(a.dataMax)&&(e={min:a.dataMin,max:a.dataMax}):("series"===p||c)&&a.point.series&&(e=b.seriesExtremes[a.point.series.index][H?f:k]));e||(e=b.globalExtremes[H?f:k]);if(x){b=[];a=Math.floor(u/12);f=Math.ceil(m/12)+1;for(k=x.length;a<f;++a)for(c=0;c<k;++c)p=12*a+x[c],
p>=u&&p<=m&&b.push(p);h=g(z,e,{min:0,max:b.length-1},d,"logarithmic"===h);return b[Math.round(h)]}return g(z,e,{min:u,max:m},d,"logarithmic"===h)}function a(a,b,c,d,e,f,k){return C(t(a,b,c,E({min:0,max:1,mapTo:"y",mapFunction:"linear",within:"chart"},f||{}),d,k),e)}function c(a,b,c,d){let e;b-=(a.chart.series.length-1)*d;c.seriesTimeProps.every(a=>{a=Object.keys(a);if(1<a.length)return!1;e||(e=a[0]);return e===a[0]})?(a=c.seriesExtremes[a.index][e],a=a.max-a.min,c=c.seriesExtremes.reduce((a,b)=>b[e]?
a+b[e].max-b[e].min:a,0),c=Math.round(a/c*b)):(c=a.chart.series.reduce((a,b)=>a+b.points.length,0),c=Math.round((a.points||[]).length/c*b));return Math.max(50,c)}function e(a,b,c,d){const e=d.mapping||{};b="speech"===d.type?new h({language:d.language,name:d.preferredVoice}):new r(b,c,{capabilities:{pan:!!e.pan,tremolo:!!e.tremolo,filters:!(!e.highpass&&!e.lowpass)},synthPatch:d.instrument,midiTrackName:d.midiName});return a.addChannel(d.type||"instrument",b,C(d.showPlayMarker,!0))}function f(b,c,
d,e,f,k){var g=(c,f,g,h)=>a(b,e,!1,(h||d)[c],f,g,k);const h=[],m={noteDuration:g("noteDuration",200,{min:40,max:1E3}),pan:g("pan",0,{min:-1,max:1}),volume:g("volume",1,{min:.1,max:1})};d.frequency&&(m.frequency=g("frequency",440,{min:50,max:6E3}));d.lowpass&&(m.lowpassFreq=g("frequency",2E4,{min:0,max:2E4},d.lowpass),m.lowpassResonance=g("resonance",0,{min:-6,max:12},d.lowpass));d.highpass&&(m.highpassFreq=g("frequency",2E4,{min:0,max:2E4},d.highpass),m.highpassResonance=g("resonance",0,{min:-6,max:12},
d.highpass));d.tremolo&&(m.tremoloDepth=g("depth",0,{min:0,max:.8},d.tremolo),m.tremoloSpeed=g("speed",0,{min:0,max:.8},d.tremolo));const p=g("gapBetweenNotes",150,{min:50,max:1E3}),u=g("playDelay",0,{max:200});g=(d,g=0)=>{let q=d;d.mapTo?("string"===typeof d.min&&(q.min=r.noteStringToC0Distance(d.min)),"string"===typeof d.max&&(q.max=r.noteStringToC0Distance(d.max))):"string"===typeof d&&/^([a-g][#b]?)[0-8]$/i.test(d)&&(q=r.noteStringToC0Distance(d));m.note=a(b,e,!1,q,-1,{min:0,max:107},k);-1<m.note&&
(f&&(m.note=Math.round(m.note)),h.push(c.addEvent({time:b.time+u+p*g,relatedPoint:b.point,instrumentEventOptions:void 0!==g?E({},m):m})))};d.pitch&&d.pitch.constructor===Array?d.pitch.forEach(g):d.pitch?g(d.pitch):d.frequency&&h.push(c.addEvent({time:b.time+u,relatedPoint:b.point,instrumentEventOptions:m}));return h}function w(a,b){return B("function"===typeof b?b(a):b,a,a.point&&a.point.series.chart)}function L(b,c,d,e,g){var f=(c,f,k)=>a(b,e,!1,d[c],f,k,g);const k=f("playDelay",0,{max:200}),h=f("pitch",
1,{min:.3,max:2}),m=f("rate",1,{min:.4,max:4});f=f("volume",1,{min:.1});const p=w(b,d.text);if(p)return c.addEvent({time:b.time+k,relatedPoint:b.point,speechOptions:{pitch:h,rate:m,volume:f},message:p})}function M(a,b,c,d){let e=[];"speech"===c.type&&c.mapping?(a=L(a,b,c.mapping,d))&&(e=[a]):c.mapping&&(e=f(a,b,c.mapping,d,C(c.roundToMusicalNotes,!0)));return e}function K(a,b){const c=a.algorithm||"minmax",d=a=>b[a]?[b[a].point]:[];if("first"===c)return d(0);if("last"===c)return d(b.length-1);if("middle"===
c)return d(b.length>>1);if("firstlast"===c)return d(0).concat(d(b.length-1));if("minmax"===c){const c=a.prop||"y";let d,e,f,g;b.forEach(a=>{const b=n(a.point,c);if(void 0!==b){if(!d||b<f)d=a,f=b;if(!e||b>g)e=a,g=b}});if(d&&e)return d.point===e.point?[d.point]:d.time>e.time?[e.point,d.point]:[d.point,e.point]}return[]}function F(a,b,c){if("function"===typeof b)return b(a);if("object"===typeof b){var d=b.prop;a=C(a.value,a.point&&n(a.point,d));if("number"!==typeof a)return!1;d=b.crossingUp;const e=
b.crossingDown,f="number"===typeof c;c=d&&e?f&&(c<d&&a>=d||c>e&&a<=e):(void 0===d||f&&c<d&&a>=d)&&(void 0===e||f&&c>e&&a<=e);d=C(b.max,Infinity);b=C(b.min,-Infinity);return a<=d&&a>=b&&c}return!0}const {clamp:k,defined:q,extend:E,getNestedProperty:G,merge:D,pick:C}=l,{format:B}=y;return function(d,k,h){const q=h.options.sonification||{},p=q.defaultInstrumentOptions,m=q.defaultSpeechOptions,l=D({enabled:!0,groupTimespan:15,algorithm:"minmax",prop:"y"},q.pointGrouping),r=q.globalTracks||[],t=q.globalContextTracks||
[],u="sequential"===q.order,y=Math.max(50,q.duration-300),G=q.afterSeriesWait,B=q.events||{},w=v(h),z=new b({onPlay:B.onPlay,onEnd:B.onEnd,onStop:B.onStop,showCrosshair:q.showCrosshair,showTooltip:q.showTooltip},h);h.sonification&&(h.sonification.propMetrics=w);let A=0;h.series.forEach((b,h)=>{var q=b.options.sonification||{};if(b.visible&&!1!==q.enabled){const v=u?c(b,y,w,G):y,H=D(p,q.defaultInstrumentOptions),N=D(m,q.defaultSpeechOptions),O=D(l,q.pointGrouping);var x=(q.tracks||[H]).concat(r);q=
z.channels.length&&!u?q.contextTracks||[]:(q.contextTracks||[]).concat(t);const I=[];let J;x.forEach(c=>{const f=D({pointGrouping:O,midiName:c.midiName||b.name},"speech"===c.type?N:H,c),g=f.pointGrouping,h=f.activeWhen,q=a=>{"object"===typeof h&&h.prop&&(J=n(a,h.prop))},p=e(z,d,k,f);let m=[],l=0;const r=a=>{if(1===m.length)I.push(...M({point:m[0].point,time:l+a/2},p,f,w));else{const b=K(g,m),c=a/b.length;b.forEach((a,b)=>I.push(...M({point:a,time:l+c/2+c*b},p,f,w)))}m=[]};(b.points||[]).forEach((c,
d)=>{d=d===b.points.length-1;var e=A;e=a({point:c,time:0},w,u,f.mapping&&f.mapping.time||0,0,{min:0,max:v,mapTo:"x"})+e;const k={point:c,time:e};if(f.mapping&&F(k,h,J))if(q(c),g.enabled){c=e-l;const a=g.groupTimespan,b=d&&c<=a?c:a;d||c>a?(c<=a&&m.push(k),r(b),l=Math.floor(e/a)*a,d&&c>a?I.push(...M({point:k.point,time:l+b/2},p,f,w)):m=[k]):m.push(k)}else I.push(...M(k,p,f,w));else q(c),d&&m.length&&r(m[m.length-1].time-m[0].time)})});x=I.reduce((a,b)=>b.time<a.time?b:a,{time:Infinity});const P=I.reduce((a,
b)=>b.time>a.time?b:a,{time:-Infinity});x.callback=B.onSeriesStart?B.onSeriesStart.bind(null,{series:b,timeline:z}):void 0;P.callback=B.onSeriesEnd?B.onSeriesEnd.bind(null,{series:b,timeline:z}):void 0;q.forEach(a=>{const b="speech"===a.type?D(m,a):D(p,{mapping:{pitch:{mapTo:"value"}}},a),c=e(z,d,k,b);J=void 0;const {timeInterval:q,valueInterval:l}=b,n=b.valueProp||"x",r=b.activeWhen;a=w.seriesExtremes[h][n];const t=(a,d)=>{b.mapping&&F({time:a,value:d},"object"===typeof r?E({prop:n},r):r,J)?(J=d,
"speech"===b.type?L({time:a,value:d},c,b.mapping,w,n):f({time:a,value:d},c,b.mapping,w,C(b.roundToMusicalNotes,!0),n)):J=d};if(q)for(var u=0;u<=v;){var B=g(u,{min:0,max:v},a);t(u+A,B);u+=q}if(l)for(u=a.min;u<=a.max;)B=g(u,a,{min:0,max:v},!1,"logarithmic"===b.valueMapFunction),t(B+A,u),u+=l});u&&(A+=v+G)}});return z}});v(b,"Extensions/Sonification/Sonification.js",[b["Core/Defaults.js"],b["Core/Utilities.js"],b["Core/Globals.js"],b["Extensions/Sonification/Options.js"],b["Extensions/Sonification/SonificationInstrument.js"],
b["Extensions/Sonification/SonificationSpeaker.js"],b["Extensions/Sonification/SynthPatch.js"],b["Extensions/Sonification/InstrumentPresets.js"],b["Extensions/Sonification/TimelineFromChart.js"]],function(b,r,h,l,y,n,d,v,g){const {defaultOptions:t,getOptions:a}=b,{addEvent:c,extend:e,fireEvent:f,merge:w,pick:A}=r,{doc:L,win:K}=h;class F{constructor(a){this.chart=a;this.lastUpdate=this.retryContextCounter=0;this.unbindKeydown=c(L,"keydown",function(b){a&&a.sonification&&("Esc"===b.key||"Escape"===
b.key)&&a.sonification.cancel()});try{this.audioContext=new K.AudioContext,this.audioContext.suspend(),this.audioDestination=this.audioContext.destination}catch(q){}}setAudioDestination(a){this.audioDestination=a;this.update()}isPlaying(){return!!this.timeline&&this.timeline.isPlaying}playSegment(a,b){this.ready(this.playSegment.bind(this,a,b))&&this.timeline&&this.timeline.playSegment(a,b)}playAdjacent(a,b,c){if(this.ready(this.playAdjacent.bind(this,a,b,c))&&this.timeline){var d=this.chart.options.sonification;
(d=d&&d.events&&d.events.onBoundaryHit)||this.initBoundaryInstrument();this.timeline.playAdjacent(a,b,d||(()=>{this.defaultBoundaryHit()}),c)}}playAdjacentSeries(a,b="x",c){const d=this.getLastPlayedPoint();if(d){const e=d.series.index+(a?1:-1);this.playClosestToProp(b,d[b],a=>!!a.relatedPoint&&a.relatedPoint.series.index===e,c);return this.chart.series[e]||null}return null}playClosestToProp(a,b,c,d){if(this.ready(this.playClosestToProp.bind(this,a,b,c,d))&&this.timeline){var e=this.chart.options.sonification;
(e=e&&e.events&&e.events.onBoundaryHit)||this.initBoundaryInstrument();this.timeline.playClosestToPropValue(a,b,d,e||(()=>this.defaultBoundaryHit()),c)}}getLastPlayedPoint(){return this.timeline?this.timeline.getLastPlayedPoint():null}playNote(a,b,c=0){if(this.ready(this.playNote.bind(this,a,b))){var d=b.noteDuration=b.noteDuration||500,e=new y(this.audioContext,this.audioDestination,{synthPatch:a,capabilities:{filters:!0,tremolo:!0,pan:!0}});e.scheduleEventAtTime(c/1E3,b);setTimeout(()=>e&&e.destroy(),
c+d+500)}}speak(a,b,c=0){(new n(w({language:"en-US",rate:1.5,volume:.4},b||{}))).sayAtTime(c,a)}cancel(){this.timeline&&this.timeline.cancel();f(this,"cancel")}downloadMIDI(){this.ready(this.downloadMIDI.bind(this))&&this.timeline&&(this.timeline.reset(),this.timeline.downloadMIDI())}sonifyChart(a,b){this.ready(this.sonifyChart.bind(this,a,b))&&this.timeline&&(this.timeline.reset(),this.beforePlay(),this.timeline.play(void 0,void 0,a,b))}sonifySeries(a,b,c){this.ready(this.sonifySeries.bind(this,
a,b,c))&&this.timeline&&(this.timeline.reset(),this.beforePlay(),this.timeline.play(b=>!!b.relatedPoint&&b.relatedPoint.series===a,void 0,b,c))}sonifyPoint(a,b){this.ready(this.sonifyPoint.bind(this,a,b))&&this.timeline&&(this.timeline.reset(),this.beforePlay(),this.timeline.anchorPlayMoment(b=>b.relatedPoint===a,b))}setMasterVolume(a){this.timeline&&this.timeline.setMasterVolume(a)}destroy(){this.unbindKeydown();this.timeline&&(this.timeline.destroy(),delete this.timeline);this.boundaryInstrument&&
this.boundaryInstrument.stop();this.audioContext&&(this.audioContext.close(),delete this.audioContext)}update(){var a=this.chart.options&&this.chart.options.sonification;if(this.ready(this.update.bind(this))&&a){var b=Date.now(),c=a.updateInterval;b-this.lastUpdate<c&&!this.forceReady?(clearTimeout(this.scheduledUpdate),this.scheduledUpdate=setTimeout(this.update.bind(this),c/2)):(a=a.events||{},a.beforeUpdate&&a.beforeUpdate({chart:this.chart,timeline:this.timeline}),this.lastUpdate=b,this.timeline&&
this.timeline.destroy(),this.audioContext&&this.audioDestination&&(this.timeline=g(this.audioContext,this.audioDestination,this.chart),b=this.chart.options.sonification,this.timeline.setMasterVolume(A(b&&b.masterVolume,1))),a.afterUpdate&&a.afterUpdate({chart:this.chart,timeline:this.timeline}))}}ready(a){if(!this.audioContext||!this.audioDestination||!this.chart.options||this.chart.options.sonification&&!1===this.chart.options.sonification.enabled)return!1;if("suspended"===this.audioContext.state&&
!this.forceReady)return 20>this.retryContextCounter++&&setTimeout(()=>{this.audioContext&&"suspended"===this.audioContext.state?this.audioContext.resume().then(a):a()},5),!1;this.retryContextCounter=0;return!0}beforePlay(){var a=this.chart.options.sonification;(a=a&&a.events&&a.events.beforePlay)&&a({chart:this.chart,timeline:this.timeline})}initBoundaryInstrument(){this.boundaryInstrument||(this.boundaryInstrument=new d(this.audioContext,w(v.chop,{masterVolume:.3})),this.boundaryInstrument.startSilently(),
this.boundaryInstrument.connect(this.audioDestination))}defaultBoundaryHit(){this.boundaryInstrument&&(this.boundaryInstrument.playFreqAtTime(.1,1,200),this.boundaryInstrument.playFreqAtTime(.2,1,200))}}(function(b){function d(){const a=this.sonification,c=this.options&&this.options.sonification;c&&c.enabled?a?a.update():(this.sonification=new b(this),this.sonification.update()):a&&(a.destroy(),delete this.sonification)}function f(){this&&this.sonification&&this.sonification.destroy()}function g(){this.updateSonificationEnabled&&
this.updateSonificationEnabled()}function h(a){if(a=a.options.sonification)w(!0,this.options.sonification,a),g.call(this)}const k=[];b.compose=function(b,m,l){-1===k.indexOf(b)&&(k.push(b),e(b.prototype,{updateSonificationEnabled:d,sonify:function(a){this.sonification&&this.sonification.sonifyChart(!1,a)},toggleSonify:function(a=!0,b){if(this.sonification){var c=this.sonification.timeline;K.speechSynthesis&&K.speechSynthesis.cancel();c&&this.sonification.isPlaying()?a?this.sonification.cancel():c.pause():
c&&c.isPaused?c.resume():this.sonification.sonifyChart(a,b)}}}),c(b,"destroy",f),c(b,"render",g),c(b,"update",h));-1===k.indexOf(m)&&(k.push(m),m.prototype.sonify=function(a){this.chart.sonification&&this.chart.sonification.sonifySeries(this,!1,a)});-1===k.indexOf(l)&&(k.push(l),l.prototype.sonify=function(a){this.series.chart.sonification&&this.series.chart.sonification.sonifyPoint(this,a)});(b=a().exporting)&&b.buttons&&b.buttons.contextButton.menuItems&&b.buttons.contextButton.menuItems.push("separator",
"downloadMIDI","playAsSound")}})(F||(F={}));w(!0,t,l);"";return F});v(b,"Extensions/Sonification/Scales.js",[],function(){"";return{minor:[0,2,3,5,7,8,10],dorian:[0,2,3,5,7,9,10],harmonicMinor:[0,2,3,5,7,8,11],phrygian:[0,1,3,5,7,8,11],major:[0,2,4,5,7,9,11],lydian:[0,2,4,6,7,9,11],mixolydian:[0,2,4,5,7,9,10],majorPentatonic:[0,2,4,7,9],minorPentatonic:[0,3,5,7,10]}});v(b,"masters/modules/sonification.src.js",[b["Core/Globals.js"],b["Extensions/Sonification/Sonification.js"],b["Extensions/Sonification/SynthPatch.js"],
b["Extensions/Sonification/InstrumentPresets.js"],b["Extensions/Sonification/Scales.js"],b["Extensions/Sonification/SonificationInstrument.js"],b["Extensions/Sonification/SonificationSpeaker.js"],b["Extensions/Sonification/SonificationTimeline.js"]],function(b,r,h,l,v,n,d,A){b.sonification={InstrumentPresets:l,Scales:v,SynthPatch:h,SonificationInstrument:n,SonificationSpeaker:d,SonificationTimeline:A,Sonification:r};r.compose(b.Chart,b.Series,b.Point)})});
//# sourceMappingURL=sonification.js.map