/*
 Highcharts JS v11.0.0 (2023-04-26)

 Pictorial graph series type for Highcharts

 (c) 2010-2022 Torstein Honsi, Magdalena Gut

 License: www.highcharts.com/license
*/
'use strict';(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/modules/pictorial",["highcharts"],function(p){c(p);c.Highcharts=p;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function p(c,g,h,e){c.hasOwnProperty(g)||(c[g]=e.apply(null,h),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:g,module:c[g]}})))}c=c?c._modules:
{};p(c,"Extensions/PatternFill.js",[c["Core/Animation/AnimationUtilities.js"],c["Core/Chart/Chart.js"],c["Core/Globals.js"],c["Core/Defaults.js"],c["Core/Series/Point.js"],c["Core/Series/Series.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,g,h,e,x,r,v,m){function F(b,d){b=JSON.stringify(b);const a=b.length||0;let k=0,f=0;if(d){d=Math.max(Math.floor(a/500),1);for(let f=0;f<a;f+=d)k+=b.charCodeAt(f);k&=k}for(;f<a;++f)d=b.charCodeAt(f),k=(k<<5)-k+d,k&=k;return k.toString(16).replace("-",
"1")}const {animObject:q}=c,{getOptions:p}=e,{addEvent:t,defined:y,erase:C,merge:z,pick:u,removeEvent:D,wrap:E}=m,A=h.patterns=(()=>{const b=[],d=p().colors;["M 0 0 L 5 5 M 4.5 -0.5 L 5.5 0.5 M -0.5 4.5 L 0.5 5.5","M 0 5 L 5 0 M -0.5 0.5 L 0.5 -0.5 M 4.5 5.5 L 5.5 4.5","M 2 0 L 2 5 M 4 0 L 4 5","M 0 2 L 5 2 M 0 4 L 5 4","M 0 1.5 L 2.5 1.5 L 2.5 0 M 2.5 5 L 2.5 3.5 L 5 3.5"].forEach((a,k)=>{b.push({path:a,color:d[k],width:5,height:5,patternTransform:"scale(1.4 1.4)"})});["M 0 0 L 5 10 L 10 0","M 3 3 L 8 3 L 8 8 L 3 8 Z",
"M 5 5 m -4 0 a 4 4 0 1 1 8 0 a 4 4 0 1 1 -8 0","M 0 0 L 10 10 M 9 -1 L 11 1 M -1 9 L 1 11","M 0 10 L 10 0 M -1 1 L 1 -1 M 9 11 L 11 9"].forEach((a,k)=>{b.push({path:a,color:d[k+5],width:10,height:10})});return b})();x.prototype.calculatePatternDimensions=function(b){if(!b.width||!b.height){var d=this.graphic&&(this.graphic.getBBox&&this.graphic.getBBox(!0)||this.graphic.element&&this.graphic.element.getBBox())||{},a=this.shapeArgs;a&&(d.width=a.width||d.width,d.height=a.height||d.height,d.x=a.x||
d.x,d.y=a.y||d.y);if(b.image){if(!d.width||!d.height){b._width="defer";b._height="defer";d=this.series.chart.mapView&&this.series.chart.mapView.getSVGTransform().scaleY;y(d)&&0>d&&(b._inverted=!0);return}b.aspectRatio&&(d.aspectRatio=d.width/d.height,b.aspectRatio>d.aspectRatio?d.aspectWidth=d.height*b.aspectRatio:d.aspectHeight=d.width/b.aspectRatio);b._width=b.width||Math.ceil(d.aspectWidth||d.width);b._height=b.height||Math.ceil(d.aspectHeight||d.height)}b.width||(b._x=b.x||0,b._x+=d.x-Math.round(d.aspectWidth?
Math.abs(d.aspectWidth-d.width)/2:0));b.height||(b._y=b.y||0,b._y+=d.y-Math.round(d.aspectHeight?Math.abs(d.aspectHeight-d.height)/2:0))}};v.prototype.addPattern=function(b,d){let a;d=u(d,!0);let k=q(d);let f=b.width||b._width||32,c=b.height||b._height||32,w=b.color||"#343434",n=b.id,h=this;var e=function(b){h.rect(0,0,f,c).attr({fill:b}).add(a)};n||(this.idCounter=this.idCounter||0,n="highcharts-pattern-"+this.idCounter+"-"+(this.chartIndex||0),++this.idCounter);this.forExport&&(n+="-export");this.defIds=
this.defIds||[];if(!(-1<this.defIds.indexOf(n))){this.defIds.push(n);var l={id:n,patternUnits:"userSpaceOnUse",patternContentUnits:b.patternContentUnits||"userSpaceOnUse",width:f,height:c,x:b._x||b.x||0,y:b._y||b.y||0};b._inverted&&(l.patternTransform="scale(1, -1)",b.patternTransform&&(b.patternTransform+=" scale(1, -1)"));b.patternTransform&&(l.patternTransform=b.patternTransform);a=this.createElement("pattern").attr(l).add(this.defs);a.id=n;b.path?(l=m.isObject(b.path)?b.path:{d:b.path},b.backgroundColor&&
e(b.backgroundColor),e={d:l.d},this.styledMode||(e.stroke=l.stroke||w,e["stroke-width"]=u(l.strokeWidth,2),e.fill=l.fill||"none"),l.transform&&(e.transform=l.transform),this.createElement("path").attr(e).add(a),a.color=w):b.image&&(d?this.image(b.image,0,0,f,c,function(){this.animate({opacity:u(b.opacity,1)},k);D(this.element,"load")}).attr({opacity:0}).add(a):this.image(b.image,0,0,f,c).add(a));b.image&&d||"undefined"===typeof b.opacity||[].forEach.call(a.element.childNodes,function(a){a.setAttribute("opacity",
b.opacity)});this.patternElements=this.patternElements||{};return this.patternElements[n]=a}};E(r.prototype,"getColor",function(b){const d=this.options.color;d&&d.pattern&&!d.pattern.color?(delete this.options.color,b.apply(this,Array.prototype.slice.call(arguments,1)),d.pattern.color=this.color,this.color=this.options.color=d):b.apply(this,Array.prototype.slice.call(arguments,1))});t(r,"render",function(){const b=this.chart.isResizing;(this.isDirtyData||b||!this.chart.hasRendered)&&(this.points||
[]).forEach(function(d){const a=d.options&&d.options.color;a&&a.pattern&&(!b||d.shapeArgs&&d.shapeArgs.width&&d.shapeArgs.height?d.calculatePatternDimensions(a.pattern):(a.pattern._width="defer",a.pattern._height="defer"))})});t(x,"afterInit",function(){const b=this.options.color;b&&b.pattern&&("string"===typeof b.pattern.path&&(b.pattern.path={d:b.pattern.path}),this.color=this.options.color=z(this.series.options.color,b))});t(v,"complexColor",function(b){const d=b.args[0],a=b.args[1];b=b.args[2];
const k=this.chartIndex||0;let f=d.pattern,c="#343434";"undefined"!==typeof d.patternIndex&&A&&(f=A[d.patternIndex]);if(!f)return!0;if(f.image||"string"===typeof f.path||f.path&&f.path.d){let a=b.parentNode&&b.parentNode.getAttribute("class");a=a&&-1<a.indexOf("highcharts-legend");"defer"!==f._width&&"defer"!==f._height||x.prototype.calculatePatternDimensions.call({graphic:{element:b}},f);if(a||!f.id)f=z({},f),f.id="highcharts-pattern-"+k+"-"+F(f)+F(f,!0);this.addPattern(f,!this.forExport&&u(f.animation,
this.globalAnimation,{duration:100}));c=`url(${this.url}#${f.id+(this.forExport?"-export":"")})`}else c=f.color||c;b.setAttribute(a,c);d.toString=function(){return c};return!1});t(g,"endResize",function(){(this.renderer&&this.renderer.defIds||[]).filter(function(b){return b&&b.indexOf&&0===b.indexOf("highcharts-pattern-")}).length&&(this.series.forEach(function(b){b.visible&&b.points.forEach(function(b){(b=b.options&&b.options.color)&&b.pattern&&(b.pattern._width="defer",b.pattern._height="defer")})}),
this.redraw(!1))});t(g,"redraw",function(){const b={},d=this.renderer,a=(d.defIds||[]).filter(function(a){return a.indexOf&&0===a.indexOf("highcharts-pattern-")});a.length&&([].forEach.call(this.renderTo.querySelectorAll('[color^="url("], [fill^="url("], [stroke^="url("]'),function(a){if(a=a.getAttribute("fill")||a.getAttribute("color")||a.getAttribute("stroke"))a=a.replace(d.url,"").replace("url(#","").replace(")",""),b[a]=!0}),a.forEach(function(a){b[a]||(C(d.defIds,a),d.patternElements[a]&&(d.patternElements[a].destroy(),
delete d.patternElements[a]))}))});""});p(c,"Series/Pictorial/PictorialUtilities.js",[c["Core/Utilities.js"]],function(c){const {defined:g}=c;return{rescalePatternFill:function(c,e,g,r,v=1){var m=c&&c.attr("fill");if(m=m&&m.match(/url\(([^)]+)\)/))if(m=document.querySelector(`${m[1]} path`)){let q=m.getBBox();if(0===q.width){var h=m.parentElement;c.renderer.box.appendChild(m);q=m.getBBox();h.appendChild(m)}c=1/(q.width+v);r=e/r/q.height;h=q.width/q.height;e=g/e;const t=-q.width/2;h<e&&(c=c*h/e);m.setAttribute("stroke-width",
v/(g*c));m.setAttribute("transform","translate(0.5, 0)"+`scale(${c} ${r}) `+`translate(${t+v*c/2}, ${-q.y})`)}},invertShadowGroup:function(c,e){(e=e.chart.inverted)&&c.attr({rotation:e?90:0,scaleX:e?-1:1})},getStackMetrics:function(c,e){let h=c.len,r=0;e&&g(e.max)&&(r=c.toPixels(e.max,!0),h=c.len-r);return{height:h,y:r}}}});p(c,"Series/Pictorial/PictorialPoint.js",[c["Core/Series/SeriesRegistry.js"],c["Series/Pictorial/PictorialUtilities.js"]],function(c,g){c=c.seriesTypes.column.prototype.pointClass;
const {rescalePatternFill:h,getStackMetrics:e}=g;class p extends c{constructor(){super(...arguments);this.pathDef=this.series=this.options=void 0}setState(){super.setState.apply(this,arguments);const c=this.series,g=c.options.paths;this.graphic&&this.shapeArgs&&g&&h(this.graphic,e(c.yAxis,g[this.index%g.length]).height,this.shapeArgs.width||0,this.shapeArgs.height||Infinity,this.series.options.borderWidth||0)}}return p});p(c,"Series/Pictorial/PictorialSeries.js",[c["Core/Animation/AnimationUtilities.js"],
c["Core/Chart/Chart.js"],c["Series/Pictorial/PictorialPoint.js"],c["Series/Pictorial/PictorialUtilities.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Axis/Stacking/StackItem.js"],c["Core/Utilities.js"]],function(c,g,h,e,p,r,v){function m(a){var d=Object.keys(a.points).filter(a=>1<a.split(",").length);const c=a.axis.chart.series;let e=-1;d.map(a=>parseFloat(a.split(",")[0])).forEach(a=>{c[a]&&c[a].visible&&(e=a)});if((d=a.axis.chart.series[e])&&d.is("pictorial")&&a.axis.hasData()&&d.xAxis.hasData()){const c=
d.xAxis;var w=a.axis.options;const f=a.axis.chart,k=a.shadow;var n=c.toPixels(a.x,!0);n=f.inverted?c.len-n:n;var g=d.options.paths||[],h=g[a.x%g.length];g=d.getColumnMetrics&&d.getColumnMetrics().width;const {height:e,y:B}=y(d.yAxis,h);var l=w.stackShadow;w=b(l&&l.borderWidth,d.options.borderWidth,1);!k&&l&&l.enabled&&h?(a.shadowGroup||(a.shadowGroup=f.renderer.g("shadow-group").add()),a.shadowGroup.attr({translateX:f.inverted?a.axis.pos:c.pos,translateY:f.inverted?c.pos:a.axis.pos}),a.shadow=f.renderer.rect(n,
B,g,e).attr({fill:{pattern:{path:{d:h.definition,fill:l.color||"#dedede",strokeWidth:w,stroke:l.borderColor||"transparent"},x:n,y:B,width:g,height:e,patternContentUnits:"objectBoundingBox",backgroundColor:"none",color:"#dedede"}}}).add(a.shadowGroup),C(a.shadowGroup,a.axis),z(a.shadow,e,g,e,w),a.setOffset(d.pointXOffset||0,d.barW||0)):k&&a.shadowGroup&&(k.animate({x:n,y:B,width:g,height:e}),h=/url\(([^)]+)\)/,(h=(l=k.attr("fill"))&&l.match(h))&&f.renderer.patternElements&&f.renderer.patternElements[h[1].slice(1)].animate({x:n,
y:B,width:g,height:e}),a.shadowGroup.animate({translateX:f.inverted?a.axis.pos:c.pos,translateY:f.inverted?c.pos:a.axis.pos}),C(a.shadowGroup,a.axis),z(k,e,g,e,w),a.setOffset(d.pointXOffset||0,d.barW||0))}else a.shadow&&a.shadowGroup&&(a.shadow.destroy(),a.shadow=void 0,a.shadowGroup.destroy(),a.shadowGroup=void 0)}function t(a,b){a.axes&&a.axes.forEach(function(a){a.stacking&&A(a.stacking.stacks,function(a){A(a,function(a){b(a)})})})}function q(a){t(a,function(a){a.shadow&&a.shadowGroup&&(a.shadow.destroy(),
a.shadowGroup.destroy(),delete a.shadow,delete a.shadowGroup)})}const x=p.seriesTypes.column,{animObject:G}=c,{getStackMetrics:y,invertShadowGroup:C,rescalePatternFill:z}=e,{addEvent:u,defined:D,merge:E,objectEach:A,pick:b}=v;class d extends x{constructor(){super(...arguments);this.points=this.options=this.data=this.paths=void 0}animate(a){const {chart:b,group:d}=this;var c=G(this.options.animation),e=[this.getSharedClipKey(),c.duration,c.easing,c.defer].join();let g=b.sharedClips[e];a&&d?(c=this.getClipBox(),
g||(c.y=c.height,c.height=0,g=b.renderer.clipRect(c),b.sharedClips[e]=g),d.clip(g)):g&&!g.hasClass("highcharts-animating")&&(e=this.getClipBox(),g.addClass("highcharts-animating").animate(e,c))}animateDrilldown(){}animateDrillupFrom(){}pointAttribs(a){const b=super.pointAttribs.apply(this,arguments);var c=this.options.paths;if(a&&a.shapeArgs&&c){c=c[a.index%c.length];const {y:d,height:f}=y(this.yAxis,c);c=c.definition;c!==a.pathDef?(a.pathDef=c,b.fill={pattern:{path:{d:c,fill:b.fill,strokeWidth:b["stroke-width"],
stroke:b.stroke},x:a.shapeArgs.x,y:d,width:a.shapeArgs.width||0,height:f,patternContentUnits:"objectBoundingBox",backgroundColor:"none",color:"#ff0000"}}):a.pathDef&&a.graphic&&delete b.fill}delete b.stroke;delete b.strokeWidth;return b}getExtremes(){const a=super.getExtremes.apply(this,arguments),b=this.options.paths;b&&b.forEach(function(b){D(b.max)&&D(a.dataMax)&&b.max>a.dataMax&&(a.dataMax=b.max)});return a}}d.defaultOptions=E(x.defaultOptions,{borderWidth:0});u(d,"afterRender",function(){const a=
this,b=a.options.paths,c=/url\(([^)]+)\)/;a.points.forEach(function(d){if(d.graphic&&d.shapeArgs&&b){const f=b[d.index%b.length];var e=d.graphic.attr("fill");e=e&&e.match(c);const {y:g,height:k}=y(a.yAxis,f);e&&a.chart.renderer.patternElements&&(e=a.chart.renderer.patternElements[e[1].slice(1)])&&e.animate({x:d.shapeArgs.x,y:g,width:d.shapeArgs.width||0,height:k});z(d.graphic,y(a.yAxis,f).height,d.shapeArgs.width||0,d.shapeArgs.height||Infinity,a.options.borderWidth||0)}})});u(g,"render",function(){t(this,
m)});u(r,"afterSetOffset",function(a){if(this.shadow){const {chart:b,len:c}=this.axis,{xOffset:d,width:e}=a;this.shadow.attr({translateX:b.inverted?d-b.xAxis[0].len:d,translateY:b.inverted?-c:0});this.shadow.animate({width:e})}});u(g,"afterDrilldown",function(a){q(this)});u(g,"afterDrillUp",function(a){q(this)});d.prototype.pointClass=h;p.registerSeriesType("pictorial",d);"";return d});p(c,"masters/modules/pictorial.src.js",[],function(){})});
//# sourceMappingURL=pictorial.js.map