/*
 Highmaps JS v11.0.0 (2023-04-26)

 Highmaps as a plugin for Highcharts or Highcharts Stock.

 (c) 2011-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(A){a(A);a.Highcharts=A;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function A(a,k,p,w){a.hasOwnProperty(k)||(a[k]=w.apply(null,p),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:k,module:a[k]}})))}a=a?a._modules:
{};A(a,"Core/Axis/Color/ColorAxisComposition.js",[a["Core/Color/Color.js"],a["Core/Utilities.js"]],function(a,k){const {parse:p}=a,{addEvent:h,extend:l,merge:x,pick:t,splat:q}=k;var v;(function(m){function e(){const b=this.options;this.colorAxis=[];b.colorAxis&&(b.colorAxis=q(b.colorAxis),b.colorAxis.forEach((b,c)=>{b.index=c;new y(this,b)}))}function a(b){const c=c=>{c=b.allItems.indexOf(c);-1!==c&&(this.destroyItem(b.allItems[c]),b.allItems.splice(c,1))};let f=[],n,d;(this.chart.colorAxis||[]).forEach(function(b){(n=
b.options)&&n.showInLegend&&(n.dataClasses&&n.visible?f=f.concat(b.getDataClassLegendSymbols()):n.visible&&f.push(b),b.series.forEach(function(b){if(!b.options.showInLegend||n.dataClasses)"point"===b.options.legendType?b.points.forEach(function(b){c(b)}):c(b)}))});for(d=f.length;d--;)b.allItems.unshift(f[d])}function g(b){b.visible&&b.item.legendColor&&b.item.legendItem.symbol.attr({fill:b.item.legendColor})}function d(){const b=this.chart.colorAxis;b&&b.forEach(function(b,c,f){b.update({},f)})}function c(){(this.chart.colorAxis&&
this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function b(){const b=this.axisTypes;b?-1===b.indexOf("colorAxis")&&b.push("colorAxis"):this.axisTypes=["colorAxis"]}function n(b){const c=this,f=b?"show":"hide";c.visible=c.options.visible=!!b;["graphic","dataLabel"].forEach(function(b){if(c[b])c[b][f]()});this.series.buildKDTree()}function f(){const b=this,c=this.options.nullColor,f=this.colorAxis,n=this.colorKey;(this.data.length?this.data:this.points).forEach(u=>{var d=u.getNestedProperty(n);
(d=u.options.color||(u.isNull||null===u.value?c:f&&"undefined"!==typeof d?f.toColor(d,u):u.color||b.color))&&u.color!==d&&(u.color=d,"point"===b.options.legendType&&u.legendItem&&u.legendItem.label&&b.chart.legend.colorizeItem(u,u.visible))})}function z(b){const c=b.prototype.createAxis;b.prototype.createAxis=function(b,f){if("colorAxis"!==b)return c.apply(this,arguments);const u=new y(this,x(f.axis,{index:this[b].length,isX:!1}));this.isDirtyLegend=!0;this.axes.forEach(function(b){b.series=[]});
this.series.forEach(function(b){b.bindAxes();b.isDirtyData=!0});t(f.redraw,!0)&&this.redraw(f.animation);return u}}function C(){this.elem.attr("fill",p(this.start).tweenTo(p(this.end),this.pos),void 0,!0)}function D(){this.elem.attr("stroke",p(this.start).tweenTo(p(this.end),this.pos),void 0,!0)}const r=[];let y;m.compose=function(m,u,E,F,H){y||(y=m);k.pushUnique(r,u)&&(m=u.prototype,m.collectionsWithUpdate.push("colorAxis"),m.collectionsWithInit.colorAxis=[m.addColorAxis],h(u,"afterGetAxes",e),z(u));
k.pushUnique(r,E)&&(u=E.prototype,u.fillSetter=C,u.strokeSetter=D);k.pushUnique(r,F)&&(h(F,"afterGetAllItems",a),h(F,"afterColorizeItem",g),h(F,"afterUpdate",d));k.pushUnique(r,H)&&(l(H.prototype,{optionalAxis:"colorAxis",translateColors:f}),l(H.prototype.pointClass.prototype,{setVisible:n}),h(H,"afterTranslate",c,{order:1}),h(H,"bindAxes",b))};m.pointSetVisible=n})(v||(v={}));return v});A(a,"Core/Axis/Color/ColorAxisDefaults.js",[],function(){return{lineWidth:0,minPadding:0,maxPadding:0,gridLineColor:"#ffffff",
gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{distance:8,overflow:"justify",rotation:0},minColor:"#e6e9ff",maxColor:"#0022ff",tickLength:5,showInLegend:!0}});A(a,"Core/Axis/Color/ColorAxis.js",[a["Core/Axis/Axis.js"],a["Core/Color/Color.js"],a["Core/Axis/Color/ColorAxisComposition.js"],a["Core/Axis/Color/ColorAxisDefaults.js"],a["Core/Legend/LegendSymbol.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],
function(a,k,p,w,l,x,t){const {parse:q}=k,{series:h}=x,{extend:m,isNumber:e,merge:B,pick:g}=t;class d extends a{static compose(c,b,n,f){p.compose(d,c,b,n,f)}constructor(c,b){super(c,b);this.beforePadding=!1;this.chart=void 0;this.coll="colorAxis";this.stops=this.options=this.dataClasses=void 0;this.visible=!0;this.init(c,b)}init(c,b){var n=c.options.legend||{};const f=b.layout?"vertical"!==b.layout:"vertical"!==n.layout,z=b.visible;n=B(d.defaultColorAxisOptions,b,{showEmpty:!1,title:null,visible:n.enabled&&
!1!==z});this.coll="colorAxis";this.side=b.side||f?2:1;this.reversed=b.reversed||!f;this.opposite=!f;super.init(c,n);this.userOptions.visible=z;b.dataClasses&&this.initDataClasses(b);this.initStops();this.horiz=f;this.zoomEnabled=!1}initDataClasses(c){const b=this.chart,n=this.legendItem=this.legendItem||{},f=c.dataClasses.length,d=this.options;let g,e=0,r=b.options.chart.colorCount;this.dataClasses=g=[];n.labels=[];(c.dataClasses||[]).forEach(function(c,n){c=B(c);g.push(c);if(b.styledMode||!c.color)"category"===
d.dataClassColor?(b.styledMode||(n=b.options.colors,r=n.length,c.color=n[e]),c.colorIndex=e,e++,e===r&&(e=0)):c.color=q(d.minColor).tweenTo(q(d.maxColor),2>f?.5:n/(f-1))})}hasData(){return!!(this.tickPositions||[]).length}setTickPositions(){if(!this.dataClasses)return super.setTickPositions()}initStops(){this.stops=this.options.stops||[[0,this.options.minColor],[1,this.options.maxColor]];this.stops.forEach(function(c){c.color=q(c[1])})}setOptions(c){super.setOptions(c);this.options.crosshair=this.options.marker}setAxisSize(){var c=
this.legendItem&&this.legendItem.symbol;const b=this.chart;var n=b.options.legend||{};let f,g;c?(this.left=n=c.attr("x"),this.top=f=c.attr("y"),this.width=g=c.attr("width"),this.height=c=c.attr("height"),this.right=b.chartWidth-n-g,this.bottom=b.chartHeight-f-c,this.len=this.horiz?g:c,this.pos=this.horiz?n:f):this.len=(this.horiz?n.symbolWidth:n.symbolHeight)||d.defaultLegendLength}normalizedValue(c){this.logarithmic&&(c=this.logarithmic.log2lin(c));return 1-(this.max-c)/(this.max-this.min||1)}toColor(c,
b){const n=this.dataClasses;var f=this.stops;let d,g,e,r;if(n)for(r=n.length;r--;){if(e=n[r],d=e.from,f=e.to,("undefined"===typeof d||c>=d)&&("undefined"===typeof f||c<=f)){g=e.color;b&&(b.dataClass=r,b.colorIndex=e.colorIndex);break}}else{c=this.normalizedValue(c);for(r=f.length;r--&&!(c>f[r][0]););d=f[r]||f[r+1];f=f[r+1]||d;c=1-(f[0]-c)/(f[0]-d[0]||1);g=d.color.tweenTo(f.color,c)}return g}getOffset(){const c=this.legendItem&&this.legendItem.group,b=this.chart.axisOffset[this.side];if(c){this.axisParent=
c;super.getOffset();const n=this.chart.legend;n.allItems.forEach(function(b){b instanceof d&&b.drawLegendSymbol(n,b)});n.render();this.chart.getMargins(!0);this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width);this.chart.axisOffset[this.side]=b}}setLegendColor(){var c=this.reversed,b=c?1:0;c=c?0:1;b=this.horiz?[b,0,c,0]:[0,c,0,b];this.legendColor={linearGradient:{x1:b[0],y1:b[1],x2:b[2],y2:b[3]},stops:this.stops}}drawLegendSymbol(c,b){var n;b=b.legendItem||{};const f=c.padding,e=
c.options,C=this.options.labels,m=g(e.itemDistance,10),r=this.horiz,y=g(e.symbolWidth,r?d.defaultLegendLength:12),a=g(e.symbolHeight,r?12:d.defaultLegendLength),u=g(e.labelPadding,r?16:30);this.setLegendColor();b.symbol||(b.symbol=this.chart.renderer.symbol("roundedRect",0,c.baseline-11,y,a,{r:null!==(n=e.symbolRadius)&&void 0!==n?n:3}).attr({zIndex:1}).add(b.group));b.labelWidth=y+f+(r?m:g(C.x,C.distance)+this.maxLabelLength);b.labelHeight=a+f+(r?u:0)}setState(c){this.series.forEach(function(b){b.setState(c)})}setVisible(){}getSeriesExtremes(){const c=
this.series;let b;let d,f,e=c.length,C,m;this.dataMin=Infinity;for(this.dataMax=-Infinity;e--;){f=c[e];b=f.colorKey=g(f.options.colorKey,f.colorKey,f.pointValKey,f.zoneAxis,"y");var r=f.pointArrayMap;d=f[b+"Min"]&&f[b+"Max"];if(f[b+"Data"])var y=f[b+"Data"];else if(r){if(y=[],r=r.indexOf(b),C=f.yData,0<=r&&C)for(m=0;m<C.length;m++)y.push(g(C[m][r],C[m]))}else y=f.yData;d?(f.minColorValue=f[b+"Min"],f.maxColorValue=f[b+"Max"]):(y=h.prototype.getExtremes.call(f,y),f.minColorValue=y.dataMin,f.maxColorValue=
y.dataMax);"undefined"!==typeof f.minColorValue&&(this.dataMin=Math.min(this.dataMin,f.minColorValue),this.dataMax=Math.max(this.dataMax,f.maxColorValue));d||h.prototype.applyExtremes.call(f)}}drawCrosshair(c,b){const d=this.legendItem||{},f=b&&b.plotX,g=b&&b.plotY,e=this.pos,m=this.len;let r;b&&(r=this.toPixels(b.getNestedProperty(b.series.colorKey)),r<e?r=e-2:r>e+m&&(r=e+m+2),b.plotX=r,b.plotY=this.len-r,super.drawCrosshair(c,b),b.plotX=f,b.plotY=g,this.cross&&!this.cross.addedToColorAxis&&d.group&&
(this.cross.addClass("highcharts-coloraxis-marker").add(d.group),this.cross.addedToColorAxis=!0,this.chart.styledMode||"object"!==typeof this.crosshair||this.cross.attr({fill:this.crosshair.color})))}getPlotLinePath(c){const b=this.left,d=c.translatedValue,f=this.top;return e(d)?this.horiz?[["M",d-4,f-6],["L",d+4,f-6],["L",d,f],["Z"]]:[["M",b,d],["L",b-6,d+6],["L",b-6,d-6],["Z"]]:super.getPlotLinePath(c)}update(c,b){const d=this.chart.legend;this.series.forEach(b=>{b.isDirtyData=!0});(c.dataClasses&&
d.allItems||this.dataClasses)&&this.destroyItems();super.update(c,b);this.legendItem&&this.legendItem.label&&(this.setLegendColor(),d.colorizeItem(this,!0))}destroyItems(){const c=this.chart,b=this.legendItem||{};if(b.label)c.legend.destroyItem(this);else if(b.labels)for(const d of b.labels)c.legend.destroyItem(d);c.isDirtyLegend=!0}destroy(){this.chart.isDirtyLegend=!0;this.destroyItems();super.destroy(...[].slice.call(arguments))}remove(c){this.destroyItems();super.remove(c)}getDataClassLegendSymbols(){const c=
this,b=c.chart,d=c.legendItem&&c.legendItem.labels||[],f=b.options.legend,e=g(f.valueDecimals,-1),C=g(f.valueSuffix,""),a=b=>c.series.reduce((c,f)=>{c.push(...f.points.filter(c=>c.dataClass===b));return c},[]);let r;d.length||c.dataClasses.forEach((f,g)=>{const u=f.from,n=f.to,{numberFormatter:z}=b;let y=!0;r="";"undefined"===typeof u?r="< ":"undefined"===typeof n&&(r="> ");"undefined"!==typeof u&&(r+=z(u,e)+C);"undefined"!==typeof u&&"undefined"!==typeof n&&(r+=" - ");"undefined"!==typeof n&&(r+=
z(n,e)+C);d.push(m({chart:b,name:r,options:{},drawLegendSymbol:l.drawRectangle,visible:!0,isDataClass:!0,setState:b=>{for(const c of a(g))c.setState(b)},setVisible:function(){this.visible=y=c.visible=!y;for(const b of a(g))b.setVisible(y);b.legend.colorizeItem(this,y)}},f))});return d}}d.defaultColorAxisOptions=w;d.defaultLegendLength=200;d.keepProps=["legendItem"];Array.prototype.push.apply(a.keepProps,d.keepProps);"";return d});A(a,"Maps/MapNavigationDefaults.js",[a["Core/Defaults.js"],a["Core/Utilities.js"]],
function(a,k){({extend:k}=k);const h={buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",x:0,width:18,height:18,padding:5,style:{color:"#666666",fontSize:"1em",fontWeight:"bold"},theme:{fill:"#ffffff",stroke:"#e6e6e6","stroke-width":1,"text-align":"center"}},buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1};k(a.defaultOptions.lang,{zoomIn:"Zoom in",zoomOut:"Zoom out"});return a.defaultOptions.mapNavigation=
h});A(a,"Maps/MapNavigation.js",[a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,k,p){function h(g){g&&(g.preventDefault&&g.preventDefault(),g.stopPropagation&&g.stopPropagation(),g.cancelBubble=!0)}function l(g){this.navButtons=[];this.init(g)}const {doc:x}=k,{addEvent:t,extend:q,isNumber:v,merge:m,objectEach:e,pick:B}=p;l.prototype.init=function(g){this.chart=g};l.prototype.update=function(g){let d=this,c=this.chart,b=c.options.mapNavigation,n,f=function(b){this.handler.call(c,
b);h(b)},z=d.navButtons;g&&(b=c.options.mapNavigation=m(c.options.mapNavigation,g));for(;z.length;)z.pop().destroy();B(b.enableButtons,b.enabled)&&!c.renderer.forExport&&(d.navButtonsGroup||(d.navButtonsGroup=c.renderer.g().attr({zIndex:4}).add()),e(b.buttons,function(g,e){var r;g=m(b.buttonOptions,g);!c.styledMode&&g.theme&&(n=g.theme,n.style=m(g.theme.style,g.style));const {text:a,width:C=0,height:u=0,padding:E=0}=g,F=c.renderer.button("+"!==a&&"-"!==a&&a||"",0,0,f,n,void 0,void 0,void 0,"zoomIn"===
e?"topbutton":"bottombutton").addClass("highcharts-map-navigation highcharts-"+{zoomIn:"zoom-in",zoomOut:"zoom-out"}[e]).attr({width:C,height:u,title:c.options.lang[e],padding:g.padding,zIndex:5}).add(d.navButtonsGroup);if("+"===a||"-"===a){e=C+1;const b=[["M",E+3,E+u/2],["L",E+e-3,E+u/2]];"+"===a&&b.push(["M",E+e/2,E+3],["L",E+e/2,E+u-3]);c.renderer.path(b).addClass("highcharts-button-symbol").attr(c.styledMode?{}:{stroke:null===(r=g.style)||void 0===r?void 0:r.color,"stroke-width":3,"stroke-linecap":"round"}).add(F)}F.handler=
g.onclick;t(F.element,"dblclick",h);z.push(F);q(g,{width:F.width,height:2*F.height});if(c.hasLoaded)F.align(g,!1,g.alignTo);else{const b=t(c,"load",()=>{F.element&&F.align(g,!1,g.alignTo);b()})}}),g=function(){var f=c.exportingGroup&&c.exportingGroup.getBBox();if(f){const c=d.navButtonsGroup.getBBox();if(!(c.x>=f.x+f.width||c.x+c.width<=f.x||c.y>=f.y+f.height||c.y+c.height<=f.y)){const g=-c.y-c.height+f.y-5;f=f.y+f.height-c.y+5;d.navButtonsGroup.attr({translateY:"bottom"===(b.buttonOptions&&b.buttonOptions.verticalAlign)?
g:f})}}},c.hasLoaded||t(c,"render",g));this.updateEvents(b)};l.prototype.updateEvents=function(g){const d=this.chart;B(g.enableDoubleClickZoom,g.enabled)||g.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||t(d.container,"dblclick",function(c){d.pointer.onContainerDblClick(c)}):this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick());B(g.enableMouseWheelZoom,g.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||t(d.container,void 0!==x.onwheel?"wheel":void 0!==x.onmousewheel?
"mousewheel":"DOMMouseScroll",function(c){d.pointer.inClass(c.target,"highcharts-no-mousewheel")||(d.pointer.onContainerMouseWheel(c),h(c));return!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())};q(a.prototype,{fitToBox:function(g,d){[["x","width"],["y","height"]].forEach(function(c){const b=c[0];c=c[1];g[b]+g[c]>d[b]+d[c]&&(g[c]>d[c]?(g[c]=d[c],g[b]=d[b]):g[b]=d[b]+d[c]-g[c]);g[c]>d[c]&&(g[c]=d[c]);g[b]<d[b]&&(g[b]=d[b])});return g},mapZoom:function(g,d,c,b,e){this.mapView&&
(v(g)&&(g=Math.log(g)/Math.log(.5)),this.mapView.zoomBy(g,v(d)&&v(c)?this.mapView.projection.inverse([d,c]):void 0,v(b)&&v(e)?[b,e]:void 0))}});t(a,"beforeRender",function(){this.mapNavigation=new l(this);this.mapNavigation.update()});k.MapNavigation=l});A(a,"Maps/MapPointer.js",[a["Core/Pointer.js"],a["Core/Utilities.js"]],function(a,k){const {defined:h,extend:w,pick:l,wrap:x}=k,t=a.prototype.normalize;let q=0,v;w(a.prototype,{normalize:function(m,e){const a=this.chart;m=t.call(this,m,e);a&&a.mapView&&
(e=a.mapView.pixelsToLonLat({x:m.chartX-a.plotLeft,y:m.chartY-a.plotTop}))&&w(m,e);return m},onContainerDblClick:function(m){const e=this.chart;m=this.normalize(m);e.options.mapNavigation.enableDoubleClickZoomTo?e.pointer.inClass(m.target,"highcharts-tracker")&&e.hoverPoint&&e.hoverPoint.zoomTo():e.isInsidePlot(m.chartX-e.plotLeft,m.chartY-e.plotTop)&&e.mapZoom(.5,void 0,void 0,m.chartX,m.chartY)},onContainerMouseWheel:function(m){const e=this.chart;m=this.normalize(m);const a=h(m.wheelDelta)&&-m.wheelDelta/
120||m.deltaY||m.detail;1<=Math.abs(a)&&(q+=Math.abs(a),v&&clearTimeout(v),v=setTimeout(()=>{q=0},50));10>q&&e.isInsidePlot(m.chartX-e.plotLeft,m.chartY-e.plotTop)&&e.mapView&&e.mapView.zoomBy((e.options.mapNavigation.mouseWheelSensitivity-1)*-a,void 0,[m.chartX,m.chartY],1>Math.abs(a)?!1:void 0)}});x(a.prototype,"zoomOption",function(a){const e=this.chart.options.mapNavigation;l(e.enableTouchZoom,e.enabled)&&(this.chart.options.chart.zooming.pinchType="xy");a.apply(this,[].slice.call(arguments,1))});
x(a.prototype,"pinchTranslate",function(a,e,l,g,d,c,b){a.call(this,e,l,g,d,c,b);"map"===this.chart.options.chart.type&&this.hasZoom&&(a=g.scaleX>g.scaleY,this.pinchTranslateDirection(!a,e,l,g,d,c,b,a?g.scaleX:g.scaleY))})});A(a,"Series/ColorMapComposition.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,k){const {column:{prototype:h}}=a.seriesTypes,{addEvent:w,defined:l}=k;var x;(function(a){function q(a){this.moveToTopOnHover&&this.graphic&&this.graphic.attr({zIndex:a&&
"hover"===a.state?1:0})}const x=[];a.pointMembers={dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value&&(void 0===this.value||!isNaN(this.value))}};a.seriesMembers={colorKey:"value",axisTypes:["xAxis","yAxis","colorAxis"],parallelArrays:["x","y","value"],pointArrayMap:["value"],trackerGroups:["group","markerGroup","dataLabelsGroup"],colorAttribs:function(a){const e={};!l(a.color)||a.state&&"normal"!==a.state||(e[this.colorProp||
"fill"]=a.color);return e},pointAttribs:h.pointAttribs};a.compose=function(a){const e=a.prototype.pointClass;k.pushUnique(x,e)&&w(e,"afterSetState",q);return a}})(x||(x={}));return x});A(a,"Maps/MapSymbols.js",[a["Core/Renderer/SVG/SVGRenderer.js"]],function(a){const {prototype:{symbols:h}}=a;h.bottombutton=function(a,k,l,x,t){if(t){const a=(null===t||void 0===t?void 0:t.r)||0;t.brBoxY=k-a;t.brBoxHeight=x+a}return h.roundedRect(a,k,l,x,t)};h.topbutton=function(a,k,l,x,t){t&&(t.brBoxHeight=x+((null===
t||void 0===t?void 0:t.r)||0));return h.roundedRect(a,k,l,x,t)};return h});A(a,"Core/Chart/MapChart.js",[a["Core/Chart/Chart.js"],a["Core/Defaults.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,k,p,w){const {getOptions:l}=k,{merge:h,pick:t}=w;class q extends a{init(a,m){const e=l().credits;a=h({chart:{panning:{enabled:!0,type:"xy"},type:"map"},credits:{mapText:t(e.mapText,' \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>'),mapTextFull:t(e.mapTextFull,
"{geojson.copyright}")},mapView:{},tooltip:{followTouchMove:!1}},a);super.init(a,m)}}(function(a){a.maps={};a.mapChart=function(m,e,l){return new a(m,e,l)};a.splitPath=function(a){"string"===typeof a&&(a=a.replace(/([A-Za-z])/g," $1 ").replace(/^\s*/,"").replace(/\s*$/,""),a=a.split(/[ ,;]+/).map(a=>/[A-za-z]/.test(a)?a:parseFloat(a)));return p.prototype.pathToSegments(a)}})(q||(q={}));return q});A(a,"Maps/MapUtilities.js",[],function(){return{boundsFromPath:function(a){let h=-Number.MAX_VALUE,p=
Number.MAX_VALUE,w=-Number.MAX_VALUE,l=Number.MAX_VALUE,x;a.forEach(a=>{const q=a[a.length-2];a=a[a.length-1];"number"===typeof q&&"number"===typeof a&&(p=Math.min(p,q),h=Math.max(h,q),l=Math.min(l,a),w=Math.max(w,a),x=!0)});if(x)return{x1:p,y1:l,x2:h,y2:w}},pointInPolygon:function(a,k){let h,w,l,x=!1,t=a.x,q=a.y;a=0;for(h=k.length-1;a<k.length;h=a++)w=k[a][1]>q,l=k[h][1]>q,w!==l&&t<(k[h][0]-k[a][0])*(q-k[a][1])/(k[h][1]-k[a][1])+k[a][0]&&(x=!x);return x}}});A(a,"Series/Map/MapPoint.js",[a["Series/ColorMapComposition.js"],
a["Maps/MapUtilities.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,k,p,w){const {boundsFromPath:l}=k;({seriesTypes:{scatter:k}}=p);const {extend:h,isNumber:t,pick:q}=w;class v extends k.prototype.pointClass{constructor(){super(...arguments);this.series=this.path=this.options=void 0}static getProjectedPath(a,e){a.projectedPath||(e&&a.geometry?(e.hasCoordinates=!0,a.projectedPath=e.path(a.geometry)):a.projectedPath=a.path);return a.projectedPath||[]}applyOptions(a,e){const m=
this.series;a=super.applyOptions.call(this,a,e);e=m.joinBy;m.mapData&&m.mapMap&&(e=super.getNestedProperty.call(a,e[1]),(e="undefined"!==typeof e&&m.mapMap[e])?h(a,e):-1!==m.pointArrayMap.indexOf("value")&&(a.value=a.value||null));return a}getProjectedBounds(a){a=v.getProjectedPath(this,a);a=l(a);var e=this.properties,m=this.series.chart.mapView;if(a){const g=e&&e["hc-middle-lon"],d=e&&e["hc-middle-lat"];if(m&&t(g)&&t(d)){if(e=m.lonLatToProjectedUnits({lon:g,lat:d}))a.midX=e.x,a.midY=e.y}else m=e&&
e["hc-middle-x"],e=e&&e["hc-middle-y"],a.midX=a.x1+(a.x2-a.x1)*q(this.middleX,t(m)?m:.5),e=q(this.middleY,t(e)?e:.5),this.geometry||(e=1-e),a.midY=a.y2-(a.y2-a.y1)*e;return a}}onMouseOver(a){w.clearTimeout(this.colorInterval);if(!this.isNull&&this.visible||this.series.options.nullInteraction)super.onMouseOver.call(this,a);else this.series.onMouseOut(a)}setVisible(a){const e=a?"show":"hide";this.visible=this.options.visible=!!a;if(this.dataLabel)this.dataLabel[e]();this.graphic&&this.graphic.attr(this.series.pointAttribs(this))}zoomTo(a){const e=
this.series.chart,l=e.mapView;var g=this.bounds;if(l&&g){const c=t(this.insetIndex)&&l.insets[this.insetIndex];if(c){var d=c.projectedUnitsToPixels({x:g.x1,y:g.y1});g=c.projectedUnitsToPixels({x:g.x2,y:g.y2});d=l.pixelsToProjectedUnits({x:d.x,y:d.y});g=l.pixelsToProjectedUnits({x:g.x,y:g.y});g={x1:d.x,y1:d.y,x2:g.x,y2:g.y}}l.fitToBounds(g,void 0,!1);this.series.isDirty=!0;e.redraw(a)}}}h(v.prototype,{dataLabelOnNull:a.pointMembers.dataLabelOnNull,moveToTopOnHover:a.pointMembers.moveToTopOnHover,isValid:a.pointMembers.isValid});
return v});A(a,"Maps/MapViewOptionsDefault.js",[],function(){return{center:[0,0],fitToGeometry:void 0,maxZoom:void 0,padding:0,projection:{name:void 0,parallels:void 0,rotation:void 0},zoom:void 0}});A(a,"Maps/MapViewInsetsOptionsDefault.js",[],function(){return{borderColor:"#cccccc",borderWidth:1,center:[0,0],padding:"10%",relativeTo:"mapBoundingBox",units:"percent"}});A(a,"Extensions/GeoJSON.js",[a["Core/Chart/Chart.js"],a["Core/FormatUtilities.js"],a["Core/Globals.js"],a["Core/Utilities.js"]],
function(a,k,p,w){function l(a,d){d||(d=Object.keys(a.objects)[0]);d=a.objects[d];if(d["hc-decoded-geojson"])return d["hc-decoded-geojson"];let c=a.arcs;if(a.transform){const {scale:b,translate:d}=a.transform;c=a.arcs.map(a=>{let c=0,f=0;return a.map(a=>{a=a.slice();a[0]=(c+=a[0])*b[0]+d[0];a[1]=(f+=a[1])*b[1]+d[1];return a})})}const b=a=>"number"===typeof a[0]?a.reduce((b,a,f)=>{let d=0>a?c[~a]:c[a];0>a?(d=d.slice(0,0===f?d.length:d.length-1),d.reverse()):f&&(d=d.slice(1));return b.concat(d)},[]):
a.map(b),e=d.geometries.map(a=>({type:"Feature",properties:a.properties,geometry:{type:a.type,coordinates:a.coordinates||b(a.arcs)}}));a={type:"FeatureCollection",copyright:a.copyright,copyrightShort:a.copyrightShort,copyrightUrl:a.copyrightUrl,features:e,"hc-recommended-mapview":d["hc-recommended-mapview"],bbox:a.bbox,title:a.title};return d["hc-decoded-geojson"]=a}function h(a,d="map",c){const b=[];a="Topology"===a.type?l(a):a;a.features.forEach(function(a){var c=a.geometry||{},e=c.type;c=c.coordinates;
a=a.properties;let g;"map"!==d&&"mapbubble"!==d||"Polygon"!==e&&"MultiPolygon"!==e?"mapline"!==d||"LineString"!==e&&"MultiLineString"!==e?"mappoint"===d&&"Point"===e&&c.length&&(g={geometry:{coordinates:c,type:e}}):c.length&&(g={geometry:{coordinates:c,type:e}}):c.length&&(g={geometry:{coordinates:c,type:e}});if(g){e=a&&(a.name||a.NAME);c=a&&a.lon;const d=a&&a.lat;b.push(m(g,{lat:"number"===typeof d?d:void 0,lon:"number"===typeof c?c:void 0,name:"string"===typeof e?e:void 0,properties:a}))}});c&&
a.copyrightShort&&(c.chart.mapCredits=t(c.chart.options.credits.mapText,{geojson:a}),c.chart.mapCreditsFull=t(c.chart.options.credits.mapTextFull,{geojson:a}));return b}const {format:t}=k,{win:q}=p,{error:v,extend:m,merge:e,wrap:B}=w;"";a.prototype.transformFromLatLon=function(a,d){var c=this.options.chart.proj4||q.proj4;if(c){var {jsonmarginX:b=0,jsonmarginY:e=0,jsonres:f=1,scale:g=1,xoffset:l=0,xpan:m=0,yoffset:r=0,ypan:y=0}=d;a=c(d.crs,[a.lon,a.lat]);c=d.cosAngle||d.rotation&&Math.cos(d.rotation);
var h=d.sinAngle||d.rotation&&Math.sin(d.rotation);d=d.rotation?[a[0]*c+a[1]*h,-a[0]*h+a[1]*c]:a;return{x:((d[0]-l)*g+m)*f+b,y:-(((r-d[1])*g+y)*f-e)}}v(21,!1,this)};a.prototype.transformToLatLon=function(a,d){const c=this.options.chart.proj4||q.proj4;if(!c)v(21,!1,this);else if(null!==a.y){var {jsonmarginX:b=0,jsonmarginY:e=0,jsonres:f=1,scale:g=1,xoffset:l=0,xpan:m=0,yoffset:r=0,ypan:y=0}=d;a={x:((a.x-b)/f-m)/g+l,y:((a.y-e)/f+y)/g+r};var h=d.cosAngle||d.rotation&&Math.cos(d.rotation),u=d.sinAngle||
d.rotation&&Math.sin(d.rotation);d=c(d.crs,"WGS84",d.rotation?{x:a.x*h+a.y*-u,y:a.x*u+a.y*h}:a);return{lat:d.y,lon:d.x}}};a.prototype.fromPointToLatLon=function(a){return this.mapView&&this.mapView.projectedUnitsToLonLat(a)};a.prototype.fromLatLonToPoint=function(a){return this.mapView&&this.mapView.lonLatToProjectedUnits(a)};B(a.prototype,"addCredits",function(a,d){d=e(!0,this.options.credits,d);this.mapCredits&&(d.href=null);a.call(this,d);this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})});
p.geojson=h;p.topo2geo=l;return{geojson:h,topo2geo:l}});A(a,"Core/Geometry/PolygonClip.js",[],function(){const a=(a,l,h)=>(l[0]-a[0])*(h[1]-a[1])>(l[1]-a[1])*(h[0]-a[0]),k=(a,l,h,k)=>{var q=[a[0]-l[0],a[1]-l[1]];const p=[h[0]-k[0],h[1]-k[1]];a=a[0]*l[1]-a[1]*l[0];h=h[0]*k[1]-h[1]*k[0];k=1/(q[0]*p[1]-q[1]*p[0]);q=[(a*p[0]-h*q[0])*k,(a*p[1]-h*q[1])*k];q.isIntersection=!0;return q};var p;(function(h){h.clipLineString=(a,k)=>{const l=[];a=h.clipPolygon(a,k,!1);for(k=1;k<a.length;k++)a[k].isIntersection&&
a[k-1].isIntersection&&(l.push(a.splice(0,k)),k=0),k===a.length-1&&l.push(a);return l};h.clipPolygon=(l,h,p=!0)=>{let q=h[h.length-1],x,m,e=l;for(let t=0;t<h.length;t++){const g=e;l=h[t];e=[];x=p?g[g.length-1]:g[0];for(let d=0;d<g.length;d++)m=g[d],a(q,l,m)?(a(q,l,x)||e.push(k(q,l,x,m)),e.push(m)):a(q,l,x)&&e.push(k(q,l,x,m)),x=m;q=l}return e}})(p||(p={}));return p});A(a,"Maps/Projections/LambertConformalConic.js",[],function(){const a=Math.sign||(a=>0===a?0:0<a?1:-1),k=Math.PI/180,p=Math.PI/2;class w{constructor(l){var h,
t=(l.parallels||[]).map(a=>a*k);const q=t[0]||0;t=null!==(h=t[1])&&void 0!==h?h:q;h=Math.cos(q);"object"===typeof l.projectedBounds&&(this.projectedBounds=l.projectedBounds);l=q===t?Math.sin(q):Math.log(h/Math.cos(t))/Math.log(Math.tan((p+t)/2)/Math.tan((p+q)/2));1e-10>Math.abs(l)&&(l=1e-10*(a(l)||1));this.n=l;this.c=h*Math.pow(Math.tan((p+q)/2),l)/l}forward(a){var h=a[0]*k;const {c:l,n:q,projectedBounds:w}=this;a=a[1]*k;0<l?a<-p+.000001&&(a=-p+.000001):a>p-.000001&&(a=p-.000001);var m=l/Math.pow(Math.tan((p+
a)/2),q);a=m*Math.sin(q*h)*63.78137;h=63.78137*(l-m*Math.cos(q*h));m=[a,h];w&&(a<w.x1||a>w.x2||h<w.y1||h>w.y2)&&(m.outside=!0);return m}inverse(h){const l=h[0]/63.78137;h=h[1]/63.78137;const {c:w,n:q}=this;h=w-h;const v=a(q)*Math.sqrt(l*l+h*h);let m=Math.atan2(l,Math.abs(h))*a(h);0>h*q&&(m-=Math.PI*a(l)*a(h));return[m/q/k,(2*Math.atan(Math.pow(w/v,1/q))-p)/k]}}return w});A(a,"Maps/Projections/EqualEarth.js",[],function(){const a=Math.sqrt(3)/2;class k{constructor(){this.bounds={x1:-200.37508342789243,
x2:200.37508342789243,y1:-97.52595454902263,y2:97.52595454902263}}forward(h){const k=Math.PI/180,l=Math.asin(a*Math.sin(h[1]*k)),p=l*l,t=p*p*p;return[h[0]*k*Math.cos(l)*74.03120656864502/(a*(1.340264+3*-.081106*p+t*(7*.000893+.034164*p))),74.03120656864502*l*(1.340264+-.081106*p+t*(.000893+.003796*p))]}inverse(h){const k=h[0]/74.03120656864502;h=h[1]/74.03120656864502;const l=180/Math.PI;let p=h;let t;let q;for(q=0;12>q;++q){var v=p*p;t=v*v*v;var m=p*(1.340264+-.081106*v+t*(.000893+.003796*v))-h;
v=1.340264+3*-.081106*v+t*(7*.000893+.034164*v);p-=m/=v;if(1e-9>Math.abs(m))break}v=p*p;return[l*a*k*(1.340264+3*-.081106*v+v*v*v*(7*.000893+.034164*v))/Math.cos(p),l*Math.asin(Math.sin(p)/a)]}}return k});A(a,"Maps/Projections/Miller.js",[],function(){const a=Math.PI/4,k=Math.PI/180;class p{constructor(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-146.91480769173063,y2:146.91480769173063}}forward(h){return[h[0]*k*63.78137,79.7267125*Math.log(Math.tan(a+.4*h[1]*k))]}inverse(h){return[h[0]/
63.78137/k,2.5*(Math.atan(Math.exp(h[1]/63.78137*.8))-a)/k]}}return p});A(a,"Maps/Projections/Orthographic.js",[],function(){const a=Math.PI/180;class k{constructor(){this.antimeridianCutting=!1;this.bounds={x1:-63.78460826781007,x2:63.78460826781007,y1:-63.78460826781007,y2:63.78460826781007}}forward(h){const k=h[0];h=h[1]*a;h=[Math.cos(h)*Math.sin(k*a)*63.78460826781007,63.78460826781007*Math.sin(h)];if(-90>k||90<k)h.outside=!0;return h}inverse(h){const k=h[0]/63.78460826781007;h=h[1]/63.78460826781007;
const l=Math.sqrt(k*k+h*h),p=Math.asin(l),t=Math.sin(p);return[Math.atan2(k*t,l*Math.cos(p))/a,Math.asin(l&&h*t/l)/a]}}return k});A(a,"Maps/Projections/WebMercator.js",[],function(){const a=Math.PI/180;class k{constructor(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-200.3750834278071,y2:200.3750834278071};this.maxLatitude=85.0511287798}forward(h){var k=Math.sin(h[1]*a);k=[63.78137*h[0]*a,63.78137*Math.log((1+k)/(1-k))/2];85.0511287798<Math.abs(h[1])&&(k.outside=!0);return k}inverse(h){return[h[0]/
(63.78137*a),(2*Math.atan(Math.exp(h[1]/63.78137))-Math.PI/2)/a]}}return k});A(a,"Maps/Projections/ProjectionRegistry.js",[a["Maps/Projections/LambertConformalConic.js"],a["Maps/Projections/EqualEarth.js"],a["Maps/Projections/Miller.js"],a["Maps/Projections/Orthographic.js"],a["Maps/Projections/WebMercator.js"]],function(a,k,p,w,l){return{EqualEarth:k,LambertConformalConic:a,Miller:p,Orthographic:w,WebMercator:l}});A(a,"Maps/Projection.js",[a["Core/Geometry/PolygonClip.js"],a["Maps/Projections/ProjectionRegistry.js"],
a["Core/Utilities.js"]],function(a,k,p){const {clipLineString:h,clipPolygon:l}=a,{clamp:x,erase:t}=p,q=2*Math.PI/360,v=a=>{-180>a&&(a+=360);180<a&&(a-=360);return a};class m{static add(a,h){m.registry[a]=h}static greatCircle(a,h,g){const {atan2:d,cos:c,sin:b,sqrt:e}=Math,f=a[1]*q,z=a[0]*q,k=h[1]*q,m=h[0]*q;var r=k-f,y=m-z;r=b(r/2)*b(r/2)+c(f)*c(k)*b(y/2)*b(y/2);r=2*d(e(r),e(1-r));var l=Math.round(6371E3*r/5E5);y=[];g&&y.push(a);if(1<l)for(a=1/l,l=a;.999>l;l+=a){var u=b((1-l)*r)/b(r);const a=b(l*r)/
b(r);var E=u*c(f)*c(z)+a*c(k)*c(m);const g=u*c(f)*b(z)+a*c(k)*b(m);u=u*b(f)+a*b(k);u=d(u,e(E*E+g*g));E=d(g,E);y.push([E/q,u/q])}g&&y.push(h);return y}static insertGreatCircles(a){let e=a.length-1;for(;e--;)if(10<Math.max(Math.abs(a[e][0]-a[e+1][0]),Math.abs(a[e][1]-a[e+1][1]))){const g=m.greatCircle(a[e],a[e+1]);g.length&&a.splice(e+1,0,...g)}}static toString(a){const {name:e,rotation:g}=a||{};return[e,g&&g.join(",")].join(";")}constructor(a={}){this.hasGeoProjection=this.hasCoordinates=!1;this.maxLatitude=
90;this.options=a;const {name:e,projectedBounds:g,rotation:d}=a;this.rotator=d?this.getRotator(d):void 0;const c=e?m.registry[e]:void 0;c&&(this.def=new c(a));const {def:b,rotator:n}=this;b&&(this.maxLatitude=b.maxLatitude||90,this.hasGeoProjection=!0);n&&b?(this.forward=a=>b.forward(n.forward(a)),this.inverse=a=>n.inverse(b.inverse(a))):b?(this.forward=a=>b.forward(a),this.inverse=a=>b.inverse(a)):n&&(this.forward=n.forward,this.inverse=n.inverse);this.bounds="world"===g?b&&b.bounds:g}lineIntersectsBounds(a){const {x1:e,
x2:g,y1:d,y2:c}=this.bounds||{},b=(a,b,c)=>{const [d,f]=a;a=b?0:1;if("number"===typeof c&&d[b]>=c!==f[b]>=c)return a=d[a]+(c-d[b])/(f[b]-d[b])*(f[a]-d[a]),b?[a,c]:[c,a]};let n,f=a[0];if(n=b(a,0,e))f=n,a[1]=n;else if(n=b(a,0,g))f=n,a[1]=n;if(n=b(a,1,d))f=n;else if(n=b(a,1,c))f=n;return f}getRotator(a){const e=a[0]*q,g=(a[1]||0)*q;a=(a[2]||0)*q;const d=Math.cos(g),c=Math.sin(g),b=Math.cos(a),n=Math.sin(a);if(0!==e||0!==g||0!==a)return{forward:a=>{var f=a[0]*q+e,g=a[1]*q,h=Math.cos(g);a=Math.cos(f)*
h;f=Math.sin(f)*h;g=Math.sin(g);h=g*d+a*c;return[Math.atan2(f*b-h*n,a*d-g*c)/q,Math.asin(h*b+f*n)/q]},inverse:a=>{var f=a[0]*q,g=a[1]*q,h=Math.cos(g);a=Math.cos(f)*h;f=Math.sin(f)*h;g=Math.sin(g);h=g*b-f*n;return[(Math.atan2(f*b+g*n,a*d+h*c)-e)/q,Math.asin(h*d-a*c)/q]}}}forward(a){return a}inverse(a){return a}cutOnAntimeridian(a,h){const g=[],d=[a];a.forEach((b,c)=>{let d=a[c-1];if(!c){if(!h)return;d=a[a.length-1]}const f=d[0];var u=b[0];(-90>f||90<f)&&(-90>u||90<u)&&0<f!==0<u&&(u=x((180-(f+360)%
360)/((u+360)%360-(f+360)%360),0,1),g.push({i:c,lat:d[1]+u*(b[1]-d[1]),direction:0>f?1:-1,previousLonLat:d,lonLat:b}))});if(g.length)if(h){if(1===g.length%2){var c=g.slice().sort((a,b)=>Math.abs(b.lat)-Math.abs(a.lat))[0];t(g,c)}for(var b=g.length-2;0<=b;){var e=g[b].i,f=v(180+.000001*g[b].direction),k=v(180-.000001*g[b].direction);e=a.splice(e,g[b+1].i-e,...m.greatCircle([f,g[b].lat],[f,g[b+1].lat],!0));e.push(...m.greatCircle([k,g[b+1].lat],[k,g[b].lat],!0));d.push(e);b-=2}if(c)for(e=0;e<d.length;e++){const {direction:a,
lat:g}=c;b=d[e];k=b.indexOf(c.lonLat);if(-1<k){e=(0>g?-1:1)*this.maxLatitude;var l=v(180+.000001*a);f=v(180-.000001*a);const d=m.greatCircle([l,g],[l,e],!0);for(l+=120*a;-180<l&&180>l;l+=120*a)d.push([l,e]);d.push(...m.greatCircle([f,e],[f,c.lat],!0));b.splice(k,0,...d);break}}}else for(c=g.length;c--;)b=a.splice(g[c].i,a.length,[v(180+.000001*g[c].direction),g[c].lat]),b.unshift([v(180-.000001*g[c].direction),g[c].lat]),d.push(b);return d}path(a){const {bounds:e,def:g,rotator:d}=this,c=[],b="Polygon"===
a.type||"MultiPolygon"===a.type,n=this.hasGeoProjection,f=!g||!1!==g.antimeridianCutting,k=f?d:void 0,q=f?g||this:this;let p;e&&(p=[[e.x1,e.y1],[e.x2,e.y1],[e.x2,e.y2],[e.x1,e.y2]]);const r=a=>{a=a.map(a=>{if(f){k&&(a=k.forward(a));let b=a[0];.000001>Math.abs(b-180)&&(b=180>b?179.999999:180.000001);a=[b,a[1]]}return a});let d=[a];n&&(m.insertGreatCircles(a),f&&(d=this.cutOnAntimeridian(a,b)));d.forEach(a=>{if(!(2>a.length)){var d=!1,u=!1,g=a=>{d?c.push(["L",a[0],a[1]]):(c.push(["M",a[0],a[1]]),d=
!0)},k=!1,r=!1,z=a.map(a=>{a=q.forward(a);a.outside?k=!0:r=!0;Infinity===a[1]?a[1]=1E10:-Infinity===a[1]&&(a[1]=-1E10);return a});if(f){b&&z.push(z[0]);if(k){if(!r)return;if(p)if(b)z=l(z,p);else if(e){h(z,p).forEach(a=>{d=!1;a.forEach(g)});return}}z.forEach(g)}else for(let c=0;c<z.length;c++){const f=a[c],e=z[c];if(e.outside)u=!0;else{if(b&&!y){var y=f;a.push(f);z.push(e)}u&&C&&(b&&n?m.greatCircle(C,f).forEach(a=>g(q.forward(a))):d=!1);g(e);var C=f;u=!1}}}})};"LineString"===a.type?r(a.coordinates):
"MultiLineString"===a.type?a.coordinates.forEach(a=>r(a)):"Polygon"===a.type?(a.coordinates.forEach(a=>r(a)),c.length&&c.push(["Z"])):"MultiPolygon"===a.type&&(a.coordinates.forEach(a=>{a.forEach(a=>r(a))}),c.length&&c.push(["Z"]));return c}}m.registry=k;return m});A(a,"Maps/MapView.js",[a["Maps/MapViewOptionsDefault.js"],a["Maps/MapViewInsetsOptionsDefault.js"],a["Extensions/GeoJSON.js"],a["Core/Chart/MapChart.js"],a["Maps/MapUtilities.js"],a["Maps/Projection.js"],a["Core/Utilities.js"]],function(a,
k,p,w,l,x,t){const {topo2geo:h}=p,{maps:v}=w,{boundsFromPath:m,pointInPolygon:e}=l,{addEvent:B,clamp:g,fireEvent:d,isArray:c,isNumber:b,isObject:n,isString:f,merge:z,pick:C,relativeLength:D}=t,r=(a,b)=>{const {width:c,height:d}=b;return Math.log(400.979322/Math.max((a.x2-a.x1)/(c/256),(a.y2-a.y1)/(d/256)))/Math.log(2)};class y{static mergeInsets(a,b){const c=a=>{const b={};a.forEach((a,c)=>{b[a&&a.id||`i${c}`]=a});return b},d=z(c(a),c(b));return Object.keys(d).map(a=>d[a])}createInsets(){const a=
this.options,b=a.insets;b&&b.forEach(b=>{b=new I(this,z(a.insetOptions,b));this.insets.push(b)})}constructor(c,d){this.allowTransformAnimation=!0;this.insets=[];this.padding=[0,0,0,0];this.eventsToUnbind=[];let f;if(!(this instanceof I)){var u=[c.options.chart.map,...(c.options.series||[]).map(a=>a.mapData)].map(a=>this.getGeoMap(a));const a=[];u.forEach(b=>{if(b&&(f||(f=b["hc-recommended-mapview"]),b.bbox)){const [c,d,f,u]=b.bbox;a.push({x1:c,y1:d,x2:f,y2:u})}});const b=a.length&&y.compositeBounds(a);
if(b){const {x1:a,y1:c,x2:d,y2:f}=b;var e=180<d-a&&90<f-c?{name:"EqualEarth"}:{name:"LambertConformalConic",parallels:[c,f],rotation:[-(a+d)/2]}}this.geoMap=u[0]}this.userOptions=d||{};e=z(a,{projection:e},f,d);u=f&&f.insets;d=d&&d.insets;u&&d&&(e.insets=y.mergeInsets(u,d));this.chart=c;this.center=e.center;this.options=e;this.projection=new x(e.projection);this.playingField=c.plotBox;this.zoom=e.zoom||0;this.createInsets();this.eventsToUnbind.push(B(c,"afterSetChartSize",()=>{this.playingField=this.getField();
if(void 0===this.minZoom||this.minZoom===this.zoom)this.fitToBounds(void 0,void 0,!1),!this.chart.hasRendered&&b(this.userOptions.zoom)&&(this.zoom=this.userOptions.zoom),this.userOptions.center&&z(!0,this.center,this.userOptions.center)}));this.setUpEvents()}fitToBounds(a,b,d=!0,f){const u=a||this.getProjectedBounds();if(u){var e=C(b,a?0:this.options.padding);b=this.getField(!1);e=c(e)?e:[e,e,e,e];this.padding=[D(e[0],b.height),D(e[1],b.width),D(e[2],b.height),D(e[3],b.width)];this.playingField=
this.getField();b=r(u,this.playingField);a||(this.minZoom=b);a=this.projection.inverse([(u.x2+u.x1)/2,(u.y2+u.y1)/2]);this.setView(a,b,d,f)}}getField(a=!0){a=a?this.padding:[0,0,0,0];return{x:a[3],y:a[0],width:this.chart.plotWidth-a[1]-a[3],height:this.chart.plotHeight-a[0]-a[2]}}getGeoMap(a){if(f(a))return v[a]&&"Topology"===v[a].type?h(v[a]):v[a];if(n(a,!0)){if("FeatureCollection"===a.type)return a;if("Topology"===a.type)return h(a)}}getMapBBox(){const a=this.getProjectedBounds(),b=this.getScale();
if(a){const c=this.padding,d=this.projectedUnitsToPixels({x:a.x1,y:a.y2});return{width:(a.x2-a.x1)*b+c[1]+c[3],height:(a.y2-a.y1)*b+c[0]+c[2],x:d.x-c[3],y:d.y-c[0]}}}getProjectedBounds(){const a=this.projection;var b=this.chart.series.reduce((a,b)=>{const c=b.getProjectedBounds&&b.getProjectedBounds();c&&!1!==b.options.affectsMapView&&a.push(c);return a},[]),c=this.options.fitToGeometry;return c?(this.fitToGeometryCache||("MultiPoint"===c.type?(c=c.coordinates.map(b=>a.forward(b)),b=c.map(a=>a[0]),
c=c.map(a=>a[1]),this.fitToGeometryCache={x1:Math.min.apply(0,b),x2:Math.max.apply(0,b),y1:Math.min.apply(0,c),y2:Math.max.apply(0,c)}):this.fitToGeometryCache=m(a.path(c))),this.fitToGeometryCache):this.projection.bounds||y.compositeBounds(b)}getScale(){return 256/400.979322*Math.pow(2,this.zoom)}getSVGTransform(){const {x:a,y:b,width:c,height:d}=this.playingField,f=this.projection.forward(this.center);var e=this.projection.hasCoordinates?-1:1;const g=this.getScale();e*=g;return{scaleX:g,scaleY:e,
translateX:a+c/2-f[0]*g,translateY:b+d/2-f[1]*e}}lonLatToPixels(a){if(a=this.lonLatToProjectedUnits(a))return this.projectedUnitsToPixels(a)}lonLatToProjectedUnits(a){const b=this.chart,c=b.mapTransforms;if(c){for(const f in c)if(Object.hasOwnProperty.call(c,f)&&c[f].hitZone){var d=b.transformFromLatLon(a,c[f]);if(d&&e(d,c[f].hitZone.coordinates[0]))return d}return b.transformFromLatLon(a,c["default"])}for(d of this.insets)if(d.options.geoBounds&&e({x:a.lon,y:a.lat},d.options.geoBounds.coordinates[0]))return a=
d.projection.forward([a.lon,a.lat]),a=d.projectedUnitsToPixels({x:a[0],y:a[1]}),this.pixelsToProjectedUnits(a);a=this.projection.forward([a.lon,a.lat]);if(!a.outside)return{x:a[0],y:a[1]}}projectedUnitsToLonLat(a){var b=this.chart;const c=b.mapTransforms;if(c){for(const d in c)if(Object.hasOwnProperty.call(c,d)&&c[d].hitZone&&e(a,c[d].hitZone.coordinates[0]))return b.transformToLatLon(a,c[d]);return b.transformToLatLon(a,c["default"])}b=this.projectedUnitsToPixels(a);for(var d of this.insets)if(d.hitZone&&
e(b,d.hitZone.coordinates[0]))return a=d.pixelsToProjectedUnits(b),d=d.projection.inverse([a.x,a.y]),{lon:d[0],lat:d[1]};d=this.projection.inverse([a.x,a.y]);return{lon:d[0],lat:d[1]}}redraw(a){this.chart.series.forEach(a=>{a.useMapGeometry&&(a.isDirty=!0)});this.chart.redraw(a)}setView(a,c,f=!0,e){a&&(this.center=a);"number"===typeof c&&("number"===typeof this.minZoom&&(c=Math.max(c,this.minZoom)),"number"===typeof this.options.maxZoom&&(c=Math.min(c,this.options.maxZoom)),b(c)&&(this.zoom=c));var g=
this.getProjectedBounds();if(g){a=this.projection.forward(this.center);const {x:b,y:d,width:f,height:e}=this.playingField;c=this.getScale();var h=this.projectedUnitsToPixels({x:g.x1,y:g.y1}),n=this.projectedUnitsToPixels({x:g.x2,y:g.y2});g=[(g.x1+g.x2)/2,(g.y1+g.y2)/2];if(!this.chart.series.some(a=>a.isDrilling)){const u=h.x,k=n.y;n=n.x;h=h.y;n-u<f?a[0]=g[0]:u<b&&n<b+f?a[0]+=Math.max(u-b,n-f-b)/c:n>b+f&&u>b&&(a[0]+=Math.min(n-f-b,u-b)/c);h-k<e?a[1]=g[1]:k<d&&h<d+e?a[1]-=Math.max(k-d,h-e-d)/c:h>d+
e&&k>d&&(a[1]-=Math.min(h-e-d,k-d)/c);this.center=this.projection.inverse(a)}this.insets.forEach(a=>{a.options.field&&(a.hitZone=a.getHitZone(),a.playingField=a.getField())});this.render()}d(this,"afterSetView");f&&this.redraw(e)}projectedUnitsToPixels(a){const b=this.getScale(),c=this.projection.forward(this.center),d=this.playingField;return{x:d.x+d.width/2-b*(c[0]-a.x),y:d.y+d.height/2+b*(c[1]-a.y)}}pixelsToLonLat(a){return this.projectedUnitsToLonLat(this.pixelsToProjectedUnits(a))}pixelsToProjectedUnits(a){const {x:b,
y:c}=a;a=this.getScale();const d=this.projection.forward(this.center),f=this.playingField;return{x:d[0]+(b-(f.x+f.width/2))/a,y:d[1]-(c-(f.y+f.height/2))/a}}setUpEvents(){const {chart:a}=this;let c,d,f;const e=e=>{var h=a.pointer.pinchDown,n=this.projection;let {mouseDownX:k,mouseDownY:u}=a;1===h.length&&(k=h[0].chartX,u=h[0].chartY);if("number"===typeof k&&"number"===typeof u){h=`${k},${u}`;const {chartX:l,chartY:m}=e.originalEvent;h!==d&&(d=h,c=this.projection.forward(this.center),f=(this.projection.options.rotation||
[0,0]).slice());h=(h=n.def&&n.def.bounds)&&r(h,this.playingField)||-Infinity;if("Orthographic"===n.options.name&&(this.minZoom||Infinity)<1.3*h){if(h=440/(this.getScale()*Math.min(a.plotWidth,a.plotHeight)),f){n=(k-l)*h-f[0];h=g(-f[1]-(u-m)*h,-80,80);const b=this.zoom;this.update({projection:{rotation:[-n,-h]}},!1);this.fitToBounds(void 0,void 0,!1);this.zoom=b;a.redraw(!1)}}else b(l)&&b(m)&&(n=this.getScale(),n=this.projection.inverse([c[0]+(k-l)/n,c[1]-(u-m)/n*(this.projection.hasCoordinates?1:
-1)]),this.setView(n,void 0,!0,!1));e.preventDefault()}};B(a,"pan",e);B(a,"touchpan",e);B(a,"selection",b=>{if(b.resetSelection)this.zoomBy();else{const c=b.x-a.plotLeft,d=b.y-a.plotTop,{y:f,x:e}=this.pixelsToProjectedUnits({x:c,y:d}),{y:g,x:h}=this.pixelsToProjectedUnits({x:c+b.width,y:d+b.height});this.fitToBounds({x1:e,y1:f,x2:h,y2:g},void 0,!0,b.originalEvent.touches?!1:void 0);/^touch/.test(b.originalEvent.type)||a.showResetZoom();b.preventDefault()}})}render(){this.group||(this.group=this.chart.renderer.g("map-view").attr({zIndex:4}).add())}update(a,
c=!0,d){var f=a.projection;f=f&&x.toString(f)!==x.toString(this.options.projection);let e=!1;z(!0,this.userOptions,a);z(!0,this.options,a);"insets"in a&&(this.insets.forEach(a=>a.destroy()),this.insets.length=0,e=!0);(f||"fitToGeometry"in a)&&delete this.fitToGeometryCache;if(f||e)this.chart.series.forEach(a=>{const b=a.transformGroups;a.clearBounds&&a.clearBounds();a.isDirty=!0;a.isDirtyData=!0;if(e&&b)for(;1<b.length;)(a=b.pop())&&a.destroy()}),f&&(this.projection=new x(this.options.projection)),
e&&this.createInsets(),a.center||!Object.hasOwnProperty.call(a,"zoom")||b(a.zoom)||this.fitToBounds(void 0,void 0,!1);a.center||b(a.zoom)?this.setView(this.options.center,a.zoom,!1):"fitToGeometry"in a&&this.fitToBounds(void 0,void 0,!1);c&&this.chart.redraw(d)}zoomBy(a,b,c,d){var f=this.chart;const e=this.projection.forward(this.center);let [g,h]=b?this.projection.forward(b):[];if("number"===typeof a){a=this.zoom+a;if(c){const [a,d]=c;c=this.getScale();b=d-f.plotTop-f.plotHeight/2;g=e[0]+(a-f.plotLeft-
f.plotWidth/2)/c;h=e[1]+b/c}if("number"===typeof g&&"number"===typeof h){f=1-Math.pow(2,this.zoom)/Math.pow(2,a);var n=e[1]-h;e[0]-=(e[0]-g)*f;e[1]+=n*f;n=this.projection.inverse(e)}this.setView(n,a,void 0,d)}else this.fitToBounds(void 0,void 0,void 0,d)}}y.compositeBounds=a=>{if(a.length)return a.slice(1).reduce((a,b)=>{a.x1=Math.min(a.x1,b.x1);a.y1=Math.min(a.y1,b.y1);a.x2=Math.max(a.x2,b.x2);a.y2=Math.max(a.y2,b.y2);return a},z(a[0]))};class I extends y{constructor(a,b){super(a.chart,b);this.id=
b.id;this.mapView=a;this.options=z(k,b);this.allBounds=[];this.options.geoBounds&&(a=a.projection.path(this.options.geoBounds),this.geoBoundsProjectedBox=m(a),this.geoBoundsProjectedPolygon=a.map(a=>[a[1]||0,a[2]||0]))}getField(a=!0){var c=this.hitZone;if(c){var d=a?this.padding:[0,0,0,0];c=c.coordinates[0];var f=c.map(a=>a[0]);const e=c.map(a=>a[1]);c=Math.min.apply(0,f)+d[3];f=Math.max.apply(0,f)-d[1];const g=Math.min.apply(0,e)+d[0];d=Math.max.apply(0,e)-d[2];if(b(c)&&b(g))return{x:c,y:g,width:f-
c,height:d-g}}return super.getField.call(this,a)}getHitZone(){const {chart:a,mapView:b,options:c}=this;var {coordinates:d}=c.field||{};if(d){d=d[0];if("percent"===c.units){const f="mapBoundingBox"===c.relativeTo&&b.getMapBBox()||z(a.plotBox,{x:0,y:0});d=d.map(a=>[D(`${a[0]}%`,f.width,f.x),D(`${a[1]}%`,f.height,f.y)])}return{type:"Polygon",coordinates:[d]}}}getProjectedBounds(){return y.compositeBounds(this.allBounds)}isInside(a){const {geoBoundsProjectedBox:b,geoBoundsProjectedPolygon:c}=this;return!!(b&&
a.x>=b.x1&&a.x<=b.x2&&a.y>=b.y1&&a.y<=b.y2&&c&&e(a,c))}render(){const {chart:a,mapView:b,options:c}=this;var d=c.borderPath||c.field;if(d&&b.group){let f=!0;this.border||(this.border=a.renderer.path().addClass("highcharts-mapview-inset-border").add(b.group),f=!1);a.styledMode||this.border.attr({stroke:c.borderColor,"stroke-width":c.borderWidth});const e=Math.round(this.border.strokeWidth())%2/2,g="mapBoundingBox"===c.relativeTo&&b.getMapBBox()||b.playingField;d=(d.coordinates||[]).reduce((b,d)=>d.reduce((b,
d,f)=>{let [h,n]=d;"percent"===c.units&&(h=a.plotLeft+D(`${h}%`,g.width,g.x),n=a.plotTop+D(`${n}%`,g.height,g.y));h=Math.floor(h)+e;n=Math.floor(n)+e;b.push(0===f?["M",h,n]:["L",h,n]);return b},b),[]);this.border[f?"animate":"attr"]({d})}}destroy(){this.border&&(this.border=this.border.destroy());this.eventsToUnbind.forEach(a=>a())}setUpEvents(){}}B(w,"afterInit",function(){this.mapView=new y(this,this.options.mapView)});return y});A(a,"Series/Map/MapSeries.js",[a["Core/Animation/AnimationUtilities.js"],
a["Series/ColorMapComposition.js"],a["Series/CenteredUtilities.js"],a["Core/Globals.js"],a["Core/Legend/LegendSymbol.js"],a["Core/Chart/MapChart.js"],a["Series/Map/MapPoint.js"],a["Maps/MapView.js"],a["Core/Series/Series.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,k,p,w,l,x,t,q,v,m,e,B){const {animObject:g}=a;({noop:a}=w);const {splitPath:d}=x,{seriesTypes:{column:c,scatter:b}}=m,{extend:h,find:f,fireEvent:z,getNestedProperty:C,
isArray:D,defined:r,isNumber:y,isObject:I,merge:u,objectEach:E,pick:F,splat:A}=B;class G extends b{constructor(){super(...arguments);this.points=this.options=this.joinBy=this.group=this.data=this.chart=void 0;this.processedData=[]}animate(a){const {chart:b,group:c}=this,d=g(this.options.animation);a?c.attr({translateX:b.plotLeft+b.plotWidth/2,translateY:b.plotTop+b.plotHeight/2,scaleX:.001,scaleY:.001}):c.animate({translateX:b.plotLeft,translateY:b.plotTop,scaleX:1,scaleY:1},d)}clearBounds(){this.points.forEach(a=>
{delete a.bounds;delete a.insetIndex;delete a.projectedPath});delete this.bounds}doFullTranslate(){return!(!this.isDirtyData&&!this.chart.isResizing&&this.hasRendered)}drawMapDataLabels(){v.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)}drawPoints(){const a=this,{chart:b,group:d,transformGroups:f=[]}=this,{mapView:e,renderer:g}=b;e&&(this.transformGroups=f,f[0]||(f[0]=g.g().add(d)),e.insets.forEach((a,b)=>{f[b+1]||f.push(g.g().add(d))}),this.doFullTranslate()&&
(this.points.forEach(a=>{const {graphic:c,shapeArgs:d}=a;a.group=f["number"===typeof a.insetIndex?a.insetIndex+1:0];c&&c.parentGroup!==a.group&&c.add(a.group);d&&b.hasRendered&&!b.styledMode&&(d.fill=this.pointAttribs(a,a.state).fill)}),c.prototype.drawPoints.apply(this),this.points.forEach(c=>{const d=c.graphic;if(d){const f=d.animate;let e="";c.name&&(e+="highcharts-name-"+c.name.replace(/ /g,"-").toLowerCase());c.properties&&c.properties["hc-key"]&&(e+=" highcharts-key-"+c.properties["hc-key"].toString().toLowerCase());
e&&d.addClass(e);b.styledMode&&d.css(this.pointAttribs(c,c.selected&&"select"||void 0));d.animate=function(c,e,g){const h=y(c["stroke-width"])&&!y(d["stroke-width"]),n=y(d["stroke-width"])&&!y(c["stroke-width"]);if(h||n){const f=F(a.getStrokeWidth(a.options),1)/(b.mapView&&b.mapView.getScale()||1);h&&(d["stroke-width"]=f);n&&(c["stroke-width"]=f)}return f.call(d,c,e,n?function(){d.element.removeAttribute("stroke-width");delete d["stroke-width"];g&&g.apply(this,arguments)}:g)}}})),f.forEach((c,d)=>
{const f=(0===d?e:e.insets[d-1]).getSVGTransform(),h=F(this.getStrokeWidth(this.options),1),n=f.scaleX,k=0<f.scaleY?1:-1,r=b=>{(a.points||[]).forEach(a=>{const c=a.graphic;let d;c&&c["stroke-width"]&&(d=this.getStrokeWidth(a.options))&&c.attr({"stroke-width":d/b})})};if(g.globalAnimation&&b.hasRendered&&e.allowTransformAnimation){const a=Number(c.attr("translateX")),e=Number(c.attr("translateY")),l=Number(c.attr("scaleX")),m=(b,d)=>{b=l+(n-l)*d.pos;c.attr({translateX:a+(f.translateX-a)*d.pos,translateY:e+
(f.translateY-e)*d.pos,scaleX:b,scaleY:b*k,"stroke-width":h/b});r(b)};d={};b.options.chart&&(d=u({},b.options.chart.animation));if("boolean"!==typeof d){const a=d.step;d.step=function(b){a&&a.apply(this,arguments);m.apply(this,arguments)}}c.attr({animator:0}).animate({animator:1},d,function(){"boolean"!==typeof g.globalAnimation&&g.globalAnimation.complete&&g.globalAnimation.complete({applyDrilldown:!0})})}else c.attr(u(f,{"stroke-width":h/n})),r(n)}),this.isDrilling||this.drawMapDataLabels())}getProjectedBounds(){if(!this.bounds&&
this.chart.mapView){const {insets:a,projection:b}=this.chart.mapView,c=[];(this.points||[]).forEach(function(g){if(g.path||g.geometry){"string"===typeof g.path?g.path=d(g.path):D(g.path)&&"M"===g.path[0]&&(g.path=e.prototype.pathToSegments(g.path));if(!g.bounds){let c=g.getProjectedBounds(b);if(c){g.labelrank=F(g.labelrank,(c.x2-c.x1)*(c.y2-c.y1));const {midX:b,midY:d}=c;if(a&&y(b)&&y(d)){const e=f(a,a=>a.isInside({x:b,y:d}));e&&(delete g.projectedPath,(c=g.getProjectedBounds(e.projection))&&e.allBounds.push(c),
g.insetIndex=a.indexOf(e))}g.bounds=c}}g.bounds&&void 0===g.insetIndex&&c.push(g.bounds)}});this.bounds=q.compositeBounds(c)}return this.bounds}getStrokeWidth(a){const b=this.pointAttrToOptions;return a[b&&b["stroke-width"]||"borderWidth"]}hasData(){return!!this.processedXData.length}pointAttribs(a,b){var d;const {mapView:f,styledMode:e}=a.series.chart,g=e?this.colorAttribs(a):c.prototype.pointAttribs.call(this,a,b);let h=this.getStrokeWidth(a.options);if(b){b=u(this.options.states[b],a.options.states&&
a.options.states[b]||{});const c=this.getStrokeWidth(b);r(c)&&(h=c);g.stroke=null!==(d=b.borderColor)&&void 0!==d?d:a.color}h&&f&&(h/=f.getScale());d=this.getStrokeWidth(this.options);g.dashstyle&&f&&y(d)&&(h=d/f.getScale());a.visible||(g.fill=this.options.nullColor);r(h)?g["stroke-width"]=h:delete g["stroke-width"];g["stroke-linecap"]=g["stroke-linejoin"]=this.options.linecap;return g}updateData(){return this.processedData?!1:super.updateData.apply(this,arguments)}setData(a,b=!0,c,d){delete this.bounds;
super.setData.call(this,a,!1,void 0,d);this.processData();this.generatePoints();b&&this.chart.redraw(c)}processData(){const a=this.options,b=a.data;var c=this.chart.options.chart;const d=this.joinBy,f=a.keys||this.pointArrayMap,e=[],g={};var h=this.chart.mapView;h=h&&(I(a.mapData,!0)?h.getGeoMap(a.mapData):h.geoMap);var n=this.chart.mapTransforms;(this.chart.mapTransforms=n=c.mapTransforms||h&&h["hc-transform"]||n)&&E(n,function(a){a.rotation&&(a.cosAngle=Math.cos(a.rotation),a.sinAngle=Math.sin(a.rotation))});
let k;D(a.mapData)?k=a.mapData:h&&"FeatureCollection"===h.type&&(this.mapTitle=h.title,k=w.geojson(h,this.type,this));const r=this.processedData=[];b&&b.forEach(function(c,e){let g=0;if(y(c))r[e]={value:c};else if(D(c)){r[e]={};!a.keys&&c.length>f.length&&"string"===typeof c[0]&&(r[e]["hc-key"]=c[0],++g);for(let a=0;a<f.length;++a,++g)f[a]&&"undefined"!==typeof c[g]&&(0<f[a].indexOf(".")?t.prototype.setNestedProperty(r[e],c[g],f[a]):r[e][f[a]]=c[g])}else r[e]=b[e];d&&"_i"===d[0]&&(r[e]._i=e)});if(k){this.mapData=
k;this.mapMap={};for(n=0;n<k.length;n++)c=k[n],h=c.properties,c._i=n,d[0]&&h&&h[d[0]]&&(c[d[0]]=h[d[0]]),g[c[d[0]]]=c;this.mapMap=g;if(d[1]){const a=d[1];r.forEach(function(b){b=C(a,b);g[b]&&e.push(g[b])})}if(a.allAreas){if(d[1]){const a=d[1];r.forEach(function(b){e.push(C(a,b))})}const a="|"+e.map(function(a){return a&&a[d[0]]}).join("|")+"|";k.forEach(function(b){d[0]&&-1!==a.indexOf("|"+b[d[0]]+"|")||r.push(u(b,{value:null}))})}}this.processedXData=Array(r.length)}setOptions(a){a=v.prototype.setOptions.call(this,
a);let b=a.joinBy;null===b&&(b="_i");b=this.joinBy=A(b);b[1]||(b[1]=b[0]);return a}translate(){const a=this.doFullTranslate(),b=this.chart.mapView,c=b&&b.projection;!this.chart.hasRendered||!this.isDirtyData&&this.hasRendered||(this.processData(),this.generatePoints(),delete this.bounds,!b||b.userOptions.center||y(b.userOptions.zoom)||b.zoom!==b.minZoom?this.getProjectedBounds():b.fitToBounds(void 0,void 0,!1));if(b){const d=b.getSVGTransform();this.points.forEach(function(f){const e=y(f.insetIndex)&&
b.insets[f.insetIndex].getSVGTransform()||d;e&&f.bounds&&y(f.bounds.midX)&&y(f.bounds.midY)&&(f.plotX=f.bounds.midX*e.scaleX+e.translateX,f.plotY=f.bounds.midY*e.scaleY+e.translateY);a&&(f.shapeType="path",f.shapeArgs={d:t.getProjectedPath(f,c)});f.projectedPath&&!f.projectedPath.length?f.setVisible(!1):f.setVisible(!0)})}z(this,"afterTranslate")}}G.defaultOptions=u(b.defaultOptions,{affectsMapView:!0,animation:!1,dataLabels:{crop:!1,formatter:function(){const {numberFormatter:a}=this.series.chart,
{value:b}=this.point;return y(b)?a(b,-1):""},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},linecap:"round",marker:null,nullColor:"#f7f7f7",stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:"#e6e6e6",borderWidth:1,joinBy:"hc-key",states:{hover:{halo:void 0,borderColor:"#666666",borderWidth:2},normal:{animation:!0},select:{color:"#cccccc"}}});h(G.prototype,{type:"map",axisTypes:k.seriesMembers.axisTypes,colorAttribs:k.seriesMembers.colorAttribs,
colorKey:k.seriesMembers.colorKey,directTouch:!0,drawDataLabels:a,drawGraph:a,drawLegendSymbol:l.drawRectangle,forceDL:!0,getCenter:p.getCenter,getExtremesFromAll:!0,getSymbol:a,isCartesian:!1,parallelArrays:k.seriesMembers.parallelArrays,pointArrayMap:k.seriesMembers.pointArrayMap,pointClass:t,preserveAspectRatio:!0,searchPoint:a,trackerGroups:k.seriesMembers.trackerGroups,useMapGeometry:!0});k.compose(G);m.registerSeriesType("map",G);"";return G});A(a,"Series/MapLine/MapLineSeries.js",[a["Series/Map/MapSeries.js"],
a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,k,p){const {series:h}=k,{extend:l,merge:x}=p;class t extends a{constructor(){super(...arguments);this.points=this.options=this.data=void 0}pointAttribs(h,k){h=a.prototype.pointAttribs.call(this,h,k);h.fill=this.options.fillColor;return h}}t.defaultOptions=x(a.defaultOptions,{lineWidth:1,fillColor:"none"});l(t.prototype,{type:"mapline",colorProp:"stroke",drawLegendSymbol:h.prototype.drawLegendSymbol,pointAttrToOptions:{stroke:"color",
"stroke-width":"lineWidth"}});k.registerSeriesType("mapline",t);"";return t});A(a,"Series/MapPoint/MapPointPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,k){({seriesTypes:{scatter:a}}=a);const {isNumber:h}=k;class w extends a.prototype.pointClass{constructor(){super(...arguments);this.series=this.options=void 0}isValid(){return!!(this.options.geometry||h(this.x)&&h(this.y)||h(this.options.lon)&&h(this.options.lat))}}return w});A(a,"Series/MapPoint/MapPointSeries.js",
[a["Core/Globals.js"],a["Series/MapPoint/MapPointPoint.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,k,p,w,l){({noop:a}=a);const {seriesTypes:{map:h,scatter:t}}=p,{extend:q,fireEvent:v,isNumber:m,merge:e}=l;class B extends t{constructor(){super(...arguments);this.points=this.options=this.data=this.chart=void 0;this.clearBounds=h.prototype.clearBounds}drawDataLabels(){super.drawDataLabels();this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)}projectPoint(a){const d=
this.chart.mapView;if(d){const {geometry:c,lon:b,lat:e}=a;a=c&&"Point"===c.type&&c.coordinates;m(b)&&m(e)&&(a=[b,e]);if(a)return d.lonLatToProjectedUnits({lon:a[0],lat:a[1]})}}translate(){const a=this.chart.mapView;this.processedXData||this.processData();this.generatePoints();this.getProjectedBounds&&this.isDirtyData&&(delete this.bounds,this.getProjectedBounds());if(a){const d=a.getSVGTransform(),{hasCoordinates:c}=a.projection;this.points.forEach(b=>{let {x:e,y:f}=b;var g=m(b.insetIndex)&&a.insets[b.insetIndex].getSVGTransform()||
d;const h=this.projectPoint(b.options)||b.properties&&this.projectPoint(b.properties);let k;h?(e=h.x,f=h.y):b.bounds&&(e=b.bounds.midX,f=b.bounds.midY,g&&m(e)&&m(f)&&(b.plotX=e*g.scaleX+g.translateX,b.plotY=f*g.scaleY+g.translateY,k=!0));m(e)&&m(f)?k||(g=a.projectedUnitsToPixels({x:e,y:f}),b.plotX=g.x,b.plotY=c?g.y:this.chart.plotHeight-g.y):b.y=b.plotX=b.plotY=void 0;b.isInside=this.isPointInside(b);b.zone=this.zones.length?b.getZone():void 0})}v(this,"afterTranslate")}}B.defaultOptions=e(t.defaultOptions,
{dataLabels:{crop:!1,defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:"#000000"}}});w.prototype.symbols.mapmarker=(a,d,c,b,e)=>{const f=e&&"legend"===e.context;f?(a+=c/2,e=d+b):e&&"number"===typeof e.anchorX&&"number"===typeof e.anchorY?(a=e.anchorX,e=e.anchorY):(a+=c/2,e=d+b/2,d-=b);b=f?b/3:b/2;return[["M",a,e],["C",a,e,a-b,d+1.5*b,a-b,d+b],["A",b,b,1,1,1,a+b,d+b],["C",a+b,d+1.5*b,a,e,a,e],["Z"]]};q(B.prototype,{type:"mappoint",axisTypes:["colorAxis"],forceDL:!0,
isCartesian:!1,pointClass:k,searchPoint:a,useMapGeometry:!0});p.registerSeriesType("mappoint",B);"";return B});A(a,"Series/Bubble/BubbleLegendDefaults.js",[],function(){return{borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"0.7em",color:"#000000"},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,
ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}});A(a,"Series/Bubble/BubbleLegendItem.js",[a["Core/Color/Color.js"],a["Core/FormatUtilities.js"],a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,k,p,w){const {parse:h}=a,{noop:x}=p,{arrayMax:t,arrayMin:q,isNumber:v,merge:m,pick:e,stableSort:B}=w;class g{constructor(a,c){this.options=this.symbols=this.visible=this.selected=this.ranges=this.movementX=this.maxLabel=
this.legend=this.chart=void 0;this.setState=x;this.init(a,c)}init(a,c){this.options=a;this.visible=!0;this.chart=c.chart;this.legend=c}addToLegend(a){a.splice(this.options.legendIndex,0,this)}drawLegendSymbol(a){const c=e(a.options.itemDistance,20),b=this.legendItem||{},d=this.options;var f=d.ranges,g=d.connectorDistance;if(f&&f.length&&v(f[0].value)){B(f,function(a,b){return b.value-a.value});this.ranges=f;this.setOptions();this.render();a=this.getMaxLabelSize();var h=this.ranges[0].radius;f=2*h;
g=g-h+a.width;g=0<g?g:0;this.maxLabel=a;this.movementX="left"===d.labels.align?g:0;b.labelWidth=f+g+c;b.labelHeight=f+a.height/2}else a.options.bubbleLegend.autoRanges=!0}setOptions(){const a=this.ranges,c=this.options,b=this.chart.series[c.seriesIndex],g=this.legend.baseline,f={zIndex:c.zIndex,"stroke-width":c.borderWidth},k={zIndex:c.zIndex,"stroke-width":c.connectorWidth},l={align:this.legend.options.rtl||"left"===c.labels.align?"right":"left",zIndex:c.zIndex},q=b.options.marker.fillOpacity,r=
this.chart.styledMode;a.forEach(function(d,n){r||(f.stroke=e(d.borderColor,c.borderColor,b.color),f.fill=e(d.color,c.color,1!==q?h(b.color).setOpacity(q).get("rgba"):b.color),k.stroke=e(d.connectorColor,c.connectorColor,b.color));a[n].radius=this.getRangeRadius(d.value);a[n]=m(a[n],{center:a[0].radius-a[n].radius+g});r||m(!0,a[n],{bubbleAttribs:m(f),connectorAttribs:m(k),labelAttribs:l})},this)}getRangeRadius(a){const c=this.options;return this.chart.series[this.options.seriesIndex].getRadius.call(this,
c.ranges[c.ranges.length-1].value,c.ranges[0].value,c.minSize,c.maxSize,a)}render(){const a=this.legendItem||{},c=this.chart.renderer,b=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]});a.symbol=c.g("bubble-legend");a.label=c.g("bubble-legend-item");a.symbol.translateX=0;a.symbol.translateY=0;a.symbol.add(a.label);a.label.add(a.group);for(const a of this.ranges)a.value>=b&&this.renderRange(a);this.hideOverlappingLabels()}renderRange(a){var c=this.options;
const b=c.labels;var d=this.chart;const f=d.series[c.seriesIndex],e=d.renderer,g=this.symbols;d=g.labels;const h=a.center,k=Math.abs(a.radius);var l=c.connectorDistance||0;const m=b.align,q=c.connectorWidth,p=this.ranges[0].radius||0,t=h-k-c.borderWidth/2+q/2,v=e.styledMode;l=this.legend.options.rtl||"left"===m?-l:l;"center"===m&&(l=0,c.connectorDistance=0,a.labelAttribs.align="center");g.bubbleItems.push(e.circle(p,h+((t%1?1:.5)-(q%2?0:.5)),k).attr(v?{}:a.bubbleAttribs).addClass((v?"highcharts-color-"+
f.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(c.className||"")).add(this.legendItem.symbol));g.connectors.push(e.path(e.crispLine([["M",p,t],["L",p+l,t]],c.connectorWidth)).attr(v?{}:a.connectorAttribs).addClass((v?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(c.connectorClassName||"")).add(this.legendItem.symbol));a=e.text(this.formatLabel(a)).attr(v?{}:a.labelAttribs).css(v?{}:b.style).addClass("highcharts-bubble-legend-labels "+(c.labels.className||
"")).add(this.legendItem.symbol);c={x:p+l+c.labels.x,y:t+c.labels.y+.4*a.getBBox().height};a.attr(c);d.push(a);a.placed=!0;a.alignAttr=c}getMaxLabelSize(){let a,c;this.symbols.labels.forEach(function(b){c=b.getBBox(!0);a=a?c.width>a.width?c:a:c});return a||{}}formatLabel(a){var c=this.options;const b=c.labels.formatter;c=c.labels.format;const {numberFormatter:d}=this.chart;return c?k.format(c,a):b?b.call(a):d(a.value,1)}hideOverlappingLabels(){const a=this.chart,c=this.symbols;!this.options.labels.allowOverlap&&
c&&(a.hideOverlappingLabels(c.labels),c.labels.forEach(function(a,d){a.newOpacity?a.newOpacity!==a.oldOpacity&&c.connectors[d].show():c.connectors[d].hide()}))}getRanges(){const a=this.legend.bubbleLegend,c=a.options.ranges;let b,g,f=Number.MAX_VALUE,h=-Number.MAX_VALUE;a.chart.series.forEach(function(a){a.isBubble&&!a.ignoreSeries&&(g=a.zData.filter(v),g.length&&(f=e(a.options.zMin,Math.min(f,Math.max(q(g),!1===a.options.displayNegative?a.options.zThreshold:-Number.MAX_VALUE))),h=e(a.options.zMax,
Math.max(h,t(g)))))});b=f===h?[{value:h}]:[{value:f},{value:(f+h)/2},{value:h,autoRanges:!0}];c.length&&c[0].radius&&b.reverse();b.forEach(function(a,d){c&&c[d]&&(b[d]=m(c[d],a))});return b}predictBubbleSizes(){var a=this.chart,c=a.legend.options,b=c.floating;const e=(c="horizontal"===c.layout)?a.legend.lastLineHeight:0,f=a.plotSizeX,g=a.plotSizeY;var h=a.series[this.options.seriesIndex],k=h.getPxExtremes();a=Math.ceil(k.minPxSize);k=Math.ceil(k.maxPxSize);const r=Math.min(g,f);h=h.options.maxSize;
if(b||!/%$/.test(h))b=k;else if(h=parseFloat(h),b=(r+e)*h/100/(h/100+1),c&&g-b>=f||!c&&f-b>=g)b=k;return[a,Math.ceil(b)]}updateRanges(a,c){const b=this.legend.options.bubbleLegend;b.minSize=a;b.maxSize=c;b.ranges=this.getRanges()}correctSizes(){const a=this.legend,c=this.chart.series[this.options.seriesIndex].getPxExtremes();1<Math.abs(Math.ceil(c.maxPxSize)-this.options.maxSize)&&(this.updateRanges(this.options.minSize,c.maxPxSize),a.render())}}"";return g});A(a,"Series/Bubble/BubbleLegendComposition.js",
[a["Series/Bubble/BubbleLegendDefaults.js"],a["Series/Bubble/BubbleLegendItem.js"],a["Core/Defaults.js"],a["Core/Utilities.js"]],function(a,k,p,w){function h(a,c,d){const b=this.legend;var f=0<=x(this);let e,h;b&&b.options.enabled&&b.bubbleLegend&&b.options.bubbleLegend.autoRanges&&f?(e=b.bubbleLegend.options,f=b.bubbleLegend.predictBubbleSizes(),b.bubbleLegend.updateRanges(f[0],f[1]),e.placed||(b.group.placed=!1,b.allItems.forEach(a=>{h=a.legendItem||{};h.group&&(h.group.translateY=null)})),b.render(),
this.getMargins(),this.axes.forEach(function(a){a.visible&&a.render();e.placed||(a.setScale(),a.updateNames(),g(a.ticks,function(a){a.isNew=!0;a.isNewLabel=!0}))}),e.placed=!0,this.getMargins(),a.call(this,c,d),b.bubbleLegend.correctSizes(),m(b,t(b))):(a.call(this,c,d),b&&b.options.enabled&&b.bubbleLegend&&(b.render(),m(b,t(b))))}function x(a){a=a.series;let b=0;for(;b<a.length;){if(a[b]&&a[b].isBubble&&a[b].visible&&a[b].zData.length)return b;b++}return-1}function t(a){a=a.allItems;const b=[],c=
a.length;let d,e,g=0;for(e=0;e<c;e++){var h=a[e].legendItem||{};d=(a[e+1]||{}).legendItem||{};h.labelHeight&&(a[e].itemHeight=h.labelHeight);if(a[e]===a[c-1]||h.y!==d.y){b.push({height:0});h=b[b.length-1];for(g;g<=e;g++)a[g].itemHeight>h.height&&(h.height=a[g].itemHeight);h.step=e}}return b}function q(a){const b=this.bubbleLegend,c=this.options,d=c.bubbleLegend,e=x(this.chart);b&&b.ranges&&b.ranges.length&&(d.ranges.length&&(d.autoRanges=!!d.ranges[0].autoRanges),this.destroyItem(b));0<=e&&c.enabled&&
d.enabled&&(d.seriesIndex=e,this.bubbleLegend=new k(d,this),this.bubbleLegend.addToLegend(a.allItems))}function v(a){if(a.defaultPrevented)return!1;var b=this.chart;a=this.visible;const c=this.chart.legend;c&&c.bubbleLegend&&(this.visible=!a,this.ignoreSeries=a,b=0<=x(b),c.bubbleLegend.visible!==b&&(c.update({bubbleLegend:{enabled:b}}),c.bubbleLegend.visible=b),this.visible=a)}function m(a,c){const b=a.options.rtl;let d,e,g,h,k=0;a.allItems.forEach((a,f)=>{h=a.legendItem||{};if(h.group){d=h.group.translateX||
0;e=h.y||0;if((g=a.movementX)||b&&a.ranges)g=b?d-a.options.maxSize/2:d+g,h.group.attr({translateX:g});f>c[k].step&&k++;h.group.attr({translateY:Math.round(e+c[k].height/2)});h.y=e+c[k].height/2}})}const {setOptions:e}=p,{addEvent:B,objectEach:g,wrap:d}=w,c=[];return{compose:function(b,g,f){w.pushUnique(c,b)&&(e({legend:{bubbleLegend:a}}),d(b.prototype,"drawChartBox",h));w.pushUnique(c,g)&&B(g,"afterGetAllItems",q);w.pushUnique(c,f)&&B(f,"legendItemClick",v)}}});A(a,"Series/Bubble/BubblePoint.js",
[a["Core/Series/Point.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,k,p){({seriesTypes:{scatter:{prototype:{pointClass:k}}}}=k);({extend:p}=p);class h extends k{constructor(){super(...arguments);this.series=this.options=void 0}haloPath(h){return a.prototype.haloPath.call(this,0===h?0:(this.marker?this.marker.radius||0:0)+h)}}p(h.prototype,{ttBelow:!1});return h});A(a,"Series/Bubble/BubbleSeries.js",[a["Series/Bubble/BubbleLegendComposition.js"],a["Series/Bubble/BubblePoint.js"],
a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,k,p,w,l,x){function h(){const a=this.len,b=this.chart,c=this.isXAxis,d=c?"xData":"yData",f=this.min,e=this.max-f;let g=0,h=a,k=a/e,l;this.series.forEach(a=>{if(a.bubblePadding&&(a.visible||!b.options.chart.ignoreHiddenSeries)){l=this.allowZoomOutside=!0;const b=a[d];c&&((a.onPoint||a).getRadii(0,0,a),a.onPoint&&(a.radii=a.onPoint.radii));if(0<e){let c=b.length;for(;c--;)if(n(b[c])&&
this.dataMin<=b[c]&&b[c]<=this.max){const d=a.radii&&a.radii[c]||0;g=Math.min((b[c]-f)*k-d,g);h=Math.max((b[c]-f)*k+d,h)}}}});l&&0<e&&!this.logarithmic&&(h-=a,k*=(a+Math.max(0,g)-Math.min(h,a))/a,[["min","userMin",g],["max","userMax",h]].forEach(a=>{"undefined"===typeof z(this.options[a[0]],this[a[1]])&&(this[a[0]]+=a[2]/k)}))}const {parse:q}=p;({noop:p}=w);const {series:v,seriesTypes:{column:{prototype:m},scatter:e}}=l,{addEvent:B,arrayMax:g,arrayMin:d,clamp:c,extend:b,isNumber:n,merge:f,pick:z}=
x,C=[];class D extends e{constructor(){super(...arguments);this.zData=this.yData=this.radii=this.points=this.options=this.minPxSize=this.maxPxSize=this.data=void 0}static compose(b,c,d,f){a.compose(c,d,f);x.pushUnique(C,b)&&(b.prototype.beforePadding=h)}animate(a){!a&&this.points.length<this.options.animationLimit&&this.points.forEach(function(a){const {graphic:b}=a;b&&b.width&&(this.hasRendered||b.attr({x:a.plotX,y:a.plotY,width:1,height:1}),b.animate(this.markerAttribs(a),this.options.animation))},
this)}getRadii(){const a=this.zData,b=this.yData,c=[];let d,f,e,g=this.chart.bubbleZExtremes;const {minPxSize:h,maxPxSize:k}=this.getPxExtremes();if(!g){let a=Number.MAX_VALUE,b=-Number.MAX_VALUE,c;this.chart.series.forEach(d=>{d.bubblePadding&&(d.visible||!this.chart.options.chart.ignoreHiddenSeries)&&(d=(d.onPoint||d).getZExtremes())&&(a=Math.min(z(a,d.zMin),d.zMin),b=Math.max(z(b,d.zMax),d.zMax),c=!0)});c?(g={zMin:a,zMax:b},this.chart.bubbleZExtremes=g):g={zMin:0,zMax:0}}f=0;for(d=a.length;f<d;f++)e=
a[f],c.push(this.getRadius(g.zMin,g.zMax,h,k,e,b&&b[f]));this.radii=c}getRadius(a,b,c,d,f,e){const g=this.options,h="width"!==g.sizeBy,k=g.zThreshold;let l=b-a,m=.5;if(null===e||null===f)return null;if(n(f)){g.sizeByAbsoluteValue&&(f=Math.abs(f-k),l=Math.max(b-k,Math.abs(a-k)),a=0);if(f<a)return c/2-1;0<l&&(m=(f-a)/l)}h&&0<=m&&(m=Math.sqrt(m));return Math.ceil(c+m*(d-c))/2}hasData(){return!!this.processedXData.length}pointAttribs(a,b){const c=this.options.marker.fillOpacity;a=v.prototype.pointAttribs.call(this,
a,b);1!==c&&(a.fill=q(a.fill).setOpacity(c).get("rgba"));return a}translate(){super.translate.call(this);this.getRadii();this.translateBubble()}translateBubble(){const {data:a,radii:c}=this,{minPxSize:d}=this.getPxExtremes();let f=a.length;for(;f--;){const e=a[f],g=c?c[f]:0;n(g)&&g>=d/2?(e.marker=b(e.marker,{radius:g,width:2*g,height:2*g}),e.dlBox={x:e.plotX-g,y:e.plotY-g,width:2*g,height:2*g}):(e.shapeArgs=e.plotY=e.dlBox=void 0,e.isInside=!1)}}getPxExtremes(){const a=Math.min(this.chart.plotWidth,
this.chart.plotHeight);var b=b=>{let c;"string"===typeof b&&(c=/%$/.test(b),b=parseInt(b,10));return c?a*b/100:b};const c=b(z(this.options.minSize,8));b=Math.max(b(z(this.options.maxSize,"20%")),c);return{minPxSize:c,maxPxSize:b}}getZExtremes(){var a=this.options;const b=(this.zData||[]).filter(n);if(b.length){const f=z(a.zMin,c(d(b),!1===a.displayNegative?a.zThreshold||0:-Number.MAX_VALUE,Number.MAX_VALUE));a=z(a.zMax,g(b));if(n(f)&&n(a))return{zMin:f,zMax:a}}}}D.defaultOptions=f(e.defaultOptions,
{dataLabels:{formatter:function(){const {numberFormatter:a}=this.series.chart,{z:b}=this.point;return n(b)?a(b,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"});b(D.prototype,{alignDataLabel:m.alignDataLabel,
applyZones:p,bubblePadding:!0,buildKDTree:p,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:k,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"});B(D,"updatedData",a=>{delete a.target.chart.bubbleZExtremes});B(D,"remove",a=>{delete a.target.chart.bubbleZExtremes});l.registerSeriesType("bubble",D);"";"";return D});A(a,"Series/MapBubble/MapBubblePoint.js",[a["Series/Bubble/BubblePoint.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],
function(a,k,p){({seriesTypes:{map:{prototype:{pointClass:{prototype:k}}}}}=k);({extend:p}=p);class h extends a{isValid(){return"number"===typeof this.z}}p(h.prototype,{applyOptions:k.applyOptions,getProjectedBounds:k.getProjectedBounds});return h});A(a,"Series/MapBubble/MapBubbleSeries.js",[a["Series/Bubble/BubbleSeries.js"],a["Series/MapBubble/MapBubblePoint.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,k,p,w){const {seriesTypes:{map:{prototype:h},mappoint:{prototype:x}}}=
p,{extend:t,merge:q}=w;class v extends a{constructor(){super(...arguments);this.points=this.options=this.data=void 0;this.clearBounds=h.clearBounds}searchPoint(a,e){return this.searchKDTree({clientX:a.chartX-this.chart.plotLeft,plotY:a.chartY-this.chart.plotTop},e,a)}translate(){x.translate.call(this);this.getRadii();this.translateBubble()}updateParallelArrays(a,e,h){super.updateParallelArrays.call(this,a,e,h);a=this.processedXData;e=this.xData;a&&e&&(a.length=e.length)}}v.defaultOptions=q(a.defaultOptions,
{lineWidth:0,animationLimit:500,joinBy:"hc-key",tooltip:{pointFormat:"{point.name}: {point.z}"}});t(v.prototype,{type:"mapbubble",axisTypes:["colorAxis"],getProjectedBounds:h.getProjectedBounds,isCartesian:!1,pointArrayMap:["z"],pointClass:k,processData:h.processData,projectPoint:x.projectPoint,setData:h.setData,setOptions:h.setOptions,updateData:h.updateData,useMapGeometry:!0,xyFromShape:!0});p.registerSeriesType("mapbubble",v);"";return v});A(a,"Series/Heatmap/HeatmapPoint.js",[a["Core/Series/SeriesRegistry.js"],
a["Core/Utilities.js"]],function(a,k){({seriesTypes:{scatter:{prototype:{pointClass:a}}}}=a);const {clamp:h,defined:w,extend:l,pick:x}=k;class t extends a{constructor(){super(...arguments);this.y=this.x=this.value=this.series=this.options=void 0}applyOptions(a,h){(this.isNull||null===this.value)&&delete this.color;super.applyOptions(a,h);this.formatPrefix=this.isNull||null===this.value?"null":"point";return this}getCellAttributes(){var a=this.series;const k=a.options,l=(k.colsize||1)/2,e=(k.rowsize||
1)/2,p=a.xAxis,g=a.yAxis,d=this.options.marker||a.options.marker;a=a.pointPlacementToXValue();const c=x(this.pointPadding,k.pointPadding,0),b={x1:h(Math.round(p.len-p.translate(this.x-l,!1,!0,!1,!0,-a)),-p.len,2*p.len),x2:h(Math.round(p.len-p.translate(this.x+l,!1,!0,!1,!0,-a)),-p.len,2*p.len),y1:h(Math.round(g.translate(this.y-e,!1,!0,!1,!0)),-g.len,2*g.len),y2:h(Math.round(g.translate(this.y+e,!1,!0,!1,!0)),-g.len,2*g.len)};[["width","x"],["height","y"]].forEach(function(a){var f=a[0];a=a[1];let e=
a+"1",h=a+"2";const k=Math.abs(b[e]-b[h]),l=d&&d.lineWidth||0,m=Math.abs(b[e]+b[h])/2;f=d&&d[f];w(f)&&f<k&&(f=f/2+l/2,b[e]=m-f,b[h]=m+f);if(c){if("x"===a&&p.reversed||"y"===a&&!g.reversed)e=h,h=a+"1";b[e]+=c;b[h]-=c}});return b}haloPath(a){if(!a)return[];const {x:h=0,y:k=0,width:e=0,height:l=0}=this.shapeArgs||{};return[["M",h-a,k-a],["L",h-a,k+l+a],["L",h+e+a,k+l+a],["L",h+e+a,k-a],["Z"]]}isValid(){return Infinity!==this.value&&-Infinity!==this.value}}l(t.prototype,{dataLabelOnNull:!0,moveToTopOnHover:!0,
ttBelow:!1});return t});A(a,"Series/Heatmap/HeatmapSeries.js",[a["Core/Color/Color.js"],a["Series/ColorMapComposition.js"],a["Series/Heatmap/HeatmapPoint.js"],a["Core/Legend/LegendSymbol.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,k,p,w,l,x,t){const {series:h,seriesTypes:{column:v,scatter:m}}=l,{prototype:{symbols:e}}=x,{extend:A,fireEvent:g,isNumber:d,merge:c,pick:b}=t;class n extends m{constructor(){super(...arguments);this.points=
this.options=this.data=this.colorAxis=void 0;this.valueMin=this.valueMax=NaN}drawPoints(){if((this.options.marker||{}).enabled||this._hasPointMarkers)h.prototype.drawPoints.call(this),this.points.forEach(a=>{a.graphic&&(a.graphic[this.chart.styledMode?"css":"animate"](this.colorAttribs(a)),null===a.value&&a.graphic.addClass("highcharts-null-point"))})}getExtremes(){const {dataMin:a,dataMax:b}=h.prototype.getExtremes.call(this,this.valueData);d(a)&&(this.valueMin=a);d(b)&&(this.valueMax=b);return h.prototype.getExtremes.call(this)}getValidPoints(a,
b){return h.prototype.getValidPoints.call(this,a,b,!0)}hasData(){return!!this.processedXData.length}init(){super.init.apply(this,arguments);const a=this.options;a.pointRange=b(a.pointRange,a.colsize||1);this.yAxis.axisPointRange=a.rowsize||1;e.ellipse=e.circle;a.marker&&d(a.borderRadius)&&(a.marker.r=a.borderRadius)}markerAttribs(a,b){const c=a.shapeArgs||{};if(a.hasImage)return{x:a.plotX,y:a.plotY};if(b&&"normal"!==b){var d=a.options.marker||{};a=this.options.marker||{};a=a.states&&a.states[b]||
{};d=d.states&&d.states[b]||{};b=(d.width||a.width||c.width||0)+(d.widthPlus||a.widthPlus||0);a=(d.height||a.height||c.height||0)+(d.heightPlus||a.heightPlus||0);return{x:(c.x||0)+((c.width||0)-b)/2,y:(c.y||0)+((c.height||0)-a)/2,width:b,height:a}}return c}pointAttribs(b,d){const e=h.prototype.pointAttribs.call(this,b,d),f=this.options||{};var g=this.chart.options.plotOptions||{},k=g.series||{};const l=g.heatmap||{};g=b&&b.options.borderColor||f.borderColor||l.borderColor||k.borderColor;k=b&&b.options.borderWidth||
f.borderWidth||l.borderWidth||k.borderWidth||e["stroke-width"];e.stroke=b&&b.marker&&b.marker.lineColor||f.marker&&f.marker.lineColor||g||this.color;e["stroke-width"]=k;d&&"normal"!==d&&(b=c(f.states&&f.states[d],f.marker&&f.marker.states&&f.marker.states[d],b&&b.options.states&&b.options.states[d]||{}),e.fill=b.color||a.parse(e.fill).brighten(b.brightness||0).get(),e.stroke=b.lineColor||e.stroke);return e}translate(){const {borderRadius:a,marker:b}=this.options,h=b&&b.symbol||"rect",k=e[h]?h:"rect",
l=-1!==["circle","square"].indexOf(k);this.generatePoints();this.points.forEach(function(b){const f=b.getCellAttributes();let g=Math.min(f.x1,f.x2);var m=Math.min(f.y1,f.y2);let n=Math.max(Math.abs(f.x2-f.x1),0),p=Math.max(Math.abs(f.y2-f.y1),0);b.hasImage=0===(b.marker&&b.marker.symbol||h||"").indexOf("url");l&&(m=Math.abs(n-p),g=Math.min(f.x1,f.x2)+(n<p?0:m/2),m=Math.min(f.y1,f.y2)+(n<p?m/2:0),n=p=Math.min(n,p));b.hasImage&&(b.marker={width:n,height:p});b.plotX=b.clientX=(f.x1+f.x2)/2;b.plotY=(f.y1+
f.y2)/2;b.shapeType="path";b.shapeArgs=c(!0,{x:g,y:m,width:n,height:p},{d:e[k](g,m,n,p,{r:d(a)?a:0})})});g(this,"afterTranslate")}}n.defaultOptions=c(m.defaultOptions,{animation:!1,borderRadius:0,borderWidth:0,nullColor:"#f7f7f7",dataLabels:{formatter:function(){const {numberFormatter:a}=this.series.chart,{value:b}=this.point;return d(b)?a(b,-1):""},inside:!0,verticalAlign:"middle",crop:!1,overflow:"allow",padding:0},marker:{symbol:"rect",radius:0,lineColor:void 0,states:{hover:{lineWidthPlus:0},
select:{}}},clip:!0,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}});A(n.prototype,{axisTypes:k.seriesMembers.axisTypes,colorKey:k.seriesMembers.colorKey,directTouch:!0,getExtremesFromAll:!0,parallelArrays:k.seriesMembers.parallelArrays,pointArrayMap:["y","value"],pointClass:p,specialGroup:"group",trackerGroups:k.seriesMembers.trackerGroups,alignDataLabel:v.prototype.alignDataLabel,colorAttribs:k.seriesMembers.colorAttribs,drawLegendSymbol:w.drawRectangle,
getSymbol:h.prototype.getSymbol});k.compose(n);l.registerSeriesType("heatmap",n);"";"";return n});A(a,"masters/modules/map.src.js",[a["Core/Globals.js"],a["Core/Axis/Color/ColorAxis.js"],a["Series/MapBubble/MapBubbleSeries.js"],a["Core/Chart/MapChart.js"],a["Maps/MapView.js"],a["Maps/Projection.js"]],function(a,k,p,w,l,x){a.ColorAxis=k;a.MapChart=w;a.mapChart=a.Map=w.mapChart;a.MapView=l;a.maps=w.maps;a.Projection=x;k.compose(a.Chart,a.Fx,a.Legend,a.Series);p.compose(a.Axis,a.Chart,a.Legend,a.Series)})});
//# sourceMappingURL=map.js.map