/*
 Highcharts JS v11.0.0 (2023-04-26)

 Wind barb series module

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/windbarb",["highcharts"],function(f){a(f);a.Highcharts=f;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function f(a,k,e,f){a.hasOwnProperty(k)||(a[k]=f.apply(null,e),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:k,module:a[k]}})))}a=a?a._modules:
{};f(a,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}});f(a,"Series/OnSeriesComposition.js",[a["Series/Column/ColumnSeries.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,k,e){var f=a.prototype,p=k.prototype,b=e.defined,h=e.stableSort,m;(function(a){function m(a){return p.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,a)}function k(){f.translate.apply(this);var a=this,l=a.options,t=a.chart,d=a.points,c=l.onSeries,x=
(c=c&&t.get(c))&&c.options.step,u=c&&c.points,g=t.inverted,m=a.xAxis,k=a.yAxis;t=d.length-1;var p;l=l.onKey||"y";var e=u&&u.length,v=0,r;if(c&&c.visible&&e){v=(c.pointXOffset||0)+(c.barW||0)/2;var n=c.currentDataGrouping;var y=u[e-1].x+(n?n.totalRange:0);h(d,function(d,c){return d.x-c.x});for(l="plot"+l[0].toUpperCase()+l.substr(1);e--&&d[t];){var q=u[e];n=d[t];n.y=q.y;if(q.x<=n.x&&"undefined"!==typeof q[l]){if(n.x<=y&&(n.plotY=q[l],q.x<n.x&&!x&&(r=u[e+1])&&"undefined"!==typeof r[l])){var w=(n.x-
q.x)/(r.x-q.x);n.plotY+=w*(r[l]-q[l]);n.y+=w*(r.y-q.y)}t--;e++;if(0>t)break}}}d.forEach(function(c,x){c.plotX+=v;if("undefined"===typeof c.plotY||g)0<=c.plotX&&c.plotX<=m.len?g?(c.plotY=m.translate(c.x,0,1,0,1),c.plotX=b(c.y)?k.translate(c.y,0,0,0,1):0):c.plotY=(m.opposite?0:a.yAxis.len)+m.offset:c.shapeArgs={};if((p=d[x-1])&&p.plotX===c.plotX){"undefined"===typeof p.stackIndex&&(p.stackIndex=0);var u=p.stackIndex+1}c.stackIndex=u});this.onSeries=c}var v=[];a.compose=function(a){if(e.pushUnique(v,
a)){var l=a.prototype;l.getPlotBox=m;l.translate=k}return a};a.getPlotBox=m;a.translate=k})(m||(m={}));return m});f(a,"Series/Windbarb/WindbarbPoint.js",[a["Core/Utilities.js"],a["Series/Column/ColumnSeries.js"]],function(a,k){var e=this&&this.__extends||function(){var a=function(b,h){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var h in b)Object.prototype.hasOwnProperty.call(b,h)&&(a[h]=b[h])};return a(b,h)};return function(b,h){function e(){this.constructor=
b}if("function"!==typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");a(b,h);b.prototype=null===h?Object.create(h):(e.prototype=h.prototype,new e)}}(),f=a.isNumber;return function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.beaufort=void 0;b.beaufortLevel=void 0;b.direction=void 0;b.options=void 0;b.series=void 0;return b}e(b,a);b.prototype.isValid=function(){return f(this.value)&&0<=this.value};return b}(k.prototype.pointClass)});
f(a,"Series/Windbarb/WindbarbSeries.js",[a["Core/Animation/AnimationUtilities.js"],a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Core/Globals.js"],a["Series/OnSeriesComposition.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"],a["Series/Windbarb/WindbarbPoint.js"]],function(a,k,e,f,p,b,h){var m=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,d){a.__proto__=d}||function(a,d){for(var c in d)Object.prototype.hasOwnProperty.call(d,
c)&&(a[c]=d[c])};return a(b,d)};return function(b,d){function c(){this.constructor=b}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");a(b,d);b.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),v=a.animObject,r=p.series,w=p.seriesTypes.column;a=b.extend;var A=b.merge,z=b.pick;b=function(a){function b(){var d=null!==a&&a.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}m(b,
a);b.registerApproximation=function(){k.windbarb||(k.windbarb=function(a,c){var d=0,b=0,g,f=a.length;for(g=0;g<f;g++)d+=a[g]*Math.cos(c[g]*e.deg2rad),b+=a[g]*Math.sin(c[g]*e.deg2rad);return[a.reduce(function(a,c){return a+c},0)/a.length,Math.atan2(b,d)/e.deg2rad]})};b.prototype.init=function(a,c){b.registerApproximation();r.prototype.init.call(this,a,c)};b.prototype.pointAttribs=function(a,c){var b=this.options;a=a.color||this.color;var d=this.options.lineWidth;c&&(a=b.states[c].color||a,d=(b.states[c].lineWidth||
d)+(b.states[c].lineWidthPlus||0));return{stroke:a,"stroke-width":d}};b.prototype.windArrow=function(a){var c=1.943844*a.value,b=this.options.vectorLength/20,d=-10;if(a.isNull)return[];if(0===a.beaufortLevel)return this.chart.renderer.symbols.circle(-10*b,-10*b,20*b,20*b);a=[["M",0,7*b],["L",-1.5*b,7*b],["L",0,10*b],["L",1.5*b,7*b],["L",0,7*b],["L",0,-10*b]];var g=(c-c%50)/50;if(0<g)for(;g--;)a.push(-10===d?["L",0,d*b]:["M",0,d*b],["L",5*b,d*b+2],["L",0,d*b+4]),c-=50,d+=7;g=(c-c%10)/10;if(0<g)for(;g--;)a.push(-10===
d?["L",0,d*b]:["M",0,d*b],["L",7*b,d*b]),c-=10,d+=3;g=(c-c%5)/5;if(0<g)for(;g--;)a.push(-10===d?["L",0,d*b]:["M",0,d*b],["L",4*b,d*b]),c-=5,d+=3;return a};b.prototype.drawPoints=function(){var a=this.chart,b=this.yAxis,e=a.inverted,f=this.options.vectorLength/2;this.points.forEach(function(c){var d=c.plotX,g=c.plotY;!1===this.options.clip||a.isInsidePlot(d,0)?(c.graphic||(c.graphic=this.chart.renderer.path().add(this.markerGroup).addClass("highcharts-point highcharts-color-"+z(c.colorIndex,c.series.colorIndex))),
c.graphic.attr({d:this.windArrow(c),translateX:d+this.options.xOffset,translateY:g+this.options.yOffset,rotation:c.direction}),this.chart.styledMode||c.graphic.attr(this.pointAttribs(c))):c.graphic&&(c.graphic=c.graphic.destroy());c.tooltipPos=[d+this.options.xOffset+(e&&!this.onSeries?f:0),g+this.options.yOffset-(e?0:f+b.pos-a.plotTop)]},this)};b.prototype.animate=function(a){a?this.markerGroup.attr({opacity:.01}):this.markerGroup.animate({opacity:1},v(this.options.animation))};b.prototype.markerAttribs=
function(a,b){return{}};b.prototype.getExtremes=function(){return{}};b.prototype.shouldShowTooltip=function(b,c,e){void 0===e&&(e={});e.ignoreX=this.chart.inverted;e.ignoreY=!e.ignoreX;return a.prototype.shouldShowTooltip.call(this,b,c,e)};b.defaultOptions=A(w.defaultOptions,{dataGrouping:{enabled:!0,approximation:"windbarb",groupPixelWidth:30},lineWidth:2,onSeries:null,states:{hover:{lineWidthPlus:0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> {series.name}: <b>{point.value}</b> ({point.beaufort})<br/>'},
vectorLength:20,colorKey:"value",yOffset:-20,xOffset:0});return b}(w);f.compose(b);a(b.prototype,{beaufortFloor:[0,.3,1.6,3.4,5.5,8,10.8,13.9,17.2,20.8,24.5,28.5,32.7],beaufortName:"Calm;Light air;Light breeze;Gentle breeze;Moderate breeze;Fresh breeze;Strong breeze;Near gale;Gale;Strong gale;Storm;Violent storm;Hurricane".split(";"),invertible:!1,parallelArrays:["x","value","direction"],pointArrayMap:["value","direction"],pointClass:h,trackerGroups:["markerGroup"],translate:function(){var a=this.beaufortFloor,
b=this.beaufortName;f.translate.call(this);this.points.forEach(function(d){for(var c=0;c<a.length&&!(a[c]>d.value);c++);d.beaufortLevel=c-1;d.beaufort=b[c-1]})}});b.registerApproximation();p.registerSeriesType("windbarb",b);"";return b});f(a,"masters/modules/windbarb.src.js",[],function(){})});
//# sourceMappingURL=windbarb.js.map