/*
 Highcharts JS v11.0.0 (2023-04-26)

 (c) 2017-2021 Highsoft AS
 Authors: Jon Arild Nygard

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/venn",["highcharts"],function(n){a(n);a.Highcharts=n;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function n(a,p,h,f){a.hasOwnProperty(p)||(a[p]=f.apply(null,h),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:p,module:a[p]}})))}a=a?a._modules:
{};n(a,"Core/Geometry/GeometryUtilities.js",[],function(){var a;(function(a){a.getCenterOfPoints=function(a){var f=a.reduce(function(a,f){a.x+=f.x;a.y+=f.y;return a},{x:0,y:0});return{x:f.x/a.length,y:f.y/a.length}};a.getDistanceBetweenPoints=function(a,f){return Math.sqrt(Math.pow(f.x-a.x,2)+Math.pow(f.y-a.y,2))};a.getAngleBetweenPoints=function(a,f){return Math.atan2(f.x-a.x,f.y-a.y)}})(a||(a={}));return a});n(a,"Core/Geometry/CircleUtilities.js",[a["Core/Geometry/GeometryUtilities.js"]],function(a){var p=
a.getAngleBetweenPoints,h=a.getCenterOfPoints,f=a.getDistanceBetweenPoints,l;(function(a){function m(a,d){d=Math.pow(10,d);return Math.round(a*d)/d}function l(a){if(0>=a)throw Error("radius of circle must be a positive number.");return Math.PI*a*a}function q(a,d){return a*a*Math.acos(1-d/a)-(a-d)*Math.sqrt(d*(2*a-d))}function g(a,d){var r=f(a,d),g=a.r,h=d.r,v=[];if(r<g+h&&r>Math.abs(g-h)){g*=g;var l=(g-h*h+r*r)/(2*r);h=Math.sqrt(g-l*l);g=a.x;v=d.x;a=a.y;var q=d.y;d=g+l*(v-g)/r;l=a+l*(q-a)/r;a=h/r*
-(q-a);r=h/r*-(v-g);v=[{x:m(d+a,14),y:m(l-r,14)},{x:m(d-a,14),y:m(l+r,14)}]}return v}function u(a){return a.reduce(function(a,f,h,l){l=l.slice(h+1).reduce(function(a,d,l,m){var v=[h,l+h+1];return a.concat(g(f,d).map(function(a){a.indexes=v;return a}))},[]);return a.concat(l)},[])}function n(a,d){return f(a,d)<=d.r+1e-10}function w(a,d){return!d.some(function(d){return!n(a,d)})}function D(a){return u(a).filter(function(d){return w(d,a)})}a.round=m;a.getAreaOfCircle=l;a.getCircularSegmentArea=q;a.getOverlapBetweenCircles=
function(a,d,f){var h=0;f<a+d&&(f<=Math.abs(d-a)?h=l(a<d?a:d):(h=(a*a-d*d+f*f)/(2*f),f-=h,h=q(a,a-h)+q(d,d-f)),h=m(h,14));return h};a.getCircleCircleIntersection=g;a.getCirclesIntersectionPoints=u;a.isCircle1CompletelyOverlappingCircle2=function(a,d){return f(a,d)+d.r<a.r+1e-10};a.isPointInsideCircle=n;a.isPointInsideAllCircles=w;a.isPointOutsideAllCircles=function(a,d){return!d.some(function(d){return n(a,d)})};a.getCirclesIntersectionPolygon=D;a.getAreaOfIntersectionBetweenCircles=function(a){var d=
D(a);if(1<d.length){var g=h(d);d=d.map(function(a){a.angle=p(g,a);return a}).sort(function(a,d){return d.angle-a.angle});var l=d[d.length-1];d=d.reduce(function(d,g){var l=d.startPoint,m=h([l,g]),q=g.indexes.filter(function(a){return-1<l.indexes.indexOf(a)}).reduce(function(t,c){c=a[c];var b=p(c,g),e=p(c,l);b=e-(e-b+(e<b?2*Math.PI:0))/2;b=f(m,{x:c.x+c.r*Math.sin(b),y:c.y+c.r*Math.cos(b)});c=c.r;b>2*c&&(b=2*c);if(!t||t.width>b)t={r:c,largeArc:b>c?1:0,width:b,x:g.x,y:g.y};return t},null);if(q){var A=
q.r;d.arcs.push(["A",A,A,0,q.largeArc,1,q.x,q.y]);d.startPoint=g}return d},{startPoint:l,arcs:[]}).arcs;if(0!==d.length&&1!==d.length){d.unshift(["M",l.x,l.y]);var m={center:g,d}}}return m}})(l||(l={}));return l});n(a,"Series/DrawPointUtilities.js",[a["Core/Utilities.js"]],function(a){var p=this&&this.__assign||function(){p=Object.assign||function(a){for(var f,h=1,q=arguments.length;h<q;h++){f=arguments[h];for(var m in f)Object.prototype.hasOwnProperty.call(f,m)&&(a[m]=f[m])}return a};return p.apply(this,
arguments)};return{draw:function(a,f){var l=f.animatableAttribs,h=f.onComplete,m=f.css,A=f.renderer,u=a.series&&a.series.chart.hasRendered?void 0:a.series&&a.series.options.animation,g=a.graphic;f.attribs=p(p({},f.attribs),{"class":a.getClassName()})||{};if(a.shouldDraw())g||(a.graphic=g="text"===f.shapeType?A.text():A[f.shapeType](f.shapeArgs||{}),g.add(f.group)),m&&g.css(m),g.attr(f.attribs).animate(l,f.isNew?!1:u,h);else if(g){var n=function(){a.graphic=g=g&&g.destroy();"function"===typeof h&&
h()};Object.keys(l).length?g.animate(l,void 0,function(){return n()}):n()}}}});n(a,"Series/Venn/VennPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,p){var h=this&&this.__extends||function(){var a=function(f,h){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var g in f)Object.prototype.hasOwnProperty.call(f,g)&&(a[g]=f[g])};return a(f,h)};return function(f,h){function l(){this.constructor=f}if("function"!==typeof h&&
null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");a(f,h);f.prototype=null===h?Object.create(h):(l.prototype=h.prototype,new l)}}(),f=p.isNumber;return function(a){function l(){var f=null!==a&&a.apply(this,arguments)||this;f.options=void 0;f.series=void 0;return f}h(l,a);l.prototype.isValid=function(){return f(this.value)};l.prototype.shouldDraw=function(){return!!this.shapeArgs};return l}(a.seriesTypes.scatter.prototype.pointClass)});n(a,"Series/Venn/VennUtils.js",
[a["Core/Geometry/CircleUtilities.js"],a["Core/Geometry/GeometryUtilities.js"],a["Core/Utilities.js"]],function(a,p,h){function f(a){var c={};a.filter(function(a){return 2===a.sets.length}).forEach(function(a){a.sets.forEach(function(b,k,x){var e;G(c[b])||(c[b]={totalOverlap:0,overlapping:{}});c[b]={totalOverlap:(c[b].totalOverlap||0)+a.value,overlapping:w(w({},c[b].overlapping||{}),(e={},e[x[1-k]]=a.value,e))}})});a.filter(u).forEach(function(a){F(a,c[a.sets[0]])});return a}function l(a,c,b,e,k){var x=
a(c),y=a(b);k=k||100;e=e||1e-10;var t=b-c,f=1;if(c>=b)throw Error("a must be smaller than b.");if(0<x*y)throw Error("f(a) and f(b) must have opposite signs.");if(0===x)var d=c;else if(0===y)d=b;else for(;f++<=k&&0!==h&&t>e;){t=(b-c)/2;d=c+t;var h=a(d);0<x*h?c=d:b=d}return d}function q(a){a=a.slice(0,-1);for(var c=a.length,b=[],e=function(a,b){a.sum+=b[a.i];return a},k=0;k<c;k++)b[k]=a.reduce(e,{sum:0,i:k}).sum/c;return b}function m(a,c,b){var e=a+c;return 0>=b?e:D(a<c?a:c)<=b?0:l(function(k){k=d(a,
c,k);return b-k},0,e)}function n(a){var c=0;2===a.length&&(c=a[0],a=a[1],c=d(c.r,a.r,B(c,a)));return c}function u(a){return C(a.sets)&&1===a.sets.length}function g(a){var c={};return G(a)&&z(a.value)&&-1<a.value&&C(a.sets)&&0<a.sets.length&&!a.sets.some(function(a){var b=!1;!c[a]&&E(a)?c[a]=!0:b=!0;return b})}function J(a,c){return c.reduce(function(b,c){var k=0;1<c.sets.length&&(k=c.value,c=n(c.sets.map(function(b){return a[b]})),c=k-c,k=Math.round(c*c*1E11)/1E11);return b+k},0)}function K(a,c){return"undefined"!==
typeof c.totalOverlap&&"undefined"!==typeof a.totalOverlap?c.totalOverlap-a.totalOverlap:NaN}var w=this&&this.__assign||function(){w=Object.assign||function(a){for(var c,b=1,e=arguments.length;b<e;b++){c=arguments[b];for(var k in c)Object.prototype.hasOwnProperty.call(c,k)&&(a[k]=c[k])}return a};return w.apply(this,arguments)},D=a.getAreaOfCircle,v=a.getCircleCircleIntersection,d=a.getOverlapBetweenCircles,r=a.isPointInsideAllCircles,H=a.isPointInsideCircle,I=a.isPointOutsideAllCircles,B=p.getDistanceBetweenPoints,
F=h.extend,C=h.isArray,z=h.isNumber,G=h.isObject,E=h.isString;return{geometry:p,geometryCircles:a,addOverlapToSets:f,getCentroid:q,getDistanceBetweenCirclesByOverlap:m,getLabelWidth:function(a,c,b){var e=c.reduce(function(a,b){return Math.min(b.r,a)},Infinity),k=b.filter(function(b){return!H(a,b)});b=function(b,e){return l(function(y){var d={x:a.x+e*y,y:a.y};d=r(d,c)&&I(d,k);return-(b-y)+(d?0:Number.MAX_VALUE)},0,b)};return 2*Math.min(b(e,-1),b(e,1))},getMarginFromCircles:function(a,c,b){c=c.reduce(function(b,
c){c=c.r-B(a,c);return c<=b?c:b},Number.MAX_VALUE);return c=b.reduce(function(b,c){c=B(a,c)-c.r;return c<=b?c:b},c)},isSet:u,layoutGreedyVenn:function(a){var c=[],b={};a.filter(function(a){return 1===a.sets.length}).forEach(function(a){b[a.sets[0]]=a.circle={x:Number.MAX_VALUE,y:Number.MAX_VALUE,r:Math.sqrt(a.value/Math.PI)}});var e=function(a,b){var k=a.circle;k&&(k.x=b.x,k.y=b.y);c.push(a)};f(a);var k=a.filter(u).sort(K);e(k.shift(),{x:0,y:0});var d=a.filter(function(a){return 2===a.sets.length});
k.forEach(function(a){var k=a.circle;if(k){var f=k.r,y=a.overlapping,x=c.reduce(function(a,e,x){var h=e.circle;if(!h||!y)return a;var g=m(f,h.r,y[e.sets[0]]),l=[{x:h.x+g,y:h.y},{x:h.x-g,y:h.y},{x:h.x,y:h.y+g},{x:h.x,y:h.y-g}];c.slice(x+1).forEach(function(a){var b=a.circle;b&&(a=m(f,b.r,y[a.sets[0]]),l=l.concat(v({x:h.x,y:h.y,r:g},{x:b.x,y:b.y,r:a})))});l.forEach(function(c){k.x=c.x;k.y=c.y;var e=J(b,d);e<a.loss&&(a.loss=e,a.coordinates=c)});return a},{loss:Number.MAX_VALUE,coordinates:void 0});e(a,
x.coordinates)}});return b},loss:J,nelderMead:function(a,c){var b=function(a,b){return a.fx-b.fx},e=function(a,b,c,k){return b.map(function(b,e){return a*b+c*k[e]})},k=function(b,c){c.fx=a(c);b[b.length-1]=c;return b},d=function(b){var c=b[0];return b.map(function(b){b=e(.5,c,.5,b);b.fx=a(b);return b})},f=function(b,c,k,d){b=e(k,b,d,c);b.fx=a(b);return b};c=function(b){var c=b.length,k=Array(c+1);k[0]=b;k[0].fx=a(b);for(var e=0;e<c;++e){var d=b.slice();d[e]=d[e]?1.05*d[e]:.001;d.fx=a(d);k[e+1]=d}return k}(c);
for(var h=0;100>h;h++){c.sort(b);var g=c[c.length-1],l=q(c),m=f(l,g,2,-1);if(m.fx<c[0].fx)g=f(l,g,3,-2),c=k(c,g.fx<m.fx?g:m);else if(m.fx>=c[c.length-2].fx){var t=void 0;m.fx>g.fx?(t=f(l,g,.5,.5),c=t.fx<g.fx?k(c,t):d(c)):(t=f(l,g,1.5,-.5),c=t.fx<m.fx?k(c,t):d(c))}else c=k(c,m)}return c[0]},processVennData:function(a,c){a=C(a)?a:[];var b=a.reduce(function(a,b){var c;if(c=b.sets)c=g(b)&&u(b)&&0<b.value;c&&-1===a.indexOf(b.sets[0])&&a.push(b.sets[0]);return a},[]).sort(),e=a.reduce(function(a,e){e.sets&&
g(e)&&!e.sets.some(function(a){return-1===b.indexOf(a)})&&(a[e.sets.sort().join(c)]={sets:e.sets,value:e.value||0});return a},{});b.reduce(function(a,b,e,d){d.slice(e+1).forEach(function(k){a.push(b+c+k)});return a},[]).forEach(function(a){if(!e[a]){var b={sets:a.split(c),value:0};e[a]=b}});return Object.keys(e).map(function(a){return e[a]})},sortByTotalOverlap:K}});n(a,"Series/Venn/VennSeries.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Color/Color.js"],a["Core/Geometry/CircleUtilities.js"],
a["Series/DrawPointUtilities.js"],a["Core/Geometry/GeometryUtilities.js"],a["Core/Series/SeriesRegistry.js"],a["Series/Venn/VennPoint.js"],a["Series/Venn/VennUtils.js"],a["Core/Legend/LegendSymbol.js"],a["Core/Utilities.js"]],function(a,p,h,f,l,q,m,n,L,g){var u=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(c,b)};
return function(c,b){function e(){this.constructor=c}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");a(c,b);c.prototype=null===b?Object.create(b):(e.prototype=b.prototype,new e)}}(),A=a.animObject,w=p.parse,D=h.getAreaOfIntersectionBetweenCircles,v=h.getCirclesIntersectionPolygon,d=h.isCircle1CompletelyOverlappingCircle2,r=h.isPointInsideAllCircles,H=h.isPointOutsideAllCircles,I=l.getCenterOfPoints,B=q.seriesTypes.scatter;a=
g.addEvent;var F=g.extend,C=g.isArray,z=g.isNumber,G=g.isObject,E=g.merge;g=function(a){function c(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.mapOfIdToRelation=void 0;b.options=void 0;b.points=void 0;return b}u(c,a);c.getLabelPosition=function(a,c){var b=a.reduce(function(b,e){var d=e.r/2;return[{x:e.x,y:e.y},{x:e.x+d,y:e.y},{x:e.x-d,y:e.y},{x:e.x,y:e.y+d},{x:e.x,y:e.y-d}].reduce(function(b,e){var d=n.getMarginFromCircles(e,a,c);b.margin<d&&(b.point=e,b.margin=d);return b},b)},
{point:void 0,margin:-Number.MAX_VALUE}).point;b=n.nelderMead(function(b){return-n.getMarginFromCircles({x:b[0],y:b[1]},a,c)},[b.x,b.y]);b={x:b[0],y:b[1]};r(b,a)&&H(b,c)||(b=1<a.length?I(v(a)):{x:a[0].x,y:a[0].y});return b};c.getLabelValues=function(a,e){var b=a.sets,f=e.reduce(function(a,c){var e=-1<b.indexOf(c.sets[0]);c.circle&&a[e?"internal":"external"].push(c.circle);return a},{internal:[],external:[]});f.external=f.external.filter(function(a){return f.internal.some(function(b){return!d(a,b)})});
a=c.getLabelPosition(f.internal,f.external);e=n.getLabelWidth(a,f.internal,f.external);return{position:a,width:e}};c.layout=function(a){var b={},d={};if(0<a.length){var f=n.layoutGreedyVenn(a),h=a.filter(n.isSet);a.forEach(function(a){var e=a.sets,k=e.join();if(e=n.isSet(a)?f[k]:D(e.map(function(a){return f[a]})))b[k]=e,d[k]=c.getLabelValues(a,h)})}return{mapOfIdToShape:b,mapOfIdToLabelValues:d}};c.getScale=function(a,c,d){var b=d.bottom-d.top,e=d.right-d.left;b=Math.min(0<e?1/e*a:1,0<b?1/b*c:1);
return{scale:b,centerX:a/2-(d.right+d.left)/2*b,centerY:c/2-(d.top+d.bottom)/2*b}};c.updateFieldBoundaries=function(a,c){var b=c.x-c.r,d=c.x+c.r,e=c.y+c.r;c=c.y-c.r;if(!z(a.left)||a.left>b)a.left=b;if(!z(a.right)||a.right<d)a.right=d;if(!z(a.top)||a.top>c)a.top=c;if(!z(a.bottom)||a.bottom<e)a.bottom=e;return a};c.prototype.animate=function(a){if(!a){var b=A(this.options.animation);this.points.forEach(function(a){var c=a.shapeArgs;if(a.graphic&&c){var d={},e={};c.d?d.opacity=.001:(d.r=0,e.r=c.r);a.graphic.attr(d).animate(e,
b);c.d&&setTimeout(function(){a&&a.graphic&&a.graphic.animate({opacity:1})},b.duration)}},this)}};c.prototype.drawPoints=function(){var a=this,c=a.chart,d=a.group,h=c.renderer;(a.points||[]).forEach(function(b){var e={zIndex:C(b.sets)?b.sets.length:0},g=b.shapeArgs;c.styledMode||F(e,a.pointAttribs(b,b.state));f.draw(b,{isNew:!b.graphic,animatableAttribs:g,attribs:e,group:d,renderer:h,shapeType:g&&g.d?"path":"circle"})})};c.prototype.init=function(){B.prototype.init.apply(this,arguments);delete this.opacity};
c.prototype.pointAttribs=function(a,c){var b=this.options||{};a=E(b,{color:a&&a.color},a&&a.options||{},c&&b.states[c]||{});return{fill:w(a.color).brighten(a.brightness).get(),opacity:a.opacity,stroke:a.borderColor,"stroke-width":a.borderWidth,dashstyle:a.borderDashStyle}};c.prototype.translate=function(){var a=this.chart;this.processedXData=this.xData;this.generatePoints();var d=n.processVennData(this.options.data,c.splitter);d=c.layout(d);var f=d.mapOfIdToShape,h=d.mapOfIdToLabelValues;d=Object.keys(f).filter(function(a){return(a=
f[a])&&z(a.r)}).reduce(function(a,b){return c.updateFieldBoundaries(a,f[b])},{top:0,bottom:0,left:0,right:0});a=c.getScale(a.plotWidth,a.plotHeight,d);var g=a.scale,l=a.centerX,m=a.centerY;this.points.forEach(function(a){var c=C(a.sets)?a.sets:[],b=c.join(),d=f[b],e=h[b]||{};b=e.width;e=e.position;var k=a.options&&a.options.dataLabels;if(d){if(d.r)var n={x:l+d.x*g,y:m+d.y*g,r:d.r*g};else d.d&&(d=d.d,d.forEach(function(a){"M"===a[0]?(a[1]=l+a[1]*g,a[2]=m+a[2]*g):"A"===a[0]&&(a[1]*=g,a[2]*=g,a[6]=l+
a[6]*g,a[7]=m+a[7]*g)}),n={d});e?(e.x=l+e.x*g,e.y=m+e.y*g):e={};z(b)&&(b=Math.round(b*g))}a.shapeArgs=n;e&&n&&(a.plotX=e.x,a.plotY=e.y);b&&n&&(a.dlOptions=E(!0,{style:{width:b}},G(k,!0)?k:void 0));a.name=a.options.name||c.join("\u2229")})};c.splitter="highcharts-split";c.defaultOptions=E(B.defaultOptions,{borderColor:"#cccccc",borderDashStyle:"solid",borderWidth:1,brighten:0,clip:!1,colorByPoint:!0,dataLabels:{enabled:!0,verticalAlign:"middle",formatter:function(){return this.point.name}},inactiveOtherPoints:!0,
marker:!1,opacity:.75,showInLegend:!1,legendType:"point",states:{hover:{opacity:1,borderColor:"#333333"},select:{color:"#cccccc",borderColor:"#000000",animation:!1},inactive:{opacity:.075}},tooltip:{pointFormat:"{point.name}: {point.value}"}});return c}(B);F(g.prototype,{axisTypes:[],directTouch:!0,drawLegendSymbol:L.drawRectangle,isCartesian:!1,pointArrayMap:["value"],pointClass:m,utils:n});q.registerSeriesType("venn",g);"";a(g,"afterSetOptions",function(a){var c=a.options.states;this.is("venn")&&
Object.keys(c).forEach(function(a){c[a].halo=!1})});return g});n(a,"masters/modules/venn.src.js",[],function(){})});
//# sourceMappingURL=venn.js.map