/*
 Highcharts Gantt JS v11.0.0 (2023-04-26)

 Tree Grid

 (c) 2016-2021 Jon Arild Nygard

 License: www.highcharts.com/license
*/
'use strict';(function(e){"object"===typeof module&&module.exports?(e["default"]=e,module.exports=e):"function"===typeof define&&define.amd?define("highcharts/modules/treegrid",["highcharts"],function(G){e(G);e.Highcharts=G;return e}):e("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(e){function G(e,v,u,N){e.hasOwnProperty(v)||(e[v]=N.apply(null,u),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:v,module:e[v]}})))}e=e?e._modules:
{};G(e,"Core/Axis/BrokenAxis.js",[e["Core/Axis/Stacking/StackItem.js"],e["Core/Utilities.js"]],function(e,v){var u=v.addEvent,D=v.find,F=v.fireEvent,w=v.isArray,l=v.isNumber,B=v.pick,y;(function(a){function z(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function E(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function J(){var a=this.brokenAxis;if(a&&a.hasBreaks){for(var b=this.tickPositions,A=this.tickPositions.info,h=[],f=0;f<
b.length;f++)a.isInAnyBreak(b[f])||h.push(b[f]);this.tickPositions=h;this.tickPositions.info=A}}function g(){this.brokenAxis||(this.brokenAxis=new y(this))}function q(){var a=this.options.connectNulls,b=this.points,A=this.xAxis,h=this.yAxis;if(this.isDirty)for(var f=b.length;f--;){var d=b[f],m=!(null===d.y&&!1===a)&&(A&&A.brokenAxis&&A.brokenAxis.isInAnyBreak(d.x,!0)||h&&h.brokenAxis&&h.brokenAxis.isInAnyBreak(d.y,!0));d.visible=m?!1:!1!==d.options.visible}}function n(){this.drawBreaks(this.xAxis,
["x"]);this.drawBreaks(this.yAxis,B(this.pointArrayMap,["y"]))}function c(a,b){var A=this,h=A.points,f,d,m,x;if(a&&a.brokenAxis&&a.brokenAxis.hasBreaks){var c=a.brokenAxis;b.forEach(function(b){f=c&&c.breakArray||[];d=a.isXAxis?a.min:B(A.options.threshold,a.min);h.forEach(function(h){x=B(h["stack"+b.toUpperCase()],h[b]);f.forEach(function(b){if(l(d)&&l(x)){m=!1;if(d<b.from&&x>b.to||d>b.from&&x<b.from)m="pointBreak";else if(d<b.from&&x>b.from&&x<b.to||d>b.from&&x>b.to&&x<b.from)m="pointInBreak";m&&
F(a,m,{point:h,brk:b})}})})})}}function p(){var a=this.currentDataGrouping,b=a&&a.gapSize;a=this.points.slice();var c=this.yAxis,h=this.options.gapSize,f=a.length-1,d;if(h&&0<f)for("value"!==this.options.gapUnit&&(h*=this.basePointRange),b&&b>h&&b>=this.basePointRange&&(h=b),d=void 0;f--;)d&&!1!==d.visible||(d=a[f+1]),b=a[f],!1!==d.visible&&!1!==b.visible&&(d.x-b.x>h&&(d=(b.x+d.x)/2,a.splice(f+1,0,{isNull:!0,x:d}),c.stacking&&this.options.stacking&&(d=c.stacking.stacks[this.stackKey][d]=new e(c,c.options.stackLabels,
!1,d,this.stack),d.total=0)),d=b);return this.getGraphPath(a)}var r=[];a.compose=function(a,b){v.pushUnique(r,a)&&(a.keepProps.push("brokenAxis"),u(a,"init",g),u(a,"afterInit",z),u(a,"afterSetTickPositions",J),u(a,"afterSetOptions",E));if(v.pushUnique(r,b)){var A=b.prototype;A.drawBreaks=c;A.gappedPath=p;u(b,"afterGeneratePoints",q);u(b,"afterRender",n)}return a};var y=function(){function a(a){this.hasBreaks=!1;this.axis=a}a.isInBreak=function(a,c){var b=a.repeat||Infinity,f=a.from,d=a.to-a.from;
c=c>=f?(c-f)%b:b-(f-c)%b;return a.inclusive?c<=d:c<d&&0!==c};a.lin2Val=function(b){var c=this.brokenAxis;c=c&&c.breakArray;if(!c||!l(b))return b;var h;for(h=0;h<c.length;h++){var f=c[h];if(f.from>=b)break;else f.to<b?b+=f.len:a.isInBreak(f,b)&&(b+=f.len)}return b};a.val2Lin=function(b){var c=this.brokenAxis;c=c&&c.breakArray;if(!c||!l(b))return b;var h=b,f;for(f=0;f<c.length;f++){var d=c[f];if(d.to<=b)h-=d.len;else if(d.from>=b)break;else if(a.isInBreak(d,b)){h-=b-d.from;break}}return h};a.prototype.findBreakAt=
function(a,c){return D(c,function(b){return b.from<a&&a<b.to})};a.prototype.isInAnyBreak=function(b,c){var h=this.axis,f=h.options.breaks||[],d=f.length,m;if(d&&l(b)){for(;d--;)if(a.isInBreak(f[d],b)){var x=!0;m||(m=B(f[d].showPoints,!h.isXAxis))}var g=x&&c?x&&!m:x}return g};a.prototype.setBreaks=function(b,c){var h=this,f=h.axis,d=w(b)&&!!b.length;f.isDirty=h.hasBreaks!==d;h.hasBreaks=d;f.options.breaks=f.userOptions.breaks=b;f.forceRedraw=!0;f.series.forEach(function(a){a.isDirty=!0});d||f.val2lin!==
a.val2Lin||(delete f.val2lin,delete f.lin2val);d&&(f.userOptions.ordinal=!1,f.lin2val=a.lin2Val,f.val2lin=a.val2Lin,f.setExtremes=function(a,b,c,d,g){if(h.hasBreaks){for(var m=this.options.breaks||[],x;x=h.findBreakAt(a,m);)a=x.to;for(;x=h.findBreakAt(b,m);)b=x.from;b<a&&(b=a)}f.constructor.prototype.setExtremes.call(this,a,b,c,d,g)},f.setAxisTranslation=function(){f.constructor.prototype.setAxisTranslation.call(this);h.unitLength=void 0;if(h.hasBreaks){var b=f.options.breaks||[],c=[],d=[],g=B(f.pointRangePadding,
0),p=0,n,q=f.userMin||f.min,r=f.userMax||f.max,k;b.forEach(function(k){n=k.repeat||Infinity;l(q)&&l(r)&&(a.isInBreak(k,q)&&(q+=k.to%n-q%n),a.isInBreak(k,r)&&(r-=r%n-k.from%n))});b.forEach(function(a){C=a.from;n=a.repeat||Infinity;if(l(q)&&l(r)){for(;C-n>q;)C-=n;for(;C<q;)C+=n;for(k=C;k<r;k+=n)c.push({value:k,move:"in"}),c.push({value:k+a.to-a.from,move:"out",size:a.breakSize})}});c.sort(function(k,a){return k.value===a.value?("in"===k.move?0:1)-("in"===a.move?0:1):k.value-a.value});var t=0;var C=
q;c.forEach(function(k){t+="in"===k.move?1:-1;1===t&&"in"===k.move&&(C=k.value);0===t&&l(C)&&(d.push({from:C,to:k.value,len:k.value-C-(k.size||0)}),p+=k.value-C-(k.size||0))});h.breakArray=d;l(q)&&l(r)&&l(f.min)&&(h.unitLength=r-q-p+g,F(f,"afterBreaks"),f.staticScale?f.transA=f.staticScale:h.unitLength&&(f.transA*=(r-f.min+g)/h.unitLength),g&&(f.minPixelPadding=f.transA*(f.minPointOffset||0)),f.min=q,f.max=r)}});B(c,!0)&&f.chart.redraw()};return a}();a.Additions=y})(y||(y={}));return y});G(e,"Core/Axis/GridAxis.js",
[e["Core/Axis/Axis.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(e,v,u){function D(k,a){var t={width:0,height:0};a.forEach(function(a){a=k[a];if(u.isObject(a,!0)){var b=u.isObject(a.label,!0)?a.label:{};a=b.getBBox?b.getBBox().height:0;b.textStr&&!m(b.textPxLength)&&(b.textPxLength=b.getBBox().width);var c=m(b.textPxLength)?Math.round(b.textPxLength):0;b.textStr&&(c=Math.round(b.getBBox().width));t.height=Math.max(a,t.height);t.width=Math.max(c,t.width)}});"treegrid"===this.options.type&&
this.treeGrid&&this.treeGrid.mapOfPosToGridNode&&(t.width+=this.options.labels.indentation*((this.treeGrid.mapOfPosToGridNode[-1].height||0)-1));return t}function F(){var k=this.grid;(k&&k.columns||[]).forEach(function(k){k.getOffset()})}function w(k){if(!0===(this.options.grid||{}).enabled){var a=this.axisTitle,b=this.height,c=this.horiz,m=this.left,d=this.offset,f=this.opposite,g=this.options,x=this.top,h=this.width,n=this.tickSize(),p=a&&a.getBBox().width,q=g.title.x,r=g.title.y;g=H(g.title.margin,
c?5:10);a=a?this.chart.renderer.fontMetrics(a).f:0;n=(c?x+b:m)+(c?1:-1)*(f?-1:1)*(n?n[0]/2:0)+(this.side===I.bottom?a:0);k.titlePosition.x=c?m-(p||0)/2-g+q:n+(f?h:0)+d+q;k.titlePosition.y=c?n-(f?b:0)+(f?a:-a)/2+d+r:x-g+r}}function l(){var a=this.chart,t=this.options.grid;t=void 0===t?{}:t;var b=this.userOptions;if(t.enabled){var c=this.options;c.labels.align=H(c.labels.align,"center");this.categories||(c.showLastLabel=!1);this.labelRotation=0;c.labels.rotation=0}if(t.columns){c=this.grid.columns=
[];for(var m=this.grid.columnIndex=0;++m<t.columns.length;){var d=x(b,t.columns[t.columns.length-m-1],{linkedTo:0,type:"category",scrollbar:{enabled:!1}});delete d.grid.columns;d=new e(this.chart,d);d.grid.isColumn=!0;d.grid.columnIndex=m;h(a.axes,d);h(a[this.coll],d);c.push(d)}}}function B(){var a=this.grid,t=this.options;if(!0===(t.grid||{}).enabled){var b=this.min||0,c=this.max||0;this.maxLabelDimensions=this.getMaxLabelDimensions(this.ticks,this.tickPositions);this.rightWall&&this.rightWall.destroy();
if(this.grid&&this.grid.isOuterAxis()&&this.axisLine){var m=t.lineWidth;if(m){m=this.getLinePath(m);var d=m[0],f=m[1],g=((this.tickSize("tick")||[1])[0]-1)*(this.side===I.top||this.side===I.left?-1:1);"M"===d[0]&&"L"===f[0]&&(this.horiz?(d[2]+=g,f[2]+=g):(d[1]+=g,f[1]+=g));!this.horiz&&this.chart.marginRight&&(d=[d,["L",this.left,d[2]||0]],g=["L",this.chart.chartWidth-this.chart.marginRight,this.toPixels(c+this.tickmarkOffset)],f=[["M",f[1]||0,this.toPixels(c+this.tickmarkOffset)],g],this.grid.upperBorder||
0===b%1||(this.grid.upperBorder=this.grid.renderBorder(d)),this.grid.upperBorder&&(this.grid.upperBorder.attr({stroke:t.lineColor,"stroke-width":t.lineWidth}),this.grid.upperBorder.animate({d})),this.grid.lowerBorder||0===c%1||(this.grid.lowerBorder=this.grid.renderBorder(f)),this.grid.lowerBorder&&(this.grid.lowerBorder.attr({stroke:t.lineColor,"stroke-width":t.lineWidth}),this.grid.lowerBorder.animate({d:f})));this.grid.axisLineExtra?(this.grid.axisLineExtra.attr({stroke:t.lineColor,"stroke-width":t.lineWidth}),
this.grid.axisLineExtra.animate({d:m})):this.grid.axisLineExtra=this.grid.renderBorder(m);this.axisLine[this.showAxis?"show":"hide"]()}}(a&&a.columns||[]).forEach(function(a){return a.render()});if(!this.horiz&&this.chart.hasRendered&&(this.scrollbar||this.linkedParent&&this.linkedParent.scrollbar)){a=this.tickmarkOffset;t=this.tickPositions[this.tickPositions.length-1];m=this.tickPositions[0];for(d=f=void 0;(f=this.hiddenLabels.pop())&&f.element;)f.show();for(;(d=this.hiddenMarks.pop())&&d.element;)d.show();
(f=this.ticks[m].label)&&(b-m>a?this.hiddenLabels.push(f.hide()):f.show());(f=this.ticks[t].label)&&(t-c>a?this.hiddenLabels.push(f.hide()):f.show());(b=this.ticks[t].mark)&&t-c<a&&0<t-c&&this.ticks[t].isLast&&this.hiddenMarks.push(b.hide())}}}function y(){var a=this.tickPositions&&this.tickPositions.info,t=this.options,b=this.userOptions.labels||{};(t.grid||{}).enabled&&(this.horiz?(this.series.forEach(function(a){a.options.pointRange=0}),a&&t.dateTimeLabelFormats&&t.labels&&!A(b.align)&&(!1===t.dateTimeLabelFormats[a.unitName].range||
1<a.count)&&(t.labels.align="left",A(b.x)||(t.labels.x=3))):"treegrid"!==this.options.type&&this.grid&&this.grid.columns&&(this.minPointOffset=this.tickInterval))}function a(a){var k=this.options;a=a.userOptions;var b=k&&u.isObject(k.grid,!0)?k.grid:{};if(!0===b.enabled){var c=x(!0,{className:"highcharts-grid-axis "+(a.className||""),dateTimeLabelFormats:{hour:{list:["%H:%M","%H"]},day:{list:["%A, %e. %B","%a, %e. %b","%E"]},week:{list:["Week %W","W%W"]},month:{list:["%B","%b","%o"]}},grid:{borderWidth:1},
labels:{padding:2,style:{fontSize:"0.9em"}},margin:0,title:{text:null,reserveSpace:!1,rotation:0},units:[["millisecond",[1,10,100]],["second",[1,10]],["minute",[1,5,15]],["hour",[1,6]],["day",[1]],["week",[1]],["month",[1]],["year",null]]},a);"xAxis"===this.coll&&(A(a.linkedTo)&&!A(a.tickPixelInterval)&&(c.tickPixelInterval=350),A(a.tickPixelInterval)||!A(a.linkedTo)||A(a.tickPositioner)||A(a.tickInterval)||(c.tickPositioner=function(a,k){var b=this.linkedParent&&this.linkedParent.tickPositions&&
this.linkedParent.tickPositions.info;if(b){for(var t=c.units||[],d=void 0,f=1,C="year",g=0;g<t.length;g++){var x=t[g];if(x&&x[0]===b.unitName){d=g;break}}(t=m(d)&&t[d+1])?(C=t[0]||"year",f=(f=t[1])&&f[0]||1):"year"===b.unitName&&(f=10*b.count);b=O[C];this.tickInterval=b*f;return this.chart.time.getTimeTicks({unitRange:b,count:f,unitName:C},a,k,this.options.startOfWeek)}}));x(!0,this.options,c);this.horiz&&(k.minPadding=H(a.minPadding,0),k.maxPadding=H(a.maxPadding,0));m(k.grid.borderWidth)&&(k.tickWidth=
k.lineWidth=b.borderWidth)}}function z(a){a=(a=a.userOptions)&&a.grid||{};var k=a.columns;a.enabled&&k&&x(!0,this.options,k[k.length-1])}function E(){(this.grid.columns||[]).forEach(function(a){return a.setScale()})}function J(a){var k=this.horiz,b=this.maxLabelDimensions,c=this.options.grid;c=void 0===c?{}:c;if(c.enabled&&b){var m=2*this.options.labels.distance;k=k?c.cellHeight||m+b.height:m+b.width;d(a.tickSize)?a.tickSize[0]=k:a.tickSize=[k,0]}}function g(){this.axes.forEach(function(a){(a.grid&&
a.grid.columns||[]).forEach(function(a){a.setAxisSize();a.setAxisTranslation()})})}function q(a){var b=this.grid;(b.columns||[]).forEach(function(b){return b.destroy(a.keepEvents)});b.columns=void 0}function n(a){a=a.userOptions||{};var b=a.grid||{};b.enabled&&A(b.borderColor)&&(a.tickColor=a.lineColor=b.borderColor);this.grid||(this.grid=new Q(this));this.hiddenLabels=[];this.hiddenMarks=[]}function c(a){var b=this.label,c=this.axis,k=c.reversed,d=c.chart,f=c.options.grid||{},g=c.options.labels,
x=g.align,h=I[c.side],n=a.tickmarkOffset,q=c.tickPositions,p=this.pos-n;q=m(q[a.index+1])?q[a.index+1]-n:(c.max||0)+n;var r=c.tickSize("tick");n=r?r[0]:0;r=r?r[1]/2:0;if(!0===f.enabled){if("top"===h){f=c.top+c.offset;var H=f-n}else"bottom"===h?(H=d.chartHeight-c.bottom+c.offset,f=H+n):(f=c.top+c.len-(c.translate(k?q:p)||0),H=c.top+c.len-(c.translate(k?p:q)||0));"right"===h?(h=d.chartWidth-c.right+c.offset,k=h+n):"left"===h?(k=c.left+c.offset,h=k-n):(h=Math.round(c.left+(c.translate(k?q:p)||0))-r,
k=Math.min(Math.round(c.left+(c.translate(k?p:q)||0))-r,c.left+c.len));this.slotWidth=k-h;a.pos.x="left"===x?h:"right"===x?k:h+(k-h)/2;a.pos.y=H+(f-H)/2;b&&(d=d.renderer.fontMetrics(b),b=b.getBBox().height,a.pos.y=g.useHTML?a.pos.y+(d.b+-(b/2)):a.pos.y+((d.b-(d.h-d.f))/2+-((Math.round(b/d.h)-1)*d.h/2)));a.pos.x+=c.horiz&&g.x||0}}function p(a){var c=a.axis,b=a.value;if(c.options.grid&&c.options.grid.enabled){var k=c.tickPositions,d=(c.linkedParent||c).series[0],m=b===k[0];k=b===k[k.length-1];var g=
d&&f(d.options.data,function(a){return a[c.isXAxis?"x":"y"]===b}),h=void 0;g&&d.is("gantt")&&(h=x(g),v.seriesTypes.gantt.prototype.pointClass.setGanttPointAliases(h));a.isFirst=m;a.isLast=k;a.point=h}}function r(){var a=this.options,c=this.categories,b=this.tickPositions,d=b[0],m=b[b.length-1],f=this.linkedParent&&this.linkedParent.min||this.min,g=this.linkedParent&&this.linkedParent.max||this.max,h=this.tickInterval;!0!==(a.grid||{}).enabled||c||!this.horiz&&!this.isLinked||(d<f&&d+h>f&&!a.startOnTick&&
(b[0]=f),m>g&&m-h<g&&!a.endOnTick&&(b[b.length-1]=g))}function L(a){var c=this.options.grid;return!0===(void 0===c?{}:c).enabled&&this.categories?this.tickInterval:a.apply(this,Array.prototype.slice.call(arguments,1))}var K=v.dateFormats,b=u.addEvent,A=u.defined,h=u.erase,f=u.find,d=u.isArray,m=u.isNumber,x=u.merge,H=u.pick,O=u.timeUnits,P=u.wrap,I;(function(a){a[a.top=0]="top";a[a.right=1]="right";a[a.bottom=2]="bottom";a[a.left=3]="left"})(I||(I={}));var M=[],Q=function(){function a(a){this.axis=
a}a.prototype.isOuterAxis=function(){var a=this.axis,c=a.grid.columnIndex,b=a.linkedParent&&a.linkedParent.grid.columns||a.grid.columns,d=c?a.linkedParent:a,k=-1,f=0;(a.chart[a.coll]||[]).forEach(function(c,b){c.side!==a.side||c.options.isInternal||(f=b,c===d&&(k=b))});return f===k&&(m(c)?b.length===c:!0)};a.prototype.renderBorder=function(a){var c=this.axis,b=c.chart.renderer,d=c.options;a=b.path(a).addClass("highcharts-axis-line").add(c.axisBorder);b.styledMode||a.attr({stroke:d.lineColor,"stroke-width":d.lineWidth,
zIndex:7});return a};return a}();K.E=function(a){return this.dateFormat("%a",a,!0).charAt(0)};K.W=function(a){var c=this,b=new this.Date(a);["Hours","Milliseconds","Minutes","Seconds"].forEach(function(a){c.set(a,b,0)});var d=(this.get("Day",b)+6)%7;a=new this.Date(b.valueOf());this.set("Date",a,this.get("Date",b)-d+3);d=new this.Date(this.get("FullYear",a),0,1);4!==this.get("Day",d)&&(this.set("Month",b,0),this.set("Date",b,1+(11-this.get("Day",d))%7));return(1+Math.floor((a.valueOf()-d.valueOf())/
6048E5)).toString()};"";return{compose:function(d,f,m){u.pushUnique(M,d)&&(d.keepProps.push("grid"),d.prototype.getMaxLabelDimensions=D,P(d.prototype,"unsquish",L),b(d,"init",n),b(d,"afterGetOffset",F),b(d,"afterGetTitlePosition",w),b(d,"afterInit",l),b(d,"afterRender",B),b(d,"afterSetAxisTranslation",y),b(d,"afterSetOptions",a),b(d,"afterSetOptions",z),b(d,"afterSetScale",E),b(d,"afterTickSize",J),b(d,"trimTicks",r),b(d,"destroy",q));u.pushUnique(M,f)&&b(f,"afterSetChartSize",g);u.pushUnique(M,m)&&
(b(m,"afterGetLabelPosition",c),b(m,"labelFormat",p));return d}}});G(e,"Gantt/Tree.js",[e["Core/Utilities.js"]],function(e){var v=e.extend,u=e.isNumber,D=e.pick,F=function(e,u){var l=e.reduce(function(a,e){var l=D(e.parent,"");"undefined"===typeof a[l]&&(a[l]=[]);a[l].push(e);return a},{});Object.keys(l).forEach(function(a,e){var z=l[a];""!==a&&-1===u.indexOf(a)&&(z.forEach(function(a){e[""].push(a)}),delete e[a])});return l},w=function(e,B,y,a,z,E){var l=0,g=0,q=E&&E.after,n=E&&E.before;B={data:a,
depth:y-1,id:e,level:y,parent:B};var c,p;"function"===typeof n&&n(B,E);n=(z[e]||[]).map(function(a){var n=w(a.id,e,y+1,a,z,E),q=a.start;a=!0===a.milestone?q:a.end;c=!u(c)||q<c?q:c;p=!u(p)||a>p?a:p;l=l+1+n.descendants;g=Math.max(n.height+1,g);return n});a&&(a.start=D(a.start,c),a.end=D(a.end,p));v(B,{children:n,descendants:l,height:g});"function"===typeof q&&q(B,E);return B};return{getListOfParents:F,getNode:w,getTree:function(e,u){var l=e.map(function(a){return a.id});e=F(e,l);return w("",null,1,
null,e,u)}}});G(e,"Core/Axis/TreeGrid/TreeGridTick.js",[e["Core/Utilities.js"]],function(e){function v(){this.treeGrid||(this.treeGrid=new E(this))}function u(a,g){a=a.treeGrid;var q=!a.labelIcon,n=g.renderer,c=g.xy,e=g.options,r=e.width||0,l=e.height||0,u=c.x-r/2-(e.padding||0);c=c.y-l/2;var b=g.collapsed?90:180,z=g.show&&B(c),h=a.labelIcon;h||(a.labelIcon=h=n.path(n.symbols[e.type](e.x||0,e.y||0,r,l)).addClass("highcharts-label-icon").add(g.group));h[z?"show":"hide"]();n.styledMode||h.attr({cursor:"pointer",
fill:y(g.color,"#666666"),"stroke-width":1,stroke:e.lineColor,strokeWidth:e.lineWidth||0});h[q?"attr":"animate"]({translateX:u,translateY:c,rotation:b})}function D(a,g,e,n,c,p,r,u,z){var b=y(this.options&&this.options.labels,p);p=this.pos;var q=this.axis,h="treegrid"===q.options.type;a=a.apply(this,[g,e,n,c,b,r,u,z]);h&&(g=b&&l(b.symbol,!0)?b.symbol:{},b=b&&B(b.indentation)?b.indentation:0,p=(p=(q=q.treeGrid.mapOfPosToGridNode)&&q[p])&&p.depth||1,a.x+=(g.width||0)+2*(g.padding||0)+(p-1)*b);return a}
function F(a){var g=this,e=g.pos,n=g.axis,c=g.label,p=n.treeGrid.mapOfPosToGridNode,r=n.options,z=y(g.options&&g.options.labels,r&&r.labels),v=z&&l(z.symbol,!0)?z.symbol:{},b=(p=p&&p[e])&&p.depth;r="treegrid"===r.type;var A=-1<n.tickPositions.indexOf(e);e=n.chart.styledMode;r&&p&&c&&c.element&&c.addClass("highcharts-treegrid-node-level-"+b);a.apply(g,Array.prototype.slice.call(arguments,1));r&&c&&c.element&&p&&p.descendants&&0<p.descendants&&(n=n.treeGrid.isCollapsed(p),u(g,{color:!e&&c.styles&&c.styles.color||
"",collapsed:n,group:c.parentGroup,options:v,renderer:c.renderer,show:A,xy:c.xy}),v="highcharts-treegrid-node-"+(n?"expanded":"collapsed"),c.addClass("highcharts-treegrid-node-"+(n?"collapsed":"expanded")).removeClass(v),e||c.css({cursor:"pointer"}),[c,g.treeGrid.labelIcon].forEach(function(a){a&&!a.attachedTreeGridEvents&&(w(a.element,"mouseover",function(){c.addClass("highcharts-treegrid-node-active");c.renderer.styledMode||c.css({textDecoration:"underline"})}),w(a.element,"mouseout",function(){var a=
l(z.style)?z.style:{};c.removeClass("highcharts-treegrid-node-active");c.renderer.styledMode||c.css({textDecoration:a.textDecoration})}),w(a.element,"click",function(){g.treeGrid.toggleCollapse()}),a.attachedTreeGridEvents=!0)}))}var w=e.addEvent,l=e.isObject,B=e.isNumber,y=e.pick,a=e.wrap,z=[],E=function(){function l(a){this.tick=a}l.compose=function(g){e.pushUnique(z,g)&&(w(g,"init",v),a(g.prototype,"getLabelPosition",D),a(g.prototype,"renderLabel",F),g.prototype.collapse=function(a){this.treeGrid.collapse(a)},
g.prototype.expand=function(a){this.treeGrid.expand(a)},g.prototype.toggleCollapse=function(a){this.treeGrid.toggleCollapse(a)})};l.prototype.collapse=function(a){var g=this.tick,e=g.axis,c=e.brokenAxis;c&&e.treeGrid.mapOfPosToGridNode&&(g=e.treeGrid.collapse(e.treeGrid.mapOfPosToGridNode[g.pos]),c.setBreaks(g,y(a,!0)))};l.prototype.destroy=function(){this.labelIcon&&this.labelIcon.destroy()};l.prototype.expand=function(a){var g=this.tick,e=g.axis,c=e.brokenAxis;c&&e.treeGrid.mapOfPosToGridNode&&
(g=e.treeGrid.expand(e.treeGrid.mapOfPosToGridNode[g.pos]),c.setBreaks(g,y(a,!0)))};l.prototype.toggleCollapse=function(a){var g=this.tick,e=g.axis,c=e.brokenAxis;c&&e.treeGrid.mapOfPosToGridNode&&(g=e.treeGrid.toggleCollapse(e.treeGrid.mapOfPosToGridNode[g.pos]),c.setBreaks(g,y(a,!0)))};return l}();return E});G(e,"Series/TreeUtilities.js",[e["Core/Color/Color.js"],e["Core/Utilities.js"]],function(e,v){function u(a,e){var l=e.before,z=e.idRoot,g=e.mapIdToNode[z],q=e.points[a.i],n=q&&q.options||{},
c=[],p=0;a.levelDynamic=a.level-(!1!==e.levelIsConstant?0:g.level);a.name=y(q&&q.name,"");a.visible=z===a.id||!0===e.visible;"function"===typeof l&&(a=l(a,e));a.children.forEach(function(g,n){var l=D({},e);D(l,{index:n,siblings:a.children.length,visible:a.visible});g=u(g,l);c.push(g);g.visible&&(p+=g.val)});l=y(n.value,p);a.visible=0<=l&&(0<p||a.visible);a.children=c;a.childrenTotal=p;a.isLeaf=a.visible&&!p;a.val=l;return a}var D=v.extend,F=v.isArray,w=v.isNumber,l=v.isObject,B=v.merge,y=v.pick;return{getColor:function(a,
l){var u=l.index,v=l.mapOptionsToLevel,g=l.parentColor,q=l.parentColorIndex,n=l.series,c=l.colors,p=l.siblings,r=n.points,z=n.chart.options.chart,w;if(a){r=r[a.i];a=v[a.level]||{};if(v=r&&a.colorByPoint){var b=r.index%(c?c.length:z.colorCount);var A=c&&c[b]}if(!n.chart.styledMode){c=r&&r.options.color;z=a&&a.color;if(w=g)w=(w=a&&a.colorVariation)&&"brightness"===w.key&&u&&p?e.parse(g).brighten(u/p*w.to).get():g;w=y(c,z,A,w,n.color)}var h=y(r&&r.options.colorIndex,a&&a.colorIndex,b,q,l.colorIndex)}return{color:w,
colorIndex:h}},getLevelOptions:function(a){var e={};if(l(a)){var u=w(a.from)?a.from:1;var v=a.levels;var g={};var q=l(a.defaults)?a.defaults:{};F(v)&&(g=v.reduce(function(a,c){if(l(c)&&w(c.level)){var e=B({},c);var g=y(e.levelIsConstant,q.levelIsConstant);delete e.levelIsConstant;delete e.level;c=c.level+(g?0:u-1);l(a[c])?B(!0,a[c],e):a[c]=e}return a},{}));v=w(a.to)?a.to:1;for(a=0;a<=v;a++)e[a]=B({},q,l(g[a])?g[a]:{})}return e},setTreeValues:u,updateRootId:function(a){if(l(a)){var e=l(a.options)?
a.options:{};e=y(a.rootNode,e.rootId,"");l(a.userOptions)&&(a.userOptions.rootId=e);a.rootNode=e}return e}}});G(e,"Core/Axis/TreeGrid/TreeGridAxis.js",[e["Core/Axis/BrokenAxis.js"],e["Core/Axis/GridAxis.js"],e["Gantt/Tree.js"],e["Core/Axis/TreeGrid/TreeGridTick.js"],e["Series/TreeUtilities.js"],e["Core/Utilities.js"]],function(e,v,u,G,F,w){function l(a,c){var b=a.collapseEnd||0;a=a.collapseStart||0;b>=c&&(a-=.5);return{from:a,to:b,showPoints:!1}}function B(a,c,b){var d=[],e=[],f={},m="boolean"===
typeof c?c:!1,g={},h=-1;a=u.getTree(a,{after:function(a){a=g[a.pos];var c=0,b=0;a.children.forEach(function(a){b+=(a.descendants||0)+1;c=Math.max((a.height||0)+1,c)});a.descendants=b;a.height=c;a.collapsed&&e.push(a)},before:function(a){var c=p(a.data,!0)?a.data:{},b=r(c.name)?c.name:"",e=f[a.parent];e=p(e,!0)?g[e.pos]:null;var k=function(a){return a.name===b},l;m&&p(e,!0)&&(l=q(e.children,k))?(k=l.pos,l.nodes.push(a)):k=h++;g[k]||(g[k]=l={depth:e?e.depth+1:0,name:b,id:c.id,nodes:[a],children:[],
pos:k},-1!==k&&d.push(b),p(e,!0)&&e.children.push(l));r(a.id)&&(f[a.id]=a);l&&!0===c.collapsed&&(l.collapsed=!0);a.pos=k}});g=function(a,c){var b=function(a,d,e){var f=d+(-1===d?0:c-1),g=(f-d)/2,m=d+g;a.nodes.forEach(function(a){var c=a.data;p(c,!0)&&(c.y=d+(c.seriesIndex||0),delete c.seriesIndex);a.pos=m});e[m]=a;a.pos=m;a.tickmarkOffset=g+.5;a.collapseStart=f+.5;a.children.forEach(function(a){b(a,f+1,e);f=(a.collapseEnd||0)-.5});a.collapseEnd=f+.5;return e};return b(a["-1"],-1,{})}(g,b);return{categories:d,
mapOfIdToNode:f,mapOfPosToGridNode:g,collapsedNodes:e,tree:a}}function y(a){a.target.axes.filter(function(a){return"treegrid"===a.options.type}).forEach(function(b){var d=b.options||{},e=d.labels,f=d.uniqueNames;d=d.max;var g=0;if(!b.treeGrid.mapOfPosToGridNode||b.series.some(function(a){return!a.hasRendered||a.isDirtyData||a.isDirty})){var m=b.series.reduce(function(a,b){b.visible&&((b.options.data||[]).forEach(function(c){b.options.keys&&b.options.keys.length&&(c=b.pointClass.prototype.optionsToObject.call({series:b},
c),b.pointClass.setGanttPointAliases(c));p(c,!0)&&(c.seriesIndex=g,a.push(c))}),!0===f&&g++);return a},[]);if(d&&m.length<d)for(var h=m.length;h<=d;h++)m.push({name:h+"\u200b"});d=B(m,f||!1,!0===f?g:1);b.categories=d.categories;b.treeGrid.mapOfPosToGridNode=d.mapOfPosToGridNode;b.hasNames=!0;b.treeGrid.tree=d.tree;b.series.forEach(function(a){var b=(a.options.data||[]).map(function(b){c(b)&&a.options.keys&&a.options.keys.length&&m.forEach(function(a){0<=b.indexOf(a.x)&&0<=b.indexOf(a.x2)&&(b=a)});
return p(b,!0)?L(b):b});a.visible&&a.setData(b,!1)});b.treeGrid.mapOptionsToLevel=J({defaults:e,from:1,levels:e&&e.levels,to:b.treeGrid.tree&&b.treeGrid.tree.height});"beforeRender"===a.type&&(b.treeGrid.collapsedNodes=d.collapsedNodes)}})}function a(a,b){var c=this.treeGrid.mapOptionsToLevel||{},d=this.ticks,e=d[b],f;if("treegrid"===this.options.type&&this.treeGrid.mapOfPosToGridNode){var g=this.treeGrid.mapOfPosToGridNode[b];(c=c[g.depth])&&(f={labels:c});!e&&h?d[b]=new h(this,b,void 0,void 0,{category:g.name,
tickmarkOffset:g.tickmarkOffset,options:f}):(e.parameters.category=g.name,e.options=f,e.addLabel())}else a.apply(this,Array.prototype.slice.call(arguments,1))}function z(a,b,c){var d=this,e="treegrid"===c.type;d.treeGrid||(d.treeGrid=new f(d));e&&(g(b,"beforeRender",y),g(b,"beforeRedraw",y),g(b,"addSeries",function(a){a.options.data&&(a=B(a.options.data,c.uniqueNames||!1,1),d.treeGrid.collapsedNodes=(d.treeGrid.collapsedNodes||[]).concat(a.collapsedNodes))}),g(d,"foundExtremes",function(){d.treeGrid.collapsedNodes&&
d.treeGrid.collapsedNodes.forEach(function(a){var b=d.treeGrid.collapse(a);d.brokenAxis&&(d.brokenAxis.setBreaks(b,!1),d.treeGrid.collapsedNodes&&(d.treeGrid.collapsedNodes=d.treeGrid.collapsedNodes.filter(function(b){return a.collapseStart!==b.collapseStart||a.collapseEnd!==b.collapseEnd})))})}),g(d,"afterBreaks",function(){"yAxis"===d.coll&&!d.staticScale&&d.chart.options.chart.height&&(d.isDirty=!0)}),c=L({grid:{enabled:!0},labels:{align:"left",levels:[{level:void 0},{level:1,style:{fontWeight:"bold"}}],
symbol:{type:"triangle",x:-5,y:-5,height:10,width:10,padding:5}},uniqueNames:!1},c,{reversed:!0,grid:{columns:void 0}}));a.apply(d,[b,c]);e&&(d.hasNames=!0,d.options.showLastLabel=!0)}function D(a){var b=this.options;"treegrid"===b.type?(this.min=K(this.userMin,b.min,this.dataMin),this.max=K(this.userMax,b.max,this.dataMax),n(this,"foundExtremes"),this.setAxisTranslation(),this.tickmarkOffset=.5,this.tickInterval=1,this.tickPositions=this.treeGrid.mapOfPosToGridNode?this.treeGrid.getTickPositions():
[]):a.apply(this,Array.prototype.slice.call(arguments,1))}var J=F.getLevelOptions,g=w.addEvent,q=w.find,n=w.fireEvent,c=w.isArray,p=w.isObject,r=w.isString,L=w.merge,K=w.pick,b=w.wrap,A=[],h,f=function(){function c(a){this.axis=a}c.compose=function(c,d,f,g){if(w.pushUnique(A,c)){-1===c.keepProps.indexOf("treeGrid")&&c.keepProps.push("treeGrid");var m=c.prototype;b(m,"generateTick",a);b(m,"init",z);b(m,"setTickInterval",D);m.utils={getNode:u.getNode}}w.pushUnique(A,g)&&(h||(h=g));v.compose(c,d,g);
e.compose(c,f);G.compose(g);return c};c.prototype.setCollapsedStatus=function(a){var b=this.axis,c=b.chart;b.series.forEach(function(b){var d=b.options.data;if(a.id&&d){var e=c.get(a.id);b=d[b.data.indexOf(e)];e&&b&&(e.collapsed=a.collapsed,b.collapsed=a.collapsed)}})};c.prototype.collapse=function(a){var b=this.axis,c=b.options.breaks||[],d=l(a,b.max);c.push(d);a.collapsed=!0;b.treeGrid.setCollapsedStatus(a);return c};c.prototype.expand=function(a){var b=this.axis,c=b.options.breaks||[],d=l(a,b.max);
a.collapsed=!1;b.treeGrid.setCollapsedStatus(a);return c.reduce(function(a,b){b.to===d.to&&b.from===d.from||a.push(b);return a},[])};c.prototype.getTickPositions=function(){var a=this.axis,b=Math.floor(a.min/a.tickInterval)*a.tickInterval,c=Math.ceil(a.max/a.tickInterval)*a.tickInterval;return Object.keys(a.treeGrid.mapOfPosToGridNode||{}).reduce(function(d,e){e=+e;!(e>=b&&e<=c)||a.brokenAxis&&a.brokenAxis.isInAnyBreak(e)||d.push(e);return d},[])};c.prototype.isCollapsed=function(a){var b=this.axis,
c=b.options.breaks||[],d=l(a,b.max);return c.some(function(a){return a.from===d.from&&a.to===d.to})};c.prototype.toggleCollapse=function(a){return this.isCollapsed(a)?this.expand(a):this.collapse(a)};return c}();return f});G(e,"masters/modules/treegrid.src.js",[e["Core/Globals.js"],e["Core/Axis/TreeGrid/TreeGridAxis.js"]],function(e,v){v.compose(e.Axis,e.Chart,e.Series,e.Tick)})});
//# sourceMappingURL=treegrid.js.map