/*
 Highstock JS v11.0.0 (2023-04-26)

 Highcharts Stock as a plugin for Highcharts

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(E){b(E);b.Highcharts=E;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function E(b,n,t,k){b.hasOwnProperty(n)||(b[n]=k.apply(null,t),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:n,module:b[n]}})))}b=b?b._modules:
{};E(b,"Core/Axis/BrokenAxis.js",[b["Core/Axis/Stacking/StackItem.js"],b["Core/Utilities.js"]],function(b,n){var t=n.addEvent,k=n.find,u=n.fireEvent,C=n.isArray,h=n.isNumber,F=n.pick,y;(function(a){function g(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function p(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function z(){var q=this.brokenAxis;if(q&&q.hasBreaks){for(var a=this.tickPositions,A=this.tickPositions.info,l=[],d=0;d<
a.length;d++)q.isInAnyBreak(a[d])||l.push(a[d]);this.tickPositions=l;this.tickPositions.info=A}}function e(){this.brokenAxis||(this.brokenAxis=new D(this))}function G(){var q=this.options.connectNulls,a=this.points,A=this.xAxis,l=this.yAxis;if(this.isDirty)for(var d=a.length;d--;){var m=a[d],c=!(null===m.y&&!1===q)&&(A&&A.brokenAxis&&A.brokenAxis.isInAnyBreak(m.x,!0)||l&&l.brokenAxis&&l.brokenAxis.isInAnyBreak(m.y,!0));m.visible=c?!1:!1!==m.options.visible}}function q(){this.drawBreaks(this.xAxis,
["x"]);this.drawBreaks(this.yAxis,F(this.pointArrayMap,["y"]))}function B(q,a){var A=this,l=A.points,d,m,c,f;if(q&&q.brokenAxis&&q.brokenAxis.hasBreaks){var r=q.brokenAxis;a.forEach(function(x){d=r&&r.breakArray||[];m=q.isXAxis?q.min:F(A.options.threshold,q.min);l.forEach(function(r){f=F(r["stack"+x.toUpperCase()],r[x]);d.forEach(function(d){if(h(m)&&h(f)){c=!1;if(m<d.from&&f>d.to||m>d.from&&f<d.from)c="pointBreak";else if(m<d.from&&f>d.from&&f<d.to||m>d.from&&f>d.to&&f<d.from)c="pointInBreak";c&&
u(q,c,{point:r,brk:d})}})})})}}function K(){var q=this.currentDataGrouping,a=q&&q.gapSize;q=this.points.slice();var A=this.yAxis,l=this.options.gapSize,d=q.length-1,m;if(l&&0<d)for("value"!==this.options.gapUnit&&(l*=this.basePointRange),a&&a>l&&a>=this.basePointRange&&(l=a),m=void 0;d--;)m&&!1!==m.visible||(m=q[d+1]),a=q[d],!1!==m.visible&&!1!==a.visible&&(m.x-a.x>l&&(m=(a.x+m.x)/2,q.splice(d+1,0,{isNull:!0,x:m}),A.stacking&&this.options.stacking&&(m=A.stacking.stacks[this.stackKey][m]=new b(A,A.options.stackLabels,
!1,m,this.stack),m.total=0)),m=a);return this.getGraphPath(q)}var y=[];a.compose=function(a,b){n.pushUnique(y,a)&&(a.keepProps.push("brokenAxis"),t(a,"init",e),t(a,"afterInit",g),t(a,"afterSetTickPositions",z),t(a,"afterSetOptions",p));if(n.pushUnique(y,b)){var A=b.prototype;A.drawBreaks=B;A.gappedPath=K;t(b,"afterGeneratePoints",G);t(b,"afterRender",q)}return a};var D=function(){function q(q){this.hasBreaks=!1;this.axis=q}q.isInBreak=function(q,a){var l=q.repeat||Infinity,d=q.from,m=q.to-q.from;
a=a>=d?(a-d)%l:l-(d-a)%l;return q.inclusive?a<=m:a<m&&0!==a};q.lin2Val=function(a){var e=this.brokenAxis;e=e&&e.breakArray;if(!e||!h(a))return a;var l;for(l=0;l<e.length;l++){var d=e[l];if(d.from>=a)break;else d.to<a?a+=d.len:q.isInBreak(d,a)&&(a+=d.len)}return a};q.val2Lin=function(a){var e=this.brokenAxis;e=e&&e.breakArray;if(!e||!h(a))return a;var l=a,d;for(d=0;d<e.length;d++){var m=e[d];if(m.to<=a)l-=m.len;else if(m.from>=a)break;else if(q.isInBreak(m,a)){l-=a-m.from;break}}return l};q.prototype.findBreakAt=
function(q,a){return k(a,function(a){return a.from<q&&q<a.to})};q.prototype.isInAnyBreak=function(a,e){var l=this.axis,d=l.options.breaks||[],m=d.length,c;if(m&&h(a)){for(;m--;)if(q.isInBreak(d[m],a)){var f=!0;c||(c=F(d[m].showPoints,!l.isXAxis))}var r=f&&e?f&&!c:f}return r};q.prototype.setBreaks=function(a,e){var l=this,d=l.axis,m=C(a)&&!!a.length;d.isDirty=l.hasBreaks!==m;l.hasBreaks=m;d.options.breaks=d.userOptions.breaks=a;d.forceRedraw=!0;d.series.forEach(function(c){c.isDirty=!0});m||d.val2lin!==
q.val2Lin||(delete d.val2lin,delete d.lin2val);m&&(d.userOptions.ordinal=!1,d.lin2val=q.lin2Val,d.val2lin=q.val2Lin,d.setExtremes=function(c,f,r,x,m){if(l.hasBreaks){for(var J=this.options.breaks||[],q;q=l.findBreakAt(c,J);)c=q.to;for(;q=l.findBreakAt(f,J);)f=q.from;f<c&&(f=c)}d.constructor.prototype.setExtremes.call(this,c,f,r,x,m)},d.setAxisTranslation=function(){d.constructor.prototype.setAxisTranslation.call(this);l.unitLength=void 0;if(l.hasBreaks){var c=d.options.breaks||[],f=[],r=[],x=F(d.pointRangePadding,
0),m=0,a,L=d.userMin||d.min,e=d.userMax||d.max,O;c.forEach(function(c){a=c.repeat||Infinity;h(L)&&h(e)&&(q.isInBreak(c,L)&&(L+=c.to%a-L%a),q.isInBreak(c,e)&&(e-=e%a-c.from%a))});c.forEach(function(c){H=c.from;a=c.repeat||Infinity;if(h(L)&&h(e)){for(;H-a>L;)H-=a;for(;H<L;)H+=a;for(O=H;O<e;O+=a)f.push({value:O,move:"in"}),f.push({value:O+c.to-c.from,move:"out",size:c.breakSize})}});f.sort(function(c,f){return c.value===f.value?("in"===c.move?0:1)-("in"===f.move?0:1):c.value-f.value});var g=0;var H=
L;f.forEach(function(c){g+="in"===c.move?1:-1;1===g&&"in"===c.move&&(H=c.value);0===g&&h(H)&&(r.push({from:H,to:c.value,len:c.value-H-(c.size||0)}),m+=c.value-H-(c.size||0))});l.breakArray=r;h(L)&&h(e)&&h(d.min)&&(l.unitLength=e-L-m+x,u(d,"afterBreaks"),d.staticScale?d.transA=d.staticScale:l.unitLength&&(d.transA*=(e-d.min+x)/l.unitLength),x&&(d.minPixelPadding=d.transA*(d.minPointOffset||0)),d.min=L,d.max=e)}});F(e,!0)&&d.chart.redraw()};return q}();a.Additions=D})(y||(y={}));return y});E(b,"masters/modules/broken-axis.src.js",
[b["Core/Globals.js"],b["Core/Axis/BrokenAxis.js"]],function(b,n){n.compose(b.Axis,b.Series)});E(b,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}});E(b,"Extensions/DataGrouping/ApproximationDefaults.js",[b["Extensions/DataGrouping/ApproximationRegistry.js"],b["Core/Utilities.js"]],function(b,n){function t(a){var b=a.length;a=k(a);y(a)&&b&&(a=h(a/b));return a}function k(a){var b=a.length;if(!b&&a.hasNulls)var p=null;else if(b)for(p=0;b--;)p+=a[b];return p}var u=n.arrayMax,
v=n.arrayMin,h=n.correctFloat,C=n.extend,y=n.isNumber;n={average:t,averages:function(){var a=[];[].forEach.call(arguments,function(b){a.push(t(b))});return"undefined"===typeof a[0]?void 0:a},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},high:function(a){return a.length?u(a):a.hasNulls?null:void 0},hlc:function(a,g,p){a=b.high(a);g=b.low(g);p=b.close(p);if(y(a)||y(g)||y(p))return[a,g,p]},low:function(a){return a.length?v(a):a.hasNulls?null:void 0},ohlc:function(a,g,p,z){a=
b.open(a);g=b.high(g);p=b.low(p);z=b.close(z);if(y(a)||y(g)||y(p)||y(z))return[a,g,p,z]},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},range:function(a,g){a=b.low(a);g=b.high(g);if(y(a)||y(g))return[a,g];if(null===a&&null===g)return null},sum:k};C(b,n);return n});E(b,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %e %b, %H:%M:%S.%L","%A, %e %b, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %e %b, %H:%M:%S",
"%A, %e %b, %H:%M:%S","-%H:%M:%S"],minute:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],hour:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],day:["%A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],week:["Week from %A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},
heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}});E(b,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[b["Extensions/DataGrouping/DataGroupingDefaults.js"],b["Core/Utilities.js"]],function(b,n){function t(a){var e=this,b=e.series;b.forEach(function(q){q.groupPixelWidth=void 0});b.forEach(function(q){q.groupPixelWidth=
e.getGroupPixelWidth&&e.getGroupPixelWidth();q.groupPixelWidth&&(q.hasProcessed=!0);q.applyGrouping(!!a.hasExtremesChanged)})}function k(){for(var g=this.series,e=g.length,p=0,q=!1,B,K;e--;)if(K=g[e].options.dataGrouping)if(p=Math.max(p,a(K.groupPixelWidth,b.common.groupPixelWidth)),B=(g[e].processedXData||g[e].data).length,g[e].groupPixelWidth||B>this.chart.plotSizeX/p||B&&K.forced)q=!0;return q?p:0}function u(){this.series.forEach(function(a){a.hasProcessed=!1})}function v(b,e){var g;e=a(e,!0);
b||(b={forced:!1,units:null});if(this instanceof p)for(g=this.series.length;g--;)this.series[g].update({dataGrouping:b},!1);else this.chart.options.series.forEach(function(q){q.dataGrouping="boolean"===typeof b?b:y(b,q.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0);e&&this.chart.redraw()}var h=n.addEvent,C=n.extend,y=n.merge,a=n.pick,g=[],p;return{compose:function(a){p=a;n.pushUnique(g,a)&&(h(a,"afterSetScale",u),h(a,"postProcessData",t),C(a.prototype,{applyGrouping:t,getGroupPixelWidth:k,
setDataGrouping:v}))}}});E(b,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[b["Extensions/DataGrouping/ApproximationRegistry.js"],b["Extensions/DataGrouping/DataGroupingDefaults.js"],b["Core/Axis/DateTimeAxis.js"],b["Core/Defaults.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,n,t,k,u,v){function h(a){var l=this.chart,d=this.options.dataGrouping,m=!1!==this.allowDG&&d&&D(d.enabled,l.options.isStock),c=this.visible||!l.options.chart.ignoreHiddenSeries,f=this.currentDataGrouping,
r=!1;m&&!this.requireSorting&&(this.requireSorting=r=!0);a=!1===!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!a)||!m;r&&(this.requireSorting=!1);if(!a){this.destroyGroupedData();var x=d.groupAll?this.xData:this.processedXData,J=d.groupAll?this.yData:this.processedYData;m=l.plotSizeX;a=this.xAxis;var N=a.options.ordinal,L=this.groupPixelWidth;r=void 0;if(L&&x&&x.length&&m){this.isDirty=r=!0;this.points=null;var e=a.getExtremes();var b=e.min;e=e.max;N=N&&a.ordinal&&a.ordinal.getGroupIntervalFactor(b,
e,this)||1;m=a.getTimeTicks(t.Additions.prototype.normalizeTimeTickInterval(L*(e-b)/m*N,d.units||n.units),Math.min(b,x[0]),Math.max(e,x[x.length-1]),a.options.startOfWeek,x,this.closestPointRange);L=z.groupData.apply(this,[x,J,m,d.approximation]);x=L.groupedXData;J=L.groupedYData;N=0;d&&d.smoothed&&x.length&&(d.firstAnchor="firstPoint",d.anchor="middle",d.lastAnchor="lastPoint",q(32,!1,l,{"dataGrouping.smoothed":"use dataGrouping.anchor"}));l=x;var g=this.options.dataGrouping;b=this.currentDataGrouping&&
this.currentDataGrouping.gapSize;if(g&&this.xData&&b&&this.groupMap){var H=l.length-1;var p=g.anchor;var B=D(g.firstAnchor,p);g=D(g.lastAnchor,p);if(p&&"start"!==p){var w=b*{middle:.5,end:1}[p];for(p=l.length-1;p--&&0<p;)l[p]+=w}if(B&&"start"!==B&&this.xData[0]>=l[0]){p=this.groupMap[0].start;w=this.groupMap[0].length;var h=void 0;K(p)&&K(w)&&(h=p+(w-1));l[0]={middle:l[0]+.5*b,end:l[0]+b,firstPoint:this.xData[0],lastPoint:h&&this.xData[h]}[B]}g&&"start"!==g&&b&&l[H]>=e-b&&(e=this.groupMap[this.groupMap.length-
1].start,l[H]={middle:l[H]+.5*b,end:l[H]+b,firstPoint:e&&this.xData[e],lastPoint:this.xData[this.xData.length-1]}[g])}for(e=1;e<m.length;e++)m.info.segmentStarts&&-1!==m.info.segmentStarts.indexOf(e)||(N=Math.max(m[e]-m[e-1],N));e=m.info;e.gapSize=N;this.closestPointRange=m.info.totalRange;this.groupMap=L.groupMap;if(c){c=x;if(G(c[0])&&K(a.min)&&K(a.dataMin)&&c[0]<a.min){if(!G(a.options.min)&&a.min<=a.dataMin||a.min===a.dataMin)a.min=Math.min(c[0],a.min);a.dataMin=Math.min(c[0],a.dataMin)}if(G(c[c.length-
1])&&K(a.max)&&K(a.dataMax)&&c[c.length-1]>a.max){if(!G(a.options.max)&&K(a.dataMax)&&a.max>=a.dataMax||a.max===a.dataMax)a.max=Math.max(c[c.length-1],a.max);a.dataMax=Math.max(c[c.length-1],a.dataMax)}}d.groupAll&&(this.allGroupedData=J,d=this.cropData(x,J,a.min,a.max,1),x=d.xData,J=d.yData,this.cropStart=d.start);this.processedXData=x;this.processedYData=J}else this.groupMap=null;this.hasGroupedData=r;this.currentDataGrouping=e;this.preventGraphAnimation=(f&&f.totalRange)!==(e&&e.totalRange)}}function C(){this.groupedData&&
(this.groupedData.forEach(function(a,q){a&&(this.groupedData[q]=a.destroy?a.destroy():null)},this),this.groupedData.length=0)}function y(){w.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null}function a(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")?"sum":"average"}function g(a,q,d,m){var c=this,f=c.data,r=c.options&&c.options.data,x=[],J=[],e=[],L=a.length,l=!!q,g=[],p=c.pointArrayMap,H=p&&p.length,B=["x"].concat(p||
["y"]),w=this.options.dataGrouping&&this.options.dataGrouping.groupAll,h=0,z=0;m="function"===typeof m?m:m&&b[m]?b[m]:b[c.getDGApproximation&&c.getDGApproximation()||"average"];if(H)for(var A=p.length;A--;)g.push([]);else g.push([]);A=H||1;for(var k=0;k<=L;k++)if(!(a[k]<d[0])){for(;"undefined"!==typeof d[h+1]&&a[k]>=d[h+1]||k===L;){var D=d[h];c.dataGroupInfo={start:w?z:c.cropStart+z,length:g[0].length};var u=m.apply(c,g);c.pointClass&&!G(c.dataGroupInfo.options)&&(c.dataGroupInfo.options=M(c.pointClass.prototype.optionsToObject.call({series:c},
c.options.data[c.cropStart+z])),B.forEach(function(f){delete c.dataGroupInfo.options[f]}));"undefined"!==typeof u&&(x.push(D),J.push(u),e.push(c.dataGroupInfo));z=k;for(D=0;D<A;D++)g[D].length=0,g[D].hasNulls=!1;h+=1;if(k===L)break}if(k===L)break;if(p){D=c.options.dataGrouping&&c.options.dataGrouping.groupAll?k:c.cropStart+k;u=f&&f[D]||c.pointClass.prototype.applyOptions.apply({series:c},[r[D]]);var n=void 0;for(D=0;D<H;D++)n=u[p[D]],K(n)?g[D].push(n):null===n&&(g[D].hasNulls=!0)}else D=l?q[k]:null,
K(D)?g[0].push(D):null===D&&(g[0].hasNulls=!0)}return{groupedXData:x,groupedYData:J,groupMap:e}}function p(a){a=a.options;var q=this.type,d=this.chart.options.plotOptions,m=this.useCommonDataGrouping&&n.common,c=n.seriesSpecific,f=k.defaultOptions.plotOptions[q].dataGrouping;if(d&&(c[q]||m)){var r=this.chart.rangeSelector;f||(f=M(n.common,c[q]));a.dataGrouping=M(m,f,d.series&&d.series.dataGrouping,d[q].dataGrouping,this.userOptions.dataGrouping,!a.isInternal&&r&&K(r.selected)&&r.buttonOptions[r.selected].dataGrouping)}}
var z=u.series.prototype,e=v.addEvent,G=v.defined,q=v.error,B=v.extend,K=v.isNumber,M=v.merge,D=v.pick,w=z.generatePoints,I=[];return{compose:function(b){var l=b.prototype.pointClass;v.pushUnique(I,l)&&e(l,"update",function(){if(this.dataGroup)return q(24,!1,this.series.chart),!1});v.pushUnique(I,b)&&(e(b,"afterSetOptions",p),e(b,"destroy",C),B(b.prototype,{applyGrouping:h,destroyGroupedData:C,generatePoints:y,getDGApproximation:a,groupData:g}))},groupData:g}});E(b,"Extensions/DataGrouping/DataGrouping.js",
[b["Extensions/DataGrouping/DataGroupingAxisComposition.js"],b["Extensions/DataGrouping/DataGroupingDefaults.js"],b["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],b["Core/FormatUtilities.js"],b["Core/Utilities.js"]],function(b,n,t,k,u){function v(b){var g=this.chart,e=g.time,p=b.labelConfig,q=p.series,B=q.tooltipOptions,K=q.options.dataGrouping,k=q.xAxis,D=B.xDateFormat,w=B[b.isFooter?"footerFormat":"headerFormat"];if(k&&"datetime"===k.options.type&&K&&a(p.key)){var u=q.currentDataGrouping;
K=K.dateTimeLabelFormats||n.common.dateTimeLabelFormats;if(u)if(B=K[u.unitName],1===u.count)D=B[0];else{D=B[1];var A=B[2]}else!D&&K&&k.dateTime&&(D=k.dateTime.getXDateFormat(p.x,B.dateTimeLabelFormats));D=e.dateFormat(D,p.key);A&&(D+=e.dateFormat(A,p.key+u.totalRange-1));q.chart.styledMode&&(w=this.styledModeFormat(w));b.text=h(w,{point:y(p.point,{key:D}),series:q},g);b.preventDefault()}}var h=k.format,C=u.addEvent,y=u.extend,a=u.isNumber,g=[];k={compose:function(a,h,e){b.compose(a);t.compose(h);
e&&u.pushUnique(g,e)&&C(e,"headerFormatter",v)},groupData:t.groupData};"";"";return k});E(b,"masters/modules/datagrouping.src.js",[b["Core/Globals.js"],b["Extensions/DataGrouping/ApproximationDefaults.js"],b["Extensions/DataGrouping/ApproximationRegistry.js"],b["Extensions/DataGrouping/DataGrouping.js"]],function(b,n,t,k){b.dataGrouping={approximationDefaults:n,approximations:t};k.compose(b.Axis,b.Series,b.Tooltip)});E(b,"Series/DataModifyComposition.js",[b["Core/Axis/Axis.js"],b["Core/Series/Point.js"],
b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,n,t,k){var u=n.prototype.tooltipFormatter,v=k.addEvent,h=k.arrayMax,C=k.arrayMin,y=k.correctFloat,a=k.defined,g=k.isArray,p=k.isNumber,z=k.isString,e=k.pick,G;(function(q){function b(c,r,d){this.isXAxis||(this.series.forEach(function(f){"compare"===c&&"boolean"!==typeof r?f.setCompare(r,!1):"cumulative"!==c||z(r)||f.setCumulative(r,!1)}),e(d,!0)&&this.chart.redraw())}function G(c){var f=this,d=f.series.chart.numberFormatter,m=function(r){c=
c.replace("{point."+r+"}",(0<f[r]&&"change"===r?"+":"")+d(f[r],e(f.series.tooltipOptions.changeDecimals,2)))};a(f.change)&&m("change");a(f.cumulativeSum)&&m("cumulativeSum");return u.apply(this,[c])}function n(){var f=this.options.compare;if("percent"===f||"value"===f||this.options.cumulative){var r=new c(this);"percent"===f||"value"===f?r.initCompare(f):r.initCumulative()}this.dataModify=r}function D(f){f=f.dataExtremes;var r=f.activeYData;if(this.dataModify&&f){var d=void 0;this.options.compare?
d=[this.dataModify.modifyValue(f.dataMin),this.dataModify.modifyValue(f.dataMax)]:this.options.cumulative&&g(r)&&2<=r.length&&(d=c.getCumulativeExtremes(r));d&&(f.dataMin=C(d),f.dataMax=h(d))}}function w(c,r){this.options.compare=this.userOptions.compare=c;this.update({},e(r,!0));!this.dataModify||"value"!==c&&"percent"!==c?this.points.forEach(function(c){delete c.change}):this.dataModify.initCompare(c)}function t(){if(this.xAxis&&this.processedYData&&this.dataModify){var c=this.processedXData,r=
this.processedYData,d=r.length,m=!0===this.options.compareStart?0:1,a=-1,q;this.pointArrayMap&&(a=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(q=0;q<d-m;q++){var b=r[q]&&-1<a?r[q][a]:r[q];if(p(b)&&0!==b&&c[q+m]>=(this.xAxis.min||0)){this.dataModify.compareValue=b;break}}}}function A(c,r){this.setModifier("compare",c,r)}function l(c,r){c=e(c,!1);this.options.cumulative=this.userOptions.cumulative=c;this.update({},e(r,!0));this.dataModify?this.dataModify.initCumulative():
this.points.forEach(function(c){delete c.cumulativeSum})}function d(c,r){this.setModifier("cumulative",c,r)}var m=[];q.compose=function(c,r,x){if(k.pushUnique(m,c)){var f=c.prototype;f.setCompare=w;f.setCumulative=l;v(c,"afterInit",n);v(c,"afterGetExtremes",D);v(c,"afterProcessData",t)}k.pushUnique(m,r)&&(r=r.prototype,r.setCompare=A,r.setModifier=b,r.setCumulative=d);k.pushUnique(m,x)&&(x.prototype.tooltipFormatter=G);return c};var c=function(){function c(c){this.series=c}c.prototype.modifyValue=
function(){return 0};c.getCumulativeExtremes=function(c){var f=Infinity,r=-Infinity;c.reduce(function(c,d){d=c+d;f=Math.min(f,d,c);r=Math.max(r,d,c);return d});return[f,r]};c.prototype.initCompare=function(c){this.modifyValue=function(f,r){null===f&&(f=0);var d=this.compareValue;return"undefined"!==typeof f&&"undefined"!==typeof d?(f="value"===c?f-d:f/d*100-(100===this.series.options.compareBase?0:100),"undefined"!==typeof r&&(r=this.series.points[r])&&(r.change=f),f):0}};c.prototype.initCumulative=
function(){this.modifyValue=function(c,f){null===c&&(c=0);if(void 0!==c&&void 0!==f){var r=0<f?this.series.points[f-1]:null;r&&r.cumulativeSum&&(c=y(r.cumulativeSum+c));if(f=this.series.points[f])f.cumulativeSum=c;return c}return 0}};return c}();q.Additions=c})(G||(G={}));"";return G});E(b,"Core/Axis/NavigatorAxisComposition.js",[b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,n){function t(){this.navigatorAxis||(this.navigatorAxis=new p(this))}function k(a){var b=this.chart.options,g=b.navigator,
q=this.navigatorAxis,p=b.chart.zooming.pinchType,h=b.rangeSelector;b=b.chart.zooming.type;this.isXAxis&&(g&&g.enabled||h&&h.enabled)&&("y"===b?a.zoomed=!1:(!u&&"xy"===b||u&&"xy"===p)&&this.options.range&&(g=q.previousZoom,C(a.newMin)?q.previousZoom=[this.min,this.max]:g&&(a.newMin=g[0],a.newMax=g[1],q.previousZoom=void 0)));"undefined"!==typeof a.zoomed&&a.preventDefault()}var u=b.isTouchDevice,v=n.addEvent,h=n.correctFloat,C=n.defined,y=n.isNumber,a=n.pick,g=[],p=function(){function b(a){this.axis=
a}b.compose=function(a){n.pushUnique(g,a)&&(a.keepProps.push("navigatorAxis"),v(a,"init",t),v(a,"zoom",k))};b.prototype.destroy=function(){this.axis=void 0};b.prototype.toFixedRange=function(b,g,q,p){var e=this.axis,B=e.chart;b=a(q,e.translate(b,!0,!e.horiz));g=a(p,e.translate(g,!0,!e.horiz));B=B&&B.fixedRange;e=(e.pointRange||0)/2;var D=B&&(g-b)/B;C(q)||(b=h(b+e));C(p)||(g=h(g-e));.7<D&&1.3>D&&(p?b=g-B:g=b+B);y(b)&&y(g)||(b=g=void 0);return{min:b,max:g}};return b}();return p});E(b,"Stock/Navigator/NavigatorDefaults.js",
[b["Core/Color/Color.js"],b["Core/Series/SeriesRegistry.js"]],function(b,n){b=b.parse;n=n.seriesTypes;n={height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:b("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:"undefined"===typeof n.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},
dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,
className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}};"";return n});E(b,"Stock/Navigator/NavigatorSymbols.js",
[],function(){return{"navigator-handle":function(b,n,t,k,u){void 0===u&&(u={});b=u.width?u.width/2:t;n=Math.round(b/3)+.5;k=u.height||k;return[["M",-b-1,.5],["L",b,.5],["L",b,k+.5],["L",-b-1,k+.5],["L",-b-1,.5],["M",-n,4],["L",-n,k-3],["M",n-1,4],["L",n-1,k-3]]}}});E(b,"Stock/Navigator/NavigatorComposition.js",[b["Core/Defaults.js"],b["Core/Globals.js"],b["Core/Axis/NavigatorAxisComposition.js"],b["Stock/Navigator/NavigatorDefaults.js"],b["Stock/Navigator/NavigatorSymbols.js"],b["Core/Renderer/RendererRegistry.js"],
b["Core/Utilities.js"]],function(b,n,t,k,u,v,h){function F(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function y(){var d,c=this.legend,f=this.navigator;if(f){var r=c&&c.options;var a=f.xAxis;var q=f.yAxis;var b=f.scrollbarHeight,e=f.scrollButtonSize;this.inverted?(f.left=f.opposite?this.chartWidth-b-f.height:this.spacing[3]+b,f.top=this.plotTop+e):(f.left=A(a.left,this.plotLeft+e),f.top=f.navigatorOptions.top||this.chartHeight-f.height-b-((null===(d=this.scrollbar)||void 0===d?void 0:
d.options.margin)||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(r&&"bottom"===r.verticalAlign&&"proximate"!==r.layout&&r.enabled&&!r.floating?c.legendHeight+A(r.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));a&&q&&(this.inverted?a.options.left=q.options.left=f.left:a.options.top=q.options.top=f.top,a.setAxisSize(),q.setAxisSize())}}function a(m){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||
(this.scroller=this.navigator=new d(this),A(m.redraw,!0)&&this.redraw(m.animation))}function g(){var m=this.options;if(m.navigator.enabled||m.scrollbar.enabled)this.scroller=this.navigator=new d(this)}function p(){var d=this.options,c=d.navigator,f=d.rangeSelector;if((c&&c.enabled||f&&f.enabled)&&(!K&&"x"===d.chart.zooming.type||K&&"x"===d.chart.zooming.pinchType))return!1}function z(d){var c=d.navigator;c&&d.xAxis[0]&&(d=d.xAxis[0].getExtremes(),c.render(d.min,d.max))}function e(d){var c=d.options.navigator||
{},f=d.options.scrollbar||{};this.navigator||this.scroller||!c.enabled&&!f.enabled||(I(!0,this.options.navigator,c),I(!0,this.options.scrollbar,f),delete d.options.navigator,delete d.options.scrollbar)}function G(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}var q=b.defaultOptions,B=b.setOptions,K=n.isTouchDevice,C=v.getRendererType,D=h.addEvent,w=h.extend,I=h.merge,A=h.pick,l=[],d;return{compose:function(m,c,f,r){t.compose(m);d=f;h.pushUnique(l,c)&&
(c.prototype.callbacks.push(z),D(c,"afterAddSeries",F),D(c,"afterSetChartSize",y),D(c,"afterUpdate",a),D(c,"beforeRender",g),D(c,"beforeShowResetZoom",p),D(c,"update",e));h.pushUnique(l,r)&&D(r,"afterUpdate",G);h.pushUnique(l,C)&&w(C().prototype.symbols,u);h.pushUnique(l,B)&&w(q,{navigator:k})}}});E(b,"Core/Axis/ScrollbarAxis.js",[b["Core/Utilities.js"]],function(b){var n=b.addEvent,t=b.defined,k=b.pick,u=[];return function(){function v(){}v.compose=function(h,v){if(!b.pushUnique(u,h))return h;var y=
function(a){var b=k(a.options&&a.options.min,a.min),p=k(a.options&&a.options.max,a.max);return{axisMin:b,axisMax:p,scrollMin:t(a.dataMin)?Math.min(b,a.min,a.dataMin,k(a.threshold,Infinity)):b,scrollMax:t(a.dataMax)?Math.max(p,a.max,a.dataMax,k(a.threshold,-Infinity)):p}};n(h,"afterInit",function(){var a=this;a.options&&a.options.scrollbar&&a.options.scrollbar.enabled&&(a.options.scrollbar.vertical=!a.horiz,a.options.startOnTick=a.options.endOnTick=!1,a.scrollbar=new v(a.chart.renderer,a.options.scrollbar,
a.chart),n(a.scrollbar,"changed",function(b){var g=y(a),h=g.axisMax,e=g.scrollMin,k=g.scrollMax-e;t(g.axisMin)&&t(h)&&(a.horiz&&!a.reversed||!a.horiz&&a.reversed?(g=e+k*this.to,e+=k*this.from):(g=e+k*(1-this.from),e+=k*(1-this.to)),this.shouldUpdateExtremes(b.DOMType)?a.setExtremes(e,g,!0,"mousemove"!==b.DOMType&&"touchmove"!==b.DOMType,b):this.setRange(this.from,this.to))}))});n(h,"afterRender",function(){var a=y(this),b=a.scrollMin,p=a.scrollMax;a=this.scrollbar;var h=this.axisTitleMargin+(this.titleOffset||
0),e=this.chart.scrollbarsOffsets,k=this.options.margin||0;a&&(this.horiz?(this.opposite||(e[1]+=h),a.position(this.left,this.top+this.height+2+e[1]-(this.opposite?k:0),this.width,this.height),this.opposite||(e[1]+=k),h=1):(this.opposite&&(e[0]+=h),a.position(a.options.opposite?this.left+this.width+2+e[0]-(this.opposite?0:k):this.opposite?0:k,this.top,this.width,this.height),this.opposite&&(e[0]+=k),h=0),e[h]+=a.size+(a.options.margin||0),isNaN(b)||isNaN(p)||!t(this.min)||!t(this.max)||this.min===
this.max?a.setRange(0,1):(e=(this.min-b)/(p-b),b=(this.max-b)/(p-b),this.horiz&&!this.reversed||!this.horiz&&this.reversed?a.setRange(e,b):a.setRange(1-b,1-e)))});n(h,"afterGetOffset",function(){var a=this.scrollbar,b=a&&!a.options.opposite;b=this.horiz?2:b?3:1;a&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[b]+=a.size+(a.options.margin||0))});return h};return v}()});E(b,"Stock/Scrollbar/ScrollbarDefaults.js",[b["Core/Globals.js"]],function(b){return{height:10,barBorderRadius:5,buttonBorderRadius:0,
buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",trackBackgroundColor:"none",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}});E(b,"Stock/Scrollbar/Scrollbar.js",[b["Core/Defaults.js"],b["Core/Globals.js"],b["Core/Axis/ScrollbarAxis.js"],b["Stock/Scrollbar/ScrollbarDefaults.js"],
b["Core/Utilities.js"]],function(b,n,t,k,u){var v=b.defaultOptions,h=u.addEvent,F=u.correctFloat,y=u.defined,a=u.destroyObjectProperties,g=u.fireEvent,p=u.merge,z=u.pick,e=u.removeEvent;b=function(){function b(a,b,e){this._events=[];this.chart=void 0;this.from=this.chartY=this.chartX=0;this.scrollbar=this.renderer=this.options=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=
0;this.track=void 0;this.trackBorderWidth=1;this.userOptions=void 0;this.y=this.x=0;this.init(a,b,e)}b.compose=function(a){t.compose(a,b)};b.swapXY=function(a,b){b&&a.forEach(function(a){for(var b=a.length,q,e=0;e<b;e+=2)q=a[e+1],"number"===typeof q&&(a[e+1]=a[e+2],a[e+2]=q)});return a};b.prototype.addEvents=function(){var a=this.options.inverted?[1,0]:[0,1],b=this.scrollbarButtons,e=this.scrollbarGroup.element,g=this.track.element,p=this.mouseDownHandler.bind(this),k=this.mouseMoveHandler.bind(this),
u=this.mouseUpHandler.bind(this);a=[[b[a[0]].element,"click",this.buttonToMinClick.bind(this)],[b[a[1]].element,"click",this.buttonToMaxClick.bind(this)],[g,"click",this.trackClick.bind(this)],[e,"mousedown",p],[e.ownerDocument,"mousemove",k],[e.ownerDocument,"mouseup",u]];n.hasTouch&&a.push([e,"touchstart",p],[e.ownerDocument,"touchmove",k],[e.ownerDocument,"touchend",u]);a.forEach(function(a){h.apply(null,a)});this._events=a};b.prototype.buttonToMaxClick=function(a){var b=(this.to-this.from)*z(this.options.step,
.2);this.updatePosition(this.from+b,this.to+b);g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};b.prototype.buttonToMinClick=function(a){var b=F(this.to-this.from)*z(this.options.step,.2);this.updatePosition(F(this.from-b),F(this.to-b));g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};b.prototype.cursorToScrollbarPosition=function(a){var b=this.options;b=b.minWidth>this.calculatedWidth?b.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/
(this.barWidth-b),chartY:(a.chartY-this.y-this.yOffset)/(this.barWidth-b)}};b.prototype.destroy=function(){var b=this,e=b.chart.scroller;b.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(a){b[a]&&b[a].destroy&&(b[a]=b[a].destroy())});e&&b===e.scrollbar&&(e.scrollbar=null,a(e.scrollbarButtons))};b.prototype.drawScrollbarButton=function(a){var q=this.renderer,e=this.scrollbarButtons,g=this.options,p=this.size,h=q.g().add(this.group);e.push(h);g.buttonsEnabled&&
(h=q.rect().addClass("highcharts-scrollbar-button").add(h),this.chart.styledMode||h.attr({stroke:g.buttonBorderColor,"stroke-width":g.buttonBorderWidth,fill:g.buttonBackgroundColor}),h.attr(h.crisp({x:-.5,y:-.5,width:p+1,height:p+1,r:g.buttonBorderRadius},h.strokeWidth())),a=q.path(b.swapXY([["M",p/2+(a?-1:1),p/2-3],["L",p/2+(a?-1:1),p/2+3],["L",p/2+(a?2:-2),p/2]],g.vertical)).addClass("highcharts-scrollbar-arrow").add(e[a]),this.chart.styledMode||a.attr({fill:g.buttonArrowColor}))};b.prototype.init=
function(a,b,e){this.scrollbarButtons=[];this.renderer=a;this.userOptions=b;this.options=p(k,v.scrollbar,b);this.options.margin=z(this.options.margin,10);this.chart=e;this.size=z(this.options.size,this.options.height);b.enabled&&(this.render(),this.addEvents())};b.prototype.mouseDownHandler=function(a){a=this.chart.pointer.normalize(a);a=this.cursorToScrollbarPosition(a);this.chartX=a.chartX;this.chartY=a.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=!0};b.prototype.mouseMoveHandler=
function(a){var b=this.chart.pointer.normalize(a),e=this.options.vertical?"chartY":"chartX",q=this.initPositions||[];!this.grabbedCenter||a.touches&&0===a.touches[0][e]||(b=this.cursorToScrollbarPosition(b)[e],e=this[e],e=b-e,this.hasDragged=!0,this.updatePosition(q[0]+e,q[1]+e),this.hasDragged&&g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a}))};b.prototype.mouseUpHandler=function(a){this.hasDragged&&g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",
DOMType:a.type,DOMEvent:a});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};b.prototype.position=function(a,b,e,g){var q=this.options,p=q.buttonsEnabled,h=q.margin;h=void 0===h?0:h;q=q.vertical;var k=this.rendered?"animate":"attr",l=g,d=0;this.group.show();this.x=a;this.y=b+this.trackBorderWidth;this.width=e;this.height=g;this.xOffset=l;this.yOffset=d;q?(this.width=this.yOffset=e=this.size,this.xOffset=l=0,this.yOffset=d=p?this.size:0,this.barWidth=g-(p?2*e:0),this.x=a+=h):(this.height=
g=this.size,this.xOffset=l=p?this.size:0,this.barWidth=e-(p?2*g:0),this.y+=h);this.group[k]({translateX:a,translateY:this.y});this.track[k]({width:e,height:g});this.scrollbarButtons[1][k]({translateX:q?0:e-l,translateY:q?g-d:0})};b.prototype.removeEvents=function(){this._events.forEach(function(a){e.apply(null,a)});this._events.length=0};b.prototype.render=function(){var a=this.renderer,e=this.options,g=this.size,p=this.chart.styledMode,h=a.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=
h;this.track=a.rect().addClass("highcharts-scrollbar-track").attr({r:e.trackBorderRadius||0,height:g,width:g}).add(h);p||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,"stroke-width":e.trackBorderWidth});var k=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-k%2/2,y:-k%2/2});this.scrollbarGroup=a.g().add(h);this.scrollbar=a.rect().addClass("highcharts-scrollbar-thumb").attr({height:g-k,width:g-k,r:e.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=
a.path(b.swapXY([["M",-3,g/4],["L",-3,2*g/3],["M",0,g/4],["L",0,2*g/3],["M",3,g/4],["L",3,2*g/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);p||(this.scrollbar.attr({fill:e.barBackgroundColor,stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);
this.drawScrollbarButton(1)};b.prototype.setRange=function(a,b){var e=this.options,q=e.vertical,g=e.minWidth,p=this.barWidth,h=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(y(p)){var k=p*Math.min(b,1);a=Math.max(a,0);var l=Math.ceil(p*a);this.calculatedWidth=k=F(k-l);k<g&&(l=(p-g+k)*a,k=g);g=Math.floor(l+this.xOffset+this.yOffset);p=k/2-.5;this.from=a;this.to=b;q?(this.scrollbarGroup[h]({translateY:g}),this.scrollbar[h]({height:k}),this.scrollbarRifles[h]({translateY:p}),
this.scrollbarTop=g,this.scrollbarLeft=0):(this.scrollbarGroup[h]({translateX:g}),this.scrollbar[h]({width:k}),this.scrollbarRifles[h]({translateX:p}),this.scrollbarLeft=g,this.scrollbarTop=0);12>=k?this.scrollbarRifles.hide():this.scrollbarRifles.show();!1===e.showFull&&(0>=a&&1<=b?this.group.hide():this.group.show());this.rendered=!0}};b.prototype.shouldUpdateExtremes=function(a){return z(this.options.liveRedraw,n.svg&&!n.isTouchDevice&&!this.chart.boosted)||"mouseup"===a||"touchend"===a||!y(a)};
b.prototype.trackClick=function(a){var b=this.chart.pointer.normalize(a),e=this.to-this.from,q=this.y+this.scrollbarTop,p=this.x+this.scrollbarLeft;this.options.vertical&&b.chartY>q||!this.options.vertical&&b.chartX>p?this.updatePosition(this.from+e,this.to+e):this.updatePosition(this.from-e,this.to-e);g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};b.prototype.update=function(a){this.destroy();this.init(this.chart.renderer,p(!0,this.options,a),this.chart)};b.prototype.updatePosition=
function(a,b){1<b&&(a=F(1-F(b-a)),b=1);0>a&&(b=F(b-a),a=0);this.from=a;this.to=b};b.defaultOptions=k;return b}();v.scrollbar=p(!0,b.defaultOptions,v.scrollbar);return b});E(b,"Stock/Navigator/Navigator.js",[b["Core/Axis/Axis.js"],b["Core/Defaults.js"],b["Core/Globals.js"],b["Core/Axis/NavigatorAxisComposition.js"],b["Stock/Navigator/NavigatorComposition.js"],b["Stock/Scrollbar/Scrollbar.js"],b["Core/Utilities.js"]],function(b,n,t,k,u,v,h){function F(d){for(var c=[],f=1;f<arguments.length;f++)c[f-
1]=arguments[f];c=[].filter.call(c,w);if(c.length)return Math[d].apply(0,c)}var y=n.defaultOptions,a=t.hasTouch,g=t.isTouchDevice,p=h.addEvent,z=h.clamp,e=h.correctFloat,G=h.defined,q=h.destroyObjectProperties,B=h.erase,C=h.extend,M=h.find,D=h.isArray,w=h.isNumber,I=h.merge,A=h.pick,l=h.removeEvent,d=h.splat;return function(){function m(c){this.rendered=this.range=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=
this.height=this.handles=this.chart=this.baseSeries=void 0;this.scrollbarHeight=0;this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.scrollButtonSize=void 0;this.init(c)}m.compose=function(c,f,r){u.compose(c,f,m,r)};m.prototype.drawHandle=function(c,f,r,d){var a=this.navigatorOptions.handles.height;this.handles[f][d](r?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(c,10)+.5-a)}:{translateX:Math.round(this.left+parseInt(c,
10)),translateY:Math.round(this.top+this.height/2-a/2-1)})};m.prototype.drawOutline=function(c,f,r,d){var a=this.navigatorOptions.maskInside,b=this.outline.strokeWidth(),m=b/2,x=b%2/2,e=this.scrollButtonSize,g=this.size,q=this.top;b=this.height;var l=q-m,p=q+b,h=this.left;r?(r=q+f+x,f=q+c+x,x=[["M",h+b,q-e-x],["L",h+b,r],["L",h,r],["M",h,f],["L",h+b,f],["L",h+b,q+g+e]],a&&x.push(["M",h+b,r-m],["L",h+b,f+m])):(h-=e,c+=h+e-x,f+=h+e-x,x=[["M",h,l],["L",c,l],["L",c,p],["M",f,p],["L",f,l],["L",h+g+2*e,
q+m]],a&&x.push(["M",c-m,l],["L",f+m,l]));this.outline[d]({d:x})};m.prototype.drawMasks=function(c,f,d,a){var r=this.left,b=this.top,m=this.height;if(d){var x=[r,r,r];var e=[b,b+c,b+f];var g=[m,m,m];var q=[c,f-c,this.size-f]}else x=[r,r+c,r+f],e=[b,b,b],g=[c,f-c,this.size-f],q=[m,m,m];this.shades.forEach(function(c,f){c[a]({x:x[f],y:e[f],width:g[f],height:q[f]})})};m.prototype.renderElements=function(){var c=this,f=c.navigatorOptions,r=f.maskInside,d=c.chart,a=d.renderer,b={cursor:d.inverted?"ns-resize":
"ew-resize"},m=c.navigatorGroup=a.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!r,r,!r].forEach(function(r,x){var e=a.rect().addClass("highcharts-navigator-mask"+(1===x?"-inside":"-outside")).add(m);d.styledMode||(e.attr({fill:r?f.maskFill:"rgba(0,0,0,0)"}),1===x&&e.css(b));c.shades[x]=e});c.outline=a.path().addClass("highcharts-navigator-outline").add(m);d.styledMode||c.outline.attr({"stroke-width":f.outlineWidth,stroke:f.outlineColor});if(f.handles&&f.handles.enabled){var e=f.handles,
g=e.height,q=e.width;[0,1].forEach(function(f){c.handles[f]=a.symbol(e.symbols[f],-q/2-1,0,q,g,e);d.inverted&&c.handles[f].attr({rotation:90,rotationOriginX:Math.floor(-q/2),rotationOriginY:(g+q)/2});c.handles[f].attr({zIndex:7-f}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][f]).add(m);d.styledMode||c.handles[f].attr({fill:e.backgroundColor,stroke:e.borderColor,"stroke-width":e.lineWidth}).css(b)})}};m.prototype.update=function(c){(this.series||[]).forEach(function(c){c.baseSeries&&
delete c.baseSeries.navigatorSeries});this.destroy();I(!0,this.chart.options.navigator,c);this.init(this.chart)};m.prototype.render=function(c,f,d,a){var r=this.chart,b=this.xAxis,m=b.pointRange||0,x=b.navigatorAxis.fake?r.xAxis[0]:b,g=this.navigatorEnabled,q=this.rendered,l=r.inverted,p=r.xAxis[0].minRange,h=r.xAxis[0].options.maxRange,k=this.scrollButtonSize,u=this.scrollbarHeight,n;if(!this.hasDragged||G(d)){c=e(c-m/2);f=e(f+m/2);if(!w(c)||!w(f))if(q)d=0,a=A(b.width,x.width);else return;this.left=
A(b.left,r.plotLeft+k+(l?r.plotWidth:0));var t=this.size=n=A(b.len,(l?r.plotHeight:r.plotWidth)-2*k);r=l?u:n+2*k;d=A(d,b.toPixels(c,!0));a=A(a,b.toPixels(f,!0));w(d)&&Infinity!==Math.abs(d)||(d=0,a=r);c=b.toValue(d,!0);f=b.toValue(a,!0);var B=Math.abs(e(f-c));B<p?this.grabbedLeft?d=b.toPixels(f-p-m,!0):this.grabbedRight&&(a=b.toPixels(c+p+m,!0)):G(h)&&e(B-m)>h&&(this.grabbedLeft?d=b.toPixels(f-h-m,!0):this.grabbedRight&&(a=b.toPixels(c+h+m,!0)));this.zoomedMax=z(Math.max(d,a),0,t);this.zoomedMin=
z(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(d,a),0,t);this.range=this.zoomedMax-this.zoomedMin;t=Math.round(this.zoomedMax);d=Math.round(this.zoomedMin);g&&(this.navigatorGroup.attr({visibility:"inherit"}),q=q&&!this.hasDragged?"animate":"attr",this.drawMasks(d,t,l,q),this.drawOutline(d,t,l,q),this.navigatorOptions.handles.enabled&&(this.drawHandle(d,0,l,q),this.drawHandle(t,1,l,q)));this.scrollbar&&(l?(l=this.top-k,x=this.left-u+(g||!x.opposite?0:(x.titleOffset||0)+x.axisTitleMargin),
u=n+2*k):(l=this.top+(g?this.height:-u),x=this.left-k),this.scrollbar.position(x,l,r,u),this.scrollbar.setRange(this.zoomedMin/(n||1),this.zoomedMax/(n||1)));this.rendered=!0}};m.prototype.addMouseEvents=function(){var c=this,f=c.chart,d=f.container,b=[],m,e;c.mouseMoveHandler=m=function(f){c.onMouseMove(f)};c.mouseUpHandler=e=function(f){c.onMouseUp(f)};b=c.getPartsEvents("mousedown");b.push(p(f.renderTo,"mousemove",m),p(d.ownerDocument,"mouseup",e));a&&(b.push(p(f.renderTo,"touchmove",m),p(d.ownerDocument,
"touchend",e)),b.concat(c.getPartsEvents("touchstart")));c.eventsToUnbind=b;c.series&&c.series[0]&&b.push(p(c.series[0].xAxis,"foundExtremes",function(){f.navigator.modifyNavigatorAxisExtremes()}))};m.prototype.getPartsEvents=function(c){var f=this,d=[];["shades","handles"].forEach(function(r){f[r].forEach(function(a,b){d.push(p(a.element,c,function(c){f[r+"Mousedown"](c,b)}))})});return d};m.prototype.shadesMousedown=function(c,f){c=this.chart.pointer.normalize(c);var d=this.chart,a=this.xAxis,b=
this.zoomedMin,m=this.size,e=this.range,g=this.left,q=c.chartX;d.inverted&&(q=c.chartY,g=this.top);if(1===f)this.grabbedCenter=q,this.fixedWidth=e,this.dragOffset=q-b;else{c=q-g-e/2;if(0===f)c=Math.max(0,c);else if(2===f&&c+e>=m)if(c=m-e,this.reversedExtremes){c-=e;var l=this.getUnionExtremes().dataMin}else var p=this.getUnionExtremes().dataMax;c!==b&&(this.fixedWidth=e,f=a.navigatorAxis.toFixedRange(c,c+e,l,p),G(f.min)&&d.xAxis[0].setExtremes(Math.min(f.min,f.max),Math.max(f.min,f.max),!0,null,{trigger:"navigator"}))}};
m.prototype.handlesMousedown=function(c,f){this.chart.pointer.normalize(c);c=this.chart;var d=c.xAxis[0],a=this.reversedExtremes;0===f?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=a?d.min:d.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=a?d.max:d.min);c.fixedRange=null};m.prototype.onMouseMove=function(c){var f=this,d=f.chart,a=f.navigatorSize,b=f.range,m=f.dragOffset,e=d.inverted,q=f.left;c.touches&&0===c.touches[0].pageX||(c=d.pointer.normalize(c),
d=c.chartX,e&&(q=f.top,d=c.chartY),f.grabbedLeft?(f.hasDragged=!0,f.render(0,0,d-q,f.otherHandlePos)):f.grabbedRight?(f.hasDragged=!0,f.render(0,0,f.otherHandlePos,d-q)):f.grabbedCenter&&(f.hasDragged=!0,d<m?d=m:d>a+m-b&&(d=a+m-b),f.render(0,0,d-m,d-m+b)),f.hasDragged&&f.scrollbar&&A(f.scrollbar.options.liveRedraw,!g&&!this.chart.boosted)&&(c.DOMType=c.type,setTimeout(function(){f.onMouseUp(c)},0)))};m.prototype.onMouseUp=function(c){var f=this.chart,d=this.xAxis,a=this.scrollbar,b=c.DOMEvent||c,
m=f.inverted,e=this.rendered&&!this.hasDragged?"animate":"attr";if(this.hasDragged&&(!a||!a.hasDragged)||"scrollbar"===c.trigger){a=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var q=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var g=this.fixedExtreme;this.zoomedMax===this.size&&(g=this.reversedExtremes?a.dataMin:a.dataMax);0===this.zoomedMin&&(q=this.reversedExtremes?a.dataMax:a.dataMin);d=d.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,q,g);G(d.min)&&
f.xAxis[0].setExtremes(Math.min(d.min,d.max),Math.max(d.min,d.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:b})}"mousemove"!==c.DOMType&&"touchmove"!==c.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&w(this.zoomedMin)&&w(this.zoomedMax)&&(f=Math.round(this.zoomedMin),c=Math.round(this.zoomedMax),this.shades&&this.drawMasks(f,
c,m,e),this.outline&&this.drawOutline(f,c,m,e),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(f,0,m,e),this.drawHandle(c,1,m,e)))};m.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(c){c()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()};m.prototype.removeBaseSeriesEvents=function(){var c=this.baseSeries||[];this.navigatorEnabled&&c[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&
c.forEach(function(c){l(c,"updatedData",this.updatedDataHandler)},this),c[0].xAxis&&l(c[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};m.prototype.init=function(c){var f=c.options,d=f.navigator||{},a=d.enabled,m=f.scrollbar||{},e=m.enabled;f=a&&d.height||0;var q=e&&m.height||0,g=m.buttonsEnabled&&q||0;this.handles=[];this.shades=[];this.chart=c;this.setBaseSeries();this.height=f;this.scrollbarHeight=q;this.scrollButtonSize=g;this.scrollbarEnabled=e;this.navigatorEnabled=a;this.navigatorOptions=
d;this.scrollbarOptions=m;this.opposite=A(d.opposite,!(a||!c.inverted));var l=this;a=l.baseSeries;m=c.xAxis.length;e=c.yAxis.length;q=a&&a[0]&&a[0].xAxis||c.xAxis[0]||{options:{}};c.isDirtyBox=!0;l.navigatorEnabled?(l.xAxis=new b(c,I({breaks:q.options.breaks,ordinal:q.options.ordinal},d.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:m,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},c.inverted?{offsets:[g,
0,-g,0],width:f}:{offsets:[0,-g,0,g],height:f})),l.yAxis=new b(c,I(d.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:e,isInternal:!0,reversed:A(d.yAxis&&d.yAxis.reversed,c.yAxis[0]&&c.yAxis[0].reversed,!1),zoomEnabled:!1},c.inverted?{width:f}:{height:f})),a||d.series.data?l.updateNavigatorSeries(!1):0===c.series.length&&(l.unbindRedraw=p(c,"beforeRedraw",function(){0<c.series.length&&!l.series&&(l.setBaseSeries(),l.unbindRedraw())})),l.reversedExtremes=c.inverted&&!l.xAxis.reversed||!c.inverted&&
l.xAxis.reversed,l.renderElements(),l.addMouseEvents()):(l.xAxis={chart:c,navigatorAxis:{fake:!0},translate:function(f,d){var a=c.xAxis[0],b=a.getExtremes(),r=a.len-2*g,m=F("min",a.options.min,b.dataMin);a=F("max",a.options.max,b.dataMax)-m;return d?f*a/r+m:r*(f-m)/a},toPixels:function(c){return this.translate(c)},toValue:function(c){return this.translate(c,!0)}},l.xAxis.navigatorAxis.axis=l.xAxis,l.xAxis.navigatorAxis.toFixedRange=k.prototype.toFixedRange.bind(l.xAxis.navigatorAxis));c.options.scrollbar.enabled&&
(d=I(c.options.scrollbar,{vertical:c.inverted}),!w(d.margin)&&l.navigatorEnabled&&(d.margin=c.inverted?-3:3),c.scrollbar=l.scrollbar=new v(c.renderer,d,c),p(l.scrollbar,"changed",function(c){var f=l.size,d=f*this.to;f*=this.from;l.hasDragged=l.scrollbar.hasDragged;l.render(0,0,f,d);this.shouldUpdateExtremes(c.DOMType)&&setTimeout(function(){l.onMouseUp(c)})}));l.addBaseSeriesEvents();l.addChartEvents()};m.prototype.getUnionExtremes=function(c){var f=this.chart.xAxis[0],d=this.xAxis,a=d.options,b=
f.options,m;c&&null===f.dataMin||(m={dataMin:A(a&&a.min,F("min",b.min,f.dataMin,d.dataMin,d.min)),dataMax:A(a&&a.max,F("max",b.max,f.dataMax,d.dataMax,d.max))});return m};m.prototype.setBaseSeries=function(c,f){var d=this.chart,a=this.baseSeries=[];c=c||d.options&&d.options.navigator.baseSeries||(d.series.length?M(d.series,function(c){return!c.options.isInternal}).index:0);(d.series||[]).forEach(function(f,d){f.options.isInternal||!f.options.showInNavigator&&(d!==c&&f.options.id!==c||!1===f.options.showInNavigator)||
a.push(f)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,f)};m.prototype.updateNavigatorSeries=function(c,f){var a=this,b=a.chart,m=a.baseSeries,e={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},q=a.series=(a.series||[]).filter(function(c){var f=c.baseSeries;return 0>m.indexOf(f)?(f&&(l(f,"updatedData",a.updatedDataHandler),
delete f.navigatorSeries),c.chart&&c.destroy(),!1):!0}),g,p,h=a.navigatorOptions.series,k;m&&m.length&&m.forEach(function(c){var r=c.navigatorSeries,x=C({color:c.color,visible:c.visible},D(h)?y.navigator.series:h);r&&!1===a.navigatorOptions.adaptToUpdatedData||(e.name="Navigator "+m.length,g=c.options||{},k=g.navigatorOptions||{},x.dataLabels=d(x.dataLabels),p=I(g,e,x,k),p.pointRange=A(x.pointRange,k.pointRange,y.plotOptions[p.type||"line"].pointRange),x=k.data||x.data,a.hasNavigatorData=a.hasNavigatorData||
!!x,p.data=x||g.data&&g.data.slice(0),r&&r.options?r.update(p,f):(c.navigatorSeries=b.initSeries(p),c.navigatorSeries.baseSeries=c,q.push(c.navigatorSeries)))});if(h.data&&(!m||!m.length)||D(h))a.hasNavigatorData=!1,h=d(h),h.forEach(function(c,f){e.name="Navigator "+(q.length+1);p=I(y.navigator.series,{color:b.series[f]&&!b.series[f].options.isInternal&&b.series[f].color||b.options.colors[f]||b.options.colors[0]},e,c);p.data=c.data;p.data&&(a.hasNavigatorData=!0,q.push(b.initSeries(p)))});c&&this.addBaseSeriesEvents()};
m.prototype.addBaseSeriesEvents=function(){var c=this,f=this,d=f.baseSeries||[];d[0]&&d[0].xAxis&&d[0].eventsToUnbind.push(p(d[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes));d.forEach(function(d){d.eventsToUnbind.push(p(d,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)}));d.eventsToUnbind.push(p(d,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)}));!1!==c.navigatorOptions.adaptToUpdatedData&&d.xAxis&&d.eventsToUnbind.push(p(d,"updatedData",
c.updatedDataHandler));d.eventsToUnbind.push(p(d,"remove",function(){this.navigatorSeries&&(B(f.series,this.navigatorSeries),G(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})};m.prototype.getBaseSeriesMin=function(c){return this.baseSeries.reduce(function(c,d){return Math.min(c,d.xData&&d.xData.length?d.xData[0]:c)},c)};m.prototype.modifyNavigatorAxisExtremes=function(){var c=this.xAxis;if("undefined"!==typeof c.getExtremes){var f=this.getUnionExtremes(!0);
!f||f.dataMin===c.min&&f.dataMax===c.max||(c.min=f.dataMin,c.max=f.dataMax)}};m.prototype.modifyBaseAxisExtremes=function(){var c=this.chart.navigator,f=this.getExtremes(),d=f.dataMin,a=f.dataMax;f=f.max-f.min;var b=c.stickToMin,m=c.stickToMax,e=A(this.options.overscroll,0),g=c.series&&c.series[0],q=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(b){var l=d;var p=l+f}m&&(p=a+e,b||(l=Math.max(d,p-f,c.getBaseSeriesMin(g&&g.xData?g.xData[0]:-Number.MAX_VALUE))));
q&&(b||m)&&w(l)&&(this.min=this.userMin=l,this.max=this.userMax=p)}c.stickToMin=c.stickToMax=null};m.prototype.updatedDataHandler=function(){var c=this.chart.navigator,d=this.navigatorSeries;c.stickToMax=A(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,c.reversedExtremes?0===Math.round(c.zoomedMin):Math.round(c.zoomedMax)>=Math.round(c.size));c.stickToMin=c.shouldStickToMin(this,c);d&&!c.hasNavigatorData&&(d.options.pointStart=this.xData[0],d.setData(this.options.data,!1,null,
!1))};m.prototype.shouldStickToMin=function(c,d){d=d.getBaseSeriesMin(c.xData[0]);var f=c.xAxis;c=f.max;var a=f.min;f=f.options.range;return w(c)&&w(a)?f&&0<c-d?c-d<f:a<=d:!1};m.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(p(this.chart,"redraw",function(){var c=this.navigator,d=c&&(c.baseSeries&&c.baseSeries[0]&&c.baseSeries[0].xAxis||this.xAxis[0]);d&&c.render(d.min,d.max)}),p(this.chart,"getMargins",function(){var c=this.navigator,d=
c.opposite?"plotTop":"marginBottom";this.inverted&&(d=c.opposite?"marginRight":"plotLeft");this[d]=(this[d]||0)+(c.navigatorEnabled||!this.inverted?c.height+c.scrollbarHeight:0)+c.navigatorOptions.margin}))};m.prototype.destroy=function(){var c=this;this.removeEvents();this.xAxis&&(B(this.chart.xAxis,this.xAxis),B(this.chart.axes,this.xAxis));this.yAxis&&(B(this.chart.yAxis,this.yAxis),B(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(c){c.destroy&&c.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(d){c[d]&&
c[d].destroy&&c[d].destroy();c[d]=null});[this.handles].forEach(function(c){q(c)})};return m}()});E(b,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"},rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,
inputBoxWidth:void 0,inputDateFormat:"%e %b %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#334eff",cursor:"pointer",fontSize:"0.8em"},labelStyle:{color:"#666666",fontSize:"0.8em"}}}});E(b,"Stock/RangeSelector/RangeSelectorComposition.js",[b["Core/Defaults.js"],b["Stock/RangeSelector/RangeSelectorDefaults.js"],b["Core/Utilities.js"]],function(b,n,
t){function k(){var a=this.range,d=a.type,b=this.max,c=this.chart.time,f=function(f,a){var b="year"===d?"FullYear":"Month",m=new c.Date(f),r=c.get(b,m);c.set(b,m,r+a);r===c.get(b,m)&&c.set("Date",m,0);return m.getTime()-f};if(C(a)){var r=b-a;var e=a}else a&&(r=b+f(b,-(a.count||1)),this.chart&&(this.chart.fixedRange=b-r));var g=D(this.dataMin,Number.MIN_VALUE);C(r)||(r=g);r<=g&&(r=g,"undefined"===typeof e&&(e=f(r,a.count)),this.newMax=Math.min(r+e,D(this.dataMax,Number.MAX_VALUE)));C(b)?!C(a)&&a&&
a._offsetMin&&(r+=a._offsetMin):r=void 0;return r}function u(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new A(this))}function v(){var a=this.axes,d=this.rangeSelector;d&&(C(d.deferredYTDClick)&&(d.clickButton(d.deferredYTDClick),delete d.deferredYTDClick),a.forEach(function(d){d.updateNames();d.setScale()}),this.getAxisMargins(),d.render(),a=d.options.verticalAlign,d.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=
!0)))}function h(a){var d,b,c,f,r=a.rangeSelector,g=function(){r&&(d=a.xAxis[0].getExtremes(),b=a.legend,f=r&&r.options.verticalAlign,C(d.min)&&r.render(d.min,d.max),b.display&&"top"===f&&f===b.options.verticalAlign&&(c=M(a.spacingBox),c.y="vertical"===b.options.layout?a.plotTop:c.y+r.getHeight(),b.group.placed=!1,b.align(c)))};r&&(B(w,function(c){return c[0]===a})||w.push([a,[e(a.xAxis[0],"afterSetExtremes",function(c){r&&r.render(c.min,c.max)}),e(a,"redraw",g)]]),g())}function F(){for(var a=0,d=
w.length;a<d;++a){var b=w[a];if(b[0]===this){b[1].forEach(function(c){return c()});w.splice(a,1);break}}}function y(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}function a(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}function g(a){var d=a.options.rangeSelector;a=this.extraBottomMargin;var b=
this.extraTopMargin,c=this.rangeSelector;d&&d.enabled&&!G(c)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=c=new A(this));this.extraTopMargin=this.extraBottomMargin=!1;c&&(h(this),d=d&&d.verticalAlign||c.options&&c.options.verticalAlign,c.options.floating||("bottom"===d?this.extraBottomMargin=!0:"middle"!==d&&(this.extraTopMargin=!0)),this.extraBottomMargin!==a||this.extraTopMargin!==b)&&(this.isDirtyBox=!0)}var p=b.defaultOptions,z=b.setOptions,e=t.addEvent,
G=t.defined,q=t.extend,B=t.find,C=t.isNumber,M=t.merge,D=t.pick,w=[],I=[],A;return{compose:function(b,d,m){A=m;t.pushUnique(I,b)&&(b.prototype.minFromRange=k);t.pushUnique(I,d)&&(e(d,"afterGetContainer",u),e(d,"beforeRender",v),e(d,"destroy",F),e(d,"getMargins",y),e(d,"render",a),e(d,"update",g),d.prototype.callbacks.push(h));t.pushUnique(I,z)&&(q(p,{rangeSelector:n.rangeSelector}),q(p.lang,n.lang))}}});E(b,"Stock/RangeSelector/RangeSelector.js",[b["Core/Axis/Axis.js"],b["Core/Defaults.js"],b["Core/Globals.js"],
b["Stock/RangeSelector/RangeSelectorComposition.js"],b["Core/Renderer/SVG/SVGElement.js"],b["Core/Utilities.js"]],function(b,n,t,k,u,v){function h(a){if(-1!==a.indexOf("%L"))return"text";var d="aAdewbBmoyY".split("").some(function(c){return-1!==a.indexOf("%"+c)}),b="HkIlMS".split("").some(function(c){return-1!==a.indexOf("%"+c)});return d&&b?"datetime-local":d?"date":b?"time":"text"}var F=n.defaultOptions,y=v.addEvent,a=v.createElement,g=v.css,p=v.defined,z=v.destroyObjectProperties,e=v.discardElement,
G=v.extend,q=v.fireEvent,B=v.isNumber,C=v.merge,M=v.objectEach,D=v.pad,w=v.pick,I=v.pInt,A=v.splat;n=function(){function l(d){this.buttons=void 0;this.buttonOptions=l.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=d;this.init(d)}l.compose=function(d,a){k.compose(d,a,l)};l.prototype.clickButton=function(d,a){var c=this.chart,f=this.buttonOptions[d],r=c.xAxis[0],m=c.scroller&&c.scroller.getUnionExtremes()||r||{},e=f.type,g=f.dataGrouping,l=m.dataMin,h=m.dataMax,
k=r&&Math.round(Math.min(r.max,w(h,r.max)));m=f._range;var u,H=!0;if(null!==l&&null!==h){c.fixedRange=m;this.setSelected(d);g&&(this.forcedDataGrouping=!0,b.prototype.setDataGrouping.call(r||{chart:this.chart},g,!1),this.frozenStates=f.preserveDataGrouping);if("month"===e||"year"===e)if(r){e={range:f,max:k,chart:c,dataMin:l,dataMax:h};var n=r.minFromRange.call(e);B(e.newMax)&&(k=e.newMax);H=!1}else m=f;else if(m)n=Math.max(k-m,l),k=Math.min(n+m,h),H=!1;else if("ytd"===e)if(r){if("undefined"===typeof h||
"undefined"===typeof l)l=Number.MAX_VALUE,h=Number.MIN_VALUE,c.series.forEach(function(c){if(c=c.xData)l=Math.min(c[0],l),h=Math.max(c[c.length-1],h)}),a=!1;e=this.getYTDExtremes(h,l,c.time.useUTC);n=u=e.min;k=e.max}else{this.deferredYTDClick=d;return}else"all"===e&&r&&(c.navigator&&c.navigator.baseSeries[0]&&(c.navigator.baseSeries[0].xAxis.options.range=void 0),n=l,k=h);H&&f._offsetMin&&p(n)&&(n+=f._offsetMin);f._offsetMax&&p(k)&&(k+=f._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=d+1);
if(r)r.setExtremes(n,k,w(a,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:f});else{var t=A(c.options.xAxis)[0];var z=t.range;t.range=m;var v=t.min;t.min=u;y(c,"load",function(){t.range=z;t.min=v})}q(this,"afterBtnClick")}};l.prototype.setSelected=function(d){this.selected=this.options.selected=d};l.prototype.init=function(d){var a=this,c=d.options.rangeSelector,f=c.buttons||a.defaultButtons.slice(),b=c.selected,e=function(){var c=a.minInput,d=a.maxInput;c&&c.blur&&q(c,"blur");d&&d.blur&&
q(d,"blur")};a.chart=d;a.options=c;a.buttons=[];a.buttonOptions=f;this.eventsToUnbind=[];this.eventsToUnbind.push(y(d.container,"mousedown",e));this.eventsToUnbind.push(y(d,"resize",e));f.forEach(a.computeButtonRange);"undefined"!==typeof b&&f[b]&&this.clickButton(b,!1);this.eventsToUnbind.push(y(d,"load",function(){d.xAxis&&d.xAxis[0]&&y(d.xAxis[0],"setExtremes",function(c){this.max-this.min!==d.fixedRange&&"rangeSelectorButton"!==c.trigger&&"updatedData"!==c.trigger&&a.forcedDataGrouping&&!a.frozenStates&&
this.setDataGrouping(!1,!1)})}))};l.prototype.updateButtonStates=function(){var d=this,a=this.chart,c=this.dropdown,f=a.xAxis[0],b=Math.round(f.max-f.min),e=!f.hasVisibleSeries,g=a.scroller&&a.scroller.getUnionExtremes()||f,q=g.dataMin,p=g.dataMax;a=d.getYTDExtremes(p,q,a.time.useUTC);var l=a.min,h=a.max,k=d.selected,u=d.options.allButtonsEnabled,n=d.buttons,t=B(k);d.buttonOptions.forEach(function(a,r){var m=a._range,g=a.type,x=a.count||1,J=n[r],L=a._offsetMax-a._offsetMin,H=r===k,N=m>p-q,z=m<f.minRange;
a=0;var w=!1,B=!1;m=m===b;("month"===g||"year"===g)&&b+36E5>=864E5*{month:28,year:365}[g]*x-L&&b-36E5<=864E5*{month:31,year:366}[g]*x+L?m=!0:"ytd"===g?(m=h-l+L===b,w=!H):"all"===g&&(m=f.max-f.min>=p-q,B=!H&&t&&m);g=!u&&(N||z||B||e);x=H&&m||m&&!t&&!w||H&&d.frozenStates;g?a=3:x&&(t=!0,a=2);J.state!==a&&(J.setState(a),c&&(c.options[r+1].disabled=g,2===a&&(c.selectedIndex=r+1)),0===a&&k===r&&d.setSelected())})};l.prototype.computeButtonRange=function(d){var a=d.type,c=d.count||1,f={millisecond:1,second:1E3,
minute:6E4,hour:36E5,day:864E5,week:6048E5};if(f[a])d._range=f[a]*c;else if("month"===a||"year"===a)d._range=864E5*{month:30,year:365}[a]*c;d._offsetMin=w(d.offsetMin,0);d._offsetMax=w(d.offsetMax,0);d._range+=d._offsetMax-d._offsetMin};l.prototype.getInputValue=function(a){a="min"===a?this.minInput:this.maxInput;var d=this.chart.options.rangeSelector,c=this.chart.time;return a?("text"===a.type&&d.inputDateParser||this.defaultInputDateParser)(a.value,c.useUTC,c):0};l.prototype.setInputValue=function(a,
b){var c=this.options,d=this.chart.time,r="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:this.maxDateBox;if(r){var m=r.getAttribute("data-hc-time");m=p(m)?Number(m):void 0;p(b)&&(p(m)&&r.setAttribute("data-hc-time-previous",m),r.setAttribute("data-hc-time",b),m=b);r.value=d.dateFormat(this.inputTypeFormats[r.type]||c.inputEditDateFormat,m);a&&a.attr({text:d.dateFormat(c.inputDateFormat,m)})}};l.prototype.setInputExtremes=function(a,b,c){if(a="min"===a?this.minInput:this.maxInput){var d=
this.inputTypeFormats[a.type],r=this.chart.time;d&&(b=r.dateFormat(d,b),a.min!==b&&(a.min=b),c=r.dateFormat(d,c),a.max!==c&&(a.max=c))}};l.prototype.showInput=function(a){var d="min"===a?this.minDateBox:this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&d&&this.inputGroup){var c="text"===a.type,f=this.inputGroup,b=f.translateX;f=f.translateY;var e=this.options.inputBoxWidth;g(a,{width:c?d.width+(e?-2:20)+"px":"auto",height:d.height-2+"px",border:"2px solid silver"});c&&e?g(a,{left:b+d.x+
"px",top:f+"px"}):g(a,{left:Math.min(Math.round(d.x+b-(a.offsetWidth-d.width)/2),this.chart.chartWidth-a.offsetWidth)+"px",top:f-(a.offsetHeight-d.height)/2+"px"})}};l.prototype.hideInput=function(a){(a="min"===a?this.minInput:this.maxInput)&&g(a,{top:"-9999em",border:0,width:"1px",height:"1px"})};l.prototype.defaultInputDateParser=function(a,b,c){var d=a.split("/").join("-").split(" ").join("T");-1===d.indexOf("T")&&(d+="T00:00");if(b)d+="Z";else{var r;if(r=t.isSafari)r=d,r=!(6<r.length&&(r.lastIndexOf("-")===
r.length-6||r.lastIndexOf("+")===r.length-6));r&&(r=(new Date(d)).getTimezoneOffset()/60,d+=0>=r?"+".concat(D(-r),":00"):"-".concat(D(r),":00"))}d=Date.parse(d);B(d)||(a=a.split("-"),d=Date.UTC(I(a[0]),I(a[1])-1,I(a[2])));c&&b&&B(d)&&(d+=c.getTimezoneOffset(d));return d};l.prototype.drawInput=function(d){function b(){var a=e.maxInput,f=e.minInput,b=c.xAxis[0],r=c.scroller&&c.scroller.xAxis?c.scroller.xAxis:b,m=r.dataMin;r=r.dataMax;var g=e.getInputValue(d);g!==Number(n.getAttribute("data-hc-time-previous"))&&
B(g)&&(n.setAttribute("data-hc-time-previous",g),k&&a&&B(m)?g>Number(a.getAttribute("data-hc-time"))?g=void 0:g<m&&(g=m):f&&B(r)&&(g<Number(f.getAttribute("data-hc-time"))?g=void 0:g>r&&(g=r)),"undefined"!==typeof g&&b.setExtremes(k?g:b.min,k?b.max:g,void 0,void 0,{trigger:"rangeSelectorInput"}))}var c=this.chart,f=this.div,r=this.inputGroup,e=this,q=c.renderer.style||{},p=c.renderer,l=c.options.rangeSelector,k="min"===d,u=F.lang[k?"rangeSelectorFrom":"rangeSelectorTo"]||"";u=p.label(u,0).addClass("highcharts-range-label").attr({padding:u?
2:0,height:u?l.inputBoxHeight:0}).add(r);p=p.label("",0).addClass("highcharts-range-input").attr({padding:2,width:l.inputBoxWidth,height:l.inputBoxHeight,"text-align":"center"}).on("click",function(){e.showInput(d);e[d+"Input"].focus()});c.styledMode||p.attr({stroke:l.inputBoxBorderColor,"stroke-width":1});p.add(r);var n=a("input",{name:d,className:"highcharts-range-selector"},void 0,f);n.setAttribute("type",h(l.inputDateFormat||"%e %b %Y"));c.styledMode||(u.css(C(q,l.labelStyle)),p.css(C({color:"#333333"},
q,l.inputStyle)),g(n,G({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:q.fontSize,fontFamily:q.fontFamily,top:"-9999em"},l.inputStyle)));n.onfocus=function(){e.showInput(d)};n.onblur=function(){n===t.doc.activeElement&&b();e.hideInput(d);e.setInputValue(d);n.blur()};var H=!1;n.onchange=function(){H||(b(),e.hideInput(d),n.blur())};n.onkeypress=function(c){13===c.keyCode&&b()};n.onkeydown=function(c){H=!0;38!==c.keyCode&&
40!==c.keyCode||b()};n.onkeyup=function(){H=!1};return{dateBox:p,input:n,label:u}};l.prototype.getPosition=function(){var a=this.chart,b=a.options.rangeSelector;a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}};l.prototype.getYTDExtremes=function(a,b,c){var d=this.chart.time,r=new d.Date(a),e=d.get("FullYear",r);c=c?d.Date.UTC(e,0,1):+new d.Date(e,0,1);b=Math.max(b,c);r=r.getTime();return{max:Math.min(a||r,r),min:b}};l.prototype.render=
function(d,b){var c=this.chart,f=c.renderer,r=c.container,e=c.options,m=e.rangeSelector,g=w(e.chart.style&&e.chart.style.zIndex,0)+1;e=m.inputEnabled;if(!1!==m.enabled){this.rendered||(this.group=f.g("range-selector-group").attr({zIndex:7}).add(),this.div=a("div",void 0,{position:"relative",height:0,zIndex:g}),this.buttonOptions.length&&this.renderButtons(),r.parentNode&&r.parentNode.insertBefore(this.div,r),e&&(this.inputGroup=f.g("input-group").add(this.group),f=this.drawInput("min"),this.minDateBox=
f.dateBox,this.minLabel=f.label,this.minInput=f.input,f=this.drawInput("max"),this.maxDateBox=f.dateBox,this.maxLabel=f.label,this.maxInput=f.input));if(e&&(this.setInputValue("min",d),this.setInputValue("max",b),d=c.scroller&&c.scroller.getUnionExtremes()||c.xAxis[0]||{},p(d.dataMin)&&p(d.dataMax)&&(c=c.xAxis[0].minRange||0,this.setInputExtremes("min",d.dataMin,Math.min(d.dataMax,this.getInputValue("max"))-c),this.setInputExtremes("max",Math.max(d.dataMin,this.getInputValue("min"))+c,d.dataMax)),
this.inputGroup)){var q=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(c){if(c){var a=c.getBBox().width;a&&(c.attr({x:q}),q+=a+m.inputSpacing)}})}this.alignElements();this.rendered=!0}};l.prototype.renderButtons=function(){var d=this,b=this.buttons,c=this.options,f=F.lang,r=this.chart.renderer,e=C(c.buttonTheme),g=e&&e.states,p=e.width||28;delete e.width;delete e.states;this.buttonGroup=r.g("range-selector-buttons").add(this.group);var l=this.dropdown=a("select",
void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);y(l,"touchstart",function(){l.style.fontSize="16px"});[[t.isMS?"mouseover":"mouseenter"],[t.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(c){var a=c[0],f=c[1];y(l,a,function(){var c=b[d.currentButtonIndex()];c&&q(c.element,f||a)})});this.zoomText=r.label(f&&f.rangeSelectorZoom||"",0).attr({padding:c.buttonTheme.padding,height:c.buttonTheme.height,paddingLeft:0,
paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(c.labelStyle),e["stroke-width"]=w(e["stroke-width"],0));a("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,l);this.buttonOptions.forEach(function(c,f){a("option",{textContent:c.title||c.text},void 0,l);b[f]=r.button(c.text,0,0,function(a){var b=c.events&&c.events.click,r;b&&(r=b.call(c,a));!1!==r&&d.clickButton(f);d.isActive=!0},e,g&&g.hover,g&&g.select,g&&g.disabled).attr({"text-align":"center",width:p}).add(d.buttonGroup);
c.title&&b[f].attr("title",c.title)})};l.prototype.alignElements=function(){var a=this,b=this.buttonGroup,c=this.buttons,f=this.chart,r=this.group,e=this.inputGroup,g=this.options,q=this.zoomText,p=f.options,l=p.exporting&&!1!==p.exporting.enabled&&p.navigation&&p.navigation.buttonOptions;p=g.buttonPosition;var h=g.inputPosition,k=g.verticalAlign,n=function(c,d){return l&&a.titleCollision(f)&&"top"===k&&"right"===d.align&&d.y-c.getBBox().height-12<(l.y||0)+(l.height||0)+f.spacing[0]?-40:0},u=f.plotLeft;
if(r&&p&&h){var t=p.x-f.spacing[3];if(b){this.positionButtons();if(!this.initialButtonGroupWidth){var z=0;q&&(z+=q.getBBox().width+5);c.forEach(function(a,d){z+=a.width;d!==c.length-1&&(z+=g.buttonSpacing)});this.initialButtonGroupWidth=z}u-=f.spacing[3];this.updateButtonStates();q=n(b,p);this.alignButtonGroup(q);r.placed=b.placed=f.hasLoaded}b=0;e&&(b=n(e,h),"left"===h.align?t=u:"right"===h.align&&(t=-Math.max(f.axisOffset[1],-b)),e.align({y:h.y,width:e.getBBox().width,align:h.align,x:h.x+t-2},!0,
f.spacingBox),e.placed=f.hasLoaded);this.handleCollision(b);r.align({verticalAlign:k},!0,f.spacingBox);e=r.alignAttr.translateY;b=r.getBBox().height+20;n=0;"bottom"===k&&(n=(n=f.legend&&f.legend.options)&&"bottom"===n.verticalAlign&&n.enabled&&!n.floating?f.legend.legendHeight+w(n.margin,10):0,b=b+n-20,n=e-b-(g.floating?0:g.y)-(f.titleOffset?f.titleOffset[2]:0)-10);if("top"===k)g.floating&&(n=0),f.titleOffset&&f.titleOffset[0]&&(n=f.titleOffset[0]),n+=f.margin[0]-f.spacing[0]||0;else if("middle"===
k)if(h.y===p.y)n=e;else if(h.y||p.y)n=0>h.y||0>p.y?n-Math.min(h.y,p.y):e-b;r.translate(g.x,g.y+Math.floor(n));p=this.minInput;h=this.maxInput;e=this.dropdown;g.inputEnabled&&p&&h&&(p.style.marginTop=r.translateY+"px",h.style.marginTop=r.translateY+"px");e&&(e.style.marginTop=r.translateY+"px")}};l.prototype.alignButtonGroup=function(a,b){var c=this.chart,d=this.buttonGroup,e=this.options.buttonPosition,m=c.plotLeft-c.spacing[3],g=e.x-c.spacing[3];"right"===e.align?g+=a-m:"center"===e.align&&(g-=m/
2);d&&d.align({y:e.y,width:w(b,this.initialButtonGroupWidth),align:e.align,x:g},!0,c.spacingBox)};l.prototype.positionButtons=function(){var a=this.buttons,b=this.chart,c=this.options,f=this.zoomText,e=b.hasLoaded?"animate":"attr",g=c.buttonPosition,q=b=b.plotLeft;f&&"hidden"!==f.visibility&&(f[e]({x:w(b+g.x,b)}),q+=g.x+f.getBBox().width+5);f=0;for(g=this.buttonOptions.length;f<g;++f)if("hidden"!==a[f].visibility)a[f][e]({x:q}),q+=a[f].width+c.buttonSpacing;else a[f][e]({x:b})};l.prototype.handleCollision=
function(a){var d=this,c=this.chart,b=this.buttonGroup,e=this.inputGroup,g=this.options,q=g.buttonPosition,p=g.dropdown,l=g.inputPosition;g=function(){var c=0;d.buttons.forEach(function(a){a=a.getBBox();a.width>c&&(c=a.width)});return c};var h=function(c){if(e&&b){var d=e.alignAttr.translateX+e.alignOptions.x-a+e.getBBox().x+2,f=e.alignOptions.width,r=b.alignAttr.translateX+b.getBBox().x;return r+c>d&&d+f>r&&q.y<l.y+e.getBBox().height}return!1},k=function(){e&&b&&e.attr({translateX:e.alignAttr.translateX+
(c.axisOffset[1]>=-a?0:-a),translateY:e.alignAttr.translateY+b.getBBox().height+10})};if(b){if("always"===p){this.collapseButtons(a);h(g())&&k();return}"never"===p&&this.expandButtons()}e&&b?l.align===q.align||h(this.initialButtonGroupWidth+20)?"responsive"===p?(this.collapseButtons(a),h(g())&&k()):k():"responsive"===p&&this.expandButtons():b&&"responsive"===p&&(this.initialButtonGroupWidth>c.plotWidth?this.collapseButtons(a):this.expandButtons())};l.prototype.collapseButtons=function(a){var d=this.buttons,
c=this.buttonOptions,b=this.chart,e=this.dropdown,g=this.options,q=this.zoomText,p=b.userOptions.rangeSelector&&b.userOptions.rangeSelector.buttonTheme||{},l=function(c){return{text:c?"".concat(c," \u25be"):"\u25be",width:"auto",paddingLeft:w(g.buttonTheme.paddingLeft,p.padding,8),paddingRight:w(g.buttonTheme.paddingRight,p.padding,8)}};q&&q.hide();var h=!1;c.forEach(function(c,a){a=d[a];2!==a.state?a.hide():(a.show(),a.attr(l(c.text)),h=!0)});h||(e&&(e.selectedIndex=0),d[0].show(),d[0].attr(l(this.zoomText&&
this.zoomText.textStr)));c=g.buttonPosition.align;this.positionButtons();"right"!==c&&"center"!==c||this.alignButtonGroup(a,d[this.currentButtonIndex()].getBBox().width);this.showDropdown()};l.prototype.expandButtons=function(){var a=this.buttons,b=this.buttonOptions,c=this.options,f=this.zoomText;this.hideDropdown();f&&f.show();b.forEach(function(d,b){b=a[b];b.show();b.attr({text:d.text,width:c.buttonTheme.width||28,paddingLeft:w(c.buttonTheme.paddingLeft,"unset"),paddingRight:w(c.buttonTheme.paddingRight,
"unset")});2>b.state&&b.setState(0)});this.positionButtons()};l.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-1:0};l.prototype.showDropdown=function(){var a=this.buttonGroup,b=this.buttons,c=this.chart,f=this.dropdown;if(a&&f){var e=a.translateX;a=a.translateY;b=b[this.currentButtonIndex()].getBBox();g(f,{left:c.plotLeft+e+"px",top:a+.5+"px",width:b.width+"px",height:b.height+"px"});this.hasVisibleDropdown=!0}};l.prototype.hideDropdown=function(){var a=
this.dropdown;a&&(g(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};l.prototype.getHeight=function(){var a=this.options,b=this.group,c=a.y,f=a.buttonPosition.y,e=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=b?b.getBBox(!0).height+13+c:0;b=Math.min(e,f);if(0>e&&0>f||0<e&&0<f)a+=Math.abs(b);return a};l.prototype.titleCollision=function(a){return!(a.options.title.text||a.options.subtitle.text)};l.prototype.update=function(a){var b=this.chart;C(!0,b.options.rangeSelector,
a);this.destroy();this.init(b);this.render()};l.prototype.destroy=function(){var a=this,b=a.minInput,c=a.maxInput;a.eventsToUnbind&&(a.eventsToUnbind.forEach(function(a){return a()}),a.eventsToUnbind=void 0);z(a.buttons);b&&(b.onfocus=b.onblur=b.onchange=null);c&&(c.onfocus=c.onblur=c.onchange=null);M(a,function(c,b){c&&"chart"!==b&&(c instanceof u?c.destroy():c instanceof window.HTMLElement&&e(c));c!==l.prototype[b]&&(a[b]=null)},this)};return l}();G(n.prototype,{defaultButtons:[{type:"month",count:1,
text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"}});"";return n});E(b,"Core/Axis/OrdinalAxis.js",[b["Core/Axis/Axis.js"],b["Core/Globals.js"],b["Core/Series/Series.js"],b["Core/Utilities.js"]],
function(b,n,t,k){var u=k.addEvent,v=k.correctFloat,h=k.css,F=k.defined,y=k.error,a=k.pick,g=k.timeUnits,p=[],z;(function(b){function e(a,b,d,e,m,q,p){void 0===m&&(m=[]);void 0===q&&(q=0);var c={},f=this.options.tickPixelInterval,r=this.chart.time,l=[],h,k,x=0,n=[],u=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!m||3>m.length||"undefined"===typeof b)return r.getTimeTicks.apply(r,arguments);var t=m.length;for(h=0;h<t;h++){var z=h&&m[h-1]>d;m[h]<b&&(x=h);if(h===t-1||m[h+1]-m[h]>
5*q||z){if(m[h]>u){for(k=r.getTimeTicks(a,m[x],m[h],e);k.length&&k[0]<=u;)k.shift();k.length&&(u=k[k.length-1]);l.push(n.length);n=n.concat(k)}x=h+1}if(z)break}if(k){k=k.info;if(p&&k.unitRange<=g.hour){h=n.length-1;for(x=1;x<h;x++)if(r.dateFormat("%d",n[x])!==r.dateFormat("%d",n[x-1])){c[n[x]]="day";var J=!0}J&&(c[n[0]]="day");k.higherRanks=c}k.segmentStarts=l;n.info=k}else y(12,!1,this.chart);if(p&&F(f)){k=n.length;r=[];x=[];h=void 0;for(J=k;J--;)l=this.translate(n[J]),h&&(x[J]=h-l),r[J]=h=l;x.sort();
x=x[Math.floor(x.length/2)];x<.6*f&&(x=null);J=n[k-1]>d?k-1:k;for(h=void 0;J--;)l=r[J],k=Math.abs(h-l),h&&k<.8*f&&(null===x||k<.8*x)?(c[n[J]]&&!c[n[J+1]]?(k=J+1,h=l):k=J,n.splice(k,1)):h=l}return n}function q(a){var c=this.ordinal.positions;if(!c)return a;var b=c.length-1;if(0>a)a=c[0];else if(a>b)a=c[b];else{b=Math.floor(a);var d=a-b}return"undefined"!==typeof d&&"undefined"!==typeof c[b]?c[b]+(d?d*(c[b+1]-c[b]):0):a}function z(a){var c=this.ordinal,b=c.positions;if(!b)return a;var d=(a-(this.old?
this.old.min:this.min))*(this.old?this.old.transA:this.transA)+this.minPixelPadding;0<d&&d<this.left+this.len||(c.extendedOrdinalPositions||(c.extendedOrdinalPositions=c.getExtendedPositions()),b=c.extendedOrdinalPositions);if(b&&b.length){a=c.getIndexOfPoint(d,b);c=v(a%1);if(0<=a&&a<b.length-1)return b[Math.floor(a)]+c*(b[Math.ceil(a)]-b[Math.floor(a)]);c=b.length;d=b[0];b=b[c-1];var e=(b-d)/(c-1);return 0>a?d+e*a:b+e*(a-c)}return a}function C(a,d){var c=b.Additions.findIndexOf(a,d,!0);return a[c]===
d?c:c+(d-a[c])/(a[c+1]-a[c])}function M(){this.ordinal||(this.ordinal=new b.Additions(this))}function D(){this.isXAxis&&F(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&F(this.userMin)&&(this.min+=this.options.overscroll))}function w(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)}
function I(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))}function A(a){var c=this.xAxis[0],b=c.options.overscroll,d=a.originalEvent.chartX,e=this.options.chart.panning,g=!1;if(e&&"y"!==e.type&&c.options.ordinal&&c.series.length){var m=this.mouseDownX,q=c.getExtremes(),p=q.dataMax,l=q.min,k=q.max,n=this.hoverPoints,u=c.closestPointRange||c.ordinal&&c.ordinal.overscrollPointsRange;m=(m-d)/(c.translationSlope*(c.ordinal.slope||
u));u=c.ordinal.getExtendedPositions();u={ordinal:{positions:u,extendedOrdinalPositions:u}};var t=c.index2val,z=c.val2lin,w=void 0,B=w=void 0,v=void 0;u.ordinal.positions?1<Math.abs(m)&&(n&&n.forEach(function(a){a.setState()}),0>m?(B=u,v=c.ordinal.positions?c:u):(B=c.ordinal.positions?c:u,v=u),w=v.ordinal.positions,p>w[w.length-1]&&w.push(p),this.fixedRange=k-l,w=c.navigatorAxis.toFixedRange(void 0,void 0,t.apply(B,[z.apply(B,[l,!0])+m]),t.apply(v,[z.apply(v,[k,!0])+m])),w.min>=Math.min(q.dataMin,
l)&&w.max<=Math.max(p,k)+b&&c.setExtremes(w.min,w.max,!0,!1,{trigger:"pan"}),this.mouseDownX=d,h(this.container,{cursor:"move"})):g=!0}else g=!0;g||e&&/y/.test(e.type)?b&&(c.max=c.dataMax+b):a.preventDefault()}function l(){var a=this.xAxis;a&&a.options.ordinal&&(delete a.ordinal.index,delete a.ordinal.extendedOrdinalPositions)}function d(a,b){var c=this.ordinal,d=c.positions,f=c.slope,e=c.extendedOrdinalPositions;if(!d)return a;var g=d.length;if(d[0]<=a&&d[g-1]>=a)a=C(d,a);else{e||(e=c.getExtendedPositions&&
c.getExtendedPositions(),c.extendedOrdinalPositions=e);if(!e||!e.length)return a;g=e.length;f||(f=(e[g-1]-e[0])/g);d=C(e,d[0]);a>=e[0]&&a<=e[g-1]?a=C(e,a)-d:a<e[0]?(a=e[0]-a,a=-d-a/f):(a-=e[g-1],a=a/f+g-d)}return b?a:f*(a||0)+c.offset}b.compose=function(a,b,g){if(k.pushUnique(p,a)){var c=a.prototype;c.getTimeTicks=e;c.index2val=q;c.lin2val=z;c.val2lin=d;c.ordinal2lin=c.val2lin;u(a,"afterInit",M);u(a,"foundExtremes",D);u(a,"afterSetScale",w);u(a,"initialAxisTranslation",I)}k.pushUnique(p,g)&&u(g,"pan",
A);k.pushUnique(p,b)&&u(b,"updatedData",l);return a};var m=function(){function c(a){this.index={};this.axis=a}c.prototype.beforeSetTickPositions=function(){var c=this.axis,b=c.ordinal,d=c.getExtremes(),e=d.min,g=d.max,m=c.isXAxis&&!!c.options.breaks;d=c.options.ordinal;var q=c.chart.options.chart.ignoreHiddenSeries,p,h,l=[],k=Number.MAX_VALUE,n=!1,u=!1,t=!1;if(d||m){var z=0;c.series.forEach(function(c,b){p=[];0<b&&"highcharts-navigator-series"!==c.options.id&&1<c.processedXData.length&&(u=z!==c.processedXData[1]-
c.processedXData[0]);z=c.processedXData[1]-c.processedXData[0];c.boosted&&(t=c.boosted);if(!(q&&!1===c.visible||!1===c.takeOrdinalPosition&&!m)&&(l=l.concat(c.processedXData),w=l.length,l.sort(function(a,c){return a-c}),k=Math.min(k,a(c.closestPointRange,k)),w)){for(b=0;b<w-1;)l[b]!==l[b+1]&&p.push(l[b+1]),b++;p[0]!==l[0]&&p.unshift(l[0]);l=p}});u&&t&&(l.pop(),l.shift());var w=l.length;if(2<w){var B=l[1]-l[0];for(h=w-1;h--&&!n;)l[h+1]-l[h]!==B&&(n=!0);!c.options.keepOrdinalPadding&&(l[0]-e>B||g-l[l.length-
1]>B)&&(n=!0)}else c.options.overscroll&&(2===w?k=l[1]-l[0]:1===w?(k=c.options.overscroll,l=[l[0],l[0]+k]):k=b.overscrollPointsRange);n||c.forceOrdinal?(c.options.overscroll&&(b.overscrollPointsRange=k,l=l.concat(b.getOverscrollPositions())),b.positions=l,B=c.ordinal2lin(Math.max(e,l[0]),!0),h=Math.max(c.ordinal2lin(Math.min(g,l[l.length-1]),!0),1),b.slope=g=(g-e)/(h-B),b.offset=e-B*g):(b.overscrollPointsRange=a(c.closestPointRange,b.overscrollPointsRange),b.positions=c.ordinal.slope=b.offset=void 0)}c.isOrdinal=
d&&n;b.groupIntervalFactor=null};c.findIndexOf=function(a,c,b){for(var d=0,e=a.length-1,f;d<e;)f=Math.ceil((d+e)/2),a[f]<=c?d=f:e=f-1;return a[d]===c?d:b?d:-1};c.prototype.getExtendedPositions=function(){var a=this,c=a.axis,b=c.constructor.prototype,d=c.chart,e=c.series[0].currentDataGrouping,g=e?e.count+e.unitName:"raw",m=c.options.overscroll,q=c.getExtremes(),l=void 0,p=a.index;p||(p=a.index={});if(!p[g]){var h={series:[],chart:d,forceOrdinal:!1,getExtremes:function(){return{min:q.dataMin,max:q.dataMax+
m}},getGroupPixelWidth:b.getGroupPixelWidth,getTimeTicks:b.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:b.ordinal2lin,getIndexOfPoint:b.getIndexOfPoint,val2lin:b.val2lin};h.ordinal.axis=h;c.series.forEach(function(c){l={xAxis:h,xData:c.xData.slice(),chart:d,destroyGroupedData:n.noop,getProcessedData:t.prototype.getProcessedData,applyGrouping:t.prototype.applyGrouping};l.xData=l.xData.concat(a.getOverscrollPositions());l.options={dataGrouping:e?
{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[e.unitName,[e.count]]]}:{enabled:!1}};h.series.push(l);c.processData.apply(l)});l.closestPointRange!==l.basePointRange&&l.currentDataGrouping&&(h.forceOrdinal=!0);c.ordinal.beforeSetTickPositions.apply({axis:h});p[g]=h.ordinal.positions}return p[g]};c.prototype.getGroupIntervalFactor=function(a,c,b){b=b.processedXData;var d=b.length,e=[];var f=this.groupIntervalFactor;if(!f){for(f=0;f<
d-1;f++)e[f]=b[f+1]-b[f];e.sort(function(a,c){return a-c});e=e[Math.floor(d/2)];a=Math.max(a,b[0]);c=Math.min(c,b[d-1]);this.groupIntervalFactor=f=d*e/(c-a)}return f};c.prototype.getIndexOfPoint=function(b,d){var e=this.axis,f=this.positions?this.positions[0]:0,g=e.series[0].points&&e.series[0].points[0]&&e.series[0].points[0].plotX||e.minPixelPadding;1<e.series.length&&e.series.forEach(function(c){c.points&&F(c.points[0])&&F(c.points[0].plotX)&&c.points[0].plotX<g&&c.points[0].plotX>=a(e.min,-Infinity)&&
(g=c.points[0].plotX)});b=(b-g)/(e.translationSlope*(this.slope||e.closestPointRange||this.overscrollPointsRange));return c.findIndexOf(d,f)+b};c.prototype.getOverscrollPositions=function(){var a=this.axis,c=a.options.overscroll,b=this.overscrollPointsRange,d=[],e=a.dataMax;if(F(b))for(;e<=a.dataMax+c;)e+=b,d.push(e);return d};c.prototype.postProcessTickInterval=function(a){var c=this.axis,b=this.slope;return b?c.options.breaks?c.closestPointRange||a:a/(b/c.closestPointRange):a};return c}();b.Additions=
m})(z||(z={}));return z});E(b,"Series/HLC/HLCPoint.js",[b["Core/Series/SeriesRegistry.js"]],function(b){var n=this&&this.__extends||function(){var b=function(k,n){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,h){b.__proto__=h}||function(b,h){for(var k in h)Object.prototype.hasOwnProperty.call(h,k)&&(b[k]=h[k])};return b(k,n)};return function(k,n){function u(){this.constructor=k}if("function"!==typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");
b(k,n);k.prototype=null===n?Object.create(n):(u.prototype=n.prototype,new u)}}();return function(b){function k(){var k=null!==b&&b.apply(this,arguments)||this;k.close=void 0;k.high=void 0;k.low=void 0;k.options=void 0;k.plotClose=void 0;k.series=void 0;return k}n(k,b);return k}(b.seriesTypes.column.prototype.pointClass)});E(b,"Series/HLC/HLCSeriesDefaults.js",[],function(){"";return{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},
threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}});E(b,"Series/HLC/HLCSeries.js",[b["Series/HLC/HLCPoint.js"],b["Series/HLC/HLCSeriesDefaults.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,n,t,k){var u=this&&this.__extends||function(){var b=function(a,g){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var e in b)Object.prototype.hasOwnProperty.call(b,e)&&(a[e]=b[e])};return b(a,g)};return function(a,
g){function p(){this.constructor=a}if("function"!==typeof g&&null!==g)throw new TypeError("Class extends value "+String(g)+" is not a constructor or null");b(a,g);a.prototype=null===g?Object.create(g):(p.prototype=g.prototype,new p)}}(),v=t.seriesTypes.column,h=k.extend,C=k.merge;k=function(b){function a(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.yData=void 0;return a}u(a,b);a.prototype.extendStem=function(a,b,h){var e=a[0];a=a[1];"number"===typeof e[2]&&
(e[2]=Math.max(h+b,e[2]));"number"===typeof a[2]&&(a[2]=Math.min(h-b,a[2]))};a.prototype.getPointPath=function(a,b){b=b.strokeWidth();var g=a.series,e=b%2/2,h=Math.round(a.plotX)-e,q=Math.round(a.shapeArgs.width/2),p=[["M",h,Math.round(a.yBottom)],["L",h,Math.round(a.plotHigh)]];null!==a.close&&(a=Math.round(a.plotClose)+e,p.push(["M",h,a],["L",h+q,a]),g.extendStem(p,b/2,a));return p};a.prototype.drawSinglePoint=function(a){var b=a.series,g=b.chart,e=a.graphic;"undefined"!==typeof a.plotY&&(e||(a.graphic=
e=g.renderer.path().add(b.group)),g.styledMode||e.attr(b.pointAttribs(a,a.selected&&"select")),b=b.getPointPath(a,e),e[e?"animate":"attr"]({d:b}).addClass(a.getClassName(),!0))};a.prototype.drawPoints=function(){this.points.forEach(this.drawSinglePoint)};a.prototype.init=function(){b.prototype.init.apply(this,arguments);this.options.stacking=void 0};a.prototype.pointAttribs=function(a,h){a=b.prototype.pointAttribs.call(this,a,h);delete a.fill;return a};a.prototype.toYData=function(a){return[a.high,
a.low,a.close]};a.prototype.translate=function(){var a=this,h=a.yAxis,k=this.pointArrayMap&&this.pointArrayMap.slice()||[],e=k.map(function(a){return"plot".concat(a.charAt(0).toUpperCase()+a.slice(1))});e.push("yBottom");k.push("low");b.prototype.translate.apply(a);a.points.forEach(function(b){k.forEach(function(g,p){g=b[g];null!==g&&(a.dataModify&&(g=a.dataModify.modifyValue(g)),b[e[p]]=h.toPixels(g,!0))});b.tooltipPos[1]=b.plotHigh+h.pos-a.chart.plotTop})};a.defaultOptions=C(v.defaultOptions,n);
return a}(v);h(k.prototype,{pointClass:b,animate:null,directTouch:!1,pointArrayMap:["high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});t.registerSeriesType("hlc",k);return k});E(b,"Series/OHLC/OHLCPoint.js",[b["Core/Series/SeriesRegistry.js"]],function(b){var n=this&&this.__extends||function(){var b=function(k,n){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,h){b.__proto__=h}||function(b,h){for(var k in h)Object.prototype.hasOwnProperty.call(h,
k)&&(b[k]=h[k])};return b(k,n)};return function(k,n){function u(){this.constructor=k}if("function"!==typeof n&&null!==n)throw new TypeError("Class extends value "+String(n)+" is not a constructor or null");b(k,n);k.prototype=null===n?Object.create(n):(u.prototype=n.prototype,new u)}}();return function(b){function k(){var k=null!==b&&b.apply(this,arguments)||this;k.open=void 0;k.options=void 0;k.plotOpen=void 0;k.series=void 0;return k}n(k,b);k.prototype.getClassName=function(){return b.prototype.getClassName.call(this)+
(this.open<this.close?" highcharts-point-up":" highcharts-point-down")};k.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)};k.prototype.resolveColor=function(){b.prototype.resolveColor.call(this);this.resolveUpColor()};k.prototype.getZone=function(){var k=b.prototype.getZone.call(this);this.resolveUpColor();return k};k.prototype.applyOptions=function(){b.prototype.applyOptions.apply(this,arguments);
this.resolveColor&&this.resolveColor();return this};return k}(b.seriesTypes.hlc.prototype.pointClass)});E(b,"Series/OHLC/OHLCSeriesDefaults.js",[],function(){"";return{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'}}});E(b,"Series/OHLC/OHLCSeries.js",[b["Series/OHLC/OHLCPoint.js"],b["Series/OHLC/OHLCSeriesDefaults.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],
function(b,n,t,k){function u(a){a=a.options;var b=a.dataGrouping;b&&a.useOhlcData&&"highcharts-navigator-series"!==a.id&&(b.approximation="ohlc")}function v(b){b=b.options;b.useOhlcData&&"highcharts-navigator-series"!==b.id&&a(this,{pointValKey:z.prototype.pointValKey,pointArrayMap:z.prototype.pointArrayMap,toYData:z.prototype.toYData})}var h=this&&this.__extends||function(){var a=function(b,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var e in b)Object.prototype.hasOwnProperty.call(b,
e)&&(a[e]=b[e])};return a(b,e)};return function(b,e){function g(){this.constructor=b}if("function"!==typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");a(b,e);b.prototype=null===e?Object.create(e):(g.prototype=e.prototype,new g)}}(),C=t.seriesTypes.hlc,y=k.addEvent,a=k.extend,g=k.merge,p=[],z=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}h(b,a);b.compose=function(a){for(var b=
1;b<arguments.length;b++);k.pushUnique(p,a)&&(y(a,"afterSetOptions",u),y(a,"init",v))};b.prototype.getPointPath=function(b,e){var g=a.prototype.getPointPath.call(this,b,e);e=e.strokeWidth();var h=e%2/2,q=Math.round(b.plotX)-h,k=Math.round(b.shapeArgs.width/2);null!==b.open&&(b=Math.round(b.plotOpen)+h,g.push(["M",q,b],["L",q-k,b]),a.prototype.extendStem.call(this,g,e/2,b));return g};b.prototype.pointAttribs=function(b,e){e=a.prototype.pointAttribs.call(this,b,e);var g=this.options;delete e.fill;!b.options.color&&
g.upColor&&b.open<b.close&&(e.stroke=g.upColor);return e};b.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]};b.defaultOptions=g(C.defaultOptions,n);return b}(C);a(z.prototype,{pointClass:b,pointArrayMap:["open","high","low","close"]});t.registerSeriesType("ohlc",z);return z});E(b,"Series/Candlestick/CandlestickSeriesDefaults.js",[b["Core/Defaults.js"],b["Core/Utilities.js"]],function(b,n){"";return{states:{hover:{lineWidth:2}},threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",
stickyTracking:!0}});E(b,"Series/Candlestick/CandlestickSeries.js",[b["Series/Candlestick/CandlestickSeriesDefaults.js"],b["Core/Defaults.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,n,t,k){var u=this&&this.__extends||function(){var a=function(b,h){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var e in b)Object.prototype.hasOwnProperty.call(b,e)&&(a[e]=b[e])};return a(b,h)};return function(b,h){function g(){this.constructor=
b}if("function"!==typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");a(b,h);b.prototype=null===h?Object.create(h):(g.prototype=h.prototype,new g)}}(),v=n.defaultOptions;n=t.seriesTypes;var h=n.column,C=n.ohlc,y=k.merge;k=function(a){function g(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}u(g,a);g.prototype.pointAttribs=function(a,b){var e=h.prototype.pointAttribs.call(this,a,b),g=this.options,
q=a.open<a.close,k=g.lineColor||this.color,p=a.color||this.color;e["stroke-width"]=g.lineWidth;e.fill=a.options.color||(q?g.upColor||p:p);e.stroke=a.options.lineColor||(q?g.upLineColor||k:k);b&&(a=g.states[b],e.fill=a.color||e.fill,e.stroke=a.lineColor||e.stroke,e["stroke-width"]=a.lineWidth||e["stroke-width"]);return e};g.prototype.drawPoints=function(){for(var a=this.chart,b=this.yAxis.reversed,e=0,g=this.points;e<g.length;e++){var h=g[e],k=h.graphic,n=!k;if("undefined"!==typeof h.plotY){k||(h.graphic=
k=a.renderer.path().add(this.group));this.chart.styledMode||k.attr(this.pointAttribs(h,h.selected&&"select")).shadow(this.options.shadow);var u=k.strokeWidth()%2/2;var t=Math.round(h.plotX)-u;var w=h.plotOpen;var v=h.plotClose;var A=Math.min(w,v);w=Math.max(w,v);var l=Math.round(h.shapeArgs.width/2);v=b?w!==h.yBottom:Math.round(A)!==Math.round(h.plotHigh);var d=b?Math.round(A)!==Math.round(h.plotHigh):w!==h.yBottom;A=Math.round(A)+u;w=Math.round(w)+u;u=[];u.push(["M",t-l,w],["L",t-l,A],["L",t+l,A],
["L",t+l,w],["Z"],["M",t,A],["L",t,v?Math.round(b?h.yBottom:h.plotHigh):A],["M",t,w],["L",t,d?Math.round(b?h.plotHigh:h.yBottom):w]);k[n?"attr":"animate"]({d:u}).addClass(h.getClassName(),!0)}}};g.defaultOptions=y(C.defaultOptions,v.plotOptions,{tooltip:C.defaultOptions.tooltip},b);return g}(C);t.registerSeriesType("candlestick",k);return k});E(b,"Series/Flags/FlagsPoint.js",[b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,n){var t=this&&this.__extends||function(){var b=function(k,
h){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,h){b.__proto__=h}||function(b,h){for(var a in h)Object.prototype.hasOwnProperty.call(h,a)&&(b[a]=h[a])};return b(k,h)};return function(k,h){function n(){this.constructor=k}if("function"!==typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");b(k,h);k.prototype=null===h?Object.create(h):(n.prototype=h.prototype,new n)}}(),k=n.isNumber;return function(b){function n(){var h=null!==
b&&b.apply(this,arguments)||this;h.options=void 0;h.series=void 0;h.ttBelow=!1;return h}t(n,b);n.prototype.isValid=function(){return k(this.y)||"undefined"===typeof this.y};n.prototype.hasNewShapeType=function(){var b=this.options.shape||this.series.options.shape;return this.graphic&&b&&b!==this.graphic.symbolKey};return n}(b.seriesTypes.column.prototype.pointClass)});E(b,"Series/Flags/FlagsSeriesDefaults.js",[],function(){"";return{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",
tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd3ff"}},style:{fontSize:"0.7em",fontWeight:"bold"}}});E(b,"Series/Flags/FlagsSymbols.js",[b["Core/Renderer/RendererRegistry.js"]],function(b){var n;(function(n){function k(b,k,n,a,g){var h=g&&g.anchorX||b;g=g&&g.anchorY||k;var t=this.circle(h-1,g-1,2,2);t.push(["M",h,g],["L",b,k+a],["L",b,k],["L",b+n,k],["L",b+n,k+a],["L",b,k+a],["Z"]);return t}function u(b,k){b[k+
"pin"]=function(h,a,g,p,n){var e=n&&n.anchorX;n=n&&n.anchorY;"circle"===k&&p>g&&(h-=Math.round((p-g)/2),g=p);var t=b[k](h,a,g,p);if(e&&n){var q=e;"circle"===k?q=h+g/2:(h=t[0],g=t[1],"M"===h[0]&&"L"===g[0]&&(q=(h[1]+g[1])/2));t.push(["M",q,a>n?a:a+p],["L",e,n]);t=t.concat(b.circle(e-1,n-1,2,2))}return t}}var t=[];n.compose=function(h){-1===t.indexOf(h)&&(t.push(h),h=h.prototype.symbols,h.flag=k,u(h,"circle"),u(h,"square"));h=b.getRendererType();t.indexOf(h)&&t.push(h)}})(n||(n={}));return n});E(b,
"Series/OnSeriesComposition.js",[b["Series/Column/ColumnSeries.js"],b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,n,t){var k=b.prototype,u=n.prototype,v=t.defined,h=t.stableSort,C;(function(b){function a(a){return u.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,a)}function g(){k.translate.apply(this);var a=this,b=a.options,g=a.chart,q=a.points,p=b.onSeries,n=(p=p&&g.get(p))&&p.options.step,t=p&&p.points,u=g.inverted,w=a.xAxis,C=a.yAxis;g=q.length-
1;var A;b=b.onKey||"y";var l=t&&t.length,d=0,m;if(p&&p.visible&&l){d=(p.pointXOffset||0)+(p.barW||0)/2;var c=p.currentDataGrouping;var f=t[l-1].x+(c?c.totalRange:0);h(q,function(a,b){return a.x-b.x});for(b="plot"+b[0].toUpperCase()+b.substr(1);l--&&q[g];){var r=t[l];c=q[g];c.y=r.y;if(r.x<=c.x&&"undefined"!==typeof r[b]){if(c.x<=f&&(c.plotY=r[b],r.x<c.x&&!n&&(m=t[l+1])&&"undefined"!==typeof m[b])){var x=(c.x-r.x)/(m.x-r.x);c.plotY+=x*(m[b]-r[b]);c.y+=x*(m.y-r.y)}g--;l++;if(0>g)break}}}q.forEach(function(b,
c){b.plotX+=d;if("undefined"===typeof b.plotY||u)0<=b.plotX&&b.plotX<=w.len?u?(b.plotY=w.translate(b.x,0,1,0,1),b.plotX=v(b.y)?C.translate(b.y,0,0,0,1):0):b.plotY=(w.opposite?0:a.yAxis.len)+w.offset:b.shapeArgs={};if((A=q[c-1])&&A.plotX===b.plotX){"undefined"===typeof A.stackIndex&&(A.stackIndex=0);var e=A.stackIndex+1}b.stackIndex=e});this.onSeries=p}var p=[];b.compose=function(b){if(t.pushUnique(p,b)){var e=b.prototype;e.getPlotBox=a;e.translate=g}return b};b.getPlotBox=a;b.translate=g})(C||(C=
{}));return C});E(b,"Series/Flags/FlagsSeries.js",[b["Series/Flags/FlagsPoint.js"],b["Series/Flags/FlagsSeriesDefaults.js"],b["Series/Flags/FlagsSymbols.js"],b["Core/Globals.js"],b["Series/OnSeriesComposition.js"],b["Core/Renderer/RendererUtilities.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Renderer/SVG/SVGElement.js"],b["Core/Utilities.js"]],function(b,n,t,k,u,v,h,E,y){var a=this&&this.__extends||function(){var a=function(b,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,
b){a.__proto__=b}||function(a,b){for(var e in b)Object.prototype.hasOwnProperty.call(b,e)&&(a[e]=b[e])};return a(b,e)};return function(b,e){function g(){this.constructor=b}if("function"!==typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");a(b,e);b.prototype=null===e?Object.create(e):(g.prototype=e.prototype,new g)}}();k=k.noop;var g=v.distribute,p=h.series,C=h.seriesTypes.column,e=y.addEvent,F=y.defined;v=y.extend;var q=y.merge,B=y.objectEach,
K=y.wrap;y=function(b){function h(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}a(h,b);h.prototype.animate=function(a){a&&this.setClip()};h.prototype.drawPoints=function(){var a=this.points,b=this.chart,e=b.renderer,h=b.inverted,d=this.options,m=d.y,c=this.yAxis,f={},k=[],p;for(p=a.length;p--;){var n=a[p];var t=(h?n.plotY:n.plotX)>this.xAxis.len;var u=n.plotX;var v=n.stackIndex;var C=n.options.shape||d.shape;var y=n.plotY;"undefined"!==typeof y&&
(y=n.plotY+m-("undefined"!==typeof v&&v*d.stackDistance));n.anchorX=v?void 0:n.plotX;var D=v?void 0:n.plotY;var z="flag"!==C;v=n.graphic;"undefined"!==typeof y&&0<=u&&!t?(v&&n.hasNewShapeType()&&(v=v.destroy()),v||(v=n.graphic=e.label("",null,null,C,null,null,d.useHTML).addClass("highcharts-point").add(this.markerGroup),n.graphic.div&&(n.graphic.div.point=n),v.isNew=!0),v.attr({align:z?"center":"left",width:d.width,height:d.height,"text-align":d.textAlign}),b.styledMode||v.attr(this.pointAttribs(n)).css(q(d.style,
n.style)).shadow(d.shadow),0<u&&(u-=v.strokeWidth()%2),C={y,anchorY:D},d.allowOverlapX&&(C.x=u,C.anchorX=n.anchorX),v.attr({text:n.options.title||d.title||"A"})[v.isNew?"attr":"animate"](C),d.allowOverlapX||(f[n.plotX]?f[n.plotX].size=Math.max(f[n.plotX].size,v.width):f[n.plotX]={align:z?.5:0,size:v.width,target:u,anchorX:u}),n.tooltipPos=[u,y+c.pos-b.plotTop]):v&&(n.graphic=v.destroy())}if(!d.allowOverlapX){var G=100;B(f,function(a){a.plotX=a.anchorX;k.push(a);G=Math.max(a.size,G)});g(k,h?c.len:
this.xAxis.len,G);for(b=0;b<a.length;b++)e=a[b],m=e.plotX,(m=(h=e.graphic)&&f[m])&&h&&(F(m.pos)?h[h.isNew?"attr":"animate"]({x:m.pos+(m.align||0)*m.size,anchorX:e.anchorX}).show().isNew=!1:h.hide().isNew=!0)}d.useHTML&&this.markerGroup&&K(this.markerGroup,"on",function(a){return E.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})};h.prototype.drawTracker=function(){var a=this.points;b.prototype.drawTracker.call(this);for(var g=function(b){var d=b.graphic;d&&
(b.unbindMouseOver&&b.unbindMouseOver(),b.unbindMouseOver=e(d.element,"mouseover",function(){0<b.stackIndex&&!b.raised&&(b._y=d.y,d.attr({y:b._y-8}),b.raised=!0);for(var e=0;e<a.length;e++){var c=a[e];c!==b&&c.raised&&c.graphic&&(c.graphic.attr({y:c._y}),c.raised=!1)}}))},h=0;h<a.length;h++)g(a[h])};h.prototype.pointAttribs=function(a,b){var e=this.options,g=a&&a.color||this.color,d=e.lineColor,h=a&&a.lineWidth;a=a&&a.fillColor||e.fillColor;b&&(a=e.states[b].fillColor,d=e.states[b].lineColor,h=e.states[b].lineWidth);
return{fill:a||g,stroke:d||g,"stroke-width":h||e.lineWidth||0}};h.prototype.setClip=function(){p.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])};h.compose=t.compose;h.defaultOptions=q(C.defaultOptions,n);return h}(C);u.compose(y);v(y.prototype,{allowDG:!1,forceCrop:!0,invertible:!1,noSharedTooltip:!0,pointClass:b,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],buildKDTree:k,
init:p.prototype.init});h.registerSeriesType("flags",y);"";return y});E(b,"Core/Chart/StockChart.js",[b["Core/Axis/Axis.js"],b["Core/Chart/Chart.js"],b["Core/FormatUtilities.js"],b["Core/Defaults.js"],b["Stock/Navigator/NavigatorDefaults.js"],b["Stock/RangeSelector/RangeSelectorDefaults.js"],b["Stock/Scrollbar/ScrollbarDefaults.js"],b["Core/Series/Series.js"],b["Core/Renderer/SVG/SVGRenderer.js"],b["Core/Utilities.js"]],function(b,n,t,k,u,v,h,E,y,a){function g(a,b){return"xAxis"===a?{minPadding:0,
maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:"yAxis"===a?{labels:{y:-2},opposite:A(b.opposite,!0),showLastLabel:!(!b.categories&&"category"!==b.type),title:{text:null}}:{}}function p(a,b){return"xAxis"===a?(a={type:"datetime",categories:void 0},A(b.navigator&&b.navigator.enabled,u.enabled,!0)&&(a.startOnTick=!1,a.endOnTick=!1),a):{}}var C=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&
function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),e=t.format,F=k.getOptions;t=a.addEvent;var q=a.clamp,B=a.defined,K=a.extend,M=a.find,D=a.isNumber,w=a.isString,I=a.merge,
A=a.pick,l=a.splat;a=function(a){function b(){return null!==a&&a.apply(this,arguments)||this}C(b,a);b.prototype.init=function(b,d){var c=F(),e=b.xAxis,f=b.yAxis,m=A(b.navigator&&b.navigator.enabled,u.enabled,!0);b.xAxis=b.yAxis=void 0;m=I({chart:{panning:{enabled:!0,type:"x"},zooming:{pinchType:"x"}},navigator:{enabled:m},scrollbar:{enabled:A(h.enabled,!0)},rangeSelector:{enabled:A(v.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:A(c.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},
b,{isStock:!0});b.xAxis=e;b.yAxis=f;m.xAxis=l(b.xAxis||{}).map(function(a,d){return I(g("xAxis",a),c.xAxis,c.xAxis&&c.xAxis[d],a,p("xAxis",b))});m.yAxis=l(b.yAxis||{}).map(function(a,b){return I(g("yAxis",a),c.yAxis,c.yAxis&&c.yAxis[b],a)});a.prototype.init.call(this,m,d)};b.prototype.createAxis=function(b,d){d.axis=I(g(b,d.axis),d.axis,p(b,this.userOptions));return a.prototype.createAxis.call(this,b,d)};return b}(n);(function(a){a.stockChart=function(b,c,d){return new a(b,c,d)}})(a||(a={}));t(E,
"setOptions",function(a){var b;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?b={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(b={marker:{enabled:!1,radius:2}}),b&&(a.plotOptions[this.type]=I(a.plotOptions[this.type],b)))});t(b,"autoLabelAlign",function(a){var b=this.chart,c=this.options,d=b._labelPanes=b._labelPanes||{},e=c.labels;b.options.isStock&&"yAxis"===this.coll&&(b=c.top+","+c.height,!d[b]&&e.enabled&&(15===e.distance&&1===this.side&&(e.distance=0),
"undefined"===typeof e.align&&(e.align="right"),d[b]=this,a.align="right",a.preventDefault()))});t(b,"destroy",function(){var a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});t(b,"getPlotLinePath",function(a){function b(a){var b="xAxis"===a?"yAxis":"xAxis";a=c.options[b];return D(a)?[e[b][a]]:w(a)?[e.get(a)]:d.map(function(a){return a[b]})}var c=this,d=this.isLinked&&!this.series?this.linkedParent.series:this.series,
e=c.chart,g=e.renderer,h=c.left,k=c.top,l,n,p,t,u=[],v=[],C=a.translatedValue,y=a.value,z=a.force;if(e.options.isStock&&!1!==a.acrossPanes&&"xAxis"===c.coll||"yAxis"===c.coll){a.preventDefault();v=b(c.coll);var E=c.isXAxis?e.yAxis:e.xAxis;E.forEach(function(a){if(B(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var b=a.isXAxis?"yAxis":"xAxis";b=B(a.options[b])?e[b][a.options[b]]:e[b][0];c===b&&v.push(a)}});var F=v.length?[]:[c.isXAxis?e.yAxis[0]:e.xAxis[0]];v.forEach(function(a){-1!==F.indexOf(a)||
M(F,function(b){return b.pos===a.pos&&b.len===a.len})||F.push(a)});var G=A(C,c.translate(y,void 0,void 0,a.old));D(G)&&(c.horiz?F.forEach(function(a){var b;n=a.pos;t=n+a.len;l=p=Math.round(G+c.transB);"pass"!==z&&(l<h||l>h+c.width)&&(z?l=p=q(l,h,h+c.width):b=!0);b||u.push(["M",l,n],["L",p,t])}):F.forEach(function(a){var b;l=a.pos;p=l+a.len;n=t=Math.round(k+c.height-G);"pass"!==z&&(n<k||n>k+c.height)&&(z?n=t=q(n,k,k+c.height):b=!0);b||u.push(["M",l,n],["L",p,t])}));a.path=0<u.length?g.crispPolyLine(u,
a.lineWidth||1):null}});y.prototype.crispPolyLine=function(a,b){for(var c=0;c<a.length;c+=2){var d=a[c],e=a[c+1];d[1]===e[1]&&(d[1]=e[1]=Math.round(d[1])-b%2/2);d[2]===e[2]&&(d[2]=e[2]=Math.round(d[2])+b%2/2)}return a};t(b,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});t(b,"afterDrawCrosshair",function(a){var b,c;if(this.crosshair&&this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&D(this.min)&&D(this.max)){var d=this.chart,g=this.logarithmic,
h=this.crosshair.label,k=this.horiz,l=this.opposite,n=this.left,p=this.top,q=this.width,t=this.crossLabel,u=h.format,v="",w="inside"===this.options.tickPosition,C=!1!==this.crosshair.snap,y=0,z=a.e||this.cross&&this.cross.e;a=a.point;var B=this.min,E=this.max;g&&(B=g.lin2log(B),E=g.lin2log(E));g=k?"center":l?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";t||(t=this.crossLabel=d.renderer.label("",0,void 0,h.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+
(a&&a.series?a.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:h.align||g,padding:A(h.padding,8),r:A(h.borderRadius,3),zIndex:2}).add(this.labelGroup),d.styledMode||t.attr({fill:h.backgroundColor||a&&a.series&&a.series.color||"#666666",stroke:h.borderColor||"","stroke-width":h.borderWidth||0}).css(K({color:"#ffffff",fontWeight:"normal",fontSize:"0.7em",textAlign:"center"},h.style||{})));k?(q=C?(a.plotX||0)+n:z.chartX,p+=l?0:this.height):(q=n+this.offset+(l?q:0),p=C?(a.plotY||
0)+p:z.chartY);u||h.formatter||(this.dateTime&&(v="%b %d, %Y"),u="{value"+(v?":"+v:"")+"}");v=C?this.isXAxis?a.x:a.y:this.toValue(k?z.chartX:z.chartY);C=a&&a.series?a.series.isPointInside(a):D(v)&&v>B&&v<E;z="";u?z=e(u,{value:v},d):h.formatter&&D(v)&&(z=h.formatter.call(this,v));t.attr({text:z,x:q,y:p,visibility:C?"inherit":"hidden"});h=t.getBBox();!D(t.x)||k||l||(q=t.x-h.width/2);if(D(t.y))if(k){if(w&&!l||!w&&l)p=t.y-h.height}else p=t.y-h.height/2;k?(b=n-h.x,c=n+this.width-h.x):(b="left"===this.labelAlign?
n:0,c="right"===this.labelAlign?n+this.width:d.chartWidth);t.translateX<b&&(y=b-t.translateX);t.translateX+h.width>=c&&(y=-(t.translateX+h.width-c));t.attr({x:q+y,y:p,anchorX:k?q:this.opposite?0:d.chartWidth,anchorY:k?this.opposite?d.chartHeight:0:p+h.height/2})}});E.prototype.forceCropping=function(){var a=this.chart,b=this.options.dataGrouping;return!1!==this.allowDG&&b&&A(b.enabled,a.options.isStock)};t(n,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(I(!0,this.options.scrollbar,
a.scrollbar),this.navigator.update({}),delete a.scrollbar)});return a});E(b,"masters/modules/stock.src.js",[b["Core/Globals.js"],b["Series/DataModifyComposition.js"],b["Stock/Navigator/Navigator.js"],b["Stock/RangeSelector/RangeSelector.js"],b["Stock/Scrollbar/Scrollbar.js"],b["Core/Axis/OrdinalAxis.js"],b["Series/OHLC/OHLCSeries.js"],b["Series/Flags/FlagsSeries.js"],b["Core/Chart/StockChart.js"]],function(b,n,t,k,u,v,h,E,y){b.Navigator=t;b.RangeSelector=k;b.Scrollbar=u;b.StockChart=b.stockChart=
y.stockChart;n.compose(b.Series,b.Axis,b.Point);E.compose(b.Renderer);t.compose(b.Axis,b.Chart,b.Series);h.compose(b.Series);v.compose(b.Axis,b.Series,b.Chart);k.compose(b.Axis,b.Chart);u.compose(b.Axis)})});
//# sourceMappingURL=stock.js.map