/*
 Highstock JS v11.0.0 (2023-04-26)

 Advanced Highcharts Stock tools

 (c) 2010-2021 Highsoft AS
 Author: Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/stock-tools",["highcharts","highcharts/modules/stock"],function(r){b(r);b.Highcharts=r;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function r(b,n,l,q){b.hasOwnProperty(n)||(b[n]=q.apply(null,l),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:n,
module:b[n]}})))}b=b?b._modules:{};r(b,"Core/Chart/ChartNavigationComposition.js",[],function(){var b;(function(b){b.compose=function(b){b.navigation||(b.navigation=new l(b));return b};var l=function(){function b(b){this.updates=[];this.chart=b}b.prototype.addUpdate=function(b){this.chart.navigation.updates.push(b)};b.prototype.update=function(b,d){var e=this;this.updates.forEach(function(H){H.call(e.chart,b,d)})};return b}();b.Additions=l})(b||(b={}));return b});r(b,"Extensions/Annotations/NavigationBindingsUtilities.js",
[b["Core/Utilities.js"]],function(b){var n=b.defined,l=b.isNumber,q=b.pick,g={backgroundColor:"string",borderColor:"string",borderRadius:"string",color:"string",fill:"string",fontSize:"string",labels:"string",name:"string",stroke:"string",title:"string"};return{annotationsFieldsTypes:g,getAssignedAxis:function(b){return b.filter(function(e){var b=e.axis.getExtremes(),d=b.min;b=b.max;var g=q(e.axis.minPointOffset,0);return l(d)&&l(b)&&e.value>=d-g&&e.value<=b+g&&!e.axis.options.isInternal})[0]},getFieldType:function(b,
e){b=g[b];e=typeof e;n(b)&&(e=b);return{string:"text",number:"number","boolean":"checkbox"}[e]}}});r(b,"Extensions/Annotations/NavigationBindingsDefaults.js",[b["Extensions/Annotations/NavigationBindingsUtilities.js"],b["Core/Utilities.js"]],function(b,n){var l=b.getAssignedAxis,q=n.isNumber,g=n.merge;return{lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",ellipse:"Ellipse",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",
format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",
start:function(b){var e=this.chart.pointer.getCoordinates(b);b=l(e.xAxis);e=l(e.yAxis);var d=this.chart.options.navigation;if(b&&e)return this.chart.addAnnotation(g({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:b.value,y:e.value,xAxis:b.axis.options.index,yAxis:e.axis.options.index},r:5}]},d.annotationsOptions,d.bindings.circleAnnotation.annotationsOptions))},steps:[function(b,e){var d=e.options.shapes;d=d&&d[0]&&d[0].point||{};if(q(d.xAxis)&&q(d.yAxis)){var g=this.chart.inverted;
var l=this.chart.xAxis[d.xAxis].toPixels(d.x);d=this.chart.yAxis[d.yAxis].toPixels(d.y);g=Math.max(Math.sqrt(Math.pow(g?d-b.chartX:l-b.chartX,2)+Math.pow(g?l-b.chartY:d-b.chartY,2)),5)}e.update({shapes:[{r:g}]})}]},ellipseAnnotation:{className:"highcharts-ellipse-annotation",start:function(b){var e=this.chart.pointer.getCoordinates(b);b=l(e.xAxis);e=l(e.yAxis);var d=this.chart.options.navigation;if(b&&e)return this.chart.addAnnotation(g({langKey:"ellipse",type:"basicAnnotation",shapes:[{type:"ellipse",
xAxis:b.axis.options.index,yAxis:e.axis.options.index,points:[{x:b.value,y:e.value},{x:b.value,y:e.value}],ry:1}]},d.annotationsOptions,d.bindings.ellipseAnnotation.annotationOptions))},steps:[function(b,e){e=e.shapes[0];var d=e.getAbsolutePosition(e.points[1]);e.translatePoint(b.chartX-d.x,b.chartY-d.y,1);e.redraw(!1)},function(b,e){e=e.shapes[0];var d=e.getAbsolutePosition(e.points[0]),g=e.getAbsolutePosition(e.points[1]);b=e.getDistanceFromLine(d,g,b.chartX,b.chartY);d=e.getYAxis();b=Math.abs(d.toValue(0)-
d.toValue(b));e.setYRadius(b);e.redraw(!1)}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(b){b=this.chart.pointer.getCoordinates(b);var e=l(b.xAxis),d=l(b.yAxis);if(e&&d){b=e.value;var n=d.value;e=e.axis.options.index;d=d.axis.options.index;var x=this.chart.options.navigation;return this.chart.addAnnotation(g({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:e,yAxis:d,x:b,y:n},{xAxis:e,yAxis:d,x:b,y:n},{xAxis:e,yAxis:d,x:b,y:n},{xAxis:e,
yAxis:d,x:b,y:n},{command:"Z"}]}]},x.annotationsOptions,x.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(b,e){var g=e.options.shapes;g=g&&g[0]&&g[0].points||[];var d=this.chart.pointer.getCoordinates(b);b=l(d.xAxis);d=l(d.yAxis);b&&d&&(b=b.value,d=d.value,g[1].x=b,g[2].x=b,g[2].y=d,g[3].y=d,e.update({shapes:[{points:g}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(b){var e=this.chart.pointer.getCoordinates(b);b=l(e.xAxis);e=l(e.yAxis);var d=this.chart.options.navigation;
if(b&&e)return this.chart.addAnnotation(g({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:b.axis.options.index,yAxis:e.axis.options.index,x:b.value,y:e.value},overflow:"none",crop:!0}]},d.annotationsOptions,d.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}}});r(b,"Extensions/Annotations/NavigationBindings.js",[b["Core/Chart/ChartNavigationComposition.js"],b["Core/Defaults.js"],b["Core/FormatUtilities.js"],
b["Core/Globals.js"],b["Extensions/Annotations/NavigationBindingsDefaults.js"],b["Extensions/Annotations/NavigationBindingsUtilities.js"],b["Core/Utilities.js"]],function(b,n,l,q,g,d,e){function v(a,c){var b=z.Element.prototype,f=b.matches||b.msMatchesSelector||b.webkitMatchesSelector,k=null;if(b.closest)k=b.closest.call(a,c);else{do{if(f.call(a,c))return a;a=a.parentElement||a.parentNode}while(null!==a&&1===a.nodeType)}return k}function r(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()}
function x(){this.navigationBindings&&this.navigationBindings.destroy()}function h(){var a=this.options;a&&a.navigation&&a.navigation.bindings&&(this.navigationBindings=new D(this,a.navigation),this.navigationBindings.initEvents(),this.navigationBindings.initUpdate())}function p(){var a=this.navigationBindings;if(this&&a){var c=!1;this.series.forEach(function(a){!a.options.isInternal&&a.visible&&(c=!0)});if(this.navigationBindings&&this.navigationBindings.container&&this.navigationBindings.container[0]){var b=
this.navigationBindings.container[0];y(a.boundClassNames,function(a,f){if(f=b.querySelectorAll("."+f))for(var k=0;k<f.length;k++){var u=f[k],e=u.className;"normal"===a.noDataState?-1!==e.indexOf("highcharts-disabled-btn")&&u.classList.remove("highcharts-disabled-btn"):c?-1!==e.indexOf("highcharts-disabled-btn")&&u.classList.remove("highcharts-disabled-btn"):-1===e.indexOf("highcharts-disabled-btn")&&(u.className+=" highcharts-disabled-btn")}})}}}function m(){this.deselectAnnotation()}function a(){this.selectedButtonElement=
null}function c(a){function c(a){var c=this,f=c.chart.navigationBindings,k=f.activeAnnotation;b&&b.call(c,a);k!==c?(f.deselectAnnotation(),f.activeAnnotation=c,c.setControlPointsVisibility(!0),A(f,"showPopup",{annotation:c,formType:"annotation-toolbar",options:f.annotationToFields(c),onSubmit:function(a){if("remove"===a.actionType)f.activeAnnotation=!1,f.chart.removeAnnotation(c);else{var b={};f.fieldsToOptions(a.fields,b);f.deselectAnnotation();a=b.typeOptions;"measure"===c.options.type&&(a.crosshairY.enabled=
0!==a.crosshairY.strokeWidth,a.crosshairX.enabled=0!==a.crosshairX.strokeWidth);c.update(b)}}})):A(f,"closePopup");a.activeAnnotation=!0}var b=a.prototype.defaultOptions.events&&a.prototype.defaultOptions.events.click,f,k;E(!0,a.prototype.defaultOptions.events,{click:c,touchstart:function(a){f=a.touches[0].clientX;k=a.touches[0].clientY},touchend:function(a){f&&4<=Math.sqrt(Math.pow(f-a.changedTouches[0].clientX,2)+Math.pow(k-a.changedTouches[0].clientY,2))||c.call(this,a)}})}var f=n.setOptions,u=
l.format,t=q.doc,z=q.win,k=d.getFieldType,w=e.addEvent,I=e.attr,A=e.fireEvent,C=e.isArray,J=e.isFunction,K=e.isNumber,F=e.isObject,E=e.merge,y=e.objectEach,G=e.pick,B=[],D=function(){function d(a,c){this.selectedButton=this.boundClassNames=void 0;this.chart=a;this.options=c;this.eventsToUnbind=[];this.container=this.chart.container.getElementsByClassName(this.options.bindingsClassName||"");this.container.length||(this.container=t.getElementsByClassName(this.options.bindingsClassName||""))}d.compose=
function(b,k){e.pushUnique(B,b)&&(w(b,"remove",r),c(b),y(b.types,function(a){c(a)}));e.pushUnique(B,k)&&(w(k,"destroy",x),w(k,"load",h),w(k,"render",p));e.pushUnique(B,d)&&(w(d,"closePopup",m),w(d,"deselectButton",a));e.pushUnique(B,f)&&f(g)};d.prototype.initEvents=function(){var a=this,c=a.chart,b=a.container,f=a.options;a.boundClassNames={};y(f.bindings||{},function(c){a.boundClassNames[c.className]=c});[].forEach.call(b,function(c){a.eventsToUnbind.push(w(c,"click",function(b){var f=a.getButtonEvents(c,
b);f&&!f.button.classList.contains("highcharts-disabled-btn")&&a.bindingsButtonClick(f.button,f.events,b)}))});y(f.events||{},function(c,b){J(c)&&a.eventsToUnbind.push(w(a,b,c,{passive:!1}))});a.eventsToUnbind.push(w(c.container,"click",function(b){!c.cancelClick&&c.isInsidePlot(b.chartX-c.plotLeft,b.chartY-c.plotTop,{visiblePlotOnly:!0})&&a.bindingsChartClick(this,b)}));a.eventsToUnbind.push(w(c.container,q.isTouchDevice?"touchmove":"mousemove",function(c){a.bindingsContainerMouseMove(this,c)},q.isTouchDevice?
{passive:!1}:void 0))};d.prototype.initUpdate=function(){var a=this;b.compose(this.chart).navigation.addUpdate(function(c){a.update(c)})};d.prototype.bindingsButtonClick=function(a,c,b){var f=this.chart,k=f.renderer.boxWrapper,u=!0;this.selectedButtonElement&&(this.selectedButtonElement.classList===a.classList&&(u=!1),A(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&"annotations"===this.currentUserDetails.coll&&f.removeAnnotation(this.currentUserDetails),
this.mouseMoveEvent=this.nextEvent=!1));u?(this.selectedButton=c,this.selectedButtonElement=a,A(this,"selectButton",{button:a}),c.init&&c.init.call(this,a,b),(c.start||c.steps)&&f.renderer.boxWrapper.addClass("highcharts-draw-mode")):(f.stockTools&&f.stockTools.toggleButtonActiveClass(a),k.removeClass("highcharts-draw-mode"),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=null)};d.prototype.bindingsChartClick=function(a,c){a=this.chart;var b=this.activeAnnotation,f=this.selectedButton;a=
a.renderer.boxWrapper;b&&(b.cancelClick||c.activeAnnotation||!c.target.parentNode||v(c.target,".highcharts-popup")?b.cancelClick&&setTimeout(function(){b.cancelClick=!1},0):A(this,"closePopup"));f&&f.start&&(this.nextEvent?(this.nextEvent(c,this.currentUserDetails),this.steps&&(this.stepIndex++,f.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=f.steps[this.stepIndex]:(A(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),f.end&&f.end.call(this,
c,this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=null))):(this.currentUserDetails=f.start.call(this,c))&&f.steps?(this.stepIndex=0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=f.steps[this.stepIndex]):(A(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,f.end&&f.end.call(this,c,this.currentUserDetails)))};d.prototype.bindingsContainerMouseMove=function(a,c){this.mouseMoveEvent&&
this.mouseMoveEvent(c,this.currentUserDetails)};d.prototype.fieldsToOptions=function(a,c){y(a,function(a,b){var f=parseFloat(a),k=b.split("."),u=k.length-1;!K(f)||a.match(/px/g)||b.match(/format/g)||(a=f);if("undefined"!==a){var d=c;k.forEach(function(c,b){var f=G(k[b+1],"");u===b?d[c]=a:(d[c]||(d[c]=f.match(/\d/g)?[]:{}),d=d[c])})}});return c};d.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)};d.prototype.annotationToFields=
function(a){function c(b,f,d,t,g){if(d&&b&&-1===h.indexOf(f)&&(0<=(d.indexOf&&d.indexOf(f))||d[f]||!0===d))if(C(b))t[f]=[],b.forEach(function(a,b){F(a)?(t[f][b]={},y(a,function(a,k){c(a,k,e[f],t[f][b],f)})):c(a,0,e[f],t[f],f)});else if(F(b)){var m={};C(t)?(t.push(m),m[f]={},m=m[f]):t[f]=m;y(b,function(a,b){c(a,b,0===f?d:e[f],m,f)})}else"format"===f?t[f]=[u(b,a.labels[0].points[0]).toString(),"text"]:C(t)?t.push([b,k(g,b)]):t[f]=[b,k(f,b)]}var b=a.options,f=d.annotationsEditable,e=f.nestedOptions,
t=G(b.type,b.shapes&&b.shapes[0]&&b.shapes[0].type,b.labels&&b.labels[0]&&b.labels[0].type,"label"),h=d.annotationsNonEditable[b.langKey]||[],g={langKey:b.langKey,type:t};y(b,function(a,k){"typeOptions"===k?(g[k]={},y(b[k],function(a,b){c(a,b,e,g[k],b)})):c(a,k,f[t],g,k)});return g};d.prototype.getClickedClassNames=function(a,c){var b=c.target;c=[];for(var f;b&&b.tagName&&((f=I(b,"class"))&&(c=c.concat(f.split(" ").map(function(a){return[a,b]}))),b=b.parentNode,b!==a););return c};d.prototype.getButtonEvents=
function(a,c){var b=this,f;this.getClickedClassNames(a,c).forEach(function(a){b.boundClassNames[a[0]]&&!f&&(f={events:b.boundClassNames[a[0]],button:a[1]})});return f};d.prototype.update=function(a){this.options=E(!0,this.options,a);this.removeEvents();this.initEvents()};d.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(a){return a()})};d.prototype.destroy=function(){this.removeEvents()};d.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],
labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],ellipse:["shapes"],verticalLine:[],
label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]};d.annotationsNonEditable={rectangle:["crosshairX","crosshairY","labelOptions"],ellipse:["labelOptions"],circle:["labelOptions"]};return d}();"";return D});r(b,"Stock/StockTools/StockToolsUtilities.js",[b["Core/Defaults.js"],b["Extensions/Annotations/NavigationBindingsUtilities.js"],
b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,n,l,q){function g(a,b){a=b.pointer.getCoordinates(a);var c=Number.MAX_VALUE,f;if(b.navigationBindings){var d=e(a.xAxis);var k=e(a.yAxis)}if(d&&k){var h=d.value;b=k.value;k.axis.series.forEach(function(a){a.points&&a.points.forEach(function(a){a&&c>Math.abs(a.x-h)&&(c=Math.abs(a.x-h),f=a)})});if(f&&f.x&&f.y)return{x:f.x,y:f.y,below:b<f.y,series:f.series,xAxis:f.series.xAxis.options.index||0,yAxis:f.series.yAxis.options.index||0}}}var d=
b.getOptions,e=n.getAssignedAxis,v=n.getFieldType,r=q.defined,x=q.fireEvent,h=q.isNumber,p=q.uniqueKey,m="apo ad aroon aroonoscillator atr ao cci chaikin cmf cmo disparityindex dmi dpo linearRegressionAngle linearRegressionIntercept linearRegressionSlope klinger macd mfi momentum natr obv ppo roc rsi slowstochastic stochastic trix williamsr".split(" "),a="ad cmf klinger mfi obv vbp vwap".split(" ");return{indicatorsWithAxes:m,indicatorsWithVolume:a,addFlagFromForm:function(a){return function(c){var b=
this,f=b.chart,d=f.stockTools;if(c=g(c,f)){var k={type:"flags",onSeries:c.series.id,shape:a,data:[{x:c.x,y:c.y}],xAxis:c.xAxis,yAxis:c.yAxis,point:{events:{click:function(){var a=this,c=a.options;x(b,"showPopup",{point:a,formType:"annotation-toolbar",options:{langKey:"flags",type:"flags",title:[c.title,v("title",c.title)],name:[c.name,v("name",c.name)]},onSubmit:function(c){"remove"===c.actionType?a.remove():a.update(b.fieldsToOptions(c.fields,{}))}})}}}};d&&d.guiEnabled||f.addSeries(k);x(b,"showPopup",
{formType:"flag",options:{langKey:"flags",type:"flags",title:["A",v("label","A")],name:["Flag A",v("label","Flag A")]},onSubmit:function(a){b.fieldsToOptions(a.fields,k.data[0]);f.addSeries(k)}})}}},attractToPoint:g,getAssignedAxis:e,isNotNavigatorYAxis:function(a){return"highcharts-navigator-yaxis"!==a.userOptions.className},isPriceIndicatorEnabled:function(a){return a.some(function(a){return a.lastVisiblePrice||a.lastPrice})},manageIndicators:function(c){var b=this.chart,e={linkedTo:c.linkedTo,
type:c.type};if("edit"===c.actionType)this.fieldsToOptions(c.fields,e),(c=b.get(c.seriesId))&&c.update(e,!1);else if("remove"===c.actionType){if(c=b.get(c.seriesId)){var h=c.yAxis;c.linkedSeries&&c.linkedSeries.forEach(function(a){a.remove(!1)});c.remove(!1);0<=m.indexOf(c.type)&&(e={height:h.options.height,top:h.options.top},h.remove(!1),this.resizeYAxes(e))}}else{e.id=p();this.fieldsToOptions(c.fields,e);h=b.get(e.linkedTo);var g=d().plotOptions;"undefined"!==typeof h&&h instanceof l&&"sum"===h.getDGApproximation()&&
!r(g&&g[e.type]&&g.dataGrouping&&g.dataGrouping.approximation)&&(e.dataGrouping={approximation:"sum"});0<=m.indexOf(c.type)?(h=b.addAxis({id:p(),offset:0,opposite:!0,title:{text:""},tickPixelInterval:40,showLastLabel:!1,labels:{align:"left",y:-2}},!1,!1),e.yAxis=h.options.id,this.resizeYAxes()):e.yAxis=b.get(c.linkedTo).options.yAxis;0<=a.indexOf(c.type)&&(e.params.volumeSeriesID=b.series.filter(function(a){return"column"===a.options.type})[0].options.id);b.addSeries(e,!1)}x(this,"deselectButton",
{button:this.selectedButtonElement});b.redraw()},updateHeight:function(a,b){var c=b.options.typeOptions,f=h(c.yAxis)&&this.chart.yAxis[c.yAxis];f&&c.points&&b.update({typeOptions:{height:f.toValue(a[f.horiz?"chartX":"chartY"])-(c.points[1].y||0)}})},updateNthPoint:function(a){return function(c,b){var f=b.options.typeOptions,d=h(f.xAxis)&&this.chart.xAxis[f.xAxis],k=h(f.yAxis)&&this.chart.yAxis[f.yAxis];d&&k&&(f.points.forEach(function(b,f){f>=a&&(b.x=d.toValue(c[d.horiz?"chartX":"chartY"]),b.y=k.toValue(c[k.horiz?
"chartX":"chartY"]))}),b.update({typeOptions:{points:f.points}}))}},updateRectSize:function(a,b){var c=b.chart,f=b.options.typeOptions,d=h(f.xAxis)&&c.xAxis[f.xAxis],k=h(f.yAxis)&&c.yAxis[f.yAxis];d&&k&&(d=d.toValue(a[d.horiz?"chartX":"chartY"]),a=k.toValue(a[k.horiz?"chartX":"chartY"]),k=d-f.point.x,f=f.point.y-a,b.update({typeOptions:{background:{width:c.inverted?f:k,height:c.inverted?k:f}}}))}}});r(b,"Stock/StockTools/StockToolsBindings.js",[b["Core/Globals.js"],b["Extensions/Annotations/NavigationBindingsUtilities.js"],
b["Stock/StockTools/StockToolsUtilities.js"],b["Core/Utilities.js"]],function(b,n,l,q){var g=n.getAssignedAxis;n=l.addFlagFromForm;var d=l.attractToPoint,e=l.isNotNavigatorYAxis,v=l.isPriceIndicatorEnabled,r=l.manageIndicators,x=l.updateHeight,h=l.updateNthPoint;l=l.updateRectSize;var p=q.fireEvent,m=q.merge;return{segment:{className:"highcharts-segment",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=m({langKey:"segment",
type:"crookedLine",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,y:c.value},{x:a.value,y:c.value}]}},b.annotationsOptions,b.bindings.segment.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1)]},arrowSegment:{className:"highcharts-arrow-segment",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=m({langKey:"arrowSegment",type:"crookedLine",typeOptions:{line:{markerEnd:"arrow"},
xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,y:c.value},{x:a.value,y:c.value}]}},b.annotationsOptions,b.bindings.arrowSegment.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1)]},ray:{className:"highcharts-ray",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=m({langKey:"ray",type:"infinityLine",typeOptions:{type:"ray",xAxis:a.axis.options.index,yAxis:c.axis.options.index,
points:[{x:a.value,y:c.value},{x:a.value,y:c.value}]}},b.annotationsOptions,b.bindings.ray.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1)]},arrowRay:{className:"highcharts-arrow-ray",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=m({langKey:"arrowRay",type:"infinityLine",typeOptions:{type:"ray",line:{markerEnd:"arrow"},xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,
y:c.value},{x:a.value,y:c.value}]}},b.annotationsOptions,b.bindings.arrowRay.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1)]},infinityLine:{className:"highcharts-infinity-line",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=m({langKey:"infinityLine",type:"infinityLine",typeOptions:{type:"line",xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,y:c.value},{x:a.value,y:c.value}]}},
b.annotationsOptions,b.bindings.infinityLine.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1)]},arrowInfinityLine:{className:"highcharts-arrow-infinity-line",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=m({langKey:"arrowInfinityLine",type:"infinityLine",typeOptions:{type:"line",line:{markerEnd:"arrow"},xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,y:c.value},{x:a.value,
y:c.value}]}},b.annotationsOptions,b.bindings.arrowInfinityLine.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1)]},horizontalLine:{className:"highcharts-horizontal-line",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=m({langKey:"horizontalLine",type:"infinityLine",draggable:"y",typeOptions:{type:"horizontalLine",xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,y:c.value}]}},
b.annotationsOptions,b.bindings.horizontalLine.annotationsOptions);this.chart.addAnnotation(a)}}},verticalLine:{className:"highcharts-vertical-line",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=m({langKey:"verticalLine",type:"infinityLine",draggable:"x",typeOptions:{type:"verticalLine",xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,y:c.value}]}},b.annotationsOptions,b.bindings.verticalLine.annotationsOptions);
this.chart.addAnnotation(a)}}},crooked3:{className:"highcharts-crooked3",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=a.value,d=c.value,e=this.chart.options.navigation;a=m({langKey:"crooked3",type:"crookedLine",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:b,y:d},{x:b,y:d},{x:b,y:d}]}},e.annotationsOptions,e.bindings.crooked3.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1),h(2)]},crooked5:{className:"highcharts-crooked5",
start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=a.value,d=c.value,e=this.chart.options.navigation;a=m({langKey:"crooked5",type:"crookedLine",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:b,y:d},{x:b,y:d},{x:b,y:d},{x:b,y:d},{x:b,y:d}]}},e.annotationsOptions,e.bindings.crooked5.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1),h(2),h(3),h(4)]},elliott3:{className:"highcharts-elliott3",start:function(a){var c=
this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=a.value,d=c.value,e=this.chart.options.navigation;a=m({langKey:"elliott3",type:"elliottWave",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:b,y:d},{x:b,y:d},{x:b,y:d},{x:b,y:d}]},labelOptions:{style:{color:"#666666"}}},e.annotationsOptions,e.bindings.elliott3.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1),h(2),h(3)]},elliott5:{className:"highcharts-elliott5",start:function(a){var c=
this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=a.value,d=c.value,e=this.chart.options.navigation;a=m({langKey:"elliott5",type:"elliottWave",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:b,y:d},{x:b,y:d},{x:b,y:d},{x:b,y:d},{x:b,y:d},{x:b,y:d}]},labelOptions:{style:{color:"#666666"}}},e.annotationsOptions,e.bindings.elliott5.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1),h(2),h(3),h(4),h(5)]},measureX:{className:"highcharts-measure-x",
start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=m({langKey:"measure",type:"measure",typeOptions:{selectType:"x",xAxis:a.axis.options.index,yAxis:c.axis.options.index,point:{x:a.value,y:c.value},crosshairX:{strokeWidth:1,stroke:"#000000"},crosshairY:{enabled:!1,strokeWidth:0,stroke:"#000000"},background:{width:0,height:0,strokeWidth:0,stroke:"#ffffff"}},labelOptions:{style:{color:"#666666"}}},b.annotationsOptions,
b.bindings.measureX.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[l]},measureY:{className:"highcharts-measure-y",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=m({langKey:"measure",type:"measure",typeOptions:{selectType:"y",xAxis:a.axis.options.index,yAxis:c.axis.options.index,point:{x:a.value,y:c.value},crosshairX:{enabled:!1,strokeWidth:0,stroke:"#000000"},crosshairY:{strokeWidth:1,stroke:"#000000"},
background:{width:0,height:0,strokeWidth:0,stroke:"#ffffff"}},labelOptions:{style:{color:"#666666"}}},b.annotationsOptions,b.bindings.measureY.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[l]},measureXY:{className:"highcharts-measure-xy",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=m({langKey:"measure",type:"measure",typeOptions:{selectType:"xy",xAxis:a.axis.options.index,yAxis:c.axis.options.index,
point:{x:a.value,y:c.value},background:{width:0,height:0,strokeWidth:10},crosshairX:{strokeWidth:1,stroke:"#000000"},crosshairY:{strokeWidth:1,stroke:"#000000"}},labelOptions:{style:{color:"#666666"}}},b.annotationsOptions,b.bindings.measureXY.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[l]},fibonacci:{className:"highcharts-fibonacci",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=a.value,d=c.value,e=this.chart.options.navigation;
a=m({langKey:"fibonacci",type:"fibonacci",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:b,y:d},{x:b,y:d}]},labelOptions:{style:{color:"#666666"}}},e.annotationsOptions,e.bindings.fibonacci.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1),x]},parallelChannel:{className:"highcharts-parallel-channel",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=a.value,d=c.value,e=this.chart.options.navigation;
a=m({langKey:"parallelChannel",type:"tunnel",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:b,y:d},{x:b,y:d}]}},e.annotationsOptions,e.bindings.parallelChannel.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1),x]},pitchfork:{className:"highcharts-pitchfork",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=a.value,d=c.value,e=this.chart.options.navigation;a=m({langKey:"pitchfork",type:"pitchfork",
typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,y:c.value,controlPoint:{style:{fill:"#f21313"}}},{x:b,y:d},{x:b,y:d}],innerBackground:{fill:"rgba(100, 170, 255, 0.8)"}},shapeOptions:{strokeWidth:2}},e.annotationsOptions,e.bindings.pitchfork.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[h(1),h(2)]},verticalCounter:{className:"highcharts-vertical-counter",start:function(a){if(a=d(a,this.chart)){this.verticalCounter=this.verticalCounter||0;var c=
this.chart.options.navigation;a=m({langKey:"verticalCounter",type:"verticalLine",typeOptions:{point:{x:a.x,y:a.y,xAxis:a.xAxis,yAxis:a.yAxis},label:{offset:a.below?40:-40,text:this.verticalCounter.toString()}},labelOptions:{style:{color:"#666666",fontSize:"0.7em"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},c.annotationsOptions,c.bindings.verticalCounter.annotationsOptions);a=this.chart.addAnnotation(a);this.verticalCounter++;a.options.events.click.call(a,{})}}},timeCycles:{className:"highcharts-time-cycles",
start:function(a){if(a=d(a,this.chart)){var c=this.chart.options.navigation;a=m({langKey:"timeCycles",type:"timeCycles",typeOptions:{xAxis:a.xAxis,yAxis:a.yAxis,points:[{x:a.x},{x:a.x}],line:{stroke:"rgba(0, 0, 0, 0.75)",fill:"transparent",strokeWidth:2}}},c.annotationsOptions,c.bindings.timeCycles.annotationsOptions);a=this.chart.addAnnotation(a);a.options.events.click.call(a,{});return a}},steps:[h(1)]},verticalLabel:{className:"highcharts-vertical-label",start:function(a){if(a=d(a,this.chart)){var c=
this.chart.options.navigation;a=m({langKey:"verticalLabel",type:"verticalLine",typeOptions:{point:{x:a.x,y:a.y,xAxis:a.xAxis,yAxis:a.yAxis},label:{offset:a.below?40:-40}},labelOptions:{style:{color:"#666666",fontSize:"0.7em"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},c.annotationsOptions,c.bindings.verticalLabel.annotationsOptions);a=this.chart.addAnnotation(a);a.options.events.click.call(a,{})}}},verticalArrow:{className:"highcharts-vertical-arrow",start:function(a){if(a=d(a,this.chart)){var c=
this.chart.options.navigation;a=m({langKey:"verticalArrow",type:"verticalLine",typeOptions:{point:{x:a.x,y:a.y,xAxis:a.xAxis,yAxis:a.yAxis},label:{offset:a.below?40:-40,format:" "},connector:{fill:"none",stroke:a.below?"#f21313":"#06b535"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},c.annotationsOptions,c.bindings.verticalArrow.annotationsOptions);a=this.chart.addAnnotation(a);a.options.events.click.call(a,{})}}},fibonacciTimeZones:{className:"highcharts-fibonacci-time-zones",start:function(a){var c=
this.chart.pointer.getCoordinates(a);a=g(c.xAxis);c=g(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=m({type:"fibonacciTimeZones",langKey:"fibonacciTimeZones",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value}]}},b.annotationsOptions,b.bindings.fibonacciTimeZones.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[function(a,c){var b=c.options.typeOptions.points;b=b&&b[0].x;var d=this.chart.pointer.getCoordinates(a);a=g(d.xAxis);d=g(d.yAxis);
c.update({typeOptions:{xAxis:a.axis.options.index,yAxis:d.axis.options.index,points:[{x:b},{x:a.value}]}})}]},flagCirclepin:{className:"highcharts-flag-circlepin",start:n("circlepin")},flagDiamondpin:{className:"highcharts-flag-diamondpin",start:n("flag")},flagSquarepin:{className:"highcharts-flag-squarepin",start:n("squarepin")},flagSimplepin:{className:"highcharts-flag-simplepin",start:n("nopin")},zoomX:{className:"highcharts-zoom-x",init:function(a){this.chart.update({chart:{zooming:{type:"x"}}});
p(this,"deselectButton",{button:a})}},zoomY:{className:"highcharts-zoom-y",init:function(a){this.chart.update({chart:{zooming:{type:"y"}}});p(this,"deselectButton",{button:a})}},zoomXY:{className:"highcharts-zoom-xy",init:function(a){this.chart.update({chart:{zooming:{type:"xy"}}});p(this,"deselectButton",{button:a})}},seriesTypeLine:{className:"highcharts-series-type-line",init:function(a){this.chart.series[0].update({type:"line",useOhlcData:!0});p(this,"deselectButton",{button:a})}},seriesTypeOhlc:{className:"highcharts-series-type-ohlc",
init:function(a){this.chart.series[0].update({type:"ohlc"});p(this,"deselectButton",{button:a})}},seriesTypeCandlestick:{className:"highcharts-series-type-candlestick",init:function(a){this.chart.series[0].update({type:"candlestick"});p(this,"deselectButton",{button:a})}},seriesTypeHeikinAshi:{className:"highcharts-series-type-heikinashi",init:function(a){this.chart.series[0].update({type:"heikinashi"});p(this,"deselectButton",{button:a})}},seriesTypeHLC:{className:"highcharts-series-type-hlc",init:function(a){this.chart.series[0].update({type:"hlc",
useOhlcData:!0});p(this,"deselectButton",{button:a})}},seriesTypeHollowCandlestick:{className:"highcharts-series-type-hollowcandlestick",init:function(a){this.chart.series[0].update({type:"hollowcandlestick"});p(this,"deselectButton",{button:a})}},fullScreen:{className:"highcharts-full-screen",noDataState:"normal",init:function(a){this.chart.fullscreen&&this.chart.fullscreen.toggle();p(this,"deselectButton",{button:a})}},currentPriceIndicator:{className:"highcharts-current-price-indicator",init:function(a){var c=
this.chart,b=c.series,d=c.stockTools,e=v(c.series);d&&d.guiEnabled&&(b.forEach(function(a){a.update({lastPrice:{enabled:!e},lastVisiblePrice:{enabled:!e,label:{enabled:!0}}},!1)}),c.redraw());p(this,"deselectButton",{button:a})}},indicators:{className:"highcharts-indicators",init:function(){var a=this;p(a,"showPopup",{formType:"indicators",options:{},onSubmit:function(c){r.call(a,c)}})}},toggleAnnotations:{className:"highcharts-toggle-annotations",init:function(a){var c=this.chart,b=c.stockTools,
d=b.getIconsURL();this.toggledAnnotations=!this.toggledAnnotations;(c.annotations||[]).forEach(function(a){a.setVisibility(!this.toggledAnnotations)},this);b&&b.guiEnabled&&(a.firstChild.style["background-image"]=this.toggledAnnotations?'url("'+d+'annotations-hidden.svg")':'url("'+d+'annotations-visible.svg")');p(this,"deselectButton",{button:a})}},saveChart:{className:"highcharts-save-chart",noDataState:"normal",init:function(a){var c=this.chart,d=[],h=[],g=[],m=[];c.annotations.forEach(function(a,
c){d[c]=a.userOptions});c.series.forEach(function(a){a.is("sma")?h.push(a.userOptions):"flags"===a.type&&g.push(a.userOptions)});c.yAxis.forEach(function(a){e(a)&&m.push(a.options)});b.win.localStorage.setItem("highcharts-chart",JSON.stringify({annotations:d,indicators:h,flags:g,yAxes:m}));p(this,"deselectButton",{button:a})}}}});r(b,"Stock/StockTools/StockToolsDefaults.js",[],function(){return{lang:{stockTools:{gui:{simpleShapes:"Simple shapes",lines:"Lines",crookedLines:"Crooked lines",measure:"Measure",
advanced:"Advanced",toggleAnnotations:"Toggle annotations",verticalLabels:"Vertical labels",flags:"Flags",zoomChange:"Zoom change",typeChange:"Type change",saveChart:"Save chart",indicators:"Indicators",currentPriceIndicator:"Current Price Indicators",zoomX:"Zoom X",zoomY:"Zoom Y",zoomXY:"Zooom XY",fullScreen:"Fullscreen",typeOHLC:"OHLC",typeLine:"Line",typeCandlestick:"Candlestick",typeHLC:"HLC",typeHollowCandlestick:"Hollow Candlestick",typeHeikinAshi:"Heikin Ashi",circle:"Circle",ellipse:"Ellipse",
label:"Label",rectangle:"Rectangle",flagCirclepin:"Flag circle",flagDiamondpin:"Flag diamond",flagSquarepin:"Flag square",flagSimplepin:"Flag simple",measureXY:"Measure XY",measureX:"Measure X",measureY:"Measure Y",segment:"Segment",arrowSegment:"Arrow segment",ray:"Ray",arrowRay:"Arrow ray",line:"Line",arrowInfinityLine:"Arrow line",horizontalLine:"Horizontal line",verticalLine:"Vertical line",infinityLine:"Infinity line",crooked3:"Crooked 3 line",crooked5:"Crooked 5 line",elliott3:"Elliott 3 line",
elliott5:"Elliott 5 line",verticalCounter:"Vertical counter",verticalLabel:"Vertical label",verticalArrow:"Vertical arrow",fibonacci:"Fibonacci",fibonacciTimeZones:"Fibonacci Time Zones",pitchfork:"Pitchfork",parallelChannel:"Parallel channel",timeCycles:"Time Cycles"}},navigation:{popup:{circle:"Circle",ellipse:"Ellipse",rectangle:"Rectangle",label:"Label",segment:"Segment",arrowSegment:"Arrow segment",ray:"Ray",arrowRay:"Arrow ray",line:"Line",arrowInfinityLine:"Arrow line",horizontalLine:"Horizontal line",
verticalLine:"Vertical line",crooked3:"Crooked 3 line",crooked5:"Crooked 5 line",elliott3:"Elliott 3 line",elliott5:"Elliott 5 line",verticalCounter:"Vertical counter",verticalLabel:"Vertical label",verticalArrow:"Vertical arrow",fibonacci:"Fibonacci",fibonacciTimeZones:"Fibonacci Time Zones",pitchfork:"Pitchfork",parallelChannel:"Parallel channel",infinityLine:"Infinity line",measure:"Measure",measureXY:"Measure XY",measureX:"Measure X",measureY:"Measure Y",timeCycles:"Time Cycles",flags:"Flags",
addButton:"Add",saveButton:"Save",editButton:"Edit",removeButton:"Remove",series:"Series",volume:"Volume",connector:"Connector",innerBackground:"Inner background",outerBackground:"Outer background",crosshairX:"Crosshair X",crosshairY:"Crosshair Y",tunnel:"Tunnel",background:"Background",noFilterMatch:"No match",searchIndicators:"Search Indicators",clearFilter:"\u2715 clear filter",index:"Index",period:"Period",periods:"Periods",standardDeviation:"Standard deviation",periodTenkan:"Tenkan period",periodSenkouSpanB:"Senkou Span B period",
periodATR:"ATR period",multiplierATR:"ATR multiplier",shortPeriod:"Short period",longPeriod:"Long period",signalPeriod:"Signal period",decimals:"Decimals",algorithm:"Algorithm",topBand:"Top band",bottomBand:"Bottom band",initialAccelerationFactor:"Initial acceleration factor",maxAccelerationFactor:"Max acceleration factor",increment:"Increment",multiplier:"Multiplier",ranges:"Ranges",highIndex:"High index",lowIndex:"Low index",deviation:"Deviation",xAxisUnit:"x-axis unit",factor:"Factor",fastAvgPeriod:"Fast average period",
slowAvgPeriod:"Slow average period",average:"Average",indicatorAliases:{abands:["Acceleration Bands"],bb:["Bollinger Bands"],dema:["Double Exponential Moving Average"],ema:["Exponential Moving Average"],ikh:["Ichimoku Kinko Hyo"],keltnerchannels:["Keltner Channels"],linearRegression:["Linear Regression"],pivotpoints:["Pivot Points"],pc:["Price Channel"],priceenvelopes:["Price Envelopes"],psar:["Parabolic SAR"],sma:["Simple Moving Average"],supertrend:["Super Trend"],tema:["Triple Exponential Moving Average"],
vbp:["Volume by Price"],vwap:["Volume Weighted Moving Average"],wma:["Weighted Moving Average"],zigzag:["Zig Zag"],apo:["Absolute price indicator"],ad:["Accumulation/Distribution"],aroon:["Aroon"],aroonoscillator:["Aroon oscillator"],atr:["Average True Range"],ao:["Awesome oscillator"],cci:["Commodity Channel Index"],chaikin:["Chaikin"],cmf:["Chaikin Money Flow"],cmo:["Chande Momentum Oscillator"],disparityindex:["Disparity Index"],dmi:["Directional Movement Index"],dpo:["Detrended price oscillator"],
klinger:["Klinger Oscillator"],linearRegressionAngle:["Linear Regression Angle"],linearRegressionIntercept:["Linear Regression Intercept"],linearRegressionSlope:["Linear Regression Slope"],macd:["Moving Average Convergence Divergence"],mfi:["Money Flow Index"],momentum:["Momentum"],natr:["Normalized Average True Range"],obv:["On-Balance Volume"],ppo:["Percentage Price oscillator"],roc:["Rate of Change"],rsi:["Relative Strength Index"],slowstochastic:["Slow Stochastic"],stochastic:["Stochastic"],trix:["TRIX"],
williamsr:["Williams %R"]}}}},stockTools:{gui:{enabled:!0,className:"highcharts-bindings-wrapper",toolbarClassName:"stocktools-toolbar",buttons:"indicators separator simpleShapes lines crookedLines measure advanced toggleAnnotations separator verticalLabels flags separator zoomChange fullScreen typeChange separator currentPriceIndicator saveChart".split(" "),definitions:{separator:{symbol:"separator.svg"},simpleShapes:{items:["label","circle","ellipse","rectangle"],circle:{symbol:"circle.svg"},ellipse:{symbol:"ellipse.svg"},
rectangle:{symbol:"rectangle.svg"},label:{symbol:"label.svg"}},flags:{items:["flagCirclepin","flagDiamondpin","flagSquarepin","flagSimplepin"],flagSimplepin:{symbol:"flag-basic.svg"},flagDiamondpin:{symbol:"flag-diamond.svg"},flagSquarepin:{symbol:"flag-trapeze.svg"},flagCirclepin:{symbol:"flag-elipse.svg"}},lines:{items:"segment arrowSegment ray arrowRay line arrowInfinityLine horizontalLine verticalLine".split(" "),segment:{symbol:"segment.svg"},arrowSegment:{symbol:"arrow-segment.svg"},ray:{symbol:"ray.svg"},
arrowRay:{symbol:"arrow-ray.svg"},line:{symbol:"line.svg"},arrowInfinityLine:{symbol:"arrow-line.svg"},verticalLine:{symbol:"vertical-line.svg"},horizontalLine:{symbol:"horizontal-line.svg"}},crookedLines:{items:["elliott3","elliott5","crooked3","crooked5"],crooked3:{symbol:"crooked-3.svg"},crooked5:{symbol:"crooked-5.svg"},elliott3:{symbol:"elliott-3.svg"},elliott5:{symbol:"elliott-5.svg"}},verticalLabels:{items:["verticalCounter","verticalLabel","verticalArrow"],verticalCounter:{symbol:"vertical-counter.svg"},
verticalLabel:{symbol:"vertical-label.svg"},verticalArrow:{symbol:"vertical-arrow.svg"}},advanced:{items:["fibonacci","fibonacciTimeZones","pitchfork","parallelChannel","timeCycles"],pitchfork:{symbol:"pitchfork.svg"},fibonacci:{symbol:"fibonacci.svg"},fibonacciTimeZones:{symbol:"fibonacci-timezone.svg"},parallelChannel:{symbol:"parallel-channel.svg"},timeCycles:{symbol:"time-cycles.svg"}},measure:{items:["measureXY","measureX","measureY"],measureX:{symbol:"measure-x.svg"},measureY:{symbol:"measure-y.svg"},
measureXY:{symbol:"measure-xy.svg"}},toggleAnnotations:{symbol:"annotations-visible.svg"},currentPriceIndicator:{symbol:"current-price-show.svg"},indicators:{symbol:"indicators.svg"},zoomChange:{items:["zoomX","zoomY","zoomXY"],zoomX:{symbol:"zoom-x.svg"},zoomY:{symbol:"zoom-y.svg"},zoomXY:{symbol:"zoom-xy.svg"}},typeChange:{items:"typeOHLC typeLine typeCandlestick typeHollowCandlestick typeHLC typeHeikinAshi".split(" "),typeOHLC:{symbol:"series-ohlc.svg"},typeLine:{symbol:"series-line.svg"},typeCandlestick:{symbol:"series-candlestick.svg"},
typeHLC:{symbol:"series-hlc.svg"},typeHeikinAshi:{symbol:"series-heikin-ashi.svg"},typeHollowCandlestick:{symbol:"series-hollow-candlestick.svg"}},fullScreen:{symbol:"fullscreen.svg"},saveChart:{symbol:"save-chart.svg"}}}}}});r(b,"Stock/StockTools/StockTools.js",[b["Core/Defaults.js"],b["Extensions/Annotations/NavigationBindingsUtilities.js"],b["Stock/StockTools/StockToolsBindings.js"],b["Stock/StockTools/StockToolsDefaults.js"],b["Stock/StockTools/StockToolsUtilities.js"],b["Core/Utilities.js"]],
function(b,n,l,q,g,d){function e(a,b,d,e){function k(a){return f(a)&&!u(a)&&a.match("%")}var h=0,g;if(e){var m=c(parseFloat(e.top)/100);var p=c(parseFloat(e.height)/100)}return{positions:a.map(function(f,e){var w=c(k(f.options.height)?parseFloat(f.options.height)/100:f.height/b);f=c(k(f.options.top)?parseFloat(f.options.top)/100:(f.top-f.chart.plotTop)/b);p?(f>m&&(f-=p),h=Math.max(h,(f||0)+(w||0))):(u(w)||(w=a[e-1].series.every(function(a){return a.is("sma")})?g:d/100),u(f)||(f=h),g=w,h=c(Math.max(h,
(f||0)+(w||0))));return{height:100*w,top:100*f}}),allAxesHeight:h}}function v(a){var b=[];a.forEach(function(c,d){c=a[d+1];b[d]=c?{enabled:!0,controlledAxis:{next:[t(c.options.id,c.options.index)]}}:{enabled:!1}});return b}function r(a,b,d,f){a.forEach(function(e,k){k=a[k-1];e.top=k?c(k.height+k.top):0;d&&(e.height=c(e.height+f*b))});return a}function x(a){var b=this.chart,d=b.yAxis.filter(m);b=this.getYAxisPositions(d,b.plotHeight,20,a);var f=b.positions,e=b.allAxesHeight,k=this.getYAxisResizers(d);
!a&&e<=c(1)?f[f.length-1]={height:20,top:c(100*e-20)}:f.forEach(function(a){a.height=a.height/(100*e)*100;a.top=a.top/(100*e)*100});f.forEach(function(a,b){d[b].update({height:a.height+"%",top:a.top+"%",resize:k[b],offset:0},!1)})}var h=b.setOptions,p=n.getAssignedAxis,m=g.isNotNavigatorYAxis,a=g.isPriceIndicatorEnabled,c=d.correctFloat,f=d.defined,u=d.isNumber,t=d.pick,z=[];return{compose:function(b){d.pushUnique(z,b)&&(b=b.prototype,b.getYAxisPositions=e,b.getYAxisResizers=v,b.recalculateYAxisPositions=
r,b.resizeYAxes=x,b.utils={indicatorsWithAxes:g.indicatorsWithAxes,indicatorsWithVolume:g.indicatorsWithVolume,getAssignedAxis:p,isPriceIndicatorEnabled:a,manageIndicators:g.manageIndicators});d.pushUnique(z,h)&&(h(q),h({navigation:{bindings:l}}))}}});r(b,"Stock/StockTools/StockToolbar.js",[b["Core/Utilities.js"]],function(b){var n=b.addEvent,l=b.createElement,q=b.css,g=b.fireEvent,d=b.getStyle,e=b.isArray,r=b.merge,v=b.pick;b=function(){function b(b,d,e){this.wrapper=this.toolbar=this.submenu=this.showhideBtn=
this.listWrapper=this.arrowWrapper=this.arrowUp=this.arrowDown=void 0;this.chart=e;this.options=b;this.lang=d;this.iconsURL=this.getIconsURL();this.guiEnabled=b.enabled;this.visible=v(b.visible,!0);this.placed=v(b.placed,!1);this.eventsToUnbind=[];this.guiEnabled&&(this.createHTML(),this.init(),this.showHideNavigatorion());g(this,"afterInit")}b.prototype.init=function(){var b=this,d=this.lang,g=this.options,a=this.toolbar,c=g.definitions,f=a.childNodes;g.buttons.forEach(function(h){var g=b.addButton(a,
c,h,d);b.eventsToUnbind.push(n(g.buttonWrapper,"click",function(){return b.eraseActiveButtons(f,g.buttonWrapper)}));e(c[h].items)&&b.addSubmenu(g,c[h])})};b.prototype.addSubmenu=function(b,e){var g=this,a=b.submenuArrow,c=b.buttonWrapper,f=d(c,"width"),h=this.wrapper,p=this.listWrapper,r=this.toolbar.childNodes,k=this.submenu=l("ul",{className:"highcharts-submenu-wrapper"},void 0,c);this.addSubmenuItems(c,e);this.eventsToUnbind.push(n(a,"click",function(a){a.stopPropagation();g.eraseActiveButtons(r,
c);0<=c.className.indexOf("highcharts-current")?(p.style.width=p.startWidth+"px",c.classList.remove("highcharts-current"),k.style.display="none"):(k.style.display="block",a=k.offsetHeight-c.offsetHeight-3,k.offsetHeight+c.offsetTop>h.offsetHeight&&c.offsetTop>a||(a=0),q(k,{top:-a+"px",left:f+3+"px"}),c.className+=" highcharts-current",p.startWidth=h.offsetWidth,p.style.width=p.startWidth+d(p,"padding-left")+k.offsetWidth+3+"px")}))};b.prototype.addSubmenuItems=function(b,d){var e=this,a=this,c=this.submenu,
f=this.lang,g=this.listWrapper,h;d.items.forEach(function(k){h=e.addButton(c,d,k,f);e.eventsToUnbind.push(n(h.mainButton,"click",function(){a.switchSymbol(this,b,!0);g.style.width=g.startWidth+"px";c.style.display="none"}))});var p=c.querySelectorAll("li > .highcharts-menu-item-btn")[0];this.switchSymbol(p,!1)};b.prototype.eraseActiveButtons=function(b,d,e){[].forEach.call(b,function(a){a!==d&&(a.classList.remove("highcharts-current"),a.classList.remove("highcharts-active"),e=a.querySelectorAll(".highcharts-submenu-wrapper"),
0<e.length&&(e[0].style.display="none"))})};b.prototype.addButton=function(d,e,g,a){void 0===a&&(a={});e=e[g];var c=e.items,f=e.className||"";d=l("li",{className:v(b.prototype.classMapping[g],"")+" "+f,title:a[g]||g},void 0,d);g=l("span",{className:"highcharts-menu-item-btn"},void 0,d);if(c&&c.length)return e=l("span",{className:"highcharts-submenu-item-arrow highcharts-arrow-right"},void 0,d),e.style.backgroundImage="url("+this.iconsURL+"arrow-bottom.svg)",{buttonWrapper:d,mainButton:g,submenuArrow:e};
g.style.backgroundImage="url("+this.iconsURL+e.symbol+")";return{buttonWrapper:d,mainButton:g}};b.prototype.addNavigation=function(){var b=this.wrapper;this.arrowWrapper=l("div",{className:"highcharts-arrow-wrapper"});this.arrowUp=l("div",{className:"highcharts-arrow-up"},void 0,this.arrowWrapper);this.arrowUp.style.backgroundImage="url("+this.iconsURL+"arrow-right.svg)";this.arrowDown=l("div",{className:"highcharts-arrow-down"},void 0,this.arrowWrapper);this.arrowDown.style.backgroundImage="url("+
this.iconsURL+"arrow-right.svg)";b.insertBefore(this.arrowWrapper,b.childNodes[0]);this.scrollButtons()};b.prototype.scrollButtons=function(){var b=this.wrapper,d=this.toolbar,e=.1*b.offsetHeight,a=0;this.eventsToUnbind.push(n(this.arrowUp,"click",function(){0<a&&(a-=e,d.style.marginTop=-a+"px")}));this.eventsToUnbind.push(n(this.arrowDown,"click",function(){b.offsetHeight+a<=d.offsetHeight+e&&(a+=e,d.style.marginTop=-a+"px")}))};b.prototype.createHTML=function(){var b=this.chart,d=this.options,e=
b.container,a=b.options.navigation,c=this.wrapper=l("div",{className:"highcharts-stocktools-wrapper "+d.className+" "+(a&&a.bindingsClassName)});e.appendChild(c);["mousedown","mousemove","click","touchstart"].forEach(function(a){n(c,a,function(a){return a.stopPropagation()})});n(c,"mouseover",function(a){return b.pointer.onContainerMouseLeave(a)});this.toolbar=e=l("ul",{className:"highcharts-stocktools-toolbar "+d.toolbarClassName});this.listWrapper=d=l("div",{className:"highcharts-menu-wrapper"});
c.insertBefore(d,c.childNodes[0]);d.insertBefore(e,d.childNodes[0]);this.showHideToolbar();this.addNavigation()};b.prototype.showHideNavigatorion=function(){this.visible&&this.toolbar.offsetHeight>this.wrapper.offsetHeight-50?this.arrowWrapper.style.display="block":(this.toolbar.style.marginTop="0px",this.arrowWrapper.style.display="none")};b.prototype.showHideToolbar=function(){var b=this.chart,e=this.wrapper,g=this.listWrapper,a=this.submenu,c=this.showhideBtn=l("div",{className:"highcharts-toggle-toolbar highcharts-arrow-left"},
void 0,e),f=this.visible;c.style.backgroundImage="url("+this.iconsURL+"arrow-right.svg)";f?(e.style.height="100%",c.style.top=d(g,"padding-top")+"px",c.style.left=e.offsetWidth+d(g,"padding-left")+"px"):(a&&(a.style.display="none"),c.style.left="0px",f=this.visible=!1,g.classList.add("highcharts-hide"),c.classList.toggle("highcharts-arrow-right"),e.style.height=c.offsetHeight+"px");this.eventsToUnbind.push(n(c,"click",function(){b.update({stockTools:{gui:{visible:!f,placed:!0}}})}))};b.prototype.switchSymbol=
function(b,d){var e=b.parentNode,a=e.className;e=e.parentNode.parentNode;-1<a.indexOf("highcharts-disabled-btn")||(e.className="",a&&e.classList.add(a.trim()),e.querySelectorAll(".highcharts-menu-item-btn")[0].style.backgroundImage=b.style.backgroundImage,d&&this.toggleButtonActiveClass(e))};b.prototype.toggleButtonActiveClass=function(b){b=b.classList;b.contains("highcharts-active")?b.remove("highcharts-active"):b.add("highcharts-active")};b.prototype.unselectAllButtons=function(b){var d=b.parentNode.querySelectorAll(".highcharts-active");
[].forEach.call(d,function(d){d!==b&&d.classList.remove("highcharts-active")})};b.prototype.update=function(b,d){r(!0,this.chart.options.stockTools,b);this.destroy();this.chart.setStockTools(b);this.chart.navigationBindings&&this.chart.navigationBindings.update();this.chart.isDirtyBox=!0;v(d,!0)&&this.chart.redraw()};b.prototype.destroy=function(){var b=this.wrapper,d=b&&b.parentNode;this.eventsToUnbind.forEach(function(b){return b()});d&&d.removeChild(b)};b.prototype.redraw=function(){this.showHideNavigatorion()};
b.prototype.getIconsURL=function(){return this.chart.options.navigation.iconsURL||this.options.iconsURL||"https://code.highcharts.com/11.0.0/gfx/stock-icons/"};return b}();b.prototype.classMapping={circle:"highcharts-circle-annotation",ellipse:"highcharts-ellipse-annotation",rectangle:"highcharts-rectangle-annotation",label:"highcharts-label-annotation",segment:"highcharts-segment",arrowSegment:"highcharts-arrow-segment",ray:"highcharts-ray",arrowRay:"highcharts-arrow-ray",line:"highcharts-infinity-line",
arrowInfinityLine:"highcharts-arrow-infinity-line",verticalLine:"highcharts-vertical-line",horizontalLine:"highcharts-horizontal-line",crooked3:"highcharts-crooked3",crooked5:"highcharts-crooked5",elliott3:"highcharts-elliott3",elliott5:"highcharts-elliott5",pitchfork:"highcharts-pitchfork",fibonacci:"highcharts-fibonacci",fibonacciTimeZones:"highcharts-fibonacci-time-zones",parallelChannel:"highcharts-parallel-channel",measureX:"highcharts-measure-x",measureY:"highcharts-measure-y",measureXY:"highcharts-measure-xy",
timeCycles:"highcharts-time-cycles",verticalCounter:"highcharts-vertical-counter",verticalLabel:"highcharts-vertical-label",verticalArrow:"highcharts-vertical-arrow",currentPriceIndicator:"highcharts-current-price-indicator",indicators:"highcharts-indicators",flagCirclepin:"highcharts-flag-circlepin",flagDiamondpin:"highcharts-flag-diamondpin",flagSquarepin:"highcharts-flag-squarepin",flagSimplepin:"highcharts-flag-simplepin",zoomX:"highcharts-zoom-x",zoomY:"highcharts-zoom-y",zoomXY:"highcharts-zoom-xy",
typeLine:"highcharts-series-type-line",typeOHLC:"highcharts-series-type-ohlc",typeHLC:"highcharts-series-type-hlc",typeCandlestick:"highcharts-series-type-candlestick",typeHollowCandlestick:"highcharts-series-type-hollowcandlestick",typeHeikinAshi:"highcharts-series-type-heikinashi",fullScreen:"highcharts-full-screen",toggleAnnotations:"highcharts-toggle-annotations",saveChart:"highcharts-save-chart",separator:"highcharts-separator"};return b});r(b,"Stock/StockTools/StockToolsGui.js",[b["Core/Defaults.js"],
b["Stock/StockTools/StockToolsDefaults.js"],b["Stock/StockTools/StockToolbar.js"],b["Core/Utilities.js"]],function(b,n,l,q){function g(a){var b=this.options,c=b.lang;a=u(b.stockTools&&b.stockTools.gui,a&&a.gui);this.stockTools=new l(a,c&&c.stockTools&&c.stockTools.gui,this);this.stockTools.guiEnabled&&(this.isDirtyBox=!0)}function d(){this.setStockTools()}function e(){if(this.stockTools){var a=this.options.chart,b=this.stockTools.listWrapper;b=b&&(b.startWidth+f(b,"padding-left")+f(b,"padding-right")||
b.offsetWidth);var c=!1;b&&b<this.plotWidth?(a=t(a.spacingLeft,a.spacing&&a.spacing[3],0)+b,c=a-this.spacingBox.x,this.spacingBox.x=a,this.spacingBox.width-=c,c=!0):0===b&&(c=!0);b!==this.stockTools.prevOffsetWidth&&(this.stockTools.prevOffsetWidth=b,c&&(this.isDirtyLegend=!0))}}function r(){this.stockTools&&this.stockTools.destroy()}function v(){var a=this.stockTools&&this.stockTools.listWrapper;(a=a&&(a.startWidth+f(a,"padding-left")+f(a,"padding-right")||a.offsetWidth))&&a<this.plotWidth&&(this.plotLeft+=
a,this.spacing[3]+=a)}function x(){this.stockTools&&this.stockTools.guiEnabled&&this.stockTools.redraw()}function h(){var a=this.stockTools,b=a&&a.toolbar&&a.toolbar.querySelector(".highcharts-current-price-indicator");a&&this.navigationBindings&&this.options.series&&b&&(this.navigationBindings.constructor.prototype.utils.isPriceIndicatorEnabled(this.series)?b.firstChild.style["background-image"]='url("'+a.getIconsURL()+'current-price-hide.svg")':b.firstChild.style["background-image"]='url("'+a.getIconsURL()+
'current-price-show.svg")')}function p(a){var b=this.chart.stockTools;b&&b.guiEnabled&&(a=a.button,0<=a.parentNode.className.indexOf("highcharts-submenu-wrapper")&&(a=a.parentNode.parentNode),b.toggleButtonActiveClass(a))}function m(a){var b=this.chart.stockTools;if(b&&b.guiEnabled){var c=a.button;b.unselectAllButtons(a.button);0<=c.parentNode.className.indexOf("highcharts-submenu-wrapper")&&(c=c.parentNode.parentNode);b.toggleButtonActiveClass(c)}}var a=b.setOptions,c=q.addEvent,f=q.getStyle,u=q.merge,
t=q.pick,z=[];return{compose:function(b,f){q.pushUnique(z,b)&&(c(b,"afterGetContainer",d),c(b,"beforeRedraw",e),c(b,"beforeRender",e),c(b,"destroy",r),c(b,"getMargins",v,{order:0}),c(b,"redraw",x),c(b,"render",h),b.prototype.setStockTools=g);q.pushUnique(z,f)&&(c(f,"deselectButton",p),c(f,"selectButton",m));q.pushUnique(z,a)&&a(n)}}});r(b,"masters/modules/stock-tools.src.js",[b["Core/Globals.js"],b["Extensions/Annotations/NavigationBindings.js"],b["Stock/StockTools/StockTools.js"],b["Stock/StockTools/StockToolsGui.js"],
b["Stock/StockTools/StockToolbar.js"]],function(b,n,l,q,g){b.Toolbar=g;l.compose(n);q.compose(b.Chart,n)})});
//# sourceMappingURL=stock-tools.js.map