/*
 Highcharts JS v11.0.0 (2023-04-26)

 Sonification module

 (c) 2010-2022 Highsoft AS
 Author: ystein Moseng

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/sonification",["highcharts"],function(t){a(t);a.Highcharts=t;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function t(a,m,e,l){a.hasOwnProperty(m)||(a[m]=l.apply(null,e),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:m,module:a[m]}})))}a=a?
a._modules:{};t(a,"Extensions/Sonification/Options.js",[],function(){"";return{sonification:{enabled:!0,duration:6E3,afterSeriesWait:700,updateInterval:200,masterVolume:.7,order:"sequential",showTooltip:!0,showCrosshair:!0,pointGrouping:{enabled:!0,groupTimespan:15,algorithm:"minmax",prop:"y"},defaultInstrumentOptions:{roundToMusicalNotes:!0,instrument:"piano",mapping:{time:"x",pan:"x",noteDuration:200,pitch:{mapTo:"y",min:"c2",max:"c6",within:"yAxis"},gapBetweenNotes:100}},defaultSpeechOptions:{language:"en-US",
mapping:{time:"x",rate:1.3,volume:.4},pointGrouping:{algorithm:"last"}}},exporting:{menuItemDefinitions:{downloadMIDI:{textKey:"downloadMIDI",onclick:function(){this.sonification&&this.sonification.downloadMIDI()}},playAsSound:{textKey:"playAsSound",onclick:function(){var a=this.sonification;a&&a.isPlaying()?a.cancel():this.sonify()}}}},lang:{downloadMIDI:"Download MIDI",playAsSound:"Play as sound"}}});t(a,"Extensions/Sonification/SynthPatch.js",[a["Core/Utilities.js"]],function(a){function m(c,b){return(.2414*
c-.2414)*Math.log(b)+(3.5-1.7*c)/1.8}function e(c,b,g){c.gain.cancelScheduledValues(b);c.gain.setTargetAtTime(g,b,n.stopRampTime/4);c.gain.setValueAtTime(g,b+n.stopRampTime)}function l(c,b,g,f,d){void 0===d&&(d=1);b="attack"===b;var I=f.gain;I.cancelScheduledValues(g);c.length?(1<c[0].t&&c.unshift({t:0,vol:b?0:1}),c.forEach(function(b,f){f=c[f-1];I.setTargetAtTime(b.vol*d,g+(f?f.t/1E3+n.stopRampTime:0),Math.max(f?(b.t-f.t)/1E3:0,n.stopRampTime)/2)})):e(f,g,b?d:0)}var A=this&&this.__assign||function(){A=
Object.assign||function(c){for(var b,g=1,f=arguments.length;g<f;g++){b=arguments[g];for(var d in b)Object.prototype.hasOwnProperty.call(b,d)&&(c[d]=b[d])}return c};return A.apply(this,arguments)},y=a.clamp,d=a.defined,B=a.pick,h=function(){function c(b,g){this.pulseWidth=Math.min(Math.max(0,g.pulseWidth||.5));var f=function(){return new OscillatorNode(b,{type:"sawtooth",detune:g.detune,frequency:Math.max(1,g.frequency||350)})};this.sawOscA=f();this.sawOscB=f();this.phaseInverter=new GainNode(b,{gain:-1});
this.masterGain=new GainNode(b);this.delayNode=new DelayNode(b,{delayTime:this.pulseWidth/this.sawOscA.frequency.value});this.sawOscA.connect(this.masterGain);this.sawOscB.connect(this.phaseInverter);this.phaseInverter.connect(this.delayNode);this.delayNode.connect(this.masterGain)}c.prototype.connect=function(b){this.masterGain.connect(b)};c.prototype.getFrequencyFacade=function(){var b=this;return{cancelScheduledValues:function(g){b.sawOscA.frequency.cancelScheduledValues(g);b.sawOscB.frequency.cancelScheduledValues(g);
b.delayNode.delayTime.cancelScheduledValues(g);return b.sawOscA.frequency},setValueAtTime:function(g,f){this.cancelScheduledValues(f);b.sawOscA.frequency.setValueAtTime(g,f);b.sawOscB.frequency.setValueAtTime(g,f);b.delayNode.delayTime.setValueAtTime(Math.round(1E4*b.pulseWidth/g)/1E4,f);return b.sawOscA.frequency},setTargetAtTime:function(g,f,c){this.cancelScheduledValues(f);b.sawOscA.frequency.setTargetAtTime(g,f,c);b.sawOscB.frequency.setTargetAtTime(g,f,c);b.delayNode.delayTime.setTargetAtTime(Math.round(1E4*
b.pulseWidth/g)/1E4,f,c);return b.sawOscA.frequency}}};c.prototype.getPWMTarget=function(){return this.delayNode.delayTime};c.prototype.start=function(){this.sawOscA.start();this.sawOscB.start()};c.prototype.stop=function(b){this.sawOscA.stop(b);this.sawOscB.stop(b)};return c}(),w=function(){function c(b,c,f){this.audioContext=b;this.options=c;this.fmOscillatorIx=c.fmOscillator;this.vmOscillatorIx=c.vmOscillator;this.createSoundSource();this.createGain();this.createFilters();this.createVolTracking();
f&&this.connect(f)}c.prototype.connect=function(b){[this.lowpassNode,this.highpassNode,this.volTrackingNode,this.vmNode,this.gainNode,this.whiteNoise,this.pulseNode,this.oscNode].reduce(function(b,c){return c?(c.connect(b),c):b},b)};c.prototype.start=function(){this.oscNode&&this.oscNode.start();this.whiteNoise&&this.whiteNoise.start();this.pulseNode&&this.pulseNode.start()};c.prototype.stopAtTime=function(b){this.oscNode&&this.oscNode.stop(b);this.whiteNoise&&this.whiteNoise.stop(b);this.pulseNode&&
this.pulseNode.stop(b)};c.prototype.setFreqAtTime=function(b,c,f){void 0===f&&(f=0);var g=this.options;c=y(B(g.fixedFrequency,c)*(g.freqMultiplier||1),0,21E3);g=this.getOscTarget();var d=f/5E3;g&&(g.cancelScheduledValues(b),f&&.01<b-(this.lastUpdateTime||-1)?(g.setTargetAtTime(c,b,d),g.setValueAtTime(c,b+d)):g.setValueAtTime(c,b));this.scheduleVolTrackingChange(c,b,f);this.scheduleFilterTrackingChange(c,b,f);this.lastUpdateTime=b};c.prototype.getFMTarget=function(){return this.oscNode&&this.oscNode.detune||
this.whiteNoise&&this.whiteNoise.detune||this.pulseNode&&this.pulseNode.getPWMTarget()};c.prototype.getVMTarget=function(){return this.vmNode&&this.vmNode.gain};c.prototype.runEnvelopeAtTime=function(b,c){this.gainNode&&l(("attack"===b?this.options.attackEnvelope:this.options.releaseEnvelope)||[],b,c,this.gainNode,this.options.volume)};c.prototype.cancelScheduled=function(){this.gainNode&&this.gainNode.gain.cancelScheduledValues(this.audioContext.currentTime);var b=this.getOscTarget();b&&b.cancelScheduledValues(0);
this.lowpassNode&&this.lowpassNode.frequency.cancelScheduledValues(0);this.highpassNode&&this.highpassNode.frequency.cancelScheduledValues(0);this.volTrackingNode&&this.volTrackingNode.gain.cancelScheduledValues(0)};c.prototype.scheduleVolTrackingChange=function(b,c,f){this.volTrackingNode&&(b=m(this.options.volumePitchTrackingMultiplier||1,b),f=f?f/1E3:n.stopRampTime,this.volTrackingNode.gain.cancelScheduledValues(c),this.volTrackingNode.gain.setTargetAtTime(b,c,f/5),this.volTrackingNode.gain.setValueAtTime(b,
c+f))};c.prototype.scheduleFilterTrackingChange=function(b,c,f){var g=this.options,d=f?f/1E3:n.stopRampTime;f=function(f,g){var n=m(g.frequencyPitchTrackingMultiplier||1,b);g=y((g.frequency||1E3)*n,0,21E3);f.frequency.cancelScheduledValues(c);f.frequency.setTargetAtTime(g,c,d/5);f.frequency.setValueAtTime(g,c+d)};this.lowpassNode&&g.lowpass&&f(this.lowpassNode,g.lowpass);this.highpassNode&&g.highpass&&f(this.highpassNode,g.highpass)};c.prototype.createGain=function(){var b=this.options;if(d(b.volume)||
b.attackEnvelope&&b.attackEnvelope.length||b.releaseEnvelope&&b.releaseEnvelope.length)this.gainNode=new GainNode(this.audioContext,{gain:B(b.volume,1)});this.vmNode=new GainNode(this.audioContext)};c.prototype.createSoundSource=function(){var b=this.options,c=this.audioContext,f=(b.fixedFrequency||0)*(b.freqMultiplier||1);if("whitenoise"===b.type){f=2*c.sampleRate;b=c.createBuffer(1,f,c.sampleRate);for(var d=b.getChannelData(0),n=0;n<f;++n)d[n]=1.2*Math.random()-.6;c=this.whiteNoise=c.createBufferSource();
c.buffer=b;c.loop=!0}else"pulse"===b.type?this.pulseNode=new h(c,{detune:b.detune,pulseWidth:b.pulseWidth,frequency:f}):this.oscNode=new OscillatorNode(c,{type:b.type||"sine",detune:b.detune,frequency:f})};c.prototype.createFilters=function(){var b=this.options;b.lowpass&&b.lowpass.frequency&&(this.lowpassNode=new BiquadFilterNode(this.audioContext,{type:"lowpass",Q:b.lowpass.Q||1,frequency:b.lowpass.frequency}));b.highpass&&b.highpass.frequency&&(this.highpassNode=new BiquadFilterNode(this.audioContext,
{type:"highpass",Q:b.highpass.Q||1,frequency:b.highpass.frequency}))};c.prototype.createVolTracking=function(){var b=this.options;b.volumePitchTrackingMultiplier&&1!==b.volumePitchTrackingMultiplier&&(this.volTrackingNode=new GainNode(this.audioContext,{gain:1}))};c.prototype.getOscTarget=function(){return this.oscNode?this.oscNode.frequency:this.pulseNode&&this.pulseNode.getFrequencyFacade()};return c}(),n=function(){function c(b,c){var f=this;this.audioContext=b;this.options=c;this.eqNodes=[];this.midiInstrument=
c.midiInstrument||1;this.outputNode=new GainNode(b,{gain:0});this.createEqChain(this.outputNode);var g=this.eqNodes.length?this.eqNodes[0]:this.outputNode;this.oscillators=(this.options.oscillators||[]).map(function(c){return new w(b,c,d(c.fmOscillator)||d(c.vmOscillator)?void 0:g)});this.oscillators.forEach(function(b){if(d(b.fmOscillatorIx)){var c=f.oscillators[b.fmOscillatorIx];c&&(c=c.getFMTarget())&&b.connect(c)}d(b.vmOscillatorIx)&&(c=f.oscillators[b.vmOscillatorIx])&&(c=c.getVMTarget())&&b.connect(c)})}
c.prototype.startSilently=function(){this.outputNode.gain.value=0;this.oscillators.forEach(function(b){return b.start()})};c.prototype.stop=function(){var b=this.audioContext.currentTime,d=b+c.stopRampTime;e(this.outputNode,b,0);this.oscillators.forEach(function(b){return b.stopAtTime(d)});this.outputNode.disconnect()};c.prototype.silenceAtTime=function(b){!b&&.01>this.outputNode.gain.value?this.outputNode.gain.value=0:this.releaseAtTime((b||0)+this.audioContext.currentTime)};c.prototype.mute=function(){this.cancelScheduled();
e(this.outputNode,this.audioContext.currentTime,0)};c.prototype.playFreqAtTime=function(b,c,f){var d=(b||0)+this.audioContext.currentTime,g=this.options;this.oscillators.forEach(function(b){b.setFreqAtTime(d,c,g.noteGlideDuration);b.runEnvelopeAtTime("attack",d)});l(g.masterAttackEnvelope||[],"attack",d,this.outputNode,g.masterVolume);f&&this.releaseAtTime(d+f/1E3)};c.prototype.cancelScheduled=function(){this.outputNode.gain.cancelScheduledValues(this.audioContext.currentTime);this.oscillators.forEach(function(b){return b.cancelScheduled()})};
c.prototype.connect=function(b){return this.outputNode.connect(b)};c.prototype.createEqChain=function(b){var c=this;this.eqNodes=(this.options.eq||[]).map(function(b){return new BiquadFilterNode(c.audioContext,A({type:"peaking"},b))});this.eqNodes.reduceRight(function(b,c){c.connect(b);return c},b)};c.prototype.releaseAtTime=function(b){var c=0;this.oscillators.forEach(function(f){var d=f.options.releaseEnvelope;d&&d.length&&(c=Math.max(c,d[d.length-1].t),f.runEnvelopeAtTime("release",b))});var f=
this.options.masterReleaseEnvelope||[];f.length&&(l(f,"release",b,this.outputNode,this.options.masterVolume),c=Math.max(c,f[f.length-1].t));e(this.outputNode,b+c/1E3,0)};c.stopRampTime=.012;return c}();"";return n});t(a,"Extensions/Sonification/InstrumentPresets.js",[],function(){"";return{piano:{masterVolume:.45,masterAttackEnvelope:[{t:1,vol:.71},{t:40,vol:.79},{t:82,vol:.64},{t:147,vol:.29},{t:260,vol:.15},{t:417,vol:.05},{t:589,vol:0}],eq:[{frequency:200,Q:.7,gain:6},{frequency:450,gain:6},{frequency:1300,
gain:2},{frequency:2600,Q:.8,gain:8},{frequency:3500,Q:.8,gain:6},{frequency:6200,Q:.8,gain:10},{frequency:8E3,gain:-23},{frequency:1E4,Q:.4,gain:-12}],oscillators:[{type:"pulse",volume:.5,pulseWidth:.55,volumePitchTrackingMultiplier:.1,lowpass:{frequency:4.5,frequencyPitchTrackingMultiplier:900,Q:-2},highpass:{frequency:270},attackEnvelope:[{t:1,vol:1}],releaseEnvelope:[{t:1,vol:1},{t:282,vol:.64},{t:597,vol:0}]},{type:"whitenoise",volume:.8,lowpass:{frequency:400},highpass:{frequency:300},attackEnvelope:[{t:1,
vol:1},{t:19,vol:0}]}]},plucked:{masterVolume:.5,midiInstrument:25,masterAttackEnvelope:[{t:1,vol:.71},{t:4,vol:.71},{t:31,vol:.4},{t:109,vol:.12},{t:234,vol:.04},{t:442,vol:0}],eq:[{frequency:800,gain:-8},{frequency:1400,Q:4,gain:4},{frequency:1600,gain:-14},{frequency:2200,gain:-8},{frequency:3600,gain:-2},{frequency:6400,Q:2,gain:-6}],oscillators:[{type:"sawtooth",volume:.9,volumePitchTrackingMultiplier:.6,highpass:{frequency:100},lowpass:{frequency:8E3},releaseEnvelope:[{t:1,vol:1},{t:315,vol:.56},
{t:550,vol:0}]}]},flute:{masterVolume:1.1,midiInstrument:74,noteGlideDuration:30,masterAttackEnvelope:[{t:0,vol:0},{t:29,vol:1},{t:76,vol:.48},{t:600,vol:.36}],masterReleaseEnvelope:[{t:1,vol:.36},{t:24,vol:.15},{t:119,vol:0}],eq:[{frequency:150,Q:.6,gain:-10},{frequency:500,gain:4},{frequency:1100,gain:-4},{frequency:2200,gain:-14},{frequency:5E3,gain:8},{frequency:6400,gain:10},{frequency:8E3,gain:12},{frequency:10800,gain:8}],oscillators:[{type:"triangle",volume:1,volumePitchTrackingMultiplier:.4,
lowpass:{frequency:12,frequencyPitchTrackingMultiplier:100},highpass:{frequency:200}},{type:"sine",fixedFrequency:5,volume:.2,vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:48,vol:0},{t:225,vol:.05},{t:600,vol:.77}]},{type:"whitenoise",volume:.13,lowpass:{frequency:9E3,Q:3},highpass:{frequency:6E3,Q:3},vmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:26,vol:1},{t:93,vol:.8}]}]},lead:{masterVolume:1,midiInstrument:20,masterAttackEnvelope:[{t:1,vol:.81},{t:98,vol:.5},{t:201,vol:.18},{t:377,vol:.04},{t:586,
vol:0},{t:586,vol:0}],eq:[{frequency:200,gain:-6},{frequency:400,gain:-8},{frequency:800,Q:.5,gain:-10},{frequency:1200,gain:4},{frequency:3600,gain:-4},{frequency:4200,gain:-12},{frequency:7400,gain:-14},{frequency:1E4,gain:2}],oscillators:[{type:"triangle",volume:1.1,volumePitchTrackingMultiplier:.6,lowpass:{frequency:5E3},highpass:{frequency:100}},{type:"sawtooth",volume:.4,lowpass:{frequency:7E3},highpass:{frequency:800,Q:6},releaseEnvelope:[{t:0,vol:.99},{t:200,vol:.83},{t:495,vol:0}]}]},vibraphone:{masterVolume:1,
midiInstrument:12,masterAttackEnvelope:[{t:1,vol:0},{t:10,vol:.63},{t:82,vol:.64},{t:149,vol:.26},{t:600,vol:0}],eq:[{frequency:200,Q:.8,gain:-12},{frequency:400,gain:-4},{frequency:1600,Q:.5,gain:6},{frequency:2200,Q:.5,gain:6},{frequency:6400,gain:4},{frequency:12800,gain:4}],oscillators:[{type:"sine",volume:1.5,volumePitchTrackingMultiplier:1e-7,attackEnvelope:[{t:1,vol:1}],releaseEnvelope:[{t:1,vol:1},{t:146,vol:.39},{t:597,vol:0}]},{type:"whitenoise",volume:.03,volumePitchTrackingMultiplier:.0001,
lowpass:{frequency:900},highpass:{frequency:800},attackEnvelope:[{t:1,vol:1},{t:9,vol:0}]},{type:"sine",freqMultiplier:4,volume:.15,volumePitchTrackingMultiplier:.0001},{type:"sine",fixedFrequency:3,volume:6,fmOscillator:0,releaseEnvelope:[{t:1,vol:1},{t:190,vol:.41},{t:600,vol:0}]},{type:"sine",fixedFrequency:6,volume:3,fmOscillator:2},{type:"sine",freqMultiplier:9,volume:.0005,volumePitchTrackingMultiplier:.0001,releaseEnvelope:[{t:1,vol:.97},{t:530,vol:0}]}]},saxophone:{masterVolume:1,midiInstrument:67,
noteGlideDuration:10,masterAttackEnvelope:[{t:1,vol:.57},{t:35,vol:1},{t:87,vol:.84},{t:111,vol:.6},{t:296,vol:.49},{t:600,vol:.58}],masterReleaseEnvelope:[{t:1,vol:.58},{t:47,vol:.16},{t:119,vol:0}],eq:[{frequency:200,gain:-2},{frequency:600,gain:2},{frequency:800,gain:-10},{frequency:1100,gain:-2},{frequency:2200,gain:-2},{frequency:3500,gain:10},{frequency:12800,gain:4}],oscillators:[{type:"sawtooth",volume:.45,volumePitchTrackingMultiplier:.06,lowpass:{frequency:18,frequencyPitchTrackingMultiplier:200},
highpass:{frequency:300}},{type:"whitenoise",fixedFrequency:1,volume:.4,highpass:{frequency:7E3},vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:51,vol:1},{t:86,vol:.84},{t:500,vol:.78}]},{type:"sine",fixedFrequency:4,volume:2,fmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:15,vol:.94},{t:79,vol:1},{t:172,vol:.47},{t:500,vol:.26}]},{type:"sine",fixedFrequency:7,volume:6,fmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:25,vol:.99},{t:85,vol:0},{t:85,vol:0},{t:387,vol:.02},{t:511,vol:.43},{t:600,vol:0}]}]},
trumpet:{masterVolume:.3,midiInstrument:57,noteGlideDuration:40,masterAttackEnvelope:[{t:1,vol:0},{t:17,vol:1},{t:42,vol:.85},{t:76,vol:1},{t:202,vol:.65},{t:226,vol:.86},{t:282,vol:.63}],masterReleaseEnvelope:[{t:1,vol:.62},{t:34,vol:.14},{t:63,vol:.21},{t:96,vol:0}],eq:[{frequency:200,Q:.6,gain:10},{frequency:600,Q:.5,gain:6},{frequency:1500,Q:.7,gain:14},{frequency:3200,Q:2,gain:8},{frequency:3800,Q:.8,gain:10},{frequency:6200,gain:12},{frequency:8400,gain:-20},{frequency:12800,Q:.5,gain:-18}],
oscillators:[{type:"sawtooth",volume:.15,pulseWidth:.5,volumePitchTrackingMultiplier:.5,lowpass:{frequency:1900,Q:3}},{type:"sine",fixedFrequency:6,volume:.2,vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:102,vol:.13},{t:556,vol:.24}]},{type:"whitenoise",volume:.45,highpass:{frequency:7E3,Q:9},vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:89,vol:.51},{t:577,vol:.29}]},{type:"sine",fixedFrequency:5.7,volume:20,fmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:89,vol:1},{t:137,vol:.46},{t:283,vol:.15},{t:600,
vol:.28}]}]},sawsynth:{masterVolume:.3,midiInstrument:51,noteGlideDuration:40,masterAttackEnvelope:[{t:0,vol:.6},{t:9,vol:1},{t:102,vol:.48}],eq:[{frequency:200,gain:-6}],oscillators:[{type:"sawtooth",volume:.4,volumePitchTrackingMultiplier:.3},{type:"sawtooth",volume:.4,detune:11,volumePitchTrackingMultiplier:.3},{type:"sawtooth",volume:.4,detune:-11,volumePitchTrackingMultiplier:.3}]},basic1:{masterVolume:1,noteGlideDuration:0,masterReleaseEnvelope:[{t:1,vol:.36},{t:24,vol:.15},{t:119,vol:0}],eq:[{frequency:150,
Q:.6,gain:-12},{frequency:1100,gain:-2},{frequency:2200,gain:-16},{frequency:5E3,gain:8},{frequency:6400,gain:10},{frequency:8E3,gain:12},{frequency:10800,gain:8}],oscillators:[{type:"triangle",volume:1,volumePitchTrackingMultiplier:.05,lowpass:{frequency:17,frequencyPitchTrackingMultiplier:100},highpass:{frequency:200}},{type:"whitenoise",volume:.04,lowpass:{frequency:9E3,Q:3},highpass:{frequency:6E3,Q:3},vmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:26,vol:1},{t:71,vol:.73}]}]},basic2:{masterVolume:.3,
eq:[{frequency:200,Q:.7,gain:6},{frequency:450,gain:2},{frequency:1300,gain:-2},{frequency:2600,Q:.8,gain:6},{frequency:3500,Q:.8,gain:6},{frequency:6200,Q:.8,gain:10},{frequency:8E3,gain:-18},{frequency:1E4,Q:.4,gain:-12}],oscillators:[{type:"pulse",volume:.4,pulseWidth:.55,volumePitchTrackingMultiplier:.1,lowpass:{frequency:4.5,frequencyPitchTrackingMultiplier:900,Q:-2},highpass:{frequency:270}}]},chord:{masterVolume:1,masterAttackEnvelope:[{t:1,vol:.79},{t:27,vol:.86},{t:62,vol:.81},{t:150,vol:.35},
{t:408,vol:.04},{t:600,vol:0}],eq:[{frequency:200,gain:-8},{frequency:600,Q:2,gain:4},{frequency:800,gain:-10},{frequency:1600,gain:-2},{frequency:2200,gain:-6},{frequency:3600,Q:.7,gain:-2},{frequency:6400,gain:6},{frequency:12800,gain:6}],oscillators:[{type:"triangle",volume:1.1,volumePitchTrackingMultiplier:.05,lowpass:{frequency:8E3},highpass:{frequency:100},releaseEnvelope:[{t:1,vol:1},{t:315,vol:.56},{t:540,vol:0}]},{type:"triangle",freqMultiplier:1.17,volume:.4,volumePitchTrackingMultiplier:.07,
lowpass:{frequency:5E3},highpass:{frequency:100},releaseEnvelope:[{t:0,vol:1},{t:476,vol:0}]},{type:"triangle",freqMultiplier:1.58333,volume:.7,volumePitchTrackingMultiplier:.02,highpass:{frequency:200},releaseEnvelope:[{t:0,vol:1},{t:422,vol:.56},{t:577,vol:0}]},{type:"sine",fixedFrequency:10,volume:4,fmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:157,vol:.65}]},{type:"sine",fixedFrequency:5,volume:.3,vmOscillator:2,attackEnvelope:[{t:1,vol:1},{t:155,vol:.91},{t:289,vol:.78}]}]},wobble:{masterVolume:.9,
masterReleaseEnvelope:[{t:1,vol:.36},{t:24,vol:.15},{t:119,vol:0}],eq:[{frequency:150,Q:.6,gain:-12},{frequency:1100,gain:-2},{frequency:2200,gain:-16},{frequency:5E3,gain:8},{frequency:6400,gain:10},{frequency:8E3,gain:12},{frequency:10800,gain:8}],oscillators:[{type:"triangle",volume:.9,volumePitchTrackingMultiplier:.1,lowpass:{frequency:17,frequencyPitchTrackingMultiplier:100},highpass:{frequency:200}},{type:"whitenoise",volume:.04,lowpass:{frequency:9E3,Q:3},highpass:{frequency:6E3,Q:3},vmOscillator:0,
attackEnvelope:[{t:0,vol:0},{t:26,vol:1},{t:71,vol:.73}]},{type:"sine",freqMultiplier:.011,volume:30,fmOscillator:0}]},sine:{masterVolume:1,oscillators:[{type:"sine",volumePitchTrackingMultiplier:.07}]},sineGlide:{masterVolume:1,noteGlideDuration:100,oscillators:[{type:"sine",volumePitchTrackingMultiplier:.07}]},triangle:{masterVolume:.5,oscillators:[{type:"triangle",volume:1,volumePitchTrackingMultiplier:.07}]},sawtooth:{masterVolume:.25,midiInstrument:82,oscillators:[{type:"sawtooth",volume:.3,
volumePitchTrackingMultiplier:.07}]},square:{masterVolume:.3,midiInstrument:81,oscillators:[{type:"square",volume:.2,volumePitchTrackingMultiplier:.07}]},chop:{masterVolume:1,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:44,vol:0}],oscillators:[{type:"whitenoise",volume:1,lowpass:{frequency:600},highpass:{frequency:200}}]},shaker:{masterVolume:.4,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:44,vol:0}],oscillators:[{type:"whitenoise",volume:1,lowpass:{frequency:6500},highpass:{frequency:5E3}}]},
step:{masterVolume:1,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:44,vol:0}],eq:[{frequency:200,gain:-1},{frequency:400,gain:-14},{frequency:800,gain:8},{frequency:1E3,Q:5,gain:-24},{frequency:1600,gain:8},{frequency:2200,gain:-10},{frequency:5400,gain:4},{frequency:12800,gain:-36}],oscillators:[{type:"whitenoise",volume:1.5,lowpass:{frequency:300},highpass:{frequency:100,Q:6}}]},kick:{masterVolume:.55,masterAttackEnvelope:[{t:1,vol:.8},{t:15,vol:1},{t:45,vol:.35},{t:121,vol:.11},{t:242,
vol:0}],eq:[{frequency:50,gain:6},{frequency:400,gain:-18},{frequency:1600,gain:18}],oscillators:[{type:"triangle",fixedFrequency:90,volume:1,lowpass:{frequency:300},attackEnvelope:[{t:1,vol:1},{t:6,vol:1},{t:45,vol:.01}]},{type:"whitenoise",volume:.4,lowpass:{frequency:200},attackEnvelope:[{t:1,vol:1},{t:30,vol:0}]},{type:"triangle",freqMultiplier:.1,volume:1,lowpass:{frequency:200}}]},shortnote:{masterVolume:.8,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:15,vol:0}],eq:[{frequency:400,
gain:-4},{frequency:800,gain:-12},{frequency:2400,gain:4},{frequency:7200,gain:-20},{frequency:1E3,Q:5,gain:-12},{frequency:5400,gain:-32},{frequency:12800,gain:-14}],oscillators:[{type:"sawtooth",volume:.6,lowpass:{frequency:1E3}},{type:"whitenoise",volume:.2,lowpass:{frequency:1E4},highpass:{frequency:7E3},attackEnvelope:[{t:1,vol:1},{t:10,vol:0}]},{type:"whitenoise",volume:1.3,lowpass:{frequency:700,Q:4},highpass:{frequency:250}}]},noise:{masterVolume:.3,midiInstrument:122,oscillators:[{type:"whitenoise"}]},
filteredNoise:{masterVolume:.3,midiInstrument:122,eq:[{frequency:1600,gain:-8},{frequency:2200,gain:-4}],oscillators:[{type:"whitenoise",lowpass:{frequency:5,frequencyPitchTrackingMultiplier:1300,Q:6},highpass:{frequency:5,frequencyPitchTrackingMultiplier:300,Q:6}}]},wind:{masterVolume:.75,midiInstrument:122,noteGlideDuration:150,masterReleaseEnvelope:[{t:0,vol:1},{t:124,vol:.24},{t:281,vol:0}],oscillators:[{type:"whitenoise",volume:1,lowpass:{frequency:100,frequencyPitchTrackingMultiplier:6,Q:23},
highpass:{frequency:170,frequencyPitchTrackingMultiplier:6}},{type:"sine",freqMultiplier:.016,volume:1E3,fmOscillator:0}]}}});t(a,"Extensions/Sonification/SonificationInstrument.js",[a["Extensions/Sonification/SynthPatch.js"],a["Extensions/Sonification/InstrumentPresets.js"],a["Core/Utilities.js"]],function(a,m,e){var l=e.defined,A=e.extend;e=function(){function e(d,e,h){this.audioContext=d;this.curParams={};this.midiTrackName=h.midiTrackName;this.masterVolNode=new GainNode(d);this.masterVolNode.connect(e);
this.volumeNode=new GainNode(d);this.createNodesFromCapabilities(A({pan:!0},h.capabilities||{}));this.connectCapabilityNodes(this.volumeNode,this.masterVolNode);this.synthPatch=new a(d,"string"===typeof h.synthPatch?m[h.synthPatch]:h.synthPatch);this.midiInstrument=this.synthPatch.midiInstrument||1;this.synthPatch.startSilently();this.synthPatch.connect(this.volumeNode)}e.prototype.setMasterVolume=function(d){this.masterVolNode.gain.setTargetAtTime(d,0,e.rampTime)};e.prototype.scheduleEventAtTime=
function(d,a){var h=A(this.curParams,a);a=l(a.frequency)?a.frequency:l(a.note)?e.musicalNoteToFrequency(a.note):220;l(a)&&this.synthPatch.playFreqAtTime(d,a,h.noteDuration);(l(h.tremoloDepth)||l(h.tremoloSpeed))&&this.setTremoloAtTime(d,h.tremoloDepth,h.tremoloSpeed);l(h.pan)&&this.setPanAtTime(d,h.pan);l(h.volume)&&this.setVolumeAtTime(d,h.volume);(l(h.lowpassFreq)||l(h.lowpassResonance))&&this.setFilterAtTime("lowpass",d,h.lowpassFreq,h.lowpassResonance);(l(h.highpassFreq)||l(h.highpassResonance))&&
this.setFilterAtTime("highpass",d,h.highpassFreq,h.highpassResonance)};e.prototype.silenceAtTime=function(d){this.synthPatch.silenceAtTime(d)};e.prototype.cancel=function(){this.synthPatch.mute();[this.tremoloDepth&&this.tremoloDepth.gain,this.tremoloOsc&&this.tremoloOsc.frequency,this.lowpassNode&&this.lowpassNode.frequency,this.lowpassNode&&this.lowpassNode.Q,this.highpassNode&&this.highpassNode.frequency,this.highpassNode&&this.highpassNode.Q,this.panNode&&this.panNode.pan,this.volumeNode.gain].forEach(function(d){return d&&
d.cancelScheduledValues(0)})};e.prototype.destroy=function(){this.cancel();this.synthPatch.stop();this.tremoloOsc&&this.tremoloOsc.stop();[this.tremoloDepth,this.tremoloOsc,this.lowpassNode,this.highpassNode,this.panNode,this.volumeNode,this.masterVolNode].forEach(function(d){return d&&d.disconnect()})};e.prototype.setPanAtTime=function(d,a){this.panNode&&this.panNode.pan.setTargetAtTime(a,d+this.audioContext.currentTime,e.rampTime)};e.prototype.setFilterAtTime=function(d,a,h,w){d=this[d+"Node"];
a=this.audioContext.currentTime+a;d&&(l(w)&&d.Q.setTargetAtTime(w,a,e.rampTime),l(h)&&d.frequency.setTargetAtTime(h,a,e.rampTime))};e.prototype.setVolumeAtTime=function(d,a){this.volumeNode&&this.volumeNode.gain.setTargetAtTime(a,d+this.audioContext.currentTime,e.rampTime)};e.prototype.setTremoloAtTime=function(d,a,h){d=this.audioContext.currentTime+d;this.tremoloDepth&&l(a)&&this.tremoloDepth.gain.setTargetAtTime(a,d,e.rampTime);this.tremoloOsc&&l(h)&&this.tremoloOsc.frequency.setTargetAtTime(15*
h,d,e.rampTime)};e.prototype.createNodesFromCapabilities=function(d){var a=this.audioContext;d.pan&&(this.panNode=new StereoPannerNode(a));d.tremolo&&(this.tremoloOsc=new OscillatorNode(a,{type:"sine",frequency:3}),this.tremoloDepth=new GainNode(a),this.tremoloOsc.connect(this.tremoloDepth),this.tremoloDepth.connect(this.masterVolNode.gain),this.tremoloOsc.start());d.filters&&(this.lowpassNode=new BiquadFilterNode(a,{type:"lowpass",frequency:2E4}),this.highpassNode=new BiquadFilterNode(a,{type:"highpass",
frequency:0}))};e.prototype.connectCapabilityNodes=function(d,a){[this.panNode,this.lowpassNode,this.highpassNode,d].reduce(function(d,a){return a?(a.connect(d),a):d},a)};e.noteStringToC0Distance=function(d){var a=d.match(/^([a-g][#b]?)([0-8])$/i),e=a?a[1]:"a";d=e[0].toLowerCase();e=e[1];a=a?parseInt(a[2],10):4;return({c:0,d:2,e:4,f:5,g:7,a:9,b:11}[d]||0)+("#"===e?1:"b"===e?-1:0)+12*a};e.musicalNoteToFrequency=function(d){d="string"===typeof d?this.noteStringToC0Distance(d):d;return 16.3516*Math.pow(2,
Math.min(d,107)/12)};e.rampTime=a.stopRampTime/4;return e}();"";return e});t(a,"Extensions/Sonification/SonificationSpeaker.js",[a["Core/Utilities.js"]],function(a){var m=a.pick;a=function(){function a(a){this.options=a;this.masterVolume=1;this.synthesis=window.speechSynthesis;"undefined"!==typeof speechSynthesis.onvoiceschanged&&(speechSynthesis.onvoiceschanged=this.setVoice.bind(this));this.setVoice();this.scheduled=[]}a.prototype.say=function(a,e){this.synthesis&&(this.synthesis.cancel(),a=new SpeechSynthesisUtterance(a),
this.voice&&(a.voice=this.voice),a.rate=e&&e.rate||this.options.rate||1,a.pitch=e&&e.pitch||this.options.pitch||1,a.volume=m(e&&e.volume,this.options.volume,1)*this.masterVolume,this.synthesis.speak(a))};a.prototype.sayAtTime=function(a,e,m){this.scheduled.push(setTimeout(this.say.bind(this,e,m),a))};a.prototype.cancel=function(){this.scheduled.forEach(clearTimeout);this.scheduled=[];this.synthesis.cancel()};a.prototype.destroy=function(){this.cancel()};a.prototype.setMasterVolume=function(a){this.masterVolume=
a};a.prototype.setVoice=function(){if(this.synthesis){for(var a=this.options.name,e=this.options.language||"en-US",m=this.synthesis.getVoices(),d=m.length,v=void 0,h=0;h<d;++h){if(a&&m[h].name===a){this.voice=m[h];return}if(!v&&m[h].lang===e&&(v=m[h],!a))break}this.voice=v}};return a}();"";return a});t(a,"Extensions/Sonification/TimelineChannel.js",[],function(){var a=function(){function a(a,l,m,v,d){void 0===m&&(m=!1);this.type=a;this.engine=l;this.showPlayMarker=m;this.muted=d;this.events=v||[]}
a.prototype.addEvent=function(a){var e=this.events[this.events.length-1];if(e&&a.time<e.time){for(e=this.events.length;e--&&this.events[e].time>a.time;);this.events.splice(e+1,0,a)}else this.events.push(a);return a};a.prototype.mute=function(){this.muted=!0};a.prototype.unmute=function(){this.muted=!1};a.prototype.cancel=function(){this.engine.cancel()};a.prototype.destroy=function(){this.engine.destroy()};return a}();"";return a});t(a,"Extensions/Sonification/MIDI.js",[a["Extensions/Sonification/SonificationInstrument.js"],
a["Core/Utilities.js"]],function(a,m){var e=m.pick,l=function(a){return[77,84,104,100,0,0,0,6,0,1<a?1:0,a>>>8&255,a>>>0&255,1,244]},v=[0,255,81,3,7,161,32],y=function(a){for(var d=a&127,c=[];a>>=7;)d<<=8,d|=a&127|128;for(;;)if(c.push(d&255),d&128)d>>=8;else break;return c},d=function(d){var n,c,b=[],g=function(c){for(var a=b.length;a--&&b[a].timeMS>c.timeMS;);b.splice(a+1,0,c)};d.forEach(function(b){var d=b.instrumentEventOptions||{},f=b.time,h=c=e(d.noteDuration,c);b=h&&b.time+h;h=[{valMap:function(b){return 64+
63*b&127},data:{10:d.pan,92:d.tremoloDepth,93:d.tremoloSpeed}},{valMap:function(b){return 127*b/2E4&127},data:{74:d.lowpassFreq,75:d.highpassFreq}},{valMap:function(b){return 63*Math.min(18,Math.max(-18,b))/18+63&127},data:{71:d.lowpassResonance,76:d.highpassResonance}}];var w=n=void 0===d.volume?e(n,127):127*d.volume&127,k=d.frequency;d=d.note||0;d=12+(k?Math.round(12*Math.log(k)/Math.LN2-48.37632):"string"===typeof d?a.noteStringToC0Distance(d):d)&127;h.forEach(function(b){return Object.keys(b.data).forEach(function(c){var a=
b.data[c];void 0!==a&&g({timeMS:f,type:"CTRL_CHG",data:[176,parseInt(c,10),b.valMap(a)]})})});b&&(g({timeMS:f,type:"NON",data:[144,d,w]}),g({timeMS:b,type:"NOF",data:[128,d,w]}))});return b},B=function(a,d){var c=[];d&&c.push(0,192,d&127);if(a){d=[];for(var b=0;b<a.length;++b){var g=a.charCodeAt(b);128>g&&d.push(g)}return c.concat([0,255,3],y(d.length),d)}return c},h=function(a,n,c,b){var g=0;c=B(c,b);a=d(a).reduce(function(b,c){var a=y(c.timeMS-g);g=c.timeMS;return b.concat(a,c.data)},[]);b=[0,255,
47,0];var f=(n?v.length:0)+c.length+a.length+b.length;return[77,84,114,107,f>>>24&255,f>>>16&255,f>>>8&255,f>>>0&255].concat(n?v:[],c,a,b)};return function(a){a=a.filter(function(b){return!!b.events.length});var d=a.length,c=1<d;return new Uint8Array(l(c?d+1:d).concat(c?h([],!0):[],a.reduce(function(b,a){var d=a.engine;return b.concat(h(a.events,!c,d.midiTrackName,d.midiInstrument))},[])))}});t(a,"Extensions/DownloadURL.js",[a["Core/Globals.js"]],function(a){var m=a.isSafari,e=a.win,l=e.document,
v=e.URL||e.webkitURL||e,y=a.dataURLtoBlob=function(a){if((a=a.replace(/filename=.*;/,"").match(/data:([^;]*)(;base64)?,([0-9A-Za-z+/]+)/))&&3<a.length&&e.atob&&e.ArrayBuffer&&e.Uint8Array&&e.Blob&&v.createObjectURL){var d=e.atob(a[3]),h=new e.ArrayBuffer(d.length);h=new e.Uint8Array(h);for(var w=0;w<h.length;++w)h[w]=d.charCodeAt(w);a=new e.Blob([h],{type:a[1]});return v.createObjectURL(a)}};a=a.downloadURL=function(a,v){var d=e.navigator,w=l.createElement("a");if("string"===typeof a||a instanceof
String||!d.msSaveOrOpenBlob){a="".concat(a);d=/Edge\/\d+/.test(d.userAgent);if(m&&"string"===typeof a&&0===a.indexOf("data:application/pdf")||d||2E6<a.length)if(a=y(a)||"",!a)throw Error("Failed to convert to blob");if("undefined"!==typeof w.download)w.href=a,w.download=v,l.body.appendChild(w),w.click(),l.body.removeChild(w);else try{var n=e.open(a,"chart");if("undefined"===typeof n||null===n)throw Error("Failed to open window");}catch(c){e.location.href=a}}else d.msSaveOrOpenBlob(a,v)};return{dataURLtoBlob:y,
downloadURL:a}});t(a,"Extensions/Sonification/SonificationTimeline.js",[a["Extensions/Sonification/TimelineChannel.js"],a["Extensions/Sonification/MIDI.js"],a["Extensions/DownloadURL.js"],a["Core/Utilities.js"]],function(a,m,e,l){function v(d,e){e=e.map(function(b){b.cancel();return{channel:b,filteredEvents:b.muted?[]:b.events.filter(d)}});var c=e.reduce(function(b,a){return Math.min(b,a.filteredEvents.length?a.filteredEvents[0].time:Infinity)},Infinity);return e.map(function(b){return new a(b.channel.type,
b.channel.engine,b.channel.showPlayMarker,b.filteredEvents.map(function(a){return h(a,{time:a.time-c})}),b.channel.muted)})}var y=e.downloadURL,d=l.defined,t=l.find,h=l.merge;e=function(){function e(a,c){this.chart=c;this.isPlaying=this.isPaused=!1;this.channels=[];this.scheduledCallbacks=[];this.resumeFromTime=this.playTimestamp=0;this.options=a||{}}e.prototype.addChannel=function(d,c,b,e){void 0===b&&(b=!1);if("instrument"===d&&!c.scheduleEventAtTime||"speech"===d&&!c.sayAtTime)throw Error("Highcharts Sonification: Invalid channel engine.");
d=new a(d,c,b,e);this.channels.push(d);return d};e.prototype.play=function(a,c,b,d){var e=this;void 0===c&&(c=!0);void 0===b&&(b=!0);this.isPlaying?this.cancel():this.clearScheduledCallbacks();this.playTimestamp=Date.now();this.resumeFromTime=0;this.isPaused=!1;this.isPlaying=!0;var g=this.options.skipThreshold||2,n=this.options.onPlay,h=this.options.showTooltip,K=this.options.showCrosshair;a=a?v(a,this.playingChannels||this.channels):this.channels;var k=function(a){return Object.keys(a.speechOptions||
{}).concat(Object.keys(a.instrumentEventOptions||{})).join()},q=[];c&&(this.playingChannels=a);n&&n({chart:this.chart,timeline:this});var l=0;a.forEach(function(a){if(!a.muted){var b=a.events.length,c=-Infinity,d=-Infinity,f="";l=Math.max(a.events[b-1]&&a.events[b-1].time||0,l);for(var p=function(u){var p=a.events[u],x=k(p);if(x===f&&p.time-d<g)return"continue";f=x;d=p.time;"instrument"===a.type?a.engine.scheduleEventAtTime(p.time/1E3,p.instrumentEventOptions||{}):a.engine.sayAtTime(p.time,p.message||
"",p.speechOptions||{});var r=p.relatedPoint,n=r&&r.series&&r.series.chart;u=p.callback||r&&(h||K)&&!1!==a.showPlayMarker&&(50<p.time-c||u===b-1);r&&q.push(r);u&&(e.scheduledCallbacks.push(setTimeout(function(){p.callback&&p.callback();if(r){if(K){var a=r.series;a&&a.xAxis&&a.xAxis.crosshair&&a.xAxis.drawCrosshair(void 0,r);a&&a.yAxis&&a.yAxis.crosshair&&a.yAxis.drawCrosshair(void 0,r)}if(h&&!(n&&n.hoverPoints&&1<n.hoverPoints.length&&t(n.hoverPoints,function(a){return a===r})&&r.onMouseOver))r.onMouseOver()}},
p.time)),c=p.time)},r=0;r<b;++r)p(r)}});var m=this.options.onEnd,z=this.options.onStop;this.scheduledCallbacks.push(setTimeout(function(){var a=e.chart,c={chart:a,timeline:e,pointsPlayed:q};e.isPlaying=!1;b&&e.resetPlayState();z&&z(c);m&&m(c);d&&d(c);if(a){a.tooltip&&a.tooltip.hide(0);if(a.hoverSeries)a.hoverSeries.onMouseOut();a.axes.forEach(function(a){return a.hideCrosshair()})}},l+250));this.resumeFromTime=c?l:this.getLength()};e.prototype.pause=function(){this.isPaused=!0;this.cancel();return this.resumeFromTime=
Date.now()-this.playTimestamp-10};e.prototype.getCurrentTime=function(){return this.isPlaying?Date.now()-this.playTimestamp:this.resumeFromTime};e.prototype.getLength=function(){return this.channels.reduce(function(a,c){return(c=c.events[c.events.length-1])?Math.max(c.time,a):a},0)};e.prototype.resume=function(){if(this.playingChannels){var a=this.resumeFromTime-50;this.play(function(c){return c.time>a},!1,!1);this.playTimestamp-=a}else this.play(void 0,!1,!1)};e.prototype.anchorPlayMoment=function(a,
c){this.isPlaying&&this.pause();var b=0;this.play(function(c,d,e){(d=a(c,d,e))&&c.time>b&&(b=c.time);return d},!1,!1,c);this.playingChannels=this.playingChannels||this.channels;this.isPaused=!0;this.isPlaying=!1;this.resumeFromTime=b};e.prototype.playAdjacent=function(a,c,b,d){this.isPlaying&&this.pause();var e=this.resumeFromTime,g=this.channels.reduce(function(b,c){c=d?c.events.filter(d):c.events;for(var f=0,g=c.length;f<g;){var h=f+g>>1,n=c[h].time,l=n-e;0<l?(a&&n<b&&(b=n),g=h):0>l?(!a&&n>b&&(b=
n),f=h+1):a?f=h+1:g=h}return b},a?Infinity:-Infinity);Infinity===g||-Infinity===g?b&&b({chart:this.chart,timeline:this,attemptedNext:a}):this.anchorPlayMoment(function(b,c,f){var k=a?b.time>e&&b.time<=g+.02:b.time<e&&b.time>=g-.02;return d?k&&d(b,c,f):k},c)};e.prototype.playClosestToPropValue=function(a,c,b,e,f){var g=Infinity,h=null;(this.playingChannels||this.channels).forEach(function(b){b=b.events;for(var e=b.length;e--;){var k=b[e];if(f?f(k,e,b)&&k.relatedPoint:k.relatedPoint)k=b[e].relatedPoint[a],
k=d(k)&&Math.abs(c-k),!1!==k&&k<g&&(g=k,h=b[e])}});h?(this.play(function(a){return!!(h&&a.time<h.time+1&&a.time>h.time-1&&a.relatedPoint===h.relatedPoint)},!1,!1,b),this.playingChannels=this.playingChannels||this.channels,this.isPaused=!0,this.isPlaying=!1,this.resumeFromTime=h.time):e&&e({chart:this.chart,timeline:this})};e.prototype.getEventsForPoint=function(a){return this.channels.reduce(function(c,b){b=b.events.filter(function(b){return b.relatedPoint===a});return c.concat(b)},[])};e.prototype.playSegment=
function(a,c){var b=Infinity,d=-Infinity;this.channels.forEach(function(a){a.events.length&&(b=Math.min(a.events[0].time,b),d=Math.max(a.events[a.events.length-1].time,d))});if(Infinity>b){var e=(d-b)/100,h=b+a*e,n=h+e;this.channels.some(function(a){a=a.events;for(var b=0,c=a.length;b<c;){var d=b+c>>1,e=a[d].time;if(e<h)b=d+1;else if(e>n)c=d;else return!0}return!1})&&(this.play(function(a){return a.time>=h&&a.time<=n},!1,!1,c),this.playingChannels=this.playingChannels||this.channels,this.isPaused=
!0,this.isPlaying=!1,this.resumeFromTime=n)}};e.prototype.getLastPlayedPoint=function(a){var c=this.getCurrentTime(),b=Infinity,d=null;(this.playingChannels||this.channels).forEach(function(e){e=e.events.filter(function(b,d,e){return!(!(b.relatedPoint&&b.time<=c)||a&&!a(b,d,e))});if(e=e[e.length-1]){var f=Math.abs(e.time-c);f<b&&(b=f,d=e.relatedPoint)}});return d};e.prototype.reset=function(){this.isPlaying&&this.cancel();this.resetPlayState()};e.prototype.cancel=function(){var a=this.options.onStop;
a&&a({chart:this.chart,timeline:this});this.isPlaying=!1;this.channels.forEach(function(a){return a.cancel()});this.playingChannels&&this.playingChannels!==this.channels&&this.playingChannels.forEach(function(a){return a.cancel()});this.clearScheduledCallbacks();this.resumeFromTime=0};e.prototype.destroy=function(){this.cancel();this.playingChannels&&this.playingChannels!==this.channels&&this.playingChannels.forEach(function(a){return a.destroy()});this.channels.forEach(function(a){return a.destroy()})};
e.prototype.setMasterVolume=function(a){this.channels.forEach(function(c){return c.engine.setMasterVolume(a)})};e.prototype.getMIDIData=function(){return m(this.channels.filter(function(a){return"instrument"===a.type}))};e.prototype.downloadMIDI=function(a){var c=this.getMIDIData();a=(a||this.chart&&this.chart.options.title&&this.chart.options.title.text||"chart")+".mid";c=new Blob([c],{type:"application/octet-stream"});c=window.URL.createObjectURL(c);y(c,a);window.URL.revokeObjectURL(c)};e.prototype.resetPlayState=
function(){delete this.playingChannels;this.playTimestamp=this.resumeFromTime=0;this.isPaused=!1};e.prototype.clearScheduledCallbacks=function(){this.scheduledCallbacks.forEach(clearTimeout);this.scheduledCallbacks=[]};return e}();"";return e});t(a,"Extensions/Sonification/TimelineFromChart.js",[a["Extensions/Sonification/SonificationTimeline.js"],a["Extensions/Sonification/SonificationInstrument.js"],a["Extensions/Sonification/SonificationSpeaker.js"],a["Core/Utilities.js"],a["Core/FormatUtilities.js"]],
function(a,m,e,l,t){function v(a,b){if(b){var c=a[b];if("number"===typeof c)return c;c=z(b,a)}return"number"===typeof c?c:void 0}function d(a,b,c){a=a.series;for(var d=b.length,e=c.length,p=function(a){return a.reduce(function(a,b){a[b]={min:Infinity,max:-Infinity};a;return a},{})},f=function(a,b,c){var d=b[c];void 0===d&&(d=z(c,b));"number"===typeof d&&(a[c].min=Math.min(a[c].min,d),a[c].max=Math.max(a[c].max,d))},u=p(b),g=a.length,h=Array(g);g--;){var k=p(c),x=a[g].options;if(!(!a[g].visible||x&&
x.sonification&&!1===x.sonification.enabled)){x=a[g].points||[];for(var F=x.length;F--;){for(var G=d;G--;)f(u,x[F],b[G]);for(G=e;G--;)f(k,x[F],c[G])}h[g]=k}}return{globalExtremes:u,seriesExtremes:h}}function A(a){var b=a.options.sonification||{},c=b.defaultSpeechOptions&&b.defaultSpeechOptions.mapping||{},e=[],f={},u=function(a,b){null!==b?(e[b]=e[b]||{},e[b][a]=!0):f[a]=!0},g={},h={},l=function(a,b,c){var d=function(a){return"-"===a.charAt(0)?a.slice(1):a};if("string"===typeof b&&"text"!==a)"pitch"===
a&&/^([a-g][#b]?)[0-8]$/i.test(b)||("time"===a&&(h[b]=!0,u(b,c)),g[d(b)]=!0);else if(b&&b.mapTo&&"string"===typeof b.mapTo){d=d(b.mapTo);"time"===a&&u(d,c);if("time"===a||"series"===b.within)h[d]=!0;g[d]=!0}else-1<["tremolo","lowpass","highpass"].indexOf(a)&&"object"===typeof b&&Object.keys(b).forEach(function(a){return l(a,b[a],c)})},q=function(a,b){Object.keys(a).forEach(function(c){return l(c,a[c],b)})},n=function(a){return a.forEach(function(a){g[a.valueProp||"x"]=h[a.valueProp||"x"]=!0})};q((b.defaultInstrumentOptions||
{}).mapping||{time:"x",pitch:"y"},null);q(c,null);n(b.globalContextTracks||[]);var m=Object.keys(f).length;a.series.forEach(function(a){var b=a.options.sonification;if(a.visible&&(!b||!1!==b.enabled)&&(m&&(e[a.index]=C(f)),b)){var c=(b.defaultInstrumentOptions||{}).mapping,d=(b.defaultSpeechOptions||{}).mapping;c&&q(c,a.index);d&&q(d,a.index);n(b.contextTracks||[]);(b.tracks||[]).concat(b.contextTracks||[]).forEach(function(b){b.mapping&&q(b.mapping,a.index)})}});return k({seriesTimeProps:e},d(a,
Object.keys(g),Object.keys(h)))}function h(a,b,c,d,e){var f=b.max-b.min;if(0>=f)return c.min;var p=c.max-c.min;f=p*(a-b.min)/f;e&&(e=0<b.min?function(a){return Math.log(a)/Math.LOG10E}:function(a){var b=Math.abs(a);10>b&&(b+=(10-b)/10);b=Math.log(b)/Math.LN10;return 0>a?-b:b},f=e(b.min),f=p*(e(a)-f)/(e(b.max)-f));return q(d?c.max-f:c.min+f,c.min,c.max)}function w(a,b,c,d,e,f){if("number"===typeof e)return e;if("function"===typeof e)return e(L({time:0},a));var p=e,g=d.mapFunction,k=d.min,u=d.max,r=
d.within;if("object"===typeof e){p=e.mapTo;g=e.mapFunction||g;k=E(e.min,k);u=E(e.max,u);r=e.within||d.within;var x=e.scale}if(!p)return null;(d="-"===p.charAt(0))&&(p=p.slice(1));var q=a.value,l="value"===p&&void 0!==q&&f;if(!l){q=e.value;if(void 0===q){if(!a.point)return null;q=a.point[p]}void 0===q&&(q=z(p,a.point))}if("number"!==typeof q||null===q)return null;e=null;a.point&&("xAxis"===r||"yAxis"===r?(a=a.point.series[r])&&D(a.dataMin)&&D(a.dataMax)&&(e={min:a.dataMin,max:a.dataMax}):("series"===
r||c)&&a.point.series&&(e=b.seriesExtremes[a.point.series.index][l?f:p]));e||(e=b.globalExtremes[l?f:p]);if(x){b=[];f=Math.ceil(u/12)+1;p=x.length;for(a=Math.floor(k/12);a<f;++a)for(c=0;c<p;++c)r=12*a+x[c],r>=k&&r<=u&&b.push(r);g=h(q,e,{min:0,max:b.length-1},d,"logarithmic"===g);return b[Math.round(g)]}return h(q,e,{min:k,max:u},d,"logarithmic"===g)}function n(a,b,c,d,e,f,g){return E(w(a,b,c,L({min:0,max:1,mapTo:"y",mapFunction:"linear",within:"chart"},f||{}),d,g),e)}function c(a,b,c,d){var e;b-=
(a.chart.series.length-1)*d;c.seriesTimeProps.every(function(a){a=Object.keys(a);if(1<a.length)return!1;e||(e=a[0]);return e===a[0]})?(a=c.seriesExtremes[a.index][e],a=a.max-a.min,c=c.seriesExtremes.reduce(function(a,b){return b[e]?a+b[e].max-b[e].min:a},0),c=Math.round(a/c*b)):(c=a.chart.series.reduce(function(a,b){return a+b.points.length},0),c=Math.round((a.points||[]).length/c*b));return Math.max(50,c)}function b(a,b,c,d){var f=d.mapping||{};b="speech"===d.type?new e({language:d.language,name:d.preferredVoice}):
new m(b,c,{capabilities:{pan:!!f.pan,tremolo:!!f.tremolo,filters:!(!f.highpass&&!f.lowpass)},synthPatch:d.instrument,midiTrackName:d.midiName});return a.addChannel(d.type||"instrument",b,E(d.showPlayMarker,!0))}function g(a,b,c,d,e,f){var g=function(b,e,g,k){return n(a,d,!1,(k||c)[b],e,g,f)},h=[],k={noteDuration:g("noteDuration",200,{min:40,max:1E3}),pan:g("pan",0,{min:-1,max:1}),volume:g("volume",1,{min:.1,max:1})};c.frequency&&(k.frequency=g("frequency",440,{min:50,max:6E3}));c.lowpass&&(k.lowpassFreq=
g("frequency",2E4,{min:0,max:2E4},c.lowpass),k.lowpassResonance=g("resonance",0,{min:-6,max:12},c.lowpass));c.highpass&&(k.highpassFreq=g("frequency",2E4,{min:0,max:2E4},c.highpass),k.highpassResonance=g("resonance",0,{min:-6,max:12},c.highpass));c.tremolo&&(k.tremoloDepth=g("depth",0,{min:0,max:.8},c.tremolo),k.tremoloSpeed=g("speed",0,{min:0,max:.8},c.tremolo));var p=g("gapBetweenNotes",150,{min:50,max:1E3}),q=g("playDelay",0,{max:200});g=function(c,g){void 0===g&&(g=0);var u=c;c.mapTo?("string"===
typeof c.min&&(u.min=m.noteStringToC0Distance(c.min)),"string"===typeof c.max&&(u.max=m.noteStringToC0Distance(c.max))):"string"===typeof c&&/^([a-g][#b]?)[0-8]$/i.test(c)&&(u=m.noteStringToC0Distance(c));k.note=n(a,d,!1,u,-1,{min:0,max:107},f);-1<k.note&&(e&&(k.note=Math.round(k.note)),h.push(b.addEvent({time:a.time+q+p*g,relatedPoint:a.point,instrumentEventOptions:void 0!==g?L({},k):k})))};c.pitch&&c.pitch.constructor===Array?c.pitch.forEach(g):c.pitch?g(c.pitch):c.frequency&&h.push(b.addEvent({time:a.time+
q,relatedPoint:a.point,instrumentEventOptions:k}));return h}function f(a,b){return O("function"===typeof b?b(a):b,a,a.point&&a.point.series.chart)}function I(a,b,c,d,e){var g=function(b,f,g){return n(a,d,!1,c[b],f,g,e)},k=g("playDelay",0,{max:200}),h=g("pitch",1,{min:.3,max:2}),p=g("rate",1,{min:.4,max:4});g=g("volume",1,{min:.1});var q=f(a,c.text);if(q)return b.addEvent({time:a.time+k,relatedPoint:a.point,speechOptions:{pitch:h,rate:p,volume:g},message:q})}function N(a,b,c,d){var e=[];"speech"===
c.type&&c.mapping?(a=I(a,b,c.mapping,d))&&(e=[a]):c.mapping&&(e=g(a,b,c.mapping,d,E(c.roundToMusicalNotes,!0)));return e}function J(a,b){var c=a.algorithm||"minmax",d=function(a){return b[a]?[b[a].point]:[]};if("first"===c)return d(0);if("last"===c)return d(b.length-1);if("middle"===c)return d(b.length>>1);if("firstlast"===c)return d(0).concat(d(b.length-1));if("minmax"===c){var e=a.prop||"y",f,g,k,h;b.forEach(function(a){var b=v(a.point,e);if(void 0!==b){if(!f||b<k)f=a,k=b;if(!g||b>h)g=a,h=b}});
if(f&&g)return f.point===g.point?[f.point]:f.time>g.time?[g.point,f.point]:[f.point,g.point]}return[]}function K(a,b,c){if("function"===typeof b)return b(a);if("object"===typeof b){var d=b.prop;a=E(a.value,a.point&&v(a.point,d));if("number"!==typeof a)return!1;d=b.crossingUp;var e=b.crossingDown,f="number"===typeof c;c=d&&e?f&&(c<d&&a>=d||c>e&&a<=e):(void 0===d||f&&c<d&&a>=d)&&(void 0===e||f&&c>e&&a<=e);d=E(b.max,Infinity);b=E(b.min,-Infinity);return a<=d&&a>=b&&c}return!0}var k=this&&this.__assign||
function(){k=Object.assign||function(a){for(var b,c=1,d=arguments.length;c<d;c++){b=arguments[c];for(var e in b)Object.prototype.hasOwnProperty.call(b,e)&&(a[e]=b[e])}return a};return k.apply(this,arguments)},q=l.clamp,D=l.defined,L=l.extend,z=l.getNestedProperty,C=l.merge,E=l.pick,O=t.format;return function(d,e,f){var k=f.options.sonification||{},q=k.defaultInstrumentOptions,l=k.defaultSpeechOptions,m=C({enabled:!0,groupTimespan:15,algorithm:"minmax",prop:"y"},k.pointGrouping),p=k.globalTracks||
[],u=k.globalContextTracks||[],D="sequential"===k.order,z=Math.max(50,k.duration-300),w=k.afterSeriesWait,t=k.events||{},x=A(f),y=new a({onPlay:t.onPlay,onEnd:t.onEnd,onStop:t.onStop,showCrosshair:k.showCrosshair,showTooltip:k.showTooltip},f);f.sonification&&(f.sonification.propMetrics=x);var B=0;f.series.forEach(function(a,f){var k=a.options.sonification||{};if(a.visible&&!1!==k.enabled){var r=D?c(a,z,x,w):z,A=C(q,k.defaultInstrumentOptions),O=C(l,k.defaultSpeechOptions),G=C(m,k.pointGrouping),F=
(k.tracks||[A]).concat(p);k=y.channels.length&&!D?k.contextTracks||[]:(k.contextTracks||[]).concat(u);var M=[],H;F.forEach(function(c){var f=C({pointGrouping:G,midiName:c.midiName||a.name},"speech"===c.type?O:A,c),g=f.pointGrouping,k=f.activeWhen,h=function(a){"object"===typeof k&&k.prop&&(H=v(a,k.prop))},q=b(y,d,e,f),l=function(a){return M.push.apply(M,N(a,q,f,x))},m=[],p=0,u=function(a){if(1===m.length)l({point:m[0].point,time:p+a/2});else{var b=J(g,m),c=a/b.length;b.forEach(function(a,b){return l({point:a,
time:p+c/2+c*b})})}m=[]};(a.points||[]).forEach(function(b,c){c=c===a.points.length-1;var d=B;d=n({point:b,time:0},x,D,f.mapping&&f.mapping.time||0,0,{min:0,max:r,mapTo:"x"})+d;var e={point:b,time:d};if(f.mapping&&K(e,k,H))if(h(b),g.enabled){b=d-p;var q=g.groupTimespan,C=c&&b<=q?b:q;c||b>q?(b<=q&&m.push(e),u(C),p=Math.floor(d/q)*q,c&&b>q?l({point:e.point,time:p+C/2}):m=[e]):m.push(e)}else l(e);else h(b),c&&m.length&&u(m[m.length-1].time-m[0].time)})});F=M.reduce(function(a,b){return b.time<a.time?
b:a},{time:Infinity});var P=M.reduce(function(a,b){return b.time>a.time?b:a},{time:-Infinity});F.callback=t.onSeriesStart?t.onSeriesStart.bind(null,{series:a,timeline:y}):void 0;P.callback=t.onSeriesEnd?t.onSeriesEnd.bind(null,{series:a,timeline:y}):void 0;k.forEach(function(a){var c="speech"===a.type?C(l,a):C(q,{mapping:{pitch:{mapTo:"value"}}},a),k=b(y,d,e,c);H=void 0;a=c.timeInterval;var m=c.valueInterval,p=c.valueProp||"x",n=c.activeWhen,u=x.seriesExtremes[f][p],D=function(a,b){c.mapping&&K({time:a,
value:b},"object"===typeof n?L({prop:p},n):n,H)?(H=b,"speech"===c.type?I({time:a,value:b},k,c.mapping,x,p):g({time:a,value:b},k,c.mapping,x,E(c.roundToMusicalNotes,!0),p)):H=b};if(a)for(var v=0;v<=r;){var z=h(v,{min:0,max:r},u);D(v+B,z);v+=a}if(m)for(z=u.min;z<=u.max;)v=h(z,u,{min:0,max:r},!1,"logarithmic"===c.valueMapFunction),D(v+B,z),z+=m});D&&(B+=r+w)}});return y}});t(a,"Extensions/Sonification/Sonification.js",[a["Core/Defaults.js"],a["Core/Utilities.js"],a["Core/Globals.js"],a["Extensions/Sonification/Options.js"],
a["Extensions/Sonification/SonificationInstrument.js"],a["Extensions/Sonification/SonificationSpeaker.js"],a["Extensions/Sonification/SynthPatch.js"],a["Extensions/Sonification/InstrumentPresets.js"],a["Extensions/Sonification/TimelineFromChart.js"]],function(a,m,e,l,t,y,d,B,h){var v=a.defaultOptions,n=a.getOptions,c=m.addEvent,b=m.extend,g=m.fireEvent,f=m.merge,A=m.pick,N=e.doc,J=e.win;a=function(){function a(a){this.chart=a;this.lastUpdate=this.retryContextCounter=0;this.unbindKeydown=c(N,"keydown",
function(b){a&&a.sonification&&("Esc"===b.key||"Escape"===b.key)&&a.sonification.cancel()});try{this.audioContext=new J.AudioContext,this.audioContext.suspend(),this.audioDestination=this.audioContext.destination}catch(q){}}a.prototype.setAudioDestination=function(a){this.audioDestination=a;this.update()};a.prototype.isPlaying=function(){return!!this.timeline&&this.timeline.isPlaying};a.prototype.playSegment=function(a,b){this.ready(this.playSegment.bind(this,a,b))&&this.timeline&&this.timeline.playSegment(a,
b)};a.prototype.playAdjacent=function(a,b,c){var d=this;if(this.ready(this.playAdjacent.bind(this,a,b,c))&&this.timeline){var e=this.chart.options.sonification;(e=e&&e.events&&e.events.onBoundaryHit)||this.initBoundaryInstrument();this.timeline.playAdjacent(a,b,e||function(){d.defaultBoundaryHit()},c)}};a.prototype.playAdjacentSeries=function(a,b,c){void 0===b&&(b="x");var d=this.getLastPlayedPoint();if(d){var e=d.series.index+(a?1:-1);this.playClosestToProp(b,d[b],function(a){return!!a.relatedPoint&&
a.relatedPoint.series.index===e},c);return this.chart.series[e]||null}return null};a.prototype.playClosestToProp=function(a,b,c,d){var e=this;if(this.ready(this.playClosestToProp.bind(this,a,b,c,d))&&this.timeline){var f=this.chart.options.sonification;(f=f&&f.events&&f.events.onBoundaryHit)||this.initBoundaryInstrument();this.timeline.playClosestToPropValue(a,b,d,f||function(){return e.defaultBoundaryHit()},c)}};a.prototype.getLastPlayedPoint=function(){return this.timeline?this.timeline.getLastPlayedPoint():
null};a.prototype.playNote=function(a,b,c){void 0===c&&(c=0);if(this.ready(this.playNote.bind(this,a,b))){var d=b.noteDuration=b.noteDuration||500,e=new t(this.audioContext,this.audioDestination,{synthPatch:a,capabilities:{filters:!0,tremolo:!0,pan:!0}});e.scheduleEventAtTime(c/1E3,b);setTimeout(function(){return e&&e.destroy()},c+d+500)}};a.prototype.speak=function(a,b,c){void 0===c&&(c=0);(new y(f({language:"en-US",rate:1.5,volume:.4},b||{}))).sayAtTime(c,a)};a.prototype.cancel=function(){this.timeline&&
this.timeline.cancel();g(this,"cancel")};a.prototype.downloadMIDI=function(){this.ready(this.downloadMIDI.bind(this))&&this.timeline&&(this.timeline.reset(),this.timeline.downloadMIDI())};a.prototype.sonifyChart=function(a,b){this.ready(this.sonifyChart.bind(this,a,b))&&this.timeline&&(this.timeline.reset(),this.beforePlay(),this.timeline.play(void 0,void 0,a,b))};a.prototype.sonifySeries=function(a,b,c){this.ready(this.sonifySeries.bind(this,a,b,c))&&this.timeline&&(this.timeline.reset(),this.beforePlay(),
this.timeline.play(function(b){return!!b.relatedPoint&&b.relatedPoint.series===a},void 0,b,c))};a.prototype.sonifyPoint=function(a,b){this.ready(this.sonifyPoint.bind(this,a,b))&&this.timeline&&(this.timeline.reset(),this.beforePlay(),this.timeline.anchorPlayMoment(function(b){return b.relatedPoint===a},b))};a.prototype.setMasterVolume=function(a){this.timeline&&this.timeline.setMasterVolume(a)};a.prototype.destroy=function(){this.unbindKeydown();this.timeline&&(this.timeline.destroy(),delete this.timeline);
this.boundaryInstrument&&this.boundaryInstrument.stop();this.audioContext&&(this.audioContext.close(),delete this.audioContext)};a.prototype.update=function(){var a=this.chart.options&&this.chart.options.sonification;if(this.ready(this.update.bind(this))&&a){var b=Date.now(),c=a.updateInterval;b-this.lastUpdate<c&&!this.forceReady?(clearTimeout(this.scheduledUpdate),this.scheduledUpdate=setTimeout(this.update.bind(this),c/2)):(a=a.events||{},a.beforeUpdate&&a.beforeUpdate({chart:this.chart,timeline:this.timeline}),
this.lastUpdate=b,this.timeline&&this.timeline.destroy(),this.audioContext&&this.audioDestination&&(this.timeline=h(this.audioContext,this.audioDestination,this.chart),b=this.chart.options.sonification,this.timeline.setMasterVolume(A(b&&b.masterVolume,1))),a.afterUpdate&&a.afterUpdate({chart:this.chart,timeline:this.timeline}))}};a.prototype.ready=function(a){var b=this;if(!this.audioContext||!this.audioDestination||!this.chart.options||this.chart.options.sonification&&!1===this.chart.options.sonification.enabled)return!1;
if("suspended"===this.audioContext.state&&!this.forceReady)return 20>this.retryContextCounter++&&setTimeout(function(){b.audioContext&&"suspended"===b.audioContext.state?b.audioContext.resume().then(a):a()},5),!1;this.retryContextCounter=0;return!0};a.prototype.beforePlay=function(){var a=this.chart.options.sonification;(a=a&&a.events&&a.events.beforePlay)&&a({chart:this.chart,timeline:this.timeline})};a.prototype.initBoundaryInstrument=function(){this.boundaryInstrument||(this.boundaryInstrument=
new d(this.audioContext,f(B.chop,{masterVolume:.3})),this.boundaryInstrument.startSilently(),this.boundaryInstrument.connect(this.audioDestination))};a.prototype.defaultBoundaryHit=function(){this.boundaryInstrument&&(this.boundaryInstrument.playFreqAtTime(.1,1,200),this.boundaryInstrument.playFreqAtTime(.2,1,200))};return a}();(function(a){function d(){var b=this.sonification,c=this.options&&this.options.sonification;c&&c.enabled?b?b.update():(this.sonification=new a(this),this.sonification.update()):
b&&(b.destroy(),delete this.sonification)}function e(){this&&this.sonification&&this.sonification.destroy()}function g(){this.updateSonificationEnabled&&this.updateSonificationEnabled()}function h(a){if(a=a.options.sonification)f(!0,this.options.sonification,a),g.call(this)}var l=[];a.compose=function(a,f,k){-1===l.indexOf(a)&&(l.push(a),b(a.prototype,{updateSonificationEnabled:d,sonify:function(a){this.sonification&&this.sonification.sonifyChart(!1,a)},toggleSonify:function(a,b){void 0===a&&(a=!0);
if(this.sonification){var c=this.sonification.timeline;J.speechSynthesis&&J.speechSynthesis.cancel();c&&this.sonification.isPlaying()?a?this.sonification.cancel():c.pause():c&&c.isPaused?c.resume():this.sonification.sonifyChart(a,b)}}}),c(a,"destroy",e),c(a,"render",g),c(a,"update",h));-1===l.indexOf(f)&&(l.push(f),f.prototype.sonify=function(a){this.chart.sonification&&this.chart.sonification.sonifySeries(this,!1,a)});-1===l.indexOf(k)&&(l.push(k),k.prototype.sonify=function(a){this.series.chart.sonification&&
this.series.chart.sonification.sonifyPoint(this,a)});(a=n().exporting)&&a.buttons&&a.buttons.contextButton.menuItems&&a.buttons.contextButton.menuItems.push("separator","downloadMIDI","playAsSound")}})(a||(a={}));f(!0,v,l);"";return a});t(a,"Extensions/Sonification/Scales.js",[],function(){"";return{minor:[0,2,3,5,7,8,10],dorian:[0,2,3,5,7,9,10],harmonicMinor:[0,2,3,5,7,8,11],phrygian:[0,1,3,5,7,8,11],major:[0,2,4,5,7,9,11],lydian:[0,2,4,6,7,9,11],mixolydian:[0,2,4,5,7,9,10],majorPentatonic:[0,2,
4,7,9],minorPentatonic:[0,3,5,7,10]}});t(a,"masters/modules/sonification.src.js",[a["Core/Globals.js"],a["Extensions/Sonification/Sonification.js"],a["Extensions/Sonification/SynthPatch.js"],a["Extensions/Sonification/InstrumentPresets.js"],a["Extensions/Sonification/Scales.js"],a["Extensions/Sonification/SonificationInstrument.js"],a["Extensions/Sonification/SonificationSpeaker.js"],a["Extensions/Sonification/SonificationTimeline.js"]],function(a,m,e,l,t,y,d,B){a.sonification={InstrumentPresets:l,
Scales:t,SynthPatch:e,SonificationInstrument:y,SonificationSpeaker:d,SonificationTimeline:B,Sonification:m};m.compose(a.Chart,a.Series,a.Point)})});
//# sourceMappingURL=sonification.js.map