/*
 Highcharts Gantt JS v11.0.0 (2023-04-26)

 Pathfinder

 (c) 2016-2021 ystein Moseng

 License: www.highcharts.com/license
*/
'use strict';(function(f){"object"===typeof module&&module.exports?(f["default"]=f,module.exports=f):"function"===typeof define&&define.amd?define("highcharts/modules/pathfinder",["highcharts"],function(y){f(y);f.Highcharts=y;return f}):f("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(f){function y(f,n,A,x){f.hasOwnProperty(n)||(f[n]=x.apply(null,A),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:n,module:f[n]}})))}f=f?f._modules:
{};y(f,"Gantt/Connection.js",[f["Core/Defaults.js"],f["Core/Globals.js"],f["Core/Series/Point.js"],f["Core/Utilities.js"]],function(f,n,A,x){function C(b){var h=b.shapeArgs;return h?{xMin:h.x||0,xMax:(h.x||0)+(h.width||0),yMin:h.y||0,yMax:(h.y||0)+(h.height||0)}:(h=b.graphic&&b.graphic.getBBox())?{xMin:b.plotX-h.width/2,xMax:b.plotX+h.width/2,yMin:b.plotY-h.height/2,yMax:b.plotY+h.height/2}:null}var B=f.defaultOptions,l=x.defined,m=x.error;f=x.extend;var r=x.merge,v=x.objectEach;"";var d=n.deg2rad,
a=Math.max,e=Math.min;f(B,{connectors:{type:"straight",lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});x=function(){function b(h,F,c){this.toPoint=this.pathfinder=this.graphics=this.fromPoint=this.chart=void 0;this.init(h,F,c)}b.prototype.init=function(h,F,c){this.fromPoint=h;this.toPoint=F;this.options=c;this.chart=h.series.chart;this.pathfinder=this.chart.pathfinder};b.prototype.renderPath=
function(h,F,c){var b=this.chart,d=b.styledMode,a=b.pathfinder,g=!b.options.chart.forExport&&!1!==c,k=this.graphics&&this.graphics.path;a.group||(a.group=b.renderer.g().addClass("highcharts-pathfinder-group").attr({zIndex:-1}).add(b.seriesGroup));a.group.translate(b.plotLeft,b.plotTop);k&&k.renderer||(k=b.renderer.path().add(a.group),d||k.attr({opacity:0}));k.attr(F);h={d:h};d||(h.opacity=1);k[g?"animate":"attr"](h,c);this.graphics=this.graphics||{};this.graphics.path=k};b.prototype.addMarker=function(h,
b,c){var a=this.fromPoint.series.chart,F=a.pathfinder;a=a.renderer;var e="start"===h?this.fromPoint:this.toPoint,g=e.getPathfinderAnchorPoint(b);if(b.enabled&&((c="start"===h?c[1]:c[c.length-2])&&"M"===c[0]||"L"===c[0])){c={x:c[1],y:c[2]};c=e.getRadiansToVector(c,g);g=e.getMarkerVector(c,b.radius,g);c=-c/d;if(b.width&&b.height){var k=b.width;var z=b.height}else k=z=2*b.radius;this.graphics=this.graphics||{};g={x:g.x-k/2,y:g.y-z/2,width:k,height:z,rotation:c,rotationOriginX:g.x,rotationOriginY:g.y};
this.graphics[h]?this.graphics[h].animate(g):(this.graphics[h]=a.symbol(b.symbol).addClass("highcharts-point-connecting-path-"+h+"-marker").attr(g).add(F.group),a.styledMode||this.graphics[h].attr({fill:b.color||this.fromPoint.color,stroke:b.lineColor,"stroke-width":b.lineWidth,opacity:0}).animate({opacity:1},e.series.options.animation))}};b.prototype.getPath=function(b){var h=this.pathfinder,a=this.chart,d=h.algorithms[b.type],e=h.chartObstacles;if("function"!==typeof d)return m('"'+b.type+'" is not a Pathfinder algorithm.'),
{path:[],obstacles:[]};d.requiresObstacles&&!e&&(e=h.chartObstacles=h.getChartObstacles(b),a.options.connectors.algorithmMargin=b.algorithmMargin,h.chartObstacleMetrics=h.getObstacleMetrics(e));return d(this.fromPoint.getPathfinderAnchorPoint(b.startMarker),this.toPoint.getPathfinderAnchorPoint(b.endMarker),r({chartObstacles:e,lineObstacles:h.lineObstacles||[],obstacleMetrics:h.chartObstacleMetrics,hardBounds:{xMin:0,xMax:a.plotWidth,yMin:0,yMax:a.plotHeight},obstacleOptions:{margin:b.algorithmMargin},
startDirectionX:h.getAlgorithmStartDirection(b.startMarker)},b))};b.prototype.render=function(){var b=this.fromPoint,d=b.series,c=d.chart,f=c.pathfinder,t=r(c.options.connectors,d.options.connectors,b.options.connectors,this.options),m={};c.styledMode||(m.stroke=t.lineColor||b.color,m["stroke-width"]=t.lineWidth,t.dashStyle&&(m.dashstyle=t.dashStyle));m["class"]="highcharts-point-connecting-path highcharts-color-"+b.colorIndex;t=r(m,t);l(t.marker.radius)||(t.marker.radius=e(a(Math.ceil((t.algorithmMargin||
8)/2)-1,1),5));b=this.getPath(t);c=b.path;b.obstacles&&(f.lineObstacles=f.lineObstacles||[],f.lineObstacles=f.lineObstacles.concat(b.obstacles));this.renderPath(c,m,d.options.animation);this.addMarker("start",r(t.marker,t.startMarker),c);this.addMarker("end",r(t.marker,t.endMarker),c)};b.prototype.destroy=function(){this.graphics&&(v(this.graphics,function(b){b.destroy()}),delete this.graphics)};return b}();n.Connection=x;f(A.prototype,{getPathfinderAnchorPoint:function(b){var a=C(this);switch(b.align){case "right":var d=
"xMax";break;case "left":d="xMin"}switch(b.verticalAlign){case "top":var c="yMin";break;case "bottom":c="yMax"}return{x:d?a[d]:(a.xMin+a.xMax)/2,y:c?a[c]:(a.yMin+a.yMax)/2}},getRadiansToVector:function(b,a){var d;l(a)||(d=C(this))&&(a={x:(d.xMin+d.xMax)/2,y:(d.yMin+d.yMax)/2});return Math.atan2(a.y-b.y,b.x-a.x)},getMarkerVector:function(b,a,d){var c=2*Math.PI,e=C(this),h=e.xMax-e.xMin,f=e.yMax-e.yMin,g=Math.atan2(f,h),k=!1;h/=2;var z=f/2,I=e.xMin+h;e=e.yMin+z;for(var G=I,l=e,p=1,u=1;b<-Math.PI;)b+=
c;for(;b>Math.PI;)b-=c;c=Math.tan(b);b>-g&&b<=g?(u=-1,k=!0):b>g&&b<=Math.PI-g?u=-1:b>Math.PI-g||b<=-(Math.PI-g)?(p=-1,k=!0):p=-1;k?(G+=p*h,l+=u*h*c):(G+=f/(2*c)*p,l+=u*z);d.x!==I&&(G=d.x);d.y!==e&&(l=d.y);return{x:G+a*Math.cos(b),y:l-a*Math.sin(b)}}});return x});y(f,"Gantt/PathfinderAlgorithms.js",[f["Core/Utilities.js"]],function(f){function n(d,a,e){e=e||0;var b=d.length-1;a-=1e-7;for(var h,f;e<=b;)if(h=b+e>>1,f=a-d[h].xMin,0<f)e=h+1;else if(0>f)b=h-1;else return h;return 0<e?e-1:0}function A(d,
a){for(var e=n(d,a.x+1)+1;e--;){var b;if(b=d[e].xMax>=a.x)b=d[e],b=a.x<=b.xMax&&a.x>=b.xMin&&a.y<=b.yMax&&a.y>=b.yMin;if(b)return e}return-1}function x(d){var a=[];if(d.length){a.push(["M",d[0].start.x,d[0].start.y]);for(var e=0;e<d.length;++e)a.push(["L",d[e].end.x,d[e].end.y])}return a}function C(d,a){d.yMin=m(d.yMin,a.yMin);d.yMax=l(d.yMax,a.yMax);d.xMin=m(d.xMin,a.xMin);d.xMax=l(d.xMax,a.xMax)}var B=f.pick,l=Math.min,m=Math.max,r=Math.abs;f=function(d,a,e){function b(b,a,d,g,e){b={x:b.x,y:b.y};
b[a]=d[g||a]+(e||0);return b}function h(a,d,g){var k=r(d[g]-a[g+"Min"])>r(d[g]-a[g+"Max"]);return b(d,g,a,g+(k?"Max":"Min"),k?1:-1)}var f=[],c=B(e.startDirectionX,r(a.x-d.x)>r(a.y-d.y))?"x":"y",l=e.chartObstacles,m=A(l,d);e=A(l,a);if(-1<e){var n=l[e];e=h(n,a,c);n={start:e,end:a};var g=e}else g=a;-1<m&&(l=l[m],e=h(l,d,c),f.push({start:d,end:e}),e[c]>=d[c]===e[c]>=g[c]&&(c="y"===c?"x":"y",a=d[c]<a[c],f.push({start:e,end:b(e,c,l,c+(a?"Max":"Min"),a?1:-1)}),c="y"===c?"x":"y"));d=f.length?f[f.length-1].end:
d;e=b(d,c,g);f.push({start:d,end:e});c=b(e,"y"===c?"x":"y",g);f.push({start:e,end:c});f.push(n);return{path:x(f),obstacles:f}};f.requiresObstacles=!0;var v=function(d,a,e){function b(b,a,d){var g,k=b.x<a.x?1:-1;if(b.x<a.x){var f=b;var e=a}else f=a,e=b;if(b.y<a.y){var z=b;var c=a}else z=a,c=b;for(g=0>k?l(n(p,e.x),p.length-1):0;p[g]&&(0<k&&p[g].xMin<=e.x||0>k&&p[g].xMax>=f.x);){if(p[g].xMin<=e.x&&p[g].xMax>=f.x&&p[g].yMin<=c.y&&p[g].yMax>=z.y)return d?{y:b.y,x:b.x<a.x?p[g].xMin-1:p[g].xMax+1,obstacle:p[g]}:
{x:b.x,y:b.y<a.y?p[g].yMin-1:p[g].yMax+1,obstacle:p[g]};g+=k}return a}function f(a,g,d,k,e){var f=e.soft,z=e.hard,c=k?"x":"y",h={x:g.x,y:g.y},p={x:g.x,y:g.y};e=a[c+"Max"]>=f[c+"Max"];f=a[c+"Min"]<=f[c+"Min"];var l=a[c+"Max"]>=z[c+"Max"];z=a[c+"Min"]<=z[c+"Min"];var D=r(a[c+"Min"]-g[c]),w=r(a[c+"Max"]-g[c]);d=10>r(D-w)?g[c]<d[c]:w<D;p[c]=a[c+"Min"];h[c]=a[c+"Max"];a=b(g,p,k)[c]!==p[c];g=b(g,h,k)[c]!==h[c];d=a?g?d:!0:g?!1:d;d=f?e?d:!0:e?!1:d;return z?l?d:!0:l?!1:d}function v(a,d,k){if(a.x===d.x&&a.y===
d.y)return[];var c=k?"x":"y",h=e.obstacleOptions.margin;var u={soft:{xMin:z,xMax:I,yMin:G,yMax:K},hard:e.hardBounds};var w=A(p,a);if(-1<w){w=p[w];u=f(w,a,d,k,u);C(w,e.hardBounds);var D=k?{y:a.y,x:w[u?"xMax":"xMin"]+(u?1:-1)}:{x:a.x,y:w[u?"yMax":"yMin"]+(u?1:-1)};var q=A(p,D);-1<q&&(q=p[q],C(q,e.hardBounds),D[c]=u?m(w[c+"Max"]-h+1,(q[c+"Min"]+w[c+"Max"])/2):l(w[c+"Min"]+h-1,(q[c+"Max"]+w[c+"Min"])/2),a.x===D.x&&a.y===D.y?(g&&(D[c]=u?m(w[c+"Max"],q[c+"Max"])+1:l(w[c+"Min"],q[c+"Min"])-1),g=!g):g=!1);
a=[{start:a,end:D}]}else c=b(a,{x:k?d.x:a.x,y:k?a.y:d.y},k),a=[{start:a,end:{x:c.x,y:c.y}}],c[k?"x":"y"]!==d[k?"x":"y"]&&(u=f(c.obstacle,c,d,!k,u),C(c.obstacle,e.hardBounds),u={x:k?c.x:c.obstacle[u?"xMax":"xMin"]+(u?1:-1),y:k?c.obstacle[u?"yMax":"yMin"]+(u?1:-1):c.y},k=!k,a=a.concat(v({x:c.x,y:c.y},u,k)));return a=a.concat(v(a[a.length-1].end,d,!k))}function c(a,b,g){var c=l(a.xMax-b.x,b.x-a.xMin)<l(a.yMax-b.y,b.y-a.yMin);g=f(a,b,g,c,{soft:e.hardBounds,hard:e.hardBounds});return c?{y:b.y,x:a[g?"xMax":
"xMin"]+(g?1:-1)}:{x:b.x,y:a[g?"yMax":"yMin"]+(g?1:-1)}}var y=B(e.startDirectionX,r(a.x-d.x)>r(a.y-d.y)),t=y?"x":"y",E=[],g=!1,k=e.obstacleMetrics,z=l(d.x,a.x)-k.maxWidth-10,I=m(d.x,a.x)+k.maxWidth+10,G=l(d.y,a.y)-k.maxHeight-10,K=m(d.y,a.y)+k.maxHeight+10,p=e.chartObstacles;var u=n(p,z);k=n(p,I);p=p.slice(u,k+1);if(-1<(k=A(p,a))){var H=c(p[k],a,d);E.push({end:a,start:H});a=H}for(;-1<(k=A(p,a));)u=0>a[t]-d[t],H={x:a.x,y:a.y},H[t]=p[k][u?t+"Max":t+"Min"]+(u?1:-1),E.push({end:a,start:H}),a=H;d=v(d,
a,y);d=d.concat(E.reverse());return{path:x(d),obstacles:d}};v.requiresObstacles=!0;return{fastAvoid:v,straight:function(d,a){return{path:[["M",d.x,d.y],["L",a.x,a.y]],obstacles:[{start:d,end:a}]}},simpleConnect:f}});y(f,"Gantt/Pathfinder.js",[f["Gantt/Connection.js"],f["Core/Chart/Chart.js"],f["Core/Defaults.js"],f["Core/Globals.js"],f["Core/Series/Point.js"],f["Core/Utilities.js"],f["Gantt/PathfinderAlgorithms.js"]],function(f,n,A,x,C,B,l){function m(a){var b=a.shapeArgs;return b?{xMin:b.x||0,xMax:(b.x||
0)+(b.width||0),yMin:b.y||0,yMax:(b.y||0)+(b.height||0)}:(b=a.graphic&&a.graphic.getBBox())?{xMin:a.plotX-b.width/2,xMax:a.plotX+b.width/2,yMin:a.plotY-b.height/2,yMax:a.plotY+b.height/2}:null}function r(a){for(var b=a.length,c=0,d,g,f=[],e=function(a,b,c){c=y(c,10);var d=a.yMax+c>b.yMin-c&&a.yMin-c<b.yMax+c,g=a.xMax+c>b.xMin-c&&a.xMin-c<b.xMax+c,k=d?a.xMin>b.xMax?a.xMin-b.xMax:b.xMin-a.xMax:Infinity,f=g?a.yMin>b.yMax?a.yMin-b.yMax:b.yMin-a.yMax:Infinity;return g&&d?c?e(a,b,Math.floor(c/2)):Infinity:
t(k,f)};c<b;++c)for(d=c+1;d<b;++d)g=e(a[c],a[d]),80>g&&f.push(g);f.push(80);return J(Math.floor(f.sort(function(a,b){return a-b})[Math.floor(f.length/10)]/2-1),1)}function v(a){if(a.options.pathfinder||a.series.reduce(function(a,b){b.options&&h(!0,b.options.connectors=b.options.connectors||{},b.options.pathfinder);return a||b.options&&b.options.pathfinder},!1))h(!0,a.options.connectors=a.options.connectors||{},a.options.pathfinder),e('WARNING: Pathfinder options have been renamed. Use "chart.connectors" or "series.connectors" instead.')}
A=A.defaultOptions;var d=B.addEvent,a=B.defined,e=B.error,b=B.extend,h=B.merge,y=B.pick,c=B.splat;"";var J=Math.max,t=Math.min;b(A,{connectors:{type:"straight",lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});var E=function(){function b(a){this.lineObstacles=this.group=this.connections=this.chartObstacleMetrics=this.chartObstacles=this.chart=void 0;this.init(a)}b.prototype.init=function(a){this.chart=
a;this.connections=[];d(a,"redraw",function(){this.pathfinder.update()})};b.prototype.update=function(a){var b=this.chart,d=this,g=d.connections;d.connections=[];b.series.forEach(function(a){a.visible&&!a.options.isInternal&&a.points.forEach(function(a){var g=a.options;g&&g.dependency&&(g.connect=g.dependency);var e;g=a.options&&a.options.connect&&c(a.options.connect);a.visible&&!1!==a.isInside&&g&&g.forEach(function(c){e=b.get("string"===typeof c?c:c.to);e instanceof C&&e.series.visible&&e.visible&&
!1!==e.isInside&&d.connections.push(new f(a,e,"string"===typeof c?{}:c))})})});for(var k=0,e=void 0,h=void 0,l=g.length,m=d.connections.length;k<l;++k){h=!1;var q=g[k];for(e=0;e<m;++e){var w=d.connections[e];if((q.options&&q.options.type)===(w.options&&w.options.type)&&q.fromPoint===w.fromPoint&&q.toPoint===w.toPoint){w.graphics=q.graphics;h=!0;break}}h||q.destroy()}delete this.chartObstacles;delete this.lineObstacles;d.renderConnections(a)};b.prototype.renderConnections=function(a){a?this.chart.series.forEach(function(a){var b=
function(){var b=a.chart.pathfinder;(b&&b.connections||[]).forEach(function(b){b.fromPoint&&b.fromPoint.series===a&&b.render()});a.pathfinderRemoveRenderEvent&&(a.pathfinderRemoveRenderEvent(),delete a.pathfinderRemoveRenderEvent)};!1===a.options.animation?b():a.pathfinderRemoveRenderEvent=d(a,"afterAnimate",b)}):this.connections.forEach(function(a){a.render()})};b.prototype.getChartObstacles=function(b){for(var c=[],d=this.chart.series,g=y(b.algorithmMargin,0),e,f=0,k=d.length;f<k;++f)if(d[f].visible&&
!d[f].options.isInternal){var h=0,l=d[f].points.length,q=void 0;for(q=void 0;h<l;++h)q=d[f].points[h],q.visible&&(q=m(q))&&c.push({xMin:q.xMin-g,xMax:q.xMax+g,yMin:q.yMin-g,yMax:q.yMax+g})}c=c.sort(function(a,b){return a.xMin-b.xMin});a(b.algorithmMargin)||(e=b.algorithmMargin=r(c),c.forEach(function(a){a.xMin-=e;a.xMax+=e;a.yMin-=e;a.yMax+=e}));return c};b.prototype.getObstacleMetrics=function(a){for(var b=0,c=0,d,g,e=a.length;e--;)d=a[e].xMax-a[e].xMin,g=a[e].yMax-a[e].yMin,b<d&&(b=d),c<g&&(c=g);
return{maxHeight:c,maxWidth:b}};b.prototype.getAlgorithmStartDirection=function(a){var b="top"!==a.verticalAlign&&"bottom"!==a.verticalAlign;return"left"!==a.align&&"right"!==a.align?b?void 0:!1:b?!0:void 0};return b}();E.prototype.algorithms=l;x.Pathfinder=E;b(C.prototype,{getPathfinderAnchorPoint:function(a){var b=m(this);switch(a.align){case "right":var c="xMax";break;case "left":c="xMin"}switch(a.verticalAlign){case "top":var d="yMin";break;case "bottom":d="yMax"}return{x:c?b[c]:(b.xMin+b.xMax)/
2,y:d?b[d]:(b.yMin+b.yMax)/2}},getRadiansToVector:function(b,c){var d;a(c)||(d=m(this))&&(c={x:(d.xMin+d.xMax)/2,y:(d.yMin+d.yMax)/2});return Math.atan2(c.y-b.y,b.x-c.x)},getMarkerVector:function(a,b,c){var d=2*Math.PI,e=m(this),g=e.xMax-e.xMin,f=e.yMax-e.yMin,h=Math.atan2(f,g),k=!1;g/=2;var l=f/2,q=e.xMin+g;e=e.yMin+l;for(var r=q,n=e,t=1,v=1;a<-Math.PI;)a+=d;for(;a>Math.PI;)a-=d;d=Math.tan(a);a>-h&&a<=h?(v=-1,k=!0):a>h&&a<=Math.PI-h?v=-1:a>Math.PI-h||a<=-(Math.PI-h)?(t=-1,k=!0):t=-1;k?(r+=t*g,n+=
v*g*d):(r+=f/(2*d)*t,n+=v*l);c.x!==q&&(r=c.x);c.y!==e&&(n=c.y);return{x:r+b*Math.cos(a),y:n-b*Math.sin(a)}}});n.prototype.callbacks.push(function(a){!1!==a.options.connectors.enabled&&(v(a),this.pathfinder=new E(this),this.pathfinder.update(!0))});return E});y(f,"Extensions/ArrowSymbols.js",[f["Core/Utilities.js"]],function(f){function n(f,m,r,n){return[["M",f,m+n/2],["L",f+r,m],["L",f,m+n/2],["L",f+r,m+n]]}function A(f,m,r,v){return n(f,m,r/2,v)}function x(f,m,n,v){return[["M",f+n,m],["L",f,m+v/
2],["L",f+n,m+v],["Z"]]}function y(f,m,n,v){return x(f,m,n/2,v)}var B=[];return{compose:function(l){f.pushUnique(B,l)&&(l=l.prototype.symbols,l.arrow=n,l["arrow-filled"]=x,l["arrow-filled-half"]=y,l["arrow-half"]=A,l["triangle-left"]=x,l["triangle-left-half"]=y)}}});y(f,"masters/modules/pathfinder.src.js",[f["Core/Globals.js"],f["Extensions/ArrowSymbols.js"]],function(f,n){n.compose(f.SVGRenderer)})});
//# sourceMappingURL=pathfinder.js.map