/*
 Highcharts JS v11.0.0 (2023-04-26)

 Force directed graph module

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(d){"object"===typeof module&&module.exports?(d["default"]=d,module.exports=d):"function"===typeof define&&define.amd?define("highcharts/modules/networkgraph",["highcharts"],function(l){d(l);d.Highcharts=l;return d}):d("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(d){function l(b,a,c,e){b.hasOwnProperty(a)||(b[a]=e.apply(null,c),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:a,module:b[a]}})))}d=d?
d._modules:{};l(d,"Series/DragNodesComposition.js",[d["Core/Utilities.js"]],function(b){function a(){var a=this,b,e,d;a.container&&(b=c(a.container,"mousedown",function(b){var f=a.hoverPoint;f&&f.series&&f.series.hasDraggableNodes&&f.series.options.draggable&&(f.series.onMouseDown(f,b),e=c(a.container,"mousemove",function(a){return f&&f.series&&f.series.onMouseMove(f,a)}),d=c(a.container.ownerDocument,"mouseup",function(a){e();d();return f&&f.series&&f.series.onMouseUp(f,a)}))}));c(a,"destroy",function(){b()})}
var c=b.addEvent,e=[];return{compose:function(f){b.pushUnique(e,f)&&c(f,"load",a)},onMouseDown:function(a,b){b=this.chart.pointer.normalize(b);a.fixedPosition={chartX:b.chartX,chartY:b.chartY,plotX:a.plotX,plotY:a.plotY};a.inDragMode=!0},onMouseMove:function(a,b){if(a.fixedPosition&&a.inDragMode){var c=this.chart,f=c.pointer.normalize(b);b=a.fixedPosition.chartX-f.chartX;f=a.fixedPosition.chartY-f.chartY;var e=c.graphLayoutsLookup,d=void 0,h=void 0;if(5<Math.abs(b)||5<Math.abs(f))d=a.fixedPosition.plotX-
b,h=a.fixedPosition.plotY-f,c.isInsidePlot(d,h)&&(a.plotX=d,a.plotY=h,a.hasDragged=!0,this.redrawHalo(a),e.forEach(function(a){a.restartSimulation()}))}},onMouseUp:function(a,b){a.fixedPosition&&(a.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw()),a.inDragMode=a.hasDragged=!1,this.options.fixedDraggable||delete a.fixedPosition)},redrawHalo:function(a){a&&this.halo&&this.halo.attr({d:a.haloPath(this.options.states.hover.halo.size)})}}});l(d,"Series/GraphLayoutComposition.js",
[d["Core/Animation/AnimationUtilities.js"],d["Core/Utilities.js"]],function(b,a){function c(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(a){a.updateSimulation()}),this.redraw())}function e(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(a){a.updateSimulation(!1)}),this.redraw())}function f(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(a){a.stop()})}function d(){var a=!1,b=function(b){b.maxIterations--&&isFinite(b.temperature)&&!b.isStable()&&
!b.enableSimulation&&(b.beforeStep&&b.beforeStep(),b.step(),c=!1,a=!0)};if(this.graphLayoutsLookup){n(!1,this);for(this.graphLayoutsLookup.forEach(function(a){return a.start()});!c;){var c=!0;this.graphLayoutsLookup.forEach(b)}a&&this.series.forEach(function(a){a&&a.layout&&a.render()})}}var n=b.setAnimation,v=a.addEvent,m=[];return{compose:function(b){a.pushUnique(m,b)&&(v(b,"afterPrint",c),v(b,"beforePrint",e),v(b,"predraw",f),v(b,"render",d))},integrations:{},layouts:{}}});l(d,"Series/NodesComposition.js",
[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(b,a){b=b.series;var c=b.prototype,e=b.prototype.pointClass.prototype,f=a.defined,d=a.extend,n=a.find,v=a.merge,m=a.pick,p;(function(b){function h(){this.data=[].concat(this.points||[],this.nodes);return c.destroy.apply(this,arguments)}function t(){this.nodes&&(this.nodes.forEach(function(a){a.destroy()}),this.nodes.length=0);c.setData.apply(this,arguments)}function g(a){var b=arguments,g=this.isNode?this.linksTo.concat(this.linksFrom):
[this.fromNode,this.toNode];"select"!==a&&g.forEach(function(a){a&&a.series&&(e.setState.apply(a,b),a.isNode||(a.fromNode.graphic&&e.setState.apply(a.fromNode,b),a.toNode&&a.toNode.graphic&&e.setState.apply(a.toNode,b)))});e.setState.apply(this,b)}function k(a,b,g,c){var k=this,t=this.series.options.nodes,r=this.series.options.data,y=r&&r.length||0,x=r&&r[this.index];e.update.call(this,a,this.isNode?!1:b,g,c);this.isNode&&(a=(t||[]).reduce(function(a,b,g){return k.id===b.id?g:a},-1),c=v(t&&t[a]||
{},r&&r[this.index]||{}),r&&(x?r[this.index]=x:r.length=y),t?0<=a?t[a]=c:t.push(c):this.series.options.nodes=[c],m(b,!0)&&this.series.chart.redraw(g))}var y=[];b.compose=function(b,c){a.pushUnique(y,b)&&(b=b.prototype,b.setNodeState=g,b.setState=g,b.update=k);a.pushUnique(y,c)&&(b=c.prototype,b.destroy=h,b.setData=t);return c};b.createNode=function(a){var b=this.pointClass,g=function(a,b){return n(a,function(a){return a.id===b})},c=g(this.nodes,a);if(!c){g=this.options.nodes&&g(this.options.nodes,
a);var k=(new b).init(this,d({className:"highcharts-node",isNode:!0,id:a,y:1},g));k.linksTo=[];k.linksFrom=[];k.getSum=function(){var a=0,b=0;k.linksTo.forEach(function(b){a+=b.weight||0});k.linksFrom.forEach(function(a){b+=a.weight||0});return Math.max(a,b)};k.offset=function(a,b){for(var g=0,c=0;c<k[b].length;c++){if(k[b][c]===a)return g;g+=k[b][c].weight}};k.hasShape=function(){var a=0;k.linksTo.forEach(function(b){b.outgoing&&a++});return!k.linksTo.length||a!==k.linksTo.length};k.index=this.nodes.push(k)-
1;c=k}c.formatPrefix="node";c.name=c.name||c.options.id||"";c.mass=m(c.options.mass,c.options.marker&&c.options.marker.radius,this.options.marker&&this.options.marker.radius,4);return c};b.destroy=h;b.generatePoints=function(){var a=this,b=this.chart,g={};c.generatePoints.call(this);this.nodes||(this.nodes=[]);this.colorCounter=0;this.nodes.forEach(function(a){a.linksFrom.length=0;a.linksTo.length=0;a.level=a.options.level});this.points.forEach(function(c){f(c.from)&&(g[c.from]||(g[c.from]=a.createNode(c.from)),
g[c.from].linksFrom.push(c),c.fromNode=g[c.from],b.styledMode?c.colorIndex=m(c.options.colorIndex,g[c.from].colorIndex):c.color=c.options.color||g[c.from].color);f(c.to)&&(g[c.to]||(g[c.to]=a.createNode(c.to)),g[c.to].linksTo.push(c),c.toNode=g[c.to]);c.name=c.name||c.id},this);this.nodeLookup=g};b.setNodeState=g;b.updateNode=k})(p||(p={}));return p});l(d,"Series/Networkgraph/NetworkgraphPoint.js",[d["Series/NodesComposition.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(b,
a,c){var e=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function g(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(g.prototype=c.prototype,new g)}}();
a=a.series;var f=a.prototype,d=a.prototype.pointClass,n=c.addEvent,v=c.css,m=c.defined;a=c.extend;var p=c.pick;c=function(a){function b(){return null!==a&&a.apply(this,arguments)||this}e(b,a);b.prototype.destroy=function(){this.isNode&&this.linksFrom.concat(this.linksTo).forEach(function(a){a.destroyElements&&a.destroyElements()});this.series.layout.removeElementFromCollection(this,this.series.layout[this.isNode?"nodes":"links"]);return d.prototype.destroy.apply(this,arguments)};b.prototype.getDegree=
function(){var a=this.isNode?this.linksFrom.length+this.linksTo.length:0;return 0===a?1:a};b.prototype.getLinkAttributes=function(){var a=this.series.options.link,b=this.options;return{"stroke-width":p(b.width,a.width),stroke:b.color||a.color,dashstyle:b.dashStyle||a.dashStyle,opacity:p(b.opacity,a.opacity,1)}};b.prototype.getLinkPath=function(){var a=this.fromNode,b=this.toNode;a.plotX>b.plotX&&(a=this.toNode,b=this.fromNode);return[["M",a.plotX||0,a.plotY||0],["L",b.plotX||0,b.plotY||0]]};b.prototype.getMass=
function(){var a=this.fromNode.mass,b=this.toNode.mass,c=a+b;return{fromNode:1-a/c,toNode:1-b/c}};b.prototype.init=function(b,c,k){a.prototype.init.call(this,b,c,k);this.series.options.draggable&&!this.series.chart.styledMode&&(n(this,"mouseOver",function(){v(this.series.chart.container,{cursor:"move"})}),n(this,"mouseOut",function(){v(this.series.chart.container,{cursor:"default"})}));return this};b.prototype.isValid=function(){return!this.isNode||m(this.id)};b.prototype.redrawLink=function(){var a=
this.getLinkPath();if(this.graphic){this.shapeArgs={d:a};if(!this.series.chart.styledMode){var b=this.series.pointAttribs(this);this.graphic.attr(b);(this.dataLabels||[]).forEach(function(a){a&&a.attr({opacity:b.opacity})})}this.graphic.animate(this.shapeArgs);var c=a[0];a=a[1];"M"===c[0]&&"L"===a[0]&&(this.plotX=(c[1]+a[1])/2,this.plotY=(c[2]+a[2])/2)}};b.prototype.remove=function(a,b){var c=this.series,g=c.options.nodes||[],e,d=g.length;if(this.isNode){c.points=[];[].concat(this.linksFrom).concat(this.linksTo).forEach(function(a){e=
a.fromNode.linksFrom.indexOf(a);-1<e&&a.fromNode.linksFrom.splice(e,1);e=a.toNode.linksTo.indexOf(a);-1<e&&a.toNode.linksTo.splice(e,1);f.removePoint.call(c,c.data.indexOf(a),!1,!1)});c.points=c.data.slice();for(c.nodes.splice(c.nodes.indexOf(this),1);d--;)if(g[d].id===this.options.id){c.options.nodes.splice(d,1);break}this&&this.destroy();c.isDirty=!0;c.isDirtyData=!0;a&&c.chart.redraw(a)}else c.removePoint(c.data.indexOf(this),a,b)};b.prototype.renderLink=function(){if(!this.graphic&&(this.graphic=
this.series.chart.renderer.path(this.getLinkPath()).addClass(this.getClassName(),!0).add(this.series.group),!this.series.chart.styledMode)){var a=this.series.pointAttribs(this);this.graphic.attr(a);(this.dataLabels||[]).forEach(function(b){b&&b.attr({opacity:a.opacity})})}};return b}(d);a(c.prototype,{setState:b.setNodeState});return c});l(d,"Series/Networkgraph/NetworkgraphSeriesDefaults.js",[],function(){"";return{stickyTracking:!1,inactiveOtherPoints:!0,marker:{enabled:!0,states:{inactive:{opacity:.3,
animation:{duration:50}}}},states:{inactive:{linkOpacity:.3,animation:{duration:50}}},dataLabels:{formatter:function(){return this.key},linkFormatter:function(){return this.point.fromNode.name+"<br>"+this.point.toNode.name},linkTextPath:{enabled:!0},textPath:{enabled:!1},style:{transition:"opacity 2000ms"},defer:!0,animation:{defer:1E3}},link:{color:"rgba(100, 100, 100, 0.5)",width:1},draggable:!0,layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:1,enableSimulation:!1,theta:.5,maxSpeed:10,
approximation:"none",type:"reingold-fruchterman",integration:"euler",maxIterations:1E3,gravitationalConstant:.0625,friction:-.981},showInLegend:!1}});l(d,"Series/Networkgraph/EulerIntegration.js",[],function(){return{attractive:function(b,a,c,e){var f=b.getMass(),d=c.x/e*a;a*=c.y/e;b.fromNode.fixedPosition||(b.fromNode.dispX-=d*f.fromNode/b.fromNode.degree,b.fromNode.dispY-=a*f.fromNode/b.fromNode.degree);b.toNode.fixedPosition||(b.toNode.dispX+=d*f.toNode/b.toNode.degree,b.toNode.dispY+=a*f.toNode/
b.toNode.degree)},attractiveForceFunction:function(b,a){return b*b/a},barycenter:function(){var b=this.options.gravitationalConstant,a=this.barycenter.xFactor,c=this.barycenter.yFactor;this.nodes.forEach(function(e){if(!e.fixedPosition){var f=e.getDegree();f*=1+f/2;e.dispX+=(a-e.plotX)*b*f/e.degree;e.dispY+=(c-e.plotY)*b*f/e.degree}})},getK:function(b){return Math.pow(b.box.width*b.box.height/b.nodes.length,.3)},integrate:function(b,a){a.dispX+=a.dispX*b.options.friction;a.dispY+=a.dispY*b.options.friction;
var c=a.temperature=b.vectorLength({x:a.dispX,y:a.dispY});0!==c&&(a.plotX+=a.dispX/c*Math.min(Math.abs(a.dispX),b.temperature),a.plotY+=a.dispY/c*Math.min(Math.abs(a.dispY),b.temperature))},repulsive:function(b,a,c,e){b.dispX+=c.x/e*a/b.degree;b.dispY+=c.y/e*a/b.degree},repulsiveForceFunction:function(b,a){return a*a/b}}});l(d,"Series/Networkgraph/QuadTreeNode.js",[],function(){return function(){function b(a){this.isInternal=this.isEmpty=this.body=!1;this.nodes=[];this.box=a;this.boxSize=Math.min(a.width,
a.height)}b.prototype.divideBox=function(){var a=this.box.width/2,c=this.box.height/2;this.nodes[0]=new b({left:this.box.left,top:this.box.top,width:a,height:c});this.nodes[1]=new b({left:this.box.left+a,top:this.box.top,width:a,height:c});this.nodes[2]=new b({left:this.box.left+a,top:this.box.top+c,width:a,height:c});this.nodes[3]=new b({left:this.box.left,top:this.box.top+c,width:a,height:c})};b.prototype.getBoxPosition=function(a){var b=a.plotY<this.box.top+this.box.height/2;return a.plotX<this.box.left+
this.box.width/2?b?0:3:b?1:2};b.prototype.insert=function(a,c){this.isInternal?this.nodes[this.getBoxPosition(a)].insert(a,c-1):(this.isEmpty=!1,this.body?c?(this.isInternal=!0,this.divideBox(),!0!==this.body&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,c-1),this.body=!0),this.nodes[this.getBoxPosition(a)].insert(a,c-1)):(c=new b({top:a.plotX||NaN,left:a.plotY||NaN,width:.1,height:.1}),c.body=a,c.isInternal=!1,this.nodes.push(c)):(this.isInternal=!1,this.body=a))};b.prototype.updateMassAndCenter=
function(){var a=0,b=0,e=0;if(this.isInternal){for(var f=0,d=this.nodes;f<d.length;f++){var n=d[f];n.isEmpty||(a+=n.mass,b+=n.plotX*n.mass,e+=n.plotY*n.mass)}b/=a;e/=a}else this.body&&(a=this.body.mass,b=this.body.plotX,e=this.body.plotY);this.mass=a;this.plotX=b;this.plotY=e};return b}()});l(d,"Series/Networkgraph/QuadTree.js",[d["Series/Networkgraph/QuadTreeNode.js"]],function(b){return function(){function a(a,e,d,h){this.box={left:a,top:e,width:d,height:h};this.maxDepth=25;this.root=new b(this.box);
this.root.isInternal=!0;this.root.isRoot=!0;this.root.divideBox()}a.prototype.calculateMassAndCenter=function(){this.visitNodeRecursive(null,null,function(a){a.updateMassAndCenter()})};a.prototype.insertNodes=function(a){for(var b=0;b<a.length;b++)this.root.insert(a[b],this.maxDepth)};a.prototype.visitNodeRecursive=function(a,b,d){var c;a||(a=this.root);a===this.root&&b&&(c=b(a));if(!1!==c){for(var e=0,f=a.nodes;e<f.length;e++){var m=f[e];if(m.isInternal){b&&(c=b(m));if(!1===c)continue;this.visitNodeRecursive(m,
b,d)}else m.body&&b&&b(m.body);d&&d(m)}a===this.root&&d&&d(a)}};return a}()});l(d,"Series/Networkgraph/VerletIntegration.js",[],function(){return{attractive:function(b,a,c){var d=b.getMass(),f=-c.x*a*this.diffTemperature;a=-c.y*a*this.diffTemperature;b.fromNode.fixedPosition||(b.fromNode.plotX-=f*d.fromNode/b.fromNode.degree,b.fromNode.plotY-=a*d.fromNode/b.fromNode.degree);b.toNode.fixedPosition||(b.toNode.plotX+=f*d.toNode/b.toNode.degree,b.toNode.plotY+=a*d.toNode/b.toNode.degree)},attractiveForceFunction:function(b,
a){return(a-b)/b},barycenter:function(){var b=this.options.gravitationalConstant,a=this.barycenter.xFactor,c=this.barycenter.yFactor;a=(a-(this.box.left+this.box.width)/2)*b;c=(c-(this.box.top+this.box.height)/2)*b;this.nodes.forEach(function(b){b.fixedPosition||(b.plotX-=a/b.mass/b.degree,b.plotY-=c/b.mass/b.degree)})},getK:function(b){return Math.pow(b.box.width*b.box.height/b.nodes.length,.5)},integrate:function(b,a){var c=-b.options.friction,d=b.options.maxSpeed,f=(a.plotX+a.dispX-a.prevX)*c;
c*=a.plotY+a.dispY-a.prevY;var h=Math.abs,n=h(f)/(f||1);h=h(c)/(c||1);f=n*Math.min(d,Math.abs(f));c=h*Math.min(d,Math.abs(c));a.prevX=a.plotX+a.dispX;a.prevY=a.plotY+a.dispY;a.plotX+=f;a.plotY+=c;a.temperature=b.vectorLength({x:f,y:c})},repulsive:function(b,a,c){a=a*this.diffTemperature/b.mass/b.degree;b.fixedPosition||(b.plotX+=c.x*a,b.plotY+=c.y*a)},repulsiveForceFunction:function(b,a){return(a-b)/b*(a>b?1:0)}}});l(d,"Series/Networkgraph/ReingoldFruchtermanLayout.js",[d["Series/Networkgraph/EulerIntegration.js"],
d["Core/Globals.js"],d["Series/GraphLayoutComposition.js"],d["Series/Networkgraph/QuadTree.js"],d["Core/Utilities.js"],d["Series/Networkgraph/VerletIntegration.js"]],function(b,a,c,d,f,h){var e=a.win,l=f.clamp,m=f.defined,p=f.isFunction,C=f.fireEvent,q=f.pick;return function(){function a(){this.attractiveForce=void 0;this.box={};this.currentStep=0;this.initialRendering=!0;this.integration=void 0;this.links=[];this.nodes=[];this.repulsiveForce=this.quadTree=this.options=void 0;this.series=[];this.simulation=
!1}a.compose=function(g){c.compose(g);c.integrations.euler=b;c.integrations.verlet=h;c.layouts["reingold-fruchterman"]=a};a.prototype.init=function(a){this.options=a;this.nodes=[];this.links=[];this.series=[];this.box={x:0,y:0,width:0,height:0};this.setInitialRendering(!0);this.integration=c.integrations[a.integration];this.enableSimulation=a.enableSimulation;this.attractiveForce=q(a.attractiveForce,this.integration.attractiveForceFunction);this.repulsiveForce=q(a.repulsiveForce,this.integration.repulsiveForceFunction);
this.approximation=a.approximation};a.prototype.updateSimulation=function(a){this.enableSimulation=q(a,this.options.enableSimulation)};a.prototype.start=function(){var a=this.series,b=this.options;this.currentStep=0;this.forces=a[0]&&a[0].forces||[];this.chart=a[0]&&a[0].chart;this.initialRendering&&(this.initPositions(),a.forEach(function(a){a.finishedAnimating=!0;a.render()}));this.setK();this.resetSimulation(b);this.enableSimulation&&this.step()};a.prototype.step=function(){var a=this,b=this.series;
this.currentStep++;"barnes-hut"===this.approximation&&(this.createQuadTree(),this.quadTree.calculateMassAndCenter());for(var c=0,d=this.forces||[];c<d.length;c++)this[d[c]+"Forces"](this.temperature);this.applyLimits();this.temperature=this.coolDown(this.startTemperature,this.diffTemperature,this.currentStep);this.prevSystemTemperature=this.systemTemperature;this.systemTemperature=this.getSystemTemperature();if(this.enableSimulation){for(c=0;c<b.length;c++)d=b[c],d.chart&&d.render();this.maxIterations--&&
isFinite(this.temperature)&&!this.isStable()?(this.simulation&&e.cancelAnimationFrame(this.simulation),this.simulation=e.requestAnimationFrame(function(){return a.step()})):(this.simulation=!1,this.series.forEach(function(a){C(a,"afterSimulation")}))}};a.prototype.stop=function(){this.simulation&&e.cancelAnimationFrame(this.simulation)};a.prototype.setArea=function(a,b,c,d){this.box={left:a,top:b,width:c,height:d}};a.prototype.setK=function(){this.k=this.options.linkLength||this.integration.getK(this)};
a.prototype.addElementsToCollection=function(a,b){for(var c=0;c<a.length;c++){var g=a[c];-1===b.indexOf(g)&&b.push(g)}};a.prototype.removeElementFromCollection=function(a,b){a=b.indexOf(a);-1!==a&&b.splice(a,1)};a.prototype.clear=function(){this.nodes.length=0;this.links.length=0;this.series.length=0;this.resetSimulation()};a.prototype.resetSimulation=function(){this.forcedStop=!1;this.systemTemperature=0;this.setMaxIterations();this.setTemperature();this.setDiffTemperature()};a.prototype.restartSimulation=
function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))};a.prototype.setMaxIterations=function(a){this.maxIterations=q(a,this.options.maxIterations)};a.prototype.setTemperature=function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)};a.prototype.setDiffTemperature=function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+
1)};a.prototype.setInitialRendering=function(a){this.initialRendering=a};a.prototype.createQuadTree=function(){this.quadTree=new d(this.box.left,this.box.top,this.box.width,this.box.height);this.quadTree.insertNodes(this.nodes)};a.prototype.initPositions=function(){var a=this.options.initialPositions;if(p(a)){a.call(this);a=0;for(var b=this.nodes;a<b.length;a++){var c=b[a];m(c.prevX)||(c.prevX=c.plotX);m(c.prevY)||(c.prevY=c.plotY);c.dispX=0;c.dispY=0}}else"circle"===a?this.setCircularPositions():
this.setRandomPositions()};a.prototype.setCircularPositions=function(){for(var a=this.box,b=this.nodes,c=2*Math.PI/(b.length+1),d=b.filter(function(a){return 0===a.linksTo.length}),f={},e=this.options.initialPositionRadius,h=function(a){var b=0;for(a=a.linksFrom||[];b<a.length;b++){var c=a[b];f[c.toNode.id]||(f[c.toNode.id]=!0,w.push(c.toNode),h(c.toNode))}},w=[],u=0;u<d.length;u++){var r=d[u];w.push(r);h(r)}if(w.length)for(d=0;d<b.length;d++)u=b[d],-1===w.indexOf(u)&&w.push(u);else w=b;d=0;for(u=
w.length;d<u;++d)b=w[d],b.plotX=b.prevX=q(b.plotX,a.width/2+e*Math.cos(d*c)),b.plotY=b.prevY=q(b.plotY,a.height/2+e*Math.sin(d*c)),b.dispX=0,b.dispY=0};a.prototype.setRandomPositions=function(){for(var a=this.box,b=this.nodes,c=b.length+1,d=function(a){a=a*a/Math.PI;return a-=Math.floor(a)},f,e=0,h=b.length;e<h;++e)f=b[e],f.plotX=f.prevX=q(f.plotX,a.width*d(e)),f.plotY=f.prevY=q(f.plotY,a.height*d(c+e)),f.dispX=0,f.dispY=0};a.prototype.force=function(a){for(var b=[],c=1;c<arguments.length;c++)b[c-
1]=arguments[c];this.integration[a].apply(this,b)};a.prototype.barycenterForces=function(){this.getBarycenter();this.force("barycenter")};a.prototype.getBarycenter=function(){for(var a=0,b=0,c=0,d=0,f=this.nodes;d<f.length;d++){var e=f[d];b+=e.plotX*e.mass;c+=e.plotY*e.mass;a+=e.mass}return this.barycenter={x:b,y:c,xFactor:b/a,yFactor:c/a}};a.prototype.barnesHutApproximation=function(a,b){var c=this.getDistXY(a,b),d=this.vectorLength(c);if(a!==b&&0!==d)if(b.isInternal)if(b.boxSize/d<this.options.theta&&
0!==d){var f=this.repulsiveForce(d,this.k);this.force("repulsive",a,f*b.mass,c,d);var g=!1}else g=!0;else f=this.repulsiveForce(d,this.k),this.force("repulsive",a,f*b.mass,c,d);return g};a.prototype.repulsiveForces=function(){var a=this;if("barnes-hut"===this.approximation)for(var b=function(b){c.quadTree.visitNodeRecursive(null,function(c){return a.barnesHutApproximation(b,c)})},c=this,d=0,f=this.nodes;d<f.length;d++){var e=f[d];b(e)}else{f=d=b=void 0;for(var h=0,n=this.nodes;h<n.length;h++){e=n[h];
for(var u=0,r=this.nodes;u<r.length;u++){var z=r[u];e===z||e.fixedPosition||(f=this.getDistXY(e,z),d=this.vectorLength(f),0!==d&&(b=this.repulsiveForce(d,this.k),this.force("repulsive",e,b*z.mass,f,d)))}}}};a.prototype.attractiveForces=function(){for(var a,b,c,d=0,f=this.links;d<f.length;d++){var e=f[d];e.fromNode&&e.toNode&&(a=this.getDistXY(e.fromNode,e.toNode),b=this.vectorLength(a),0!==b&&(c=this.attractiveForce(b,this.k),this.force("attractive",e,c,a,b)))}};a.prototype.applyLimits=function(){for(var a=
0,b=this.nodes;a<b.length;a++){var c=b[a];if(c.fixedPosition)break;this.integration.integrate(this,c);this.applyLimitBox(c,this.box);c.dispX=0;c.dispY=0}};a.prototype.applyLimitBox=function(a,b){var c=a.radius;a.plotX=l(a.plotX,b.left+c,b.width-c);a.plotY=l(a.plotY,b.top+c,b.height-c)};a.prototype.coolDown=function(a,b,c){return a-b*c};a.prototype.isStable=function(){return.00001>Math.abs(this.systemTemperature-this.prevSystemTemperature)||0>=this.temperature};a.prototype.getSystemTemperature=function(){for(var a=
0,b=0,c=this.nodes;b<c.length;b++)a+=c[b].temperature;return a};a.prototype.vectorLength=function(a){return Math.sqrt(a.x*a.x+a.y*a.y)};a.prototype.getDistR=function(a,b){a=this.getDistXY(a,b);return this.vectorLength(a)};a.prototype.getDistXY=function(a,b){var c=a.plotX-b.plotX;a=a.plotY-b.plotY;return{x:c,y:a,absX:Math.abs(c),absY:Math.abs(a)}};return a}()});l(d,"Series/SimulationSeriesUtilities.js",[d["Core/Utilities.js"],d["Core/Animation/AnimationUtilities.js"]],function(b,a){var c=b.syncTimeout,
d=a.animObject;return{initDataLabels:function(){var a=this.options.dataLabels;if(!this.dataLabelsGroup){var b=this.initDataLabelsGroup();!this.chart.styledMode&&(null===a||void 0===a?0:a.style)&&b.css(a.style);b.attr({opacity:0});this.visible&&b.show();return b}this.dataLabelsGroup.attr({opacity:1});return this.dataLabelsGroup},initDataLabelsDefer:function(){var a=this,b,e=this.options.dataLabels;(null===e||void 0===e?0:e.defer)&&(null===(b=this.options.layoutAlgorithm)||void 0===b?0:b.enableSimulation)?
c(function(){a.deferDataLabels=!1},e?d(e.animation).defer:0):this.deferDataLabels=!1}}});l(d,"Series/Networkgraph/NetworkgraphSeries.js",[d["Series/DragNodesComposition.js"],d["Series/GraphLayoutComposition.js"],d["Core/Globals.js"],d["Series/Networkgraph/NetworkgraphPoint.js"],d["Series/Networkgraph/NetworkgraphSeriesDefaults.js"],d["Series/NodesComposition.js"],d["Series/Networkgraph/ReingoldFruchtermanLayout.js"],d["Core/Series/SeriesRegistry.js"],d["Series/SimulationSeriesUtilities.js"],d["Core/Utilities.js"]],
function(b,a,c,d,f,h,n,l,m,p){var e=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=
c.prototype,new d)}}();c=c.noop;var q=l.series,t=l.seriesTypes,g=t.column.prototype,k=t.line.prototype;t=m.initDataLabels;var v=m.initDataLabelsDefer,x=p.addEvent,A=p.defined;m=p.extend;var D=p.merge,B=p.pick;p=function(c){function d(){var a=null!==c&&c.apply(this,arguments)||this;a.data=void 0;a.nodes=void 0;a.options=void 0;a.points=void 0;a.deferDataLabels=!0;return a}e(d,c);d.compose=function(a){b.compose(a);n.compose(a)};d.prototype.deferLayout=function(){var b=this.options.layoutAlgorithm,c=
this.chart.graphLayoutsStorage,d=this.chart.graphLayoutsLookup,f=this.chart.options.chart;if(this.visible){c||(this.chart.graphLayoutsStorage=c={},this.chart.graphLayoutsLookup=d=[]);var e=c[b.type];e||(b.enableSimulation=A(f.forExport)?!f.forExport:b.enableSimulation,c[b.type]=e=new a.layouts[b.type],e.init(b),d.splice(e.index,0,e));this.layout=e;e.setArea(0,0,this.chart.plotWidth,this.chart.plotHeight);e.addElementsToCollection([this],e.series);e.addElementsToCollection(this.nodes,e.nodes);e.addElementsToCollection(this.points,
e.links)}};d.prototype.destroy=function(){this.layout&&this.layout.removeElementFromCollection(this,this.layout.series);h.destroy.call(this)};d.prototype.drawDataLabels=function(){if(!this.deferDataLabels){var a=this.options.dataLabels;if(null===a||void 0===a?0:a.textPath)var b=a.textPath;q.prototype.drawDataLabels.call(this,this.nodes);if(null===a||void 0===a?0:a.linkTextPath)a.textPath=a.linkTextPath;q.prototype.drawDataLabels.call(this,this.data);if(null===a||void 0===a?0:a.textPath)a.textPath=
b}};d.prototype.generatePoints=function(){var a;h.generatePoints.apply(this,arguments);this.options.nodes&&this.options.nodes.forEach(function(a){this.nodeLookup[a.id]||(this.nodeLookup[a.id]=this.createNode(a.id))},this);for(a=this.nodes.length-1;0<=a;a--){var b=this.nodes[a];b.degree=b.getDegree();b.radius=B(b.marker&&b.marker.radius,this.options.marker&&this.options.marker.radius,0);this.nodeLookup[b.id]||b.remove()}this.data.forEach(function(a){a.formatPrefix="link"});this.indexateNodes()};d.prototype.getPointsCollection=
function(){return this.nodes||[]};d.prototype.indexateNodes=function(){this.nodes.forEach(function(a,b){a.index=b})};d.prototype.init=function(a,b){var d=this;c.prototype.init.call(this,a,b);v.call(this);x(this,"updatedData",function(){d.layout&&d.layout.stop()});x(this,"afterUpdate",function(){d.nodes.forEach(function(a){a&&a.series&&a.resolveColor()})});x(this,"afterSimulation",function(){this.deferDataLabels=!1;this.drawDataLabels()});return this};d.prototype.markerAttribs=function(a,b){b=q.prototype.markerAttribs.call(this,
a,b);A(a.plotY)||(b.y=0);b.x=(a.plotX||0)-(b.width||0)/2;return b};d.prototype.pointAttribs=function(a,b){var c=b||a&&a.state||"normal";b=q.prototype.pointAttribs.call(this,a,c);c=this.options.states[c];a&&!a.isNode&&(b=a.getLinkAttributes(),c&&(b={stroke:c.linkColor||b.stroke,dashstyle:c.linkDashStyle||b.dashstyle,opacity:B(c.linkOpacity,b.opacity),"stroke-width":c.linkColor||b["stroke-width"]}));return b};d.prototype.render=function(){var a=this.points,b=this.chart.hoverPoint,c=[];this.points=this.nodes;
k.render.call(this);this.points=a;a.forEach(function(a){a.fromNode&&a.toNode&&(a.renderLink(),a.redrawLink())});b&&b.series===this&&this.redrawHalo(b);this.chart.hasRendered&&!this.options.dataLabels.allowOverlap&&(this.nodes.concat(this.points).forEach(function(a){a.dataLabel&&c.push(a.dataLabel)}),this.chart.hideOverlappingLabels(c))};d.prototype.setState=function(a,b){b?(this.points=this.nodes.concat(this.data),q.prototype.setState.apply(this,arguments),this.points=this.data):q.prototype.setState.apply(this,
arguments);this.layout.simulation||a||this.render()};d.prototype.translate=function(){this.processedXData||this.processData();this.generatePoints();this.deferLayout();this.nodes.forEach(function(a){a.isInside=!0;a.linksFrom.forEach(function(a){a.shapeType="path";a.y=1})})};d.defaultOptions=D(q.defaultOptions,f);return d}(q);m(p.prototype,{pointClass:d,animate:void 0,directTouch:!0,drawGraph:void 0,forces:["barycenter","repulsive","attractive"],hasDraggableNodes:!0,isCartesian:!1,noSharedTooltip:!0,
pointArrayMap:["from","to"],requireSorting:!1,trackerGroups:["group","markerGroup","dataLabelsGroup"],initDataLabels:t,buildKDTree:c,createNode:h.createNode,drawTracker:g.drawTracker,onMouseDown:b.onMouseDown,onMouseMove:b.onMouseMove,onMouseUp:b.onMouseUp,redrawHalo:b.redrawHalo});l.registerSeriesType("networkgraph",p);"";return p});l(d,"masters/modules/networkgraph.src.js",[d["Core/Globals.js"],d["Series/Networkgraph/NetworkgraphSeries.js"]],function(b,a){a.compose(b.Chart)})});
//# sourceMappingURL=networkgraph.js.map