/*
 Highmaps JS v11.0.0 (2023-04-26)

 Highmaps as a plugin for Highcharts or Highcharts Stock.

 (c) 2011-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(x){c(x);c.Highcharts=x;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function x(c,k,q,m){c.hasOwnProperty(k)||(c[k]=m.apply(null,q),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:k,module:c[k]}})))}c=c?c._modules:
{};x(c,"Core/Axis/Color/ColorAxisComposition.js",[c["Core/Color/Color.js"],c["Core/Utilities.js"]],function(c,k){var q=c.parse,m=k.addEvent,p=k.extend,f=k.merge,d=k.pick,w=k.splat,r;(function(l){function u(){var h=this,a=this.options;this.colorAxis=[];a.colorAxis&&(a.colorAxis=w(a.colorAxis),a.colorAxis.forEach(function(a,g){a.index=g;new r(h,a)}))}function b(h){var a=this,g=function(g){g=h.allItems.indexOf(g);-1!==g&&(a.destroyItem(h.allItems[g]),h.allItems.splice(g,1))},b=[],v,e;(this.chart.colorAxis||
[]).forEach(function(h){(v=h.options)&&v.showInLegend&&(v.dataClasses&&v.visible?b=b.concat(h.getDataClassLegendSymbols()):v.visible&&b.push(h),h.series.forEach(function(h){if(!h.options.showInLegend||v.dataClasses)"point"===h.options.legendType?h.points.forEach(function(h){g(h)}):g(h)}))});for(e=b.length;e--;)h.allItems.unshift(b[e])}function a(h){h.visible&&h.item.legendColor&&h.item.legendItem.symbol.attr({fill:h.item.legendColor})}function e(){var h=this.chart.colorAxis;h&&h.forEach(function(h,
a,g){h.update({},g)})}function t(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function n(){var h=this.axisTypes;h?-1===h.indexOf("colorAxis")&&h.push("colorAxis"):this.axisTypes=["colorAxis"]}function g(h){var g=this,a=h?"show":"hide";g.visible=g.options.visible=!!h;["graphic","dataLabel"].forEach(function(h){if(g[h])g[h][a]()});this.series.buildKDTree()}function A(){var h=this,g=this.options.nullColor,a=this.colorAxis,b=this.colorKey;(this.data.length?
this.data:this.points).forEach(function(v){var e=v.getNestedProperty(b);(e=v.options.color||(v.isNull||null===v.value?g:a&&"undefined"!==typeof e?a.toColor(e,v):v.color||h.color))&&v.color!==e&&(v.color=e,"point"===h.options.legendType&&v.legendItem&&v.legendItem.label&&h.chart.legend.colorizeItem(v,v.visible))})}function z(h){var g=h.prototype.createAxis;h.prototype.createAxis=function(h,a){if("colorAxis"!==h)return g.apply(this,arguments);var b=new r(this,f(a.axis,{index:this[h].length,isX:!1}));
this.isDirtyLegend=!0;this.axes.forEach(function(h){h.series=[]});this.series.forEach(function(h){h.bindAxes();h.isDirtyData=!0});d(a.redraw,!0)&&this.redraw(a.animation);return b}}function h(){this.elem.attr("fill",q(this.start).tweenTo(q(this.end),this.pos),void 0,!0)}function y(){this.elem.attr("stroke",q(this.start).tweenTo(q(this.end),this.pos),void 0,!0)}var C=[],r;l.compose=function(l,d,f,B,v){r||(r=l);k.pushUnique(C,d)&&(l=d.prototype,l.collectionsWithUpdate.push("colorAxis"),l.collectionsWithInit.colorAxis=
[l.addColorAxis],m(d,"afterGetAxes",u),z(d));k.pushUnique(C,f)&&(d=f.prototype,d.fillSetter=h,d.strokeSetter=y);k.pushUnique(C,B)&&(m(B,"afterGetAllItems",b),m(B,"afterColorizeItem",a),m(B,"afterUpdate",e));k.pushUnique(C,v)&&(p(v.prototype,{optionalAxis:"colorAxis",translateColors:A}),p(v.prototype.pointClass.prototype,{setVisible:g}),m(v,"afterTranslate",t,{order:1}),m(v,"bindAxes",n))};l.pointSetVisible=g})(r||(r={}));return r});x(c,"Core/Axis/Color/ColorAxisDefaults.js",[],function(){return{lineWidth:0,
minPadding:0,maxPadding:0,gridLineColor:"#ffffff",gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{distance:8,overflow:"justify",rotation:0},minColor:"#e6e9ff",maxColor:"#0022ff",tickLength:5,showInLegend:!0}});x(c,"Core/Axis/Color/ColorAxis.js",[c["Core/Axis/Axis.js"],c["Core/Color/Color.js"],c["Core/Axis/Color/ColorAxisComposition.js"],c["Core/Axis/Color/ColorAxisDefaults.js"],c["Core/Legend/LegendSymbol.js"],
c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,q,m,p,f,d){var w=this&&this.__extends||function(){var a=function(b,g){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,g){a.__proto__=g}||function(a,g){for(var h in g)Object.prototype.hasOwnProperty.call(g,h)&&(a[h]=g[h])};return a(b,g)};return function(b,g){function e(){this.constructor=b}if("function"!==typeof g&&null!==g)throw new TypeError("Class extends value "+String(g)+" is not a constructor or null");
a(b,g);b.prototype=null===g?Object.create(g):(e.prototype=g.prototype,new e)}}(),r=k.parse,l=f.series,u=d.extend,b=d.isNumber,a=d.merge,e=d.pick;k=function(t){function n(a,b){var g=t.call(this,a,b)||this;g.beforePadding=!1;g.chart=void 0;g.coll="colorAxis";g.dataClasses=void 0;g.options=void 0;g.stops=void 0;g.visible=!0;g.init(a,b);return g}w(n,t);n.compose=function(g,a,b,h){q.compose(n,g,a,b,h)};n.prototype.init=function(g,b){var e=g.options.legend||{},h=b.layout?"vertical"!==b.layout:"vertical"!==
e.layout,A=b.visible;e=a(n.defaultColorAxisOptions,b,{showEmpty:!1,title:null,visible:e.enabled&&!1!==A});this.coll="colorAxis";this.side=b.side||h?2:1;this.reversed=b.reversed||!h;this.opposite=!h;t.prototype.init.call(this,g,e);this.userOptions.visible=A;b.dataClasses&&this.initDataClasses(b);this.initStops();this.horiz=h;this.zoomEnabled=!1};n.prototype.initDataClasses=function(g){var b=this.chart,e=this.legendItem=this.legendItem||{},h=g.dataClasses.length,t=this.options,n,l=0,d=b.options.chart.colorCount;
this.dataClasses=n=[];e.labels=[];(g.dataClasses||[]).forEach(function(g,e){g=a(g);n.push(g);if(b.styledMode||!g.color)"category"===t.dataClassColor?(b.styledMode||(e=b.options.colors,d=e.length,g.color=e[l]),g.colorIndex=l,l++,l===d&&(l=0)):g.color=r(t.minColor).tweenTo(r(t.maxColor),2>h?.5:e/(h-1))})};n.prototype.hasData=function(){return!!(this.tickPositions||[]).length};n.prototype.setTickPositions=function(){if(!this.dataClasses)return t.prototype.setTickPositions.call(this)};n.prototype.initStops=
function(){this.stops=this.options.stops||[[0,this.options.minColor],[1,this.options.maxColor]];this.stops.forEach(function(g){g.color=r(g[1])})};n.prototype.setOptions=function(g){t.prototype.setOptions.call(this,g);this.options.crosshair=this.options.marker};n.prototype.setAxisSize=function(){var g=this.legendItem&&this.legendItem.symbol,a=this.chart,b=a.options.legend||{},h,e;g?(this.left=b=g.attr("x"),this.top=h=g.attr("y"),this.width=e=g.attr("width"),this.height=g=g.attr("height"),this.right=
a.chartWidth-b-e,this.bottom=a.chartHeight-h-g,this.len=this.horiz?e:g,this.pos=this.horiz?b:h):this.len=(this.horiz?b.symbolWidth:b.symbolHeight)||n.defaultLegendLength};n.prototype.normalizedValue=function(g){this.logarithmic&&(g=this.logarithmic.log2lin(g));return 1-(this.max-g)/(this.max-this.min||1)};n.prototype.toColor=function(g,a){var b=this.dataClasses,h=this.stops,e;if(b)for(e=b.length;e--;){var t=b[e];var n=t.from;h=t.to;if(("undefined"===typeof n||g>=n)&&("undefined"===typeof h||g<=h)){var A=
t.color;a&&(a.dataClass=e,a.colorIndex=t.colorIndex);break}}else{g=this.normalizedValue(g);for(e=h.length;e--&&!(g>h[e][0]););n=h[e]||h[e+1];h=h[e+1]||n;g=1-(h[0]-g)/(h[0]-n[0]||1);A=n.color.tweenTo(h.color,g)}return A};n.prototype.getOffset=function(){var g=this.legendItem&&this.legendItem.group,a=this.chart.axisOffset[this.side];if(g){this.axisParent=g;t.prototype.getOffset.call(this);var b=this.chart.legend;b.allItems.forEach(function(h){h instanceof n&&h.drawLegendSymbol(b,h)});b.render();this.chart.getMargins(!0);
this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width);this.chart.axisOffset[this.side]=a}};n.prototype.setLegendColor=function(){var a=this.reversed,b=a?1:0;a=a?0:1;b=this.horiz?[b,0,a,0]:[0,a,0,b];this.legendColor={linearGradient:{x1:b[0],y1:b[1],x2:b[2],y2:b[3]},stops:this.stops}};n.prototype.drawLegendSymbol=function(a,b){var g;b=b.legendItem||{};var h=a.padding,t=a.options,l=this.options.labels,A=e(t.itemDistance,10),d=this.horiz,r=e(t.symbolWidth,d?n.defaultLegendLength:12),
u=e(t.symbolHeight,d?12:n.defaultLegendLength),f=e(t.labelPadding,d?16:30);this.setLegendColor();b.symbol||(b.symbol=this.chart.renderer.symbol("roundedRect",0,a.baseline-11,r,u,{r:null!==(g=t.symbolRadius)&&void 0!==g?g:3}).attr({zIndex:1}).add(b.group));b.labelWidth=r+h+(d?A:e(l.x,l.distance)+this.maxLabelLength);b.labelHeight=u+h+(d?f:0)};n.prototype.setState=function(b){this.series.forEach(function(a){a.setState(b)})};n.prototype.setVisible=function(){};n.prototype.getSeriesExtremes=function(){var b=
this.series,a=b.length,t;this.dataMin=Infinity;for(this.dataMax=-Infinity;a--;){var h=b[a];var n=h.colorKey=e(h.options.colorKey,h.colorKey,h.pointValKey,h.zoneAxis,"y");var d=h.pointArrayMap;var r=h[n+"Min"]&&h[n+"Max"];if(h[n+"Data"])var u=h[n+"Data"];else if(d){u=[];d=d.indexOf(n);var f=h.yData;if(0<=d&&f)for(t=0;t<f.length;t++)u.push(e(f[t][d],f[t]))}else u=h.yData;r?(h.minColorValue=h[n+"Min"],h.maxColorValue=h[n+"Max"]):(u=l.prototype.getExtremes.call(h,u),h.minColorValue=u.dataMin,h.maxColorValue=
u.dataMax);"undefined"!==typeof h.minColorValue&&(this.dataMin=Math.min(this.dataMin,h.minColorValue),this.dataMax=Math.max(this.dataMax,h.maxColorValue));r||l.prototype.applyExtremes.call(h)}};n.prototype.drawCrosshair=function(b,a){var g=this.legendItem||{},h=a&&a.plotX,e=a&&a.plotY,n=this.pos,l=this.len;if(a){var d=this.toPixels(a.getNestedProperty(a.series.colorKey));d<n?d=n-2:d>n+l&&(d=n+l+2);a.plotX=d;a.plotY=this.len-d;t.prototype.drawCrosshair.call(this,b,a);a.plotX=h;a.plotY=e;this.cross&&
!this.cross.addedToColorAxis&&g.group&&(this.cross.addClass("highcharts-coloraxis-marker").add(g.group),this.cross.addedToColorAxis=!0,this.chart.styledMode||"object"!==typeof this.crosshair||this.cross.attr({fill:this.crosshair.color}))}};n.prototype.getPlotLinePath=function(a){var g=this.left,e=a.translatedValue,h=this.top;return b(e)?this.horiz?[["M",e-4,h-6],["L",e+4,h-6],["L",e,h],["Z"]]:[["M",g,e],["L",g-6,e+6],["L",g-6,e-6],["Z"]]:t.prototype.getPlotLinePath.call(this,a)};n.prototype.update=
function(a,b){var g=this.chart.legend;this.series.forEach(function(a){a.isDirtyData=!0});(a.dataClasses&&g.allItems||this.dataClasses)&&this.destroyItems();t.prototype.update.call(this,a,b);this.legendItem&&this.legendItem.label&&(this.setLegendColor(),g.colorizeItem(this,!0))};n.prototype.destroyItems=function(){var a=this.chart,b=this.legendItem||{};if(b.label)a.legend.destroyItem(this);else if(b.labels){var e=0;for(b=b.labels;e<b.length;e++)a.legend.destroyItem(b[e])}a.isDirtyLegend=!0};n.prototype.destroy=
function(){this.chart.isDirtyLegend=!0;this.destroyItems();t.prototype.destroy.apply(this,[].slice.call(arguments))};n.prototype.remove=function(a){this.destroyItems();t.prototype.remove.call(this,a)};n.prototype.getDataClassLegendSymbols=function(){var a=this,b=a.chart,t=a.legendItem&&a.legendItem.labels||[],h=b.options.legend,n=e(h.valueDecimals,-1),d=e(h.valueSuffix,""),l=function(b){return a.series.reduce(function(a,h){a.push.apply(a,h.points.filter(function(a){return a.dataClass===b}));return a},
[])},r;t.length||a.dataClasses.forEach(function(h,e){var g=h.from,v=h.to,F=b.numberFormatter,z=!0;r="";"undefined"===typeof g?r="< ":"undefined"===typeof v&&(r="> ");"undefined"!==typeof g&&(r+=F(g,n)+d);"undefined"!==typeof g&&"undefined"!==typeof v&&(r+=" - ");"undefined"!==typeof v&&(r+=F(v,n)+d);t.push(u({chart:b,name:r,options:{},drawLegendSymbol:p.drawRectangle,visible:!0,isDataClass:!0,setState:function(a){for(var b=0,h=l(e);b<h.length;b++)h[b].setState(a)},setVisible:function(){this.visible=
z=a.visible=!z;for(var h=0,g=l(e);h<g.length;h++)g[h].setVisible(z);b.legend.colorizeItem(this,z)}},h))});return t};n.defaultColorAxisOptions=m;n.defaultLegendLength=200;n.keepProps=["legendItem"];return n}(c);Array.prototype.push.apply(c.keepProps,k.keepProps);"";return k});x(c,"Maps/MapNavigationDefaults.js",[c["Core/Defaults.js"],c["Core/Utilities.js"]],function(c,k){k=k.extend;var q={buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",x:0,width:18,height:18,padding:5,style:{color:"#666666",
fontSize:"1em",fontWeight:"bold"},theme:{fill:"#ffffff",stroke:"#e6e6e6","stroke-width":1,"text-align":"center"}},buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1};k(c.defaultOptions.lang,{zoomIn:"Zoom in",zoomOut:"Zoom out"});return c.defaultOptions.mapNavigation=q});x(c,"Maps/MapNavigation.js",[c["Core/Chart/Chart.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,k,q){function m(a){a&&
(a.preventDefault&&a.preventDefault(),a.stopPropagation&&a.stopPropagation(),a.cancelBubble=!0)}function p(a){this.navButtons=[];this.init(a)}var f=k.doc,d=q.addEvent,w=q.extend,r=q.isNumber,l=q.merge,u=q.objectEach,b=q.pick;p.prototype.init=function(a){this.chart=a};p.prototype.update=function(a){var e=this,t=this.chart,n=t.options.mapNavigation,g,r=function(a){this.handler.call(t,a);m(a)},z=e.navButtons;a&&(n=t.options.mapNavigation=l(t.options.mapNavigation,a));for(;z.length;)z.pop().destroy();
b(n.enableButtons,n.enabled)&&!t.renderer.forExport&&(e.navButtonsGroup||(e.navButtonsGroup=t.renderer.g().attr({zIndex:4}).add()),u(n.buttons,function(a,b){var h;a=l(n.buttonOptions,a);!t.styledMode&&a.theme&&(g=a.theme,g.style=l(a.theme.style,a.style));var u=a.text,f=a.width,A=void 0===f?0:f;f=a.height;f=void 0===f?0:f;var y=a.padding;y=void 0===y?0:y;var c=t.renderer.button("+"!==u&&"-"!==u&&u||"",0,0,r,g,void 0,void 0,void 0,"zoomIn"===b?"topbutton":"bottombutton").addClass("highcharts-map-navigation highcharts-"+
{zoomIn:"zoom-in",zoomOut:"zoom-out"}[b]).attr({width:A,height:f,title:t.options.lang[b],padding:a.padding,zIndex:5}).add(e.navButtonsGroup);if("+"===u||"-"===u)b=A+1,A=[["M",y+3,y+f/2],["L",y+b-3,y+f/2]],"+"===u&&A.push(["M",y+b/2,y+3],["L",y+b/2,y+f-3]),t.renderer.path(A).addClass("highcharts-button-symbol").attr(t.styledMode?{}:{stroke:null===(h=a.style)||void 0===h?void 0:h.color,"stroke-width":3,"stroke-linecap":"round"}).add(c);c.handler=a.onclick;d(c.element,"dblclick",m);z.push(c);w(a,{width:c.width,
height:2*c.height});if(t.hasLoaded)c.align(a,!1,a.alignTo);else var v=d(t,"load",function(){c.element&&c.align(a,!1,a.alignTo);v()})}),a=function(){var a=t.exportingGroup&&t.exportingGroup.getBBox();if(a){var b=e.navButtonsGroup.getBBox();if(!(b.x>=a.x+a.width||b.x+b.width<=a.x||b.y>=a.y+a.height||b.y+b.height<=a.y)){var g=-b.y-b.height+a.y-5;a=a.y+a.height-b.y+5;e.navButtonsGroup.attr({translateY:"bottom"===(n.buttonOptions&&n.buttonOptions.verticalAlign)?g:a})}}},t.hasLoaded||d(t,"render",a));this.updateEvents(n)};
p.prototype.updateEvents=function(a){var e=this.chart;b(a.enableDoubleClickZoom,a.enabled)||a.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||d(e.container,"dblclick",function(a){e.pointer.onContainerDblClick(a)}):this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick());b(a.enableMouseWheelZoom,a.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||d(e.container,void 0!==f.onwheel?"wheel":void 0!==f.onmousewheel?"mousewheel":"DOMMouseScroll",function(a){e.pointer.inClass(a.target,
"highcharts-no-mousewheel")||(e.pointer.onContainerMouseWheel(a),m(a));return!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())};w(c.prototype,{fitToBox:function(a,b){[["x","width"],["y","height"]].forEach(function(e){var n=e[0];e=e[1];a[n]+a[e]>b[n]+b[e]&&(a[e]>b[e]?(a[e]=b[e],a[n]=b[n]):a[n]=b[n]+b[e]-a[e]);a[e]>b[e]&&(a[e]=b[e]);a[n]<b[n]&&(a[n]=b[n])});return a},mapZoom:function(a,b,t,n,g){this.mapView&&(r(a)&&(a=Math.log(a)/Math.log(.5)),this.mapView.zoomBy(a,r(b)&&r(t)?
this.mapView.projection.inverse([b,t]):void 0,r(n)&&r(g)?[n,g]:void 0))}});d(c,"beforeRender",function(){this.mapNavigation=new p(this);this.mapNavigation.update()});k.MapNavigation=p});x(c,"Maps/MapPointer.js",[c["Core/Pointer.js"],c["Core/Utilities.js"]],function(c,k){var q=k.defined,m=k.extend,p=k.pick;k=k.wrap;var f=c.prototype.normalize,d=0,w;m(c.prototype,{normalize:function(d,l){var u=this.chart;d=f.call(this,d,l);u&&u.mapView&&(l=u.mapView.pixelsToLonLat({x:d.chartX-u.plotLeft,y:d.chartY-
u.plotTop}))&&m(d,l);return d},onContainerDblClick:function(d){var l=this.chart;d=this.normalize(d);l.options.mapNavigation.enableDoubleClickZoomTo?l.pointer.inClass(d.target,"highcharts-tracker")&&l.hoverPoint&&l.hoverPoint.zoomTo():l.isInsidePlot(d.chartX-l.plotLeft,d.chartY-l.plotTop)&&l.mapZoom(.5,void 0,void 0,d.chartX,d.chartY)},onContainerMouseWheel:function(f){var l=this.chart;f=this.normalize(f);var u=q(f.wheelDelta)&&-f.wheelDelta/120||f.deltaY||f.detail;1<=Math.abs(u)&&(d+=Math.abs(u),
w&&clearTimeout(w),w=setTimeout(function(){d=0},50));10>d&&l.isInsidePlot(f.chartX-l.plotLeft,f.chartY-l.plotTop)&&l.mapView&&l.mapView.zoomBy((l.options.mapNavigation.mouseWheelSensitivity-1)*-u,void 0,[f.chartX,f.chartY],1>Math.abs(u)?!1:void 0)}});k(c.prototype,"zoomOption",function(d){var l=this.chart.options.mapNavigation;p(l.enableTouchZoom,l.enabled)&&(this.chart.options.chart.zooming.pinchType="xy");d.apply(this,[].slice.call(arguments,1))});k(c.prototype,"pinchTranslate",function(d,l,f,b,
a,e,t){d.call(this,l,f,b,a,e,t);"map"===this.chart.options.chart.type&&this.hasZoom&&(d=b.scaleX>b.scaleY,this.pinchTranslateDirection(!d,l,f,b,a,e,t,d?b.scaleX:b.scaleY))})});x(c,"Series/ColorMapComposition.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k){var q=c.seriesTypes.column.prototype,m=k.addEvent,p=k.defined,f;(function(d){function f(d){this.moveToTopOnHover&&this.graphic&&this.graphic.attr({zIndex:d&&"hover"===d.state?1:0})}var c=[];d.pointMembers={dataLabelOnNull:!0,
moveToTopOnHover:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value&&(void 0===this.value||!isNaN(this.value))}};d.seriesMembers={colorKey:"value",axisTypes:["xAxis","yAxis","colorAxis"],parallelArrays:["x","y","value"],pointArrayMap:["value"],trackerGroups:["group","markerGroup","dataLabelsGroup"],colorAttribs:function(d){var l={};!p(d.color)||d.state&&"normal"!==d.state||(l[this.colorProp||"fill"]=d.color);return l},pointAttribs:q.pointAttribs};d.compose=
function(d){var l=d.prototype.pointClass;k.pushUnique(c,l)&&m(l,"afterSetState",f);return d}})(f||(f={}));return f});x(c,"Maps/MapSymbols.js",[c["Core/Renderer/SVG/SVGRenderer.js"]],function(c){var k=c.prototype.symbols;k.bottombutton=function(c,m,p,f,d){if(d){var q=(null===d||void 0===d?void 0:d.r)||0;d.brBoxY=m-q;d.brBoxHeight=f+q}return k.roundedRect(c,m,p,f,d)};k.topbutton=function(c,m,p,f,d){d&&(d.brBoxHeight=f+((null===d||void 0===d?void 0:d.r)||0));return k.roundedRect(c,m,p,f,d)};return k});
x(c,"Core/Chart/MapChart.js",[c["Core/Chart/Chart.js"],c["Core/Defaults.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,k,q,m){var p=this&&this.__extends||function(){var d=function(l,f){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var e in a)Object.prototype.hasOwnProperty.call(a,e)&&(b[e]=a[e])};return d(l,f)};return function(l,f){function b(){this.constructor=l}if("function"!==typeof f&&null!==f)throw new TypeError("Class extends value "+
String(f)+" is not a constructor or null");d(l,f);l.prototype=null===f?Object.create(f):(b.prototype=f.prototype,new b)}}(),f=k.getOptions,d=m.merge,w=m.pick;c=function(c){function l(){return null!==c&&c.apply(this,arguments)||this}p(l,c);l.prototype.init=function(l,b){var a=f().credits;l=d({chart:{panning:{enabled:!0,type:"xy"},type:"map"},credits:{mapText:w(a.mapText,' \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>'),mapTextFull:w(a.mapTextFull,"{geojson.copyright}")},mapView:{},
tooltip:{followTouchMove:!1}},l);c.prototype.init.call(this,l,b)};return l}(c);(function(d){d.maps={};d.mapChart=function(l,f,b){return new d(l,f,b)};d.splitPath=function(d){"string"===typeof d&&(d=d.replace(/([A-Za-z])/g," $1 ").replace(/^\s*/,"").replace(/\s*$/,""),d=d.split(/[ ,;]+/).map(function(d){return/[A-za-z]/.test(d)?d:parseFloat(d)}));return q.prototype.pathToSegments(d)}})(c||(c={}));return c});x(c,"Maps/MapUtilities.js",[],function(){return{boundsFromPath:function(c){var k=-Number.MAX_VALUE,
q=Number.MAX_VALUE,m=-Number.MAX_VALUE,p=Number.MAX_VALUE,f;c.forEach(function(d){var c=d[d.length-2];d=d[d.length-1];"number"===typeof c&&"number"===typeof d&&(q=Math.min(q,c),k=Math.max(k,c),p=Math.min(p,d),m=Math.max(m,d),f=!0)});if(f)return{x1:q,y1:p,x2:k,y2:m}},pointInPolygon:function(c,k){var q,m=!1,p=c.x,f=c.y;c=0;for(q=k.length-1;c<k.length;q=c++){var d=k[c][1]>f;var w=k[q][1]>f;d!==w&&p<(k[q][0]-k[c][0])*(f-k[c][1])/(k[q][1]-k[c][1])+k[c][0]&&(m=!m)}return m}}});x(c,"Series/Map/MapPoint.js",
[c["Series/ColorMapComposition.js"],c["Maps/MapUtilities.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,q,m){var p=this&&this.__extends||function(){var d=function(c,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var e in b)Object.prototype.hasOwnProperty.call(b,e)&&(a[e]=b[e])};return d(c,b)};return function(c,b){function a(){this.constructor=c}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+
String(b)+" is not a constructor or null");d(c,b);c.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),f=k.boundsFromPath,d=m.extend,w=m.isNumber,r=m.pick;k=function(c){function l(){var b=null!==c&&c.apply(this,arguments)||this;b.options=void 0;b.path=void 0;b.series=void 0;return b}p(l,c);l.getProjectedPath=function(b,a){b.projectedPath||(a&&b.geometry?(a.hasCoordinates=!0,b.projectedPath=a.path(b.geometry)):b.projectedPath=b.path);return b.projectedPath||[]};l.prototype.applyOptions=
function(b,a){var e=this.series;b=c.prototype.applyOptions.call(this,b,a);a=e.joinBy;e.mapData&&e.mapMap&&(a=c.prototype.getNestedProperty.call(b,a[1]),(a="undefined"!==typeof a&&e.mapMap[a])?d(b,a):-1!==e.pointArrayMap.indexOf("value")&&(b.value=b.value||null));return b};l.prototype.getProjectedBounds=function(b){b=l.getProjectedPath(this,b);b=f(b);var a=this.properties,e=this.series.chart.mapView;if(b){var d=a&&a["hc-middle-lon"],n=a&&a["hc-middle-lat"];if(e&&w(d)&&w(n)){if(a=e.lonLatToProjectedUnits({lon:d,
lat:n}))b.midX=a.x,b.midY=a.y}else e=a&&a["hc-middle-x"],a=a&&a["hc-middle-y"],b.midX=b.x1+(b.x2-b.x1)*r(this.middleX,w(e)?e:.5),a=r(this.middleY,w(a)?a:.5),this.geometry||(a=1-a),b.midY=b.y2-(b.y2-b.y1)*a;return b}};l.prototype.onMouseOver=function(b){m.clearTimeout(this.colorInterval);if(!this.isNull&&this.visible||this.series.options.nullInteraction)c.prototype.onMouseOver.call(this,b);else this.series.onMouseOut(b)};l.prototype.setVisible=function(b){var a=b?"show":"hide";this.visible=this.options.visible=
!!b;if(this.dataLabel)this.dataLabel[a]();this.graphic&&this.graphic.attr(this.series.pointAttribs(this))};l.prototype.zoomTo=function(b){var a=this.series.chart,e=a.mapView,d=this.bounds;if(e&&d){var n=w(this.insetIndex)&&e.insets[this.insetIndex];if(n){var g=n.projectedUnitsToPixels({x:d.x1,y:d.y1});d=n.projectedUnitsToPixels({x:d.x2,y:d.y2});g=e.pixelsToProjectedUnits({x:g.x,y:g.y});d=e.pixelsToProjectedUnits({x:d.x,y:d.y});d={x1:g.x,y1:g.y,x2:d.x,y2:d.y}}e.fitToBounds(d,void 0,!1);this.series.isDirty=
!0;a.redraw(b)}};return l}(q.seriesTypes.scatter.prototype.pointClass);d(k.prototype,{dataLabelOnNull:c.pointMembers.dataLabelOnNull,moveToTopOnHover:c.pointMembers.moveToTopOnHover,isValid:c.pointMembers.isValid});return k});x(c,"Maps/MapViewOptionsDefault.js",[],function(){return{center:[0,0],fitToGeometry:void 0,maxZoom:void 0,padding:0,projection:{name:void 0,parallels:void 0,rotation:void 0},zoom:void 0}});x(c,"Maps/MapViewInsetsOptionsDefault.js",[],function(){return{borderColor:"#cccccc",borderWidth:1,
center:[0,0],padding:"10%",relativeTo:"mapBoundingBox",units:"percent"}});x(c,"Extensions/GeoJSON.js",[c["Core/Chart/Chart.js"],c["Core/FormatUtilities.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,k,q,m){function p(b,a){a||(a=Object.keys(b.objects)[0]);a=b.objects[a];if(a["hc-decoded-geojson"])return a["hc-decoded-geojson"];var e=b.arcs;if(b.transform){var d=b.transform,n=d.scale,g=d.translate;e=b.arcs.map(function(a){var b=0,e=0;return a.map(function(a){a=a.slice();a[0]=(b+=a[0])*
n[0]+g[0];a[1]=(e+=a[1])*n[1]+g[1];return a})})}var c=function(a){return"number"===typeof a[0]?a.reduce(function(a,b,g){var h=0>b?e[~b]:e[b];0>b?(h=h.slice(0,0===g?h.length:h.length-1),h.reverse()):g&&(h=h.slice(1));return a.concat(h)},[]):a.map(c)};d=a.geometries.map(function(a){return{type:"Feature",properties:a.properties,geometry:{type:a.type,coordinates:a.coordinates||c(a.arcs)}}});b={type:"FeatureCollection",copyright:b.copyright,copyrightShort:b.copyrightShort,copyrightUrl:b.copyrightUrl,features:d,
"hc-recommended-mapview":a["hc-recommended-mapview"],bbox:b.bbox,title:b.title};return a["hc-decoded-geojson"]=b}function f(b,a,e){void 0===a&&(a="map");var c=[];b="Topology"===b.type?p(b):b;b.features.forEach(function(b){var e=b.geometry||{},d=e.type;e=e.coordinates;b=b.properties;var n;"map"!==a&&"mapbubble"!==a||"Polygon"!==d&&"MultiPolygon"!==d?"mapline"!==a||"LineString"!==d&&"MultiLineString"!==d?"mappoint"===a&&"Point"===d&&e.length&&(n={geometry:{coordinates:e,type:d}}):e.length&&(n={geometry:{coordinates:e,
type:d}}):e.length&&(n={geometry:{coordinates:e,type:d}});if(n){d=b&&(b.name||b.NAME);e=b&&b.lon;var h=b&&b.lat;c.push(l(n,{lat:"number"===typeof h?h:void 0,lon:"number"===typeof e?e:void 0,name:"string"===typeof d?d:void 0,properties:b}))}});e&&b.copyrightShort&&(e.chart.mapCredits=d(e.chart.options.credits.mapText,{geojson:b}),e.chart.mapCreditsFull=d(e.chart.options.credits.mapTextFull,{geojson:b}));return c}var d=k.format,w=q.win,r=m.error,l=m.extend,u=m.merge;k=m.wrap;"";c.prototype.transformFromLatLon=
function(b,a){var e=this.options.chart.proj4||w.proj4;if(e){var d=a.jsonmarginX;d=void 0===d?0:d;var n=a.jsonmarginY;n=void 0===n?0:n;var g=a.jsonres;g=void 0===g?1:g;var c=a.scale;c=void 0===c?1:c;var f=a.xoffset;f=void 0===f?0:f;var h=a.xpan;h=void 0===h?0:h;var l=a.yoffset;l=void 0===l?0:l;var p=a.ypan;p=void 0===p?0:p;b=e(a.crs,[b.lon,b.lat]);e=a.cosAngle||a.rotation&&Math.cos(a.rotation);var m=a.sinAngle||a.rotation&&Math.sin(a.rotation);a=a.rotation?[b[0]*e+b[1]*m,-b[0]*m+b[1]*e]:b;return{x:((a[0]-
f)*c+h)*g+d,y:-(((l-a[1])*c+p)*g-n)}}r(21,!1,this)};c.prototype.transformToLatLon=function(b,a){var e=this.options.chart.proj4||w.proj4;if(!e)r(21,!1,this);else if(null!==b.y){var d=a.jsonmarginX,n=a.jsonmarginY,g=a.jsonres;g=void 0===g?1:g;var c=a.scale;c=void 0===c?1:c;var f=a.xoffset,h=a.xpan,l=a.yoffset,p=a.ypan;b={x:((b.x-(void 0===d?0:d))/g-(void 0===h?0:h))/c+(void 0===f?0:f),y:((b.y-(void 0===n?0:n))/g+(void 0===p?0:p))/c+(void 0===l?0:l)};d=a.cosAngle||a.rotation&&Math.cos(a.rotation);n=
a.sinAngle||a.rotation&&Math.sin(a.rotation);a=e(a.crs,"WGS84",a.rotation?{x:b.x*d+b.y*-n,y:b.x*n+b.y*d}:b);return{lat:a.y,lon:a.x}}};c.prototype.fromPointToLatLon=function(b){return this.mapView&&this.mapView.projectedUnitsToLonLat(b)};c.prototype.fromLatLonToPoint=function(b){return this.mapView&&this.mapView.lonLatToProjectedUnits(b)};k(c.prototype,"addCredits",function(b,a){a=u(!0,this.options.credits,a);this.mapCredits&&(a.href=null);b.call(this,a);this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})});
q.geojson=f;q.topo2geo=p;return{geojson:f,topo2geo:p}});x(c,"Core/Geometry/PolygonClip.js",[],function(){var c=function(c,p,f){return(p[0]-c[0])*(f[1]-c[1])>(p[1]-c[1])*(f[0]-c[0])},k=function(c,p,f,d){var k=[c[0]-p[0],c[1]-p[1]],r=[f[0]-d[0],f[1]-d[1]];c=c[0]*p[1]-c[1]*p[0];f=f[0]*d[1]-f[1]*d[0];d=1/(k[0]*r[1]-k[1]*r[0]);k=[(c*r[0]-f*k[0])*d,(c*r[1]-f*k[1])*d];k.isIntersection=!0;return k},q;(function(m){m.clipLineString=function(c,f){var d=[];c=m.clipPolygon(c,f,!1);for(f=1;f<c.length;f++)c[f].isIntersection&&
c[f-1].isIntersection&&(d.push(c.splice(0,f)),f=0),f===c.length-1&&d.push(c);return d};m.clipPolygon=function(p,f,d){void 0===d&&(d=!0);for(var m=f[f.length-1],r,l,u=p,b=0;b<f.length;b++){var a=u;p=f[b];u=[];r=d?a[a.length-1]:a[0];for(var e=0;e<a.length;e++)l=a[e],c(m,p,l)?(c(m,p,r)||u.push(k(m,p,r,l)),u.push(l)):c(m,p,r)&&u.push(k(m,p,r,l)),r=l;m=p}return u}})(q||(q={}));return q});x(c,"Maps/Projections/LambertConformalConic.js",[],function(){var c=Math.sign||function(c){return 0===c?0:0<c?1:-1},
k=Math.PI/180,q=Math.PI/2;return function(){function m(p){var f,d=(p.parallels||[]).map(function(d){return d*k}),m=d[0]||0;d=null!==(f=d[1])&&void 0!==f?f:m;f=Math.cos(m);"object"===typeof p.projectedBounds&&(this.projectedBounds=p.projectedBounds);p=m===d?Math.sin(m):Math.log(f/Math.cos(d))/Math.log(Math.tan((q+d)/2)/Math.tan((q+m)/2));1e-10>Math.abs(p)&&(p=1e-10*(c(p)||1));this.n=p;this.c=f*Math.pow(Math.tan((q+m)/2),p)/p}m.prototype.forward=function(c){var f=c[0]*k,d=this.c,m=this.n,p=this.projectedBounds;
c=c[1]*k;0<d?c<-q+.000001&&(c=-q+.000001):c>q-.000001&&(c=q-.000001);var l=d/Math.pow(Math.tan((q+c)/2),m);c=l*Math.sin(m*f)*63.78137;f=63.78137*(d-l*Math.cos(m*f));d=[c,f];p&&(c<p.x1||c>p.x2||f<p.y1||f>p.y2)&&(d.outside=!0);return d};m.prototype.inverse=function(m){var f=m[0]/63.78137,d=this.c,p=this.n;m=d-m[1]/63.78137;var r=c(p)*Math.sqrt(f*f+m*m),l=Math.atan2(f,Math.abs(m))*c(m);0>m*p&&(l-=Math.PI*c(f)*c(m));return[l/p/k,(2*Math.atan(Math.pow(d/r,1/p))-q)/k]};return m}()});x(c,"Maps/Projections/EqualEarth.js",
[],function(){var c=Math.sqrt(3)/2;return function(){function k(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-97.52595454902263,y2:97.52595454902263}}k.prototype.forward=function(k){var m=Math.PI/180,p=Math.asin(c*Math.sin(k[1]*m)),f=p*p,d=f*f*f;return[k[0]*m*Math.cos(p)*74.03120656864502/(c*(1.340264+3*-.081106*f+d*(7*.000893+.034164*f))),74.03120656864502*p*(1.340264+-.081106*f+d*(.000893+.003796*f))]};k.prototype.inverse=function(k){var m=k[0]/74.03120656864502;k=k[1]/74.03120656864502;
var p=180/Math.PI,f=k,d;for(d=0;12>d;++d){var q=f*f;var r=q*q*q;var l=f*(1.340264+-.081106*q+r*(.000893+.003796*q))-k;q=1.340264+3*-.081106*q+r*(7*.000893+.034164*q);f-=l/=q;if(1e-9>Math.abs(l))break}q=f*f;return[p*c*m*(1.340264+3*-.081106*q+q*q*q*(7*.000893+.034164*q))/Math.cos(f),p*Math.asin(Math.sin(f)/c)]};return k}()});x(c,"Maps/Projections/Miller.js",[],function(){var c=Math.PI/4,k=Math.PI/180;return function(){function q(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-146.91480769173063,
y2:146.91480769173063}}q.prototype.forward=function(m){return[m[0]*k*63.78137,79.7267125*Math.log(Math.tan(c+.4*m[1]*k))]};q.prototype.inverse=function(m){return[m[0]/63.78137/k,2.5*(Math.atan(Math.exp(m[1]/63.78137*.8))-c)/k]};return q}()});x(c,"Maps/Projections/Orthographic.js",[],function(){var c=Math.PI/180;return function(){function k(){this.antimeridianCutting=!1;this.bounds={x1:-63.78460826781007,x2:63.78460826781007,y1:-63.78460826781007,y2:63.78460826781007}}k.prototype.forward=function(k){var m=
k[0];k=k[1]*c;k=[Math.cos(k)*Math.sin(m*c)*63.78460826781007,63.78460826781007*Math.sin(k)];if(-90>m||90<m)k.outside=!0;return k};k.prototype.inverse=function(k){var m=k[0]/63.78460826781007;k=k[1]/63.78460826781007;var p=Math.sqrt(m*m+k*k),f=Math.asin(p),d=Math.sin(f);return[Math.atan2(m*d,p*Math.cos(f))/c,Math.asin(p&&k*d/p)/c]};return k}()});x(c,"Maps/Projections/WebMercator.js",[],function(){var c=Math.PI/180;return function(){function k(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,
y1:-200.3750834278071,y2:200.3750834278071};this.maxLatitude=85.0511287798}k.prototype.forward=function(k){var m=Math.sin(k[1]*c);m=[63.78137*k[0]*c,63.78137*Math.log((1+m)/(1-m))/2];85.0511287798<Math.abs(k[1])&&(m.outside=!0);return m};k.prototype.inverse=function(k){return[k[0]/(63.78137*c),(2*Math.atan(Math.exp(k[1]/63.78137))-Math.PI/2)/c]};return k}()});x(c,"Maps/Projections/ProjectionRegistry.js",[c["Maps/Projections/LambertConformalConic.js"],c["Maps/Projections/EqualEarth.js"],c["Maps/Projections/Miller.js"],
c["Maps/Projections/Orthographic.js"],c["Maps/Projections/WebMercator.js"]],function(c,k,q,m,p){return{EqualEarth:k,LambertConformalConic:c,Miller:q,Orthographic:m,WebMercator:p}});x(c,"Maps/Projection.js",[c["Core/Geometry/PolygonClip.js"],c["Maps/Projections/ProjectionRegistry.js"],c["Core/Utilities.js"]],function(c,k,q){var m=this&&this.__spreadArray||function(c,b,a){if(a||2===arguments.length)for(var e=0,d=b.length,n;e<d;e++)!n&&e in b||(n||(n=Array.prototype.slice.call(b,0,e)),n[e]=b[e]);return c.concat(n||
Array.prototype.slice.call(b))},p=c.clipLineString,f=c.clipPolygon,d=q.clamp,w=q.erase,r=2*Math.PI/360,l=function(c){-180>c&&(c+=360);180<c&&(c-=360);return c};return function(){function c(b){void 0===b&&(b={});this.hasGeoProjection=this.hasCoordinates=!1;this.maxLatitude=90;this.options=b;var a=b.name,e=b.projectedBounds,d=b.rotation;this.rotator=d?this.getRotator(d):void 0;if(a=a?c.registry[a]:void 0)this.def=new a(b);var n=this.def,g=this.rotator;n&&(this.maxLatitude=n.maxLatitude||90,this.hasGeoProjection=
!0);g&&n?(this.forward=function(a){return n.forward(g.forward(a))},this.inverse=function(a){return g.inverse(n.inverse(a))}):n?(this.forward=function(a){return n.forward(a)},this.inverse=function(a){return n.inverse(a)}):g&&(this.forward=g.forward,this.inverse=g.inverse);this.bounds="world"===e?n&&n.bounds:e}c.add=function(b,a){c.registry[b]=a};c.greatCircle=function(b,a,c){var e=Math.atan2,d=Math.cos,g=Math.sin,f=Math.sqrt,l=b[1]*r,h=b[0]*r,k=a[1]*r,m=a[0]*r,p=k-l,q=m-h;p=g(p/2)*g(p/2)+d(l)*d(k)*
g(q/2)*g(q/2);p=2*e(f(p),f(1-p));var u=Math.round(6371E3*p/5E5);q=[];c&&q.push(b);if(1<u)for(u=b=1/u;.999>u;u+=b){var w=g((1-u)*p)/g(p),E=g(u*p)/g(p),v=w*d(l)*d(h)+E*d(k)*d(m),F=w*d(l)*g(h)+E*d(k)*g(m);w=w*g(l)+E*g(k);w=e(w,f(v*v+F*F));v=e(F,v);q.push([v/r,w/r])}c&&q.push(a);return q};c.insertGreatCircles=function(b){for(var a=b.length-1;a--;)if(10<Math.max(Math.abs(b[a][0]-b[a+1][0]),Math.abs(b[a][1]-b[a+1][1]))){var e=c.greatCircle(b[a],b[a+1]);e.length&&b.splice.apply(b,m([a+1,0],e,!1))}};c.toString=
function(b){b=b||{};var a=b.rotation;return[b.name,a&&a.join(",")].join(";")};c.prototype.lineIntersectsBounds=function(b){var a=this.bounds||{},c=a.x2,d=a.y1,n=a.y2,g=function(a,b,c){var e=a[0];a=a[1];var d=b?0:1;if("number"===typeof c&&e[b]>=c!==a[b]>=c)return e=e[d]+(c-e[b])/(a[b]-e[b])*(a[d]-e[d]),b?[e,c]:[c,e]},f=b[0];if(a=g(b,0,a.x1))f=a,b[1]=a;else if(a=g(b,0,c))f=a,b[1]=a;if(a=g(b,1,d))f=a;else if(a=g(b,1,n))f=a;return f};c.prototype.getRotator=function(b){var a=b[0]*r,c=(b[1]||0)*r;b=(b[2]||
0)*r;var d=Math.cos(c),n=Math.sin(c),g=Math.cos(b),f=Math.sin(b);if(0!==a||0!==c||0!==b)return{forward:function(b){var c=b[0]*r+a,e=b[1]*r,l=Math.cos(e);b=Math.cos(c)*l;c=Math.sin(c)*l;e=Math.sin(e);l=e*d+b*n;return[Math.atan2(c*g-l*f,b*d-e*n)/r,Math.asin(l*g+c*f)/r]},inverse:function(b){var c=b[0]*r,e=b[1]*r,l=Math.cos(e);b=Math.cos(c)*l;c=Math.sin(c)*l;e=Math.sin(e);l=e*g-c*f;return[(Math.atan2(c*g+e*f,b*d+l*n)-a)/r,Math.asin(l*d-b*n)/r]}}};c.prototype.forward=function(b){return b};c.prototype.inverse=
function(b){return b};c.prototype.cutOnAntimeridian=function(b,a){var e=[],f=[b];b.forEach(function(c,h){var g=b[h-1];if(!h){if(!a)return;g=b[b.length-1]}var n=g[0],v=c[0];(-90>n||90<n)&&(-90>v||90<v)&&0<n!==0<v&&(v=d((180-(n+360)%360)/((v+360)%360-(n+360)%360),0,1),e.push({i:h,lat:g[1]+v*(c[1]-g[1]),direction:0>n?1:-1,previousLonLat:g,lonLat:c}))});if(e.length)if(a){if(1===e.length%2){var n=e.slice().sort(function(a,b){return Math.abs(b.lat)-Math.abs(a.lat)})[0];w(e,n)}for(var g=e.length-2;0<=g;){var k=
e[g].i,p=l(180+.000001*e[g].direction),h=l(180-.000001*e[g].direction);k=b.splice.apply(b,m([k,e[g+1].i-k],c.greatCircle([p,e[g].lat],[p,e[g+1].lat],!0),!1));k.push.apply(k,c.greatCircle([h,e[g+1].lat],[h,e[g].lat],!0));f.push(k);g-=2}if(n)for(p=0;p<f.length;p++){g=n.direction;var r=n.lat;h=f[p];k=h.indexOf(n.lonLat);if(-1<k){p=(0>r?-1:1)*this.maxLatitude;var q=l(180+.000001*g),u=l(180-.000001*g);r=c.greatCircle([q,r],[q,p],!0);for(q+=120*g;-180<q&&180>q;q+=120*g)r.push([q,p]);r.push.apply(r,c.greatCircle([u,
p],[u,n.lat],!0));h.splice.apply(h,m([k,0],r,!1));break}}}else for(g=e.length;g--;)k=e[g].i,k=b.splice(k,b.length,[l(180+.000001*e[g].direction),e[g].lat]),k.unshift([l(180-.000001*e[g].direction),e[g].lat]),f.push(k);return f};c.prototype.path=function(b){var a=this,e=this.bounds,d=this.def,n=this.rotator,g=[],l="Polygon"===b.type||"MultiPolygon"===b.type,k=this.hasGeoProjection,h=!d||!1!==d.antimeridianCutting,m=h?n:void 0,r=h?d||this:this,q;e&&(q=[[e.x1,e.y1],[e.x2,e.y1],[e.x2,e.y2],[e.x1,e.y2]]);
var u=function(b){b=b.map(function(a){if(h){m&&(a=m.forward(a));var b=a[0];.000001>Math.abs(b-180)&&(b=180>b?179.999999:180.000001);a=[b,a[1]]}return a});var d=[b];k&&(c.insertGreatCircles(b),h&&(d=a.cutOnAntimeridian(b,l)));d.forEach(function(a){if(!(2>a.length)){var b=!1,d=!1,n=function(a){b?g.push(["L",a[0],a[1]]):(g.push(["M",a[0],a[1]]),b=!0)},t=!1,m=!1,D=a.map(function(a){a=r.forward(a);a.outside?t=!0:m=!0;Infinity===a[1]?a[1]=1E10:-Infinity===a[1]&&(a[1]=-1E10);return a});if(h){l&&D.push(D[0]);
if(t){if(!m)return;if(q)if(l)D=f(D,q);else if(e){p(D,q).forEach(function(a){b=!1;a.forEach(n)});return}}D.forEach(n)}else for(var z=0;z<D.length;z++){var u=a[z],y=D[z];if(y.outside)d=!0;else{if(l&&!B){var B=u;a.push(u);D.push(y)}d&&A&&(l&&k?c.greatCircle(A,u).forEach(function(a){return n(r.forward(a))}):b=!1);n(y);var A=u;d=!1}}}})};"LineString"===b.type?u(b.coordinates):"MultiLineString"===b.type?b.coordinates.forEach(function(a){return u(a)}):"Polygon"===b.type?(b.coordinates.forEach(function(a){return u(a)}),
g.length&&g.push(["Z"])):"MultiPolygon"===b.type&&(b.coordinates.forEach(function(a){a.forEach(function(a){return u(a)})}),g.length&&g.push(["Z"]));return g};c.registry=k;return c}()});x(c,"Maps/MapView.js",[c["Maps/MapViewOptionsDefault.js"],c["Maps/MapViewInsetsOptionsDefault.js"],c["Extensions/GeoJSON.js"],c["Core/Chart/MapChart.js"],c["Maps/MapUtilities.js"],c["Maps/Projection.js"],c["Core/Utilities.js"]],function(c,k,q,m,p,f,d){var w=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),r=this&&this.__spreadArray||function(a,b,c){if(c||2===arguments.length)for(var e=0,d=
b.length,h;e<d;e++)!h&&e in b||(h||(h=Array.prototype.slice.call(b,0,e)),h[e]=b[e]);return a.concat(h||Array.prototype.slice.call(b))},l=q.topo2geo,u=m.maps,b=p.boundsFromPath,a=p.pointInPolygon,e=d.addEvent,t=d.clamp,n=d.fireEvent,g=d.isArray,A=d.isNumber,z=d.isObject,h=d.isString,y=d.merge,C=d.pick,B=d.relativeLength,G=function(a,b){return Math.log(400.979322/Math.max((a.x2-a.x1)/(b.width/256),(a.y2-a.y1)/(b.height/256)))/Math.log(2)},H=function(){function d(a,b){var h=this;this.allowTransformAnimation=
!0;this.insets=[];this.padding=[0,0,0,0];this.eventsToUnbind=[];var g;if(!(this instanceof I)){var n=r([a.options.chart.map],(a.options.series||[]).map(function(a){return a.mapData}),!0).map(function(a){return h.getGeoMap(a)}),v=[];n.forEach(function(a){a&&(g||(g=a["hc-recommended-mapview"]),a.bbox&&(a=a.bbox,v.push({x1:a[0],y1:a[1],x2:a[2],y2:a[3]})))});var l=v.length&&d.compositeBounds(v);if(l){var k=l.x1;var t=l.y1,m=l.x2;l=l.y2;k=180<m-k&&90<l-t?{name:"EqualEarth"}:{name:"LambertConformalConic",
parallels:[t,l],rotation:[-(k+m)/2]}}this.geoMap=n[0]}this.userOptions=b||{};n=y(c,{projection:k},g,b);l=g&&g.insets;b=b&&b.insets;l&&b&&(n.insets=d.mergeInsets(l,b));this.chart=a;this.center=n.center;this.options=n;this.projection=new f(n.projection);this.playingField=a.plotBox;this.zoom=n.zoom||0;this.createInsets();this.eventsToUnbind.push(e(a,"afterSetChartSize",function(){h.playingField=h.getField();if(void 0===h.minZoom||h.minZoom===h.zoom)h.fitToBounds(void 0,void 0,!1),!h.chart.hasRendered&&
A(h.userOptions.zoom)&&(h.zoom=h.userOptions.zoom),h.userOptions.center&&y(!0,h.center,h.userOptions.center)}));this.setUpEvents()}d.mergeInsets=function(a,b){var c=function(a){var b={};a.forEach(function(a,c){b[a&&a.id||"i".concat(c)]=a});return b},d=y(c(a),c(b));return Object.keys(d).map(function(a){return d[a]})};d.prototype.createInsets=function(){var a=this,b=this.options,c=b.insets;c&&c.forEach(function(c){c=new I(a,y(b.insetOptions,c));a.insets.push(c)})};d.prototype.fitToBounds=function(a,
b,c,d){void 0===c&&(c=!0);var e=a||this.getProjectedBounds();if(e){var h=C(b,a?0:this.options.padding);b=this.getField(!1);h=g(h)?h:[h,h,h,h];this.padding=[B(h[0],b.height),B(h[1],b.width),B(h[2],b.height),B(h[3],b.width)];this.playingField=this.getField();b=G(e,this.playingField);a||(this.minZoom=b);a=this.projection.inverse([(e.x2+e.x1)/2,(e.y2+e.y1)/2]);this.setView(a,b,c,d)}};d.prototype.getField=function(a){void 0===a&&(a=!0);a=a?this.padding:[0,0,0,0];return{x:a[3],y:a[0],width:this.chart.plotWidth-
a[1]-a[3],height:this.chart.plotHeight-a[0]-a[2]}};d.prototype.getGeoMap=function(a){if(h(a))return u[a]&&"Topology"===u[a].type?l(u[a]):u[a];if(z(a,!0)){if("FeatureCollection"===a.type)return a;if("Topology"===a.type)return l(a)}};d.prototype.getMapBBox=function(){var a=this.getProjectedBounds(),b=this.getScale();if(a){var c=this.padding,d=this.projectedUnitsToPixels({x:a.x1,y:a.y2});return{width:(a.x2-a.x1)*b+c[1]+c[3],height:(a.y2-a.y1)*b+c[0]+c[2],x:d.x-c[3],y:d.y-c[0]}}};d.prototype.getProjectedBounds=
function(){var a=this.projection,c=this.chart.series.reduce(function(a,b){var c=b.getProjectedBounds&&b.getProjectedBounds();c&&!1!==b.options.affectsMapView&&a.push(c);return a},[]),e=this.options.fitToGeometry;return e?(this.fitToGeometryCache||("MultiPoint"===e.type?(e=e.coordinates.map(function(b){return a.forward(b)}),c=e.map(function(a){return a[0]}),e=e.map(function(a){return a[1]}),this.fitToGeometryCache={x1:Math.min.apply(0,c),x2:Math.max.apply(0,c),y1:Math.min.apply(0,e),y2:Math.max.apply(0,
e)}):this.fitToGeometryCache=b(a.path(e))),this.fitToGeometryCache):this.projection.bounds||d.compositeBounds(c)};d.prototype.getScale=function(){return 256/400.979322*Math.pow(2,this.zoom)};d.prototype.getSVGTransform=function(){var a=this.playingField,b=a.x,c=a.y,d=a.width;a=a.height;var e=this.projection.forward(this.center),h=this.projection.hasCoordinates?-1:1,g=this.getScale();h*=g;return{scaleX:g,scaleY:h,translateX:b+d/2-e[0]*g,translateY:c+a/2-e[1]*h}};d.prototype.lonLatToPixels=function(a){if(a=
this.lonLatToProjectedUnits(a))return this.projectedUnitsToPixels(a)};d.prototype.lonLatToProjectedUnits=function(b){var c=this.chart,d=c.mapTransforms;if(d){for(var e in d)if(Object.hasOwnProperty.call(d,e)&&d[e].hitZone){var h=c.transformFromLatLon(b,d[e]);if(h&&a(h,d[e].hitZone.coordinates[0]))return h}return c.transformFromLatLon(b,d["default"])}d=0;for(e=this.insets;d<e.length;d++)if(c=e[d],c.options.geoBounds&&a({x:b.lon,y:b.lat},c.options.geoBounds.coordinates[0]))return b=c.projection.forward([b.lon,
b.lat]),b=c.projectedUnitsToPixels({x:b[0],y:b[1]}),this.pixelsToProjectedUnits(b);b=this.projection.forward([b.lon,b.lat]);if(!b.outside)return{x:b[0],y:b[1]}};d.prototype.projectedUnitsToLonLat=function(b){var c=this.chart,d=c.mapTransforms;if(d){for(var e in d)if(Object.hasOwnProperty.call(d,e)&&d[e].hitZone&&a(b,d[e].hitZone.coordinates[0]))return c.transformToLatLon(b,d[e]);return c.transformToLatLon(b,d["default"])}d=this.projectedUnitsToPixels(b);e=0;for(var h=this.insets;e<h.length;e++)if(c=
h[e],c.hitZone&&a(d,c.hitZone.coordinates[0]))return b=c.pixelsToProjectedUnits(d),b=c.projection.inverse([b.x,b.y]),{lon:b[0],lat:b[1]};b=this.projection.inverse([b.x,b.y]);return{lon:b[0],lat:b[1]}};d.prototype.redraw=function(a){this.chart.series.forEach(function(a){a.useMapGeometry&&(a.isDirty=!0)});this.chart.redraw(a)};d.prototype.setView=function(a,b,c,d){void 0===c&&(c=!0);a&&(this.center=a);"number"===typeof b&&("number"===typeof this.minZoom&&(b=Math.max(b,this.minZoom)),"number"===typeof this.options.maxZoom&&
(b=Math.min(b,this.options.maxZoom)),A(b)&&(this.zoom=b));var e=this.getProjectedBounds();if(e){a=this.projection.forward(this.center);var h=this.playingField;b=h.x;var g=h.y,l=h.width;h=h.height;var f=this.getScale(),k=this.projectedUnitsToPixels({x:e.x1,y:e.y1}),t=this.projectedUnitsToPixels({x:e.x2,y:e.y2});e=[(e.x1+e.x2)/2,(e.y1+e.y2)/2];if(!this.chart.series.some(function(a){return a.isDrilling})){var m=k.x,p=t.y;t=t.x;k=k.y;t-m<l?a[0]=e[0]:m<b&&t<b+l?a[0]+=Math.max(m-b,t-l-b)/f:t>b+l&&m>b&&
(a[0]+=Math.min(t-l-b,m-b)/f);k-p<h?a[1]=e[1]:p<g&&k<g+h?a[1]-=Math.max(p-g,k-h-g)/f:k>g+h&&p>g&&(a[1]-=Math.min(k-h-g,p-g)/f);this.center=this.projection.inverse(a)}this.insets.forEach(function(a){a.options.field&&(a.hitZone=a.getHitZone(),a.playingField=a.getField())});this.render()}n(this,"afterSetView");c&&this.redraw(d)};d.prototype.projectedUnitsToPixels=function(a){var b=this.getScale(),c=this.projection.forward(this.center),e=this.playingField;return{x:e.x+e.width/2-b*(c[0]-a.x),y:e.y+e.height/
2+b*(c[1]-a.y)}};d.prototype.pixelsToLonLat=function(a){return this.projectedUnitsToLonLat(this.pixelsToProjectedUnits(a))};d.prototype.pixelsToProjectedUnits=function(a){var b=a.x;a=a.y;var c=this.getScale(),e=this.projection.forward(this.center),d=this.playingField;return{x:e[0]+(b-(d.x+d.width/2))/c,y:e[1]-(a-(d.y+d.height/2))/c}};d.prototype.setUpEvents=function(){var a=this,b=this.chart,c,d,h,g=function(e){var g=b.pointer.pinchDown,n=a.projection,l=b.mouseDownX,f=b.mouseDownY;1===g.length&&(l=
g[0].chartX,f=g[0].chartY);if("number"===typeof l&&"number"===typeof f){var k="".concat(l,",").concat(f),m=e.originalEvent;g=m.chartX;m=m.chartY;k!==d&&(d=k,c=a.projection.forward(a.center),h=(a.projection.options.rotation||[0,0]).slice());k=(k=n.def&&n.def.bounds)&&G(k,a.playingField)||-Infinity;"Orthographic"===n.options.name&&(a.minZoom||Infinity)<1.3*k?(n=440/(a.getScale()*Math.min(b.plotWidth,b.plotHeight)),h&&(l=(l-g)*n-h[0],f=t(-h[1]-(f-m)*n,-80,80),g=a.zoom,a.update({projection:{rotation:[-l,
-f]}},!1),a.fitToBounds(void 0,void 0,!1),a.zoom=g,b.redraw(!1))):A(g)&&A(m)&&(n=a.getScale(),f=a.projection.inverse([c[0]+(l-g)/n,c[1]-(f-m)/n*(a.projection.hasCoordinates?1:-1)]),a.setView(f,void 0,!0,!1));e.preventDefault()}};e(b,"pan",g);e(b,"touchpan",g);e(b,"selection",function(c){if(c.resetSelection)a.zoomBy();else{var e=c.x-b.plotLeft,d=c.y-b.plotTop,h=a.pixelsToProjectedUnits({x:e,y:d}),g=h.y;h=h.x;e=a.pixelsToProjectedUnits({x:e+c.width,y:d+c.height});a.fitToBounds({x1:h,y1:g,x2:e.x,y2:e.y},
void 0,!0,c.originalEvent.touches?!1:void 0);/^touch/.test(c.originalEvent.type)||b.showResetZoom();c.preventDefault()}})};d.prototype.render=function(){this.group||(this.group=this.chart.renderer.g("map-view").attr({zIndex:4}).add())};d.prototype.update=function(a,b,c){void 0===b&&(b=!0);var e=a.projection;e=e&&f.toString(e)!==f.toString(this.options.projection);var d=!1;y(!0,this.userOptions,a);y(!0,this.options,a);"insets"in a&&(this.insets.forEach(function(a){return a.destroy()}),this.insets.length=
0,d=!0);(e||"fitToGeometry"in a)&&delete this.fitToGeometryCache;if(e||d)this.chart.series.forEach(function(a){var b=a.transformGroups;a.clearBounds&&a.clearBounds();a.isDirty=!0;a.isDirtyData=!0;if(d&&b)for(;1<b.length;)(a=b.pop())&&a.destroy()}),e&&(this.projection=new f(this.options.projection)),d&&this.createInsets(),a.center||!Object.hasOwnProperty.call(a,"zoom")||A(a.zoom)||this.fitToBounds(void 0,void 0,!1);a.center||A(a.zoom)?this.setView(this.options.center,a.zoom,!1):"fitToGeometry"in a&&
this.fitToBounds(void 0,void 0,!1);b&&this.chart.redraw(c)};d.prototype.zoomBy=function(a,b,c,e){var d=this.chart,h=this.projection.forward(this.center);b=b?this.projection.forward(b):[];var g=b[0],n=b[1];"number"===typeof a?(a=this.zoom+a,b=void 0,c&&(g=c[0],n=c[1],c=this.getScale(),g=g-d.plotLeft-d.plotWidth/2,d=n-d.plotTop-d.plotHeight/2,g=h[0]+g/c,n=h[1]+d/c),"number"===typeof g&&"number"===typeof n&&(c=1-Math.pow(2,this.zoom)/Math.pow(2,a),g=h[0]-g,d=h[1]-n,h[0]-=g*c,h[1]+=d*c,b=this.projection.inverse(h)),
this.setView(b,a,void 0,e)):this.fitToBounds(void 0,void 0,void 0,e)};d.compositeBounds=function(a){if(a.length)return a.slice(1).reduce(function(a,b){a.x1=Math.min(a.x1,b.x1);a.y1=Math.min(a.y1,b.y1);a.x2=Math.max(a.x2,b.x2);a.y2=Math.max(a.y2,b.y2);return a},y(a[0]))};return d}(),I=function(c){function e(a,e){var d=c.call(this,a.chart,e)||this;d.id=e.id;d.mapView=a;d.options=y(k,e);d.allBounds=[];d.options.geoBounds&&(a=a.projection.path(d.options.geoBounds),d.geoBoundsProjectedBox=b(a),d.geoBoundsProjectedPolygon=
a.map(function(a){return[a[1]||0,a[2]||0]}));return d}w(e,c);e.prototype.getField=function(a){void 0===a&&(a=!0);var b=this.hitZone;if(b){var e=a?this.padding:[0,0,0,0];b=b.coordinates[0];var d=b.map(function(a){return a[0]}),h=b.map(function(a){return a[1]});b=Math.min.apply(0,d)+e[3];d=Math.max.apply(0,d)-e[1];var g=Math.min.apply(0,h)+e[0];e=Math.max.apply(0,h)-e[2];if(A(b)&&A(g))return{x:b,y:g,width:d-b,height:e-g}}return c.prototype.getField.call(this,a)};e.prototype.getHitZone=function(){var a=
this.chart,b=this.mapView,c=this.options,e=(c.field||{}).coordinates;if(e){e=e[0];if("percent"===c.units){var d="mapBoundingBox"===c.relativeTo&&b.getMapBBox()||y(a.plotBox,{x:0,y:0});e=e.map(function(a){return[B("".concat(a[0],"%"),d.width,d.x),B("".concat(a[1],"%"),d.height,d.y)]})}return{type:"Polygon",coordinates:[e]}}};e.prototype.getProjectedBounds=function(){return H.compositeBounds(this.allBounds)};e.prototype.isInside=function(b){var c=this.geoBoundsProjectedBox,e=this.geoBoundsProjectedPolygon;
return!!(c&&b.x>=c.x1&&b.x<=c.x2&&b.y>=c.y1&&b.y<=c.y2&&e&&a(b,e))};e.prototype.render=function(){var a=this.chart,b=this.mapView,c=this.options,e=c.borderPath||c.field;if(e&&b.group){var d=!0;this.border||(this.border=a.renderer.path().addClass("highcharts-mapview-inset-border").add(b.group),d=!1);a.styledMode||this.border.attr({stroke:c.borderColor,"stroke-width":c.borderWidth});var h=Math.round(this.border.strokeWidth())%2/2,g="mapBoundingBox"===c.relativeTo&&b.getMapBBox()||b.playingField;b=(e.coordinates||
[]).reduce(function(b,e){return e.reduce(function(b,e,d){var n=e[0];e=e[1];"percent"===c.units&&(n=a.plotLeft+B("".concat(n,"%"),g.width,g.x),e=a.plotTop+B("".concat(e,"%"),g.height,g.y));n=Math.floor(n)+h;e=Math.floor(e)+h;b.push(0===d?["M",n,e]:["L",n,e]);return b},b)},[]);this.border[d?"animate":"attr"]({d:b})}};e.prototype.destroy=function(){this.border&&(this.border=this.border.destroy());this.eventsToUnbind.forEach(function(a){return a()})};e.prototype.setUpEvents=function(){};return e}(H);
e(m,"afterInit",function(){this.mapView=new H(this,this.options.mapView)});return H});x(c,"Series/Map/MapSeries.js",[c["Core/Animation/AnimationUtilities.js"],c["Series/ColorMapComposition.js"],c["Series/CenteredUtilities.js"],c["Core/Globals.js"],c["Core/Legend/LegendSymbol.js"],c["Core/Chart/MapChart.js"],c["Series/Map/MapPoint.js"],c["Maps/MapView.js"],c["Core/Series/Series.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,k,q,m,p,
f,d,J,r,l,u,b){var a=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,
new e)}}(),e=c.animObject;c=m.noop;var t=f.splitPath;f=l.seriesTypes;var n=f.column,g=f.scatter;f=b.extend;var A=b.find,z=b.fireEvent,h=b.getNestedProperty,y=b.isArray,C=b.defined,B=b.isNumber,G=b.isObject,w=b.merge,I=b.objectEach,E=b.pick,v=b.splat;b=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.chart=void 0;a.data=void 0;a.group=void 0;a.joinBy=void 0;a.options=void 0;a.points=void 0;a.processedData=[];return a}a(c,b);c.prototype.animate=function(a){var b=this.chart,c=
this.group,d=e(this.options.animation);a?c.attr({translateX:b.plotLeft+b.plotWidth/2,translateY:b.plotTop+b.plotHeight/2,scaleX:.001,scaleY:.001}):c.animate({translateX:b.plotLeft,translateY:b.plotTop,scaleX:1,scaleY:1},d)};c.prototype.clearBounds=function(){this.points.forEach(function(a){delete a.bounds;delete a.insetIndex;delete a.projectedPath});delete this.bounds};c.prototype.doFullTranslate=function(){return!(!this.isDirtyData&&!this.chart.isResizing&&this.hasRendered)};c.prototype.drawMapDataLabels=
function(){r.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)};c.prototype.drawPoints=function(){var a=this,b=this,c=this.chart,e=this.group,d=this.transformGroups,h=void 0===d?[]:d,g=c.mapView,l=c.renderer;g&&(this.transformGroups=h,h[0]||(h[0]=l.g().add(e)),g.insets.forEach(function(a,b){h[b+1]||h.push(l.g().add(e))}),this.doFullTranslate()&&(this.points.forEach(function(b){var e=b.graphic,d=b.shapeArgs;b.group=h["number"===typeof b.insetIndex?
b.insetIndex+1:0];e&&e.parentGroup!==b.group&&e.add(b.group);d&&c.hasRendered&&!c.styledMode&&(d.fill=a.pointAttribs(b,b.state).fill)}),n.prototype.drawPoints.apply(this),this.points.forEach(function(e){var d=e.graphic;if(d){var h=d.animate,g="";e.name&&(g+="highcharts-name-"+e.name.replace(/ /g,"-").toLowerCase());e.properties&&e.properties["hc-key"]&&(g+=" highcharts-key-"+e.properties["hc-key"].toString().toLowerCase());g&&d.addClass(g);c.styledMode&&d.css(a.pointAttribs(e,e.selected&&"select"||
void 0));d.animate=function(a,e,g){var n=B(a["stroke-width"])&&!B(d["stroke-width"]),l=B(d["stroke-width"])&&!B(a["stroke-width"]);if(n||l){var f=E(b.getStrokeWidth(b.options),1)/(c.mapView&&c.mapView.getScale()||1);n&&(d["stroke-width"]=f);l&&(a["stroke-width"]=f)}return h.call(d,a,e,l?function(){d.element.removeAttribute("stroke-width");delete d["stroke-width"];g&&g.apply(this,arguments)}:g)}}})),h.forEach(function(e,d){var h=(0===d?g:g.insets[d-1]).getSVGTransform(),n=E(a.getStrokeWidth(a.options),
1),f=h.scaleX,k=0<h.scaleY?1:-1,t=function(c){(b.points||[]).forEach(function(b){var e=b.graphic,d;e&&e["stroke-width"]&&(d=a.getStrokeWidth(b.options))&&e.attr({"stroke-width":d/c})})};if(l.globalAnimation&&c.hasRendered&&g.allowTransformAnimation){var m=Number(e.attr("translateX")),p=Number(e.attr("translateY")),r=Number(e.attr("scaleX")),q=function(a,b){a=r+(f-r)*b.pos;e.attr({translateX:m+(h.translateX-m)*b.pos,translateY:p+(h.translateY-p)*b.pos,scaleX:a,scaleY:a*k,"stroke-width":n/a});t(a)};
d={};c.options.chart&&(d=w({},c.options.chart.animation));if("boolean"!==typeof d){var z=d.step;d.step=function(a){z&&z.apply(this,arguments);q.apply(this,arguments)}}e.attr({animator:0}).animate({animator:1},d,function(){"boolean"!==typeof l.globalAnimation&&l.globalAnimation.complete&&l.globalAnimation.complete({applyDrilldown:!0})})}else e.attr(w(h,{"stroke-width":n/f})),t(f)}),this.isDrilling||this.drawMapDataLabels())};c.prototype.getProjectedBounds=function(){if(!this.bounds&&this.chart.mapView){var a=
this.chart.mapView,b=a.insets,c=a.projection,e=[];(this.points||[]).forEach(function(a){if(a.path||a.geometry){"string"===typeof a.path?a.path=t(a.path):y(a.path)&&"M"===a.path[0]&&(a.path=u.prototype.pathToSegments(a.path));if(!a.bounds){var d=a.getProjectedBounds(c);if(d){a.labelrank=E(a.labelrank,(d.x2-d.x1)*(d.y2-d.y1));var h=d.midX,g=d.midY;if(b&&B(h)&&B(g)){var n=A(b,function(a){return a.isInside({x:h,y:g})});n&&(delete a.projectedPath,(d=a.getProjectedBounds(n.projection))&&n.allBounds.push(d),
a.insetIndex=b.indexOf(n))}a.bounds=d}}a.bounds&&void 0===a.insetIndex&&e.push(a.bounds)}});this.bounds=J.compositeBounds(e)}return this.bounds};c.prototype.getStrokeWidth=function(a){var b=this.pointAttrToOptions;return a[b&&b["stroke-width"]||"borderWidth"]};c.prototype.hasData=function(){return!!this.processedXData.length};c.prototype.pointAttribs=function(a,b){var c,e=a.series.chart,d=e.mapView;e=e.styledMode?this.colorAttribs(a):n.prototype.pointAttribs.call(this,a,b);var h=this.getStrokeWidth(a.options);
if(b){b=w(this.options.states[b],a.options.states&&a.options.states[b]||{});var g=this.getStrokeWidth(b);C(g)&&(h=g);e.stroke=null!==(c=b.borderColor)&&void 0!==c?c:a.color}h&&d&&(h/=d.getScale());c=this.getStrokeWidth(this.options);e.dashstyle&&d&&B(c)&&(h=c/d.getScale());a.visible||(e.fill=this.options.nullColor);C(h)?e["stroke-width"]=h:delete e["stroke-width"];e["stroke-linecap"]=e["stroke-linejoin"]=this.options.linecap;return e};c.prototype.updateData=function(){return this.processedData?!1:
b.prototype.updateData.apply(this,arguments)};c.prototype.setData=function(a,c,e,d){void 0===c&&(c=!0);delete this.bounds;b.prototype.setData.call(this,a,!1,void 0,d);this.processData();this.generatePoints();c&&this.chart.redraw(e)};c.prototype.processData=function(){var a=this.options,b=a.data,c=this.chart.options.chart,e=this.joinBy,g=a.keys||this.pointArrayMap,n=[],l={},f=this.chart.mapView;f=f&&(G(a.mapData,!0)?f.getGeoMap(a.mapData):f.geoMap);var k=this.chart.mapTransforms;(this.chart.mapTransforms=
k=c.mapTransforms||f&&f["hc-transform"]||k)&&I(k,function(a){a.rotation&&(a.cosAngle=Math.cos(a.rotation),a.sinAngle=Math.sin(a.rotation))});if(y(a.mapData))var t=a.mapData;else f&&"FeatureCollection"===f.type&&(this.mapTitle=f.title,t=m.geojson(f,this.type,this));var p=this.processedData=[];b&&b.forEach(function(c,h){var n=0;if(B(c))p[h]={value:c};else if(y(c)){p[h]={};!a.keys&&c.length>g.length&&"string"===typeof c[0]&&(p[h]["hc-key"]=c[0],++n);for(var f=0;f<g.length;++f,++n)g[f]&&"undefined"!==
typeof c[n]&&(0<g[f].indexOf(".")?d.prototype.setNestedProperty(p[h],c[n],g[f]):p[h][g[f]]=c[n])}else p[h]=b[h];e&&"_i"===e[0]&&(p[h]._i=h)});if(t){this.mapData=t;this.mapMap={};for(k=0;k<t.length;k++)c=t[k],f=c.properties,c._i=k,e[0]&&f&&f[e[0]]&&(c[e[0]]=f[e[0]]),l[c[e[0]]]=c;this.mapMap=l;if(e[1]){var r=e[1];p.forEach(function(a){a=h(r,a);l[a]&&n.push(l[a])})}if(a.allAreas){if(e[1]){var q=e[1];p.forEach(function(a){n.push(h(q,a))})}var z="|"+n.map(function(a){return a&&a[e[0]]}).join("|")+"|";
t.forEach(function(a){e[0]&&-1!==z.indexOf("|"+a[e[0]]+"|")||p.push(w(a,{value:null}))})}}this.processedXData=Array(p.length)};c.prototype.setOptions=function(a){a=r.prototype.setOptions.call(this,a);var b=a.joinBy;null===b&&(b="_i");b=this.joinBy=v(b);b[1]||(b[1]=b[0]);return a};c.prototype.translate=function(){var a=this.doFullTranslate(),b=this.chart.mapView,c=b&&b.projection;!this.chart.hasRendered||!this.isDirtyData&&this.hasRendered||(this.processData(),this.generatePoints(),delete this.bounds,
!b||b.userOptions.center||B(b.userOptions.zoom)||b.zoom!==b.minZoom?this.getProjectedBounds():b.fitToBounds(void 0,void 0,!1));if(b){var e=b.getSVGTransform();this.points.forEach(function(h){var g=B(h.insetIndex)&&b.insets[h.insetIndex].getSVGTransform()||e;g&&h.bounds&&B(h.bounds.midX)&&B(h.bounds.midY)&&(h.plotX=h.bounds.midX*g.scaleX+g.translateX,h.plotY=h.bounds.midY*g.scaleY+g.translateY);a&&(h.shapeType="path",h.shapeArgs={d:d.getProjectedPath(h,c)});h.projectedPath&&!h.projectedPath.length?
h.setVisible(!1):h.setVisible(!0)})}z(this,"afterTranslate")};c.defaultOptions=w(g.defaultOptions,{affectsMapView:!0,animation:!1,dataLabels:{crop:!1,formatter:function(){var a=this.series.chart.numberFormatter,b=this.point.value;return B(b)?a(b,-1):""},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},linecap:"round",marker:null,nullColor:"#f7f7f7",stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:"#e6e6e6",
borderWidth:1,joinBy:"hc-key",states:{hover:{halo:void 0,borderColor:"#666666",borderWidth:2},normal:{animation:!0},select:{color:"#cccccc"}}});return c}(g);f(b.prototype,{type:"map",axisTypes:k.seriesMembers.axisTypes,colorAttribs:k.seriesMembers.colorAttribs,colorKey:k.seriesMembers.colorKey,directTouch:!0,drawDataLabels:c,drawGraph:c,drawLegendSymbol:p.drawRectangle,forceDL:!0,getCenter:q.getCenter,getExtremesFromAll:!0,getSymbol:c,isCartesian:!1,parallelArrays:k.seriesMembers.parallelArrays,pointArrayMap:k.seriesMembers.pointArrayMap,
pointClass:d,preserveAspectRatio:!0,searchPoint:c,trackerGroups:k.seriesMembers.trackerGroups,useMapGeometry:!0});k.compose(b);l.registerSeriesType("map",b);"";return b});x(c,"Series/MapLine/MapLineSeries.js",[c["Series/Map/MapSeries.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,q){var m=this&&this.__extends||function(){var c=function(d,f){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,b){c.__proto__=b}||function(c,b){for(var a in b)Object.prototype.hasOwnProperty.call(b,
a)&&(c[a]=b[a])};return c(d,f)};return function(d,f){function l(){this.constructor=d}if("function"!==typeof f&&null!==f)throw new TypeError("Class extends value "+String(f)+" is not a constructor or null");c(d,f);d.prototype=null===f?Object.create(f):(l.prototype=f.prototype,new l)}}(),p=k.series,f=q.extend,d=q.merge;q=function(f){function k(){var c=null!==f&&f.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}m(k,f);k.prototype.pointAttribs=function(d,f){d=c.prototype.pointAttribs.call(this,
d,f);d.fill=this.options.fillColor;return d};k.defaultOptions=d(c.defaultOptions,{lineWidth:1,fillColor:"none"});return k}(c);f(q.prototype,{type:"mapline",colorProp:"stroke",drawLegendSymbol:p.prototype.drawLegendSymbol,pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"}});k.registerSeriesType("mapline",q);"";return q});x(c,"Series/MapPoint/MapPointPoint.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k){var q=this&&this.__extends||function(){var c=function(f,
d){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,d){c.__proto__=d}||function(c,d){for(var f in d)Object.prototype.hasOwnProperty.call(d,f)&&(c[f]=d[f])};return c(f,d)};return function(f,d){function k(){this.constructor=f}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");c(f,d);f.prototype=null===d?Object.create(d):(k.prototype=d.prototype,new k)}}(),m=k.isNumber;return function(c){function f(){var d=null!==
c&&c.apply(this,arguments)||this;d.options=void 0;d.series=void 0;return d}q(f,c);f.prototype.isValid=function(){return!!(this.options.geometry||m(this.x)&&m(this.y)||m(this.options.lon)&&m(this.options.lat))};return f}(c.seriesTypes.scatter.prototype.pointClass)});x(c,"Series/MapPoint/MapPointSeries.js",[c["Core/Globals.js"],c["Series/MapPoint/MapPointPoint.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,k,q,m,p){var f=this&&this.__extends||
function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}();c=c.noop;var d=q.seriesTypes,
w=d.map,r=d.scatter;d=p.extend;var l=p.fireEvent,u=p.isNumber,b=p.merge;p=function(a){function c(){var b=null!==a&&a.apply(this,arguments)||this;b.chart=void 0;b.data=void 0;b.options=void 0;b.points=void 0;b.clearBounds=w.prototype.clearBounds;return b}f(c,a);c.prototype.drawDataLabels=function(){a.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)};c.prototype.projectPoint=function(a){var b=this.chart.mapView;if(b){var c=a.geometry,e=a.lon;a=
a.lat;c=c&&"Point"===c.type&&c.coordinates;u(e)&&u(a)&&(c=[e,a]);if(c)return b.lonLatToProjectedUnits({lon:c[0],lat:c[1]})}};c.prototype.translate=function(){var a=this,b=this.chart.mapView;this.processedXData||this.processData();this.generatePoints();this.getProjectedBounds&&this.isDirtyData&&(delete this.bounds,this.getProjectedBounds());if(b){var c=b.getSVGTransform(),e=b.projection.hasCoordinates;this.points.forEach(function(d){var h=d.x;h=void 0===h?void 0:h;var g=d.y;g=void 0===g?void 0:g;var n=
u(d.insetIndex)&&b.insets[d.insetIndex].getSVGTransform()||c,f=a.projectPoint(d.options)||d.properties&&a.projectPoint(d.properties);if(f)h=f.x,g=f.y;else if(d.bounds&&(h=d.bounds.midX,g=d.bounds.midY,n&&u(h)&&u(g))){d.plotX=h*n.scaleX+n.translateX;d.plotY=g*n.scaleY+n.translateY;var l=!0}u(h)&&u(g)?l||(l=b.projectedUnitsToPixels({x:h,y:g}),d.plotX=l.x,d.plotY=e?l.y:a.chart.plotHeight-l.y):d.y=d.plotX=d.plotY=void 0;d.isInside=a.isPointInside(d);d.zone=a.zones.length?d.getZone():void 0})}l(this,"afterTranslate")};
c.defaultOptions=b(r.defaultOptions,{dataLabels:{crop:!1,defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:"#000000"}}});return c}(r);m.prototype.symbols.mapmarker=function(a,b,c,d,g){var e=g&&"legend"===g.context;e?(a+=c/2,g=b+d):g&&"number"===typeof g.anchorX&&"number"===typeof g.anchorY?(a=g.anchorX,g=g.anchorY):(a+=c/2,g=b+d/2,b-=d);d=e?d/3:d/2;return[["M",a,g],["C",a,g,a-d,b+1.5*d,a-d,b+d],["A",d,d,1,1,1,a+d,b+d],["C",a+d,b+1.5*d,a,g,a,g],["Z"]]};d(p.prototype,
{type:"mappoint",axisTypes:["colorAxis"],forceDL:!0,isCartesian:!1,pointClass:k,searchPoint:c,useMapGeometry:!0});q.registerSeriesType("mappoint",p);"";return p});x(c,"Series/Bubble/BubbleLegendDefaults.js",[],function(){return{borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"0.7em",color:"#000000"},
x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}});x(c,"Series/Bubble/BubbleLegendItem.js",[c["Core/Color/Color.js"],c["Core/FormatUtilities.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,k,q,m){var p=c.parse,f=q.noop,d=m.arrayMax,w=m.arrayMin,r=m.isNumber,l=m.merge,u=m.pick,b=m.stableSort;c=function(){function a(a,b){this.options=this.symbols=this.visible=
this.selected=this.ranges=this.movementX=this.maxLabel=this.legend=this.chart=void 0;this.setState=f;this.init(a,b)}a.prototype.init=function(a,b){this.options=a;this.visible=!0;this.chart=b.chart;this.legend=b};a.prototype.addToLegend=function(a){a.splice(this.options.legendIndex,0,this)};a.prototype.drawLegendSymbol=function(a){var c=u(a.options.itemDistance,20),d=this.legendItem||{},e=this.options,f=e.ranges,l=e.connectorDistance;if(f&&f.length&&r(f[0].value)){b(f,function(a,b){return b.value-
a.value});this.ranges=f;this.setOptions();this.render();a=this.getMaxLabelSize();var h=this.ranges[0].radius;f=2*h;l=l-h+a.width;l=0<l?l:0;this.maxLabel=a;this.movementX="left"===e.labels.align?l:0;d.labelWidth=f+l+c;d.labelHeight=f+a.height/2}else a.options.bubbleLegend.autoRanges=!0};a.prototype.setOptions=function(){var a=this.ranges,b=this.options,c=this.chart.series[b.seriesIndex],d=this.legend.baseline,f={zIndex:b.zIndex,"stroke-width":b.borderWidth},k={zIndex:b.zIndex,"stroke-width":b.connectorWidth},
h={align:this.legend.options.rtl||"left"===b.labels.align?"right":"left",zIndex:b.zIndex},m=c.options.marker.fillOpacity,q=this.chart.styledMode;a.forEach(function(e,g){q||(f.stroke=u(e.borderColor,b.borderColor,c.color),f.fill=u(e.color,b.color,1!==m?p(c.color).setOpacity(m).get("rgba"):c.color),k.stroke=u(e.connectorColor,b.connectorColor,c.color));a[g].radius=this.getRangeRadius(e.value);a[g]=l(a[g],{center:a[0].radius-a[g].radius+d});q||l(!0,a[g],{bubbleAttribs:l(f),connectorAttribs:l(k),labelAttribs:h})},
this)};a.prototype.getRangeRadius=function(a){var b=this.options;return this.chart.series[this.options.seriesIndex].getRadius.call(this,b.ranges[b.ranges.length-1].value,b.ranges[0].value,b.minSize,b.maxSize,a)};a.prototype.render=function(){var a=this.legendItem||{},b=this.chart.renderer,c=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]});a.symbol=b.g("bubble-legend");a.label=b.g("bubble-legend-item");a.symbol.translateX=0;a.symbol.translateY=0;a.symbol.add(a.label);
a.label.add(a.group);a=0;for(b=this.ranges;a<b.length;a++){var d=b[a];d.value>=c&&this.renderRange(d)}this.hideOverlappingLabels()};a.prototype.renderRange=function(a){var b=this.options,c=b.labels,d=this.chart,e=d.series[b.seriesIndex],f=d.renderer,h=this.symbols;d=h.labels;var l=a.center,k=Math.abs(a.radius),m=b.connectorDistance||0,p=c.align,q=b.connectorWidth,r=this.ranges[0].radius||0,u=l-k-b.borderWidth/2+q/2,v=f.styledMode;m=this.legend.options.rtl||"left"===p?-m:m;"center"===p&&(m=0,b.connectorDistance=
0,a.labelAttribs.align="center");h.bubbleItems.push(f.circle(r,l+((u%1?1:.5)-(q%2?0:.5)),k).attr(v?{}:a.bubbleAttribs).addClass((v?"highcharts-color-"+e.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(b.className||"")).add(this.legendItem.symbol));h.connectors.push(f.path(f.crispLine([["M",r,u],["L",r+m,u]],b.connectorWidth)).attr(v?{}:a.connectorAttribs).addClass((v?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(b.connectorClassName||"")).add(this.legendItem.symbol));
a=f.text(this.formatLabel(a)).attr(v?{}:a.labelAttribs).css(v?{}:c.style).addClass("highcharts-bubble-legend-labels "+(b.labels.className||"")).add(this.legendItem.symbol);b={x:r+m+b.labels.x,y:u+b.labels.y+.4*a.getBBox().height};a.attr(b);d.push(a);a.placed=!0;a.alignAttr=b};a.prototype.getMaxLabelSize=function(){var a,b;this.symbols.labels.forEach(function(c){b=c.getBBox(!0);a=a?b.width>a.width?b:a:b});return a||{}};a.prototype.formatLabel=function(a){var b=this.options,c=b.labels.formatter;b=b.labels.format;
var d=this.chart.numberFormatter;return b?k.format(b,a):c?c.call(a):d(a.value,1)};a.prototype.hideOverlappingLabels=function(){var a=this.chart,b=this.symbols;!this.options.labels.allowOverlap&&b&&(a.hideOverlappingLabels(b.labels),b.labels.forEach(function(a,c){a.newOpacity?a.newOpacity!==a.oldOpacity&&b.connectors[c].show():b.connectors[c].hide()}))};a.prototype.getRanges=function(){var a=this.legend.bubbleLegend,b=a.options.ranges,c,g=Number.MAX_VALUE,f=-Number.MAX_VALUE;a.chart.series.forEach(function(a){a.isBubble&&
!a.ignoreSeries&&(c=a.zData.filter(r),c.length&&(g=u(a.options.zMin,Math.min(g,Math.max(w(c),!1===a.options.displayNegative?a.options.zThreshold:-Number.MAX_VALUE))),f=u(a.options.zMax,Math.max(f,d(c)))))});var k=g===f?[{value:f}]:[{value:g},{value:(g+f)/2},{value:f,autoRanges:!0}];b.length&&b[0].radius&&k.reverse();k.forEach(function(a,c){b&&b[c]&&(k[c]=l(b[c],a))});return k};a.prototype.predictBubbleSizes=function(){var a=this.chart,b=a.legend.options,c=b.floating,d=(b="horizontal"===b.layout)?
a.legend.lastLineHeight:0,f=a.plotSizeX,l=a.plotSizeY,h=a.series[this.options.seriesIndex],k=h.getPxExtremes();a=Math.ceil(k.minPxSize);k=Math.ceil(k.maxPxSize);var m=Math.min(l,f);h=h.options.maxSize;if(c||!/%$/.test(h))c=k;else if(h=parseFloat(h),c=(m+d)*h/100/(h/100+1),b&&l-c>=f||!b&&f-c>=l)c=k;return[a,Math.ceil(c)]};a.prototype.updateRanges=function(a,b){var c=this.legend.options.bubbleLegend;c.minSize=a;c.maxSize=b;c.ranges=this.getRanges()};a.prototype.correctSizes=function(){var a=this.legend,
b=this.chart.series[this.options.seriesIndex].getPxExtremes();1<Math.abs(Math.ceil(b.maxPxSize)-this.options.maxSize)&&(this.updateRanges(this.options.minSize,b.maxPxSize),a.render())};return a}();"";return c});x(c,"Series/Bubble/BubbleLegendComposition.js",[c["Series/Bubble/BubbleLegendDefaults.js"],c["Series/Bubble/BubbleLegendItem.js"],c["Core/Defaults.js"],c["Core/Utilities.js"]],function(c,k,q,m){function p(b,c,e){var g=this.legend,h=0<=f(this),k;if(g&&g.options.enabled&&g.bubbleLegend&&g.options.bubbleLegend.autoRanges&&
h){var n=g.bubbleLegend.options;h=g.bubbleLegend.predictBubbleSizes();g.bubbleLegend.updateRanges(h[0],h[1]);n.placed||(g.group.placed=!1,g.allItems.forEach(function(a){k=a.legendItem||{};k.group&&(k.group.translateY=null)}));g.render();this.getMargins();this.axes.forEach(function(b){b.visible&&b.render();n.placed||(b.setScale(),b.updateNames(),a(b.ticks,function(a){a.isNew=!0;a.isNewLabel=!0}))});n.placed=!0;this.getMargins();b.call(this,c,e);g.bubbleLegend.correctSizes();l(g,d(g))}else b.call(this,
c,e),g&&g.options.enabled&&g.bubbleLegend&&(g.render(),l(g,d(g)))}function f(a){a=a.series;for(var b=0;b<a.length;){if(a[b]&&a[b].isBubble&&a[b].visible&&a[b].zData.length)return b;b++}return-1}function d(a){a=a.allItems;var b=[],c=a.length,d,e=0;for(d=0;d<c;d++){var f=a[d].legendItem||{};var l=(a[d+1]||{}).legendItem||{};f.labelHeight&&(a[d].itemHeight=f.labelHeight);if(a[d]===a[c-1]||f.y!==l.y){b.push({height:0});f=b[b.length-1];for(e;e<=d;e++)a[e].itemHeight>f.height&&(f.height=a[e].itemHeight);
f.step=d}}return b}function w(a){var b=this.bubbleLegend,c=this.options,d=c.bubbleLegend,e=f(this.chart);b&&b.ranges&&b.ranges.length&&(d.ranges.length&&(d.autoRanges=!!d.ranges[0].autoRanges),this.destroyItem(b));0<=e&&c.enabled&&d.enabled&&(d.seriesIndex=e,this.bubbleLegend=new k(d,this),this.bubbleLegend.addToLegend(a.allItems))}function r(a){if(a.defaultPrevented)return!1;var b=this.chart;a=this.visible;var c=this.chart.legend;c&&c.bubbleLegend&&(this.visible=!a,this.ignoreSeries=a,b=0<=f(b),
c.bubbleLegend.visible!==b&&(c.update({bubbleLegend:{enabled:b}}),c.bubbleLegend.visible=b),this.visible=a)}function l(a,b){var c=a.options.rtl,d,e,g,f,l=0;a.allItems.forEach(function(a,h){f=a.legendItem||{};if(f.group){d=f.group.translateX||0;e=f.y||0;if((g=a.movementX)||c&&a.ranges)g=c?d-a.options.maxSize/2:d+g,f.group.attr({translateX:g});h>b[l].step&&l++;f.group.attr({translateY:Math.round(e+b[l].height/2)});f.y=e+b[l].height/2}})}var u=q.setOptions,b=m.addEvent,a=m.objectEach,e=m.wrap,t=[];return{compose:function(a,
d,f){m.pushUnique(t,a)&&(u({legend:{bubbleLegend:c}}),e(a.prototype,"drawChartBox",p));m.pushUnique(t,d)&&b(d,"afterGetAllItems",w);m.pushUnique(t,f)&&b(f,"legendItemClick",r)}}});x(c,"Series/Bubble/BubblePoint.js",[c["Core/Series/Point.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,q){var m=this&&this.__extends||function(){var c=function(f,d){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,d){c.__proto__=d}||function(c,d){for(var f in d)Object.prototype.hasOwnProperty.call(d,
f)&&(c[f]=d[f])};return c(f,d)};return function(f,d){function k(){this.constructor=f}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");c(f,d);f.prototype=null===d?Object.create(d):(k.prototype=d.prototype,new k)}}();q=q.extend;k=function(k){function f(){var c=null!==k&&k.apply(this,arguments)||this;c.options=void 0;c.series=void 0;return c}m(f,k);f.prototype.haloPath=function(d){return c.prototype.haloPath.call(this,0===d?0:(this.marker?
this.marker.radius||0:0)+d)};return f}(k.seriesTypes.scatter.prototype.pointClass);q(k.prototype,{ttBelow:!1});return k});x(c,"Series/Bubble/BubbleSeries.js",[c["Series/Bubble/BubbleLegendComposition.js"],c["Series/Bubble/BubblePoint.js"],c["Core/Color/Color.js"],c["Core/Globals.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,q,m,p,f){function d(){var a=this,b=this.len,c=this.chart,d=this.isXAxis,e=d?"xData":"yData",h=this.min,f=this.max-h,l=0,k=b,n=b/f,m;this.series.forEach(function(b){if(b.bubblePadding&&
(b.visible||!c.options.chart.ignoreHiddenSeries)){m=a.allowZoomOutside=!0;var p=b[e];d&&((b.onPoint||b).getRadii(0,0,b),b.onPoint&&(b.radii=b.onPoint.radii));if(0<f)for(var q=p.length;q--;)if(g(p[q])&&a.dataMin<=p[q]&&p[q]<=a.max){var r=b.radii&&b.radii[q]||0;l=Math.min((p[q]-h)*n-r,l);k=Math.max((p[q]-h)*n+r,k)}}});m&&0<f&&!this.logarithmic&&(k-=b,n*=(b+Math.max(0,l)-Math.min(k,b))/b,[["min","userMin",l],["max","userMax",k]].forEach(function(b){"undefined"===typeof z(a.options[b[0]],a[b[1]])&&(a[b[0]]+=
b[2]/n)}))}var w=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,
new d)}}(),r=q.parse;q=m.noop;var l=p.series,u=p.seriesTypes;m=u.column.prototype;var b=u.scatter;u=f.addEvent;var a=f.arrayMax,e=f.arrayMin,t=f.clamp,n=f.extend,g=f.isNumber,A=f.merge,z=f.pick,h=[],y=function(k){function m(){var a=null!==k&&k.apply(this,arguments)||this;a.data=void 0;a.maxPxSize=void 0;a.minPxSize=void 0;a.options=void 0;a.points=void 0;a.radii=void 0;a.yData=void 0;a.zData=void 0;return a}w(m,k);m.compose=function(a,b,e,g){c.compose(b,e,g);f.pushUnique(h,a)&&(a.prototype.beforePadding=
d)};m.prototype.animate=function(a){!a&&this.points.length<this.options.animationLimit&&this.points.forEach(function(a){var b=a.graphic;b&&b.width&&(this.hasRendered||b.attr({x:a.plotX,y:a.plotY,width:1,height:1}),b.animate(this.markerAttribs(a),this.options.animation))},this)};m.prototype.getRadii=function(){var a=this,b=this.zData,c=this.yData,d=[],e=this.chart.bubbleZExtremes;var h=this.getPxExtremes();var g=h.minPxSize,f=h.maxPxSize;if(!e){var l=Number.MAX_VALUE,k=-Number.MAX_VALUE,n;this.chart.series.forEach(function(b){b.bubblePadding&&
(b.visible||!a.chart.options.chart.ignoreHiddenSeries)&&(b=(b.onPoint||b).getZExtremes())&&(l=Math.min(z(l,b.zMin),b.zMin),k=Math.max(z(k,b.zMax),b.zMax),n=!0)});n?(e={zMin:l,zMax:k},this.chart.bubbleZExtremes=e):e={zMin:0,zMax:0}}var m=0;for(h=b.length;m<h;m++){var p=b[m];d.push(this.getRadius(e.zMin,e.zMax,g,f,p,c&&c[m]))}this.radii=d};m.prototype.getRadius=function(a,b,c,d,e,h){var f=this.options,l="width"!==f.sizeBy,k=f.zThreshold,n=b-a,m=.5;if(null===h||null===e)return null;if(g(e)){f.sizeByAbsoluteValue&&
(e=Math.abs(e-k),n=Math.max(b-k,Math.abs(a-k)),a=0);if(e<a)return c/2-1;0<n&&(m=(e-a)/n)}l&&0<=m&&(m=Math.sqrt(m));return Math.ceil(c+m*(d-c))/2};m.prototype.hasData=function(){return!!this.processedXData.length};m.prototype.pointAttribs=function(a,b){var c=this.options.marker.fillOpacity;a=l.prototype.pointAttribs.call(this,a,b);1!==c&&(a.fill=r(a.fill).setOpacity(c).get("rgba"));return a};m.prototype.translate=function(){k.prototype.translate.call(this);this.getRadii();this.translateBubble()};m.prototype.translateBubble=
function(){for(var a=this.data,b=this.radii,c=this.getPxExtremes().minPxSize,d=a.length;d--;){var e=a[d],h=b?b[d]:0;g(h)&&h>=c/2?(e.marker=n(e.marker,{radius:h,width:2*h,height:2*h}),e.dlBox={x:e.plotX-h,y:e.plotY-h,width:2*h,height:2*h}):(e.shapeArgs=e.plotY=e.dlBox=void 0,e.isInside=!1)}};m.prototype.getPxExtremes=function(){var a=Math.min(this.chart.plotWidth,this.chart.plotHeight),b=function(b){if("string"===typeof b){var c=/%$/.test(b);b=parseInt(b,10)}return c?a*b/100:b},c=b(z(this.options.minSize,
8));b=Math.max(b(z(this.options.maxSize,"20%")),c);return{minPxSize:c,maxPxSize:b}};m.prototype.getZExtremes=function(){var b=this.options,c=(this.zData||[]).filter(g);if(c.length){var d=z(b.zMin,t(e(c),!1===b.displayNegative?b.zThreshold||0:-Number.MAX_VALUE,Number.MAX_VALUE));b=z(b.zMax,a(c));if(g(d)&&g(b))return{zMin:d,zMax:b}}};m.defaultOptions=A(b.defaultOptions,{dataLabels:{formatter:function(){var a=this.series.chart.numberFormatter,b=this.point.z;return g(b)?a(b,-1):""},inside:!0,verticalAlign:"middle"},
animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"});return m}(b);n(y.prototype,{alignDataLabel:m.alignDataLabel,applyZones:q,bubblePadding:!0,buildKDTree:q,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:k,parallelArrays:["x","y",
"z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"});u(y,"updatedData",function(a){delete a.target.chart.bubbleZExtremes});u(y,"remove",function(a){delete a.target.chart.bubbleZExtremes});p.registerSeriesType("bubble",y);"";"";return y});x(c,"Series/MapBubble/MapBubblePoint.js",[c["Series/Bubble/BubblePoint.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,q){var m=this&&this.__extends||function(){var c=function(f,d){c=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(c,d){c.__proto__=d}||function(c,d){for(var f in d)Object.prototype.hasOwnProperty.call(d,f)&&(c[f]=d[f])};return c(f,d)};return function(f,d){function k(){this.constructor=f}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");c(f,d);f.prototype=null===d?Object.create(d):(k.prototype=d.prototype,new k)}}();k=k.seriesTypes.map.prototype.pointClass.prototype;q=q.extend;c=function(c){function f(){return null!==
c&&c.apply(this,arguments)||this}m(f,c);f.prototype.isValid=function(){return"number"===typeof this.z};return f}(c);q(c.prototype,{applyOptions:k.applyOptions,getProjectedBounds:k.getProjectedBounds});return c});x(c,"Series/MapBubble/MapBubbleSeries.js",[c["Series/Bubble/BubbleSeries.js"],c["Series/MapBubble/MapBubblePoint.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,q,m){var p=this&&this.__extends||function(){var c=function(d,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return c(d,b)};return function(d,b){function a(){this.constructor=d}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");c(d,b);d.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),f=q.seriesTypes,d=f.map.prototype,w=f.mappoint.prototype;f=m.extend;var r=m.merge;m=function(f){function k(){var b=
null!==f&&f.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;b.clearBounds=d.clearBounds;return b}p(k,f);k.prototype.searchPoint=function(b,a){return this.searchKDTree({clientX:b.chartX-this.chart.plotLeft,plotY:b.chartY-this.chart.plotTop},a,b)};k.prototype.translate=function(){w.translate.call(this);this.getRadii();this.translateBubble()};k.prototype.updateParallelArrays=function(b,a,c){f.prototype.updateParallelArrays.call(this,b,a,c);b=this.processedXData;a=this.xData;
b&&a&&(b.length=a.length)};k.defaultOptions=r(c.defaultOptions,{lineWidth:0,animationLimit:500,joinBy:"hc-key",tooltip:{pointFormat:"{point.name}: {point.z}"}});return k}(c);f(m.prototype,{type:"mapbubble",axisTypes:["colorAxis"],getProjectedBounds:d.getProjectedBounds,isCartesian:!1,pointArrayMap:["z"],pointClass:k,processData:d.processData,projectPoint:w.projectPoint,setData:d.setData,setOptions:d.setOptions,updateData:d.updateData,useMapGeometry:!0,xyFromShape:!0});q.registerSeriesType("mapbubble",
m);"";return m});x(c,"Series/Heatmap/HeatmapPoint.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k){var q=this&&this.__extends||function(){var c=function(d,f){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,b){c.__proto__=b}||function(c,b){for(var a in b)Object.prototype.hasOwnProperty.call(b,a)&&(c[a]=b[a])};return c(d,f)};return function(d,f){function k(){this.constructor=d}if("function"!==typeof f&&null!==f)throw new TypeError("Class extends value "+
String(f)+" is not a constructor or null");c(d,f);d.prototype=null===f?Object.create(f):(k.prototype=f.prototype,new k)}}(),m=k.clamp,p=k.defined,f=k.extend,d=k.pick;c=function(c){function f(){var d=null!==c&&c.apply(this,arguments)||this;d.options=void 0;d.series=void 0;d.value=void 0;d.x=void 0;d.y=void 0;return d}q(f,c);f.prototype.applyOptions=function(d,f){(this.isNull||null===this.value)&&delete this.color;c.prototype.applyOptions.call(this,d,f);this.formatPrefix=this.isNull||null===this.value?
"null":"point";return this};f.prototype.getCellAttributes=function(){var c=this.series,f=c.options,b=(f.colsize||1)/2,a=(f.rowsize||1)/2,e=c.xAxis,k=c.yAxis,n=this.options.marker||c.options.marker;c=c.pointPlacementToXValue();var g=d(this.pointPadding,f.pointPadding,0),q={x1:m(Math.round(e.len-e.translate(this.x-b,!1,!0,!1,!0,-c)),-e.len,2*e.len),x2:m(Math.round(e.len-e.translate(this.x+b,!1,!0,!1,!0,-c)),-e.len,2*e.len),y1:m(Math.round(k.translate(this.y-a,!1,!0,!1,!0)),-k.len,2*k.len),y2:m(Math.round(k.translate(this.y+
a,!1,!0,!1,!0)),-k.len,2*k.len)};[["width","x"],["height","y"]].forEach(function(a){var b=a[0];a=a[1];var c=a+"1",d=a+"2",f=Math.abs(q[c]-q[d]),l=n&&n.lineWidth||0,m=Math.abs(q[c]+q[d])/2;b=n&&n[b];p(b)&&b<f&&(b=b/2+l/2,q[c]=m-b,q[d]=m+b);if(g){if("x"===a&&e.reversed||"y"===a&&!k.reversed)c=d,d=a+"1";q[c]+=g;q[d]-=g}});return q};f.prototype.haloPath=function(c){if(!c)return[];var d=this.shapeArgs||{},b=d.x;b=void 0===b?0:b;var a=d.y;a=void 0===a?0:a;var e=d.width;e=void 0===e?0:e;d=d.height;d=void 0===
d?0:d;return[["M",b-c,a-c],["L",b-c,a+d+c],["L",b+e+c,a+d+c],["L",b+e+c,a-c],["Z"]]};f.prototype.isValid=function(){return Infinity!==this.value&&-Infinity!==this.value};return f}(c.seriesTypes.scatter.prototype.pointClass);f(c.prototype,{dataLabelOnNull:!0,moveToTopOnHover:!0,ttBelow:!1});return c});x(c,"Series/Heatmap/HeatmapSeries.js",[c["Core/Color/Color.js"],c["Series/ColorMapComposition.js"],c["Series/Heatmap/HeatmapPoint.js"],c["Core/Legend/LegendSymbol.js"],c["Core/Series/SeriesRegistry.js"],
c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,k,q,m,p,f,d){var w=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");
a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),r=p.series,l=p.seriesTypes,u=l.column,b=l.scatter,a=f.prototype.symbols;f=d.extend;var e=d.fireEvent,t=d.isNumber,n=d.merge,g=d.pick;d=function(d){function f(){var a=null!==d&&d.apply(this,arguments)||this;a.colorAxis=void 0;a.data=void 0;a.options=void 0;a.points=void 0;a.valueMax=NaN;a.valueMin=NaN;return a}w(f,d);f.prototype.drawPoints=function(){var a=this;if((this.options.marker||{}).enabled||this._hasPointMarkers)r.prototype.drawPoints.call(this),
this.points.forEach(function(b){b.graphic&&(b.graphic[a.chart.styledMode?"css":"animate"](a.colorAttribs(b)),null===b.value&&b.graphic.addClass("highcharts-null-point"))})};f.prototype.getExtremes=function(){var a=r.prototype.getExtremes.call(this,this.valueData),b=a.dataMin;a=a.dataMax;t(b)&&(this.valueMin=b);t(a)&&(this.valueMax=a);return r.prototype.getExtremes.call(this)};f.prototype.getValidPoints=function(a,b){return r.prototype.getValidPoints.call(this,a,b,!0)};f.prototype.hasData=function(){return!!this.processedXData.length};
f.prototype.init=function(){d.prototype.init.apply(this,arguments);var b=this.options;b.pointRange=g(b.pointRange,b.colsize||1);this.yAxis.axisPointRange=b.rowsize||1;a.ellipse=a.circle;b.marker&&t(b.borderRadius)&&(b.marker.r=b.borderRadius)};f.prototype.markerAttribs=function(a,b){var c=a.shapeArgs||{};if(a.hasImage)return{x:a.plotX,y:a.plotY};if(b&&"normal"!==b){var d=a.options.marker||{};a=this.options.marker||{};a=a.states&&a.states[b]||{};d=d.states&&d.states[b]||{};b=(d.width||a.width||c.width||
0)+(d.widthPlus||a.widthPlus||0);a=(d.height||a.height||c.height||0)+(d.heightPlus||a.heightPlus||0);return{x:(c.x||0)+((c.width||0)-b)/2,y:(c.y||0)+((c.height||0)-a)/2,width:b,height:a}}return c};f.prototype.pointAttribs=function(a,b){var d=r.prototype.pointAttribs.call(this,a,b),e=this.options||{},f=this.chart.options.plotOptions||{},g=f.series||{},h=f.heatmap||{};f=a&&a.options.borderColor||e.borderColor||h.borderColor||g.borderColor;g=a&&a.options.borderWidth||e.borderWidth||h.borderWidth||g.borderWidth||
d["stroke-width"];d.stroke=a&&a.marker&&a.marker.lineColor||e.marker&&e.marker.lineColor||f||this.color;d["stroke-width"]=g;b&&"normal"!==b&&(a=n(e.states&&e.states[b],e.marker&&e.marker.states&&e.marker.states[b],a&&a.options.states&&a.options.states[b]||{}),d.fill=a.color||c.parse(d.fill).brighten(a.brightness||0).get(),d.stroke=a.lineColor||d.stroke);return d};f.prototype.translate=function(){var b=this.options,c=b.borderRadius,d=(b=b.marker)&&b.symbol||"rect",f=a[d]?d:"rect",g=-1!==["circle",
"square"].indexOf(f);this.generatePoints();this.points.forEach(function(b){var e=b.getCellAttributes(),h=Math.min(e.x1,e.x2),k=Math.min(e.y1,e.y2),l=Math.max(Math.abs(e.x2-e.x1),0),m=Math.max(Math.abs(e.y2-e.y1),0);b.hasImage=0===(b.marker&&b.marker.symbol||d||"").indexOf("url");g&&(k=Math.abs(l-m),h=Math.min(e.x1,e.x2)+(l<m?0:k/2),k=Math.min(e.y1,e.y2)+(l<m?k/2:0),l=m=Math.min(l,m));b.hasImage&&(b.marker={width:l,height:m});b.plotX=b.clientX=(e.x1+e.x2)/2;b.plotY=(e.y1+e.y2)/2;b.shapeType="path";
b.shapeArgs=n(!0,{x:h,y:k,width:l,height:m},{d:a[f](h,k,l,m,{r:t(c)?c:0})})});e(this,"afterTranslate")};f.defaultOptions=n(b.defaultOptions,{animation:!1,borderRadius:0,borderWidth:0,nullColor:"#f7f7f7",dataLabels:{formatter:function(){var a=this.series.chart.numberFormatter,b=this.point.value;return t(b)?a(b,-1):""},inside:!0,verticalAlign:"middle",crop:!1,overflow:"allow",padding:0},marker:{symbol:"rect",radius:0,lineColor:void 0,states:{hover:{lineWidthPlus:0},select:{}}},clip:!0,pointRange:null,
tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}});return f}(b);f(d.prototype,{axisTypes:k.seriesMembers.axisTypes,colorKey:k.seriesMembers.colorKey,directTouch:!0,getExtremesFromAll:!0,parallelArrays:k.seriesMembers.parallelArrays,pointArrayMap:["y","value"],pointClass:q,specialGroup:"group",trackerGroups:k.seriesMembers.trackerGroups,alignDataLabel:u.prototype.alignDataLabel,colorAttribs:k.seriesMembers.colorAttribs,drawLegendSymbol:m.drawRectangle,
getSymbol:r.prototype.getSymbol});k.compose(d);p.registerSeriesType("heatmap",d);"";"";return d});x(c,"masters/modules/map.src.js",[c["Core/Globals.js"],c["Core/Axis/Color/ColorAxis.js"],c["Series/MapBubble/MapBubbleSeries.js"],c["Core/Chart/MapChart.js"],c["Maps/MapView.js"],c["Maps/Projection.js"]],function(c,k,q,m,p,f){c.ColorAxis=k;c.MapChart=m;c.mapChart=c.Map=m.mapChart;c.MapView=p;c.maps=m.maps;c.Projection=f;k.compose(c.Chart,c.Fx,c.Legend,c.Series);q.compose(c.Axis,c.Chart,c.Legend,c.Series)})});
//# sourceMappingURL=map.js.map