/*
 Highcharts JS v11.0.0 (2023-04-26)

 Highcharts funnel module

 (c) 2010-2021 Kacper Madej

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/funnel3d",["highcharts","highcharts/highcharts-3d","highcharts/modules/cylinder"],function(n){a(n);a.Highcharts=n;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function n(a,g,F,l){a.hasOwnProperty(g)||(a[g]=l.apply(null,F),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",
{detail:{path:g,module:a[g]}})))}a=a?a._modules:{};n(a,"Series/Funnel3D/Funnel3DComposition.js",[a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Renderer/SVG/SVGRenderer3D.js"],a["Core/Utilities.js"]],function(a,g,F,l){var d=a.parse,h=g.charts,N=l.error,O=l.extend,p=l.merge,m;(function(a){function l(a){a.funnel3d=p(a.cuboid,{parts:"top bottom frontUpper backUpper frontLower backLower rightUpper rightLower".split(" "),mainParts:["top","bottom"],sideGroups:["upperGroup","lowerGroup"],sideParts:{upperGroup:["frontUpper",
"backUpper","rightUpper"],lowerGroup:["frontLower","backLower","rightLower"]},pathType:"funnel3d",opacitySetter:function(a){var b=this,c=b.parts,k=g.charts[b.renderer.chartIndex],e="group-opacity-"+a+"-"+k.index;b.parts=b.mainParts;b.singleSetterForParts("opacity",a);b.parts=c;k.renderer.filterId||(k.renderer.definition({tagName:"filter",attributes:{id:e},children:[{tagName:"feComponentTransfer",children:[{tagName:"feFuncA",attributes:{type:"table",tableValues:"0 "+a}}]}]}),b.sideGroups.forEach(function(c){b[c].attr({filter:"url(#"+
e+")"})}),b.renderer.styledMode&&(k.renderer.definition({tagName:"style",textContent:".highcharts-"+e+" {filter:url(#"+e+")}"}),b.sideGroups.forEach(function(b){b.addClass("highcharts-"+e)})));return b},fillSetter:function(a){var b=this,c=d(a),k=c.rgba[3],e={top:d(a).brighten(.1).get(),bottom:d(a).brighten(-.2).get()};1>k?(c.rgba[3]=1,c=c.get("rgb"),b.attr({opacity:k})):c=a;c.linearGradient||c.radialGradient||!b.gradientForSides||(c={linearGradient:{x1:0,x2:1,y1:1,y2:1},stops:[[0,d(a).brighten(-.2).get()],
[.5,a],[1,d(a).brighten(-.2).get()]]});c.linearGradient?b.sideGroups.forEach(function(a){var k=b[a].gradientBox,z=c.linearGradient,h=p(c,{linearGradient:{x1:k.x+z.x1*k.width,y1:k.y+z.y1*k.height,x2:k.x+z.x2*k.width,y2:k.y+z.y2*k.height}});b.sideParts[a].forEach(function(b){e[b]=h})}):(p(!0,e,{frontUpper:c,backUpper:c,rightUpper:c,frontLower:c,backLower:c,rightLower:c}),c.radialGradient&&b.sideGroups.forEach(function(c){var a=b[c].gradientBox,e=a.x+a.width/2,k=a.y+a.height/2,z=Math.min(a.width,a.height);
b.sideParts[c].forEach(function(c){b[c].setRadialReference([e,k,z])})}));b.singleSetterForParts("fill",null,e);b.color=b.fill=a;c.linearGradient&&[b.frontLower,b.frontUpper].forEach(function(c){(c=(c=c.element)&&b.renderer.gradients[c.gradient])&&"userSpaceOnUse"!==c.attr("gradientUnits")&&c.attr({gradientUnits:"userSpaceOnUse"})});return b},adjustForGradient:function(){var a=this,b;a.sideGroups.forEach(function(c){var k={x:Number.MAX_VALUE,y:Number.MAX_VALUE},e={x:-Number.MAX_VALUE,y:-Number.MAX_VALUE};
a.sideParts[c].forEach(function(c){b=a[c].getBBox(!0);k={x:Math.min(k.x,b.x),y:Math.min(k.y,b.y)};e={x:Math.max(e.x,b.x+b.width),y:Math.max(e.y,b.y+b.height)}});a[c].gradientBox={x:k.x,width:e.x-k.x,y:k.y,height:e.y-k.y}})},zIndexSetter:function(){this.finishedOnAdd&&this.adjustForGradient();return this.renderer.Element.prototype.zIndexSetter.apply(this,arguments)},onAdd:function(){this.adjustForGradient();this.finishedOnAdd=!0}})}function m(a){var l=a.prototype;O(l,{funnel3d:function(b){var c=this.element3d("funnel3d",
b),a=this.styledMode,e={"stroke-width":1,stroke:"none"};c.upperGroup=this.g("funnel3d-upper-group").attr({zIndex:c.frontUpper.zIndex}).add(c);[c.frontUpper,c.backUpper,c.rightUpper].forEach(function(b){a||b.attr(e);b.add(c.upperGroup)});c.lowerGroup=this.g("funnel3d-lower-group").attr({zIndex:c.frontLower.zIndex}).add(c);[c.frontLower,c.backLower,c.rightLower].forEach(function(b){a||b.attr(e);b.add(c.lowerGroup)});c.gradientForSides=b.gradientForSides;return c},funnel3dPath:function(b){this.getCylinderEnd||
N("A required Highcharts module is missing: cylinder.js",!0,h[this.chartIndex]);var c=h[this.chartIndex],a=b.alphaCorrection=90-Math.abs(c.options.chart.options3d.alpha%180-90),e=l.cuboidPath.call(this,p(b,{depth:b.width,width:(b.width+b.bottom.width)/2})),z=e.isTop,d=!e.isFront,g=!!b.middle,A=this.getCylinderEnd(c,p(b,{x:b.x-b.width/2,z:b.z-b.width/2,alphaCorrection:a})),f=b.bottom.width,m=p(b,{width:f,x:b.x-f/2,z:b.z-f/2,alphaCorrection:a}),w=this.getCylinderEnd(c,m,!0),q=f,v=m,t=w,x=w;g&&(q=b.middle.width,
v=p(b,{y:b.y+b.middle.fraction*b.height,width:q,x:b.x-q/2,z:b.z-q/2}),t=this.getCylinderEnd(c,v,!1),x=this.getCylinderEnd(c,v,!1));e={top:A,bottom:w,frontUpper:this.getCylinderFront(A,t),zIndexes:{group:e.zIndexes.group,top:0!==z?0:3,bottom:1!==z?0:3,frontUpper:d?2:1,backUpper:d?1:2,rightUpper:d?2:1}};e.backUpper=this.getCylinderBack(A,t);A=1!==Math.min(q,b.width)/Math.max(q,b.width);e.rightUpper=this.getCylinderFront(this.getCylinderEnd(c,p(b,{x:b.x-b.width/2,z:b.z-b.width/2,alphaCorrection:A?-a:
0}),!1),this.getCylinderEnd(c,p(v,{alphaCorrection:A?-a:0}),!g));g&&(A=1!==Math.min(q,f)/Math.max(q,f),p(!0,e,{frontLower:this.getCylinderFront(x,w),backLower:this.getCylinderBack(x,w),rightLower:this.getCylinderFront(this.getCylinderEnd(c,p(m,{alphaCorrection:A?-a:0}),!0),this.getCylinderEnd(c,p(v,{alphaCorrection:A?-a:0}),!1)),zIndexes:{frontLower:d?2:1,backLower:d?1:2,rightLower:d?1:2}}));return e}})}a.compose=function(a){F.compose(a);l(a.prototype.elements3d);m(a)}})(m||(m={}));return m});n(a,
"Series/Funnel3D/Funnel3DPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,g){var m=this&&this.__extends||function(){var a=function(d,h){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,d){a.__proto__=d}||function(a,d){for(var h in d)Object.prototype.hasOwnProperty.call(d,h)&&(a[h]=d[h])};return a(d,h)};return function(d,h){function g(){this.constructor=d}if("function"!==typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");
a(d,h);d.prototype=null===h?Object.create(h):(g.prototype=h.prototype,new g)}}();g=g.extend;a=function(a){function d(){var d=null!==a&&a.apply(this,arguments)||this;d.dlBoxRaw=void 0;d.options=void 0;d.series=void 0;d.y=void 0;return d}m(d,a);return d}(a.seriesTypes.column.prototype.pointClass);g(a.prototype,{shapeType:"funnel3d"});return a});n(a,"Series/Funnel3D/Funnel3DSeries.js",[a["Series/Funnel3D/Funnel3DComposition.js"],a["Series/Funnel3D/Funnel3DPoint.js"],a["Core/Globals.js"],a["Core/Math3D.js"],
a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,g,n,l,d,h){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");
a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}();n=n.noop;var F=l.perspective,p=d.series,B=d.seriesTypes.column,I=h.extend,M=h.merge,G=h.pick,v=h.relativeLength;l=function(d){function b(){var a=null!==d&&d.apply(this,arguments)||this;a.center=void 0;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(b,d);b.prototype.alignDataLabel=function(a,b,e){var c=a.dlBoxRaw,d=this.chart.inverted,k=a.plotY>G(this.translatedThreshold,this.yAxis.len),g=G(e.inside,!!this.options.stacking),
f={x:c.x,y:c.y,height:0};e.align=G(e.align,!d||g?"center":k?"right":"left");e.verticalAlign=G(e.verticalAlign,d||g?"middle":k?"top":"bottom");"top"!==e.verticalAlign&&(f.y+=c.bottom/("bottom"===e.verticalAlign?1:2));f.width=this.getWidthAt(f.y);this.options.reversed&&(f.width=c.fullWidth-f.width);g?f.x-=f.width/2:"left"===e.align?(e.align="right",f.x-=1.5*f.width):"right"===e.align?(e.align="left",f.x+=f.width/2):f.x-=f.width/2;a.dlBox=f;B.prototype.alignDataLabel.apply(this,arguments)};b.prototype.bindAxes=
function(){p.prototype.bindAxes.apply(this,arguments);I(this.xAxis.options,{gridLineWidth:0,lineWidth:0,title:void 0,tickPositions:[]});M(!0,this.yAxis.options,{gridLineWidth:0,title:void 0,labels:{enabled:!1}})};b.prototype.translate=function(){p.prototype.translate.apply(this,arguments);var a=0,b=this.chart,e=this.options,d=e.reversed,g=e.ignoreHiddenPoint,h=b.plotWidth,l=b.plotHeight,f=0,m=e.center,w=v(m[0],h),q=v(m[1],l),n=v(e.width,h),t,x,u=v(e.height,l),B=v(e.neckWidth,h),J=v(e.neckHeight,l),
E=q-u/2+u-J;h=this.data;var C,K,y,D,L,H,r;this.getWidthAt=x=function(a){var b=q-u/2;return a>E||u===J?B:B+(n-B)*(1-(a-b)/(u-J))};this.center=[w,q,u];this.centerX=w;h.forEach(function(b){g&&!1===b.visible||(a+=b.y)});h.forEach(function(c){L=null;C=a?c.y/a:0;y=q-u/2+f*u;D=y+C*u;t=x(y);H=D-y;r={gradientForSides:G(c.options.gradientForSides,e.gradientForSides),x:w,y,height:H,width:t,z:1,top:{width:t}};t=x(D);r.bottom={fraction:C,width:t};y>=E?r.isCylinder=!0:D>E&&(L=D,t=x(E),D=E,r.bottom.width=t,r.middle=
{fraction:H?(E-y)/H:0,width:t});d&&(r.y=y=q+u/2-(f+C)*u,r.middle&&(r.middle.fraction=1-(H?r.middle.fraction:0)),t=r.width,r.width=r.bottom.width,r.bottom.width=t);c.shapeArgs=I(c.shapeArgs,r);c.percentage=100*C;c.plotX=w;c.plotY=d?q+u/2-(f+C/2)*u:(y+(L||D))/2;K=F([{x:w,y:c.plotY,z:d?-(n-x(c.plotY))/2:-x(c.plotY)/2}],b,!0)[0];c.tooltipPos=[K.x,K.y];c.dlBoxRaw={x:w,width:x(c.plotY),y,bottom:r.height||0,fullWidth:n};g&&!1===c.visible||(f+=C)})};b.compose=a.compose;b.defaultOptions=M(B.defaultOptions,
{center:["50%","50%"],width:"90%",neckWidth:"30%",height:"100%",neckHeight:"25%",reversed:!1,gradientForSides:!0,animation:!1,edgeWidth:0,colorByPoint:!0,showInLegend:!1,dataLabels:{align:"right",crop:!1,inside:!1,overflow:"allow"}});return b}(B);I(l.prototype,{pointClass:g,translate3dShapes:n});d.registerSeriesType("funnel3d",l);"";return l});n(a,"masters/modules/funnel3d.src.js",[a["Core/Renderer/RendererRegistry.js"],a["Series/Funnel3D/Funnel3DSeries.js"]],function(a,g){g.compose(a.getRendererType());
return g})});
//# sourceMappingURL=funnel3d.js.map