/*
 Highstock JS v11.0.0 (2023-04-26)

 Drag-panes module

 (c) 2010-2021 Highsoft AS
 Author: Kacper Madej

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/drag-panes",["highcharts","highcharts/modules/stock"],function(e){a(e);a.Highcharts=e;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function e(a,c,d,e){a.hasOwnProperty(c)||(a[c]=e.apply(null,d),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:c,
module:a[c]}})))}a=a?a._modules:{};e(a,"Extensions/DragPanes/AxisResizerDefaults.js",[],function(){return{minLength:"10%",maxLength:"100%",resize:{controlledAxis:{next:[],prev:[]},enabled:!1,cursor:"ns-resize",lineColor:"#cccccc",lineDashStyle:"Solid",lineWidth:4,x:0,y:0}}});e(a,"Extensions/DragPanes/AxisResizer.js",[a["Extensions/DragPanes/AxisResizerDefaults.js"],a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,c,d){var e=c.hasTouch,l=d.addEvent,k=d.clamp,u=d.isNumber,m=d.objectEach,r=d.relativeLength;
return function(){function c(b){this.options=this.lastPos=this.controlLine=this.axis=void 0;this.init(b)}c.prototype.init=function(b,f){this.axis=b;this.options=b.options.resize;this.render();f||this.addMouseEvents()};c.prototype.render=function(){var b=this.axis,f=b.chart,a=this.options,c=a.x||0,e=a.y,d=k(b.top+b.height+e,f.plotTop,f.plotTop+f.plotHeight),h={};f.styledMode||(h={cursor:a.cursor,stroke:a.lineColor,"stroke-width":a.lineWidth,dashstyle:a.lineDashStyle});this.lastPos=d-e;this.controlLine||
(this.controlLine=f.renderer.path().addClass("highcharts-axis-resizer"));this.controlLine.add(b.axisGroup);a=f.styledMode?this.controlLine.strokeWidth():a.lineWidth;h.d=f.renderer.crispLine([["M",b.left+c,d],["L",b.left+b.width+c,d]],a);this.controlLine.attr(h)};c.prototype.addMouseEvents=function(){var b=this,a=b.controlLine.element,c=b.axis.chart.container,d=[],k,n,h;b.mouseMoveHandler=k=function(a){b.onMouseMove(a)};b.mouseUpHandler=n=function(a){b.onMouseUp(a)};b.mouseDownHandler=h=function(a){b.onMouseDown(a)};
d.push(l(c,"mousemove",k),l(c.ownerDocument,"mouseup",n),l(a,"mousedown",h));e&&d.push(l(c,"touchmove",k),l(c.ownerDocument,"touchend",n),l(a,"touchstart",h));b.eventsToUnbind=d};c.prototype.onMouseMove=function(b){b.touches&&0===b.touches[0].pageX||!this.grabbed||(this.hasDragged=!0,this.updateAxes(this.axis.chart.pointer.normalize(b).chartY-this.options.y))};c.prototype.onMouseUp=function(b){this.hasDragged&&this.updateAxes(this.axis.chart.pointer.normalize(b).chartY-this.options.y);this.grabbed=
this.hasDragged=this.axis.chart.activeResizer=null};c.prototype.onMouseDown=function(b){this.axis.chart.pointer.reset(!1,0);this.grabbed=this.axis.chart.activeResizer=!0};c.prototype.updateAxes=function(b){var a=this,c=a.axis.chart,d=a.options.controlledAxis,e=0===d.next.length?[c.yAxis.indexOf(a.axis)+1]:d.next;d=[a.axis].concat(d.prev);var l=[],h=c.plotTop,p=c.plotHeight,v=h+p;b=k(b,h,v);var m=!1,t=b-a.lastPos;1>t*t||([d,e].forEach(function(d,f){d.forEach(function(d,e){var g=(d=u(d)?c.yAxis[d]:
f||e?c.get(d):d)&&d.options;if(g&&"navigator-y-axis"!==g.id){e=d.top;var n=Math.round(r(g.minLength,p)),q=Math.round(r(g.maxLength,p));f?(t=b-a.lastPos,g=Math.round(k(d.len-t,n,q)),e=d.top+t,e+g>v&&(q=v-g-e,b+=q,e+=q),e<h&&(e=h,e+g>v&&(g=p)),g===n&&(m=!0),l.push({axis:d,options:{top:100*(e-h)/p+"%",height:100*g/p+"%"}})):(g=Math.round(k(b-e,n,q)),g===q&&(m=!0),b=e+g,l.push({axis:d,options:{height:100*g/p+"%"}}))}})}),m||(l.forEach(function(b){b.axis.update(b.options,!1)}),c.redraw(!1)))};c.prototype.destroy=
function(){var b=this;delete b.axis.resizer;this.eventsToUnbind&&this.eventsToUnbind.forEach(function(b){b()});b.controlLine.destroy();m(b,function(a,c){b[c]=null})};c.resizerOptions=a;return c}()});e(a,"Extensions/DragPanes/DragPanes.js",[a["Extensions/DragPanes/AxisResizer.js"],a["Core/Utilities.js"]],function(a,c){function d(){var b=this.resizer,c=this.options.resize;c&&(c=!1!==c.enabled,b?c?b.init(this,!0):b.destroy():c&&(this.resizer=new a(this)))}function e(b){!b.keepEvents&&this.resizer&&this.resizer.destroy()}
function k(b){this.chart.activeResizer||b.apply(this,Array.prototype.slice.call(arguments,1))}function x(b){this.chart.activeResizer||b.apply(this,Array.prototype.slice.call(arguments,1))}var u=c.addEvent,m=c.merge,r=c.wrap,w=[];return{compose:function(b,f){c.pushUnique(w,b)&&(m(!0,b.defaultOptions,a.resizerOptions),b.keepProps.push("resizer"),u(b,"afterRender",d),u(b,"destroy",e));c.pushUnique(w,f)&&(r(f.prototype,"runPointActions",x),r(f.prototype,"drag",k))}}});e(a,"masters/modules/drag-panes.src.js",
[a["Core/Globals.js"],a["Extensions/DragPanes/AxisResizer.js"],a["Extensions/DragPanes/DragPanes.js"]],function(a,c,d){a.AxisResizer=c;d.compose(a.Axis,a.Pointer)})});
//# sourceMappingURL=drag-panes.js.map