/*
 Highstock JS v11.0.0 (2023-04-26)

 Data grouping module

 (c) 2010-2021 Torstein Hnsi

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/datagrouping",["highcharts"],function(h){a(h);a.Highcharts=h;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function h(a,b,m,k){a.hasOwnProperty(b)||(a[b]=k.apply(null,m),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:b,module:a[b]}})))}a=a?
a._modules:{};h(a,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}});h(a,"Extensions/DataGrouping/ApproximationDefaults.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Core/Utilities.js"]],function(a,b){function m(d){var a=d.length;d=k(d);l(d)&&a&&(d=h(d/a));return d}function k(a){var d=a.length;if(!d&&a.hasNulls)var b=null;else if(d)for(b=0;d--;)b+=a[d];return b}var g=b.arrayMax,c=b.arrayMin,h=b.correctFloat,G=b.extend,l=b.isNumber;b={average:m,averages:function(){var a=
[];[].forEach.call(arguments,function(d){a.push(m(d))});return"undefined"===typeof a[0]?void 0:a},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},high:function(a){return a.length?g(a):a.hasNulls?null:void 0},hlc:function(d,b,e){d=a.high(d);b=a.low(b);e=a.close(e);if(l(d)||l(b)||l(e))return[d,b,e]},low:function(a){return a.length?c(a):a.hasNulls?null:void 0},ohlc:function(d,b,e,t){d=a.open(d);b=a.high(b);e=a.low(e);t=a.close(t);if(l(d)||l(b)||l(e)||l(t))return[d,b,e,t]},open:function(a){return a.length?
a[0]:a.hasNulls?null:void 0},range:function(b,c){b=a.low(b);c=a.high(c);if(l(b)||l(c))return[b,c];if(null===b&&null===c)return null},sum:k};G(a,b);return b});h(a,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %e %b, %H:%M:%S.%L","%A, %e %b, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %e %b, %H:%M:%S","%A, %e %b, %H:%M:%S","-%H:%M:%S"],minute:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],hour:["%A, %e %b, %H:%M",
"%A, %e %b, %H:%M","-%H:%M"],day:["%A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],week:["Week from %A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",
[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}});h(a,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Utilities.js"]],function(a,b){function m(a){var b=this,t=b.series;t.forEach(function(a){a.groupPixelWidth=void 0});t.forEach(function(t){t.groupPixelWidth=b.getGroupPixelWidth&&b.getGroupPixelWidth();t.groupPixelWidth&&(t.hasProcessed=!0);t.applyGrouping(!!a.hasExtremesChanged)})}
function k(){for(var b=this.series,e=b.length,c=0,l=!1,g,q;e--;)if(q=b[e].options.dataGrouping)if(c=Math.max(c,d(q.groupPixelWidth,a.common.groupPixelWidth)),g=(b[e].processedXData||b[e].data).length,b[e].groupPixelWidth||g>this.chart.plotSizeX/c||g&&q.forced)l=!0;return l?c:0}function h(){this.series.forEach(function(a){a.hasProcessed=!1})}function c(a,b){var c;b=d(b,!0);a||(a={forced:!1,units:null});if(this instanceof e)for(c=this.series.length;c--;)this.series[c].update({dataGrouping:a},!1);else this.chart.options.series.forEach(function(b){b.dataGrouping=
"boolean"===typeof a?a:l(a,b.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0);b&&this.chart.redraw()}var g=b.addEvent,G=b.extend,l=b.merge,d=b.pick,v=[],e;return{compose:function(a){e=a;b.pushUnique(v,a)&&(g(a,"afterSetScale",h),g(a,"postProcessData",m),G(a.prototype,{applyGrouping:m,getGroupPixelWidth:k,setDataGrouping:c}))}}});h(a,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],
a["Core/Axis/DateTimeAxis.js"],a["Core/Defaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,b,h,k,K,c){function g(a){var d=this.chart,c=this.options.dataGrouping,e=!1!==this.allowDG&&c&&u(c.enabled,d.options.isStock),f=this.visible||!d.options.chart.ignoreHiddenSeries,y=this.currentDataGrouping,l=!1;e&&!this.requireSorting&&(this.requireSorting=l=!0);a=!1===!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!a)||!e;l&&(this.requireSorting=!1);
if(!a){this.destroyGroupedData();var g=c.groupAll?this.xData:this.processedXData,m=c.groupAll?this.yData:this.processedYData;e=d.plotSizeX;a=this.xAxis;var k=a.options.ordinal,F=this.groupPixelWidth;l=void 0;if(F&&g&&g.length&&e){this.isDirty=l=!0;this.points=null;var n=a.getExtremes();var p=n.min;n=n.max;k=k&&a.ordinal&&a.ordinal.getGroupIntervalFactor(p,n,this)||1;e=a.getTimeTicks(h.Additions.prototype.normalizeTimeTickInterval(F*(n-p)/e*k,c.units||b.units),Math.min(p,g[0]),Math.max(n,g[g.length-
1]),a.options.startOfWeek,g,this.closestPointRange);F=t.groupData.apply(this,[g,m,e,c.approximation]);g=F.groupedXData;m=F.groupedYData;k=0;c&&c.smoothed&&g.length&&(c.firstAnchor="firstPoint",c.anchor="middle",c.lastAnchor="lastPoint",D(32,!1,d,{"dataGrouping.smoothed":"use dataGrouping.anchor"}));d=g;var C=this.options.dataGrouping;p=this.currentDataGrouping&&this.currentDataGrouping.gapSize;if(C&&this.xData&&p&&this.groupMap){var x=d.length-1;var w=C.anchor;var E=u(C.firstAnchor,w);C=u(C.lastAnchor,
w);if(w&&"start"!==w){var I=p*{middle:.5,end:1}[w];for(w=d.length-1;w--&&0<w;)d[w]+=I}if(E&&"start"!==E&&this.xData[0]>=d[0]){w=this.groupMap[0].start;I=this.groupMap[0].length;var z=void 0;q(w)&&q(I)&&(z=w+(I-1));d[0]={middle:d[0]+.5*p,end:d[0]+p,firstPoint:this.xData[0],lastPoint:z&&this.xData[z]}[E]}C&&"start"!==C&&p&&d[x]>=n-p&&(n=this.groupMap[this.groupMap.length-1].start,d[x]={middle:d[x]+.5*p,end:d[x]+p,firstPoint:n&&this.xData[n],lastPoint:this.xData[this.xData.length-1]}[C])}for(n=1;n<e.length;n++)e.info.segmentStarts&&
-1!==e.info.segmentStarts.indexOf(n)||(k=Math.max(e[n]-e[n-1],k));n=e.info;n.gapSize=k;this.closestPointRange=e.info.totalRange;this.groupMap=F.groupMap;if(f){f=g;if(H(f[0])&&q(a.min)&&q(a.dataMin)&&f[0]<a.min){if(!H(a.options.min)&&a.min<=a.dataMin||a.min===a.dataMin)a.min=Math.min(f[0],a.min);a.dataMin=Math.min(f[0],a.dataMin)}if(H(f[f.length-1])&&q(a.max)&&q(a.dataMax)&&f[f.length-1]>a.max){if(!H(a.options.max)&&q(a.dataMax)&&a.max>=a.dataMax||a.max===a.dataMax)a.max=Math.max(f[f.length-1],a.max);
a.dataMax=Math.max(f[f.length-1],a.dataMax)}}c.groupAll&&(this.allGroupedData=m,c=this.cropData(g,m,a.min,a.max,1),g=c.xData,m=c.yData,this.cropStart=c.start);this.processedXData=g;this.processedYData=m}else this.groupMap=null;this.hasGroupedData=l;this.currentDataGrouping=n;this.preventGraphAnimation=(y&&y.totalRange)!==(n&&n.totalRange)}}function m(){this.groupedData&&(this.groupedData.forEach(function(a,b){a&&(this.groupedData[b]=a.destroy?a.destroy():null)},this),this.groupedData.length=0)}function l(){L.apply(this);
this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null}function d(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")?"sum":"average"}function v(b,d,c,e){var f=this,g=f.data,l=f.options&&f.options.data,m=[],k=[],t=[],h=b.length,n=!!d,p=[],y=f.pointArrayMap,x=y&&y.length,w=["x"].concat(y||["y"]),E=this.options.dataGrouping&&this.options.dataGrouping.groupAll,u=0,D=0;e="function"===typeof e?e:e&&a[e]?a[e]:a[f.getDGApproximation&&
f.getDGApproximation()||"average"];if(x)for(var J=y.length;J--;)p.push([]);else p.push([]);J=x||1;for(var B=0;B<=h;B++)if(!(b[B]<c[0])){for(;"undefined"!==typeof c[u+1]&&b[B]>=c[u+1]||B===h;){var r=c[u];f.dataGroupInfo={start:E?D:f.cropStart+D,length:p[0].length};var A=e.apply(f,p);f.pointClass&&!H(f.dataGroupInfo.options)&&(f.dataGroupInfo.options=z(f.pointClass.prototype.optionsToObject.call({series:f},f.options.data[f.cropStart+D])),w.forEach(function(a){delete f.dataGroupInfo.options[a]}));"undefined"!==
typeof A&&(m.push(r),k.push(A),t.push(f.dataGroupInfo));D=B;for(r=0;r<J;r++)p[r].length=0,p[r].hasNulls=!1;u+=1;if(B===h)break}if(B===h)break;if(y){r=f.options.dataGrouping&&f.options.dataGrouping.groupAll?B:f.cropStart+B;A=g&&g[r]||f.pointClass.prototype.applyOptions.apply({series:f},[l[r]]);var v=void 0;for(r=0;r<x;r++)v=A[y[r]],q(v)?p[r].push(v):null===v&&(p[r].hasNulls=!0)}else r=n?d[B]:null,q(r)?p[0].push(r):null===r&&(p[0].hasNulls=!0)}return{groupedXData:m,groupedYData:k,groupMap:t}}function e(a){a=
a.options;var d=this.type,c=this.chart.options.plotOptions,e=this.useCommonDataGrouping&&b.common,f=b.seriesSpecific,g=k.defaultOptions.plotOptions[d].dataGrouping;if(c&&(f[d]||e)){var l=this.chart.rangeSelector;g||(g=z(b.common,f[d]));a.dataGrouping=z(e,g,c.series&&c.series.dataGrouping,c[d].dataGrouping,this.userOptions.dataGrouping,!a.isInternal&&l&&q(l.selected)&&l.buttonOptions[l.selected].dataGrouping)}}var t=K.series.prototype,x=c.addEvent,H=c.defined,D=c.error,E=c.extend,q=c.isNumber,z=c.merge,
u=c.pick,L=t.generatePoints,A=[];return{compose:function(a){var b=a.prototype.pointClass;c.pushUnique(A,b)&&x(b,"update",function(){if(this.dataGroup)return D(24,!1,this.series.chart),!1});c.pushUnique(A,a)&&(x(a,"afterSetOptions",e),x(a,"destroy",m),E(a.prototype,{applyGrouping:g,destroyGroupedData:m,generatePoints:l,getDGApproximation:d,groupData:v}))},groupData:v}});h(a,"Extensions/DataGrouping/DataGrouping.js",[a["Extensions/DataGrouping/DataGroupingAxisComposition.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],
a["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],a["Core/FormatUtilities.js"],a["Core/Utilities.js"]],function(a,b,m,k,h){function c(a){var c=this.chart,e=c.time,h=a.labelConfig,m=h.series,k=m.tooltipOptions,q=m.options.dataGrouping,z=m.xAxis,u=k.xDateFormat,v=k[a.isFooter?"footerFormat":"headerFormat"];if(z&&"datetime"===z.options.type&&q&&d(h.key)){var A=m.currentDataGrouping;q=q.dateTimeLabelFormats||b.common.dateTimeLabelFormats;if(A)if(k=q[A.unitName],1===A.count)u=k[0];else{u=k[1];
var y=k[2]}else!u&&q&&z.dateTime&&(u=z.dateTime.getXDateFormat(h.x,k.dateTimeLabelFormats));u=e.dateFormat(u,h.key);y&&(u+=e.dateFormat(y,h.key+A.totalRange-1));m.chart.styledMode&&(v=this.styledModeFormat(v));a.text=g(v,{point:l(h.point,{key:u}),series:m},c);a.preventDefault()}}var g=k.format,G=h.addEvent,l=h.extend,d=h.isNumber,v=[];k={compose:function(b,d,g){a.compose(b);m.compose(d);g&&h.pushUnique(v,g)&&G(g,"headerFormatter",c)},groupData:m.groupData};"";"";return k});h(a,"masters/modules/datagrouping.src.js",
[a["Core/Globals.js"],a["Extensions/DataGrouping/ApproximationDefaults.js"],a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGrouping.js"]],function(a,b,h,k){a.dataGrouping={approximationDefaults:b,approximations:h};k.compose(a.Axis,a.Series,a.Tooltip)})});
//# sourceMappingURL=datagrouping.js.map