/*
 Highcharts JS v11.0.0 (2023-04-26)

 ColorAxis module

 (c) 2012-2021 Pawel Potaczek

 License: www.highcharts.com/license
*/
'use strict';(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/modules/color-axis",["highcharts"],function(m){c(m);c.Highcharts=m;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function m(c,h,t,p){c.hasOwnProperty(h)||(c[h]=p.apply(null,t),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:h,module:c[h]}})))}c=c?c._modules:
{};m(c,"Core/Axis/Color/ColorAxisComposition.js",[c["Core/Color/Color.js"],c["Core/Utilities.js"]],function(c,h){var l=c.parse,p=h.addEvent,m=h.extend,y=h.merge,u=h.pick,B=h.splat,r;(function(c){function r(){var b=this,a=this.options;this.colorAxis=[];a.colorAxis&&(a.colorAxis=B(a.colorAxis),a.colorAxis.forEach(function(a,d){a.index=d;new k(b,a)}))}function t(a){var b=this,d=function(d){d=a.allItems.indexOf(d);-1!==d&&(b.destroyItem(a.allItems[d]),a.allItems.splice(d,1))},f=[],g,e;(this.chart.colorAxis||
[]).forEach(function(a){(g=a.options)&&g.showInLegend&&(g.dataClasses&&g.visible?f=f.concat(a.getDataClassLegendSymbols()):g.visible&&f.push(a),a.series.forEach(function(a){if(!a.options.showInLegend||g.dataClasses)"point"===a.options.legendType?a.points.forEach(function(a){d(a)}):d(a)}))});for(e=f.length;e--;)a.allItems.unshift(f[e])}function w(a){a.visible&&a.item.legendColor&&a.item.legendItem.symbol.attr({fill:a.item.legendColor})}function n(){var a=this.chart.colorAxis;a&&a.forEach(function(a,
b,d){a.update({},d)})}function E(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function e(){var a=this.axisTypes;a?-1===a.indexOf("colorAxis")&&a.push("colorAxis"):this.axisTypes=["colorAxis"]}function b(a){var b=this,d=a?"show":"hide";b.visible=b.options.visible=!!a;["graphic","dataLabel"].forEach(function(a){if(b[a])b[a][d]()});this.series.buildKDTree()}function a(){var a=this,b=this.options.nullColor,d=this.colorAxis,f=this.colorKey;(this.data.length?
this.data:this.points).forEach(function(g){var e=g.getNestedProperty(f);(e=g.options.color||(g.isNull||null===g.value?b:d&&"undefined"!==typeof e?d.toColor(e,g):g.color||a.color))&&g.color!==e&&(g.color=e,"point"===a.options.legendType&&g.legendItem&&g.legendItem.label&&a.chart.legend.colorizeItem(g,g.visible))})}function f(a){var b=a.prototype.createAxis;a.prototype.createAxis=function(a,d){if("colorAxis"!==a)return b.apply(this,arguments);var f=new k(this,y(d.axis,{index:this[a].length,isX:!1}));
this.isDirtyLegend=!0;this.axes.forEach(function(a){a.series=[]});this.series.forEach(function(a){a.bindAxes();a.isDirtyData=!0});u(d.redraw,!0)&&this.redraw(d.animation);return f}}function d(){this.elem.attr("fill",l(this.start).tweenTo(l(this.end),this.pos),void 0,!0)}function q(){this.elem.attr("stroke",l(this.start).tweenTo(l(this.end),this.pos),void 0,!0)}var x=[],k;c.compose=function(g,c,z,l,v){k||(k=g);h.pushUnique(x,c)&&(g=c.prototype,g.collectionsWithUpdate.push("colorAxis"),g.collectionsWithInit.colorAxis=
[g.addColorAxis],p(c,"afterGetAxes",r),f(c));h.pushUnique(x,z)&&(c=z.prototype,c.fillSetter=d,c.strokeSetter=q);h.pushUnique(x,l)&&(p(l,"afterGetAllItems",t),p(l,"afterColorizeItem",w),p(l,"afterUpdate",n));h.pushUnique(x,v)&&(m(v.prototype,{optionalAxis:"colorAxis",translateColors:a}),m(v.prototype.pointClass.prototype,{setVisible:b}),p(v,"afterTranslate",E,{order:1}),p(v,"bindAxes",e))};c.pointSetVisible=b})(r||(r={}));return r});m(c,"Core/Axis/Color/ColorAxisDefaults.js",[],function(){return{lineWidth:0,
minPadding:0,maxPadding:0,gridLineColor:"#ffffff",gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{distance:8,overflow:"justify",rotation:0},minColor:"#e6e9ff",maxColor:"#0022ff",tickLength:5,showInLegend:!0}});m(c,"Core/Axis/Color/ColorAxis.js",[c["Core/Axis/Axis.js"],c["Core/Color/Color.js"],c["Core/Axis/Color/ColorAxisComposition.js"],c["Core/Axis/Color/ColorAxisDefaults.js"],c["Core/Legend/LegendSymbol.js"],
c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,h,m,p,A,y,u){var l=this&&this.__extends||function(){var c=function(e,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)Object.prototype.hasOwnProperty.call(b,d)&&(a[d]=b[d])};return c(e,b)};return function(e,b){function a(){this.constructor=e}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");
c(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),r=h.parse,t=y.series,C=u.extend,D=u.isNumber,w=u.merge,n=u.pick;h=function(c){function e(b,a){var f=c.call(this,b,a)||this;f.beforePadding=!1;f.chart=void 0;f.coll="colorAxis";f.dataClasses=void 0;f.options=void 0;f.stops=void 0;f.visible=!0;f.init(b,a);return f}l(e,c);e.compose=function(b,a,f,d){m.compose(e,b,a,f,d)};e.prototype.init=function(b,a){var f=b.options.legend||{},d=a.layout?"vertical"!==a.layout:"vertical"!==
f.layout,q=a.visible;f=w(e.defaultColorAxisOptions,a,{showEmpty:!1,title:null,visible:f.enabled&&!1!==q});this.coll="colorAxis";this.side=a.side||d?2:1;this.reversed=a.reversed||!d;this.opposite=!d;c.prototype.init.call(this,b,f);this.userOptions.visible=q;a.dataClasses&&this.initDataClasses(a);this.initStops();this.horiz=d;this.zoomEnabled=!1};e.prototype.initDataClasses=function(b){var a=this.chart,f=this.legendItem=this.legendItem||{},d=b.dataClasses.length,c=this.options,e,k=0,g=a.options.chart.colorCount;
this.dataClasses=e=[];f.labels=[];(b.dataClasses||[]).forEach(function(b,f){b=w(b);e.push(b);if(a.styledMode||!b.color)"category"===c.dataClassColor?(a.styledMode||(f=a.options.colors,g=f.length,b.color=f[k]),b.colorIndex=k,k++,k===g&&(k=0)):b.color=r(c.minColor).tweenTo(r(c.maxColor),2>d?.5:f/(d-1))})};e.prototype.hasData=function(){return!!(this.tickPositions||[]).length};e.prototype.setTickPositions=function(){if(!this.dataClasses)return c.prototype.setTickPositions.call(this)};e.prototype.initStops=
function(){this.stops=this.options.stops||[[0,this.options.minColor],[1,this.options.maxColor]];this.stops.forEach(function(b){b.color=r(b[1])})};e.prototype.setOptions=function(b){c.prototype.setOptions.call(this,b);this.options.crosshair=this.options.marker};e.prototype.setAxisSize=function(){var b=this.legendItem&&this.legendItem.symbol,a=this.chart,f=a.options.legend||{},d,c;b?(this.left=f=b.attr("x"),this.top=d=b.attr("y"),this.width=c=b.attr("width"),this.height=b=b.attr("height"),this.right=
a.chartWidth-f-c,this.bottom=a.chartHeight-d-b,this.len=this.horiz?c:b,this.pos=this.horiz?f:d):this.len=(this.horiz?f.symbolWidth:f.symbolHeight)||e.defaultLegendLength};e.prototype.normalizedValue=function(b){this.logarithmic&&(b=this.logarithmic.log2lin(b));return 1-(this.max-b)/(this.max-this.min||1)};e.prototype.toColor=function(b,a){var f=this.dataClasses,d=this.stops,c;if(f)for(c=f.length;c--;){var e=f[c];var k=e.from;d=e.to;if(("undefined"===typeof k||b>=k)&&("undefined"===typeof d||b<=d)){var g=
e.color;a&&(a.dataClass=c,a.colorIndex=e.colorIndex);break}}else{b=this.normalizedValue(b);for(c=d.length;c--&&!(b>d[c][0]););k=d[c]||d[c+1];d=d[c+1]||k;b=1-(d[0]-b)/(d[0]-k[0]||1);g=k.color.tweenTo(d.color,b)}return g};e.prototype.getOffset=function(){var b=this.legendItem&&this.legendItem.group,a=this.chart.axisOffset[this.side];if(b){this.axisParent=b;c.prototype.getOffset.call(this);var f=this.chart.legend;f.allItems.forEach(function(a){a instanceof e&&a.drawLegendSymbol(f,a)});f.render();this.chart.getMargins(!0);
this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width);this.chart.axisOffset[this.side]=a}};e.prototype.setLegendColor=function(){var b=this.reversed,a=b?1:0;b=b?0:1;a=this.horiz?[a,0,b,0]:[0,b,0,a];this.legendColor={linearGradient:{x1:a[0],y1:a[1],x2:a[2],y2:a[3]},stops:this.stops}};e.prototype.drawLegendSymbol=function(b,a){var c;a=a.legendItem||{};var d=b.padding,q=b.options,h=this.options.labels,k=n(q.itemDistance,10),g=this.horiz,l=n(q.symbolWidth,g?e.defaultLegendLength:12),
m=n(q.symbolHeight,g?12:e.defaultLegendLength),p=n(q.labelPadding,g?16:30);this.setLegendColor();a.symbol||(a.symbol=this.chart.renderer.symbol("roundedRect",0,b.baseline-11,l,m,{r:null!==(c=q.symbolRadius)&&void 0!==c?c:3}).attr({zIndex:1}).add(a.group));a.labelWidth=l+d+(g?k:n(h.x,h.distance)+this.maxLabelLength);a.labelHeight=m+d+(g?p:0)};e.prototype.setState=function(b){this.series.forEach(function(a){a.setState(b)})};e.prototype.setVisible=function(){};e.prototype.getSeriesExtremes=function(){var b=
this.series,a=b.length,c;this.dataMin=Infinity;for(this.dataMax=-Infinity;a--;){var d=b[a];var e=d.colorKey=n(d.options.colorKey,d.colorKey,d.pointValKey,d.zoneAxis,"y");var h=d.pointArrayMap;var k=d[e+"Min"]&&d[e+"Max"];if(d[e+"Data"])var g=d[e+"Data"];else if(h){g=[];h=h.indexOf(e);var l=d.yData;if(0<=h&&l)for(c=0;c<l.length;c++)g.push(n(l[c][h],l[c]))}else g=d.yData;k?(d.minColorValue=d[e+"Min"],d.maxColorValue=d[e+"Max"]):(g=t.prototype.getExtremes.call(d,g),d.minColorValue=g.dataMin,d.maxColorValue=
g.dataMax);"undefined"!==typeof d.minColorValue&&(this.dataMin=Math.min(this.dataMin,d.minColorValue),this.dataMax=Math.max(this.dataMax,d.maxColorValue));k||t.prototype.applyExtremes.call(d)}};e.prototype.drawCrosshair=function(b,a){var f=this.legendItem||{},d=a&&a.plotX,e=a&&a.plotY,h=this.pos,k=this.len;if(a){var g=this.toPixels(a.getNestedProperty(a.series.colorKey));g<h?g=h-2:g>h+k&&(g=h+k+2);a.plotX=g;a.plotY=this.len-g;c.prototype.drawCrosshair.call(this,b,a);a.plotX=d;a.plotY=e;this.cross&&
!this.cross.addedToColorAxis&&f.group&&(this.cross.addClass("highcharts-coloraxis-marker").add(f.group),this.cross.addedToColorAxis=!0,this.chart.styledMode||"object"!==typeof this.crosshair||this.cross.attr({fill:this.crosshair.color}))}};e.prototype.getPlotLinePath=function(b){var a=this.left,f=b.translatedValue,d=this.top;return D(f)?this.horiz?[["M",f-4,d-6],["L",f+4,d-6],["L",f,d],["Z"]]:[["M",a,f],["L",a-6,f+6],["L",a-6,f-6],["Z"]]:c.prototype.getPlotLinePath.call(this,b)};e.prototype.update=
function(b,a){var f=this.chart.legend;this.series.forEach(function(a){a.isDirtyData=!0});(b.dataClasses&&f.allItems||this.dataClasses)&&this.destroyItems();c.prototype.update.call(this,b,a);this.legendItem&&this.legendItem.label&&(this.setLegendColor(),f.colorizeItem(this,!0))};e.prototype.destroyItems=function(){var b=this.chart,a=this.legendItem||{};if(a.label)b.legend.destroyItem(this);else if(a.labels){var c=0;for(a=a.labels;c<a.length;c++)b.legend.destroyItem(a[c])}b.isDirtyLegend=!0};e.prototype.destroy=
function(){this.chart.isDirtyLegend=!0;this.destroyItems();c.prototype.destroy.apply(this,[].slice.call(arguments))};e.prototype.remove=function(b){this.destroyItems();c.prototype.remove.call(this,b)};e.prototype.getDataClassLegendSymbols=function(){var b=this,a=b.chart,c=b.legendItem&&b.legendItem.labels||[],d=a.options.legend,e=n(d.valueDecimals,-1),h=n(d.valueSuffix,""),k=function(a){return b.series.reduce(function(b,c){b.push.apply(b,c.points.filter(function(b){return b.dataClass===a}));return b},
[])},g;c.length||b.dataClasses.forEach(function(d,f){var l=d.from,m=d.to,p=a.numberFormatter,n=!0;g="";"undefined"===typeof l?g="< ":"undefined"===typeof m&&(g="> ");"undefined"!==typeof l&&(g+=p(l,e)+h);"undefined"!==typeof l&&"undefined"!==typeof m&&(g+=" - ");"undefined"!==typeof m&&(g+=p(m,e)+h);c.push(C({chart:a,name:g,options:{},drawLegendSymbol:A.drawRectangle,visible:!0,isDataClass:!0,setState:function(a){for(var b=0,c=k(f);b<c.length;b++)c[b].setState(a)},setVisible:function(){this.visible=
n=b.visible=!n;for(var c=0,d=k(f);c<d.length;c++)d[c].setVisible(n);a.legend.colorizeItem(this,n)}},d))});return c};e.defaultColorAxisOptions=p;e.defaultLegendLength=200;e.keepProps=["legendItem"];return e}(c);Array.prototype.push.apply(c.keepProps,h.keepProps);"";return h});m(c,"masters/modules/coloraxis.src.js",[c["Core/Globals.js"],c["Core/Axis/Color/ColorAxis.js"]],function(c,h){c.ColorAxis=h;h.compose(c.Chart,c.Fx,c.Legend,c.Series)})});
//# sourceMappingURL=coloraxis.js.map