/*
 Highcharts JS v11.0.0 (2023-04-26)

 Boost module

 (c) 2010-2021 Highsoft AS
 Author: Torstein Honsi

 License: www.highcharts.com/license

*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/boost",["highcharts"],function(v){a(v);a.Highcharts=v;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function v(a,g,c,O){a.hasOwnProperty(g)||(a[g]=O.apply(null,c),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:g,module:a[g]}})))}a=a?a._modules:
{};v(a,"Extensions/Boost/Boostables.js",[],function(){return"area areaspline arearange column columnrange bar line scatter heatmap bubble treemap".split(" ")});v(a,"Extensions/Boost/BoostableMap.js",[a["Extensions/Boost/Boostables.js"]],function(a){var g={};a.forEach(function(a){g[a]=!0});return g});v(a,"Extensions/Boost/BoostChart.js",[a["Extensions/Boost/BoostableMap.js"],a["Core/Utilities.js"]],function(a,g){function c(b){var e=b.series,g=b.boost=b.boost||{},y=b.options.boost||{},c=B(y.seriesThreshold,
50);if(e.length>=c)return!0;if(1===e.length)return!1;y=y.allowForce;if("undefined"===typeof y)for(y=!0,c=0,b=b.xAxis;c<b.length;c++){var k=b[c];if(B(k.min,-Infinity)>B(k.dataMin,-Infinity)||B(k.max,Infinity)<B(k.dataMax,Infinity)){y=!1;break}}if("undefined"!==typeof g.forceChartBoost){if(y)return g.forceChartBoost;g.forceChartBoost=void 0}for(var t=c=b=0;t<e.length;t++){var D=e[t];k=D.options;0!==k.boostThreshold&&!1!==D.visible&&"heatmap"!==D.type&&(a[D.type]&&++b,l(D.processedXData,k.data,D.points)>=
(k.boostThreshold||Number.MAX_VALUE)&&++c)}g.forceChartBoost=y&&(b===e.length&&0<c||5<c);return g.forceChartBoost}function t(b){e(b,"predraw",function(){b.boost=b.boost||{};b.boost.forceChartBoost=void 0;b.boosted=!1;b.boost.clear&&b.boost.clear();b.boost.canvas&&b.boost.wgl&&c(b)&&b.boost.wgl.allocateBuffer(b);b.boost.markerGroup&&b.xAxis&&0<b.xAxis.length&&b.yAxis&&0<b.yAxis.length&&b.boost.markerGroup.translate(b.xAxis[0].pos,b.yAxis[0].pos)});e(b,"render",function(){b.boost&&b.boost.wgl&&c(b)&&
b.boost.wgl.render(b)});var a=-1,g=-1;e(b.pointer,"afterGetHoverData",function(){var e=b.hoverSeries;b.boost=b.boost||{};if(b.boost.markerGroup&&e){var l=b.inverted?e.yAxis:e.xAxis;e=b.inverted?e.xAxis:e.yAxis;if(l&&l.pos!==a||e&&e.pos!==g)b.boost.markerGroup.translate(l.pos,e.pos),a=l.pos,g=e.pos}})}function l(){for(var b=[],e=0;e<arguments.length;e++)b[e]=arguments[e];var a=-Number.MAX_VALUE;b.forEach(function(b){if("undefined"!==typeof b&&null!==b&&"undefined"!==typeof b.length&&0<b.length)return a=
b.length,!0});return a}var e=g.addEvent,B=g.pick,k=[];return{compose:function(b,e){e&&g.pushUnique(k,b)&&b.prototype.callbacks.push(t);return b},getBoostClipRect:function(b,e){var a={x:b.plotLeft,y:b.plotTop,width:b.plotWidth,height:b.plotHeight};e===b&&(e=b.inverted?b.xAxis:b.yAxis,1>=e.length?(a.y=Math.min(e[0].pos,a.y),a.height=e[0].pos-b.plotTop+e[0].len):a.height=b.plotHeight);return a},isChartSeriesBoosting:c}});v(a,"Extensions/Boost/WGLDrawMode.js",[],function(){return{area:"LINES",arearange:"LINES",
areaspline:"LINES",column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"}});v(a,"Extensions/Boost/WGLShader.js",[a["Core/Utilities.js"]],function(a){var g=a.clamp,c=a.error,t=a.pick;return function(){function a(a){this.errors=[];this.uLocations={};(this.gl=a)&&this.createShader()}a.prototype.bind=function(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)};a.prototype.createShader=function(){var a=
this,g=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}",
"vertex"),c=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),b=function(b){return a.gl.getUniformLocation(a.shaderProgram,
b)};if(!g||!c)return this.shaderProgram=!1,this.handleErrors(),!1;this.shaderProgram=this.gl.createProgram();this.gl.attachShader(this.shaderProgram,g);this.gl.attachShader(this.shaderProgram,c);this.gl.linkProgram(this.shaderProgram);if(!this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))return this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1;this.gl.useProgram(this.shaderProgram);this.gl.bindAttribLocation(this.shaderProgram,
0,"aVertexPosition");this.pUniform=b("uPMatrix");this.psUniform=b("pSize");this.fcUniform=b("fillColor");this.isBubbleUniform=b("isBubble");this.bubbleSizeAbsUniform=b("bubbleSizeAbs");this.bubbleSizeAreaUniform=b("bubbleSizeByArea");this.uSamplerUniform=b("uSampler");this.skipTranslationUniform=b("skipTranslation");this.isCircleUniform=b("isCircle");this.isInverted=b("isInverted");return!0};a.prototype.handleErrors=function(){this.errors.length&&c("[highcharts boost] shader error - "+this.errors.join("\n"))};
a.prototype.stringToProgram=function(a,g){var e=this.gl.createShader("vertex"===g?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);this.gl.shaderSource(e,a);this.gl.compileShader(e);return this.gl.getShaderParameter(e,this.gl.COMPILE_STATUS)?e:(this.errors.push("when compiling "+g+" shader:\n"+this.gl.getShaderInfoLog(e)),!1)};a.prototype.destroy=function(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)};a.prototype.fillColorUniform=function(){return this.fcUniform};
a.prototype.getProgram=function(){return this.shaderProgram};a.prototype.pointSizeUniform=function(){return this.psUniform};a.prototype.perspectiveUniform=function(){return this.pUniform};a.prototype.reset=function(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))};a.prototype.setBubbleUniforms=function(a,c,k,b){void 0===b&&(b=1);var e=a.options,l=Number.MAX_VALUE,y=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&a.is("bubble")){var B=
a.getPxExtremes();l=t(e.zMin,g(c,!1===e.displayNegative?e.zThreshold:-Number.MAX_VALUE,l));y=t(e.zMax,Math.max(y,k));this.gl.uniform1i(this.isBubbleUniform,1);this.gl.uniform1i(this.isCircleUniform,1);this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==a.options.sizeBy);this.gl.uniform1i(this.bubbleSizeAbsUniform,a.options.sizeByAbsoluteValue);this.setUniform("bubbleMinSize",B.minPxSize*b);this.setUniform("bubbleMaxSize",B.maxPxSize*b);this.setUniform("bubbleZMin",l);this.setUniform("bubbleZMax",
y);this.setUniform("bubbleZThreshold",a.options.zThreshold)}};a.prototype.setColor=function(a){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,a[0]/255,a[1]/255,a[2]/255,a[3])};a.prototype.setDrawAsCircle=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,a?1:0)};a.prototype.setInverted=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,a)};a.prototype.setPMatrix=function(a){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,
!1,a)};a.prototype.setPointSize=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,a)};a.prototype.setSkipTranslation=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,!0===a?1:0)};a.prototype.setTexture=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,a)};a.prototype.setUniform=function(a,g){this.gl&&this.shaderProgram&&(a=this.uLocations[a]=this.uLocations[a]||this.gl.getUniformLocation(this.shaderProgram,
a),this.gl.uniform1f(a,g))};return a}()});v(a,"Extensions/Boost/WGLVertexBuffer.js",[],function(){return function(){function a(a,c,t){this.buffer=!1;this.iterator=0;this.vertAttribute=this.preAllocated=!1;this.components=t||2;this.dataComponents=t;this.gl=a;this.shader=c}a.prototype.allocate=function(a){this.iterator=-1;this.preAllocated=new Float32Array(4*a)};a.prototype.bind=function(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)};
a.prototype.build=function(a,c,t){var g;this.data=a||[];if(!(this.data&&0!==this.data.length||this.preAllocated))return this.destroy(),!1;this.components=t||this.components;this.buffer&&this.gl.deleteBuffer(this.buffer);this.preAllocated||(g=new Float32Array(this.data));this.buffer=this.gl.createBuffer();this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer);this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||g,this.gl.STATIC_DRAW);this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),
c);this.gl.enableVertexAttribArray(this.vertAttribute);return!0};a.prototype.destroy=function(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.vertAttribute=this.buffer=!1);this.iterator=0;this.components=this.dataComponents||2;this.data=[]};a.prototype.push=function(a,c,t,l){this.preAllocated&&(this.preAllocated[++this.iterator]=a,this.preAllocated[++this.iterator]=c,this.preAllocated[++this.iterator]=t,this.preAllocated[++this.iterator]=l)};a.prototype.render=function(a,c,t){var g=this.preAllocated?
this.preAllocated.length:this.data.length;if(!this.buffer||!g)return!1;if(!a||a>g||0>a)a=0;if(!c||c>g)c=g;if(a>=c)return!1;this.gl.drawArrays(this.gl[t||"POINTS"],a/this.components,(c-a)/this.components);return!0};return a}()});v(a,"Extensions/Boost/WGLRenderer.js",[a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Extensions/Boost/WGLDrawMode.js"],a["Extensions/Boost/WGLShader.js"],a["Extensions/Boost/WGLVertexBuffer.js"]],function(a,g,c,v,l,e){var t=a.parse,k=g.doc,b=g.win,
O=c.isNumber,pa=c.isObject,y=c.merge,L=c.objectEach,M=c.pick,w={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},D={scatter:!0,bubble:!0},K=["webgl","experimental-webgl","moz-webgl","webkit-3d"];return function(){function c(a){this.data=[];this.height=0;this.isInited=!1;this.markerData=[];this.series=[];this.textureHandles={};this.width=0;this.postRenderCallback=a;this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,
timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}c.orthoMatrix=function(a,b){return[2/a,0,0,0,0,-(2/b),0,0,0,0,-2,0,-1,1,-1,1]};c.seriesPointCount=function(a){if(a.boosted){var p=!!a.options.stacking;var b=a.xData||a.options.xData||a.processedXData;p=(p?a.data:b||a.options.data).length;"treemap"===a.type?p*=12:"heatmap"===a.type?p*=6:w[a.type]&&(p*=2);return p}return 0};c.prototype.getPixelRatio=function(){return this.settings.pixelRatio||b.devicePixelRatio||
1};c.prototype.setOptions=function(a){"pixelRatio"in a||(a.pixelRatio=1);y(!0,this.settings,a)};c.prototype.allocateBuffer=function(a){var p=this.vbuffer,b=0;this.settings.usePreallocated&&(a.series.forEach(function(a){a.boosted&&(b+=c.seriesPointCount(a))}),p&&p.allocate(b))};c.prototype.allocateBufferForSingleSeries=function(a){var p=this.vbuffer,b=0;this.settings.usePreallocated&&(a.boosted&&(b=c.seriesPointCount(a)),p&&p.allocate(b))};c.prototype.clear=function(){var a=this.gl;a&&a.clear(a.COLOR_BUFFER_BIT|
a.DEPTH_BUFFER_BIT)};c.prototype.pushSeriesData=function(a,b){var p=this,c=this.data,e=this.settings,f=this.vbuffer,m=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),r=a.chart,q=a.options,P=!!q.stacking,g=q.data,d=a.xAxis.getExtremes(),T=d.min,V=d.max;d=a.yAxis.getExtremes();var k=d.min,l=d.max,D=a.xData||q.xData||a.processedXData,y=a.yData||q.yData||a.processedYData,F=a.zData||q.zData||a.processedZData,v=a.yAxis,M=a.xAxis,K=!D||0===D.length,B=q.connectNulls;d=a.points||!1;var E=P?a.data:
D||g,h={x:Number.MAX_VALUE,y:0},n={x:-Number.MAX_VALUE,y:0},xa="undefined"===typeof r.index,Ha=w[a.type],za=q.zoneAxis||"y",ca=q.zones||!1,X=q.threshold,da=this.getPixelRatio(),sa=a.chart.plotWidth,ha=!1,aa=!1,ba,U,O=0,L=!1,C,x,H,ia,z=-1,S=!1,Y=!1,N,ta=!1,na=!1,A=!1,ua=!1,va=!0,oa=!0,I=!1,J=!1,ea=0;if(!(q.boostData&&0<q.boostData.length)){q.gapSize&&(J="value"!==q.gapUnit?q.gapSize*a.closestPointRange:q.gapSize);if(ca){var fa=[];ca.forEach(function(a,b){if(a.color){var h=t(a.color).rgba;h[0]/=255;
h[1]/=255;h[2]/=255;fa[b]=h;I||"undefined"!==typeof a.value||(I=h)}});I||(D=a.pointAttribs&&a.pointAttribs().fill||a.color,I=t(D).rgba,I[0]/=255,I[1]/=255,I[2]/=255)}r.inverted&&(sa=a.chart.plotHeight);a.closestPointRangePx=Number.MAX_VALUE;var ja=function(a){a&&(b.colorData.push(a[0]),b.colorData.push(a[1]),b.colorData.push(a[2]),b.colorData.push(a[3]))},Z=function(a,h,n,m,p){void 0===m&&(m=1);ja(p);1===da||e.useGPUTranslations&&!b.skipTranslation||(a*=da,h*=da,m*=da);e.usePreallocated&&f?(f.push(a,
h,n?1:0,m),ea+=4):(c.push(a),c.push(h),c.push(n?da:0),c.push(m))},Da=function(){b.segments.length&&(b.segments[b.segments.length-1].to=c.length||ea)},ya=function(){b.segments.length&&b.segments[b.segments.length-1].from===(c.length||ea)||(Da(),b.segments.push({from:c.length||ea}))},Ea=function(a,h,b,f,m){ja(m);Z(a+b,h);ja(m);Z(a,h);ja(m);Z(a,h+f);ja(m);Z(a,h+f);ja(m);Z(a+b,h+f);ja(m);Z(a+b,h)};ya();if(d&&0<d.length)b.skipTranslation=!0,b.drawMode="TRIANGLES",d[0].node&&d[0].node.levelDynamic&&d.sort(function(a,
h){if(a.node){if(a.node.levelDynamic>h.node.levelDynamic)return 1;if(a.node.levelDynamic<h.node.levelDynamic)return-1}return 0}),d.forEach(function(h){var b=h.plotY;if("undefined"!==typeof b&&!isNaN(b)&&null!==h.y&&h.shapeArgs){var f=h.shapeArgs;b=f.x;b=void 0===b?0:b;var m=f.y;m=void 0===m?0:m;var n=f.width;n=void 0===n?0:n;f=f.height;f=void 0===f?0:f;var p=r.styledMode?h.series.colorAttribs(h):p=h.series.pointAttribs(h);h=p["stroke-width"]||0;A=t(p.fill).rgba;A[0]/=255;A[1]/=255;A[2]/=255;a.is("treemap")&&
(h=h||1,U=t(p.stroke).rgba,U[0]/=255,U[1]/=255,U[2]/=255,Ea(b,m,n,f,U),h/=2);a.is("heatmap")&&r.inverted&&(b=M.len-b,m=v.len-m,n=-n,f=-f);Ea(b+h,m+h,n-2*h,f-2*h,A)}});else{for(d=function(){H=E[++z];if("undefined"===typeof H)return"continue";if(xa)return"break";var f=g&&g[z];!K&&pa(f,!0)&&f.color&&(A=t(f.color).rgba,A[0]/=255,A[1]/=255,A[2]/=255);K?(C=H[0],x=H[1],E[z+1]&&(Y=E[z+1][0]),E[z-1]&&(S=E[z-1][0]),3<=H.length&&(ia=H[2],H[2]>b.zMax&&(b.zMax=H[2]),H[2]<b.zMin&&(b.zMin=H[2]))):(C=H,x=y[z],E[z+
1]&&(Y=E[z+1]),E[z-1]&&(S=E[z-1]),F&&F.length&&(ia=F[z],F[z]>b.zMax&&(b.zMax=F[z]),F[z]<b.zMin&&(b.zMin=F[z])));if(!B&&(null===C||null===x))return ya(),"continue";Y&&Y>=T&&Y<=V&&(ta=!0);S&&S>=T&&S<=V&&(na=!0);m?(K&&(x=H.slice(1,3)),N=x[0],x=x[1]):P&&(C=H.x,x=H.stackY,N=x-H.y);null!==k&&"undefined"!==typeof k&&null!==l&&"undefined"!==typeof l&&(va=x>=k&&x<=l);C>V&&n.x<V&&(n.x=C,n.y=x);C<T&&h.x>T&&(h.x=C,h.y=x);if(null===x&&B)return"continue";if(null===x||!va&&!ta&&!na)return ya(),"continue";(Y>=T||
C>=T)&&(S<=V||C<=V)&&(ua=!0);if(!ua&&!ta&&!na)return"continue";J&&C-S>J&&ya();if(ca){var p;ca.some(function(a,h){var b=ca[h-1];return"x"===za?"undefined"!==typeof a.value&&C<=a.value?(fa[h]&&(!b||C>=b.value)&&(p=fa[h]),!0):!1:"undefined"!==typeof a.value&&x<=a.value?(fa[h]&&(!b||x>=b.value)&&(p=fa[h]),!0):!1});A=p||I||A}if(!e.useGPUTranslations&&(b.skipTranslation=!0,C=M.toPixels(C,!0),x=v.toPixels(x,!0),C>sa&&"POINTS"===b.drawMode))return"continue";b.hasMarkers&&ua&&!1!==ha&&(a.closestPointRangePx=
Math.min(a.closestPointRangePx,Math.abs(C-ha)));if(!e.useGPUTranslations&&!e.usePreallocated&&ha&&1>Math.abs(C-ha)&&aa&&1>Math.abs(x-aa))return e.debug.showSkipSummary&&++O,"continue";if(Ha){ba=N;if(!1===N||"undefined"===typeof N)ba=0>x?x:0;m||P||(ba=Math.max(null===X?k:X,k));e.useGPUTranslations||(ba=v.toPixels(ba,!0));Z(C,ba,0,0,A)}q.step&&!oa&&Z(C,aa,0,2,A);Z(C,x,0,"bubble"===a.type?ia||1:2,A);ha=C;aa=x;L=!0;oa=!1};z<E.length-1&&"break"!==d(););e.debug.showSkipSummary&&console.log("skipped points:",
O);d=function(a,h){e.useGPUTranslations||(b.skipTranslation=!0,a.x=M.toPixels(a.x,!0),a.y=v.toPixels(a.y,!0));h?p.data=[a.x,a.y,0,2].concat(p.data):Z(a.x,a.y,0,2)};L||!1===B||"line_strip"!==a.drawMode||(h.x<Number.MAX_VALUE&&d(h,!0),n.x>-Number.MAX_VALUE&&d(n))}Da()}};c.prototype.pushSeries=function(a){var b=this.markerData,p=this.series,c=this.settings;0<p.length&&p[p.length-1].hasMarkers&&(p[p.length-1].markerTo=b.length);c.debug.timeSeriesProcessing&&console.time("building "+a.type+" series");
b={segments:[],markerFrom:b.length,colorData:[],series:a,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:a.options.marker?!1!==a.options.marker.enabled:!1,showMarkers:!0,drawMode:v[a.type]||"LINE_STRIP"};a.index>=p.length?p.push(b):p[a.index]=b;this.pushSeriesData(a,b);c.debug.timeSeriesProcessing&&console.timeEnd("building "+a.type+" series")};c.prototype.flush=function(){var a=this.vbuffer;this.data=[];this.markerData=[];this.series=[];a&&a.destroy()};c.prototype.setXAxis=function(a){var b=
this.shader;if(b){var c=this.getPixelRatio();b.setUniform("xAxisTrans",a.transA*c);b.setUniform("xAxisMin",a.min);b.setUniform("xAxisMinPad",a.minPixelPadding*c);b.setUniform("xAxisPointRange",a.pointRange);b.setUniform("xAxisLen",a.len*c);b.setUniform("xAxisPos",a.pos*c);b.setUniform("xAxisCVSCoord",!a.horiz);b.setUniform("xAxisIsLog",!!a.logarithmic);b.setUniform("xAxisReversed",!!a.reversed)}};c.prototype.setYAxis=function(a){var b=this.shader;if(b){var c=this.getPixelRatio();b.setUniform("yAxisTrans",
a.transA*c);b.setUniform("yAxisMin",a.min);b.setUniform("yAxisMinPad",a.minPixelPadding*c);b.setUniform("yAxisPointRange",a.pointRange);b.setUniform("yAxisLen",a.len*c);b.setUniform("yAxisPos",a.pos*c);b.setUniform("yAxisCVSCoord",!a.horiz);b.setUniform("yAxisIsLog",!!a.logarithmic);b.setUniform("yAxisReversed",!!a.reversed)}};c.prototype.setThreshold=function(a,b){var c=this.shader;c&&(c.setUniform("hasThreshold",a),c.setUniform("translatedThreshold",b))};c.prototype.renderChart=function(b){var p=
this,u=this.gl,k=this.settings,l=this.shader,f=this.vbuffer,m=this.getPixelRatio();if(b)this.width=b.chartWidth*m,this.height=b.chartHeight*m;else return!1;var r=this.height,q=this.width;if(!(u&&l&&q&&r))return!1;k.debug.timeRendering&&console.time("gl rendering");u.canvas.width=q;u.canvas.height=r;l.bind();u.viewport(0,0,q,r);l.setPMatrix(c.orthoMatrix(q,r));1<k.lineWidth&&!g.isMS&&u.lineWidth(k.lineWidth);f&&(f.build(this.data,"aVertexPosition",4),f.bind());l.setInverted(b.inverted);this.series.forEach(function(c,
q){var d=c.series.options,g=d.marker,r="undefined"!==typeof d.lineWidth?d.lineWidth:1,P=d.threshold,y=O(P),w=c.series.yAxis.getThreshold(P);P=M(d.marker?d.marker.enabled:null,c.series.xAxis.isRadial?!0:null,c.series.closestPointRangePx>2*((d.marker?d.marker.radius:10)||10));g=p.textureHandles[g&&g.symbol||c.series.symbol]||p.textureHandles.circle;if(0!==c.segments.length&&c.segments[0].from!==c.segments[0].to&&(g.isReady&&(u.bindTexture(u.TEXTURE_2D,g.handle),l.setTexture(g.handle)),b.styledMode?
g=c.series.markerGroup&&c.series.markerGroup.getStyle("fill"):(g="POINTS"===c.drawMode&&c.series.pointAttribs&&c.series.pointAttribs().fill||c.series.color,d.colorByPoint&&(g=c.series.chart.options.colors[q])),c.series.fillOpacity&&d.fillOpacity&&(g=(new a(g)).setOpacity(M(d.fillOpacity,1)).get()),g=t(g).rgba,k.useAlpha||(g[3]=1),"LINES"===c.drawMode&&k.useAlpha&&1>g[3]&&(g[3]/=10),"add"===d.boostBlending?(u.blendFunc(u.SRC_ALPHA,u.ONE),u.blendEquation(u.FUNC_ADD)):"mult"===d.boostBlending||"multiply"===
d.boostBlending?u.blendFunc(u.DST_COLOR,u.ZERO):"darken"===d.boostBlending?(u.blendFunc(u.ONE,u.ONE),u.blendEquation(u.FUNC_MIN)):u.blendFuncSeparate(u.SRC_ALPHA,u.ONE_MINUS_SRC_ALPHA,u.ONE,u.ONE_MINUS_SRC_ALPHA),l.reset(),0<c.colorData.length?(l.setUniform("hasColor",1),q=new e(u,l),q.build(c.colorData,"aColor",4),q.bind()):u.disableVertexAttribArray(u.getAttribLocation(l.getProgram(),"aColor")),l.setColor(g),p.setXAxis(c.series.xAxis),p.setYAxis(c.series.yAxis),p.setThreshold(y,w),"POINTS"===c.drawMode&&
l.setPointSize(2*M(d.marker&&d.marker.radius,.5)*m),l.setSkipTranslation(c.skipTranslation),"bubble"===c.series.type&&l.setBubbleUniforms(c.series,c.zMin,c.zMax,m),l.setDrawAsCircle(D[c.series.type]||!1),f)){if(0<r||"LINE_STRIP"!==c.drawMode)for(r=0;r<c.segments.length;r++)f.render(c.segments[r].from,c.segments[r].to,c.drawMode);if(c.hasMarkers&&P)for(l.setPointSize(2*M(d.marker&&d.marker.radius,5)*m),l.setDrawAsCircle(!0),r=0;r<c.segments.length;r++)f.render(c.segments[r].from,c.segments[r].to,"POINTS")}});
k.debug.timeRendering&&console.timeEnd("gl rendering");this.postRenderCallback&&this.postRenderCallback(this);this.flush()};c.prototype.render=function(a){var b=this;this.clear();if(a.renderer.forExport)return this.renderChart(a);this.isInited?this.renderChart(a):setTimeout(function(){b.render(a)},1)};c.prototype.setSize=function(a,b){var e=this.shader;!e||this.width===a&&this.height===b||(this.width=a,this.height=b,e.bind(),e.setPMatrix(c.orthoMatrix(a,b)))};c.prototype.init=function(a,b){var c=
this,g=this.settings;this.isInited=!1;if(!a)return!1;g.debug.timeSetup&&console.time("gl setup");for(var p=0;p<K.length&&!(this.gl=a.getContext(K[p],{}));++p);var f=this.gl;if(f)b||this.flush();else return!1;f.enable(f.BLEND);f.blendFunc(f.SRC_ALPHA,f.ONE_MINUS_SRC_ALPHA);f.disable(f.DEPTH_TEST);f.depthFunc(f.LESS);a=this.shader=new l(f);if(!a)return!1;this.vbuffer=new e(f,a);a=function(a,b){var m={isReady:!1,texture:k.createElement("canvas"),handle:f.createTexture()},e=m.texture.getContext("2d");
c.textureHandles[a]=m;m.texture.width=512;m.texture.height=512;e.mozImageSmoothingEnabled=!1;e.webkitImageSmoothingEnabled=!1;e.msImageSmoothingEnabled=!1;e.imageSmoothingEnabled=!1;e.strokeStyle="rgba(255, 255, 255, 0)";e.fillStyle="#FFF";b(e);try{f.activeTexture(f.TEXTURE0),f.bindTexture(f.TEXTURE_2D,m.handle),f.texImage2D(f.TEXTURE_2D,0,f.RGBA,f.RGBA,f.UNSIGNED_BYTE,m.texture),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_WRAP_S,f.CLAMP_TO_EDGE),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_WRAP_T,f.CLAMP_TO_EDGE),
f.texParameteri(f.TEXTURE_2D,f.TEXTURE_MAG_FILTER,f.LINEAR),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_MIN_FILTER,f.LINEAR),f.bindTexture(f.TEXTURE_2D,null),m.isReady=!0}catch(la){}};a("circle",function(a){a.beginPath();a.arc(256,256,256,0,2*Math.PI);a.stroke();a.fill()});a("square",function(a){a.fillRect(0,0,512,512)});a("diamond",function(a){a.beginPath();a.moveTo(256,0);a.lineTo(512,256);a.lineTo(256,512);a.lineTo(0,256);a.lineTo(256,0);a.fill()});a("triangle",function(a){a.beginPath();a.moveTo(0,
512);a.lineTo(256,0);a.lineTo(512,512);a.lineTo(0,512);a.fill()});a("triangle-down",function(a){a.beginPath();a.moveTo(0,0);a.lineTo(256,512);a.lineTo(512,0);a.lineTo(0,0);a.fill()});this.isInited=!0;g.debug.timeSetup&&console.timeEnd("gl setup");return!0};c.prototype.destroy=function(){var a=this.gl,b=this.shader,c=this.vbuffer;this.flush();c&&c.destroy();b&&b.destroy();a&&(L(this.textureHandles,function(b){b.handle&&a.deleteTexture(b.handle)}),a.canvas.width=1,a.canvas.height=1)};return c}()});
v(a,"Extensions/Boost/BoostSeries.js",[a["Extensions/Boost/BoostableMap.js"],a["Extensions/Boost/Boostables.js"],a["Extensions/Boost/BoostChart.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Extensions/Boost/WGLRenderer.js"]],function(a,g,c,v,l,e,B){function k(a,b){var h=b.boost;a&&h&&h.target&&h.canvas&&!q(b.chart)&&a.allocateBufferForSingleSeries(b)}function b(a){return Aa(a&&a.options&&a.options.boost&&a.options.boost.enabled,!0)}function t(a,b){var h=a.constructor,f=
a.seriesGroup||b.group,c=a.chartWidth,e=a.chartHeight,n=a,m="undefined"!==typeof SVGForeignObjectElement;n=q(a)?a:b;var d=n.boost=n.boost||{};m=!1;E||(E=la.createElement("canvas"));d.target||(d.canvas=E,a.renderer.forExport||!m?(n.renderTarget=d.target=a.renderer.image("",0,0,c,e).addClass("highcharts-boost-canvas").add(f),d.clear=function(){d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},d.copy=function(){d.resize();
d.target.attr({href:d.canvas.toDataURL("image/png")})}):(d.targetFo=a.renderer.createElement("foreignObject").add(f),n.renderTarget=d.target=la.createElement("canvas"),d.targetCtx=d.target.getContext("2d"),d.targetFo.element.appendChild(d.target),d.clear=function(){d.target.width=d.canvas.width;d.target.height=d.canvas.height},d.copy=function(){d.target.width=d.canvas.width;d.target.height=d.canvas.height;d.targetCtx.drawImage(d.canvas,0,0)}),d.resize=function(){c=a.chartWidth;e=a.chartHeight;(d.targetFo||
d.target).attr({x:0,y:0,width:c,height:e}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1});n instanceof h&&n.boost.markerGroup.translate(a.plotLeft,a.plotTop)},d.clipRect=a.renderer.clipRect(),(d.targetFo||d.target).clip(d.clipRect),n instanceof h&&(n.boost.markerGroup=n.renderer.g().add(f).translate(b.xAxis.pos,b.yAxis.pos)));d.canvas.width=c;d.canvas.height=e;d.clipRect&&d.clipRect.attr(r(a,n));d.resize();d.clear();d.wgl||(d.wgl=new B(function(a){a.settings.debug.timeBufferCopy&&console.time("buffer copy");
d.copy();a.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),d.wgl.init(d.canvas)||Q("[highcharts boost] - unable to init WebGL renderer"),d.wgl.setOptions(a.options.boost||{}),n instanceof h&&d.wgl.allocateBuffer(a));d.wgl.setSize(c,e);return d.wgl}function O(a){var b=a.points;if(b){var h=void 0,c=void 0;for(c=0;c<b.length;c+=1)(h=b[c])&&h.destroyElements&&h.destroyElements()}["graph","area","tracker"].forEach(function(b){var h=a[b];h&&(a[b]=h.destroy())});a.getZonesGraphs&&a.getZonesGraphs([["graph",
"highcharts-graph"]]).forEach(function(b){var h=a[b[0]];h&&(a[b[0]]=h.destroy())})}function y(a,b,c,f,d,e){d=d||0;f=f||3E3;for(var h=d+f,n=!0;n&&d<h&&d<a.length;)n=b(a[d],d),++d;n&&(d<a.length?e?y(a,b,c,f,d,e):T.requestAnimationFrame?T.requestAnimationFrame(function(){y(a,b,c,f,d)}):setTimeout(y,0,a,b,c,f,d):c&&c())}function L(a){a.boost=a.boost||{getPoint:function(b){return p(a,b)}};var b=a.boost.altered=[];["allowDG","directTouch","stickyTracking"].forEach(function(c){b.push({prop:c,val:a[c],own:Object.hasOwnProperty.call(a,
c)})});a.allowDG=!1;a.directTouch=!1;a.stickyTracking=!0;a.finishedAnimating=!0;a.labelBySeries&&(a.labelBySeries=a.labelBySeries.destroy())}function M(a){var b=a.boost;b&&((b.altered||[]).forEach(function(b){b.own?a[b.prop]=b.val:delete a[b.prop]}),b.clear&&b.clear())}function w(a,b){var c=a.options,f=a.xAxis&&a.xAxis.options,d=a.yAxis&&a.yAxis.options;a=a.colorAxis&&a.colorAxis.options;return c.data.length>(c.boostThreshold||Number.MAX_VALUE)&&F(d.min)&&F(d.max)&&(!b||F(f.min)&&F(f.max))&&(!a||
F(a.min)&&F(a.max))}function D(){var a=this,b=a.chart;b.boost&&b.boost.markerGroup===a.markerGroup&&(a.markerGroup=null);b.hoverPoints&&(b.hoverPoints=b.hoverPoints.filter(function(b){return b.series===a}));b.hoverPoint&&b.hoverPoint.series===a&&(b.hoverPoint=null)}function K(){var a=this.boost;a&&a.canvas&&a.target&&(a.wgl&&a.wgl.clear(),a.clear&&a.clear())}function aa(a){var b=a.boost;b&&b.canvas&&b.target&&b.wgl&&!q(a.chart)&&b.wgl.render(a.chart)}function p(a,b){var c=a.options,f=a.xAxis,d=a.pointClass;
if(b instanceof d)return b;c=a.xData||c.xData||a.processedXData||!1;d=(new d).init(a,a.options.data[b.i],c?c[b.i]:void 0);d.category=Aa(f.categories?f.categories[d.x]:d.x,d.x);d.dist=b.dist;d.distX=b.distX;d.plotX=b.plotX;d.plotY=b.plotY;d.index=b.i;d.percentage=b.percentage;d.isInside=a.isPointInside(d);return d}function V(){function a(a,b){var c="undefined"===typeof f.index,d=!1,h=!0;if("undefined"===typeof a)return!0;if(!c){if(B){var g=a[0];var n=a[1]}else g=a,n=r[b];if(v)B&&(n=a.slice(1,3)),d=
n[0],n=n[1];else if(M){g=a.x;n=a.stackY;d=n-a.y;var q=a.percentage}K||(h=(n||0)>=u&&n<=D);if(g>=P&&g<=T&&h)if(a=e.toPixels(g,!0),C){if("undefined"===typeof Q||a===E){v||(d=n);if("undefined"===typeof I||n>ma)ma=n,I=b;if("undefined"===typeof Q||d<G)G=d,Q=b}F&&a===E||("undefined"!==typeof Q&&(n=m.toPixels(ma,!0),A=m.toPixels(G,!0),ea(a,n,I,q),A!==n&&ea(a,A,Q,q)),Q=I=void 0,E=a)}else n=Math.ceil(m.toPixels(n,!0)),ea(a,n,b,q)}return!c}var b=this,c=this.options||{},f=this.chart,e=this.xAxis,m=this.yAxis,
g=c.xData||this.processedXData,r=c.yData||this.processedYData,p=c.data,l=e.getExtremes(),P=l.min,T=l.max;l=m.getExtremes();var u=l.min,D=l.max,w={},C=!!this.sampling,x=!1!==c.enableMouseTracking;l=c.threshold;var v=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),M=!!c.stacking,z=this.cropStart||0,K=this.requireSorting,B=!g,F="x"===c.findNearestPointBy,la=this.xData||this.options.xData||this.processedXData||!1;c=!1;var E,A=m.getThreshold(l),G,ma,Q,I;c=t(f,this);f.boosted=!0;if(this.visible){(this.points||
this.graph)&&O(this);q(f)?(this.markerGroup&&this.markerGroup!==f.boost.markerGroup&&this.markerGroup.destroy(),this.markerGroup=f.boost.markerGroup,this.boost&&this.boost.target&&(this.renderTarget=this.boost.target=this.boost.target.destroy())):(f.boost&&this.markerGroup===f.boost.markerGroup&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers",!0,1,f.seriesGroup));var J=this.points=[],ea=function(a,b,c,h){a=Math.ceil(a);ra=F?a:a+","+b;x&&!w[ra]&&(w[ra]=!0,f.inverted&&
(a=e.len-a,b=m.len-b),J.push({destroy:d,x:la?la[z+c]:!1,clientX:a,plotX:a,plotY:b,i:z+c,percentage:h}))};this.buildKDTree=d;c&&(k(c,this),c.pushSeries(this),aa(this));var fa=c.settings;c=function(){Ga(b,"renderedCanvas");delete b.buildKDTree;b.buildKDTree();fa.debug.timeKDTree&&console.timeEnd("kd tree building")};f.renderer.forExport||(fa.debug.timeKDTree&&console.time("kd tree building"),y(M?this.data:g||p,a,c))}}function u(a){var b=!0;this.chart.options&&this.chart.options.boost&&(b="undefined"===
typeof this.chart.options.boost.enabled?!0:this.chart.options.boost.enabled);if(!b||!this.boosted)return a.call(this);this.chart.boosted=!0;if(a=t(this.chart,this))k(a,this),a.pushSeries(this);aa(this)}function ka(c,f,d){function e(c){var f=this.options.stacking&&("translate"===d||"generatePoints"===d);this.boosted&&!f&&b(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&a[this.type]&&0!==this.options.boostThreshold?"render"===d&&this.renderCanvas&&this.renderCanvas():c.call(this)}W(c,d,
e);"translate"===d&&["column","arearange","columnrange","heatmap","treemap"].forEach(function(a){f[a]&&W(f[a].prototype,d,e)})}function wa(a){return this.boosted&&w(this)?{}:a.apply(this,[].slice.call(arguments,1))}function f(c){var f=this,d=this.options.data,e=function(a){return f.forceCrop?!1:q(f.chart)||(a?a.length:0)>=(f.options.boostThreshold||Number.MAX_VALUE)};b(this.chart)&&a[this.type]?(e(d)&&"heatmap"!==this.type&&"treemap"!==this.type&&!this.options.stacking&&w(this,!0)||(c.apply(this,
[].slice.call(arguments,1)),d=this.processedXData),(this.boosted=e(d))?(d=void 0,this.options.data&&this.options.data.length&&(d=this.getFirstValidPoint(this.options.data),F(d)||qa(d)||Q(12,!1,this.chart)),L(this)):M(this)):c.apply(this,[].slice.call(arguments,1))}function m(a){var b=a.apply(this,[].slice.call(arguments,1));return this.boost&&b?this.boost.getPoint(b):b}var r=c.getBoostClipRect,q=c.isChartSeriesBoosting,P=v.getOptions,la=l.doc,d=l.noop,T=l.win,ma=e.addEvent,Q=e.error,G=e.extend,Ga=
e.fireEvent,qa=e.isArray,F=e.isNumber,Aa=e.pick,W=e.wrap,R=[],ra,E;return{compose:function(a,b,c){if(e.pushUnique(R,a)){ma(a,"destroy",D);ma(a,"hide",K);var d=a.prototype;c&&(d.renderCanvas=V);W(d,"getExtremes",wa);W(d,"processData",f);W(d,"searchPoint",m);["translate","generatePoints","drawTracker","drawPoints","render"].forEach(function(a){return ka(d,b,a)})}if(e.pushUnique(R,P)){var h=P().plotOptions;g.forEach(function(a){var c=h[a];c&&(c.boostThreshold=5E3,c.boostData=[],b[a].prototype.fillOpacity=
!0)})}if(c){var r=b.area,q=b.areaspline,n=b.bubble;c=b.column;var l=b.heatmap,p=b.scatter,k=b.treemap;r&&e.pushUnique(R,r)&&G(r.prototype,{fill:!0,fillOpacity:!0,sampling:!0});q&&e.pushUnique(R,q)&&G(q.prototype,{fill:!0,fillOpacity:!0,sampling:!0});n&&e.pushUnique(R,n)&&(r=n.prototype,delete r.buildKDTree,W(r,"markerAttribs",function(a){return this.boosted?!1:a.apply(this,[].slice.call(arguments,1))}));c&&e.pushUnique(R,c)&&G(c.prototype,{fill:!0,sampling:!0});p&&e.pushUnique(R,p)&&(p.prototype.fill=
!0);[l,k].forEach(function(a){a&&e.pushUnique(R,a)&&W(a.prototype,"drawPoints",u)})}return a},destroyGraphics:O,getPoint:p}});v(a,"Extensions/BoostCanvas.js",[a["Extensions/Boost/BoostChart.js"],a["Extensions/Boost/BoostSeries.js"],a["Core/Chart/Chart.js"],a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,g,c,v,l,e,B,k){var b=a.getBoostClipRect,t=a.isChartSeriesBoosting,O=g.destroyGraphics,y=v.parse,L=l.doc,
M=l.noop,w=B.seriesTypes,D=k.addEvent,K=k.extend,aa=k.fireEvent,p=k.isNumber,V=k.merge,u=k.pick,ka=k.wrap,wa;return function(){l.seriesTypes.heatmap&&ka(l.seriesTypes.heatmap.prototype,"drawPoints",function(){var a=this.chart,b=this.getContext(),c=this.chart.inverted,e=this.xAxis,g=this.yAxis;b?(this.points.forEach(function(f){var d=f.plotY;if("undefined"!==typeof d&&!isNaN(d)&&null!==f.y&&b){var m=f.shapeArgs||{};d=m.x;d=void 0===d?0:d;var r=m.y;r=void 0===r?0:r;var q=m.width;q=void 0===q?0:q;m=
m.height;m=void 0===m?0:m;f=a.styledMode?f.series.colorAttribs(f):f.series.pointAttribs(f);b.fillStyle=f.fill;c?b.fillRect(g.len-r+e.left,e.len-d+g.top,-m,-q):b.fillRect(d+e.left,r+g.top,q,m)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")});K(e.prototype,{getContext:function(){var a=this.chart,c=t(a)?a:this,e=c===a?a.seriesGroup:a.seriesGroup||this.group,g=a.chartWidth,l=a.chartHeight,p=function(a,b,c,d,f,e,m){a.call(this,
c,b,d,f,e,m)},d=c.boost=c.boost||{};var k=d.targetCtx;d.canvas||(d.canvas=L.createElement("canvas"),d.target=a.renderer.image("",0,0,g,l).addClass("highcharts-boost-canvas").add(e),k=d.targetCtx=d.canvas.getContext("2d"),a.inverted&&["moveTo","lineTo","rect","arc"].forEach(function(a){ka(k,a,p)}),d.copy=function(){d.target.attr({href:d.canvas.toDataURL("image/png")})},d.clear=function(){k.clearRect(0,0,d.canvas.width,d.canvas.height);c===d.target&&d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},
d.clipRect=a.renderer.clipRect(),d.target.clip(d.clipRect));d.canvas.width!==g&&(d.canvas.width=g);d.canvas.height!==l&&(d.canvas.height=l);d.target.attr({x:0,y:0,width:g,height:l,style:"pointer-events: none",href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});d.clipRect&&d.clipRect.attr(b(a,c));return k},canvasToSVG:function(){t(this.chart)?this.boost&&this.boost.clear&&this.boost.clear():this.boost&&this.boost.copy?this.boost.copy():
this.chart.boost&&this.chart.boost.copy&&this.chart.boost.copy()},cvsLineTo:function(a,b,c){a.lineTo(b,c)},renderCanvas:function(){var a=this,b=a.options,c=a.chart,e=this.xAxis,g=this.yAxis,t=(c.options.boost||{}).timeRendering||!1,d=0,w=a.processedXData,B=a.processedYData,Q=b.data,G=e.getExtremes(),L=G.min,qa=G.max;G=g.getExtremes();var F=G.min,ka=G.max,W={},R,ra=!!a.sampling,E=b.marker&&b.marker.radius,h=this.cvsDrawPoint,n=b.lineWidth?this.cvsLineTo:void 0,xa=E&&1>=E?this.cvsMarkerSquare:this.cvsMarkerCircle,
pa=this.cvsStrokeBatch||1E3,za=!1!==b.enableMouseTracking,ca;G=b.threshold;var X=g.getThreshold(G),da=p(G),sa=X,ha=this.fill,Ba=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),ba=!!b.stacking,U=a.cropStart||0;G=c.options.loading;var Fa=a.requireSorting,Ca,C=b.connectNulls,x=!w,H,ia,z,S,Y,N=ba?a.data:w||Q,ta=a.fillOpacity?v.parse(a.color).setOpacity(u(b.fillOpacity,.75)).get():a.color,na=function(){ha?(J.fillStyle=ta,J.fill()):(J.strokeStyle=a.color,J.lineWidth=b.lineWidth,J.stroke())},A=function(b,
f,e,g){0===d&&(J.beginPath(),n&&(J.lineJoin="round"));c.scroller&&"highcharts-navigator-series"===a.options.className?(f+=c.scroller.top,e&&(e+=c.scroller.top)):f+=c.plotTop;b+=c.plotLeft;Ca?J.moveTo(b,f):h?h(J,b,f,e,ca):n?n(J,b,f):xa&&xa.call(a,J,b,f,E,g);d+=1;d===pa&&(na(),d=0);ca={clientX:b,plotY:f,yBottom:e}},ua="x"===b.findNearestPointBy,va=this.xData||this.options.xData||this.processedXData||!1,oa=function(a,b,d){Y=ua?a:a+","+b;za&&!W[Y]&&(W[Y]=!0,c.inverted&&(a=e.len-a,b=g.len-b),I.push({x:va?
va[U+d]:!1,clientX:a,plotX:a,plotY:b,i:U+d}))};w=this.boost||{};w.target&&w.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});(this.points||this.graph)&&O(this);a.plotGroup("group","series",a.visible?"visible":"hidden",b.zIndex,c.seriesGroup);a.markerGroup=a.group;D(a,"destroy",function(){a.markerGroup=null});var I=this.points=[];var J=this.getContext();a.buildKDTree=M;w.clear&&w.clear();this.visible&&(99999<Q.length&&
(c.options.loading=V(G,{labelStyle:{backgroundColor:y("#ffffff").setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),k.clearTimeout(wa),c.showLoading("Drawing..."),c.options.loading=G),t&&console.time("canvas rendering"),l.eachAsync(N,function(b,d){var f=!1,m=!1,h=!1,l=!1,n="undefined"===typeof c.index,p=!0;if(!n){if(x){var q=b[0];var k=b[1];N[d+1]&&(h=N[d+1][0]);N[d-1]&&(l=N[d-1][0])}else q=b,k=B[d],N[d+1]&&(h=N[d+1]),N[d-1]&&(l=N[d-1]);h&&h>=L&&h<=
qa&&(f=!0);l&&l>=L&&l<=qa&&(m=!0);if(Ba){x&&(k=b.slice(1,3));var r=k[0];k=k[1]}else ba&&(q=b.x,k=b.stackY,r=k-b.y);b=null===k;Fa||(p=k>=F&&k<=ka);if(!b&&(q>=L&&q<=qa&&p||f||m))if(q=Math.round(e.toPixels(q,!0)),ra){if("undefined"===typeof z||q===R){Ba||(r=k);if("undefined"===typeof S||k>ia)ia=k,S=d;if("undefined"===typeof z||r<H)H=r,z=d}q!==R&&("undefined"!==typeof z&&(k=g.toPixels(ia,!0),X=g.toPixels(H,!0),A(q,da?Math.min(k,sa):k,da?Math.max(X,sa):X,d),oa(q,k,S),X!==k&&oa(q,X,z)),z=S=void 0,R=q)}else k=
Math.round(g.toPixels(k,!0)),A(q,k,X,d),oa(q,k,d);Ca=b&&!C;0===d%5E4&&(a.boost&&a.boost.copy?a.boost.copy():a.chart.boost&&a.chart.boost.copy&&a.chart.boost.copy())}return!n},function(){var b=c.loadingDiv,d=c.loadingShown;na();a.canvasToSVG();t&&console.timeEnd("canvas rendering");aa(a,"renderedCanvas");d&&(K(b.style,{transition:"opacity 250ms",opacity:0}),c.loadingShown=!1,wa=setTimeout(function(){b.parentNode&&b.parentNode.removeChild(b);c.loadingDiv=c.loadingSpan=null},250));delete a.buildKDTree;
a.buildKDTree()},c.renderer.forExport?Number.MAX_VALUE:void 0))}});w.scatter.prototype.cvsMarkerCircle=function(a,b,c,e){a.moveTo(b,c);a.arc(b,c,e,0,2*Math.PI,!1)};w.scatter.prototype.cvsMarkerSquare=function(a,b,c,e){a.rect(b-e,c-e,2*e,2*e)};w.scatter.prototype.fill=!0;w.bubble&&(w.bubble.prototype.cvsMarkerCircle=function(a,b,c,e,g){a.moveTo(b,c);a.arc(b,c,this.radii&&this.radii[g],0,2*Math.PI,!1)},w.bubble.prototype.cvsStrokeBatch=1);K(w.area.prototype,{cvsDrawPoint:function(a,b,c,e,g){g&&b!==
g.clientX&&(a.moveTo(g.clientX,g.yBottom),a.lineTo(g.clientX,g.plotY),a.lineTo(b,c),a.lineTo(b,e))},fill:!0,fillOpacity:!0,sampling:!0});K(w.column.prototype,{cvsDrawPoint:function(a,b,c,e){a.rect(b-1,c,1,e-c)},fill:!0,sampling:!0});c.prototype.callbacks.push(function(a){D(a,"predraw",function(){var a=this.boost||{};a.target&&a.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});a.canvas&&a.canvas.getContext("2d").clearRect(0,
0,a.canvas.width,a.canvas.height)});D(a,"render",function(){a.boost&&a.boost.copy&&a.boost.copy()})})}});v(a,"Extensions/Boost/NamedColors.js",[],function(){return{defaultHTMLColorMap:{aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",
cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",feldspar:"#d19275",
firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",grey:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",
lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslateblue:"#8470ff",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",
mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",
royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",violetred:"#d02090",wheat:"#f5deb3",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"}}});v(a,"Extensions/Boost/Boost.js",[a["Extensions/Boost/BoostChart.js"],
a["Extensions/Boost/BoostSeries.js"],a["Core/Globals.js"],a["Extensions/BoostCanvas.js"],a["Extensions/Boost/NamedColors.js"],a["Core/Utilities.js"]],function(a,g,c,v,l,e){function t(){var a=!1;if("undefined"!==typeof b.WebGLRenderingContext){var c=O.createElement("canvas");for(var e=0;e<L.length;++e)try{if(a=c.getContext(L[e]),"undefined"!==typeof a&&null!==a)return!0}catch(K){}}return!1}var k=this&&this.__assign||function(){k=Object.assign||function(a){for(var b,c=1,e=arguments.length;c<e;c++){b=
arguments[c];for(var g in b)Object.prototype.hasOwnProperty.call(b,g)&&(a[g]=b[g])}return a};return k.apply(this,arguments)},b=c.win,O=c.doc,pa=e.error,y=[],L=["webgl","experimental-webgl","moz-webgl","webkit-3d"];c={compose:function(b,c,D,B){var w=t();w||("undefined"!==typeof v?v():pa(26));B&&e.pushUnique(y,B)&&(B.names=k(k({},B.names),l.defaultHTMLColorMap));a.compose(b,w);g.compose(c,D,w)},hasWebGLSupport:t};"";return c});v(a,"masters/modules/boost.src.js",[a["Core/Globals.js"],a["Extensions/Boost/Boost.js"]],
function(a,g){a.hasWebGLSupport=g.hasWebGLSupport;g.compose(a.Chart,a.Series,a.seriesTypes,a.Color)})});
//# sourceMappingURL=boost.js.map