/*
 Highcharts JS v11.0.0 (2023-04-26)

 Accessibility module

 (c) 2010-2021 Highsoft AS
 Author: Oystein Moseng

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/accessibility",["highcharts"],function(A){a(A);a.Highcharts=A;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function A(a,q,m,p){a.hasOwnProperty(q)||(a[q]=p.apply(null,m),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:q,module:a[q]}})))}a=a?
a._modules:{};A(a,"Accessibility/Utils/HTMLUtilities.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,q){function m(a){if("function"===typeof l.MouseEvent)return new l.MouseEvent(a.type,a);if(k.createEvent){var h=k.createEvent("MouseEvent");if(h.initMouseEvent)return h.initMouseEvent(a.type,a.bubbles,a.cancelable,a.view||l,a.detail,a.screenX,a.screenY,a.clientX,a.clientY,a.ctrlKey,a.altKey,a.shiftKey,a.metaKey,a.button,a.relatedTarget),h}return p(a.type)}function p(a,g,w){g=g||{x:0,y:0};
return"function"===typeof l.MouseEvent?new l.MouseEvent(a,{bubbles:!0,cancelable:!0,composed:!0,button:0,buttons:1,relatedTarget:w||y,view:l,detail:"click"===a?1:0,screenX:g.x,screenY:g.y,clientX:g.x,clientY:g.y}):k.createEvent&&(w=k.createEvent("MouseEvent"),w.initMouseEvent)?(w.initMouseEvent(a,!0,!0,l,"click"===a?1:0,g.x,g.y,g.x,g.y,!1,!1,!1,!1,0,null),w):{type:a}}var k=a.doc,l=a.win,x=q.css,y=l.EventTarget&&new l.EventTarget||"none";return{addClass:function(a,g){a.classList?a.classList.add(g):
0>a.className.indexOf(g)&&(a.className+=" "+g)},cloneMouseEvent:m,cloneTouchEvent:function(a){var h=function(a){for(var f=[],e=0;e<a.length;++e){var b=a.item(e);b&&f.push(b)}return f};if("function"===typeof l.TouchEvent)return h=new l.TouchEvent(a.type,{touches:h(a.touches),targetTouches:h(a.targetTouches),changedTouches:h(a.changedTouches),ctrlKey:a.ctrlKey,shiftKey:a.shiftKey,altKey:a.altKey,metaKey:a.metaKey,bubbles:a.bubbles,cancelable:a.cancelable,composed:a.composed,detail:a.detail,view:a.view}),
a.defaultPrevented&&h.preventDefault(),h;h=m(a);h.touches=a.touches;h.changedTouches=a.changedTouches;h.targetTouches=a.targetTouches;return h},escapeStringForHTML:function(a){return a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")},getElement:function(a){return k.getElementById(a)},getFakeMouseEvent:p,getHeadingTagNameForElement:function(a){var h=function(f){f=parseInt(f.slice(1),10);return"h"+Math.min(6,f+1)},
w=function(f){var e;a:{for(e=f;e=e.previousSibling;){var b=e.tagName||"";if(/H[1-6]/.test(b)){e=b;break a}}e=""}if(e)return h(e);f=f.parentElement;if(!f)return"p";e=f.tagName;return/H[1-6]/.test(e)?h(e):w(f)};return w(a)},removeChildNodes:function(a){for(;a.lastChild;)a.removeChild(a.lastChild)},removeClass:function(a,g){a.classList?a.classList.remove(g):a.className=a.className.replace(new RegExp(g,"g"),"")},removeElement:function(a){a&&a.parentNode&&a.parentNode.removeChild(a)},reverseChildNodes:function(a){for(var h=
a.childNodes.length;h--;)a.appendChild(a.childNodes[h])},simulatedEventTarget:y,stripHTMLTagsFromString:function(a){return"string"===typeof a?a.replace(/<\/?[^>]+(>|$)/g,""):a},visuallyHideElement:function(a){x(a,{position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:.01})}}});A(a,"Accessibility/A11yI18n.js",[a["Core/FormatUtilities.js"],
a["Core/Utilities.js"]],function(a,q){var m=a.format,p=q.getNestedProperty,k=q.pick,l;(function(a){function y(a,e){var b=a.indexOf("#each("),c=a.indexOf("#plural("),d=a.indexOf("["),u=a.indexOf("]");if(-1<b){u=a.slice(b).indexOf(")")+b;c=a.substring(0,b);d=a.substring(u+1);u=a.substring(b+6,u).split(",");b=Number(u[1]);a="";if(e=p(u[0],e))for(b=isNaN(b)?e.length:b,b=0>b?e.length+b:Math.min(b,e.length),u=0;u<b;++u)a+=c+e[u]+d;return a.length?a:""}if(-1<c){d=a.slice(c).indexOf(")")+c;c=a.substring(c+
8,d).split(",");switch(Number(p(c[0],e))){case 0:a=k(c[4],c[1]);break;case 1:a=k(c[2],c[1]);break;case 2:a=k(c[3],c[1]);break;default:a=c[1]}a?(e=a,e=e.trim&&e.trim()||e.replace(/^\s+|\s+$/g,"")):e="";return e}return-1<d?(c=a.substring(0,d),d=Number(a.substring(d+1,u)),a=void 0,e=p(c,e),!isNaN(d)&&e&&(0>d?(a=e[e.length+d],"undefined"===typeof a&&(a=e[0])):(a=e[d],"undefined"===typeof a&&(a=e[e.length-1]))),"undefined"!==typeof a?a:""):"{"+a+"}"}function h(a,e,b){var c=function(b,c){b=b.slice(c||0);
var d=b.indexOf("{"),e=b.indexOf("}");if(-1<d&&e>d)return{statement:b.substring(d+1,e),begin:c+d+1,end:c+e}},d=[],u=0;do{var f=c(a,u);var h=a.substring(u,f&&f.begin-1);h.length&&d.push({value:h,type:"constant"});f&&d.push({value:f.statement,type:"statement"});u=f?f.end+1:u+1}while(f);d.forEach(function(b){"statement"===b.type&&(b.value=y(b.value,e))});return m(d.reduce(function(b,c){return b+c.value},""),e,b)}function g(a,e){a=a.split(".");for(var b=this.options.lang,c=0;c<a.length;++c)b=b&&b[a[c]];
return"string"===typeof b?h(b,e,this):""}var w=[];a.compose=function(a){q.pushUnique(w,a)&&(a.prototype.langFormat=g);return a};a.i18nFormat=h})(l||(l={}));return l});A(a,"Accessibility/Utils/ChartUtilities.js",[a["Core/Globals.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Core/Utilities.js"]],function(a,q,m){function p(c,d){var e=d.type,a=c.hcEvents;g.createEvent&&(c.dispatchEvent||c.fireEvent)?c.dispatchEvent?c.dispatchEvent(d):c.fireEvent(e,d):a&&a[e]?b(c,e,d):c.element&&p(c.element,d)}function k(b){var c=
b.chart,e={},a="Seconds";e.Seconds=((b.dataMax||b.max||0)-(b.dataMin||b.min||0))/1E3;e.Minutes=e.Seconds/60;e.Hours=e.Minutes/60;e.Days=e.Hours/24;["Minutes","Hours","Days"].forEach(function(b){2<e[b]&&(a=b)});var f=e[a].toFixed("Seconds"!==a&&"Minutes"!==a?1:0);return c.langFormat("accessibility.axis.timeRange"+a,{chart:c,axis:b,range:f.replace(".0","")})}function l(b){var c=b.chart,e=c.options,a=e&&e.accessibility&&e.accessibility.screenReaderSection.axisRangeDateFormat||"",f={min:b.dataMin||b.min||
0,max:b.dataMax||b.max||0};e=function(d){return b.dateTime?c.time.dateFormat(a,f[d]):f[d].toString()};return c.langFormat("accessibility.axis.rangeFromTo",{chart:c,axis:b,rangeFrom:e("min"),rangeTo:e("max")})}function x(b){if(b.points&&b.points.length)return(b=e(b.points,function(b){return!!b.graphic}))&&b.graphic&&b.graphic.element}function y(b){var c=x(b);return c&&c.parentNode||b.graph&&b.graph.element||b.group&&b.group.element}function h(b,d){d.setAttribute("aria-hidden",!1);d!==b.renderTo&&d.parentNode&&
d.parentNode!==g.body&&(Array.prototype.forEach.call(d.parentNode.childNodes,function(b){b.hasAttribute("aria-hidden")||b.setAttribute("aria-hidden",!0)}),h(b,d.parentNode))}var g=a.doc,w=q.stripHTMLTagsFromString,f=m.defined,e=m.find,b=m.fireEvent;return{fireEventOnWrappedOrUnwrappedElement:p,getChartTitle:function(b){return w(b.options.title.text||b.langFormat("accessibility.defaultChartTitle",{chart:b}))},getAxisDescription:function(b){return b&&(b.userOptions&&b.userOptions.accessibility&&b.userOptions.accessibility.description||
b.axisTitle&&b.axisTitle.textStr||b.options.id||b.categories&&"categories"||b.dateTime&&"Time"||"values")},getAxisRangeDescription:function(b){var d=b.options||{};return d.accessibility&&"undefined"!==typeof d.accessibility.rangeDescription?d.accessibility.rangeDescription:b.categories?(d=b.chart,b=b.dataMax&&b.dataMin?d.langFormat("accessibility.axis.rangeCategories",{chart:d,axis:b,numCategories:b.dataMax-b.dataMin+1}):"",b):!b.dateTime||0!==b.min&&0!==b.dataMin?l(b):k(b)},getPointFromXY:function(b,
d,a){for(var c=b.length,u;c--;)if(u=e(b[c].points||[],function(b){return b.x===d&&b.y===a}))return u},getSeriesFirstPointElement:x,getSeriesFromName:function(b,d){return d?(b.series||[]).filter(function(b){return b.name===d}):b.series},getSeriesA11yElement:y,unhideChartElementFromAT:h,hideSeriesFromAT:function(b){(b=y(b))&&b.setAttribute("aria-hidden",!0)},scrollToPoint:function(c){var d=c.series.xAxis,e=c.series.yAxis,a=d&&d.scrollbar?d:e;if((d=a&&a.scrollbar)&&f(d.to)&&f(d.from)){e=d.to-d.from;
if(f(a.dataMin)&&f(a.dataMax)){var h=a.toPixels(a.dataMin),g=a.toPixels(a.dataMax);c=(a.toPixels(c["xAxis"===a.coll?"x":"y"]||0)-h)/(g-h)}else c=0;d.updatePosition(c-e/2,c+e/2);b(d,"changed",{from:d.from,to:d.to,trigger:"scrollbar",DOMEvent:null})}}}});A(a,"Accessibility/Utils/DOMElementProvider.js",[a["Core/Globals.js"],a["Accessibility/Utils/HTMLUtilities.js"]],function(a,q){var m=a.doc,p=q.removeElement;return function(){function a(){this.elements=[]}a.prototype.createElement=function(){var a=
m.createElement.apply(m,arguments);this.elements.push(a);return a};a.prototype.destroyCreatedElements=function(){this.elements.forEach(function(a){p(a)});this.elements=[]};return a}()});A(a,"Accessibility/Utils/EventProvider.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,q){var m=q.addEvent;return function(){function p(){this.eventRemovers=[]}p.prototype.addEvent=function(){var k=m.apply(a,arguments);this.eventRemovers.push(k);return k};p.prototype.removeAddedEvents=function(){this.eventRemovers.forEach(function(a){return a()});
this.eventRemovers=[]};return p}()});A(a,"Accessibility/AccessibilityComponent.js",[a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/DOMElementProvider.js"],a["Accessibility/Utils/EventProvider.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Core/Utilities.js"]],function(a,q,m,p,k){var l=a.fireEventOnWrappedOrUnwrappedElement,x=p.getFakeMouseEvent;a=k.extend;p=function(){function a(){this.proxyProvider=this.keyCodes=this.eventProvider=this.domElementProvider=this.chart=void 0}a.prototype.initBase=
function(a,g){this.chart=a;this.eventProvider=new m;this.domElementProvider=new q;this.proxyProvider=g;this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9,pageUp:33,pageDown:34,end:35,home:36}};a.prototype.addEvent=function(a,g,w,f){return this.eventProvider.addEvent(a,g,w,f)};a.prototype.createElement=function(a,g){return this.domElementProvider.createElement(a,g)};a.prototype.fakeClickEvent=function(a){var h=x("click");l(a,h)};a.prototype.destroyBase=function(){this.domElementProvider.destroyCreatedElements();
this.eventProvider.removeAddedEvents()};return a}();a(p.prototype,{init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}});return p});A(a,"Accessibility/KeyboardNavigationHandler.js",[a["Core/Utilities.js"]],function(a){var q=a.find;a=function(){function a(a,k){this.chart=a;this.keyCodeMap=k.keyCodeMap||[];this.validate=k.validate;this.init=k.init;this.terminate=k.terminate;this.response={success:1,prev:2,next:3,noHandler:4,
fail:5}}a.prototype.run=function(a){var k=a.which||a.keyCode,m=this.response.noHandler,p=q(this.keyCodeMap,function(a){return-1<a[0].indexOf(k)});p?m=p[1].call(this,k,a):9===k&&(m=this.response[a.shiftKey?"prev":"next"]);return m};return a}();"";return a});A(a,"Accessibility/Components/ContainerComponent.js",[a["Accessibility/AccessibilityComponent.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Core/Globals.js"],a["Accessibility/Utils/HTMLUtilities.js"]],
function(a,q,m,p,k){var l=this&&this.__extends||function(){var a=function(f,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var d in a)Object.prototype.hasOwnProperty.call(a,d)&&(b[d]=a[d])};return a(f,e)};return function(f,e){function b(){this.constructor=f}if("function"!==typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");a(f,e);f.prototype=null===e?Object.create(e):(b.prototype=e.prototype,
new b)}}(),x=m.unhideChartElementFromAT,y=m.getChartTitle,h=p.doc,g=k.stripHTMLTagsFromString;return function(a){function f(){return null!==a&&a.apply(this,arguments)||this}l(f,a);f.prototype.onChartUpdate=function(){this.handleSVGTitleElement();this.setSVGContainerLabel();this.setGraphicContainerAttrs();this.setRenderToAttrs();this.makeCreditsAccessible()};f.prototype.handleSVGTitleElement=function(){var a=this.chart,b="highcharts-title-"+a.index,c=g(a.langFormat("accessibility.svgContainerTitle",
{chartTitle:y(a)}));if(c.length){var d=this.svgTitleElement=this.svgTitleElement||h.createElementNS("http://www.w3.org/2000/svg","title");d.textContent=c;d.id=b;a.renderTo.insertBefore(d,a.renderTo.firstChild)}};f.prototype.setSVGContainerLabel=function(){var a=this.chart,b=a.langFormat("accessibility.svgContainerLabel",{chartTitle:y(a)});a.renderer.box&&b.length&&a.renderer.box.setAttribute("aria-label",b)};f.prototype.setGraphicContainerAttrs=function(){var a=this.chart,b=a.langFormat("accessibility.graphicContainerLabel",
{chartTitle:y(a)});b.length&&a.container.setAttribute("aria-label",b)};f.prototype.setRenderToAttrs=function(){var a=this.chart,b="disabled"!==a.options.accessibility.landmarkVerbosity,c=a.langFormat("accessibility.chartContainerLabel",{title:y(a),chart:a});c&&(a.renderTo.setAttribute("role",b?"region":"group"),a.renderTo.setAttribute("aria-label",c))};f.prototype.makeCreditsAccessible=function(){var a=this.chart,b=a.credits;b&&(b.textStr&&b.element.setAttribute("aria-label",a.langFormat("accessibility.credits",
{creditsStr:g(b.textStr)})),x(a,b.element))};f.prototype.getKeyboardNavigation=function(){var a=this.chart;return new q(a,{keyCodeMap:[],validate:function(){return!0},init:function(){var b=a.accessibility;b&&b.keyboardNavigation.tabindexContainer.focus()}})};f.prototype.destroy=function(){this.chart.renderTo.setAttribute("aria-hidden",!0)};return f}(a)});A(a,"Accessibility/FocusBorder.js",[a["Core/Renderer/SVG/SVGLabel.js"],a["Core/Utilities.js"]],function(a,q){var m=q.addEvent,p=q.pick,k;(function(k){function l(){var b=
this.focusElement,a=this.options.accessibility.keyboardNavigation.focusBorder;b&&(b.removeFocusBorder(),a.enabled&&b.addFocusBorder(a.margin,{stroke:a.style.color,strokeWidth:a.style.lineWidth,r:a.style.borderRadius}))}function y(b,a){var d=this.options.accessibility.keyboardNavigation.focusBorder;(a=a||b.element)&&a.focus&&(a.hcEvents&&a.hcEvents.focusin||m(a,"focusin",function(){}),a.focus(),d.hideBrowserFocusOutline&&(a.style.outline="none"));this.focusElement&&this.focusElement.removeFocusBorder();
this.focusElement=b;this.renderFocusBorder()}function h(b){if(!b.focusBorderDestroyHook){var a=b.destroy;b.destroy=function(){b.focusBorder&&b.focusBorder.destroy&&b.focusBorder.destroy();return a.apply(b,arguments)};b.focusBorderDestroyHook=a}}function g(b,c){this.focusBorder&&this.removeFocusBorder();var d=this.getBBox(),e=p(b,3),u=this.parentGroup,f=this.scaleX||u&&u.scaleX,g=this.scaleY||u&&u.scaleY;f=(f?!g:g)?Math.abs(f||g||1):(Math.abs(f||1)+Math.abs(g||1))/2;d.x+=this.translateX?this.translateX:
0;d.y+=this.translateY?this.translateY:0;g=d.x-e;var F=d.y-e,t=d.width+2*e,n=d.height+2*e,r=this instanceof a;if("text"===this.element.nodeName||r){var C=!!this.rotation;if(r)var z={x:C?1:0,y:0};else{var E=z=0;"middle"===this.attr("text-anchor")?z=E=.5:this.rotation?z=.25:E=.75;z={x:z,y:E}}E=+this.attr("x");var v=+this.attr("y");isNaN(E)||(g=E-d.width*z.x-e);isNaN(v)||(F=v-d.height*z.y-e);r&&C&&(r=t,t=n,n=r,isNaN(E)||(g=E-d.height*z.x-e),isNaN(v)||(F=v-d.width*z.y-e))}this.focusBorder=this.renderer.rect(g,
F,t,n,parseInt((c&&c.r||0).toString(),10)/f).addClass("highcharts-focus-border").attr({zIndex:99}).add(u);this.renderer.styledMode||this.focusBorder.attr({stroke:c&&c.stroke,"stroke-width":(c&&c.strokeWidth||0)/f});w(this,b,c);h(this)}function w(b){for(var a=[],d=1;d<arguments.length;d++)a[d-1]=arguments[d];b.focusBorderUpdateHooks||(b.focusBorderUpdateHooks={},c.forEach(function(d){d+="Setter";var c=b[d]||b._defaultSetter;b.focusBorderUpdateHooks[d]=c;b[d]=function(){var d=c.apply(b,arguments);b.addFocusBorder.apply(b,
a);return d}}))}function f(){e(this);this.focusBorderDestroyHook&&(this.destroy=this.focusBorderDestroyHook,delete this.focusBorderDestroyHook);this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}function e(b){b.focusBorderUpdateHooks&&(Object.keys(b.focusBorderUpdateHooks).forEach(function(a){var d=b.focusBorderUpdateHooks[a];d===b._defaultSetter?delete b[a]:b[a]=d}),delete b.focusBorderUpdateHooks)}var b=[],c="x y transform width height r d stroke-width".split(" ");k.compose=
function(a,c){q.pushUnique(b,a)&&(a=a.prototype,a.renderFocusBorder=l,a.setFocusToElement=y);q.pushUnique(b,c)&&(c=c.prototype,c.addFocusBorder=g,c.removeFocusBorder=f)}})(k||(k={}));return k});A(a,"Accessibility/Utils/Announcer.js",[a["Core/Renderer/HTML/AST.js"],a["Accessibility/Utils/DOMElementProvider.js"],a["Core/Globals.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Core/Utilities.js"]],function(a,q,m,p,k){var l=m.doc,x=p.addClass,y=p.visuallyHideElement,h=k.attr;return function(){function g(a,
f){this.chart=a;this.domElementProvider=new q;this.announceRegion=this.addAnnounceRegion(f)}g.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()};g.prototype.announce=function(g){var f=this;a.setElementHTML(this.announceRegion,g);this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer);this.clearAnnouncementRegionTimer=setTimeout(function(){f.announceRegion.innerHTML=a.emptyHTML;delete f.clearAnnouncementRegionTimer},1E3)};g.prototype.addAnnounceRegion=
function(a){var f=this.chart.announcerContainer||this.createAnnouncerContainer(),e=this.domElementProvider.createElement("div");h(e,{"aria-hidden":!1,"aria-live":a});this.chart.styledMode?x(e,"highcharts-visually-hidden"):y(e);f.appendChild(e);return e};g.prototype.createAnnouncerContainer=function(){var a=this.chart,f=l.createElement("div");h(f,{"aria-hidden":!1,"class":"highcharts-announcer-container"});f.style.position="relative";a.renderTo.insertBefore(f,a.renderTo.firstChild);return a.announcerContainer=
f};return g}()});A(a,"Accessibility/Components/AnnotationsA11y.js",[a["Accessibility/Utils/HTMLUtilities.js"]],function(a){function q(a){return(a.annotations||[]).reduce(function(a,g){g.options&&!1!==g.options.visible&&(a=a.concat(g.labels));return a},[])}function m(a){return a.options&&a.options.accessibility&&a.options.accessibility.description||a.graphic&&a.graphic.text&&a.graphic.text.textStr||""}function p(a){var h=a.options&&a.options.accessibility&&a.options.accessibility.description;if(h)return h;
h=a.chart;var g=m(a),k=a.points.filter(function(b){return!!b.graphic}).map(function(b){var a=b.accessibility&&b.accessibility.valueDescription||b.graphic&&b.graphic.element&&b.graphic.element.getAttribute("aria-label")||"";b=b&&b.series.name||"";return(b?b+", ":"")+"data point "+a}).filter(function(b){return!!b}),f=k.length,e="accessibility.screenReaderSection.annotations.description"+(1<f?"MultiplePoints":f?"SinglePoint":"NoPoints");a={annotationText:g,annotation:a,numPoints:f,annotationPoint:k[0],
additionalAnnotationPoints:k.slice(1)};return h.langFormat(e,a)}function k(a){return q(a).map(function(a){return(a=l(x(p(a))))?"<li>".concat(a,"</li>"):""})}var l=a.escapeStringForHTML,x=a.stripHTMLTagsFromString;return{getAnnotationsInfoHTML:function(a){var h=a.annotations;if(!h||!h.length)return"";a=k(a);return'<ul style="list-style-type: none">'.concat(a.join(" "),"</ul>")},getAnnotationLabelDescription:p,getAnnotationListItems:k,getPointAnnotationTexts:function(a){var h=q(a.series.chart).filter(function(g){return-1<
g.points.indexOf(a)});return h.length?h.map(function(a){return"".concat(m(a))}):[]}}});A(a,"Accessibility/Components/InfoRegionsComponent.js",[a["Accessibility/A11yI18n.js"],a["Accessibility/AccessibilityComponent.js"],a["Accessibility/Utils/Announcer.js"],a["Accessibility/Components/AnnotationsA11y.js"],a["Core/Renderer/HTML/AST.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Core/FormatUtilities.js"],a["Core/Globals.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Core/Utilities.js"]],function(a,
q,m,p,k,l,J,y,h,g){function w(b,a){var c=a[0],d=b.series&&b.series[0]||{};d={numSeries:b.series.length,numPoints:d.points&&d.points.length,chart:b,mapTitle:b.mapView&&b.mapView.geoMap&&b.mapView.geoMap.title};if(!c)return b.langFormat("accessibility.chartTypes.emptyChart",d);if("map"===c)return d.mapTitle?b.langFormat("accessibility.chartTypes.mapTypeDescription",d):b.langFormat("accessibility.chartTypes.unknownMap",d);if(1<b.types.length)return b.langFormat("accessibility.chartTypes.combinationChart",
d);a=a[0];c=b.langFormat("accessibility.seriesTypeDescriptions."+a,d);var e=b.series&&2>b.series.length?"Single":"Multiple";return(b.langFormat("accessibility.chartTypes."+a+e,d)||b.langFormat("accessibility.chartTypes.default"+e,d))+(c?" "+c:"")}var f=this&&this.__extends||function(){var b=function(a,d){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var d in a)Object.prototype.hasOwnProperty.call(a,d)&&(b[d]=a[d])};return b(a,d)};return function(a,
d){function c(){this.constructor=a}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");b(a,d);a.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),e=p.getAnnotationsInfoHTML,b=l.getAxisDescription,c=l.getAxisRangeDescription,d=l.getChartTitle,u=l.unhideChartElementFromAT,D=J.format,I=y.doc,x=h.addClass,B=h.getElement,H=h.getHeadingTagNameForElement,F=h.stripHTMLTagsFromString,t=h.visuallyHideElement,n=g.attr,
r=g.pick;return function(C){function z(){var b=null!==C&&C.apply(this,arguments)||this;b.announcer=void 0;b.screenReaderSections={};return b}f(z,C);z.prototype.init=function(){var b=this.chart,a=this;this.initRegionsDefinitions();this.addEvent(b,"aftergetTableAST",function(b){a.onDataTableCreated(b)});this.addEvent(b,"afterViewData",function(b){b.wasHidden&&(a.dataTableDiv=b.element,setTimeout(function(){a.focusDataTable()},300))});this.announcer=new m(b,"assertive")};z.prototype.initRegionsDefinitions=
function(){var b=this;this.screenReaderSections={before:{element:null,buildContent:function(a){var d=a.options.accessibility.screenReaderSection.beforeChartFormatter;return d?d(a):b.defaultBeforeChartFormatter(a)},insertIntoDOM:function(b,a){a.renderTo.insertBefore(b,a.renderTo.firstChild)},afterInserted:function(){"undefined"!==typeof b.sonifyButtonId&&b.initSonifyButton(b.sonifyButtonId);"undefined"!==typeof b.dataTableButtonId&&b.initDataTableButton(b.dataTableButtonId)}},after:{element:null,buildContent:function(a){var d=
a.options.accessibility.screenReaderSection.afterChartFormatter;return d?d(a):b.defaultAfterChartFormatter()},insertIntoDOM:function(b,a){a.renderTo.insertBefore(b,a.container.nextSibling)},afterInserted:function(){b.chart.accessibility&&b.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}};z.prototype.onChartRender=function(){var b=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement();this.setLinkedDescriptionAttrs();Object.keys(this.screenReaderSections).forEach(function(a){b.updateScreenReaderSection(a)})};
z.prototype.getLinkedDescriptionElement=function(){var b=this.chart.options.accessibility.linkedDescription;if(b){if("string"!==typeof b)return b;b=D(b,this.chart);b=I.querySelectorAll(b);if(1===b.length)return b[0]}};z.prototype.setLinkedDescriptionAttrs=function(){var b=this.linkedDescriptionElement;b&&(b.setAttribute("aria-hidden","true"),x(b,"highcharts-linked-description"))};z.prototype.updateScreenReaderSection=function(b){var a=this.chart,d=this.screenReaderSections[b],c=d.buildContent(a),
e=d.element=d.element||this.createElement("div"),n=e.firstChild||this.createElement("div");c?(this.setScreenReaderSectionAttribs(e,b),k.setElementHTML(n,c),e.appendChild(n),d.insertIntoDOM(e,a),a.styledMode?x(n,"highcharts-visually-hidden"):t(n),u(a,n),d.afterInserted&&d.afterInserted()):(e.parentNode&&e.parentNode.removeChild(e),d.element=null)};z.prototype.setScreenReaderSectionAttribs=function(b,a){var c=this.chart,e=c.langFormat("accessibility.screenReaderSection."+a+"RegionLabel",{chart:c,chartTitle:d(c)});
a="highcharts-screen-reader-region-".concat(a,"-").concat(c.index);n(b,{id:a,"aria-label":e||void 0});b.style.position="relative";e&&b.setAttribute("role","all"===c.options.accessibility.landmarkVerbosity?"region":"group")};z.prototype.defaultBeforeChartFormatter=function(){var b=this.chart,c=b.options.accessibility.screenReaderSection.beforeChartFormat;if(!c)return"";var n=this.getAxesDescription(),r=b.sonify&&b.options.sonification&&b.options.sonification.enabled,z="highcharts-a11y-sonify-data-btn-"+
b.index,f="hc-linkto-highcharts-data-table-"+b.index,u=e(b),t=b.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:b});n={headingTagName:H(b.renderTo),chartTitle:d(b),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:n.xAxis,yAxisDescription:n.yAxis,playAsSoundButton:r?this.getSonifyButtonText(z):"",viewTableButton:b.getCSV?this.getDataTableButtonText(f):"",annotationsTitle:u?t:"",annotationsList:u};
b=a.i18nFormat(c,n,b);this.dataTableButtonId=f;this.sonifyButtonId=z;return b.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")};z.prototype.defaultAfterChartFormatter=function(){var b=this.chart,d=b.options.accessibility.screenReaderSection.afterChartFormat;if(!d)return"";var c={endOfChartMarker:this.getEndOfChartMarkerText()};return a.i18nFormat(d,c,b).replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")};z.prototype.getLinkedDescription=function(){var b=this.linkedDescriptionElement;return F(b&&b.innerHTML||"")};z.prototype.getLongdescText=
function(){var b=this.chart.options,a=b.caption;a=a&&a.text;var d=this.getLinkedDescription();return b.accessibility.description||d||a||""};z.prototype.getTypeDescriptionText=function(){var b=this.chart;return b.types?b.options.accessibility.typeDescription||w(b,b.types):""};z.prototype.getDataTableButtonText=function(b){var a=this.chart;a=a.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:a,chartTitle:d(a)});return'<button id="'+b+'">'+a+"</button>"};z.prototype.getSonifyButtonText=
function(b){var a=this.chart;if(a.options.sonification&&!1===a.options.sonification.enabled)return"";a=a.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:a,chartTitle:d(a)});return'<button id="'+b+'">'+a+"</button>"};z.prototype.getSubtitleText=function(){var b=this.chart.options.subtitle;return F(b&&b.text||"")};z.prototype.getEndOfChartMarkerText=function(){var b=this.chart,a=b.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:b});return'<div id="highcharts-end-of-chart-marker-'+
b.index+'">'+a+"</div>"};z.prototype.onDataTableCreated=function(b){var a=this.chart;if(a.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var d=b.tree.attributes||{};d.tabindex=-1;d.summary=a.langFormat("accessibility.table.tableSummary",{chart:a});b.tree.attributes=d}};z.prototype.focusDataTable=function(){var b=this.dataTableDiv;(b=b&&b.getElementsByTagName("table")[0])&&b.focus&&b.focus()};z.prototype.initSonifyButton=function(b){var a=
this,d=this.sonifyButton=B(b),c=this.chart,e=function(b){d&&(d.setAttribute("aria-hidden","true"),d.setAttribute("aria-label",""));b.preventDefault();b.stopPropagation();b=c.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:c});a.announcer.announce(b);setTimeout(function(){d&&(d.removeAttribute("aria-hidden"),d.removeAttribute("aria-label"));c.sonify&&c.sonify()},1E3)};d&&c&&(d.setAttribute("tabindex",-1),d.onclick=function(b){(c.options.accessibility&&c.options.accessibility.screenReaderSection.onPlayAsSoundClick||
e).call(this,b,c)})};z.prototype.initDataTableButton=function(b){var a=this.viewDataTableButton=B(b),d=this.chart;b=b.replace("hc-linkto-","");a&&(n(a,{tabindex:-1,"aria-expanded":!!B(b)}),a.onclick=d.options.accessibility.screenReaderSection.onViewDataTableClick||function(){d.viewData()})};z.prototype.getAxesDescription=function(){var b=this.chart,a=function(a,d){a=b[a];return 1<a.length||a[0]&&r(a[0].options.accessibility&&a[0].options.accessibility.enabled,d)},d=!!b.types&&0>b.types.indexOf("map")&&
0>b.types.indexOf("treemap")&&0>b.types.indexOf("tilemap"),c=!!b.hasCartesianSeries,e=a("xAxis",!b.angular&&c&&d);a=a("yAxis",c&&d);d={};e&&(d.xAxis=this.getAxisDescriptionText("xAxis"));a&&(d.yAxis=this.getAxisDescriptionText("yAxis"));return d};z.prototype.getAxisDescriptionText=function(a){var d=this.chart,e=d[a];return d.langFormat("accessibility.axis."+a+"Description"+(1<e.length?"Plural":"Singular"),{chart:d,names:e.map(function(a){return b(a)}),ranges:e.map(function(b){return c(b)}),numAxes:e.length})};
z.prototype.destroy=function(){this.announcer&&this.announcer.destroy()};return z}(q)});A(a,"Accessibility/Components/MenuComponent.js",[a["Core/Chart/Chart.js"],a["Core/Utilities.js"],a["Accessibility/AccessibilityComponent.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/HTMLUtilities.js"]],function(a,q,m,p,k,l){var x=this&&this.__extends||function(){var a=function(e,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&
function(b,a){b.__proto__=a}||function(b,a){for(var d in a)Object.prototype.hasOwnProperty.call(a,d)&&(b[d]=a[d])};return a(e,b)};return function(e,b){function c(){this.constructor=e}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");a(e,b);e.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),y=q.attr,h=k.getChartTitle,g=k.unhideChartElementFromAT,w=l.getFakeMouseEvent;m=function(a){function e(){return null!==
a&&a.apply(this,arguments)||this}x(e,a);e.prototype.init=function(){var b=this.chart,a=this;this.addEvent(b,"exportMenuShown",function(){a.onMenuShown()});this.addEvent(b,"exportMenuHidden",function(){a.onMenuHidden()});this.createProxyGroup()};e.prototype.onMenuHidden=function(){var b=this.chart.exportContextMenu;b&&b.setAttribute("aria-hidden","true");this.setExportButtonExpandedState("false")};e.prototype.onMenuShown=function(){var b=this.chart,a=b.exportContextMenu;a&&(this.addAccessibleContextMenuAttribs(),
g(b,a));this.setExportButtonExpandedState("true")};e.prototype.setExportButtonExpandedState=function(b){this.exportButtonProxy&&this.exportButtonProxy.buttonElement.setAttribute("aria-expanded",b)};e.prototype.onChartRender=function(){var b=this.chart,a=b.focusElement,d=b.accessibility;this.proxyProvider.clearGroup("chartMenu");this.proxyMenuButton();this.exportButtonProxy&&a&&a===b.exportingGroup&&(a.focusBorder?b.setFocusToElement(a,this.exportButtonProxy.buttonElement):d&&d.keyboardNavigation.tabindexContainer.focus())};
e.prototype.proxyMenuButton=function(){var b=this.chart,a=this.proxyProvider,d=b.exportSVGElements&&b.exportSVGElements[0],e=b.options.exporting,f=b.exportSVGElements&&b.exportSVGElements[0];e&&!1!==e.enabled&&e.accessibility&&e.accessibility.enabled&&f&&f.element&&d&&(this.exportButtonProxy=a.addProxyElement("chartMenu",{click:d},{"aria-label":b.langFormat("accessibility.exporting.menuButtonLabel",{chart:b,chartTitle:h(b)}),"aria-expanded":!1,title:b.options.lang.contextButtonTitle||null}))};e.prototype.createProxyGroup=
function(){this.chart&&this.proxyProvider&&this.proxyProvider.addGroup("chartMenu","div")};e.prototype.addAccessibleContextMenuAttribs=function(){var b=this.chart,a=b.exportDivElements;a&&a.length&&(a.forEach(function(b){b&&("LI"!==b.tagName||b.children&&b.children.length?b.setAttribute("aria-hidden","true"):b.setAttribute("tabindex",-1))}),(a=a[0]&&a[0].parentNode)&&y(a,{"aria-hidden":void 0,"aria-label":b.langFormat("accessibility.exporting.chartMenuLabel",{chart:b}),role:"list"}))};e.prototype.getKeyboardNavigation=
function(){var b=this.keyCodes,a=this.chart,d=this;return new p(a,{keyCodeMap:[[[b.left,b.up],function(){return d.onKbdPrevious(this)}],[[b.right,b.down],function(){return d.onKbdNext(this)}],[[b.enter,b.space],function(){return d.onKbdClick(this)}]],validate:function(){return!!a.exporting&&!1!==a.options.exporting.enabled&&!1!==a.options.exporting.accessibility.enabled},init:function(){var b=d.exportButtonProxy,c=d.chart.exportingGroup;b&&c&&a.setFocusToElement(c,b.buttonElement)},terminate:function(){a.hideExportMenu()}})};
e.prototype.onKbdPrevious=function(b){var a=this.chart,d=a.options.accessibility;b=b.response;for(var e=a.highlightedExportItemIx||0;e--;)if(a.highlightExportItem(e))return b.success;return d.keyboardNavigation.wrapAround?(a.highlightLastExportItem(),b.success):b.prev};e.prototype.onKbdNext=function(b){var a=this.chart,d=a.options.accessibility;b=b.response;for(var e=(a.highlightedExportItemIx||0)+1;e<a.exportDivElements.length;++e)if(a.highlightExportItem(e))return b.success;return d.keyboardNavigation.wrapAround?
(a.highlightExportItem(0),b.success):b.next};e.prototype.onKbdClick=function(b){var a=this.chart,d=a.exportDivElements[a.highlightedExportItemIx],e=(a.exportSVGElements&&a.exportSVGElements[0]).element;a.openMenu?this.fakeClickEvent(d):(this.fakeClickEvent(e),a.highlightExportItem(0));return b.response.success};return e}(m);(function(f){function e(){var b=this.exportSVGElements&&this.exportSVGElements[0];if(b&&(b=b.element,b.onclick))b.onclick(w("click"))}function b(){var b=this.exportDivElements;
b&&this.exportContextMenu&&this.openMenu&&(b.forEach(function(b){if(b&&"highcharts-menu-item"===b.className&&b.onmouseout)b.onmouseout(w("mouseout"))}),this.highlightedExportItemIx=0,this.exportContextMenu.hideMenu(),this.container.focus())}function c(b){var a=this.exportDivElements&&this.exportDivElements[b],d=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx];if(a&&"LI"===a.tagName&&(!a.children||!a.children.length)){var e=!!(this.renderTo.getElementsByTagName("g")[0]||
{}).focus;a.focus&&e&&a.focus();if(d&&d.onmouseout)d.onmouseout(w("mouseout"));if(a.onmouseover)a.onmouseover(w("mouseover"));this.highlightedExportItemIx=b;return!0}return!1}function d(){if(this.exportDivElements)for(var b=this.exportDivElements.length;b--;)if(this.highlightExportItem(b))return!0;return!1}var u=[];f.compose=function(f){q.pushUnique(u,f)&&(f=a.prototype,f.hideExportMenu=b,f.highlightExportItem=c,f.highlightLastExportItem=d,f.showExportMenu=e)}})(m||(m={}));return m});A(a,"Accessibility/KeyboardNavigation.js",
[a["Core/Globals.js"],a["Accessibility/Components/MenuComponent.js"],a["Core/Utilities.js"],a["Accessibility/Utils/EventProvider.js"],a["Accessibility/Utils/HTMLUtilities.js"]],function(a,q,m,p,k){var l=a.doc,x=a.win,y=m.addEvent,h=m.fireEvent,g=k.getElement,w=k.simulatedEventTarget;k=function(){function a(a,b){this.components=this.chart=void 0;this.currentModuleIx=NaN;this.exitAnchor=this.eventProvider=void 0;this.modules=[];this.tabindexContainer=void 0;this.init(a,b)}a.prototype.init=function(a,
b){var e=this,d=this.eventProvider=new p;this.chart=a;this.components=b;this.modules=[];this.currentModuleIx=0;this.update();d.addEvent(this.tabindexContainer,"keydown",function(b){return e.onKeydown(b)});d.addEvent(this.tabindexContainer,"focus",function(b){return e.onFocus(b)});["mouseup","touchend"].forEach(function(b){return d.addEvent(l,b,function(b){return e.onMouseUp(b)})});["mousedown","touchstart"].forEach(function(b){return d.addEvent(a.renderTo,b,function(){e.isClickingChart=!0})})};a.prototype.update=
function(a){var b=this.chart.options.accessibility;b=b&&b.keyboardNavigation;var e=this.components;this.updateContainerTabindex();b&&b.enabled&&a&&a.length?(this.modules=a.reduce(function(b,a){a=e[a].getKeyboardNavigation();return b.concat(a)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())};a.prototype.updateExitAnchor=function(){var a="highcharts-end-of-chart-marker-".concat(this.chart.index);a=g(a);this.removeExitAnchor();a?(this.makeElementAnExitAnchor(a),
this.exitAnchor=a):this.createExitAnchor()};a.prototype.move=function(a){var b=this.modules&&this.modules[this.currentModuleIx];b&&b.terminate&&b.terminate(a);this.chart.focusElement&&this.chart.focusElement.removeFocusBorder();this.currentModuleIx+=a;if(b=this.modules&&this.modules[this.currentModuleIx]){if(b.validate&&!b.validate())return this.move(a);if(b.init)return b.init(a),!0}this.currentModuleIx=0;this.exiting=!0;0<a?this.exitAnchor&&this.exitAnchor.focus():this.tabindexContainer.focus();
return!1};a.prototype.onFocus=function(a){var b=this.chart;a=a.relatedTarget&&b.container.contains(a.relatedTarget);!(b=(b=b.options.accessibility)&&b.keyboardNavigation)||!b.enabled||this.exiting||this.tabbingInBackwards||this.isClickingChart||a||(a=this.getFirstValidModuleIx(),null!==a&&(this.currentModuleIx=a,this.modules[a].init(1)));this.exiting=!1};a.prototype.onMouseUp=function(a){delete this.isClickingChart;if(!this.keyboardReset&&a.relatedTarget!==w){var b=this.chart;a.target&&b.container.contains(a.target)||
((a=this.modules&&this.modules[this.currentModuleIx||0])&&a.terminate&&a.terminate(),this.currentModuleIx=0);b.focusElement&&(b.focusElement.removeFocusBorder(),delete b.focusElement);this.keyboardReset=!0}};a.prototype.onKeydown=function(a){a=a||x.event;var b=this.modules&&this.modules.length&&this.modules[this.currentModuleIx],c;this.exiting=this.keyboardReset=!1;if(b){var d=b.run(a);d===b.response.success?c=!0:d===b.response.prev?c=this.move(-1):d===b.response.next&&(c=this.move(1));c&&(a.preventDefault(),
a.stopPropagation())}};a.prototype.updateContainerTabindex=function(){var a=this.chart.options.accessibility;a=a&&a.keyboardNavigation;a=!(a&&!1===a.enabled);var b=this.chart,c=b.container;b.renderTo.hasAttribute("tabindex")&&(c.removeAttribute("tabindex"),c=b.renderTo);this.tabindexContainer=c;var d=c.getAttribute("tabindex");a&&!d?c.setAttribute("tabindex","0"):a||b.container.removeAttribute("tabindex")};a.prototype.createExitAnchor=function(){var a=this.chart,b=this.exitAnchor=l.createElement("div");
a.renderTo.appendChild(b);this.makeElementAnExitAnchor(b)};a.prototype.makeElementAnExitAnchor=function(a){var b=this.tabindexContainer.getAttribute("tabindex")||0;a.setAttribute("class","highcharts-exit-anchor");a.setAttribute("tabindex",b);a.setAttribute("aria-hidden",!1);this.addExitAnchorEventsToEl(a)};a.prototype.removeExitAnchor=function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)};a.prototype.addExitAnchorEventsToEl=
function(a){var b=this.chart,c=this;this.eventProvider.addEvent(a,"focus",function(a){a=a||x.event;var d=!(a.relatedTarget&&b.container.contains(a.relatedTarget)||c.exiting);b.focusElement&&delete b.focusElement;d?(c.tabbingInBackwards=!0,c.tabindexContainer.focus(),delete c.tabbingInBackwards,a.preventDefault(),c.modules&&c.modules.length&&(c.currentModuleIx=c.modules.length-1,(a=c.modules[c.currentModuleIx])&&a.validate&&!a.validate()?c.move(-1):a&&a.init(-1))):c.exiting=!1})};a.prototype.getFirstValidModuleIx=
function(){for(var a=this.modules.length,b=0;b<a;++b){var c=this.modules[b];if(!c.validate||c.validate())return b}return null};a.prototype.destroy=function(){this.removeExitAnchor();this.eventProvider.removeAddedEvents();this.chart.container.removeAttribute("tabindex")};return a}();(function(f){function e(){var a=this;h(this,"dismissPopupContent",{},function(){a.tooltip&&a.tooltip.hide(0);a.hideExportMenu()})}function b(b){27===(b.which||b.keyCode)&&a.charts&&a.charts.forEach(function(a){a&&a.dismissPopupContent&&
a.dismissPopupContent()})}var c=[];f.compose=function(a){q.compose(a);m.pushUnique(c,a)&&(a.prototype.dismissPopupContent=e);m.pushUnique(c,l)&&y(l,"keydown",b);return a}})(k||(k={}));return k});A(a,"Accessibility/Components/LegendComponent.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Globals.js"],a["Core/Legend/Legend.js"],a["Core/Utilities.js"],a["Accessibility/AccessibilityComponent.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/HTMLUtilities.js"]],
function(a,q,m,p,k,l,J,y){function h(a){var b=a.legend&&a.legend.allItems,d=a.options.legend.accessibility||{};a=a.colorAxis&&a.colorAxis.some(function(a){return!a.dataClasses||!a.dataClasses.length});return!(!b||!b.length||a||!1===d.enabled)}function g(a,b){var d=b.legendItem||{};b.setState(a?"hover":"",!0);b=0;for(var e=["group","label","symbol"];b<e.length;b++){var f=d[e[b]];(f=f&&f.element||f)&&c(f,a?"mouseover":"mouseout")}}var w=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)Object.prototype.hasOwnProperty.call(b,d)&&(a[d]=b[d])};return a(b,d)};return function(b,d){function c(){this.constructor=b}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");a(b,d);b.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),f=a.animObject,e=q.doc,b=p.addEvent,c=p.fireEvent,d=p.isNumber,u=p.pick,D=p.syncTimeout,
I=J.getChartTitle,x=y.stripHTMLTagsFromString,B=y.addClass,H=y.removeClass;a=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.highlightedLegendItemIx=NaN;b.proxyGroup=null;return b}w(b,a);b.prototype.init=function(){var a=this;this.recreateProxies();this.addEvent(m,"afterScroll",function(){this.chart===a.chart&&(a.proxyProvider.updateGroupProxyElementPositions("legend"),a.updateLegendItemProxyVisibility(),-1<a.highlightedLegendItemIx&&this.chart.highlightLegendItem(a.highlightedLegendItemIx))});
this.addEvent(m,"afterPositionItem",function(b){this.chart===a.chart&&this.chart.renderer&&a.updateProxyPositionForItem(b.item)});this.addEvent(m,"afterRender",function(){this.chart===a.chart&&this.chart.renderer&&a.recreateProxies()&&D(function(){return a.proxyProvider.updateGroupProxyElementPositions("legend")},f(u(this.chart.renderer.globalAnimation,!0)).duration)})};b.prototype.updateLegendItemProxyVisibility=function(){var a=this.chart,b=a.legend,d=b.currentPage||1,c=b.clipHeight||0,e;(b.allItems||
[]).forEach(function(n){if(n.a11yProxyElement){var v=b.pages&&b.pages.length,z=n.a11yProxyElement.element,r=!1;e=n.legendItem||{};v&&(n=e.pageIx||0,v=e.y||0,r=e.label?Math.round(e.label.getBBox().height):0,r=v+r-b.pages[n]>c||n!==d-1);r?a.styledMode?B(z,"highcharts-a11y-invisible"):z.style.visibility="hidden":(H(z,"highcharts-a11y-invisible"),z.style.visibility="")}})};b.prototype.onChartRender=function(){h(this.chart)||this.removeProxies()};b.prototype.highlightAdjacentLegendPage=function(a){var b=
this.chart,d=b.legend;a=(d.currentPage||1)+a;var c=d.pages||[];if(0<a&&a<=c.length)for(var e=c=0,n=d.allItems;e<n.length;e++)((n[e].legendItem||{}).pageIx||0)+1===a&&(d=b.highlightLegendItem(c))&&(this.highlightedLegendItemIx=c),++c};b.prototype.updateProxyPositionForItem=function(a){a.a11yProxyElement&&a.a11yProxyElement.refreshPosition()};b.prototype.recreateProxies=function(){var a=e.activeElement,b=this.proxyGroup;a=a&&b&&b.contains(a);this.removeProxies();return h(this.chart)?(this.addLegendProxyGroup(),
this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),this.updateLegendTitle(),a&&this.chart.highlightLegendItem(this.highlightedLegendItemIx),!0):!1};b.prototype.removeProxies=function(){this.proxyProvider.removeGroup("legend")};b.prototype.updateLegendTitle=function(){var a=this.chart,b=x((a.legend&&a.legend.options.title&&a.legend.options.title.text||"").replace(/<br ?\/?>/g," "));a=a.langFormat("accessibility.legend.legendLabel"+(b?"":"NoTitle"),{chart:a,legendTitle:b,chartTitle:I(a)});
this.proxyProvider.updateGroupAttrs("legend",{"aria-label":a})};b.prototype.addLegendProxyGroup=function(){this.proxyGroup=this.proxyProvider.addGroup("legend","ul",{"aria-label":"_placeholder_",role:"all"===this.chart.options.accessibility.landmarkVerbosity?"region":null})};b.prototype.proxyLegendItems=function(){var a=this,b;((this.chart.legend||{}).allItems||[]).forEach(function(d){b=d.legendItem||{};b.label&&b.label.element&&a.proxyLegendItem(d)})};b.prototype.proxyLegendItem=function(a){var b=
a.legendItem||{};if(b.label&&b.group){var d=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:x(a.name),item:a});a.a11yProxyElement=this.proxyProvider.addProxyElement("legend",{click:b.label,visual:(b.group.div?b.label:b.group).element},{tabindex:-1,"aria-pressed":a.visible,"aria-label":d})}};b.prototype.getKeyboardNavigation=function(){var a=this.keyCodes,b=this,d=this.chart;return new l(d,{keyCodeMap:[[[a.left,a.right,a.up,a.down],function(a){return b.onKbdArrowKey(this,
a)}],[[a.enter,a.space],function(){return b.onKbdClick(this)}],[[a.pageDown,a.pageUp],function(d){b.highlightAdjacentLegendPage(d===a.pageDown?1:-1);return this.response.success}]],validate:function(){return b.shouldHaveLegendNavigation()},init:function(){d.highlightLegendItem(0);b.highlightedLegendItemIx=0},terminate:function(){b.highlightedLegendItemIx=-1;d.legend.allItems.forEach(function(a){return g(!1,a)})}})};b.prototype.onKbdArrowKey=function(a,b){var d=this.keyCodes,c=a.response,e=this.chart,
n=e.options.accessibility,f=e.legend.allItems.length;b=b===d.left||b===d.up?-1:1;if(e.highlightLegendItem(this.highlightedLegendItemIx+b))return this.highlightedLegendItemIx+=b,c.success;1<f&&n.keyboardNavigation.wrapAround&&a.init(b);return c.success};b.prototype.onKbdClick=function(a){var b=this.chart.legend.allItems[this.highlightedLegendItemIx];b&&b.a11yProxyElement&&b.a11yProxyElement.click();return a.response.success};b.prototype.shouldHaveLegendNavigation=function(){if(!h(this.chart))return!1;
var a=this.chart,b=(a.options.legend||{}).accessibility||{};return!!(a.legend.display&&b.keyboardNavigation&&b.keyboardNavigation.enabled)};return b}(k);(function(a){function c(a){var b=this.legend.allItems,c=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx,e=b[a],n=e.legendItem||{};return e?(d(c)&&b[c]&&g(!1,b[c]),b=this.legend,a=(b.allItems[a].legendItem||{}).pageIx,c=b.currentPage,"undefined"!==typeof a&&a+1!==c&&b.scroll(1+a-c),n=n.label,a=e.a11yProxyElement&&e.a11yProxyElement.buttonElement,
n&&n.element&&a&&this.setFocusToElement(n,a),g(!0,e),!0):!1}function e(a){var b=a.item;this.chart.options.accessibility.enabled&&b&&b.a11yProxyElement&&b.a11yProxyElement.buttonElement.setAttribute("aria-pressed",a.visible?"true":"false")}var f=[];a.compose=function(a,d){p.pushUnique(f,a)&&(a.prototype.highlightLegendItem=c);p.pushUnique(f,d)&&b(d,"afterColorizeItem",e)}})(a||(a={}));return a});A(a,"Accessibility/Components/SeriesComponent/SeriesDescriber.js",[a["Accessibility/Components/AnnotationsA11y.js"],
a["Accessibility/Utils/ChartUtilities.js"],a["Core/FormatUtilities.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Core/Utilities.js"]],function(a,q,m,p,k){function l(a){var b=a.index;return a.series&&a.series.data&&E(b)?r(a.series.data,function(a){return!!(a&&"undefined"!==typeof a.index&&a.index>b&&a.graphic&&a.graphic.element)})||null:null}function x(a){var b=a.chart.options.accessibility.series.pointDescriptionEnabledThreshold;return!!(!1!==b&&a.points&&a.points.length>=b)}function y(a){var b=
a.options.accessibility||{};return!x(a)&&!b.exposeAsGroupOnly}function h(a){var b=a.chart.options.accessibility.keyboardNavigation.seriesNavigation;return!(!a.points||!(a.points.length<b.pointNavigationEnabledThreshold||!1===b.pointNavigationEnabledThreshold))}function g(a,b){var d=a.series,c=d.chart;a=c.options.accessibility.point||{};var e=d.options.accessibility&&d.options.accessibility.point||{};d=d.tooltipOptions||{};c=c.options.lang;return C(b)?F(b,e.valueDecimals||a.valueDecimals||d.valueDecimals||
-1,c.decimalPoint,c.accessibility.thousandsSep||c.thousandsSep):b}function w(a){var b=(a.options.accessibility||{}).description;return b&&a.chart.langFormat("accessibility.series.description",{description:b,series:a})||""}function f(a,b){return a.chart.langFormat("accessibility.series."+b+"Description",{name:D(a[b]),series:a})}function e(a,b,d){var c=b||"",e=d||"";return a.series.pointArrayMap.reduce(function(b,d){var n=g(a,z(a[d],a.options[d]));return(d=void 0!==n?d+": "+c+n+e:n)?b+(b.length?", ":
"")+d:b},"")}function b(a){var b=a.series,d=1<b.chart.series.length||b.options.name,c=a.series;var n=c.chart;var f=c.options.accessibility;f=f&&f.point&&f.point.valueDescriptionFormat||n.options.accessibility.point.valueDescriptionFormat;c=z(c.xAxis&&c.xAxis.options.accessibility&&c.xAxis.options.accessibility.enabled,!n.angular&&"flowmap"!==c.type);if(c){var v=a.series;var r=v.chart;var t=v.options.accessibility&&v.options.accessibility.point||{},C=r.options.accessibility.point||{};(v=v.xAxis&&v.xAxis.dateTime)?
(v=v.getXDateFormat(a.x||0,r.options.tooltip.dateTimeLabelFormats),t=t.dateFormatter&&t.dateFormatter(a)||C.dateFormatter&&C.dateFormatter(a)||t.dateFormat||C.dateFormat||v,r=r.time.dateFormat(t,a.x||0,void 0)):r=void 0;t=(a.series.xAxis||{}).categories&&E(a.category)&&(""+a.category).replace("<br/>"," ");C=E(a.id)&&0>(""+a.id).indexOf("highcharts-");v="x, "+a.x;r=a.name||r||t||(C?a.id:v)}else r="";t=E(a.index)?a.index+1:"";C=a.series;var h=C.chart.options.accessibility.point||{},D=C.chart.options.accessibility&&
C.chart.options.accessibility.point||{},k=C.tooltipOptions||{};v=D.valuePrefix||h.valuePrefix||k.valuePrefix||"";h=D.valueSuffix||h.valueSuffix||k.valueSuffix||"";D=g(a,a["undefined"!==typeof a.value?"value":"y"]);C=a.isNull?C.chart.langFormat("accessibility.series.nullPointValue",{point:a}):C.pointArrayMap?e(a,v,h):v+D+h;n=H(f,{point:a,index:t,xDescription:r,value:C,separator:c?", ":""},n);f=(f=a.options&&a.options.accessibility&&a.options.accessibility.description)?" "+f:"";b=d?" "+b.name+".":"";
d=a.series.chart;c=u(a);r={point:a,annotations:c};d=c.length?d.langFormat("accessibility.series.pointAnnotationsDescription",r):"";a.accessibility=a.accessibility||{};a.accessibility.valueDescription=n;return n+f+b+(d?" "+d:"")}function c(a){var d=y(a),c=h(a),e=a.chart.options.accessibility.point.describeNull;(d||c)&&a.points.forEach(function(c){var f;if(!(f=c.graphic&&c.graphic.element)){var v=c.series;f=v&&v.chart;v=v&&v.is("sunburst");f=f&&f.options.accessibility.point.describeNull;if(f=c.isNull&&
!v&&f){v=c.series;var r=l(c);v=(f=r&&r.graphic)?f.parentGroup:v.graph||v.group;r=r?{x:z(c.plotX,r.plotX,0),y:z(c.plotY,r.plotY,0)}:{x:z(c.plotX,0),y:z(c.plotY,0)};r=c.series.chart.renderer.rect(r.x,r.y,1,1);r.attr({"class":"highcharts-a11y-mock-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0});v&&v.element?(c.graphic=r,c.hasMockGraphic=!0,r.add(v),v.element.insertBefore(r.element,f?f.element:null),f=r.element):f=void 0}}v=c.options&&c.options.accessibility&&!1===c.options.accessibility.enabled;
f&&(c.isNull&&!e?f.setAttribute("aria-hidden",!0):(f.setAttribute("tabindex","-1"),a.chart.styledMode||(f.style.outline="none"),d&&!v?(r=c.series,v=r.chart.options.accessibility.point||{},r=r.options.accessibility&&r.options.accessibility.point||{},c=n(r.descriptionFormatter&&r.descriptionFormatter(c)||v.descriptionFormatter&&v.descriptionFormatter(c)||b(c)),f.setAttribute("role","img"),f.setAttribute("aria-label",c)):f.setAttribute("aria-hidden",!0)))})}function d(a){var b=a.chart,d=b.types||[],
c=w(a),e=function(d){return b[d]&&1<b[d].length&&a[d]},n=a.index+1,r=f(a,"xAxis"),v=f(a,"yAxis"),u={seriesNumber:n,series:a,chart:b};d=1<d.length?"Combination":"";u=b.langFormat("accessibility.series.summary."+a.type+d,u)||b.langFormat("accessibility.series.summary.default"+d,u);e=(e("yAxis")?" "+v+".":"")+(e("xAxis")?" "+r+".":"");r=z(a.options.accessibility&&a.options.accessibility.descriptionFormat,b.options.accessibility.series.descriptionFormat,"");return H(r,{seriesDescription:u,authorDescription:c?
" "+c:"",axisDescription:e,series:a,chart:b,seriesNumber:n},void 0)}var u=a.getPointAnnotationTexts,D=q.getAxisDescription,I=q.getSeriesFirstPointElement,A=q.getSeriesA11yElement,B=q.unhideChartElementFromAT,H=m.format,F=m.numberFormat,t=p.reverseChildNodes,n=p.stripHTMLTagsFromString,r=k.find,C=k.isNumber,z=k.pick,E=k.defined;return{defaultPointDescriptionFormatter:b,defaultSeriesDescriptionFormatter:d,describeSeries:function(a){var b=a.chart,e=I(a),f=A(a),r=b.is3d&&b.is3d();if(f){f.lastChild!==
e||r||t(f);c(a);B(b,f);r=a.chart;b=r.options.chart;e=1<r.series.length;r=r.options.accessibility.series.describeSingleSeries;var z=(a.options.accessibility||{}).exposeAsGroupOnly;b.options3d&&b.options3d.enabled&&e||!(e||r||z||x(a))?f.removeAttribute("aria-label"):(b=a.chart.options.accessibility,e=b.landmarkVerbosity,(a.options.accessibility||{}).exposeAsGroupOnly?f.setAttribute("role","img"):"all"===e?f.setAttribute("role","region"):f.setAttribute("role","group"),f.setAttribute("tabindex","-1"),
a.chart.styledMode||(f.style.outline="none"),f.setAttribute("aria-label",n(b.series.descriptionFormatter&&b.series.descriptionFormatter(a)||d(a))))}}}});A(a,"Accessibility/Components/SeriesComponent/NewDataAnnouncer.js",[a["Core/Globals.js"],a["Core/Utilities.js"],a["Accessibility/Utils/Announcer.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/EventProvider.js"],a["Accessibility/Components/SeriesComponent/SeriesDescriber.js"]],function(a,q,m,p,k,l){function x(a){var b=a.series.data.filter(function(b){return a.x===
b.x&&a.y===b.y});return 1===b.length?b[0]:a}function y(a,c){var b=(a||[]).concat(c||[]).reduce(function(a,b){a[b.name+b.index]=b;return a},{});return Object.keys(b).map(function(a){return b[a]})}var h=q.addEvent,g=q.defined,w=p.getChartTitle,f=l.defaultPointDescriptionFormatter,e=l.defaultSeriesDescriptionFormatter;p=function(){function b(a){this.announcer=void 0;this.dirty={allSeries:{}};this.eventProvider=void 0;this.lastAnnouncementTime=0;this.chart=a}b.prototype.init=function(){var a=this.chart,
b=a.options.accessibility.announceNewData.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0;this.dirty={allSeries:{}};this.eventProvider=new k;this.announcer=new m(a,b);this.addEventListeners()};b.prototype.destroy=function(){this.eventProvider.removeAddedEvents();this.announcer.destroy()};b.prototype.addEventListeners=function(){var a=this,b=this.chart,e=this.eventProvider;e.addEvent(b,"afterApplyDrilldown",function(){a.lastAnnouncementTime=0});e.addEvent(b,"afterAddSeries",function(b){a.onSeriesAdded(b.series)});
e.addEvent(b,"redraw",function(){a.announceDirtyData()})};b.prototype.onSeriesAdded=function(a){this.chart.options.accessibility.announceNewData.enabled&&(this.dirty.hasDirty=!0,this.dirty.allSeries[a.name+a.index]=a,this.dirty.newSeries=g(this.dirty.newSeries)?void 0:a)};b.prototype.announceDirtyData=function(){var a=this;if(this.chart.options.accessibility.announceNewData&&this.dirty.hasDirty){var b=this.dirty.newPoint;b&&(b=x(b));this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(b){return a.dirty.allSeries[b]}),
this.dirty.newSeries,b);this.dirty={allSeries:{}}}};b.prototype.queueAnnouncement=function(a,b,e){var d=this,c=this.chart.options.accessibility.announceNewData;if(c.enabled){var f=+new Date;c=Math.max(0,c.minAnnounceInterval-(f-this.lastAnnouncementTime));a=y(this.queuedAnnouncement&&this.queuedAnnouncement.series,a);if(b=this.buildAnnouncementMessage(a,b,e))this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:f,message:b,series:a},this.queuedAnnouncementTimer=
setTimeout(function(){d&&d.announcer&&(d.lastAnnouncementTime=+new Date,d.announcer.announce(d.queuedAnnouncement.message),delete d.queuedAnnouncement,delete d.queuedAnnouncementTimer)},c)}};b.prototype.buildAnnouncementMessage=function(b,d,u){var c=this.chart,g=c.options.accessibility.announceNewData;if(g.announcementFormatter&&(b=g.announcementFormatter(b,d,u),!1!==b))return b.length?b:null;b=a.charts&&1<a.charts.length?"Multiple":"Single";b=d?"newSeriesAnnounce"+b:u?"newPointAnnounce"+b:"newDataAnnounce";
g=w(c);return c.langFormat("accessibility.announceNewData."+b,{chartTitle:g,seriesDesc:d?e(d):null,pointDesc:u?f(u):null,point:u,series:d})};return b}();(function(a){function b(a){var b=this.chart,d=this.newDataAnnouncer;d&&d.chart===b&&b.options.accessibility.announceNewData.enabled&&(d.dirty.newPoint=g(d.dirty.newPoint)?void 0:a.point)}function d(){var a=this.chart,b=this.newDataAnnouncer;b&&b.chart===a&&a.options.accessibility.announceNewData.enabled&&(b.dirty.hasDirty=!0,b.dirty.allSeries[this.name+
this.index]=this)}a.composedMembers=[];a.compose=function(c){q.pushUnique(a.composedMembers,c)&&(h(c,"addPoint",b),h(c,"updatedData",d))}})(p||(p={}));return p});A(a,"Accessibility/ProxyElement.js",[a["Core/Globals.js"],a["Core/Utilities.js"],a["Accessibility/Utils/EventProvider.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/HTMLUtilities.js"]],function(a,q,m,p,k){var l=a.doc,x=q.attr,y=q.css,h=q.merge,g=p.fireEventOnWrappedOrUnwrappedElement,w=k.cloneMouseEvent,f=k.cloneTouchEvent,
e=k.getFakeMouseEvent,b=k.removeElement;return function(){function a(a,b,c,e){this.chart=a;this.target=b;this.groupType=c;c="ul"===c;this.eventProvider=new m;var d=c?l.createElement("li"):null,f=this.buttonElement=l.createElement("button");a.styledMode||this.hideButtonVisually(f);d?(c&&!a.styledMode&&(d.style.listStyle="none"),d.appendChild(f),this.element=d):this.element=f;this.updateTarget(b,e)}a.prototype.click=function(){var a=this.getTargetPosition();a.x+=a.width/2;a.y+=a.height/2;a=e("click",
a);g(this.target.click,a)};a.prototype.updateTarget=function(a,b){this.target=a;this.updateCSSClassName();var d=b||{};Object.keys(d).forEach(function(a){null===d[a]&&delete d[a]});x(this.buttonElement,h({"aria-label":this.getTargetAttr(a.click,"aria-label")},d));this.eventProvider.removeAddedEvents();this.addProxyEventsToButton(this.buttonElement,a.click);this.refreshPosition()};a.prototype.refreshPosition=function(){var a=this.getTargetPosition();y(this.buttonElement,{width:(a.width||1)+"px",height:(a.height||
1)+"px",left:(Math.round(a.x)||0)+"px",top:(Math.round(a.y)||0)+"px"})};a.prototype.remove=function(){this.eventProvider.removeAddedEvents();b(this.element)};a.prototype.updateCSSClassName=function(){var a=this.chart.legend;a=a.group&&a.group.div;a=-1<(a&&a.className||"").indexOf("highcharts-no-tooltip");var b=-1<(this.getTargetAttr(this.target.click,"class")||"").indexOf("highcharts-no-tooltip");this.buttonElement.className=a||b?"highcharts-a11y-proxy-button highcharts-no-tooltip":"highcharts-a11y-proxy-button"};
a.prototype.addProxyEventsToButton=function(a,b){var d=this;"click touchstart touchend touchcancel touchmove mouseover mouseenter mouseleave mouseout".split(" ").forEach(function(c){var e=0===c.indexOf("touch");d.eventProvider.addEvent(a,c,function(a){var d=e?f(a):w(a);b&&g(b,d);a.stopPropagation();e||a.preventDefault()},{passive:!1})})};a.prototype.hideButtonVisually=function(a){y(a,{borderWidth:0,backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:.001,filter:"alpha(opacity=1)",
zIndex:999,overflow:"hidden",padding:0,margin:0,display:"block",position:"absolute","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"})};a.prototype.getTargetPosition=function(){var a=this.target.click;a=a.element?a.element:a;a=this.target.visual||a;if(this.chart.renderTo&&a&&a.getBoundingClientRect){a=a.getBoundingClientRect();var b=this.chart.pointer.getChartPosition();return{x:(a.left-b.left)/b.scaleX,y:(a.top-b.top)/b.scaleY,width:a.right/b.scaleX-a.left/b.scaleX,height:a.bottom/
b.scaleY-a.top/b.scaleY}}return{x:0,y:0,width:1,height:1}};a.prototype.getTargetAttr=function(a,b){return a.element?a.element.getAttribute(b):a.getAttribute(b)};return a}()});A(a,"Accessibility/ProxyProvider.js",[a["Core/Globals.js"],a["Core/Utilities.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/DOMElementProvider.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Accessibility/ProxyElement.js"]],function(a,q,m,p,k,l){var x=a.doc,y=q.attr,h=q.css,g=m.unhideChartElementFromAT,
w=k.removeElement,f=k.removeChildNodes;return function(){function a(a){this.chart=a;this.domElementProvider=new p;this.groups={};this.groupOrder=[];this.beforeChartProxyPosContainer=this.createProxyPosContainer("before");this.afterChartProxyPosContainer=this.createProxyPosContainer("after");this.update()}a.prototype.addProxyElement=function(a,c,d){var b=this.groups[a];if(!b)throw Error("ProxyProvider.addProxyElement: Invalid group key "+a);a=new l(this.chart,c,b.type,d);b.proxyContainerElement.appendChild(a.element);
b.proxyElements.push(a);return a};a.prototype.addGroup=function(a,c,d){var b=this.groups[a];if(b)return b.groupElement;b=this.domElementProvider.createElement(c);if(d&&d.role&&"div"!==c){var e=this.domElementProvider.createElement("div");e.appendChild(b)}else e=b;e.className="highcharts-a11y-proxy-group highcharts-a11y-proxy-group-"+a.replace(/\W/g,"-");this.groups[a]={proxyContainerElement:b,groupElement:e,type:c,proxyElements:[]};y(e,d||{});"ul"===c&&b.setAttribute("role","list");this.afterChartProxyPosContainer.appendChild(e);
this.updateGroupOrder(this.groupOrder);return e};a.prototype.updateGroupAttrs=function(a,c){var b=this.groups[a];if(!b)throw Error("ProxyProvider.updateGroupAttrs: Invalid group key "+a);y(b.groupElement,c)};a.prototype.updateGroupOrder=function(a){var b=this;this.groupOrder=a.slice();if(!this.isDOMOrderGroupOrder()){var d=a.indexOf("series"),e=-1<d?a.slice(0,d):a,g=-1<d?a.slice(d+1):[];a=x.activeElement;["before","after"].forEach(function(a){var d=b["before"===a?"beforeChartProxyPosContainer":"afterChartProxyPosContainer"];
a="before"===a?e:g;f(d);a.forEach(function(a){(a=b.groups[a])&&d.appendChild(a.groupElement)})});(this.beforeChartProxyPosContainer.contains(a)||this.afterChartProxyPosContainer.contains(a))&&a&&a.focus&&a.focus()}};a.prototype.clearGroup=function(a){var b=this.groups[a];if(!b)throw Error("ProxyProvider.clearGroup: Invalid group key "+a);f(b.proxyContainerElement)};a.prototype.removeGroup=function(a){var b=this.groups[a];b&&(w(b.groupElement),delete this.groups[a])};a.prototype.update=function(){this.updatePosContainerPositions();
this.updateGroupOrder(this.groupOrder);this.updateProxyElementPositions()};a.prototype.updateProxyElementPositions=function(){Object.keys(this.groups).forEach(this.updateGroupProxyElementPositions.bind(this))};a.prototype.updateGroupProxyElementPositions=function(a){(a=this.groups[a])&&a.proxyElements.forEach(function(a){return a.refreshPosition()})};a.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()};a.prototype.createProxyPosContainer=function(a){var b=this.domElementProvider.createElement("div");
b.setAttribute("aria-hidden","false");b.className="highcharts-a11y-proxy-container"+(a?"-"+a:"");h(b,{top:"0",left:"0"});this.chart.styledMode||(b.style.whiteSpace="nowrap",b.style.position="absolute");return b};a.prototype.getCurrentGroupOrderInDOM=function(){var a=this,c=function(b){var d=[];b=b.children;for(var c=0;c<b.length;++c){a:{var e=b[c];for(var f=Object.keys(a.groups),g=f.length;g--;){var h=f[g],t=a.groups[h];if(t&&e===t.groupElement){e=h;break a}}e=void 0}e&&d.push(e)}return d},d=c(this.beforeChartProxyPosContainer);
c=c(this.afterChartProxyPosContainer);d.push("series");return d.concat(c)};a.prototype.isDOMOrderGroupOrder=function(){var a=this,c=this.getCurrentGroupOrderInDOM(),d=this.groupOrder.filter(function(b){return"series"===b||!!a.groups[b]}),e=c.length;if(e!==d.length)return!1;for(;e--;)if(c[e]!==d[e])return!1;return!0};a.prototype.updatePosContainerPositions=function(){var a=this.chart;if(!a.renderer.forExport){var c=a.renderer.box;a.container.insertBefore(this.afterChartProxyPosContainer,c.nextSibling);
a.container.insertBefore(this.beforeChartProxyPosContainer,c);g(this.chart,this.afterChartProxyPosContainer);g(this.chart,this.beforeChartProxyPosContainer)}};return a}()});A(a,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"},rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,
x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%e %b %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#334eff",cursor:"pointer",fontSize:"0.8em"},labelStyle:{color:"#666666",fontSize:"0.8em"}}}});A(a,"Stock/RangeSelector/RangeSelectorComposition.js",[a["Core/Defaults.js"],a["Stock/RangeSelector/RangeSelectorDefaults.js"],
a["Core/Utilities.js"]],function(a,q,m){function p(){var a=this.range,b=a.type,d=this.max,c=this.chart.time,e=function(a,d){var e="year"===b?"FullYear":"Month",n=new c.Date(a),f=c.get(e,n);c.set(e,n,f+d);f===c.get(e,n)&&c.set("Date",n,0);return n.getTime()-a};if(D(a)){var f=d-a;var v=a}else a&&(f=d+e(d,-(a.count||1)),this.chart&&(this.chart.fixedRange=d-f));var g=A(this.dataMin,Number.MIN_VALUE);D(f)||(f=g);f<=g&&(f=g,"undefined"===typeof v&&(v=e(f,a.count)),this.newMax=Math.min(f+v,A(this.dataMax,
Number.MAX_VALUE)));D(d)?!D(a)&&a&&a._offsetMin&&(f+=a._offsetMin):f=void 0;return f}function k(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new F(this))}function l(){var a=this.axes,b=this.rangeSelector;b&&(D(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===a?this.extraBottomMargin=
!0:"middle"!==a&&(this.extraTopMargin=!0)))}function x(a){var d,c,e,f,E=a.rangeSelector,v=function(){E&&(d=a.xAxis[0].getExtremes(),c=a.legend,f=E&&E.options.verticalAlign,D(d.min)&&E.render(d.min,d.max),c.display&&"top"===f&&f===c.options.verticalAlign&&(e=I(a.spacingBox),e.y="vertical"===c.options.layout?a.plotTop:e.y+E.getHeight(),c.group.placed=!1,c.align(e)))};E&&(u(B,function(b){return b[0]===a})||B.push([a,[b(a.xAxis[0],"afterSetExtremes",function(a){E&&E.render(a.min,a.max)}),b(a,"redraw",
v)]]),v())}function y(){for(var a=0,b=B.length;a<b;++a){var d=B[a];if(d[0]===this){d[1].forEach(function(a){return a()});B.splice(a,1);break}}}function h(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}function g(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}function w(a){var b=a.options.rangeSelector;
a=this.extraBottomMargin;var d=this.extraTopMargin,e=this.rangeSelector;b&&b.enabled&&!c(e)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=e=new F(this));this.extraTopMargin=this.extraBottomMargin=!1;e&&(x(this),b=b&&b.verticalAlign||e.options&&e.options.verticalAlign,e.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0)),this.extraBottomMargin!==a||this.extraTopMargin!==d)&&(this.isDirtyBox=!0)}var f=a.defaultOptions,
e=a.setOptions,b=m.addEvent,c=m.defined,d=m.extend,u=m.find,D=m.isNumber,I=m.merge,A=m.pick,B=[],H=[],F;return{compose:function(a,c,r){F=r;m.pushUnique(H,a)&&(a.prototype.minFromRange=p);m.pushUnique(H,c)&&(b(c,"afterGetContainer",k),b(c,"beforeRender",l),b(c,"destroy",y),b(c,"getMargins",h),b(c,"render",g),b(c,"update",w),c.prototype.callbacks.push(x));m.pushUnique(H,e)&&(d(f,{rangeSelector:q.rangeSelector}),d(f.lang,q.lang))}}});A(a,"Stock/RangeSelector/RangeSelector.js",[a["Core/Axis/Axis.js"],
a["Core/Defaults.js"],a["Core/Globals.js"],a["Stock/RangeSelector/RangeSelectorComposition.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,q,m,p,k,l){function x(a){if(-1!==a.indexOf("%L"))return"text";var b="aAdewbBmoyY".split("").some(function(b){return-1!==a.indexOf("%"+b)}),d="HkIlMS".split("").some(function(b){return-1!==a.indexOf("%"+b)});return b&&d?"datetime-local":b?"date":d?"time":"text"}var y=q.defaultOptions,h=l.addEvent,g=l.createElement,w=l.css,f=l.defined,
e=l.destroyObjectProperties,b=l.discardElement,c=l.extend,d=l.fireEvent,u=l.isNumber,D=l.merge,I=l.objectEach,A=l.pad,B=l.pick,H=l.pInt,F=l.splat;q=function(){function t(a){this.buttons=void 0;this.buttonOptions=t.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=a;this.init(a)}t.compose=function(a,b){p.compose(a,b,t)};t.prototype.clickButton=function(b,c){var e=this.chart,n=this.buttonOptions[b],r=e.xAxis[0],v=e.scroller&&e.scroller.getUnionExtremes()||r||{},
g=n.type,t=n.dataGrouping,k=v.dataMin,m=v.dataMax,G=r&&Math.round(Math.min(r.max,B(m,r.max)));v=n._range;var q,l=!0;if(null!==k&&null!==m){e.fixedRange=v;this.setSelected(b);t&&(this.forcedDataGrouping=!0,a.prototype.setDataGrouping.call(r||{chart:this.chart},t,!1),this.frozenStates=n.preserveDataGrouping);if("month"===g||"year"===g)if(r){g={range:n,max:G,chart:e,dataMin:k,dataMax:m};var w=r.minFromRange.call(g);u(g.newMax)&&(G=g.newMax);l=!1}else v=n;else if(v)w=Math.max(G-v,k),G=Math.min(w+v,m),
l=!1;else if("ytd"===g)if(r){if("undefined"===typeof m||"undefined"===typeof k)k=Number.MAX_VALUE,m=Number.MIN_VALUE,e.series.forEach(function(a){if(a=a.xData)k=Math.min(a[0],k),m=Math.max(a[a.length-1],m)}),c=!1;g=this.getYTDExtremes(m,k,e.time.useUTC);w=q=g.min;G=g.max}else{this.deferredYTDClick=b;return}else"all"===g&&r&&(e.navigator&&e.navigator.baseSeries[0]&&(e.navigator.baseSeries[0].xAxis.options.range=void 0),w=k,G=m);l&&n._offsetMin&&f(w)&&(w+=n._offsetMin);n._offsetMax&&f(G)&&(G+=n._offsetMax);
this.dropdown&&(this.dropdown.selectedIndex=b+1);if(r)r.setExtremes(w,G,B(c,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:n});else{var p=F(e.options.xAxis)[0];var D=p.range;p.range=v;var x=p.min;p.min=q;h(e,"load",function(){p.range=D;p.min=x})}d(this,"afterBtnClick")}};t.prototype.setSelected=function(a){this.selected=this.options.selected=a};t.prototype.init=function(a){var b=this,c=a.options.rangeSelector,e=c.buttons||b.defaultButtons.slice(),f=c.selected,n=function(){var a=b.minInput,
c=b.maxInput;a&&a.blur&&d(a,"blur");c&&c.blur&&d(c,"blur")};b.chart=a;b.options=c;b.buttons=[];b.buttonOptions=e;this.eventsToUnbind=[];this.eventsToUnbind.push(h(a.container,"mousedown",n));this.eventsToUnbind.push(h(a,"resize",n));e.forEach(b.computeButtonRange);"undefined"!==typeof f&&e[f]&&this.clickButton(f,!1);this.eventsToUnbind.push(h(a,"load",function(){a.xAxis&&a.xAxis[0]&&h(a.xAxis[0],"setExtremes",function(d){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==d.trigger&&"updatedData"!==
d.trigger&&b.forcedDataGrouping&&!b.frozenStates&&this.setDataGrouping(!1,!1)})}))};t.prototype.updateButtonStates=function(){var a=this,b=this.chart,d=this.dropdown,c=b.xAxis[0],e=Math.round(c.max-c.min),f=!c.hasVisibleSeries,g=b.scroller&&b.scroller.getUnionExtremes()||c,h=g.dataMin,t=g.dataMax;b=a.getYTDExtremes(t,h,b.time.useUTC);var k=b.min,m=b.max,w=a.selected,p=a.options.allButtonsEnabled,q=a.buttons,l=u(w);a.buttonOptions.forEach(function(b,n){var r=b._range,v=b.type,z=b.count||1,g=q[n],E=
b._offsetMax-b._offsetMin,u=n===w,C=r>t-h,G=r<c.minRange;b=0;var K=!1,F=!1;r=r===e;("month"===v||"year"===v)&&e+36E5>=864E5*{month:28,year:365}[v]*z-E&&e-36E5<=864E5*{month:31,year:366}[v]*z+E?r=!0:"ytd"===v?(r=m-k+E===e,K=!u):"all"===v&&(r=c.max-c.min>=t-h,F=!u&&l&&r);v=!p&&(C||G||F||f);z=u&&r||r&&!l&&!K||u&&a.frozenStates;v?b=3:z&&(l=!0,b=2);g.state!==b&&(g.setState(b),d&&(d.options[n+1].disabled=v,2===b&&(d.selectedIndex=n+1)),0===b&&w===n&&a.setSelected())})};t.prototype.computeButtonRange=function(a){var b=
a.type,d=a.count||1,c={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(c[b])a._range=c[b]*d;else if("month"===b||"year"===b)a._range=864E5*{month:30,year:365}[b]*d;a._offsetMin=B(a.offsetMin,0);a._offsetMax=B(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin};t.prototype.getInputValue=function(a){a="min"===a?this.minInput:this.maxInput;var b=this.chart.options.rangeSelector,d=this.chart.time;return a?("text"===a.type&&b.inputDateParser||this.defaultInputDateParser)(a.value,
d.useUTC,d):0};t.prototype.setInputValue=function(a,b){var d=this.options,c=this.chart.time,e="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:this.maxDateBox;if(e){var n=e.getAttribute("data-hc-time");n=f(n)?Number(n):void 0;f(b)&&(f(n)&&e.setAttribute("data-hc-time-previous",n),e.setAttribute("data-hc-time",b),n=b);e.value=c.dateFormat(this.inputTypeFormats[e.type]||d.inputEditDateFormat,n);a&&a.attr({text:c.dateFormat(d.inputDateFormat,n)})}};t.prototype.setInputExtremes=function(a,
b,d){if(a="min"===a?this.minInput:this.maxInput){var c=this.inputTypeFormats[a.type],e=this.chart.time;c&&(b=e.dateFormat(c,b),a.min!==b&&(a.min=b),d=e.dateFormat(c,d),a.max!==d&&(a.max=d))}};t.prototype.showInput=function(a){var b="min"===a?this.minDateBox:this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&b&&this.inputGroup){var d="text"===a.type,c=this.inputGroup,e=c.translateX;c=c.translateY;var f=this.options.inputBoxWidth;w(a,{width:d?b.width+(f?-2:20)+"px":"auto",height:b.height-
2+"px",border:"2px solid silver"});d&&f?w(a,{left:e+b.x+"px",top:c+"px"}):w(a,{left:Math.min(Math.round(b.x+e-(a.offsetWidth-b.width)/2),this.chart.chartWidth-a.offsetWidth)+"px",top:c-(a.offsetHeight-b.height)/2+"px"})}};t.prototype.hideInput=function(a){(a="min"===a?this.minInput:this.maxInput)&&w(a,{top:"-9999em",border:0,width:"1px",height:"1px"})};t.prototype.defaultInputDateParser=function(a,b,d){var c=a.split("/").join("-").split(" ").join("T");-1===c.indexOf("T")&&(c+="T00:00");if(b)c+="Z";
else{var e;if(e=m.isSafari)e=c,e=!(6<e.length&&(e.lastIndexOf("-")===e.length-6||e.lastIndexOf("+")===e.length-6));e&&(e=(new Date(c)).getTimezoneOffset()/60,c+=0>=e?"+".concat(A(-e),":00"):"-".concat(A(e),":00"))}c=Date.parse(c);u(c)||(a=a.split("-"),c=Date.UTC(H(a[0]),H(a[1])-1,H(a[2])));d&&b&&u(c)&&(c+=d.getTimezoneOffset(c));return c};t.prototype.drawInput=function(a){function b(){var b=n.maxInput,c=n.minInput,e=d.xAxis[0],f=d.scroller&&d.scroller.xAxis?d.scroller.xAxis:e,v=f.dataMin;f=f.dataMax;
var r=n.getInputValue(a);r!==Number(l.getAttribute("data-hc-time-previous"))&&u(r)&&(l.setAttribute("data-hc-time-previous",r),p&&b&&u(v)?r>Number(b.getAttribute("data-hc-time"))?r=void 0:r<v&&(r=v):c&&u(f)&&(r<Number(c.getAttribute("data-hc-time"))?r=void 0:r>f&&(r=f)),"undefined"!==typeof r&&e.setExtremes(p?r:e.min,p?e.max:r,void 0,void 0,{trigger:"rangeSelectorInput"}))}var d=this.chart,e=this.div,f=this.inputGroup,n=this,h=d.renderer.style||{},t=d.renderer,k=d.options.rangeSelector,p="min"===
a,G=y.lang[p?"rangeSelectorFrom":"rangeSelectorTo"]||"";G=t.label(G,0).addClass("highcharts-range-label").attr({padding:G?2:0,height:G?k.inputBoxHeight:0}).add(f);t=t.label("",0).addClass("highcharts-range-input").attr({padding:2,width:k.inputBoxWidth,height:k.inputBoxHeight,"text-align":"center"}).on("click",function(){n.showInput(a);n[a+"Input"].focus()});d.styledMode||t.attr({stroke:k.inputBoxBorderColor,"stroke-width":1});t.add(f);var l=g("input",{name:a,className:"highcharts-range-selector"},
void 0,e);l.setAttribute("type",x(k.inputDateFormat||"%e %b %Y"));d.styledMode||(G.css(D(h,k.labelStyle)),t.css(D({color:"#333333"},h,k.inputStyle)),w(l,c({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:h.fontSize,fontFamily:h.fontFamily,top:"-9999em"},k.inputStyle)));l.onfocus=function(){n.showInput(a)};l.onblur=function(){l===m.doc.activeElement&&b();n.hideInput(a);n.setInputValue(a);l.blur()};var q=!1;l.onchange=
function(){q||(b(),n.hideInput(a),l.blur())};l.onkeypress=function(a){13===a.keyCode&&b()};l.onkeydown=function(a){q=!0;38!==a.keyCode&&40!==a.keyCode||b()};l.onkeyup=function(){q=!1};return{dateBox:t,input:l,label:G}};t.prototype.getPosition=function(){var a=this.chart,b=a.options.rangeSelector;a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}};t.prototype.getYTDExtremes=function(a,b,d){var c=this.chart.time,e=new c.Date(a),
f=c.get("FullYear",e);d=d?c.Date.UTC(f,0,1):+new c.Date(f,0,1);b=Math.max(b,d);e=e.getTime();return{max:Math.min(a||e,e),min:b}};t.prototype.render=function(a,b){var d=this.chart,c=d.renderer,e=d.container,n=d.options,r=n.rangeSelector,h=B(n.chart.style&&n.chart.style.zIndex,0)+1;n=r.inputEnabled;if(!1!==r.enabled){this.rendered||(this.group=c.g("range-selector-group").attr({zIndex:7}).add(),this.div=g("div",void 0,{position:"relative",height:0,zIndex:h}),this.buttonOptions.length&&this.renderButtons(),
e.parentNode&&e.parentNode.insertBefore(this.div,e),n&&(this.inputGroup=c.g("input-group").add(this.group),c=this.drawInput("min"),this.minDateBox=c.dateBox,this.minLabel=c.label,this.minInput=c.input,c=this.drawInput("max"),this.maxDateBox=c.dateBox,this.maxLabel=c.label,this.maxInput=c.input));if(n&&(this.setInputValue("min",a),this.setInputValue("max",b),a=d.scroller&&d.scroller.getUnionExtremes()||d.xAxis[0]||{},f(a.dataMin)&&f(a.dataMax)&&(d=d.xAxis[0].minRange||0,this.setInputExtremes("min",
a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-d),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+d,a.dataMax)),this.inputGroup)){var t=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(a){if(a){var b=a.getBBox().width;b&&(a.attr({x:t}),t+=b+r.inputSpacing)}})}this.alignElements();this.rendered=!0}};t.prototype.renderButtons=function(){var a=this,b=this.buttons,c=this.options,e=y.lang,f=this.chart.renderer,v=D(c.buttonTheme),t=v&&v.states,
u=v.width||28;delete v.width;delete v.states;this.buttonGroup=f.g("range-selector-buttons").add(this.group);var k=this.dropdown=g("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);h(k,"touchstart",function(){k.style.fontSize="16px"});[[m.isMS?"mouseover":"mouseenter"],[m.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(c){var e=c[0],f=c[1];h(k,e,function(){var c=b[a.currentButtonIndex()];c&&d(c.element,
f||e)})});this.zoomText=f.label(e&&e.rangeSelectorZoom||"",0).attr({padding:c.buttonTheme.padding,height:c.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(c.labelStyle),v["stroke-width"]=B(v["stroke-width"],0));g("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,k);this.buttonOptions.forEach(function(d,c){g("option",{textContent:d.title||d.text},void 0,k);b[c]=f.button(d.text,0,0,function(b){var e=d.events&&d.events.click,
f;e&&(f=e.call(d,b));!1!==f&&a.clickButton(c);a.isActive=!0},v,t&&t.hover,t&&t.select,t&&t.disabled).attr({"text-align":"center",width:u}).add(a.buttonGroup);d.title&&b[c].attr("title",d.title)})};t.prototype.alignElements=function(){var a=this,b=this.buttonGroup,d=this.buttons,c=this.chart,e=this.group,f=this.inputGroup,g=this.options,t=this.zoomText,h=c.options,k=h.exporting&&!1!==h.exporting.enabled&&h.navigation&&h.navigation.buttonOptions;h=g.buttonPosition;var u=g.inputPosition,m=g.verticalAlign,
l=function(b,d){return k&&a.titleCollision(c)&&"top"===m&&"right"===d.align&&d.y-b.getBBox().height-12<(k.y||0)+(k.height||0)+c.spacing[0]?-40:0},p=c.plotLeft;if(e&&h&&u){var w=h.x-c.spacing[3];if(b){this.positionButtons();if(!this.initialButtonGroupWidth){var q=0;t&&(q+=t.getBBox().width+5);d.forEach(function(a,b){q+=a.width;b!==d.length-1&&(q+=g.buttonSpacing)});this.initialButtonGroupWidth=q}p-=c.spacing[3];this.updateButtonStates();t=l(b,h);this.alignButtonGroup(t);e.placed=b.placed=c.hasLoaded}b=
0;f&&(b=l(f,u),"left"===u.align?w=p:"right"===u.align&&(w=-Math.max(c.axisOffset[1],-b)),f.align({y:u.y,width:f.getBBox().width,align:u.align,x:u.x+w-2},!0,c.spacingBox),f.placed=c.hasLoaded);this.handleCollision(b);e.align({verticalAlign:m},!0,c.spacingBox);f=e.alignAttr.translateY;b=e.getBBox().height+20;l=0;"bottom"===m&&(l=(l=c.legend&&c.legend.options)&&"bottom"===l.verticalAlign&&l.enabled&&!l.floating?c.legend.legendHeight+B(l.margin,10):0,b=b+l-20,l=f-b-(g.floating?0:g.y)-(c.titleOffset?c.titleOffset[2]:
0)-10);if("top"===m)g.floating&&(l=0),c.titleOffset&&c.titleOffset[0]&&(l=c.titleOffset[0]),l+=c.margin[0]-c.spacing[0]||0;else if("middle"===m)if(u.y===h.y)l=f;else if(u.y||h.y)l=0>u.y||0>h.y?l-Math.min(u.y,h.y):f-b;e.translate(g.x,g.y+Math.floor(l));h=this.minInput;u=this.maxInput;f=this.dropdown;g.inputEnabled&&h&&u&&(h.style.marginTop=e.translateY+"px",u.style.marginTop=e.translateY+"px");f&&(f.style.marginTop=e.translateY+"px")}};t.prototype.alignButtonGroup=function(a,b){var d=this.chart,c=
this.buttonGroup,e=this.options.buttonPosition,f=d.plotLeft-d.spacing[3],n=e.x-d.spacing[3];"right"===e.align?n+=a-f:"center"===e.align&&(n-=f/2);c&&c.align({y:e.y,width:B(b,this.initialButtonGroupWidth),align:e.align,x:n},!0,d.spacingBox)};t.prototype.positionButtons=function(){var a=this.buttons,b=this.chart,d=this.options,c=this.zoomText,e=b.hasLoaded?"animate":"attr",f=d.buttonPosition,g=b=b.plotLeft;c&&"hidden"!==c.visibility&&(c[e]({x:B(b+f.x,b)}),g+=f.x+c.getBBox().width+5);c=0;for(f=this.buttonOptions.length;c<
f;++c)if("hidden"!==a[c].visibility)a[c][e]({x:g}),g+=a[c].width+d.buttonSpacing;else a[c][e]({x:b})};t.prototype.handleCollision=function(a){var b=this,d=this.chart,c=this.buttonGroup,e=this.inputGroup,f=this.options,n=f.buttonPosition,g=f.dropdown,h=f.inputPosition;f=function(){var a=0;b.buttons.forEach(function(b){b=b.getBBox();b.width>a&&(a=b.width)});return a};var t=function(b){if(e&&c){var d=e.alignAttr.translateX+e.alignOptions.x-a+e.getBBox().x+2,f=e.alignOptions.width,g=c.alignAttr.translateX+
c.getBBox().x;return g+b>d&&d+f>g&&n.y<h.y+e.getBBox().height}return!1},u=function(){e&&c&&e.attr({translateX:e.alignAttr.translateX+(d.axisOffset[1]>=-a?0:-a),translateY:e.alignAttr.translateY+c.getBBox().height+10})};if(c){if("always"===g){this.collapseButtons(a);t(f())&&u();return}"never"===g&&this.expandButtons()}e&&c?h.align===n.align||t(this.initialButtonGroupWidth+20)?"responsive"===g?(this.collapseButtons(a),t(f())&&u()):u():"responsive"===g&&this.expandButtons():c&&"responsive"===g&&(this.initialButtonGroupWidth>
d.plotWidth?this.collapseButtons(a):this.expandButtons())};t.prototype.collapseButtons=function(a){var b=this.buttons,d=this.buttonOptions,c=this.chart,e=this.dropdown,f=this.options,n=this.zoomText,g=c.userOptions.rangeSelector&&c.userOptions.rangeSelector.buttonTheme||{},h=function(a){return{text:a?"".concat(a," \u25be"):"\u25be",width:"auto",paddingLeft:B(f.buttonTheme.paddingLeft,g.padding,8),paddingRight:B(f.buttonTheme.paddingRight,g.padding,8)}};n&&n.hide();var t=!1;d.forEach(function(a,d){d=
b[d];2!==d.state?d.hide():(d.show(),d.attr(h(a.text)),t=!0)});t||(e&&(e.selectedIndex=0),b[0].show(),b[0].attr(h(this.zoomText&&this.zoomText.textStr)));d=f.buttonPosition.align;this.positionButtons();"right"!==d&&"center"!==d||this.alignButtonGroup(a,b[this.currentButtonIndex()].getBBox().width);this.showDropdown()};t.prototype.expandButtons=function(){var a=this.buttons,b=this.buttonOptions,d=this.options,c=this.zoomText;this.hideDropdown();c&&c.show();b.forEach(function(b,c){c=a[c];c.show();c.attr({text:b.text,
width:d.buttonTheme.width||28,paddingLeft:B(d.buttonTheme.paddingLeft,"unset"),paddingRight:B(d.buttonTheme.paddingRight,"unset")});2>c.state&&c.setState(0)});this.positionButtons()};t.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-1:0};t.prototype.showDropdown=function(){var a=this.buttonGroup,b=this.buttons,d=this.chart,c=this.dropdown;if(a&&c){var e=a.translateX;a=a.translateY;b=b[this.currentButtonIndex()].getBBox();w(c,{left:d.plotLeft+
e+"px",top:a+.5+"px",width:b.width+"px",height:b.height+"px"});this.hasVisibleDropdown=!0}};t.prototype.hideDropdown=function(){var a=this.dropdown;a&&(w(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};t.prototype.getHeight=function(){var a=this.options,b=this.group,d=a.y,c=a.buttonPosition.y,e=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=b?b.getBBox(!0).height+13+d:0;b=Math.min(e,c);if(0>e&&0>c||0<e&&0<c)a+=Math.abs(b);return a};t.prototype.titleCollision=
function(a){return!(a.options.title.text||a.options.subtitle.text)};t.prototype.update=function(a){var b=this.chart;D(!0,b.options.rangeSelector,a);this.destroy();this.init(b);this.render()};t.prototype.destroy=function(){var a=this,d=a.minInput,c=a.maxInput;a.eventsToUnbind&&(a.eventsToUnbind.forEach(function(a){return a()}),a.eventsToUnbind=void 0);e(a.buttons);d&&(d.onfocus=d.onblur=d.onchange=null);c&&(c.onfocus=c.onblur=c.onchange=null);I(a,function(d,c){d&&"chart"!==c&&(d instanceof k?d.destroy():
d instanceof window.HTMLElement&&b(d));d!==t.prototype[c]&&(a[c]=null)},this)};return t}();c(q.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",
time:"%H:%M:%S"}});"";return q});A(a,"Accessibility/Components/RangeSelectorComponent.js",[a["Stock/RangeSelector/RangeSelector.js"],a["Accessibility/AccessibilityComponent.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/Announcer.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Core/Utilities.js"]],function(a,q,m,p,k,l){var x=this&&this.__extends||function(){var a=function(e,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,
b){for(var d in b)Object.prototype.hasOwnProperty.call(b,d)&&(a[d]=b[d])};return a(e,b)};return function(e,b){function c(){this.constructor=e}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");a(e,b);e.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),y=m.unhideChartElementFromAT,h=m.getAxisRangeDescription,g=l.addEvent,w=l.attr;q=function(a){function e(){var b=null!==a&&a.apply(this,arguments)||this;b.announcer=
void 0;return b}x(e,a);e.prototype.init=function(){this.announcer=new p(this.chart,"polite")};e.prototype.onChartUpdate=function(){var a=this.chart,c=this,d=a.rangeSelector;d&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),d.buttons&&d.buttons.length&&d.buttons.forEach(function(a){c.setRangeButtonAttrs(a)}),d.maxInput&&d.minInput&&["minInput","maxInput"].forEach(function(b,e){if(b=d[b])y(a,b),c.setRangeInputAttrs(b,"accessibility.rangeSelector."+(e?"max":"min")+"InputLabel")}))};e.prototype.updateSelectorVisibility=
function(){var a=this.chart,c=a.rangeSelector,d=c&&c.dropdown,e=c&&c.buttons||[];c&&c.hasVisibleDropdown&&d?(y(a,d),e.forEach(function(a){return a.element.setAttribute("aria-hidden",!0)})):(d&&d.setAttribute("aria-hidden",!0),e.forEach(function(b){return y(a,b.element)}))};e.prototype.setDropdownAttrs=function(){var a=this.chart,c=a.rangeSelector&&a.rangeSelector.dropdown;c&&(a=a.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:a.options.lang.rangeSelectorZoom}),c.setAttribute("aria-label",
a),c.setAttribute("tabindex",-1))};e.prototype.setRangeButtonAttrs=function(a){w(a.element,{tabindex:-1,role:"button"})};e.prototype.setRangeInputAttrs=function(a,c){var b=this.chart;w(a,{tabindex:-1,"aria-label":b.langFormat(c,{chart:b})})};e.prototype.onButtonNavKbdArrowKey=function(a,c){var b=a.response,e=this.keyCodes,f=this.chart,g=f.options.accessibility.keyboardNavigation.wrapAround;c=c===e.left||c===e.up?-1:1;return f.highlightRangeSelectorButton(f.highlightedRangeSelectorItemIx+c)?b.success:
g?(a.init(c),b.success):b[0<c?"next":"prev"]};e.prototype.onButtonNavKbdClick=function(a){a=a.response;var b=this.chart;3!==b.oldRangeSelectorItemState&&this.fakeClickEvent(b.rangeSelector.buttons[b.highlightedRangeSelectorItemIx].element);return a.success};e.prototype.onAfterBtnClick=function(){var a=this.chart,c=h(a.xAxis[0]);(a=a.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:a,axisRangeDescription:c}))&&this.announcer.announce(a)};e.prototype.onInputKbdMove=function(a){var b=
this.chart,d=b.rangeSelector,e=b.highlightedInputRangeIx=(b.highlightedInputRangeIx||0)+a;if(1<e||0>e){if(b.accessibility)return b.accessibility.keyboardNavigation.exiting=!0,b.accessibility.keyboardNavigation.tabindexContainer.focus(),b.accessibility.keyboardNavigation.move(a)}else d&&(a=d[e?"maxDateBox":"minDateBox"],d=d[e?"maxInput":"minInput"],a&&d&&b.setFocusToElement(a,d));return!0};e.prototype.onInputNavInit=function(a){var b=this,d=this,e=this.chart,f=0<a?0:1,h=e.rangeSelector,k=h&&h[f?"maxDateBox":
"minDateBox"];a=h&&h.minInput;h=h&&h.maxInput;e.highlightedInputRangeIx=f;if(k&&a&&h){e.setFocusToElement(k,f?h:a);this.removeInputKeydownHandler&&this.removeInputKeydownHandler();e=function(a){(a.which||a.keyCode)===b.keyCodes.tab&&d.onInputKbdMove(a.shiftKey?-1:1)&&(a.preventDefault(),a.stopPropagation())};var l=g(a,"keydown",e),m=g(h,"keydown",e);this.removeInputKeydownHandler=function(){l();m()}}};e.prototype.onInputNavTerminate=function(){var a=this.chart.rangeSelector||{};a.maxInput&&a.hideInput("max");
a.minInput&&a.hideInput("min");this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)};e.prototype.initDropdownNav=function(){var a=this,c=this.chart,d=c.rangeSelector,e=d&&d.dropdown;d&&e&&(c.setFocusToElement(d.buttonGroup,e),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=g(e,"keydown",function(b){var d=c.accessibility;(b.which||b.keyCode)===a.keyCodes.tab&&(b.preventDefault(),b.stopPropagation(),
d&&(d.keyboardNavigation.tabindexContainer.focus(),d.keyboardNavigation.move(b.shiftKey?-1:1)))}))};e.prototype.getRangeSelectorButtonNavigation=function(){var a=this.chart,c=this.keyCodes,d=this;return new k(a,{keyCodeMap:[[[c.left,c.right,c.up,c.down],function(a){return d.onButtonNavKbdArrowKey(this,a)}],[[c.enter,c.space],function(){return d.onButtonNavKbdClick(this)}]],validate:function(){return!!(a.rangeSelector&&a.rangeSelector.buttons&&a.rangeSelector.buttons.length)},init:function(b){var c=
a.rangeSelector;c&&c.hasVisibleDropdown?d.initDropdownNav():c&&(c=c.buttons.length-1,a.highlightRangeSelectorButton(0<b?0:c))},terminate:function(){d.removeDropdownKeydownHandler&&(d.removeDropdownKeydownHandler(),delete d.removeDropdownKeydownHandler)}})};e.prototype.getRangeSelectorInputNavigation=function(){var a=this.chart,c=this;return new k(a,{keyCodeMap:[],validate:function(){return!!(a.rangeSelector&&a.rangeSelector.inputGroup&&"hidden"!==a.rangeSelector.inputGroup.element.style.visibility&&
!1!==a.options.rangeSelector.inputEnabled&&a.rangeSelector.minInput&&a.rangeSelector.maxInput)},init:function(a){c.onInputNavInit(a)},terminate:function(){c.onInputNavTerminate()}})};e.prototype.getKeyboardNavigation=function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]};e.prototype.destroy=function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler();this.removeInputKeydownHandler&&this.removeInputKeydownHandler();this.announcer&&this.announcer.destroy()};
return e}(q);(function(f){function e(a){var b=this.rangeSelector&&this.rangeSelector.buttons||[],d=this.highlightedRangeSelectorItemIx,c=this.rangeSelector&&this.rangeSelector.selected;"undefined"!==typeof d&&b[d]&&d!==c&&b[d].setState(this.oldRangeSelectorItemState||0);this.highlightedRangeSelectorItemIx=a;return b[a]?(this.setFocusToElement(b[a].box,b[a].element),a!==c&&(this.oldRangeSelectorItemState=b[a].state,b[a].setState(1)),!0):!1}function b(){var a=this.chart.accessibility;if(a&&a.components.rangeSelector)return a.components.rangeSelector.onAfterBtnClick()}
var c=[];f.compose=function(d,f){l.pushUnique(c,d)&&(d.prototype.highlightRangeSelectorButton=e);l.pushUnique(c,f)&&g(a,"afterBtnClick",b)}})(q||(q={}));return q});A(a,"Accessibility/Components/SeriesComponent/ForcedMarkers.js",[a["Core/Utilities.js"]],function(a){var q=a.addEvent,m=a.merge,p;(function(k){function l(a){m(!0,a,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function p(a){return a.marker.states&&a.marker.states.normal&&a.marker.states.normal.opacity}function x(){if(this.chart.styledMode){if(this.markerGroup)this.markerGroup[this.a11yMarkersForced?
"addClass":"removeClass"]("highcharts-a11y-markers-hidden");this._hasPointMarkers&&this.points&&this.points.length&&this.points.forEach(function(a){a.graphic&&(a.graphic[a.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),a.graphic[!1===a.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))})}}function h(a){this.resetA11yMarkerOptions=m(a.options.marker||{},this.userOptions.marker||{})}function g(){var a=this.options,e=!1!==(this.options.accessibility&&
this.options.accessibility.enabled);if(e=this.chart.options.accessibility.enabled&&e)e=this.chart.options.accessibility,e=this.points.length<e.series.pointDescriptionEnabledThreshold||!1===e.series.pointDescriptionEnabledThreshold;if(e){if(a.marker&&!1===a.marker.enabled&&(this.a11yMarkersForced=!0,l(this.options)),this._hasPointMarkers&&this.points&&this.points.length)for(a=this.points.length;a--;){e=this.points[a];var b=e.options,c=e.hasForcedA11yMarker;delete e.hasForcedA11yMarker;b.marker&&(c=
c&&0===p(b),b.marker.enabled&&!c?(m(!0,b.marker,{states:{normal:{opacity:p(b)||1}}}),e.hasForcedA11yMarker=!1):!1===b.marker.enabled&&(l(b),e.hasForcedA11yMarker=!0))}}else this.a11yMarkersForced&&(delete this.a11yMarkersForced,(a=this.resetA11yMarkerOptions)&&this.update({marker:{enabled:a.enabled,states:{normal:{opacity:a.states&&a.states.normal&&a.states.normal.opacity}}}}),delete this.resetA11yMarkerOptions)}var w=[];k.compose=function(f){a.pushUnique(w,f)&&(q(f,"afterSetOptions",h),q(f,"render",
g),q(f,"afterRender",x))}})(p||(p={}));return p});A(a,"Accessibility/Components/SeriesComponent/SeriesKeyboardNavigation.js",[a["Core/Series/Point.js"],a["Core/Series/Series.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Accessibility/Utils/EventProvider.js"],a["Accessibility/Utils/ChartUtilities.js"]],function(a,q,m,p,k,l,A,y){function h(a){var b=a.index,d=a.series.points,c=d.length;if(d[b]!==a)for(;c--;){if(d[c]===
a)return c}else return b}function g(a){var b=a.chart.options.accessibility.keyboardNavigation.seriesNavigation,d=a.options.accessibility||{},c=d.keyboardNavigation;return c&&!1===c.enabled||!1===d.enabled||!1===a.options.enableMouseTracking||!a.visible||b.pointNavigationEnabledThreshold&&b.pointNavigationEnabledThreshold<=a.points.length}function w(a){var b=a.series.chart.options.accessibility,d=a.options.accessibility&&!1===a.options.accessibility.enabled;return a.isNull&&b.keyboardNavigation.seriesNavigation.skipNullPoints||
!1===a.visible||!1===a.isInside||d||g(a.series)}function f(a){a=a.series||[];for(var b=a.length,d=0;d<b;++d)if(!g(a[d])){a:{var c=a[d].points||[];for(var e=c.length,f=0;f<e;++f)if(!w(c[f])){c=c[f];break a}c=null}if(c)return c}return null}function e(a){for(var b=a.series.length,d=!1;b--&&!(a.highlightedPoint=a.series[b].points[a.series[b].points.length-1],d=a.series[b].highlightNextValidPoint()););return d}function b(a){delete a.highlightedPoint;return(a=f(a))?a.highlight():!1}var c=m.seriesTypes,
d=p.doc,u=k.defined,x=k.fireEvent,I=y.getPointFromXY,J=y.getSeriesFromName,B=y.scrollToPoint;m=function(){function c(a,b){this.keyCodes=b;this.chart=a}c.prototype.init=function(){var b=this,c=this.chart,e=this.eventProvider=new A;e.addEvent(q,"destroy",function(){return b.onSeriesDestroy(this)});e.addEvent(c,"afterApplyDrilldown",function(){var a=f(this);a&&a.highlight(!1)});e.addEvent(c,"drilldown",function(a){a=a.point;var c=a.series;b.lastDrilledDownPoint={x:a.x,y:a.y,seriesName:c?c.name:""}});
e.addEvent(c,"drillupall",function(){setTimeout(function(){b.onDrillupAll()},10)});e.addEvent(a,"afterSetState",function(){var a=this.graphic&&this.graphic.element,b=d.activeElement,e=b&&b.getAttribute("class");e=e&&-1<e.indexOf("highcharts-a11y-proxy-button");c.highlightedPoint===this&&b!==a&&!e&&a&&a.focus&&a.focus()})};c.prototype.onDrillupAll=function(){var a=this.lastDrilledDownPoint,b=this.chart,c=a&&J(b,a.seriesName),d;a&&c&&u(a.x)&&u(a.y)&&(d=I(c,a.x,a.y));d=d||f(b);b.container&&b.container.focus();
d&&d.highlight&&d.highlight(!1)};c.prototype.getKeyboardNavigationHandler=function(){var a=this,c=this.keyCodes,d=this.chart,g=d.inverted;return new l(d,{keyCodeMap:[[g?[c.up,c.down]:[c.left,c.right],function(b){return a.onKbdSideways(this,b)}],[g?[c.left,c.right]:[c.up,c.down],function(b){return a.onKbdVertical(this,b)}],[[c.enter,c.space],function(a,b){if(a=d.highlightedPoint)b.point=a,x(a.series,"click",b),a.firePointEvent("click");return this.response.success}],[[c.home],function(){b(d);return this.response.success}],
[[c.end],function(){e(d);return this.response.success}],[[c.pageDown,c.pageUp],function(a){d.highlightAdjacentSeries(a===c.pageDown);return this.response.success}]],init:function(){return a.onHandlerInit(this)},validate:function(){return!!f(d)},terminate:function(){return a.onHandlerTerminate()}})};c.prototype.onKbdSideways=function(a,b){var c=this.keyCodes;return this.attemptHighlightAdjacentPoint(a,b===c.right||b===c.down)};c.prototype.onHandlerInit=function(a){var c=this.chart;c.options.accessibility.keyboardNavigation.seriesNavigation.rememberPointFocus&&
c.highlightedPoint?c.highlightedPoint.highlight():b(c);return a.response.success};c.prototype.onKbdVertical=function(a,b){var c=this.chart,d=this.keyCodes;b=b===d.down||b===d.right;d=c.options.accessibility.keyboardNavigation.seriesNavigation;if(d.mode&&"serialize"===d.mode)return this.attemptHighlightAdjacentPoint(a,b);c[c.highlightedPoint&&c.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries"](b);return a.response.success};c.prototype.onHandlerTerminate=
function(){var a=this.chart,b=a.options.accessibility.keyboardNavigation;a.tooltip&&a.tooltip.hide(0);var c=a.highlightedPoint&&a.highlightedPoint.series;if(c&&c.onMouseOut)c.onMouseOut();if(a.highlightedPoint&&a.highlightedPoint.onMouseOut)a.highlightedPoint.onMouseOut();b.seriesNavigation.rememberPointFocus||delete a.highlightedPoint};c.prototype.attemptHighlightAdjacentPoint=function(a,c){var d=this.chart,f=d.options.accessibility.keyboardNavigation.wrapAround;return d.highlightAdjacentPoint(c)?
a.response.success:f&&(c?b(d):e(d))?a.response.success:a.response[c?"next":"prev"]};c.prototype.onSeriesDestroy=function(a){var b=this.chart;b.highlightedPoint&&b.highlightedPoint.series===a&&(delete b.highlightedPoint,b.focusElement&&b.focusElement.removeFocusBorder())};c.prototype.destroy=function(){this.eventProvider.removeAddedEvents()};return c}();(function(a){function b(a){var b=this.series,c=this.highlightedPoint,d=c&&h(c)||0,e=c&&c.series.points||[],f=this.series&&this.series[this.series.length-
1];f=f&&f.points&&f.points[f.points.length-1];if(!b[0]||!b[0].points)return!1;if(c){if(b=b[c.series.index+(a?1:-1)],d=e[d+(a?1:-1)],!d&&b&&(d=b.points[a?0:b.points.length-1]),!d)return!1}else d=a?b[0].points[0]:f;return w(d)?(b=d.series,g(b)?this.highlightedPoint=a?b.points[b.points.length-1]:b.points[0]:this.highlightedPoint=d,this.highlightAdjacentPoint(a)):d.highlight()}function d(a){var b=this.highlightedPoint,c=Infinity,d;if(!u(b.plotX)||!u(b.plotY))return!1;this.series.forEach(function(e){g(e)||
e.points.forEach(function(f){if(u(f.plotY)&&u(f.plotX)&&f!==b){var g=f.plotY-b.plotY,h=Math.abs(f.plotX-b.plotX);h=Math.abs(g)*Math.abs(g)+h*h*4;e.yAxis&&e.yAxis.reversed&&(g*=-1);!(0>=g&&a||0<=g&&!a||5>h||w(f))&&h<c&&(c=h,d=f)}})});return d?d.highlight():!1}function e(a){var b=this.highlightedPoint,c=this.series&&this.series[this.series.length-1],d=c&&c.points&&c.points[c.points.length-1];if(!this.highlightedPoint)return c=a?this.series&&this.series[0]:c,(d=a?c&&c.points&&c.points[0]:d)?d.highlight():
!1;c=this.series[b.series.index+(a?-1:1)];if(!c)return!1;d=f(b,c,4);if(!d)return!1;if(g(c))return d.highlight(),a=this.highlightAdjacentSeries(a),a?a:(b.highlight(),!1);d.highlight();return d.series.highlightNextValidPoint()}function f(a,b,c,d){var e=Infinity,f=b.points.length,g=function(a){return!(u(a.plotX)&&u(a.plotY))};if(!g(a)){for(;f--;){var h=b.points[f];if(!g(h)&&(h=(a.plotX-h.plotX)*(a.plotX-h.plotX)*(c||1)+(a.plotY-h.plotY)*(a.plotY-h.plotY)*(d||1),h<e)){e=h;var k=f}}return u(k)?b.points[k]:
void 0}}function l(a){void 0===a&&(a=!0);var b=this.series.chart;if(!this.isNull&&a)this.onMouseOver();else b.tooltip&&b.tooltip.hide(0);B(this);this.graphic&&(b.setFocusToElement(this.graphic),!a&&b.focusElement&&b.focusElement.removeFocusBorder());b.highlightedPoint=this;return this}function m(){var a=this.chart.highlightedPoint,b=(a&&a.series)===this?h(a):0;a=this.points;var c=a.length;if(a&&c){for(var d=b;d<c;++d)if(!w(a[d]))return a[d].highlight();for(;0<=b;--b)if(!w(a[b]))return a[b].highlight()}return!1}
var p=[];a.compose=function(a,f,g){k.pushUnique(p,a)&&(a=a.prototype,a.highlightAdjacentPoint=b,a.highlightAdjacentPointVertical=d,a.highlightAdjacentSeries=e);k.pushUnique(p,f)&&(f.prototype.highlight=l);k.pushUnique(p,g)&&(f=g.prototype,f.keyboardMoveVertical=!0,["column","gantt","pie"].forEach(function(a){c[a]&&(c[a].prototype.keyboardMoveVertical=!1)}),f.highlightNextValidPoint=m)}})(m||(m={}));return m});A(a,"Accessibility/Components/SeriesComponent/SeriesComponent.js",[a["Accessibility/AccessibilityComponent.js"],
a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Components/SeriesComponent/ForcedMarkers.js"],a["Accessibility/Components/SeriesComponent/NewDataAnnouncer.js"],a["Accessibility/Components/SeriesComponent/SeriesDescriber.js"],a["Accessibility/Components/SeriesComponent/SeriesKeyboardNavigation.js"]],function(a,q,m,p,k,l){var x=this&&this.__extends||function(){var a=function(g,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,
c)&&(a[c]=b[c])};return a(g,f)};return function(g,f){function e(){this.constructor=g}if("function"!==typeof f&&null!==f)throw new TypeError("Class extends value "+String(f)+" is not a constructor or null");a(g,f);g.prototype=null===f?Object.create(f):(e.prototype=f.prototype,new e)}}(),y=q.hideSeriesFromAT,h=k.describeSeries;return function(a){function g(){return null!==a&&a.apply(this,arguments)||this}x(g,a);g.compose=function(a,e,b){p.compose(b);m.compose(b);l.compose(a,e,b)};g.prototype.init=function(){this.newDataAnnouncer=
new p(this.chart);this.newDataAnnouncer.init();this.keyboardNavigation=new l(this.chart,this.keyCodes);this.keyboardNavigation.init();this.hideTooltipFromATWhenShown();this.hideSeriesLabelsFromATWhenShown()};g.prototype.hideTooltipFromATWhenShown=function(){var a=this;this.chart.tooltip&&this.addEvent(this.chart.tooltip.constructor,"refresh",function(){this.chart===a.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})};g.prototype.hideSeriesLabelsFromATWhenShown=
function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(a){a.labelBySeries&&a.labelBySeries.attr("aria-hidden",!0)})})};g.prototype.onChartRender=function(){this.chart.series.forEach(function(a){!1!==(a.options.accessibility&&a.options.accessibility.enabled)&&a.visible?h(a):y(a)})};g.prototype.getKeyboardNavigation=function(){return this.keyboardNavigation.getKeyboardNavigationHandler()};g.prototype.destroy=function(){this.newDataAnnouncer.destroy();this.keyboardNavigation.destroy()};
return g}(a)});A(a,"Accessibility/Components/ZoomComponent.js",[a["Accessibility/AccessibilityComponent.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Core/Utilities.js"]],function(a,q,m,p,k){var l=this&&this.__extends||function(){var a=function(f,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&
(a[b]=c[b])};return a(f,e)};return function(f,e){function b(){this.constructor=f}if("function"!==typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");a(f,e);f.prototype=null===e?Object.create(e):(b.prototype=e.prototype,new b)}}(),x=q.unhideChartElementFromAT,y=m.getFakeMouseEvent,h=k.attr,g=k.pick;return function(a){function f(){var e=null!==a&&a.apply(this,arguments)||this;e.focusedMapNavButtonIx=-1;return e}l(f,a);f.prototype.init=function(){var a=
this,b=this.chart;this.proxyProvider.addGroup("zoom","div");["afterShowResetZoom","afterApplyDrilldown","drillupall"].forEach(function(c){a.addEvent(b,c,function(){a.updateProxyOverlays()})})};f.prototype.onChartUpdate=function(){var a=this.chart,b=this;a.mapNavigation&&a.mapNavigation.navButtons.forEach(function(c,d){x(a,c.element);b.setMapNavButtonAttrs(c.element,"accessibility.zoom.mapZoom"+(d?"Out":"In"))})};f.prototype.setMapNavButtonAttrs=function(a,b){var c=this.chart;b=c.langFormat(b,{chart:c});
h(a,{tabindex:-1,role:"button","aria-label":b})};f.prototype.onChartRender=function(){this.updateProxyOverlays()};f.prototype.updateProxyOverlays=function(){var a=this.chart;this.proxyProvider.clearGroup("zoom");a.resetZoomButton&&this.createZoomProxyButton(a.resetZoomButton,"resetZoomProxyButton",a.langFormat("accessibility.zoom.resetZoomButton",{chart:a}));a.drillUpButton&&a.breadcrumbs&&a.breadcrumbs.list&&this.createZoomProxyButton(a.drillUpButton,"drillUpProxyButton",a.langFormat("accessibility.drillUpButton",
{chart:a,buttonText:a.breadcrumbs.getButtonText(a.breadcrumbs.list[a.breadcrumbs.list.length-1])}))};f.prototype.createZoomProxyButton=function(a,b,c){this[b]=this.proxyProvider.addProxyElement("zoom",{click:a},{"aria-label":c,tabindex:-1})};f.prototype.getMapZoomNavigation=function(){var a=this.keyCodes,b=this.chart,c=this;return new p(b,{keyCodeMap:[[[a.up,a.down,a.left,a.right],function(a){return c.onMapKbdArrow(this,a)}],[[a.tab],function(a,b){return c.onMapKbdTab(this,b)}],[[a.space,a.enter],
function(){return c.onMapKbdClick(this)}]],validate:function(){return!!(b.mapView&&b.mapNavigation&&b.mapNavigation.navButtons.length)},init:function(a){return c.onMapNavInit(a)}})};f.prototype.onMapKbdArrow=function(a,b){var c=this.chart,d=this.keyCodes,e=c.container,f=b===d.up||b===d.down;b=(f?c.plotHeight:c.plotWidth)/10*(b===d.left||b===d.up?1:-1);d=10*Math.random();c={x:e.offsetLeft+c.plotLeft+c.plotWidth/2+d,y:e.offsetTop+c.plotTop+c.plotHeight/2+d};f=f?{x:c.x,y:c.y+b}:{x:c.x+b,y:c.y};[y("mousedown",
c),y("mousemove",f),y("mouseup",f)].forEach(function(a){return e.dispatchEvent(a)});return a.response.success};f.prototype.onMapKbdTab=function(a,b){var c=this.chart;a=a.response;var d=(b=b.shiftKey)&&!this.focusedMapNavButtonIx||!b&&this.focusedMapNavButtonIx;c.mapNavigation.navButtons[this.focusedMapNavButtonIx].setState(0);if(d)return c.mapView&&c.mapView.zoomBy(),a[b?"prev":"next"];this.focusedMapNavButtonIx+=b?-1:1;b=c.mapNavigation.navButtons[this.focusedMapNavButtonIx];c.setFocusToElement(b.box,
b.element);b.setState(2);return a.success};f.prototype.onMapKbdClick=function(a){this.fakeClickEvent(this.chart.mapNavigation.navButtons[this.focusedMapNavButtonIx].element);return a.response.success};f.prototype.onMapNavInit=function(a){var b=this.chart,c=b.mapNavigation.navButtons[0],d=b.mapNavigation.navButtons[1];c=0<a?c:d;b.setFocusToElement(c.box,c.element);c.setState(2);this.focusedMapNavButtonIx=0<a?0:1};f.prototype.simpleButtonNavigation=function(a,b,c){var d=this.keyCodes,e=this,f=this.chart;
return new p(f,{keyCodeMap:[[[d.tab,d.up,d.down,d.left,d.right],function(a,b){return this.response[a===d.tab&&b.shiftKey||a===d.left||a===d.up?"prev":"next"]}],[[d.space,d.enter],function(){var a=c(this,f);return g(a,this.response.success)}]],validate:function(){return f[a]&&f[a].box&&e[b].buttonElement},init:function(){f.setFocusToElement(f[a].box,e[b].buttonElement)}})};f.prototype.getKeyboardNavigation=function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(a,
b){b.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(a,b){b.drillUp();return a.response.prev}),this.getMapZoomNavigation()]};return f}(a)});A(a,"Accessibility/HighContrastMode.js",[a["Core/Globals.js"]],function(a){var q=a.doc,m=a.isMS,p=a.win;return{isHighContrastModeActive:function(){var a=/(Edg)/.test(p.navigator.userAgent);if(p.matchMedia&&a)return p.matchMedia("(-ms-high-contrast: active)").matches;if(m&&p.getComputedStyle){a=q.createElement("div");a.style.backgroundImage=
"url(".concat("data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",")");q.body.appendChild(a);var l=(a.currentStyle||p.getComputedStyle(a)).backgroundImage;q.body.removeChild(a);return"none"===l}return p.matchMedia&&p.matchMedia("(forced-colors: active)").matches},setHighContrastTheme:function(a){a.highContrastModeActive=!0;var l=a.options.accessibility.highContrastTheme;a.update(l,!1);a.series.forEach(function(a){var k=l.plotOptions[a.type]||{};a.update({color:k.color||"windowText",
colors:[k.color||"windowText"],borderColor:k.borderColor||"window"});a.points.forEach(function(a){a.options&&a.options.color&&a.update({color:k.color||"windowText",borderColor:k.borderColor||"window"},!1)})});a.redraw()}}});A(a,"Accessibility/HighContrastTheme.js",[],function(){return{chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",
labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",
edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},
title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",
inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",
trackBorderColor:"windowText"}}});A(a,"Accessibility/Options/A11yDefaults.js",[],function(){return{accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},
series:{descriptionFormat:"{seriesDescription}{authorDescription}{axisDescription}",describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{xDescription}{separator}{value}.",describeNull:!0},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:"#334eff",lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector",
"legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1,rememberPointFocus:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5E3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}}});A(a,"Accessibility/Options/LangDefaults.js",[],function(){return{accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",
drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{ Also related to, #each(additionalAnnotationPoints)}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},
sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",
tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",
arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",
funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",
defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",
barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",
bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",
timeRangeDays:"Data range: {range} days.",timeRangeHours:"Data range: {range} hours.",timeRangeMinutes:"Data range: {range} minutes.",timeRangeSeconds:"Data range: {range} seconds.",rangeFromTo:"Data ranges from {rangeFrom} to {rangeTo}.",rangeCategories:"Data range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu, {chartTitle}"},series:{summary:{"default":"{series.name}, series {seriesNumber} of {chart.series.length} with {series.points.length} data {#plural(series.points.length, points, point)}.",
defaultCombination:"{series.name}, series {seriesNumber} of {chart.series.length} with {series.points.length} data {#plural(series.points.length, points, point)}.",line:"{series.name}, line {seriesNumber} of {chart.series.length} with {series.points.length} data {#plural(series.points.length, points, point)}.",lineCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Line with {series.points.length} data {#plural(series.points.length, points, point)}.",spline:"{series.name}, line {seriesNumber} of {chart.series.length} with {series.points.length} data {#plural(series.points.length, points, point)}.",
splineCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Line with {series.points.length} data {#plural(series.points.length, points, point)}.",column:"{series.name}, bar series {seriesNumber} of {chart.series.length} with {series.points.length} {#plural(series.points.length, bars, bar)}.",columnCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Bar series with {series.points.length} {#plural(series.points.length, bars, bar)}.",bar:"{series.name}, bar series {seriesNumber} of {chart.series.length} with {series.points.length} {#plural(series.points.length, bars, bar)}.",
barCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Bar series with {series.points.length} {#plural(series.points.length, bars, bar)}.",pie:"{series.name}, pie {seriesNumber} of {chart.series.length} with {series.points.length} {#plural(series.points.length, slices, slice)}.",pieCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Pie with {series.points.length} {#plural(series.points.length, slices, slice)}.",scatter:"{series.name}, scatter plot {seriesNumber} of {chart.series.length} with {series.points.length} {#plural(series.points.length, points, point)}.",
scatterCombination:"{series.name}, series {seriesNumber} of {chart.series.length}, scatter plot with {series.points.length} {#plural(series.points.length, points, point)}.",boxplot:"{series.name}, boxplot {seriesNumber} of {chart.series.length} with {series.points.length} {#plural(series.points.length, boxes, box)}.",boxplotCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Boxplot with {series.points.length} {#plural(series.points.length, boxes, box)}.",bubble:"{series.name}, bubble series {seriesNumber} of {chart.series.length} with {series.points.length} {#plural(series.points.length, bubbles, bubble)}.",
bubbleCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Bubble series with {series.points.length} {#plural(series.points.length, bubbles, bubble)}.",map:"{series.name}, map {seriesNumber} of {chart.series.length} with {series.points.length} {#plural(series.points.length, areas, area)}.",mapCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Map with {series.points.length} {#plural(series.points.length, areas, area)}.",mapline:"{series.name}, line {seriesNumber} of {chart.series.length} with {series.points.length} data {#plural(series.points.length, points, point)}.",
maplineCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Line with {series.points.length} data {#plural(series.points.length, points, point)}.",mapbubble:"{series.name}, bubble series {seriesNumber} of {chart.series.length} with {series.points.length} {#plural(series.points.length, bubbles, bubble)}.",mapbubbleCombination:"{series.name}, series {seriesNumber} of {chart.series.length}. Bubble series with {series.points.length} {#plural(series.points.length, bubbles, bubble)}."},
description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{Annotation: #each(annotations). }"}}}});A(a,"Accessibility/Options/DeprecatedOptions.js",[a["Core/Utilities.js"]],function(a){function q(a,g,k){for(var f,e=0;e<g.length-1;++e)f=g[e],a=a[f]=y(a[f],{});a[g[g.length-1]]=k}function m(a,g,k,f){function e(a,b){return b.reduce(function(a,b){return a[b]},a)}var b=e(a.options,g),c=e(a.options,k);Object.keys(f).forEach(function(d){var e,
h=b[d];"undefined"!==typeof h&&(q(c,f[d],h),x(32,!1,a,(e={},e[g.join(".")+"."+d]=k.join(".")+"."+f[d].join("."),e)))})}function p(a){var g=a.options.chart,h=a.options.accessibility||{};["description","typeDescription"].forEach(function(f){var e;g[f]&&(h[f]=g[f],x(32,!1,a,(e={},e["chart.".concat(f)]="use accessibility.".concat(f),e)))})}function k(a){a.axes.forEach(function(g){(g=g.options)&&g.description&&(g.accessibility=g.accessibility||{},g.accessibility.description=g.description,x(32,!1,a,{"axis.description":"use axis.accessibility.description"}))})}
function l(a){var g={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","point","descriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"],"accessibility.pointDescriptionFormatter":["accessibility","point","descriptionFormatter"]};a.series.forEach(function(h){Object.keys(g).forEach(function(f){var e,b=h.options[f];"accessibility.pointDescriptionFormatter"===f&&(b=h.options.accessibility&&
h.options.accessibility.pointDescriptionFormatter);"undefined"!==typeof b&&(q(h.options,g[f],"skipKeyboardNavigation"===f?!b:b),x(32,!1,a,(e={},e["series.".concat(f)]="series."+g[f].join("."),e)))})})}var x=a.error,y=a.pick;return function(a){p(a);k(a);a.series&&l(a);m(a,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],
pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection",
"axisRangeDateFormat"]});m(a,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]});m(a,["lang","accessibility"],["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector",
"buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table","viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}});A(a,"Accessibility/Accessibility.js",[a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Accessibility/A11yI18n.js"],a["Accessibility/Components/ContainerComponent.js"],
a["Accessibility/FocusBorder.js"],a["Accessibility/Components/InfoRegionsComponent.js"],a["Accessibility/KeyboardNavigation.js"],a["Accessibility/Components/LegendComponent.js"],a["Accessibility/Components/MenuComponent.js"],a["Accessibility/Components/SeriesComponent/NewDataAnnouncer.js"],a["Accessibility/ProxyProvider.js"],a["Accessibility/Components/RangeSelectorComponent.js"],a["Accessibility/Components/SeriesComponent/SeriesComponent.js"],a["Accessibility/Components/ZoomComponent.js"],a["Accessibility/HighContrastMode.js"],
a["Accessibility/HighContrastTheme.js"],a["Accessibility/Options/A11yDefaults.js"],a["Accessibility/Options/LangDefaults.js"],a["Accessibility/Options/DeprecatedOptions.js"]],function(a,q,m,p,k,l,A,y,h,g,w,f,e,b,c,d,u,D,I,L,B){a=a.defaultOptions;var x=q.doc,F=m.addEvent,t=m.extend,n=m.fireEvent,r=m.merge,C=p.removeElement;q=function(){function a(a){this.proxyProvider=this.keyboardNavigation=this.components=this.chart=void 0;this.init(a)}a.prototype.init=function(a){this.chart=a;x.addEventListener?
(B(a),this.proxyProvider=new e(this.chart),this.initComponents(),this.keyboardNavigation=new h(a,this.components)):(this.zombie=!0,this.components={},a.renderTo.setAttribute("aria-hidden",!0))};a.prototype.initComponents=function(){var a=this.chart,e=this.proxyProvider,f=a.options.accessibility;this.components={container:new l,infoRegions:new y,legend:new g,chartMenu:new w,rangeSelector:new b,series:new c,zoom:new d};f.customComponents&&t(this.components,f.customComponents);var h=this.components;
this.getComponentOrder().forEach(function(b){h[b].initBase(a,e);h[b].init()})};a.prototype.getComponentOrder=function(){if(!this.components)return[];if(!this.components.series)return Object.keys(this.components);var a=Object.keys(this.components).filter(function(a){return"series"!==a});return["series"].concat(a)};a.prototype.update=function(){var a=this.components,b=this.chart,c=b.options.accessibility;n(b,"beforeA11yUpdate");b.types=this.getChartTypes();c=c.keyboardNavigation.order;this.proxyProvider.updateGroupOrder(c);
this.getComponentOrder().forEach(function(c){a[c].onChartUpdate();n(b,"afterA11yComponentUpdate",{name:c,component:a[c]})});this.keyboardNavigation.update(c);!b.highContrastModeActive&&u.isHighContrastModeActive()&&u.setHighContrastTheme(b);n(b,"afterA11yUpdate",{accessibility:this})};a.prototype.destroy=function(){var a=this.chart||{},b=this.components;Object.keys(b).forEach(function(a){b[a].destroy();b[a].destroyBase()});this.proxyProvider&&this.proxyProvider.destroy();a.announcerContainer&&C(a.announcerContainer);
this.keyboardNavigation&&this.keyboardNavigation.destroy();a.renderTo&&a.renderTo.setAttribute("aria-hidden",!0);a.focusElement&&a.focusElement.removeFocusBorder()};a.prototype.getChartTypes=function(){var a={};this.chart.series.forEach(function(b){a[b.type]=1});return Object.keys(a)};return a}();(function(a){function d(){this.accessibility&&this.accessibility.destroy()}function e(){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var a=this.accessibility;a&&!a.zombie&&
(a.proxyProvider.updateProxyElementPositions(),a.getComponentOrder().forEach(function(b){a.components[b].onChartRender()}))}function l(a){if(a=a.options.accessibility)a.customComponents&&(this.options.accessibility.customComponents=a.customComponents,delete a.customComponents),r(!0,this.options.accessibility,a),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility);this.a11yDirty=!0}function n(){var b=this.accessibility,c=this.options.accessibility;
c&&c.enabled?b&&!b.zombie?b.update():(this.accessibility=b=new a(this),!b.zombie)&&b.update():b?(b.destroy&&b.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)}function p(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)}var q=[];a.i18nFormat=k.i18nFormat;a.compose=function(a,r,u,t,v,x){h.compose(a);f.compose(t);g.compose(a,r);w.compose(a);c.compose(a,u,t);k.compose(a);A.compose(a,v);x&&b.compose(a,x);m.pushUnique(q,a)&&(a.prototype.updateA11yEnabled=
n,F(a,"destroy",d),F(a,"render",e),F(a,"update",l),["addSeries","init"].forEach(function(b){F(a,b,function(){this.a11yDirty=!0})}),["afterApplyDrilldown","drillupall"].forEach(function(b){F(a,b,function(){var a=this.accessibility;a&&!a.zombie&&a.update()})}));m.pushUnique(q,u)&&F(u,"update",p);m.pushUnique(q,t)&&["update","updatedData","remove"].forEach(function(a){F(t,a,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})})}})(q||(q={}));r(!0,a,I,{accessibility:{highContrastTheme:D},
lang:L});return q});A(a,"masters/modules/accessibility.src.js",[a["Core/Globals.js"],a["Accessibility/Accessibility.js"],a["Accessibility/AccessibilityComponent.js"],a["Accessibility/Utils/ChartUtilities.js"],a["Accessibility/Utils/HTMLUtilities.js"],a["Accessibility/KeyboardNavigationHandler.js"],a["Accessibility/Components/SeriesComponent/SeriesDescriber.js"]],function(a,q,m,p,k,l,A){a.i18nFormat=q.i18nFormat;a.A11yChartUtilities=p;a.A11yHTMLUtilities=k;a.AccessibilityComponent=m;a.KeyboardNavigationHandler=
l;a.SeriesAccessibilityDescriber=A;q.compose(a.Chart,a.Legend,a.Point,a.Series,a.SVGElement,a.RangeSelector)})});
//# sourceMappingURL=accessibility.js.map