/*
 Highstock JS v11.0.0 (2023-04-26)

 Indicator series type for Highcharts Stock

 (c) 2010-2021 Pawe Fus

 License: www.highcharts.com/license
*/
'use strict';(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/indicators/pivot-points",["highcharts","highcharts/modules/stock"],function(k){b(k);b.Highcharts=k;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function k(b,h,c,f){b.hasOwnProperty(h)||(b[h]=f.apply(null,c),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:h,
module:b[h]}})))}b=b?b._modules:{};k(b,"Stock/Indicators/PivotPoints/PivotPointsPoint.js",[b["Core/Series/SeriesRegistry.js"]],function(b){function h(f,d){var e=f.series.pointArrayMap,c=e.length;for(b.seriesTypes.sma.prototype.pointClass.prototype[d].call(f);c--;)d="dataLabel"+e[c],f[d]&&f[d].element&&f[d].destroy(),f[d]=null}var c=this&&this.__extends||function(){var b=function(d,e){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,d){b.__proto__=d}||function(b,d){for(var e in d)Object.prototype.hasOwnProperty.call(d,
e)&&(b[e]=d[e])};return b(d,e)};return function(d,e){function c(){this.constructor=d}if("function"!==typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");b(d,e);d.prototype=null===e?Object.create(e):(c.prototype=e.prototype,new c)}}();return function(b){function d(){var d=null!==b&&b.apply(this,arguments)||this;d.P=void 0;d.pivotLine=void 0;d.series=void 0;return d}c(d,b);d.prototype.destroyElements=function(){h(this,"destroyElements")};d.prototype.destroy=
function(){h(this,"destroyElements")};return d}(b.seriesTypes.sma.prototype.pointClass)});k(b,"Stock/Indicators/PivotPoints/PivotPointsIndicator.js",[b["Stock/Indicators/PivotPoints/PivotPointsPoint.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,h,c){var f=this&&this.__extends||function(){var b=function(d,a){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var g in b)Object.prototype.hasOwnProperty.call(b,g)&&(a[g]=
b[g])};return b(d,a)};return function(d,a){function g(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");b(d,a);d.prototype=null===a?Object.create(a):(g.prototype=a.prototype,new g)}}(),d=h.seriesTypes.sma,e=c.merge,k=c.extend,p=c.defined,t=c.isArray;c=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.endPoint=void 0;a.plotEndPoint=void 0;
return a}f(c,b);c.prototype.toYData=function(a){return[a.P]};c.prototype.translate=function(){var a=this;b.prototype.translate.apply(a);a.points.forEach(function(b){a.pointArrayMap.forEach(function(g){p(b[g])&&(b["plot"+g]=a.yAxis.toPixels(b[g],!0))})});a.plotEndPoint=a.xAxis.toPixels(a.endPoint,!0)};c.prototype.getGraphPath=function(a){for(var g=this,d=[[],[],[],[],[],[],[],[],[]],c=g.pointArrayMap.length,e=g.plotEndPoint,h=[],q,l,f=a.length,m;f--;){l=a[f];for(m=0;m<c;m++)q=g.pointArrayMap[m],p(l[q])&&
d[m].push({plotX:l.plotX,plotY:l["plot"+q],isNull:!1},{plotX:e,plotY:l["plot"+q],isNull:!1},{plotX:e,plotY:null,isNull:!0});e=l.plotX}d.forEach(function(a){h=h.concat(b.prototype.getGraphPath.call(g,a))});return h};c.prototype.drawDataLabels=function(){var a=this,g=a.pointArrayMap,d,c,e;if(a.options.dataLabels.enabled){var h=a.points.length;g.concat([!1]).forEach(function(f,l){for(e=h;e--;)c=a.points[e],f?(c.y=c[f],c.pivotLine=f,c.plotY=c["plot"+f],d=c["dataLabel"+f],l&&(c["dataLabel"+g[l-1]]=c.dataLabel),
c.dataLabels||(c.dataLabels=[]),c.dataLabels[0]=c.dataLabel=d=d&&d.element?d:null):c["dataLabel"+g[l-1]]=c.dataLabel;b.prototype.drawDataLabels.call(a)})}};c.prototype.getValues=function(a,b){var c=b.period,d=a.xData,g=(a=a.yData)?a.length:0;b=this[b.algorithm+"Placement"];var e=[],f=[],h=[],k;if(!(d.length<c)&&t(a[0])&&4===a[0].length){for(k=c+1;k<=g+c;k+=c){var m=d.slice(k-c-1,k);var n=a.slice(k-c-1,k);var p=m.length;var r=m[p-1];n=this.getPivotAndHLC(n);n=b(n);n=e.push([r].concat(n));f.push(r);
h.push(e[n-1].slice(1))}this.endPoint=m[0]+(r-m[0])/p*c;return{values:e,xData:f,yData:h}}};c.prototype.getPivotAndHLC=function(a){var b=a[a.length-1][3],c=-Infinity,d=Infinity;a.forEach(function(a){c=Math.max(c,a[1]);d=Math.min(d,a[2])});return[(c+d+b)/3,c,d,b]};c.prototype.standardPlacement=function(a){var b=a[1]-a[2];return[null,null,a[0]+b,2*a[0]-a[2],a[0],2*a[0]-a[1],a[0]-b,null,null]};c.prototype.camarillaPlacement=function(a){var b=a[1]-a[2];return[a[3]+1.5*b,a[3]+1.25*b,a[3]+1.1666*b,a[3]+
1.0833*b,a[0],a[3]-1.0833*b,a[3]-1.1666*b,a[3]-1.25*b,a[3]-1.5*b]};c.prototype.fibonacciPlacement=function(a){var b=a[1]-a[2];return[null,a[0]+b,a[0]+.618*b,a[0]+.382*b,a[0],a[0]-.382*b,a[0]-.618*b,a[0]-b,null]};c.defaultOptions=e(d.defaultOptions,{params:{index:void 0,period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}});return c}(d);k(c.prototype,{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),
pointValKey:"P",pointClass:b});h.registerSeriesType("pivotpoints",c);"";return c});k(b,"masters/indicators/pivot-points.src.js",[],function(){})});
//# sourceMappingURL=pivot-points.js.map