
<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/OA/Dll.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
require_once MAX_PATH . '/lib/OA/Maintenance/Priority.php';


$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}


$clientid = $_REQUEST['clientid'];
$campaignid = $_REQUEST['campaignid'];
$value = $_REQUEST['value'];
$campaignname = $_REQUEST['campaignname'];

 if($value == 0 ){
    $status = 0;
 }elseif($value == 1){
    $status = 4;
 }


 if (OA_Permission::isAccount(OA_ACCOUNT_ADVERTISER)) {
    if ($value == OA_ENTITY_STATUS_RUNNING) {
        OA_Permission::enforceAllowed(OA_PERM_BANNER_ACTIVATE);
    } else {
        OA_Permission::enforceAllowed(OA_PERM_BANNER_DEACTIVATE);
    }
}


/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/

if ($value == OA_ENTITY_STATUS_RUNNING) {
    $messageKey = 'strCampaignHasBeenActivated';
} else {
    $messageKey = 'strCampaignHasBeenDeactivated';
}

$doCampaigns = OA_Dal::factoryDO('campaigns');
$doCampaigns->get($campaignid);
$campaignName = $doCampaigns->campaignname; 

$translation = new OX_Translation();
$message = $GLOBALS[$messageKey];

// Modify the message to include campaign name
$translated_message = $translation->translate($message, [
    MAX::constructURL(MAX_URL_ADMIN, "campaign-edit.php?clientid=$clientid&campaignid=$campaignid"),
    htmlspecialchars($campaignName)
]);
OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

$sql=OA_Dal_Delivery_query("UPDATE ".$table_prefix."campaigns SET status = ".$status." WHERE campaignid = '".$campaignid."'");	

header("Location: advertiser-campaigns.php?clientid=" . $clientid . "&campaignid=" . $campaignid);