<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    OpenXPlugin
 * @subpackage InvocationTags
 *
 */

require_once LIB_PATH . '/Extension/invocationTags/InvocationTags.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

/**
 *
 * Invocation tag plugin.
 *
 */
class Plugins_InvocationTags_OxInvocationTags_inbannervideoads extends Plugins_InvocationTags
{
    /**
     * Return name of plugin
     *
     * @return string
     */
    public function getName()
    {
        return $this->translate("Inbanner Video Ads");
    }

    /**
     * Return the English name of the plugin. Used when
     * generating translation keys based on the plugin
     * name.
     *
     * @return string An English string describing the class.
     */
    public function getNameEN()
    {
        return 'Inbanner Video Ads';
    }

    /**
     * Check if plugin is allowed
     *
     * @return boolean  True - allowed, false - not allowed
     */
    public function isAllowed($extra = null)
    {
        $isAllowed = parent::isAllowed($extra);
        return true;
    }

    public function getOrder()
    {
        parent::getOrder();
        return 59;
    }

    /**
     * Return list of options
     *
     * @return array    Group of options
     */
    public function getOptionsList()
    {
        if (is_array($this->defaultOptions)) {
            if (in_array('cacheBuster', $this->defaultOptions)) {
                unset($this->defaultOptions['cacheBuster']);
            }
        }
        $options =  array (
            'zone_size'  => 1,
           
        
    
    );

        return $options;
    }

    
    
    function zone_size()
        {
         
             $maxInvocation = &$this->maxInvocation;
             $zone_size = (!empty($maxInvocation->zone_size)) ? $maxInvocation->zone_size :$_POST['zone_size'];;
            
     
             $option = '';       
             $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
     
             $option .= "<tr><td width='30'>&nbsp;</td>";
             $option .= "<td width='200'>Background Image Size</td><td width='100'>";
             $option .= "<select name='zone_size' id='zone_size'>";
             $option .= "<option value='' disabled>Choose size</option>
             <option value='1' ".($zone_size=='1'?"selected='selected'":''). " style='width:250px;' >300x250</option>
             <option value='2' ".($zone_size=='2'?"selected='selected'":''). " style='width:250px;' >160x600</option>
             <option value='3' ".($zone_size=='3'?"selected='selected'":''). " style='width:250px;'>728x90</option></td></tr>";
             $option .= "</select>";
             $option .= "<tr><td width='30'><img src='" . OX::assetPath(). "/images/spacer.gif' height='5' width='100%'></td></tr>";
     
             return $option;
        }



    /**
     * Return invocation code for this plugin (codetype)
     *
     * @return string
     */
    public function generateInvocationCode()
    {
        $aComments = [
            'Comment' => $this->translate("
  * This noscript section of this tag only shows image banners. There
  * is no width or height in these banners, so if you want these tags to
  * allocate space for the ad before it shows, you will need to add this
  * information to the <img> tag.
  *
  * If you do not want to deal with the intricities of the noscript
  * section, delete the tag (from <noscript>... to </noscript>). On
  * average, the noscript tag is called from less than 1% of internet
  * users."),
            ];
        parent::prepareCommonInvocationData($aComments);

        $conf = $GLOBALS['_MAX']['CONF'];
        $mi = &$this->maxInvocation;
		$zoneid=$mi->zoneid;
		if (isset($_POST['zone_size'])&& $_POST['zone_size'] != 0) {
			$zone_size = $_POST['zone_size'];
            
		}else{
            $zone_size = "1";
        }

        if (isset($mi->width) && $mi->width != '') {
        $mi->parameters['width'] = "width=".$mi->width;
        }
        
        $buffer = $mi->buffer;

        if (isset($mi->withtext) && $mi->withtext != '0') {
            $mi->parameters['withtext'] = "withtext=1";
        }
        if (isset($mi->block) && $mi->block == '1') {
            $mi->parameters['block'] = "block=1";
        }
        if (isset($mi->blockcampaign) && $mi->blockcampaign == '1') {
            $mi->parameters['blockcampaign'] = "blockcampaign=1";
        }
        if (!empty($mi->campaignid)) {
            $mi->parameters['campaignid'] = "campaignid=" . $mi->campaignid;
        }
        // The cachebuster for JS tags is auto-generated
        unset($mi->parameters['cb']);

        $way=$conf['webpath']['admin'].'/plugins/InbannerVideoAds/delivery/inbannervideoads.php';
	    $buffer  = "<script type='text/javascript'><!--//<![CDATA[
        var adurl = (location.protocol=='https:'?'https://$way':'http://$way');
        document.write (\"<\" + \"script language='JavaScript' \");
        document.write (\"type='text/javascript' src='\"+adurl);
        document.write (\"?zoneid={$zoneid}\");
        document.write (\"&amp;zone_size={$zone_size}";
	    $buffer .="\");\n";
	    $buffer .= "   document.write (\"&amp;loc=\" + escape(window.location));\n";
        $buffer .= "   if (document.referrer) document.write (\"&amp;referer=\" + escape(document.referrer));\n";
        $buffer .= "   document.write (\"&amp;display_width=\" + window.innerWidth);\n";
        $buffer .= "   document.write (\"'><\\/scr\"+\"ipt>\");\n";
        $buffer .= "//]]>--></script>"; 
        return $buffer;
    }

    public function setInvocation(&$invocation)
    {
        $this->maxInvocation = &$invocation;
        $this->maxInvocation->canDetectCharset = true;
    }
}
