<?php

/*
+---------------------------------------------------------------------------+
| OpenX v${RELEASE_MAJOR_MINOR}                                                                |
| =======${RELEASE_MAJOR_MINOR_DOUBLE_UNDERLINE}                                                                |
|                                                                           |
| Copyright (c) 2003-2009 OpenX Limited                                     |
| For contact details, see: http://www.openx.org/                           |
|                                                                           |
| This program is free software; you can redistribute it and/or modify      |
| it under the terms of the GNU General Public License as published by      |
| the Free Software Foundation; either version 2 of the License, or         |
| (at your option) any later version.                                       |
|                                                                           |
| This program is distributed in the hope that it will be useful,           |
| but WITHOUT ANY WARRANTY; without even the implied warranty of            |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
| GNU General Public License for more details.                              |
|                                                                           |
| You should have received a copy of the GNU General Public License         |
| along with this program; if not, write to the Free Software               |
| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA |
+---------------------------------------------------------------------------+
$Id: logClickCountry.delivery.php 32394 2009-02-13 15:30:45Z david.keen $
*/

/**
 * @package    Plugin
 * @subpackage openxDeliveryLogCountry
 */
 
require_once 'handset.php'; 
function Plugin_deliveryLog_oxLogDevicetype_logClickDevicetype_Delivery_logClick()
{
	
    $aData = $GLOBALS['_MAX']['deliveryData'];
	  
        $data = $GLOBALS['_MAX']['device'];
     $custom_data = $GLOBALS['_MAX']['custom_data'] = OX_bucket_customData();
  
    $aQuery = array(
        'interval_start' => $aData['interval_start'],
        'interval_start' => $aData['interval_start'],
        'creative_id'    => $aData['creative_id'],
        'zone_id'        => $aData['zone_id'],
        'os'       		 => $custom_data['os'],
		'device_type'    => $custom_data['device'],
		'brand'        	 => $data['devicebrand'],
		'model'        	 => $data['devicemodel']
        
    );
    return OX_bucket_updateTable('Data_bkt_Devicetype_c', $aQuery);
}
if(!function_exists('OX_bucket_customData'))
{
	
	function OX_bucket_customData()
	{
	
	$data = $GLOBALS['_MAX']['deliveryData'];
    $ip = $data['ip_address'];

    $ipdat = @json_decode(file_get_contents( 
        "http://www.geoplugin.net/json.gp?ip=" . $ip));
        
        
        
        $clientinfo = $GLOBALS['_MAX']['CLIENT'];
    $browser = $clientinfo['wrapper']->getBrowserName();
    $os = $clientinfo['wrapper']->getOsName();
    $os_version = $clientinfo['wrapper']->getOsVersion();

    $useragent=$clientinfo['ua'];

    ## DEVICE DETECTION
        
    $tablet_browser = 0;
    $mobile_browser = 0;
     
    if (preg_match('/(tablet|ipad|playbook)|(android(?!.*(mobi|opera mini)))/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
        $tablet_browser++;
    }
     
    if (preg_match('/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|android|iemobile)/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
        $mobile_browser++;
    }
     
    if ((strpos(strtolower($_SERVER['HTTP_ACCEPT']),'application/vnd.wap.xhtml+xml') > 0) or ((isset($_SERVER['HTTP_X_WAP_PROFILE']) or isset($_SERVER['HTTP_PROFILE'])))) {
        $mobile_browser++;
    }
     
    $mobile_ua = strtolower(substr($_SERVER['HTTP_USER_AGENT'], 0, 4));
    $mobile_agents = array(
        'w3c ','acs-','alav','alca','amoi','audi','avan','benq','bird','blac',
        'blaz','brew','cell','cldc','cmd-','dang','doco','eric','hipt','inno',
        'ipaq','java','jigs','kddi','keji','leno','lg-c','lg-d','lg-g','lge-',
        'maui','maxo','midp','mits','mmef','mobi','mot-','moto','mwbp','nec-',
        'newt','noki','palm','pana','pant','phil','play','port','prox',
        'qwap','sage','sams','sany','sch-','sec-','send','seri','sgh-','shar',
        'sie-','siem','smal','smar','sony','sph-','symb','t-mo','teli','tim-',
        'tosh','tsm-','upg1','upsi','vk-v','voda','wap-','wapa','wapi','wapp',
        'wapr','webc','winw','winw','xda ','xda-');
     
    if (in_array($mobile_ua,$mobile_agents)) {
        $mobile_browser++;
    }
     
    if (strpos(strtolower($_SERVER['HTTP_USER_AGENT']),'opera mini') > 0) {
        $mobile_browser++;

        //Check for tablets on opera mini alternative headers
        $stock_ua = strtolower(isset($_SERVER['HTTP_X_OPERAMINI_PHONE_UA'])?$_SERVER['HTTP_X_OPERAMINI_PHONE_UA']:(isset($_SERVER['HTTP_DEVICE_STOCK_UA'])?$_SERVER['HTTP_DEVICE_STOCK_UA']:''));
        if (preg_match('/(tablet|ipad|playbook)|(android(?!.*mobile))/i', $stock_ua)) {
          $tablet_browser++;
        }
    }

    $device = '';
    $device_version = '';
     
    if ($tablet_browser > 0) {
       $device = 'Tablet';
    }
    else if ($mobile_browser > 0) {
       $device = 'Mobile';
    }
    else {
       $device = 'Desktop';
    }   

    ## LANGUAGE DETECTION
    $language = '';
     
    if (empty($_REQUEST['language'])) {
        $language = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
    } else {
        $language = $_REQUEST['language'];
    }

    $language = preg_replace('/;q=[0-9\.]+$/', '', $language);
    $host = $_SERVER['REMOTE_HOST'];
    if(!empty($_REQUEST['loc']))
    {
        $domain = parse_url($_GET['loc']);
        $full_domain = $domain['host']; 

    }
    else
    {
        $full_domain = $_SERVER['REMOTE_HOST'];    
    } 
    
    
    return array( 
        'os'      	 	 => $os,
        'device'      	  => $device);
        
	
	}
}
?>
