<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

require_once LIB_PATH . '/Extension/deliveryLimitations/DeliveryLimitationsCommaSeparatedData.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

use Sinergi\BrowserDetector\Os;

/**
 * A Client delivery limitation plugin, for filtering delivery of ads on the
 * basis of the viewer's operating system.
 *
 * Works with:
 * A comma separated string of operating system codes. See the Os.res.inc.php
 * resource file for details of the valid operating system codes.
 *
 * Valid comparison operators:
 * =~, !~
 *
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 */
class Plugins_DeliveryLimitations_Client_Profiletarget extends Plugins_DeliveryLimitations_CommaSeparatedData
{
     public function __construct()
    {
        parent::__construct();
        $this->nameEnglish = 'Client - Profile-Target';

        $aStringOp = MAX_limitationsGetAOperationsForString($this);

        $this->aOperations = array(
           '==' => $GLOBALS['strEqualTo'],
           '!=' => $GLOBALS['strDifferentFrom'],
           );

       $this->nameEnglish = 'Client - Profile Targeting';
    }

   public function init($data)
    {
        parent::init($data);
        
    }

    /**
     * Outputs the HTML to display the data for this limitation
     *
     * @return void
     */
    function displayArrayData()
    {
        $tabindex =& $GLOBALS['tabindex'];

echo "<table width='275' cellpadding='0' cellspacing='0' border='0'>";
		echo "<tr id='acl-".$this->executionorder."'>";
	    echo "    <th align='center'>".$this->translate('Age')."</th>";
		echo "    <td align='center'><input type='text'  name='acl[{$this->executionorder}][data][]' value='" . ((!empty($this->data[0])) ? htmlspecialchars($this->data[0], ENT_QUOTES) : '') . "' tabindex='".($tabindex++)."'></td></br>";
		echo "</tr>";
		echo "<tr id='acl-".$this->executionorder."'>";
	    echo "    <th align='center'>".$this->translate('Phone')."</th>";
		echo "    <td align='center'><input type='text'  name='acl[{$this->executionorder}][data][]' value='" . ((!empty($this->data[1])) ? htmlspecialchars($this->data[1], ENT_QUOTES) : '') . "' tabindex='".($tabindex++)."'></td></br>";
		echo "</tr>";
		?>
		<tr>
        <td align="left" width="50"><strong><?php echo $this->translate("Gender");?>:</strong></td>
        <td><select name="acl[<?php echo $this->executionorder;
        ?>][data][]" value="<?php echo((!empty($this->data[2])) ? htmlspecialchars($this->data[2]) : '');
        ?>" tabindex="<?php echo $tabindex;
        ?>"> <?php foreach ($this->res as $key => $value) {
            echo "<option value='{$value}'".($value == $this->data[2] ? ' selected="selected"' : '').">{$value}</option>";
        }
        ?></select></td><?php
        	
		echo "</table>";
    }
		
    
		function _flattenData($data = null)
    {
        //print_r($data); 
        $result = parent::_flattenData($data);
        
        if (is_array($result)) {

            return implode($this->delimiter, $result);
        }
        return $result;
    }
 
        
}
?>
