<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

require_once LIB_PATH . '/Extension/deliveryLimitations/DeliveryLimitationsCommaSeparatedData.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/lib/max/Delivery/limitations.delivery.php';

/**
 * A Client delivery limitation plugin, for filtering delivery of ads on the
 * basis of the viewer's domain URL.
 *
 * Works with a string which is matched with the viewer's domain URL.
 * The mechanism of the matching depends on the operator being used.
 *
 * Valid comparison operators:
 * ==, !=, =~, !~, =x, ~x
 *
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 */
class Plugins_DeliveryLimitations_Client_Mobilescreenwidth extends Plugins_DeliveryLimitations_CommaSeparatedData
{
    function __construct()
    {
         // parent::__construct();
              parent::__construct();
		
        $this->aOperations = [
            '==' => 'is equal to',
            '!=' => 'is not equal to',
            'lt' => 'is less than',
            'gt' => 'is greater than',
            'le' => 'is less or equal to',
            'ge' => 'is greater or equal to'
        ] ;
        $this->nameEnglish = 'Client - Mobile Screen Width';
    }
        function init($data)
    {
		
		//$cmp = $data['comparison'];
		//print_r($cmp);
        parent::init($data);
       
        
         //print_r($data);
    }



    function displayArrayData()
    {
		//global $cmp;
		//print_r($cmp);
        $tabindex =& $GLOBALS['tabindex'];
		echo "<table width='275' cellpadding='0' cellspacing='0' border='0'>";
		
		echo "<tr id='aclsingle-".$this->executionorder."'>";
		echo "    <td align='center'><input type='number' size='10' name='acl[{$this->executionorder}][data][]' value='" . ((!empty($this->data[0])) ? htmlspecialchars($this->data[0], ENT_QUOTES) : '') . "' tabindex='".($tabindex++)."'></td>";
		
		echo "</tr>";
	
		
		echo "</table>";
		
		?>
		    
		<?php
    }
  
		function _flattenData($data = null)
    {
        //print_r($data); 
        $result = parent::_flattenData($data);
        
        if (is_array($result)) {

            return implode($this->delimiter, $result);
        }
        return $result;
    }


    
}

?>
