<?php

namespace RV\Upgrade;

use RV\Upgrade\Exception\DeliveryRuleDeletedException;

class GeoIp2Migration
{
    const RULE_TYPES = [
        'deliveryLimitations:Geo:Areacode',
        'deliveryLimitations:Geo:Region',
        'deliveryLimitations:Geo:Dma',
        'deliveryLimitations:Geo:Netspeed',
    ];

    const FIPS_TO_SUB1 = [
        'AD' => ['02' => '02', '03' => '03', '04' => '04', '05' => '05', 6 => '06', '07' => '07', '08' => '08'],
        'AE' => [1 => 'AZ', '03' => 'DU', 3 => 'DU', '04' => 'FU', '07' => 'UQ'],
        'AF' => ['01' => 'BDS', '03' => 'BGL', '05' => 'BAM', '07' => 'FYB', '08' => 'GHA', '09' => 'GHO', 10 => 'HEL', 13 => 'KAB', 17 => 'LOG', 18 => 'NAN', 19 => 'NIM', 22 => 'PAR', 24 => 'KDZ', 26 => 'TAK', 27 => 'WAR', 28 => 'ZAB', 29 => 'PKA', 30 => 'BAL', 32 => 'SAM', 33 => 'SAR'],
        'AG' => ['01' => '10', '03' => '03', 3 => '03', '04' => '04', 4 => '04', '05' => '05', 5 => '05', '06' => '06', 6 => '06', '07' => '07', 7 => '07', '08' => '08', 8 => '08'],
        'AL' => ['01' => '01', '04' => '03', '05' => '04'],
        'AM' => ['02' => 'AR', '03' => 'AV', 4 => 'GR', '05' => 'KT', 5 => 'KT', 6 => 'LO', '08' => 'SU', 8 => 'SU', 10 => 'VD'],
        'AO' => ['01' => 'BGU', 2 => 'BIE', '03' => 'CAB', 4 => 'CCU', 5 => 'CNO', 6 => 'CUS', '07' => 'CNN', 7 => 'CNN', '08' => 'HUA', 9 => 'HUI', 12 => 'MAL', 14 => 'MOX', 15 => 'UIG', 16 => 'ZAI', 17 => 'LUA', 18 => 'LSU', 19 => 'BGO', 20 => 'LNO'],
        'AR' => ['01' => 'B', '02' => 'K', '03' => 'H', '04' => 'U', '06' => 'W', 7 => 'C', '09' => 'P', 10 => 'Y', 11 => 'L', 12 => 'F', 13 => 'M', 14 => 'N', 17 => 'A', 18 => 'J', 19 => 'D', 20 => 'Z', 21 => 'S', 22 => 'G', 23 => 'V'],
        'AT' => ['01' => '1', 2 => '2', 3 => '3', 4 => '4', '05' => '5', '06' => '6', 6 => '6', '07' => '7', 7 => '7', '08' => '8', '09' => '9', 9 => '9'],
        'AU' => ['01' => 'ACT', '02' => 'NSW', '03' => 'NT', '04' => 'QLD', '05' => 'SA', '06' => 'TAS', '07' => 'VIC', '08' => 'WA'],
        'AZ' => ['01' => 'ABS', '03' => 'AGM', '04' => 'AGS', '05' => 'AGA', '06' => 'AGU', '07' => 'SR', '08' => 'AST', '09' => 'BA', 10 => 'BAL', 11 => 'BAR', 12 => 'BEY', 13 => 'BIL', 15 => 'CAL', 18 => 'FUZ', 20 => 'GA', 21 => 'GOR', 22 => 'GOY', 23 => 'HAC', 24 => 'IMI', 25 => 'ISM', 26 => 'KAL', 27 => 'KUR', 30 => 'LAN', 31 => 'LER', 32 => 'MAS', 33 => 'MI', 34 => 'NA', 35 => 'NX', 36 => 'NEF', 37 => 'OGU', 38 => 'QAB', 39 => 'QAX', 40 => 'QAZ', 41 => 'QOB', 42 => 'QBA', 44 => 'QUS', 45 => 'SAT', 46 => 'SAB', 47 => 'SAK', 48 => 'SAK', 49 => 'SAL', 51 => 'SKR', 52 => 'SMX', 53 => 'SIY', 54 => 'SM', 57 => 'TAR', 58 => 'TOV', 59 => 'UCA', 60 => 'XAC', 61 => 'XA', 62 => 'GYG', 63 => 'XIZ', 67 => 'YE', 68 => 'YEV', 70 => 'ZAQ'],
        'BA' => [1 => 'BIH', '02' => 'SRP'],
        'BB' => ['01' => '01', '02' => '02', '03' => '03', '04' => '04', '05' => '05', '06' => '06', '07' => '07', '08' => '08', '09' => '09', 9 => '09', 10 => '10', 11 => '11'],
        'BD' => ['01' => 'A', 12 => 'H', 32 => 'C', 46 => 'D', 70 => 'E', 71 => 'F', 77 => 'G'],
        'BG' => [33 => '12', 38 => '01', 39 => '02', 40 => '08', 41 => '07', 42 => '23', 43 => '26', 44 => '09', 45 => '10', 46 => '11', 47 => '12', 48 => '13', 49 => '14', 50 => '15', 51 => '16', 52 => '17', 53 => '18', 54 => '27', 55 => '19', 56 => '20', 57 => '21', 58 => '22', 59 => '24', 60 => '25', 61 => '03', 62 => '04', 63 => '05', 64 => '06', 65 => '28'],
        'BI' => [2 => 'BM', 9 => 'BB', '09' => 'BB', 10 => 'BR', 11 => 'CA', 12 => 'CI', 13 => 'GI', 14 => 'KR', 15 => 'KY', 16 => 'KI', 17 => 'MA', 18 => 'MY', 19 => 'NG', 20 => 'RT', 21 => 'RY', 22 => 'MU', 23 => 'MW'],
        'BJ' => ['02' => 'AQ', 2 => 'AQ', '03' => 'BO', 3 => 'BO', '04' => 'MO', 5 => 'OU', '06' => 'ZO'],
        'BN' => ['01' => 'BE', '03' => 'TE', '04' => 'TU'],
        'BO' => [1 => 'H', '01' => 'H', '02' => 'C', 2 => 'C', '03' => 'B', '04' => 'L', 4 => 'L', '05' => 'O', '06' => 'N', 6 => 'N', 7 => 'P', '08' => 'S', 8 => 'S', '09' => 'T', 9 => 'T'],
        'BR' => ['01' => 'AC', '02' => 'AL', '04' => 'AM', '05' => 'BA', '07' => 'DF', 7 => 'DF', 11 => 'MS', 14 => 'MT', 15 => 'MG', 17 => 'PB', 21 => 'RJ', 22 => 'RN', 23 => 'RS', 25 => 'RR', 26 => 'SC', 28 => 'SE', 30 => 'PE', 31 => 'TO'],
        'BS' => ['05' => 'BI', '06' => 'CI', 10 => 'EX', 13 => 'IN', 15 => 'LI', 16 => 'MG', 18 => 'RI', 22 => 'HI', 23 => 'NP', 24 => 'AK', 25 => 'FP', 26 => 'CS', 27 => 'CE', 28 => 'NO', 29 => 'EG', 30 => 'SA', 31 => 'CO', 32 => 'BY', 33 => 'SE', 34 => 'SO', 35 => 'SS'],
        'BT' => ['05' => '33', 5 => '33', '06' => '12', 6 => '12', 7 => '21', 8 => '22', 10 => '13', 13 => '11', 14 => '43', 15 => '23', 16 => '14', 17 => '45', 18 => '31', 19 => '41', 20 => '15', 21 => '32', 22 => '24'],
        'BW' => ['01' => 'CE', 1 => 'CE', '02' => 'CH', '03' => 'GH', 3 => 'GH', '04' => 'KG', 4 => 'KG', '05' => 'KL', 5 => 'KL', '06' => 'KW', 6 => 'KW', 9 => 'SE', 10 => 'SO'],
        'BZ' => [1 => 'BZ', '01' => 'BZ', '02' => 'CY', 2 => 'CY', '03' => 'CZL', 3 => 'CZL', '04' => 'OW', 4 => 'OW', '05' => 'SC', 5 => 'SC', '06' => 'TOL', 6 => 'TOL'],
        'CA' => ['01' => 'AB', '02' => 'BC', '03' => 'MB', '04' => 'NB', '05' => 'NL', '07' => 'NS', '08' => 'ON', '09' => 'PE', 10 => 'QC', 11 => 'SK', 13 => 'NT', 14 => 'NU'],
        'CF' => ['01' => 'BB', '02' => 'BK', '03' => 'HK', 4 => 'HS', '05' => 'HM', 6 => 'KG', '07' => 'LB', '08' => 'MB', 9 => 'NM', 11 => 'UK', 12 => 'AC', 13 => 'OP', 14 => 'VK', 15 => 'KB', 16 => 'SE', 17 => 'MP', 18 => 'BGF'],
        'CG' => ['01' => '11', '03' => '8', '04' => '5', 5 => '2', '06' => '7', '07' => '9', '08' => '14', 10 => '13', 11 => '12', 12 => 'BZV'],
        'CH' => ['01' => 'AG', 2 => 'AR', '03' => 'BL', '04' => 'BS', 4 => 'BS', '05' => 'BE', 7 => 'GE', '08' => 'GL', 9 => 'GR', 10 => 'AI', 11 => 'LU', 12 => 'NE', 13 => 'NW', 14 => 'OW', 15 => 'SG', 16 => 'SH', 17 => 'SZ', 18 => 'SO', 19 => 'TG', 21 => 'UR', 24 => 'ZG'],
        'CI' => [5 => '01', 6 => '01', 16 => 'GD', 17 => '03', 20 => '04', 39 => 'SM', 51 => 'SM', 52 => 'SM', 61 => 'AB', 62 => 'CM', 63 => 'CM', 64 => '01', 68 => 'CM', 70 => '01', 73 => 'YM'],
        'CL' => [1 => 'VS', 2 => 'AI', '03' => 'AN', 4 => 'AR', '05' => 'AT', 6 => 'BI', '07' => 'CO', 7 => 'CO', '08' => 'LI', 8 => 'LI', '09' => 'LL', 9 => 'LL', 10 => 'MA', 11 => 'ML', 12 => 'RM', 13 => 'TA'],
        'CM' => [4 => 'ES', '05' => 'LT', 7 => 'NW', 8 => 'OU', 9 => 'SW', 10 => 'AD', 11 => 'CE', 12 => 'EN', 13 => 'NO', 14 => 'SU'],
        'CO' => ['01' => 'AMA', '02' => 'ANT', '03' => 'ARA', 3 => 'ARA', 4 => 'ATL', 8 => 'CAQ', 9 => 'CAU', '09' => 'CAU', 10 => 'CES', 11 => 'CHO', 12 => 'COR', 14 => 'GUV', 15 => 'GUA', 16 => 'HUI', 17 => 'LAG', 19 => 'MET', 20 => 'NAR', 21 => 'NSA', 22 => 'PUT', 23 => 'QUI', 24 => 'RIS', 26 => 'SAN', 27 => 'SUC', 28 => 'TOL', 29 => 'VAC', 30 => 'VAU', 31 => 'VID', 32 => 'CAS', 33 => 'CUN', 34 => 'DC', 35 => 'BOL', 36 => 'BOY', 37 => 'CAL', 38 => 'MAG'],
        'CR' => ['01' => 'A', 1 => 'A', '02' => 'C', 2 => 'C', '03' => 'G', 3 => 'G', '04' => 'H', 4 => 'H', 6 => 'L', '07' => 'P', 7 => 'P', 8 => 'SJ'],
        'CU' => [1 => '01', 2 => '03', '03' => '04', 3 => '04', 4 => '99', '04' => '99', 5 => '09', 7 => '08', 8 => '06', '08' => '06', 9 => '12', '09' => '12', 10 => '14', 11 => '03', 12 => '11', 13 => '10', 14 => '07', 15 => '13', 16 => '05'],
        'DE' => [1 => 'BW', '02' => 'BY', 2 => 'BY', '03' => 'HB', '04' => 'HH', '05' => 'HE', 5 => 'HE', '06' => 'NI', 6 => 'NI', '07' => 'NW', 7 => 'NW', '08' => 'RP', '09' => 'SL', 10 => 'SH', 11 => 'BB', 12 => 'MV', 13 => 'SN', 14 => 'ST', 15 => 'TH', 16 => 'BE'],
        'DK' => [1 => '82', 2 => '84', 3 => '84', 4 => '83', 5 => '84', 6 => '84', '07' => '81', 7 => '81', 8 => '83', 9 => '82', 10 => '85', 11 => '83', 12 => '85', 13 => '82', 14 => '85', 15 => '82'],
        'DM' => ['02' => '02', '03' => '03', '04' => '04', '05' => '05', '06' => '06', '07' => '07', '08' => '08', '09' => '09', 10 => '10', 11 => '11'],
        'DZ' => ['01' => '16', 1 => '16', '03' => '05', '04' => '25', '07' => '27', '09' => '31', 12 => '19', 13 => '14', 14 => '15', 15 => '13', 18 => '06', 19 => '07', 20 => '09', 21 => '10', 22 => '17', 23 => '24', 24 => '18', 25 => '03', 26 => '29', 27 => '28', 29 => '04', 30 => '22', 31 => '21', 33 => '12', 34 => '01', 35 => '44', 36 => '46', 37 => '23', 38 => '08', 39 => '34', 41 => '02', 42 => '32', 43 => '39', 44 => '36', 46 => '33', 47 => '40', 48 => '43', 49 => '45', 50 => '30', 51 => '48', 52 => '41', 53 => '11', 54 => '37', 55 => '42', 56 => '38'],
        'EC' => [1 => 'W', '02' => 'A', 2 => 'A', 3 => 'B', 4 => 'F', '05' => 'C', 5 => 'C', '06' => 'H', 6 => 'H', 7 => 'X', '07' => 'X', '08' => 'O', 8 => 'O', 9 => 'E', '09' => 'E', 10 => 'G', 11 => 'I', 12 => 'L', 13 => 'R', 14 => 'M', 15 => 'S', 17 => 'Y', 18 => 'P', 19 => 'T', 20 => 'Z', 22 => 'U', 23 => 'N', 24 => 'D'],
        'EE' => ['01' => '37', '02' => '39', '03' => '44', 4 => '51', 5 => '49', 7 => '57', 8 => '59', 11 => '67', 12 => '65', 13 => '70', 14 => '74', 18 => '78', 19 => '82', 20 => '84', 21 => '86'],
        'EG' => [1 => 'DK', 2 => 'BA', 3 => 'BH', 4 => 'FYM', 5 => 'GH', 6 => 'ALX', 7 => 'IS', 8 => 'GZ', 9 => 'MNF', 10 => 'MN', 11 => 'C', 12 => 'KB', 13 => 'WAD', 14 => 'SHR', 15 => 'SUZ', 18 => 'BNS', 19 => 'PTS', 20 => 'DT', 21 => 'KFS', 23 => 'KN', 24 => 'SHG', 26 => 'JS', 27 => 'SIN'],
        'ES' => [7 => 'IB', 27 => 'RI', 32 => 'NC', 34 => 'AS', 39 => 'CB', 51 => 'AN', 53 => 'CN', 54 => 'CM', 55 => 'CL', 56 => 'CT', 57 => 'EX', 59 => 'PV', 60 => 'VC'],
        'ET' => [10 => 'AA', 11 => 'SN', 12 => 'TI', 13 => 'BE', 14 => 'AF', 44 => 'AA', 45 => 'AF', 46 => 'AM', 47 => 'BE', 49 => 'GA', 50 => 'HA', 52 => 'SO', 53 => 'TI', 54 => 'SN'],
        'FJ' => ['01' => 'C', '02' => 'E', '03' => 'N', '04' => 'R', '05' => 'W'],
        'FM' => ['01' => 'KSA', '02' => 'PNI', '03' => 'TRK', '04' => 'YAP', 4 => 'YAP'],
        'FR' => ['A1' => 'BFC', 'A2' => 'BRE', 'A3' => 'CVL', 'A4' => 'GES', 'A5' => 'COR', 'A6' => 'BFC', 'A8' => 'IDF', 'B1' => 'NAQ', 'B3' => 'OCC', 'B6' => 'HDF', 'B8' => 'PAC', 'B9' => 'ARA', 'C1' => 'GES', 98 => 'ARA', 99 => 'NOR'],
        'GA' => ['01' => '1', '02' => '2', '03' => '3', '04' => '4', '05' => '5', '06' => '6', '07' => '7', '08' => '8', '09' => '9'],
        'GD' => ['01' => '01', '02' => '02', '03' => '03', '04' => '04', '05' => '05', '06' => '06'],
        'GE' => ['02' => 'AB', '04' => 'AJ'],
        'GH' => ['01' => 'AA', '02' => 'AH', '03' => 'BA', '04' => 'CP', '05' => 'EP', '06' => 'NP', '08' => 'TV', '09' => 'WP', 10 => 'UE', 11 => 'UW'],
        'GM' => ['01' => 'B', '02' => 'L', '03' => 'M', '04' => 'U', '05' => 'W', '07' => 'N'],
        'GN' => ['01' => 'N', '03' => 'B', '04' => 'C', '06' => 'M', '07' => 'F', '09' => 'F', 12 => 'B', 16 => 'D', 17 => 'F', 18 => 'B', 23 => 'M', 25 => 'M', 31 => 'D', 32 => 'K', 34 => 'L', 36 => 'N', 38 => 'N', 39 => 'K'],
        'GT' => ['01' => 'AV', '02' => 'BV', '03' => 'CM', '04' => 'CQ', '05' => 'PR', '06' => 'ES', '07' => 'GU', '08' => 'HU', '09' => 'IZ', 10 => 'JA', 11 => 'JU', 12 => 'PE', 13 => 'QZ', 14 => 'QC', 15 => 'RE', 16 => 'SA', 17 => 'SM', 18 => 'SR', 19 => 'SO', 20 => 'SU', 21 => 'TO', 22 => 'ZA'],
        'GW' => ['04' => 'OI', '05' => 'BL', '06' => 'CA', 11 => 'BS'],
        'GY' => [10 => 'BA', 11 => 'CU', 12 => 'DE', 13 => 'EB', 14 => 'ES', 15 => 'MA', 16 => 'PM', 17 => 'PT', 18 => 'UD', 19 => 'UT'],
        'HN' => ['01' => 'AT', '02' => 'CH', '03' => 'CL', '04' => 'CM', '05' => 'CP', '06' => 'CR', '07' => 'EP', '08' => 'FM', '09' => 'GD', 10 => 'IN', 11 => 'IB', 12 => 'LP', 13 => 'LE', 14 => 'OC', 15 => 'OL', 16 => 'SB', 17 => 'VA', 18 => 'YO'],
        'HR' => ['01' => '07', '02' => '12', '03' => '19', '04' => '18', '05' => '04', '06' => '06', '07' => '02', '08' => '09', '09' => '20', 10 => '14', 11 => '11', 12 => '08', 13 => '15', 14 => '03', 15 => '17', 16 => '05', 17 => '10', 18 => '16', 19 => '13', 20 => '01', 21 => '21'],
        'HT' => ['03' => 'NO', '06' => 'AR', '07' => 'CE', '08' => 'GA', '09' => 'ND', 10 => 'NE', 11 => 'OU', 12 => 'SD', 13 => 'SE'],
        'HU' => ['01' => 'BK', '02' => 'BA', '04' => 'BZ', '05' => 'BU', '06' => 'CS', '07' => 'DE', '08' => 'FE', '09' => 'GS', 10 => 'HB', 11 => 'HE', 12 => 'KE', 13 => 'MI', 14 => 'NO', 15 => 'PS', 16 => 'PE', 17 => 'SO', 18 => 'SZ', 19 => 'SD', 20 => 'JN', 21 => 'TO', 22 => 'VA', 23 => 'VE', 24 => 'ZA', 25 => 'GY', 28 => 'EG', 32 => 'NK', 34 => 'SN', 36 => 'SK', 37 => 'SH', 40 => 'ZE'],
        'ID' => ['04' => 'JK', '07' => 'JT', '08' => 'JI', '09' => 'PP', 11 => 'KB', 12 => 'KS', 13 => 'KT', 14 => 'KI', 17 => 'NB', 18 => 'NT', 20 => 'SN', 21 => 'ST', 22 => 'SG', 24 => 'KU', 26 => 'SU', 28 => 'ML', 29 => 'MU', 30 => 'JB', 31 => 'SA', 32 => 'SS', 35 => 'BB'],
        'IN' => ['01' => 'AN', '02' => 'AP', '03' => 'AS', '05' => 'CH', '06' => 'DN', '07' => 'DL', '09' => 'GJ', 10 => 'HR', 11 => 'HP', 12 => 'JK', 13 => 'KL', 14 => 'LD', 16 => 'MH', 17 => 'MN', 18 => 'ML', 19 => 'KA', 20 => 'NL', 21 => 'OR', 22 => 'PY', 23 => 'PB', 24 => 'RJ', 25 => 'TN', 26 => 'TR', 28 => 'WB', 29 => 'SK', 30 => 'AR', 31 => 'MZ', 32 => 'DD', 33 => 'GA', 34 => 'BR', 35 => 'MP', 36 => 'UP', 37 => 'CT', 38 => 'JH', 39 => 'UT'],
        'IR' => ['01' => '01', '02' => '02', '03' => '08', '04' => '13', '05' => '18', '08' => '19', '09' => '24', 10 => '05', 13 => '17', 16 => '16', 23 => '20', 25 => '12', 26 => '07', 28 => '04', 30 => '30', 31 => '25', 35 => '21', 37 => '27', 38 => '32', 39 => '26'],
        'IT' => ['01' => '65', '02' => '77', '03' => '78', '04' => '72', '05' => '45', '06' => '36', '07' => '62', '08' => '42', '09' => '25', 10 => '57', 11 => '67', 12 => '21', 13 => '75', 14 => '88', 15 => '82', 16 => '52', 17 => '32', 18 => '55', 19 => '23', 20 => '34'],
        'JM' => ['01' => '13', '02' => '09', '04' => '12', '07' => '04', '08' => '02', '09' => '06', 10 => '14', 11 => '11', 12 => '08', 13 => '05', 14 => '03', 15 => '07', 16 => '10', 17 => '01'],
        'JO' => ['02' => 'BA', '07' => 'MN', '09' => 'KA', 10 => 'MA', 12 => 'AT', 13 => 'AZ', 14 => 'IR'],
        'JP' => ['02' => '05', '03' => '02', '05' => '38', '08' => '07', 10 => '10', 13 => '28', 14 => '08', 16 => '03', 17 => '37', 19 => '14', 21 => '43', 23 => '24', 24 => '04', 25 => '45', 26 => '20', 27 => '42', 28 => '29', 29 => '15', 31 => '33', 32 => '27', 33 => '41', 34 => '11', 41 => '31', 42 => '16', 43 => '30', 44 => '06', 47 => '47'],
        'KG' => ['09' => 'B'],
        'KI' => ['01' => 'G', '02' => 'L', '03' => 'P'],
        'KZ' => ['01' => 'ALM', '02' => 'ALA', '03' => 'AKM', '04' => 'AKT', '05' => 'AST', '06' => 'ATY', '08' => 'BAY', '09' => 'MAN', 11 => 'PAV', 12 => 'KAR', 13 => 'KUS', 14 => 'KZY', 17 => 'ZHA'],
        'LA' => ['01' => 'AT', '02' => 'CH', '03' => 'HO', '04' => 'KH', '05' => 'LM', '07' => 'OU', 11 => 'VT', 14 => 'XI'],
        'LB' => ['01' => 'BI', '03' => 'AS', '04' => 'BA', '05' => 'JL', '06' => 'JA', '07' => 'NA'],
        'LC' => ['02' => '12', '03' => '02', '04' => '03', '05' => '05', '07' => '07', '08' => '08', 11 => '12'],
        'LI' => ['01' => '01', '02' => '02', '03' => '03', '04' => '04', '05' => '05', '06' => '06', '07' => '07', '08' => '08', '09' => '09', 10 => '10', 11 => '11'],
        'LR' => ['01' => 'BG', '03' => 'GB', '04' => 'CM', '05' => 'LO', '06' => 'MY', '08' => 'MO', '09' => 'NI', 10 => 'SI'],
        'LS' => [10 => 'D', 11 => 'B', 12 => 'C', 13 => 'E', 14 => 'A', 16 => 'J', 18 => 'G', 19 => 'K'],
        'LU' => ['01' => 'DI', '02' => 'GR'],
        'LV' => ['01' => '002', '02' => '007', '03' => '015', '04' => '016', '05' => '022', '06' => 'DGV', '07' => 'DGV', '08' => '026', '09' => '033', 10 => '042', 11 => 'JEL', 12 => 'JEL', 14 => '047', 15 => '050', 16 => 'LPX', 17 => 'LPX', 18 => '055', 19 => '058', 21 => '067', 22 => '073', 23 => 'REZ', 24 => '077', 26 => 'RIX', 27 => '088', 28 => '097', 29 => '099', 30 => '101', 31 => 'VMR', 32 => 'VEN', 33 => 'VEN'],
        'LY' => ['03' => 'JI', '05' => 'JU', '08' => 'KF', 13 => 'WS', 30 => 'MQ', 34 => 'SB', 41 => 'MQ', 42 => 'BU', 45 => 'MI', 47 => 'WA', 50 => 'NQ', 51 => 'NQ', 52 => 'WD', 53 => 'ZA', 54 => 'BA', 55 => 'DR', 56 => 'NL', 57 => 'JG', 58 => 'MI', 60 => 'SR', 61 => 'TB', 62 => 'JI'],
        'MC' => ['01' => 'CO', '03' => 'MC'],
        'MD' => [46 => 'BA', 47 => 'CA', 48 => 'CU', 49 => 'SN', 50 => 'ED', 52 => 'CU', 53 => 'OR', 54 => 'SO', 55 => 'BD', 56 => 'UN'],
        'MK' => ['04' => '03', '06' => '04', '08' => '05', 'A1' => '73', 'A4' => '69', 'A5' => '75', 'A6' => '76', 'A8' => '10', 'A9' => '11', 'B1' => '13', 'B4' => '14', 'C2' => '32', 'C6' => '33', 10 => '06', 11 => '07', 12 => '08', 21 => '21', 24 => '25', 25 => '24', 28 => '27', 33 => '18', 34 => '19', 35 => '20', 36 => '34', 38 => '35', 40 => '37', 42 => '36', 51 => '43', 52 => '44', 57 => '47', 59 => '48', 60 => '49', 62 => '51', 63 => '52', 67 => '53', 69 => '54', 71 => '55', 72 => '56', 74 => '58', 79 => '59', 80 => '61', 82 => '62', 85 => '65', 86 => '66', 87 => '67', 99 => '72'],
        'ML' => ['01' => 'BKO', '02' => '7', '03' => '1', '04' => '5', '05' => '4', '06' => '3', '07' => '2', '08' => '6'],
        'MM' => ['03' => '07', '05' => '13', '07' => '03', '08' => '04', '09' => '02', 10 => '01', 11 => '17', 12 => '05'],
        'MN' => ['01' => '073', '02' => '069', '03' => '071', '06' => '061', '07' => '063', '08' => '059', '09' => '057', 10 => '065', 11 => '039', 12 => '043', 13 => '041', 14 => '053', 15 => '055', 16 => '049', 17 => '051', 18 => '047', 19 => '046', 20 => '1', 21 => '067', 23 => '037', 25 => '035'],
        'MR' => ['01' => '01', '03' => '03', '04' => '04', '05' => '05', '06' => '06', '07' => '07', '08' => '08', '09' => '09', 10 => '10', 11 => '11', 12 => '12'],
        'MU' => [12 => 'BL', 13 => 'FL', 14 => 'GP', 15 => 'MO', 16 => 'PA', 17 => 'PW', 18 => 'PL', 19 => 'RR', 20 => 'SA', 21 => 'AG'],
        'MX' => ['01' => 'AGU', '02' => 'BCN', '03' => 'BCS', '04' => 'CAM', '05' => 'CHP', '06' => 'CHH', '07' => 'COA', '08' => 'COL', '09' => 'MEX', 10 => 'DUR', 11 => 'GUA', 12 => 'GRO', 13 => 'HID', 14 => 'JAL', 15 => 'CMX', 16 => 'MIC', 17 => 'MOR', 18 => 'NAY', 19 => 'NLE', 20 => 'OAX', 21 => 'PUE', 22 => 'QUE', 23 => 'ROO', 24 => 'SLP', 25 => 'SIN', 26 => 'SON', 27 => 'TAB', 28 => 'TAM', 29 => 'TLA', 30 => 'VER', 31 => 'YUC', 32 => 'ZAC'],
        'MY' => ['01' => '01', '02' => '02', '03' => '03', '04' => '04', '05' => '05', '06' => '06', '07' => '08', '08' => '09', '09' => '07', 11 => '13', 12 => '10', 13 => '11', 14 => '16', 16 => '12'],
        'MZ' => ['01' => 'P', '02' => 'G', '03' => 'I', '04' => 'L', '05' => 'S', '06' => 'N', '07' => 'A', '08' => 'T', '09' => 'Q', 10 => 'B'],
        'NE' => ['01' => '1', '02' => '2', '03' => '3', '04' => '4', '05' => '8', '06' => '5', '07' => '7'],
        'NG' => ['05' => 'LA', 11 => 'FC', 16 => 'OG', 21 => 'AK', 22 => 'CR', 23 => 'KD', 24 => 'KT', 25 => 'AN', 26 => 'BE', 27 => 'BO', 28 => 'IM', 29 => 'KN', 30 => 'KW', 31 => 'NI', 32 => 'OY', 35 => 'AD', 36 => 'DE', 37 => 'ED', 39 => 'JI', 40 => 'KE', 41 => 'KO', 42 => 'OS', 43 => 'TA', 44 => 'YO', 45 => 'AB', 46 => 'BA', 47 => 'EN', 48 => 'ON', 49 => 'PL', 50 => 'RI', 51 => 'SO', 52 => 'BY', 53 => 'EB', 54 => 'EK', 55 => 'GO', 56 => 'NA', 57 => 'ZA'],
        'NI' => ['01' => 'BO', '02' => 'CA', '03' => 'CI', '04' => 'CO', '05' => 'ES', '06' => 'GR', '07' => 'JI', '08' => 'LE', '09' => 'MD', 10 => 'MN', 11 => 'MS', 12 => 'MT', 13 => 'NS', 14 => 'SJ', 15 => 'RI'],
        'NL' => ['01' => 'DR', '03' => 'GE', '04' => 'GR', '05' => 'LI', '06' => 'NB', '07' => 'NH', '08' => 'OV', '09' => 'UT', 10 => 'ZE', 11 => 'ZH', 15 => 'OV', 16 => 'FL'],
        'NO' => ['01' => '02', '02' => '09', '04' => '06', '05' => '20', '06' => '04', '07' => '12', '08' => '15', '09' => '18', 10 => '17', 11 => '05', 12 => '03', 13 => '01', 14 => '11', 15 => '14', 16 => '16', 17 => '08', 18 => '19', 19 => '10', 20 => '07'],
        'NR' => ['01' => '01', '02' => '02', '03' => '03', '04' => '04', '06' => '06', '07' => '07', '08' => '08', '09' => '09', 10 => '10', 11 => '11', 12 => '12', 13 => '13', 14 => 'YR'],
        'NZ' => [31 => 'HKB', 50 => 'MBH', 72 => 'STL', 76 => 'TKI'],
        'OM' => ['02' => 'BS', '04' => 'SS', '05' => 'DA', '06' => 'MA', '07' => 'MU', '08' => 'ZU'],
        'PA' => ['01' => '1', '02' => '4', '03' => '2', '04' => '3', '05' => '5', '06' => '6', '07' => '7', '08' => '8', '09' => 'KY', 10 => '9'],
        'PE' => [10 => 'HUC', 12 => 'JUN', 13 => 'LAL', 14 => 'LAM', 15 => 'LIM', 17 => 'MDD', 18 => 'MOQ', 20 => 'PIU', 21 => 'PUN', 22 => 'SAM', 24 => 'TUM'],
        'PG' => ['01' => 'CPM', '02' => 'GPK', '03' => 'MBA', '04' => 'NPP', '05' => 'SHM', '06' => 'WPD', '07' => 'NSB', '08' => 'CPK', '09' => 'EHG', 10 => 'EBR', 11 => 'ESW', 12 => 'MPM', 13 => 'MRL', 14 => 'MPL', 15 => 'NIK', 16 => 'WHM', 17 => 'WBK', 18 => 'SAN', 19 => 'EPW'],
        'PK' => ['01' => 'TA', '02' => 'BA', '03' => 'KP', '04' => 'PB', '05' => 'SD', '07' => 'GB', '08' => 'IS'],
        'PT' => ['02' => '01', '03' => '02', '04' => '03', '05' => '04', '06' => '05', '07' => '06', '08' => '07', '09' => '08', 11 => '09', 13 => '10', 14 => '11', 16 => '12', 17 => '13', 18 => '14', 19 => '15', 20 => '16', 21 => '17', 22 => '18'],
        'PY' => ['01' => '10', '02' => '13', '04' => '5', '05' => '6', '06' => '11', '07' => '1', '08' => '3', 10 => '4', 11 => '7', 12 => '8', 13 => '12', 15 => '9', 16 => '15', 17 => '2', 18 => '16', 19 => '14'],
        'QA' => ['01' => 'DA', '03' => 'SH', '04' => 'KH', '05' => 'WA', '06' => 'RA', '08' => 'MS', '09' => 'US'],
        'RO' => ['01' => 'AB', '02' => 'AR', '03' => 'AG', '04' => 'BC', '05' => 'BH', '06' => 'BN', '07' => 'BT', '08' => 'BR', '09' => 'BV', 11 => 'BZ', 12 => 'CS', 13 => 'CJ', 15 => 'CV', 16 => 'DB', 17 => 'DJ', 18 => 'GL', 19 => 'GJ', 20 => 'HR', 21 => 'HD', 22 => 'IL', 23 => 'IS', 25 => 'MM', 26 => 'MH', 27 => 'MS', 28 => 'NT', 29 => 'OT', 30 => 'PH', 31 => 'SJ', 32 => 'SM', 33 => 'SB', 34 => 'SV', 35 => 'TR', 36 => 'TM', 37 => 'TL', 38 => 'VS', 39 => 'VL', 40 => 'VN', 41 => 'CL', 42 => 'GR'],
        'RU' => ['01' => 'AD', '02' => 'ZAB', '03' => 'ALT', '04' => 'ALT', '05' => 'AMU', '06' => 'ARK', '07' => 'AST', '09' => 'BEL', 10 => 'BRY', 11 => 'ZAB', 14 => 'CHU', 16 => 'CU', 18 => 'KYA', 19 => 'IN', 20 => 'IRK', 21 => 'IVA', 22 => 'KB', 23 => 'KGD', 24 => 'KL', 25 => 'KLU', 26 => 'KAM', 27 => 'KC', 29 => 'KEM', 31 => 'KK', 32 => 'KHM', 33 => 'KIR', 35 => 'KO', 36 => 'KAM', 37 => 'KOS', 38 => 'KDA', 39 => 'KYA', 40 => 'KGN', 41 => 'KRS', 42 => 'LEN', 43 => 'LIP', 44 => 'MAG', 45 => 'ME', 46 => 'MO', 47 => 'MOS', 48 => 'MOW', 51 => 'NIZ', 52 => 'NGR', 53 => 'NVS', 54 => 'OMS', 55 => 'ORL', 56 => 'ORE', 57 => 'PNZ', 58 => 'PER', 59 => 'PRI', 60 => 'PSK', 62 => 'RYA', 63 => 'SA', 64 => 'SAK', 65 => 'SAM', 66 => 'SPE', 67 => 'SAR', 69 => 'SMO', 70 => 'STA', 71 => 'SVE', 72 => 'TAM', 74 => 'KYA', 75 => 'TOM', 76 => 'TUL', 77 => 'TVE', 78 => 'TYU', 79 => 'TY', 80 => 'UD', 81 => 'ULY', 82 => 'BU', 83 => 'VLA', 84 => 'VGG', 85 => 'VLG', 86 => 'VOR', 87 => 'YAN', 88 => 'YAR', 89 => 'YEV'],
        'SA' => ['03' => '12', '05' => '03', '06' => '04', '08' => '05', 10 => '01', 13 => '06', 14 => '02', 15 => '08'],
        'SB' => ['03' => 'ML', '04' => 'WE', '05' => 'CE', '06' => 'GU', '07' => 'IS', '08' => 'MK', '09' => 'TE'],
        'SC' => ['01' => '01', '02' => '02', '03' => '03', '05' => '05', '06' => '06', '07' => '07', '08' => '08', '09' => '09', 10 => '10', 11 => '11', 12 => '12', 15 => '15', 17 => '17', 18 => '18', 19 => '19', 21 => '21', 22 => '22', 23 => '23'],
        'SH' => ['01' => 'AC', '02' => 'HL', '03' => 'TA'],
        'SL' => ['01' => 'E', '02' => 'N', '03' => 'S'],
        'SM' => ['01' => '01', '02' => '02', '03' => '03', '04' => '04', '05' => '05', '06' => '06', '07' => '07', '09' => '09'],
        'SN' => ['01' => 'DK', '03' => 'DB', '04' => 'SL', '05' => 'TC', '07' => 'TH', '08' => 'LG', '09' => 'FK', 10 => 'KL', 11 => 'KD', 12 => 'ZG'],
        'SR' => [10 => 'BR', 11 => 'CM', 12 => 'CR', 13 => 'MA', 14 => 'NI', 15 => 'PR', 16 => 'PM', 17 => 'SA', 18 => 'SI', 19 => 'WA'],
        'SV' => ['01' => 'AH', '02' => 'CA', '03' => 'CH', '04' => 'CU', '05' => 'LI', '06' => 'PA', '07' => 'UN', '08' => 'MO', '09' => 'SM', 10 => 'SS', 11 => 'SA', 12 => 'SV', 13 => 'SO', 14 => 'US'],
        'SY' => ['01' => 'HA', '02' => 'LA', '03' => 'QU', '04' => 'RA', '05' => 'SU', '06' => 'DR', '07' => 'DY', '08' => 'RD', '09' => 'HL', 10 => 'HM', 11 => 'HI', 12 => 'ID', 13 => 'DI', 14 => 'TA'],
        'SZ' => ['01' => 'HH', '02' => 'LU', '03' => 'MA', '04' => 'SH'],
        'TH' => ['01' => '58', '02' => '50', '03' => '57', '04' => '55', '05' => '51', '06' => '52', '07' => '54', '08' => '63', '09' => '64', 10 => '53', 11 => '62', 12 => '65', 13 => '66', 14 => '67', 15 => '61', 16 => '60', 17 => '43', 18 => '42', 19 => '41', 20 => '47', 21 => '48', 22 => '40', 23 => '46', 24 => '44', 25 => '45', 26 => '36', 27 => '30', 28 => '31', 29 => '32', 30 => '33', 31 => '96', 32 => '18', 33 => '17', 34 => '16', 35 => '15', 36 => '14', 37 => '19', 38 => '12', 39 => '13', 40 => '10', 41 => '56', 42 => '11', 43 => '26', 44 => '24', 45 => '25', 46 => '20', 47 => '21', 48 => '22', 49 => '23', 50 => '71', 51 => '72', 52 => '70', 53 => '73', 54 => '75', 55 => '74', 56 => '76', 57 => '77', 58 => '86', 59 => '85', 60 => '84', 61 => '82', 62 => '83', 63 => '81', 64 => '80', 65 => '92', 66 => '93', 67 => '91', 68 => '90', 69 => '94', 70 => '95', 71 => '34', 72 => '35'],
        'TM' => ['01' => 'A', '02' => 'B', '03' => 'D', '04' => 'L', '05' => 'M'],
        'TN' => ['02' => '42', '03' => '41', '06' => '32', 14 => '33', 15 => '53', 16 => '52', 17 => '31', 18 => '23', 19 => '21', 22 => '34', 23 => '51', 26 => '12', 27 => '13', 28 => '82', 29 => '81', 31 => '73', 32 => '61', 33 => '43', 34 => '83', 35 => '72', 36 => '11', 37 => '22'],
        'TO' => ['01' => '01', '02' => '04', '03' => '05'],
        'TR' => ['03' => '03', '04' => '04', '05' => '05', '07' => '07', '08' => '08', '09' => '09', 10 => '10', 11 => '11', 12 => '12', 13 => '13', 14 => '14', 15 => '15', 16 => '16', 19 => '19', 20 => '20', 22 => '22', 23 => '23', 24 => '24', 25 => '25', 26 => '26', 28 => '28', 31 => '31', 32 => '33', 33 => '32', 37 => '37', 38 => '38', 39 => '39', 40 => '40', 41 => '41', 43 => '43', 44 => '44', 45 => '45', 46 => '46', 48 => '48', 49 => '49', 52 => '52', 53 => '53', 54 => '54', 55 => '55', 57 => '57', 58 => '58', 59 => '59', 60 => '60', 61 => '61', 62 => '62', 63 => '63', 64 => '64', 65 => '65', 66 => '66', 68 => '06', 69 => '29', 70 => '30', 71 => '42', 72 => '47', 74 => '56', 75 => '68', 76 => '72', 77 => '69', 78 => '70', 79 => '71', 80 => '73', 81 => '01', 82 => '18', 83 => '27', 84 => '36', 85 => '67', 86 => '75', 87 => '74', 88 => '76', 89 => '78', 90 => '79', 91 => '80', 92 => '77'],
        'TT' => ['01' => 'ARI', '02' => 'CHA', '04' => 'MRC', '05' => 'POS', '06' => 'SGE', '07' => 'SGE', '08' => 'TUP', '09' => 'SIP', 10 => 'SFO', 11 => 'TOB', 12 => 'CTT'],
        'TZ' => [13 => '06', 20 => '10', 21 => '11', 22 => '07', 23 => '02', 25 => '15'],
        'UG' => [18 => 'C', 20 => 'E', 23 => 'N', 25 => 'W', 67 => 'C'],
        'US' => ['01' => 'AL', '02' => 'AK', '04' => 'AZ', '05' => 'AR', '06' => 'CA', '08' => 'CO', '09' => 'CT', 10 => 'DE', 11 => 'DC', 12 => 'FL', 13 => 'GA', 15 => 'HI', 16 => 'ID', 17 => 'IL', 18 => 'IN', 19 => 'IA', 20 => 'KS', 21 => 'KY', 22 => 'LA', 23 => 'ME', 24 => 'MD', 25 => 'MA', 26 => 'MI', 27 => 'MN', 28 => 'MS', 29 => 'MO', 30 => 'MT', 31 => 'NE', 32 => 'NV', 33 => 'NH', 34 => 'NJ', 35 => 'NM', 36 => 'NY', 37 => 'NC', 38 => 'ND', 39 => 'OH', 40 => 'OK', 41 => 'OR', 44 => 'RI', 45 => 'SC', 46 => 'SD', 47 => 'TN', 48 => 'TX', 49 => 'UT', 50 => 'VT', 51 => 'VA', 53 => 'WA', 54 => 'WV', 55 => 'WI', 56 => 'WY'],
        'UY' => ['01' => 'AR', '02' => 'CA', '03' => 'CL', '04' => 'CO', '05' => 'DU', '06' => 'FS', '07' => 'FD', '08' => 'LA', '09' => 'MA', 10 => 'MO', 11 => 'PA', 12 => 'RN', 13 => 'RV', 14 => 'RO', 15 => 'SA', 16 => 'SJ', 17 => 'SO', 18 => 'TA', 19 => 'TT'],
        'UZ' => ['01' => 'AN', '02' => 'BU', '03' => 'FA', '05' => 'XO', '06' => 'NG', '07' => 'NW', '08' => 'QA', '09' => 'QR', 10 => 'SA', 11 => 'SI', 12 => 'SU', 13 => 'TK', 14 => 'TO'],
        'VC' => ['01' => '01', '02' => '02', '03' => '03', '04' => '04', '05' => '05', '06' => '06'],
        'VE' => ['01' => 'Z', '02' => 'B', '03' => 'C', '04' => 'D', '05' => 'E', '06' => 'F', '07' => 'G', '08' => 'H', '09' => 'Y', 11 => 'I', 12 => 'J', 13 => 'K', 14 => 'L', 15 => 'M', 16 => 'N', 17 => 'O', 18 => 'P', 19 => 'R', 20 => 'S', 21 => 'T', 22 => 'U', 23 => 'V', 24 => 'W', 25 => 'A', 26 => 'X'],
        'VN' => ['02' => '05', '03' => '50', '05' => '04', 11 => '54', 12 => '61', 13 => 'HP', 22 => '01', 23 => '35', 24 => '41', 29 => '27', 30 => '13', 32 => '05', 33 => '37', 34 => '21', 35 => '20', 37 => '46', 39 => '09', 43 => '44', 44 => '33', 45 => '39', 46 => '45', 47 => '47', 48 => '55', 49 => '30', 50 => '70', 51 => 'HN', 52 => 'SG', 53 => '43', 54 => '31', 55 => '40', 56 => 'CT', 57 => '30', 58 => '03', 59 => 'HN', 60 => '23', 61 => '14', 62 => '34', 63 => '28', 64 => '02', 65 => '63', 66 => '22', 67 => '18', 68 => '36', 69 => '32', 70 => '24', 71 => '29', 72 => '25', 73 => '52', 74 => '26', 75 => '51', 76 => '07', 77 => '49', 78 => '06'],
        'WS' => ['02' => 'AL', '03' => 'AT', '07' => 'GI', '08' => 'PA', 10 => 'TU', 11 => 'VS'],
        'YE' => ['01' => 'AB', '03' => 'MR', '04' => 'HD', '05' => 'SH', '06' => 'LA', '07' => 'BA', '09' => 'JA', 11 => 'DH', 12 => 'HJ', 13 => 'IB', 16 => 'SN', 17 => 'TA'],
        'ZM' => ['01' => '01', '02' => '10', '03' => '03', '04' => '04', '05' => '05', '06' => '06', '07' => '07', '08' => '08', '09' => '09'],
        'ZW' => ['01' => 'MA', '02' => 'MI', '03' => 'MC', '04' => 'ME', '05' => 'MW', '06' => 'MN', '07' => 'MS', '08' => 'MV', '09' => 'BU', 10 => 'HA'],
        'BH' => [1 => '15', 2 => '13', 3 => '15', 5 => '17', 6 => '13', 8 => '17', 10 => '17', 11 => '13', 12 => '17', 13 => '14'],
        'BM' => [1 => 'DS', 7 => 'GC', 8 => 'SA', 9 => 'SM', 10 => 'SH', 11 => 'WA'],
        'BY' => [1 => 'BR', 2 => 'HO', 3 => 'HR', 5 => 'HM', 6 => 'MA', 7 => 'VI'],
        'CN' => [14 => 'XZ', 20 => 'NM', 21 => 'NX'],
        'CY' => [1 => '04', 2 => '06', 3 => '03', 6 => '05'],
        'CZ' => [52 => '10', 78 => '64', 79 => '31', 80 => '63', 81 => '41', 82 => '52', 83 => '51', 84 => '71', 85 => '80', 86 => '53', 87 => '32', 88 => '20', 89 => '42', 90 => '72'],
        'DO' => [1 => '02', 2 => '03', 3 => '04', 4 => '05', 5 => '01', 6 => '06', 8 => '09', 9 => '10', 10 => '11', 11 => '07', 12 => '12', 14 => '14', 15 => '15', 16 => '16', 17 => '17', 19 => '19', 20 => '20', 21 => '24', 23 => '22', 24 => '23', 25 => '25', 26 => '26', 27 => '27', 28 => '08', 29 => '30', 30 => '13', 31 => '28', 32 => '29', 33 => '21'],
        'FI' => [1 => '01', 13 => '04', 15 => '07'],
        'GL' => ['01' => 'QA', '02' => 'SM', '03' => 'QE'],
        'GQ' => ['07' => 'KN'],
        'IL' => ['01' => 'D', '02' => 'M', '03' => 'Z', '04' => 'HA', '06' => 'JM'],
        'IQ' => ['01' => 'AN', '02' => 'BA', '03' => 'MU', '04' => 'QA', '05' => 'SU', '06' => 'BB', '08' => 'DA', '09' => 'DQ', 10 => 'DI', 11 => 'AR', 12 => 'KA', 13 => 'KI', 15 => 'NI', 16 => 'WA'],
        'KE' => ['01' => '200', '02' => '300', '05' => '30', '06' => '07', '07' => '600', '08' => '31', '09' => '12'],
        'KH' => ['04' => '5', '05' => '6', '08' => '9', '09' => '10', 10 => '11', 11 => '12', 12 => '15', 17 => '19', 19 => '21', 29 => '2'],
        'KM' => ['01' => 'A', '03' => 'M'],
        'KN' => ['04' => '10', '06' => '06', '09' => '09', 13 => '13'],
        'KP' => [12 => '01', 15 => '02'],
        'KR' => ['01' => '49', '03' => '45', '05' => '43', '06' => '42', 10 => '26', 11 => '11', 12 => '28', 13 => '41', 14 => '47', 15 => '27', 16 => '46', 17 => '44', 18 => '29', 19 => '30', 20 => '48', 21 => '31'],
        'KW' => ['02' => 'KU'],
        'LT' => [56 => 'AL', 57 => 'KU', 58 => 'KL', 59 => 'MR', 60 => 'PN', 61 => 'SA', 62 => 'TA', 63 => 'TE', 64 => 'UT', 65 => 'VL'],
        'MG' => ['01' => 'D', '02' => 'F', '03' => 'M', '04' => 'A', '05' => 'T', '06' => 'U'],
        'MV' => ['01' => '01', 26 => '26'],
        'MW' => ['02' => 'S', '03' => 'S', '05' => 'S', '07' => 'C', '09' => 'C', 11 => 'C', 12 => 'S', 13 => 'C', 17 => 'N', 20 => 'C', 23 => 'S', 24 => 'S'],
        'NA' => [21 => 'KH'],
        'NP' => ['01' => '1', '02' => '2', '04' => '3', '05' => '1', '07' => '4', '08' => '3', 10 => '4', 11 => '1'],
        'PH' => ['B4' => '00', 'D9' => '00', 'E9' => '00'],
        'PL' => [23 => 'LU', 24 => 'PD', 25 => 'SL', 26 => 'KP', 27 => 'LU', 28 => 'MZ', 29 => 'SL', 30 => 'PM', 31 => 'PM', 32 => 'LB', 33 => 'DS', 34 => 'WP', 35 => 'SL', 36 => 'SK', 37 => 'WP', 38 => 'ZP', 39 => 'MA', 40 => 'PK', 41 => 'DS', 42 => 'WP', 43 => 'LD', 44 => 'PD', 46 => 'MA', 47 => 'WN', 48 => 'OP', 49 => 'MZ', 50 => 'WP', 51 => 'LD', 52 => 'LD', 53 => 'WP', 54 => 'PK', 55 => 'MZ', 56 => 'PK', 57 => 'MZ', 58 => 'LD', 59 => 'LD', 60 => 'PM', 61 => 'PD', 63 => 'PK', 64 => 'MA', 65 => 'KP', 66 => 'DS', 67 => 'MZ', 68 => 'KP', 69 => 'DS', 70 => 'LU', 71 => 'LB'],
        'RW' => ['01' => '05', '02' => '03', '03' => '04', '04' => '05', '05' => '04', '06' => '05', '07' => '02', 10 => '03'],
        'SD' => [27 => 'NB', 29 => 'KH', 33 => 'DW', 34 => 'GK'],
        'SE' => ['02' => 'K', '03' => 'X', '05' => 'I', '06' => 'N', '07' => 'Z', '08' => 'F', '09' => 'H', 10 => 'W', 12 => 'G', 13 => 'M', 14 => 'BD', 15 => 'T', 16 => 'E', 18 => 'D', 21 => 'C', 22 => 'S', 23 => 'AC', 24 => 'Y', 25 => 'U', 26 => 'AB', 27 => 'M', 28 => 'O'],
        'SO' => ['04' => 'BY', '07' => 'HI', '09' => 'AW', 13 => 'SD', 14 => 'SH'],
        'ST' => ['02' => 'S'],
        'TD' => ['01' => 'BA', '02' => 'WF', '03' => 'BO', '04' => 'CB', '05' => 'GR', '06' => 'KA', '08' => 'LO', '09' => 'LR', 10 => 'ME', 11 => 'MC', 12 => 'OD', 13 => 'SA', 14 => 'TA'],
        'TG' => ['02' => 'M', '08' => 'P', '09' => 'K', 17 => 'M', 18 => 'M'],
        'TW' => ['02' => 'KHH', '03' => 'TPE', '04' => 'NWT'],
        'UA' => ['02' => '74', '03' => '77', '04' => '12', 10 => '35', 11 => '43', 12 => '30', 13 => '32', 17 => '51', 20 => '40', 25 => '21', 26 => '23'],
        'VU' => ['07' => 'TOB', '08' => 'SEE', 13 => 'SAM', 15 => 'TAE'],
        'ZA' => ['01' => 'EC', '02' => 'NL', '04' => 'MP'],
    ];

    const FIPS_TO_SUB2 = [
        'GB' => ['03' => 'WBK', '08' => 'CON', '09' => 'CMA', 'A1' => 'BDG', 'A2' => 'BNE', 'A3' => 'BNS', 'A4' => 'BAS', 'A5' => 'CBF', 'A6' => 'BEX', 'A7' => 'BIR', 'A8' => 'BBD', 'A9' => 'BPL', 'B1' => 'BOL', 'B2' => 'BMH', 'B3' => 'BRC', 'B4' => 'BRD', 'B5' => 'BEN', 'B6' => 'BNH', 'B7' => 'BST', 'B8' => 'BRY', 'B9' => 'BKM', 'C1' => 'BUR', 'C2' => 'CLD', 'C3' => 'CAM', 'C4' => 'CMD', 'C5' => 'CHW', 'C7' => 'COV', 'C8' => 'CRY', 'D1' => 'DAL', 'D2' => 'DER', 'D3' => 'DBY', 'D4' => 'DEV', 'D5' => 'DNC', 'D6' => 'DOR', 'D7' => 'DUD', 'D8' => 'DUR', 'D9' => 'EAL', 'E1' => 'ERY', 'E2' => 'ESX', 'E3' => 'ENF', 'E4' => 'ESS', 'E5' => 'GAT', 'E6' => 'GLS', 'E7' => 'GRE', 'E8' => 'HCK', 'E9' => 'HAL', 'F1' => 'HMF', 'F2' => 'HAM', 'F3' => 'HRY', 'F4' => 'HRW', 'F5' => 'HPL', 'F6' => 'HAV', 'F7' => 'HEF', 'F8' => 'HRT', 'F9' => 'HIL', 'G1' => 'HNS', 'G2' => 'IOW', 'G3' => 'ISL', 'G4' => 'KEC', 'G5' => 'KEN', 'G6' => 'KHL', 'G7' => 'KTT', 'G8' => 'KIR', 'G9' => 'KWL', 'H1' => 'LBH', 'H2' => 'LAN', 'H3' => 'LDS', 'H4' => 'LCE', 'H5' => 'LEC', 'H6' => 'LEW', 'H7' => 'LIN', 'H8' => 'LIV', 'H9' => 'LND', 'I1' => 'LUT', 'I2' => 'MAN', 'I3' => 'MDW', 'I4' => 'MRT', 'I5' => 'MDB', 'I6' => 'MIK', 'I7' => 'NET', 'I8' => 'NWM', 'I9' => 'NFK', 'J1' => 'NTH', 'J2' => 'NEL', 'J3' => 'NLN', 'J4' => 'NSM', 'J5' => 'NTY', 'J6' => 'NBL', 'J7' => 'NYK', 'J8' => 'NGM', 'J9' => 'NTT', 'K1' => 'OLD', 'K2' => 'OXF', 'K3' => 'PTE', 'K4' => 'PLY', 'K5' => 'POL', 'K6' => 'POR', 'K7' => 'RDG', 'K8' => 'RDB', 'K9' => 'RCC', 'L1' => 'RIC', 'L2' => 'RCH', 'L3' => 'ROT', 'L4' => 'RUT', 'L5' => 'SLF', 'L6' => 'SHR', 'L7' => 'SAW', 'L8' => 'SFT', 'L9' => 'SHF', 'M1' => 'SLG', 'M2' => 'SOL', 'M3' => 'SOM', 'M4' => 'STH', 'M5' => 'SOS', 'M6' => 'SGC', 'M7' => 'STY', 'M8' => 'SWK', 'M9' => 'STS', 'N1' => 'SHN', 'N2' => 'SKP', 'N3' => 'STT', 'N4' => 'STE', 'N5' => 'SFK', 'N6' => 'SND', 'N7' => 'SRY', 'N8' => 'STN', 'N9' => 'SWD', 'O1' => 'TAM', 'O2' => 'TFW', 'O3' => 'THR', 'O4' => 'TOB', 'O5' => 'TWH', 'O6' => 'TRF', 'O7' => 'WKF', 'O8' => 'WLL', 'O9' => 'WFT', 'P1' => 'WND', 'P2' => 'WRT', 'P3' => 'WAR', 'P4' => 'WBK', 'P5' => 'WSM', 'P6' => 'WSX', 'P7' => 'WGN', 'P8' => 'WIL', 'P9' => 'WNM', 'Q1' => 'WRL', 'Q2' => 'WOK', 'Q3' => 'WLV', 'Q4' => 'WOR', 'Q5' => 'YOR', 'Q6' => 'ANN', 'Q7' => 'AND', 'Q8' => 'ABC', 'Q9' => 'MEA', 'R1' => 'CCG', 'R2' => 'ABC', 'R3' => 'BFS', 'R4' => 'MEA', 'R5' => 'LBC', 'R6' => 'CCG', 'R7' => 'MUL', 'R8' => 'ABC', 'R9' => 'NMD', 'S1' => 'MUL', 'S2' => 'FMO', 'S3' => 'MEA', 'S4' => 'CCG', 'S5' => 'LBC', 'S6' => 'DRS', 'S7' => 'MUL', 'S8' => 'CCG', 'S9' => 'NMD', 'T1' => 'ANN', 'T2' => 'NMD', 'T3' => 'FMO', 'T4' => 'DRS', 'T5' => 'ABE', 'T6' => 'ABD', 'T7' => 'ANS', 'T8' => 'AGB', 'T9' => 'SCB', 'U1' => 'CLK', 'U2' => 'DGY', 'U3' => 'DND', 'U4' => 'EAY', 'U5' => 'EDU', 'U6' => 'ELN', 'U7' => 'ERW', 'U8' => 'EDH', 'U9' => 'FAL', 'V1' => 'FIF', 'V2' => 'GLG', 'V3' => 'HLD', 'V4' => 'IVC', 'V5' => 'MLN', 'V6' => 'MRY', 'V7' => 'NAY', 'V8' => 'NLK', 'V9' => 'ORK', 'W1' => 'PKN', 'W2' => 'RFW', 'W3' => 'ZET', 'W4' => 'SAY', 'W5' => 'SLK', 'W6' => 'STG', 'W7' => 'WDU', 'W8' => 'ELS', 'W9' => 'WLN', 'X1' => 'AGY', 'X2' => 'BGW', 'X3' => 'BGE', 'X4' => 'CAY', 'X5' => 'CRF', 'X6' => 'CGN', 'X7' => 'CMN', 'X8' => 'CWY', 'X9' => 'DEN', 'Y1' => 'FLN', 'Y2' => 'GWN', 'Y3' => 'MTY', 'Y4' => 'MON', 'Y5' => 'NTL', 'Y6' => 'NWP', 'Y7' => 'PEM', 'Y8' => 'POW', 'Y9' => 'RCT', 'Z1' => 'SWA', 'Z2' => 'TOF', 'Z3' => 'VGL', 'Z4' => 'WRX', 17 => 'LND', 28 => 'LIV', 37 => 'SHF', 43 => 'BIR', 45 => 'LDS', 87 => 'GLG', 90 => 'WRX'],
        'IE' => ['01' => 'CW', '02' => 'CN', '03' => 'CE', '04' => 'CO', '06' => 'DL', '07' => 'D', 10 => 'G', 11 => 'KY', 12 => 'KE', 13 => 'KK', 14 => 'LM', 15 => 'LS', 16 => 'LK', 18 => 'LD', 19 => 'LH', 20 => 'MO', 21 => 'MH', 22 => 'MN', 23 => 'OY', 24 => 'RN', 25 => 'SO', 26 => 'TA', 27 => 'WD', 29 => 'WH', 30 => 'WX', 31 => 'WW'],
        'MA' => ['01' => 'AGD', '02' => 'HOC', '03' => 'AZI', '04' => 'BES', '05' => 'BEM', '06' => 'BOM', '07' => 'CAS', '08' => 'CHE', '09' => 'JDI', 10 => 'KES', 11 => 'ERR', 12 => 'ESI', 13 => 'FES', 14 => 'FIG', 15 => 'KEN', 16 => 'KHE', 17 => 'KHN', 18 => 'KHO', 19 => 'MMD', 20 => 'MEK', 21 => 'NAD', 22 => 'OUA', 23 => 'OUJ', 24 => 'RAB', 25 => 'SAF', 26 => 'SET', 27 => 'TNG', 29 => 'TAT', 30 => 'TAZ', 32 => 'TIZ', 33 => 'GUE', 34 => 'IFR', 36 => 'TNT', 37 => 'TAO', 38 => 'SIK', 39 => 'TAR', 40 => 'TET', 41 => 'LAR'],
        'PH' => ['01' => 'ABR', '02' => 'AGN', '03' => 'AGS', '04' => 'AKL', '05' => 'ALB', '06' => 'ANT', '07' => 'BAN', '08' => 'BTN', '09' => 'BTG', 'A1' => 'PAM', 'A2' => 'NEC', 'A3' => 'NEC', 'A4' => 'BEN', 'A5' => 'NER', 'A7' => 'BTG', 'A8' => 'AGN', 'A9' => 'NUE', 'B1' => 'NEC', 'B2' => 'MSR', 'B3' => 'WSA', 'B5' => 'NER', 'B6' => 'CAV', 'B7' => 'CEB', 'B8' => 'MAG', 'B9' => 'PAN', 'C1' => 'CEB', 'C2' => 'ZAN', 'C3' => 'DAS', 'C4' => 'ZAN', 'C5' => 'NER', 'C6' => 'SCO', 'C7' => 'MSR', 'C8' => 'LAN', 'C9' => 'ILI', 'D1' => 'CAS', 'D2' => 'NEC', 'D3' => 'ILN', 'D4' => 'CEB', 'D5' => 'ALB', 'D6' => 'BTG', 'D7' => 'QUE', 'D8' => 'CEB', 'E1' => 'LAS', 'E2' => 'CAS', 'E3' => 'ZMB', 'E4' => 'LEY', 'E5' => 'MSC', 'E6' => 'MSC', 'E7' => 'ZAS', 'E8' => 'NUE', 'F1' => 'PLW', 'F2' => 'QUE', 'F3' => 'CAP', 'F4' => 'NEC', 'F5' => 'PAN', 'F6' => 'NUE', 'F7' => 'LAG', 'F8' => 'NEC', 'F9' => 'SUN', 'G1' => 'LEY', 'G2' => 'CAV', 'G3' => 'BOH', 'G4' => 'MSC', 'G5' => 'CEB', 'G6' => 'CAV', 'G7' => 'ZSI', 'G8' => 'AUR', 'H2' => 'QUE', 'H3' => 'NEC', 10 => 'BEN', 11 => 'BOH', 12 => 'BUK', 13 => 'BUL', 14 => 'CAG', 15 => 'CAN', 16 => 'CAS', 17 => 'CAM', 18 => 'CAP', 19 => 'CAT', 20 => 'CAV', 21 => 'CEB', 22 => 'BAS', 23 => 'EAS', 25 => 'DAS', 26 => 'DAO', 27 => 'IFU', 28 => 'ILN', 29 => 'ILS', 30 => 'ILI', 31 => 'ISA', 32 => 'KAL', 33 => 'LAG', 34 => 'LAN', 35 => 'LAS', 36 => 'LUN', 37 => 'LEY', 38 => 'MAD', 39 => 'MAS', 40 => 'MDC', 41 => 'MDR', 42 => 'MSC', 43 => 'MSR', 44 => 'MOU', 46 => 'NER', 47 => 'NUE', 48 => 'NUV', 49 => 'PLW', 50 => 'PAM', 51 => 'PAN', 53 => 'RIZ', 54 => 'ROM', 55 => 'WSA', 56 => 'MAG', 57 => 'NCO', 58 => 'SOR', 59 => 'SLE', 60 => 'SLU', 61 => 'SUN', 62 => 'SUR', 63 => 'TAR', 64 => 'ZMB', 65 => 'ZAN', 66 => 'ZAS', 67 => 'NSA', 68 => 'QUI', 69 => 'SIG', 70 => 'SCO', 71 => 'SUK', 72 => 'TAW'],
        'BE' => ['01' => 'VAN', '02' => 'VBR', '03' => 'WHT', '04' => 'WLG', '05' => 'VLI', '06' => 'WLX', '07' => 'WNA', '08' => 'VOV', '09' => 'VWV', 10 => 'WBR', 12 => 'VBR'],
        'GR' => ['01' => '71', '02' => '73', '03' => '72', '04' => '52', '05' => '62', '06' => '57', '07' => '59', '08' => '63', '09' => '56', 10 => '51', 11 => '58', 12 => '53', 13 => '54', 14 => '55', 15 => '64', 16 => '61', 17 => '33', 18 => '32', 19 => '34', 20 => '31', 21 => '42', 22 => '44', 23 => '41', 24 => '43', 25 => '22', 26 => '24', 27 => '23', 28 => '21', 29 => '06', 30 => '05', 31 => '01', 32 => '07', 33 => '03', 34 => '04', 35 => 'A1', 36 => '11', 37 => '15', 38 => '13', 39 => '14', 40 => '17', 41 => '12', 42 => '16', 43 => '94', 44 => '93', 45 => '91', 46 => '92', 47 => '81', 48 => '84', 49 => '82', 50 => '85', 51 => '83'],
        'MK' => ['01' => '02', '03' => '22', '07' => '14', '09' => '80', 'A2' => '74', 'A5' => '75', 'A7' => '62', 'B3' => '12', 'B5' => '62', 'B6' => '40', 'B7' => '16', 'B8' => '35', 'B9' => '19', 'C1' => '40', 'C2' => '32', 'C3' => '30', 'C4' => '27', 'C5' => '63', 'C6' => '33', 11 => '07', 12 => '08', 14 => '04', 15 => '80', 16 => '19', 19 => '81', 20 => '82', 22 => '23', 23 => '72', 24 => '25', 26 => '53', 27 => '19', 28 => '27', 30 => '40', 35 => '20', 36 => '34', 37 => '80', 38 => '35', 39 => '06', 40 => '37', 41 => '85', 43 => '40', 44 => '85', 45 => '47', 46 => '42', 47 => '41', 48 => '85', 49 => '36', 50 => '58', 53 => '45', 54 => '46', 55 => '73', 56 => '04', 58 => '72', 59 => '48', 60 => '49', 62 => '51', 64 => '50', 65 => '22', 66 => '18', 67 => '53', 70 => '54', 71 => '55', 75 => '47', 76 => '85', 77 => '40', 78 => '60', 79 => '59', 80 => '61', 81 => '64', 83 => '63', 84 => '64', 85 => '65', 86 => '66', 87 => '67', 88 => '50', 89 => '52', 90 => '85', 91 => '76', 92 => '70', 93 => '25', 94 => '19', 96 => '26', 97 => '71', 98 => '83'],
    ];

    const FIPS_NEW_COUNTRY = [
        'LV' => [
            20 => ['LC', '059'],
        ],
        'SD' => [
            28 => ['SS', 'EW'],
            32 => ['SS', 'BN'],
        ],
        'TW' => [
            '01' => ['CN', 'FJ'],
        ],
    ];

    public static function migrate(array $row): array
    {
        if (!isset($row['type'])) {
            throw new \InvalidArgumentException("Missing Delivery Rule type");
        }

        switch ($row['type']) {
            case 'deliveryLimitations:Geo:Areacode':
                throw new DeliveryRuleDeletedException();

            case 'deliveryLimitations:Geo:Region':
                return self::migrateRegionRule($row);

            case 'deliveryLimitations:Geo:Dma':
                return self::migrateDmaRule($row);

            case 'deliveryLimitations:Geo:Netspeed':
                return self::migrateNetSpeedRule($row);
        }

        throw new \InvalidArgumentException("Unsupporded Rule type: {$row['type']}");
    }

    private static function migrateRegionRule(array $row): array
    {
        list($country, $regions) = explode('|', $row['data']);

        $regions = explode(',', $regions);

        if (isset(self::FIPS_TO_SUB2[$country])) {
            $row['type'] = 'deliveryLimitations:Geo:Subdivision2';
            $row['data'] = self::regionTranslate($country, $regions, self::FIPS_TO_SUB2);
        } else {
            $row['type'] = 'deliveryLimitations:Geo:Subdivision1';
            $row['data'] =  self::regionTranslate($country, $regions, self::FIPS_TO_SUB1, self::FIPS_NEW_COUNTRY);
        }

        return $row;
    }

    private static function migrateDmaRule(array $row): array
    {
        $row['type'] = 'deliveryLimitations:Geo:UsMetro';

        return $row;
    }

    private static function migrateNetSpeedRule(array $row): array
    {
        $row['type'] = 'deliveryLimitations:Geo:ConnectionType';

        return $row;
    }

    private static function regionTranslate(string $country, array $regions, array $map, array $switch = []): string
    {
        $result = $warn = [];
        foreach ($regions as $region) {
            if (isset($switch[$country][$region])) {
                list($newCountry, $newRegion) = $switch[$country][$region];
                $warn[$newCountry][] = $newRegion;
                continue;
            }

            $result[] = $map[$country][$region] ?? $region;
        }

        // Old country takes precedence
        if ($result) {
            return self::regionCompact($country, $result);
        }

        // Region(s) moved to a single new country
        assert(1 === count($warn));

        return self::regionCompact(key($warn), current($warn));
    }

    private static function regionCompact(string $country, array $regions) {
        $regions = array_unique($regions, SORT_STRING);
        sort($regions, SORT_STRING);

        return $country.'|'.join(',', $regions);
    }
}