/**
 * You can use `call` to execute any async action within your test spec. The command itself
 * is treated like a synchronous function. It accepts promises and stops the execution until
 * the promise has resolved.
 *
 * This command helps to run asynchronous code within a synchronous context. With
 * WebdriverIO deprecating synchronous usage (see [RFC](https://github.com/webdriverio/webdriverio/discussions/6702))
 * this command is not very useful anymore.
 *
 * <example>
    :call.js
    it('some testing here', async () => {
        await browser.url('http://google.com')
        // make an asynchronous call using any 3rd party library supporting promises
        // e.g. call to backend or db to inject fixture data
        await browser.call(() => {
            return somePromiseLibrary.someMethod().then(() => {
                // ...
            })
        })

        // example for async call to 3rd party library that doesn't support promises
        const result = await browser.call(() => {
            return new Promise((resolve, reject) => {
                someOtherNodeLibrary.someMethod(param1, (err, res) => {
                    if (err) {
                        return reject(err)
                    }
                    resolve(res)
                })
            })
        })
    });
 * </example>
 *
 * @alias browser.call
 * @param {Function} callback  function to be called
 * @type utility
 *
 */
export default function call<T>(fn: () => T): T | Promise<T>;
//# sourceMappingURL=call.d.ts.map