import { Options, Capabilities } from '@wdio/types';
import { WebDriverResponse } from './request';
import type { JSONWPCommandError, SessionFlags } from './types';
/**
 * start browser session with WebDriver protocol
 */
export declare function startWebDriverSession(params: Options.WebDriver): Promise<{
    sessionId: string;
    capabilities: Capabilities.DesiredCapabilities;
}>;
/**
 * check if WebDriver requests was successful
 * @param  {Number}  statusCode status code of request
 * @param  {Object}  body       body payload of response
 * @return {Boolean}            true if request was successful
 */
export declare function isSuccessfulResponse(statusCode?: number, body?: WebDriverResponse): boolean;
/**
 * creates the base prototype for the webdriver monad
 */
export declare function getPrototype({ isW3C, isChrome, isMobile, isSauce, isSeleniumStandalone }: Partial<SessionFlags>): Record<string, PropertyDescriptor>;
/**
 * helper method to determine the error from webdriver response
 * @param  {Object} body body object
 * @return {Object} error
 */
export declare function getErrorFromResponseBody(body: any): Error;
export declare class CustomRequestError extends Error {
    constructor(body: WebDriverResponse);
}
/**
 * return all supported flags and return them in a format so we can attach them
 * to the instance protocol
 * @param  {Object} options   driver instance or option object containing these flags
 * @return {Object}           prototype object
 */
export declare function getEnvironmentVars({ isW3C, isMobile, isIOS, isAndroid, isChrome, isSauce, isSeleniumStandalone }: Partial<SessionFlags>): {
    isW3C: {
        value: boolean | undefined;
    };
    isMobile: {
        value: boolean | undefined;
    };
    isIOS: {
        value: boolean | undefined;
    };
    isAndroid: {
        value: boolean | undefined;
    };
    isChrome: {
        value: boolean | undefined;
    };
    isSauce: {
        value: boolean | undefined;
    };
    isSeleniumStandalone: {
        value: boolean | undefined;
    };
};
/**
 * get human readable message from response error
 * @param {Error} err response error
 */
export declare const getSessionError: (err: JSONWPCommandError, params?: Partial<Options.WebDriver>) => string;
//# sourceMappingURL=utils.d.ts.map