/**
 * @typedef {import('vfile').VFile} VFile
 * @typedef {import('vfile-message').VFileMessage} VFileMessage
 *
 * @typedef Statistics
 * @property {number} fatal Fatal errors (`fatal: true`)
 * @property {number} warn warning errors (`fatal: false`)
 * @property {number} info informational messages (`fatal: null|undefined`)
 * @property {number} nonfatal warning + info
 * @property {number} total nonfatal + fatal
 */
/**
 * Get stats for a file, list of files, or list of messages.
 *
 * @param {Array.<VFile|VFileMessage>|VFile|VFileMessage} [value]
 * @returns {Statistics}
 */
export function statistics(
  value?: Array<VFile | VFileMessage> | VFile | VFileMessage
): Statistics
export type VFile = import('vfile').VFile
export type VFileMessage = import('vfile-message').VFileMessage
export type Statistics = {
  /**
   * Fatal errors (`fatal: true`)
   */
  fatal: number
  /**
   * warning errors (`fatal: false`)
   */
  warn: number
  /**
   * informational messages (`fatal: null|undefined`)
   */
  info: number
  /**
   * warning + info
   */
  nonfatal: number
  /**
   * nonfatal + fatal
   */
  total: number
}
