/**
 * Report a file’s messages.
 *
 * @param {Error|VFile|Array<VFile>} [files]
 * @param {Options} [options]
 * @returns {string}
 */
export function reporter(
  files?: import('vfile').VFile | Error | import('vfile').VFile[] | undefined,
  options?: Options | undefined
): string
export type VFile = import('vfile').VFile
export type VFileMessage = import('vfile-message').VFileMessage
export type Statistics = import('vfile-statistics').Statistics
export type Options = {
  color?: boolean | undefined
  silent?: boolean | undefined
  quiet?: boolean | undefined
  verbose?: boolean | undefined
  defaultName?: string | undefined
}
export type Row = {
  place: string
  label: string
  reason: string
  ruleId: string
  source: string
}
export type FileRow = {
  type: 'file'
  file: VFile
  stats: Statistics
}
export type Sizes = Record<string, number>
export type Info = {
  rows: Array<FileRow | Row>
  stats: Statistics
  sizes: Sizes
}
