/**
 * Get a TOC representation of `node`.
 *
 * @param {Node} node
 * @param {Options} [options]
 * @returns {Result}
 */
export function toc(node: Node, options?: Options | undefined): Result
export type Node = import('mdast').Root | import('mdast').Content
export type List = import('mdast').List
export type SearchOptions = import('./search.js').SearchOptions
export type ContentsOptions = import('./contents.js').ContentsOptions
export type Options = SearchOptions & ContentsOptions & ExtraOptions
export type ExtraOptions = {
  /**
   * Heading to look for, wrapped in `new RegExp('^(' + value + ')$', 'i')`.
   */
  heading?: string | undefined
}
export type Result = {
  index: number | null
  endIndex: number | null
  map: List | null
}
