import { IdentityResolutionConfig, State, ResolutionParams, EventBus, RetrievedIdentifier } from './types';
import { WrappedStorageHandler } from './handlers/storage-handler';
import { WrappedCallHandler } from './handlers/call-handler';
interface Cache {
    get: (key: unknown) => unknown;
    set: (key: unknown, value: unknown, expiration?: Date) => void;
}
export declare class IdentityResolver {
    eventBus: EventBus;
    calls: WrappedCallHandler;
    cache: Cache;
    idexConfig: IdentityResolutionConfig;
    externalIds: RetrievedIdentifier[];
    source: string;
    publisherId: number | string;
    url: string;
    timeout: number;
    requestedAttributes: string[];
    tuples: [string, string][];
    private constructor();
    static make(config: State, storageHandler: WrappedStorageHandler, calls: WrappedCallHandler, eventBus: EventBus): IdentityResolver;
    static makeNoCache(config: State, calls: WrappedCallHandler, eventBus: EventBus): IdentityResolver;
    private responseReceived;
    unsafeResolve(successCallback: (result: unknown) => void, errorCallback: () => void, additionalParams: ResolutionParams): void;
    getUrl(additionalParams: Record<string, string | string[]>): string;
    resolve(successCallback: (result: unknown) => void, errorCallback: () => void, additionalParams?: ResolutionParams): void;
}
export {};
