import { StorageStrategy } from '../model/storage-strategy';
import { EventBus, ReadOnlyStorageHandler, StorageHandler } from 'live-connect-common';
import { WrappingContext } from '../utils/wrapping';
export declare class WrappedReadOnlyStorageHandler implements ReadOnlyStorageHandler {
    private minimalFunctions;
    protected constructor(storageStrategy: StorageStrategy, wrapper: WrappingContext<ReadOnlyStorageHandler>);
    static make(storageStrategy: StorageStrategy, externalStorageHandler: ReadOnlyStorageHandler, eventBus: EventBus): WrappedReadOnlyStorageHandler;
    localStorageIsEnabled(): boolean;
    getCookie(key: string): string | null;
    getDataFromLocalStorage(key: string): string | null;
}
export declare class WrappedStorageHandler extends WrappedReadOnlyStorageHandler implements StorageHandler {
    storageStrategy: StorageStrategy;
    private functions;
    protected constructor(storageStrategy: StorageStrategy, wrapper: WrappingContext<StorageHandler>);
    static make(storageStrategy: StorageStrategy, externalStorageHandler: StorageHandler, eventBus: EventBus): WrappedStorageHandler;
    get(key: string): string | null;
    set(key: string, value: string, expires: Date, domain?: string): void;
    setCookie(key: string, value: string, expires?: Date, sameSite?: string, domain?: string): void;
    setDataInLocalStorage(key: string, value: string): void;
    removeDataFromLocalStorage(key: string): void;
    findSimilarCookies(substring: string): string[];
}
