import { StorageHandler, EventBus } from 'live-connect-common';
export declare class DefaultStorageHandler implements StorageHandler {
    private eventBus;
    private _localStorageIsEnabled?;
    private cookies;
    constructor(eventBus: EventBus);
    getCookie(key: string): string | null;
    findSimilarCookies(substring: string): string[];
    setCookie(key: string, value: string, expires?: Date, sameSite?: string, domain?: string): void;
    localStorageIsEnabled(): boolean;
    getDataFromLocalStorage(key: string): string | null;
    setDataInLocalStorage(key: string, value: string): void;
    removeDataFromLocalStorage(key: string): void;
    private checkLocalStorage;
}
