'use strict';

var dist = {};

var UUID = '[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}';
var uuidRegex = new RegExp("^".concat(UUID, "$"), 'i');
var hasTrim = !!String.prototype.trim;
function safeToString(value) {
    return typeof value === 'object' ? JSON.stringify(value) : ('' + value);
}
function nonNull(value) {
    return value != null;
}
function isNonEmpty(value) {
    return nonNull(value) && trim(value).length > 0;
}
function isUUID(value) {
    return !!value && uuidRegex.test(trim(value));
}
function isArray(arr) {
    return Object.prototype.toString.call(arr) === '[object Array]';
}
function trim(value) {
    return hasTrim ? ('' + value).trim() : ('' + value).replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
}
function isString(str) {
    return typeof str === 'string';
}
function strEqualsIgnoreCase(fistStr, secondStr) {
    return isString(fistStr) && isString(secondStr) && trim(fistStr.toLowerCase()) === trim(secondStr.toLowerCase());
}
function isObject(obj) {
    return !!obj && typeof obj === 'object' && !isArray(obj);
}
function isRecord(obj) {
    return isObject(obj);
}
function isFunction$1(fun) {
    return !!fun && typeof fun === 'function';
}
function _expiresIn(expires, number) {
    return new Date((new Date().getTime() + (expires * number)));
}
function expiresInDays(expires) {
    return _expiresIn(expires, 864e5);
}
function expiresInHours(expires) {
    return _expiresIn(expires, 36e5);
}
function wrapError(name, e, message) {
    if (isObject(e)) {
        var error = void 0;
        if ('message' in e && typeof e.message === 'string') {
            error = new Error(message || e.message);
        }
        else {
            error = new Error(message);
        }
        error.name = name;
        if ('stack' in e && typeof e.stack === 'string') {
            error.stack = e.stack;
        }
        if ('lineNumber' in e && typeof e.lineNumber === 'number') {
            error.lineNumber = e.lineNumber;
        }
        if ('columnNumber' in e && typeof e.columnNumber === 'number') {
            error.columnNumber = e.columnNumber;
        }
        return error;
    }
    else {
        var error = Error(message);
        error.name = name;
        return error;
    }
}

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */


var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

var ERRORS_CHANNEL = 'li_errors';

var ReplayEmitter = /** @class */ (function () {
    function ReplayEmitter(replaySize) {
        var size = parseInt(replaySize.toString()) || 5;
        this.data = {
            h: {},
            q: {},
            size: size
        };
    }
    ReplayEmitter.prototype.on = function (name, callback, ctx) {
        var _a;
        var handler = {
            callback: callback.bind(ctx),
            unbound: callback
        };
        this.data = __assign(__assign({}, this.data), { h: __assign(__assign({}, this.data.h), (_a = {}, _a[name] = __spreadArray(__spreadArray([], (this.data.h[name] || []), true), [handler], false), _a)) });
        (this.data.q[name] || []).forEach(function (i) { return callback.call(ctx, i); });
        return this;
    };
    ReplayEmitter.prototype.once = function (name, callback, ctx) {
        var _this = this;
        var eventQueue = this.data.q[name] || [];
        if (eventQueue.length > 0) {
            callback.call(ctx, eventQueue[0]);
            return this;
        }
        else {
            var listener_1 = function (args) {
                _this.off(name, listener_1);
                callback.call(ctx, args);
            };
            listener_1._ = callback;
            return this.on(name, listener_1, ctx);
        }
    };
    ReplayEmitter.prototype.emit = function (name, event) {
        var _a;
        (this.data.h[name] || []).forEach(function (i) { return i.callback(event); });
        var queue = this.data.q[name] || [];
        this.data = __assign(__assign({}, this.data), { q: __assign(__assign({}, this.data.q), (_a = {}, _a[name] = __spreadArray(__spreadArray([], (queue.length < this.data.size ? queue : queue.slice(1)), true), [event], false), _a)) });
        return this;
    };
    ReplayEmitter.prototype.off = function (name, callback) {
        var _a;
        var handlers = this.data.h[name];
        var liveHandlers = (handlers && callback && handlers.filter(function (h) { return h.unbound !== callback; })) || [];
        if (liveHandlers.length) {
            this.data = __assign(__assign({}, this.data), { h: __assign(__assign({}, this.data.h), (_a = {}, _a[name] = liveHandlers, _a)) });
        }
        else {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var _b = this.data.h, _c = name; _b[_c]; var rest = __rest(_b, [typeof _c === "symbol" ? _c : _c + ""]);
            this.data = __assign(__assign({}, this.data), { h: rest });
        }
        return this;
    };
    ReplayEmitter.prototype.emitErrorWithMessage = function (name, message, exception) {
        var wrappedError = wrapError(name, exception, message);
        return this.emit(ERRORS_CHANNEL, wrappedError);
    };
    ReplayEmitter.prototype.emitError = function (name, exception) {
        var wrappedError = wrapError(name, exception);
        return this.emit(ERRORS_CHANNEL, wrappedError);
    };
    return ReplayEmitter;
}());

dist.ERRORS_CHANNEL = ERRORS_CHANNEL;
dist.ReplayEmitter = ReplayEmitter;
dist.UUID = UUID;
dist.expiresInDays = expiresInDays;
dist.expiresInHours = expiresInHours;
dist.isArray = isArray;
dist.isFunction = isFunction$1;
dist.isNonEmpty = isNonEmpty;
dist.isObject = isObject;
dist.isRecord = isRecord;
dist.isString = isString;
dist.isUUID = isUUID;
dist.nonNull = nonNull;
dist.safeToString = safeToString;
dist.strEqualsIgnoreCase = strEqualsIgnoreCase;
dist.trim = trim;
dist.wrapError = wrapError;

// Generated by rollup-plugin-mjs-entry

const isFunction = dist.isFunction;

var DefaultCallHandler = /** @class */ (function () {
    function DefaultCallHandler() {
    }
    DefaultCallHandler.prototype.ajaxGet = function (url, responseHandler, onError, timeout) {
        if (timeout === void 0) { timeout = 1000; }
        function errorCallback(message) {
            isFunction(onError) && onError(new Error(message));
        }
        function xhrCall() {
            var xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4) {
                    if ((xhr.status >= 200 && xhr.status < 300) || xhr.status === 304) {
                        responseHandler(xhr.responseText, xhr);
                    }
                    else {
                        errorCallback("Error during XHR call: ".concat(xhr.status, ", url: ").concat(url));
                    }
                }
            };
            return xhr;
        }
        function xdrCall() {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            var xdr = new window.XDomainRequest();
            xdr.onprogress = function () { return undefined; };
            xdr.onerror = function () { return errorCallback("Error during XDR call: ".concat(xdr.responseText, ", url: ").concat(url)); };
            xdr.onload = function () { return responseHandler(xdr.responseText, xdr); };
            return xdr;
        }
        try {
            var request = (window && window.XDomainRequest) ? xdrCall() : xhrCall();
            request.ontimeout = function () { return errorCallback("Timeout after ".concat(timeout, ", url : ").concat(url)); };
            request.open('GET', url, true);
            request.timeout = timeout;
            request.withCredentials = true;
            request.send();
        }
        catch (error) {
            errorCallback("Error while constructing ajax request, ".concat(error, ", url: ").concat(url));
        }
    };
    DefaultCallHandler.prototype.pixelGet = function (uri, onload) {
        var img = new window.Image();
        if (isFunction(onload)) {
            img.onload = onload;
        }
        img.src = uri;
    };
    return DefaultCallHandler;
}());

/*! js-cookie v3.0.5 | MIT */
/* eslint-disable no-var */
function assign (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];
    for (var key in source) {
      target[key] = source[key];
    }
  }
  return target
}
/* eslint-enable no-var */

/* eslint-disable no-var */
var defaultConverter = {
  read: function (value) {
    if (value[0] === '"') {
      value = value.slice(1, -1);
    }
    return value.replace(/(%[\dA-F]{2})+/gi, decodeURIComponent)
  },
  write: function (value) {
    return encodeURIComponent(value).replace(
      /%(2[346BF]|3[AC-F]|40|5[BDE]|60|7[BCD])/g,
      decodeURIComponent
    )
  }
};
/* eslint-enable no-var */

/* eslint-disable no-var */

function init (converter, defaultAttributes) {
  function set (name, value, attributes) {
    if (typeof document === 'undefined') {
      return
    }

    attributes = assign({}, defaultAttributes, attributes);

    if (typeof attributes.expires === 'number') {
      attributes.expires = new Date(Date.now() + attributes.expires * 864e5);
    }
    if (attributes.expires) {
      attributes.expires = attributes.expires.toUTCString();
    }

    name = encodeURIComponent(name)
      .replace(/%(2[346B]|5E|60|7C)/g, decodeURIComponent)
      .replace(/[()]/g, escape);

    var stringifiedAttributes = '';
    for (var attributeName in attributes) {
      if (!attributes[attributeName]) {
        continue
      }

      stringifiedAttributes += '; ' + attributeName;

      if (attributes[attributeName] === true) {
        continue
      }

      // Considers RFC 6265 section 5.2:
      // ...
      // 3.  If the remaining unparsed-attributes contains a %x3B (";")
      //     character:
      // Consume the characters of the unparsed-attributes up to,
      // not including, the first %x3B (";") character.
      // ...
      stringifiedAttributes += '=' + attributes[attributeName].split(';')[0];
    }

    return (document.cookie =
      name + '=' + converter.write(value, name) + stringifiedAttributes)
  }

  function get (name) {
    if (typeof document === 'undefined' || (arguments.length && !name)) {
      return
    }

    // To prevent the for loop in the first place assign an empty array
    // in case there are no cookies at all.
    var cookies = document.cookie ? document.cookie.split('; ') : [];
    var jar = {};
    for (var i = 0; i < cookies.length; i++) {
      var parts = cookies[i].split('=');
      var value = parts.slice(1).join('=');

      try {
        var found = decodeURIComponent(parts[0]);
        jar[found] = converter.read(value, found);

        if (name === found) {
          break
        }
      } catch (e) {}
    }

    return name ? jar[name] : jar
  }

  return Object.create(
    {
      set,
      get,
      remove: function (name, attributes) {
        set(
          name,
          '',
          assign({}, attributes, {
            expires: -1
          })
        );
      },
      withAttributes: function (attributes) {
        return init(this.converter, assign({}, this.attributes, attributes))
      },
      withConverter: function (converter) {
        return init(assign({}, this.converter, converter), this.attributes)
      }
    },
    {
      attributes: { value: Object.freeze(defaultAttributes) },
      converter: { value: Object.freeze(converter) }
    }
  )
}

var api = init(defaultConverter, { path: '/' });

var DefaultStorageHandler = /** @class */ (function () {
    function DefaultStorageHandler(eventBus) {
        this.eventBus = eventBus;
        this._localStorageIsEnabled = undefined;
        this.cookies = api.withConverter({
            read: function (value, name) {
                try {
                    var result = api.converter.read(value, name);
                    if (result === undefined) {
                        return null;
                    }
                    else {
                        return result;
                    }
                }
                catch (e) {
                    eventBus.emitErrorWithMessage('CookieReadError', "Failed reading cookie ".concat(name), e);
                    return null;
                }
            }
        });
    }
    DefaultStorageHandler.prototype.getCookie = function (key) {
        var result = this.cookies.get(key);
        if (result === undefined) {
            return null;
        }
        return result;
    };
    DefaultStorageHandler.prototype.findSimilarCookies = function (substring) {
        try {
            var allCookies_1 = this.cookies.get();
            return Object.keys(allCookies_1).filter(function (key) { return key.indexOf(substring) >= 0 && allCookies_1[key] !== null; }).map(function (key) { return allCookies_1[key]; });
        }
        catch (e) {
            this.eventBus.emitErrorWithMessage('CookieFindSimilarInJar', 'Failed fetching from a cookie jar', e);
            return [];
        }
    };
    DefaultStorageHandler.prototype.setCookie = function (key, value, expires, sameSite, domain) {
        if (expires) {
            var expiresDate = void 0;
            if (typeof expires === 'string') {
                expiresDate = new Date(expires);
            }
            else if (typeof expires === 'number') {
                expiresDate = new Date(Date.now() + expires * 864e5);
            }
            else {
                expiresDate = expires;
            }
            this.cookies.set(key, value, { domain: domain, expires: expiresDate, samesite: sameSite });
        }
        else {
            this.cookies.set(key, value, { domain: domain, samesite: sameSite });
        }
    };
    DefaultStorageHandler.prototype.localStorageIsEnabled = function () {
        if (this._localStorageIsEnabled == null) {
            this._localStorageIsEnabled = this.checkLocalStorage();
        }
        return this._localStorageIsEnabled;
    };
    DefaultStorageHandler.prototype.getDataFromLocalStorage = function (key) {
        if (this.localStorageIsEnabled()) {
            return window.localStorage.getItem(key);
        }
        else {
            return null;
        }
    };
    DefaultStorageHandler.prototype.setDataInLocalStorage = function (key, value) {
        if (this.localStorageIsEnabled()) {
            window.localStorage.setItem(key, value);
        }
    };
    DefaultStorageHandler.prototype.removeDataFromLocalStorage = function (key) {
        if (this.localStorageIsEnabled()) {
            window.localStorage.removeItem(key);
        }
    };
    DefaultStorageHandler.prototype.checkLocalStorage = function () {
        var enabled = false;
        try {
            if (window && window.localStorage) {
                var key = Math.random().toString();
                window.localStorage.setItem(key, key);
                enabled = window.localStorage.getItem(key) === key;
                window.localStorage.removeItem(key);
            }
        }
        catch (e) {
            this.eventBus.emitError('LSCheckError', e);
        }
        return enabled;
    };
    return DefaultStorageHandler;
}());

exports.DefaultCallHandler = DefaultCallHandler;
exports.DefaultStorageHandler = DefaultStorageHandler;
//# sourceMappingURL=index.js.map
