import { ErrorDetails } from './types';
export declare const UUID = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
export declare function safeToString(value: unknown): string;
export declare function nonNull<A>(value: A): value is NonNullable<A>;
export declare function isNonEmpty<A>(value: A): value is NonNullable<A>;
export declare function isUUID(value: unknown): value is string;
export declare function isArray(arr: unknown): arr is unknown[];
export declare function trim(value: unknown): string;
export declare function isString(str: unknown): str is string;
export declare function strEqualsIgnoreCase(fistStr: unknown, secondStr: unknown): boolean;
export declare function isObject(obj: unknown): obj is object;
export declare function isRecord(obj: unknown): obj is Record<string | symbol | number, unknown>;
export declare function isFunction(fun: unknown): fun is CallableFunction;
export declare function expiresInDays(expires: number): Date;
export declare function expiresInHours(expires: number): Date;
export declare function wrapError(name: string, e?: unknown, message?: string): ErrorDetails;
