import { EventBus } from './types';
export declare class ReplayEmitter implements EventBus {
    private data;
    constructor(replaySize: number | string);
    on<F extends ((event: unknown) => void)>(name: string, callback: F, ctx?: ThisParameterType<F>): this;
    once<F extends ((event: unknown) => void)>(name: string, callback: F, ctx?: ThisParameterType<F>): this;
    emit(name: string, event: unknown): this;
    off(name: string, callback: (event: unknown) => void): this;
    emitErrorWithMessage(name: string, message: string, exception?: unknown): this;
    emitError(name: string, exception: unknown): this;
}
