'use strict';

var UUID = '[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}';
var uuidRegex = new RegExp("^".concat(UUID, "$"), 'i');
var hasTrim = !!String.prototype.trim;
function safeToString(value) {
    return typeof value === 'object' ? JSON.stringify(value) : ('' + value);
}
function nonNull(value) {
    return value != null;
}
function isNonEmpty(value) {
    return nonNull(value) && trim(value).length > 0;
}
function isUUID(value) {
    return !!value && uuidRegex.test(trim(value));
}
function isArray(arr) {
    return Object.prototype.toString.call(arr) === '[object Array]';
}
function trim(value) {
    return hasTrim ? ('' + value).trim() : ('' + value).replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
}
function isString(str) {
    return typeof str === 'string';
}
function strEqualsIgnoreCase(fistStr, secondStr) {
    return isString(fistStr) && isString(secondStr) && trim(fistStr.toLowerCase()) === trim(secondStr.toLowerCase());
}
function isObject(obj) {
    return !!obj && typeof obj === 'object' && !isArray(obj);
}
function isRecord(obj) {
    return isObject(obj);
}
function isFunction(fun) {
    return !!fun && typeof fun === 'function';
}
function _expiresIn(expires, number) {
    return new Date((new Date().getTime() + (expires * number)));
}
function expiresInDays(expires) {
    return _expiresIn(expires, 864e5);
}
function expiresInHours(expires) {
    return _expiresIn(expires, 36e5);
}
function wrapError(name, e, message) {
    if (isObject(e)) {
        var error = void 0;
        if ('message' in e && typeof e.message === 'string') {
            error = new Error(message || e.message);
        }
        else {
            error = new Error(message);
        }
        error.name = name;
        if ('stack' in e && typeof e.stack === 'string') {
            error.stack = e.stack;
        }
        if ('lineNumber' in e && typeof e.lineNumber === 'number') {
            error.lineNumber = e.lineNumber;
        }
        if ('columnNumber' in e && typeof e.columnNumber === 'number') {
            error.columnNumber = e.columnNumber;
        }
        return error;
    }
    else {
        var error = Error(message);
        error.name = name;
        return error;
    }
}

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */


var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

var ERRORS_CHANNEL = 'li_errors';

var ReplayEmitter = /** @class */ (function () {
    function ReplayEmitter(replaySize) {
        var size = parseInt(replaySize.toString()) || 5;
        this.data = {
            h: {},
            q: {},
            size: size
        };
    }
    ReplayEmitter.prototype.on = function (name, callback, ctx) {
        var _a;
        var handler = {
            callback: callback.bind(ctx),
            unbound: callback
        };
        this.data = __assign(__assign({}, this.data), { h: __assign(__assign({}, this.data.h), (_a = {}, _a[name] = __spreadArray(__spreadArray([], (this.data.h[name] || []), true), [handler], false), _a)) });
        (this.data.q[name] || []).forEach(function (i) { return callback.call(ctx, i); });
        return this;
    };
    ReplayEmitter.prototype.once = function (name, callback, ctx) {
        var _this = this;
        var eventQueue = this.data.q[name] || [];
        if (eventQueue.length > 0) {
            callback.call(ctx, eventQueue[0]);
            return this;
        }
        else {
            var listener_1 = function (args) {
                _this.off(name, listener_1);
                callback.call(ctx, args);
            };
            listener_1._ = callback;
            return this.on(name, listener_1, ctx);
        }
    };
    ReplayEmitter.prototype.emit = function (name, event) {
        var _a;
        (this.data.h[name] || []).forEach(function (i) { return i.callback(event); });
        var queue = this.data.q[name] || [];
        this.data = __assign(__assign({}, this.data), { q: __assign(__assign({}, this.data.q), (_a = {}, _a[name] = __spreadArray(__spreadArray([], (queue.length < this.data.size ? queue : queue.slice(1)), true), [event], false), _a)) });
        return this;
    };
    ReplayEmitter.prototype.off = function (name, callback) {
        var _a;
        var handlers = this.data.h[name];
        var liveHandlers = (handlers && callback && handlers.filter(function (h) { return h.unbound !== callback; })) || [];
        if (liveHandlers.length) {
            this.data = __assign(__assign({}, this.data), { h: __assign(__assign({}, this.data.h), (_a = {}, _a[name] = liveHandlers, _a)) });
        }
        else {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var _b = this.data.h, _c = name; _b[_c]; var rest = __rest(_b, [typeof _c === "symbol" ? _c : _c + ""]);
            this.data = __assign(__assign({}, this.data), { h: rest });
        }
        return this;
    };
    ReplayEmitter.prototype.emitErrorWithMessage = function (name, message, exception) {
        var wrappedError = wrapError(name, exception, message);
        return this.emit(ERRORS_CHANNEL, wrappedError);
    };
    ReplayEmitter.prototype.emitError = function (name, exception) {
        var wrappedError = wrapError(name, exception);
        return this.emit(ERRORS_CHANNEL, wrappedError);
    };
    return ReplayEmitter;
}());

exports.ERRORS_CHANNEL = ERRORS_CHANNEL;
exports.ReplayEmitter = ReplayEmitter;
exports.UUID = UUID;
exports.expiresInDays = expiresInDays;
exports.expiresInHours = expiresInHours;
exports.isArray = isArray;
exports.isFunction = isFunction;
exports.isNonEmpty = isNonEmpty;
exports.isObject = isObject;
exports.isRecord = isRecord;
exports.isString = isString;
exports.isUUID = isUUID;
exports.nonNull = nonNull;
exports.safeToString = safeToString;
exports.strEqualsIgnoreCase = strEqualsIgnoreCase;
exports.trim = trim;
exports.wrapError = wrapError;
//# sourceMappingURL=index.js.map
