export interface RetryOptions {
    /**
    The number of times to retry failed requests.

    @default 2
    */
    limit?: number;
    /**
    The HTTP methods allowed to retry.

    @default ['get', 'put', 'head', 'delete', 'options', 'trace']
    */
    methods?: string[];
    /**
    The HTTP status codes allowed to retry.

    @default [408, 413, 429, 500, 502, 503, 504]
    */
    statusCodes?: number[];
    /**
    The HTTP status codes allowed to retry with a `Retry-After` header.

    @default [413, 429, 503]
    */
    afterStatusCodes?: number[];
    /**
    If the `Retry-After` header is greater than `maxRetryAfter`, the request will be canceled.

    @default Infinity
    */
    maxRetryAfter?: number;
}
