"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toBeRequestedTimes = exports.toBeRequestedTimesFn = void 0;
const utils_1 = require("../../utils");
const expectAdapter_1 = require("../../util/expectAdapter");
const formatMessage_1 = require("../../util/formatMessage");
function toBeRequestedTimesFn(received, times = {}, options = {}) {
    const isNot = this.isNot || false;
    const { expectation = `called${typeof times === 'number' ? ' ' + times : ''} time${times !== 1 ? 's' : ''}`, verb = 'be' } = this;
    if (typeof times === 'number') {
        options.eq = times;
    }
    else if (typeof times === 'object') {
        options = { ...options, ...times };
    }
    const eq = options.eq;
    const gte = options.gte || 1;
    const lte = options.lte || 0;
    return browser.call(async () => {
        let actual;
        const pass = await utils_1.waitUntil(async () => {
            actual = received.calls.length;
            return utils_1.compareNumbers(actual, gte, lte, eq);
        }, isNot, { ...options, wait: isNot ? 0 : options.wait });
        const error = formatMessage_1.numberError(gte, lte, eq);
        const message = utils_1.enhanceError('mock', error, actual, this, verb, expectation, '', options);
        return {
            pass,
            message: () => message
        };
    });
}
exports.toBeRequestedTimesFn = toBeRequestedTimesFn;
function toBeRequestedTimes(...args) {
    return expectAdapter_1.runExpect.call(this, toBeRequestedTimesFn, args);
}
exports.toBeRequestedTimes = toBeRequestedTimes;
