Documentation.js supports customizable themes for HTML output. A theme is a Node.js
module that exports a single function with the following signature:

```
/**
 * @function
 * @param {Array<Object>} comments - an array of comments to be output
 * @param {Object} options - theme options
 * @param {ThemeCallback} callback - see below
 */

/**
 * @callback ThemeCallback
 * @param {?Error} error
 * @param {?Array<vinyl.File>} output
 */
```

The theme function should call the callback with either an error, if one occurs,
or an array of [vinyl](https://github.com/gulpjs/vinyl) `File` objects.

The theme is free to implement HTML generation however it chooses. See
[the default theme](https://github.com/documentationjs/documentation/tree/master/src/default_theme)
for some ideas.

### Customizing the Default Theme

**Instructions**

- Copy contents of `default_theme` folder (noted above) into a new folder in your project.  One way to do it is to create a new git repository with the folder contents and add this line to your `package.json` `devDependencies` section:    `"docjs-theme": "my-gh-username/reponame"`.   That way when you install dependencies, your new theme will be in the projects `node_modules` folder.

- In the folder you created, replace `require('../')` on lines 8 and 9 of `index.js` with `require('documentation')` and save.

- You can now make changes that will show up when you generate your docs using your theme.   Example `package.json` `scripts` entry: `"documentation build index.js -f html -o docs --theme node_modules/docjs-theme"`

#### Changes to Default Theme Via documentation.yml
If a documentation.yml file is used to establish a table of contents for your documentation, small changes to the default style can be made via a <style> element in the documentation.yml file. 
  
For example, if you have you have a section header and text to describe the section, you can put it at the same level of the text as shown below:

```
- name: Section Header Name
    description: |
      <head>
        <style>
        h2{
          color:black;
        }
          code.black{
            background-color: #295377;
            overflow: hidden;
            padding: 0.5rem;
            color: white;
            font: 0.8rem Inconsolata, monospace;
            width:100%;          
          }
        </style>
      </head>

      ### Sub Section header
      Text that describes the section and sub-section here.
```
Any changes to elements and classes that also exist in the standard theme will be overwridden by what is in the documentation.yml. This opens up the possiblitity of the same CSS being defined twice, which can be confusing and is not best practice. However, it is easy to change HTML style this way. Recommend only using classes defined this way that do not exist in the standard documentation.js theme.

### Theming Markdown

The default Markdown generator for documentation.js isn't customizable - instead
of a plain-text theme, it's generated by creating an AST and then rendering
it with [remark](https://remark.js.org/). If you need something extra in Markdown,
you can either rally for that thing to be included in the default theme,
or you can hack around it by using an HTML theme that outputs Markdown.
