# Configuring documentation.js

Configuration is a completely optional step for generating documentation
with documentation.js. The tool is designed to accept any JSDoc-annotated
source code and automatically generate output.

Configuration - a `documentation.yml` file - will accomplish two goals:

* Organization: you can put top level documentation in order of importance
* Narration: you can add narrative sections - plain English writing - in
  between autogenerated API documentation.
  
Specify the configuration file with the `--config` command-line option.
```sh
$ documentation build --config documentation.yml ...
```

Here's how `documentation.yml` works:

```yml
toc:
  - Map
  - name: Geography
    description: |
      These are Mapbox GL JS's ways of representing locations
      and areas on the sphere.
  - LngLat
  - LngLatBounds
```

This puts the top level API documentation for the `Map`, `LngLat`, and `LngLatBounds`
items in the given order, and inserts a narrative item titled `Geography`
after the section on maps. The `description` property of that narrative item
is interpreted as Markdown.
If you would like reuse your existing markdown files or just keep the content separate from the configuration you can use the `file` property. It is a filename it will be resolved against the directory that the `documentation.yml` file resides in.

So with a `documentation.yml` file like this

```yml
toc:
  - Map
  - name: Geography
    file: geo.md
  - LngLat
  - LngLatBounds
```

and a file `geo.md`

```markdown
These are Mapbox GL JS's ways of representing locations
and areas on the sphere.
```

it would produce the same output as the previous example.

## Groups

The `children` property can be used to group content under headings instead of just arranging them in order. Example:

```yml
toc:
  - name: Geography
    children:
      - Map
      - LngLat
      - LngLatBounds
  - name: Navigation
    description: |
      Here are some helper functions for navigation.
    children:
      - shortestPath
      - salesman
```
