# Changelog

All notable changes to this project will be documented in this file. See [standard-version](https://github.com/conventional-changelog/standard-version) for commit guidelines.

## [14.0.1](https://github.com/documentationjs/documentation/compare/v14.0.0...v14.0.1) (2022-12-14)

### Improvements
* chore: upgrade git-url-parse to 13.1.0 to fix vulnerabilities  [#1565](https://github.com/documentationjs/documentation/pull/1565)

## [14.0.0](https://github.com/documentationjs/documentation/compare/v14.0.0-alpha.1...v14.0.0) (2022-08-19)

## [14.0.0-alpha.1](https://github.com/documentationjs/documentation/compare/v14.0.0-alpha.0...v14.0.0-alpha.1) (2022-08-07)


### Features

* :sparkles: update Babel, copy list of plugins from Prettier ([3f187d7](https://github.com/documentationjs/documentation/commit/3f187d73132c6667a9140bd491c5f703c1f37c40))

## [14.0.0-alpha.0](https://github.com/documentationjs/documentation/compare/v13.2.5...v14.0.0-alpha.0) (2022-08-05)


### ⚠ BREAKING CHANGES

* all Extensions whould contains '.' so that mean if you have just 'ts' then need to convert to '.ts'
* external parameter was removed
Migration plan propose to move all external resources to input usages
Motivation: packages has many inputs which describe in package.json
so that mean need each time to parse all package.json of exsternal resources to understand which etry point need to pick.
But it is base on guesses because entry point may could not contains a documentation and the best way to handle it manualy.
* The serve parametr was remove, you can use any other tools which could be refresh and store your html site
The private parameter has removed, use a access
* documentation.js will now require node 14 or later.

### Bug Fixes

* add micromark dependencies fixed [#1381](https://github.com/documentationjs/documentation/issues/1381) ([3ba8165](https://github.com/documentationjs/documentation/commit/3ba81659d7db5d9393fa083287d91db93d6aab5e))
* add TS and TSX as default extensions fixed [#1377](https://github.com/documentationjs/documentation/issues/1377) ([f0cb1c0](https://github.com/documentationjs/documentation/commit/f0cb1c0bb1d97228c7baab453e50e5dbe283ea46))
* external was removed as prefer of input usages ([e3c59d7](https://github.com/documentationjs/documentation/commit/e3c59d77e4e3cf6e5fabab7c0d853a06a77f6288))
* html report, it is return html if output is not defined ([0975871](https://github.com/documentationjs/documentation/commit/0975871b34b8cc0af74e0aebb43f2727e0ab9960))
* remove private parameter, use access (BREAKING CHANGES) ([874069c](https://github.com/documentationjs/documentation/commit/874069c0b3647dad413667f61d05f6d39992995d))
* The server parameter deprecated and will be remove in next Major version fixed [#1413](https://github.com/documentationjs/documentation/issues/1413) ([810e08b](https://github.com/documentationjs/documentation/commit/810e08b6fdb1076a1758bff831a9f42890f0f25f))
* use process.cwd vs `.` which can fail ([4cc70a5](https://github.com/documentationjs/documentation/commit/4cc70a5aed0c233cdcc72077733f9da8450be386))


* replace module-deps-sortable on own implementation to control how parse files ([abb781a](https://github.com/documentationjs/documentation/commit/abb781a69ac69423da11346f62d7064382bb7b74))
* Update Node minimum version to 14 ([fc0bb3c](https://github.com/documentationjs/documentation/commit/fc0bb3cd885b9577e6f1f6935e15d4ec24f89114))

### [13.2.5](https://github.com/documentationjs/documentation/compare/v13.2.4...v13.2.5) (2021-04-24)


### Bug Fixes

* add gfm format for remark fixed [#1374](https://github.com/documentationjs/documentation/issues/1374) ([#1375](https://github.com/documentationjs/documentation/issues/1375)) ([6b5bc25](https://github.com/documentationjs/documentation/commit/6b5bc2548db23fdab3fd8d29ac1aeedea7ad3a47))
* jsx should be included for tsx files but not for ts fixed [#1359](https://github.com/documentationjs/documentation/issues/1359) ([#1373](https://github.com/documentationjs/documentation/issues/1373)) ([00d434f](https://github.com/documentationjs/documentation/commit/00d434f8576969b00d53a20efebb52a880acf350))

### [13.2.4](https://github.com/documentationjs/documentation/compare/v13.2.3...v13.2.4) (2021-04-21)


### Bug Fixes

* add support Vue 3 fixed [#1339](https://github.com/documentationjs/documentation/issues/1339) ([#1372](https://github.com/documentationjs/documentation/issues/1372)) ([cd7d123](https://github.com/documentationjs/documentation/commit/cd7d12366cc499ae8d40a64905354c3479f802f6))

### [13.2.3](https://github.com/documentationjs/documentation/compare/v13.2.2...v13.2.3) (2021-04-20)

### [13.2.2](https://github.com/documentationjs/documentation/compare/v13.2.1...v13.2.2) (2021-04-20)


### Bug Fixes

* [@see](https://github.com/see) tags incorrectly formatted in markdown ouput fixed [#1337](https://github.com/documentationjs/documentation/issues/1337) ([5d8d450](https://github.com/documentationjs/documentation/commit/5d8d4504d52a5bb0a0432bf399bbd82d9e5ea7fc))

### [13.2.1](https://github.com/documentationjs/documentation/compare/v13.2.0...v13.2.1) (2021-04-06)

## [13.2.0](https://github.com/documentationjs/documentation/compare/v13.1.1...v13.2.0) (2021-03-13)


### Features

* Support import.meta ([d449e7c](https://github.com/documentationjs/documentation/commit/d449e7c3ca0abb7379ea4159b0ef0281059077eb)), closes [#1345](https://github.com/documentationjs/documentation/issues/1345)

### [13.1.1](https://github.com/documentationjs/documentation/compare/v13.1.0...v13.1.1) (2021-01-19)

## [13.1.0](https://github.com/documentationjs/documentation/compare/v13.0.2...v13.1.0) (2020-10-24)


### Features

* Add event members to md output ([#1336](https://github.com/documentationjs/documentation/issues/1336)) ([bc3233f](https://github.com/documentationjs/documentation/commit/bc3233fe7e414e65756cf50450ebad069e37506a))

### [13.0.2](https://github.com/documentationjs/documentation/compare/v13.0.1...v13.0.2) (2020-07-02)


### Bug Fixes

* Additional safety around detecting functions in HTML output ([a8b6ce1](https://github.com/documentationjs/documentation/commit/a8b6ce144ea380ad21ba99f03574f6258be10666))

### [13.0.1](https://github.com/documentationjs/documentation/compare/v13.0.0...v13.0.1) (2020-06-04)


### Bug Fixes

* 🐛 Error with flow opaque type and readme command ([78db9a4](https://github.com/documentationjs/documentation/commit/78db9a443a65bbe8ff202083351655e0cfa60004)), closes [#1322](https://github.com/documentationjs/documentation/issues/1322)
* 🐛 Fixes an issue when using object spread and $Exact ([106945c](https://github.com/documentationjs/documentation/commit/106945c6354f0b70335adf737c7b7fa296952cc3)), closes [#1324](https://github.com/documentationjs/documentation/issues/1324)

<a name="13.0.0"></a>
# [13.0.0](https://github.com/documentationjs/documentation/compare/v12.3.0...v13.0.0) (2020-05-09)


### Chores

* Update Node minimum version to 10 ([45a5257](https://github.com/documentationjs/documentation/commit/45a5257))


### BREAKING CHANGES

* documentation.js will now require node 10 or later.



<a name="12.3.0"></a>
# [12.3.0](https://github.com/documentationjs/documentation/compare/v12.2.0...v12.3.0) (2020-04-07)


### Features

* upgrade babel dependencies ([d0ec029](https://github.com/documentationjs/documentation/commit/d0ec029))



<a name="12.2.0"></a>
# [12.2.0](https://github.com/documentationjs/documentation/compare/v12.1.4...v12.2.0) (2020-03-31)


### Features

* support for the [@see](https://github.com/see) tag in Markdown & HTML ([48bb7a2](https://github.com/documentationjs/documentation/commit/48bb7a2))



<a name="12.1.4"></a>
## [12.1.4](https://github.com/documentationjs/documentation/compare/v12.1.3...v12.1.4) (2019-11-15)



<a name="12.1.3"></a>
## [12.1.3](https://github.com/documentationjs/documentation/compare/v12.1.2...v12.1.3) (2019-11-04)


### Bug Fixes

* upgrade git-url-parse to fix a parsing issue ([#1296](https://github.com/documentationjs/documentation/issues/1296)) ([344e804](https://github.com/documentationjs/documentation/commit/344e804))



<a name="12.1.2"></a>
## [12.1.2](https://github.com/documentationjs/documentation/compare/v12.1.1...v12.1.2) (2019-09-09)


### Bug Fixes

* check for empty diff ([#1273](https://github.com/documentationjs/documentation/issues/1273)) ([3e0958b](https://github.com/documentationjs/documentation/commit/3e0958b))



<a name="12.1.1"></a>
## [12.1.1](https://github.com/documentationjs/documentation/compare/v12.1.0...v12.1.1) (2019-08-01)


### Bug Fixes

* Git submodule support for repo names with a dot ([#1271](https://github.com/documentationjs/documentation/issues/1271)) ([27a29be](https://github.com/documentationjs/documentation/commit/27a29be))



<a name="12.1.0"></a>
# [12.1.0](https://github.com/documentationjs/documentation/compare/v12.0.3...v12.1.0) (2019-07-31)


### Features

* Add git submodules support to github linking ([#1270](https://github.com/documentationjs/documentation/issues/1270)) ([ec36b41](https://github.com/documentationjs/documentation/commit/ec36b41))



<a name="12.0.3"></a>
## [12.0.3](https://github.com/documentationjs/documentation/compare/v12.0.2...v12.0.3) (2019-07-22)


### Bug Fixes

* Allow skipped array arguments in destructuring. Fixes [#1247](https://github.com/documentationjs/documentation/issues/1247) ([#1266](https://github.com/documentationjs/documentation/issues/1266)) ([f9039e9](https://github.com/documentationjs/documentation/commit/f9039e9))



<a name="12.0.2"></a>
## [12.0.2](https://github.com/documentationjs/documentation/compare/v12.0.1...v12.0.2) (2019-07-16)



<a name="12.0.1"></a>
## [12.0.1](https://github.com/documentationjs/documentation/compare/v12.0.0...v12.0.1) (2019-07-10)


### Bug Fixes

* Crash when called with no inputs. yargs now variadic positional arguments undefined instead of [] ([821a15e](https://github.com/documentationjs/documentation/commit/821a15e))



<a name="12.0.0"></a>
# [12.0.0](https://github.com/documentationjs/documentation/compare/v11.0.1...v12.0.0) (2019-07-10)


* Formatted with Prettier ([8f36e75](https://github.com/documentationjs/documentation/commit/8f36e75))


### BREAKING CHANGES

* The next release will require Node 8



<a name="11.0.1"></a>
## [11.0.1](https://github.com/documentationjs/documentation/compare/v11.0.0...v11.0.1) (2019-06-12)


### Bug Fixes

* toc with children getting displayed as "note" ([#1253](https://github.com/documentationjs/documentation/issues/1253)) ([14298bb](https://github.com/documentationjs/documentation/commit/14298bb))



<a name="11.0.0"></a>
# [11.0.0](https://github.com/documentationjs/documentation/compare/v10.1.0...v11.0.0) (2019-05-08)


### Bug Fixes

* Fix parsing of optional parameters with annotations ([ca17de5](https://github.com/documentationjs/documentation/commit/ca17de5))


### Features

* Enable all parser plugins ([fa1b0b5](https://github.com/documentationjs/documentation/commit/fa1b0b5))
* Support exportNamespaceFrom in parser ([8fa141d](https://github.com/documentationjs/documentation/commit/8fa141d))


### BREAKING CHANGES

* this removes support for legacy decorators, because
in one place we had legacy and in another we didn't.



<a name="10.1.0"></a>
# [10.1.0](https://github.com/documentationjs/documentation/compare/v10.0.0...v10.1.0) (2019-04-25)


### Features

* TypeScript support & inference ([3773e02](https://github.com/documentationjs/documentation/commit/3773e02))



<a name="10.0.0"></a>
# [10.0.0](https://github.com/documentationjs/documentation/compare/v10.0.0-alpha.0...v10.0.0) (2019-04-18)


### Features

* Add flow inference for generators ([7947e97](https://github.com/documentationjs/documentation/commit/7947e97))
* Support async functions ([d31c3b7](https://github.com/documentationjs/documentation/commit/d31c3b7))
* Support classPrivateProperties in parser ([64ef671](https://github.com/documentationjs/documentation/commit/64ef671)), closes [#1216](https://github.com/documentationjs/documentation/issues/1216)
* Support generator functions ([8e3cd47](https://github.com/documentationjs/documentation/commit/8e3cd47))



<a name="10.0.0-alpha.0"></a>
# [10.0.0-alpha.0](https://github.com/documentationjs/documentation/compare/v9.3.1...v10.0.0-alpha.0) (2019-03-12)


### Features

* Support custom babel config ([#1205](https://github.com/documentationjs/documentation/issues/1205)) ([746d0a9](https://github.com/documentationjs/documentation/commit/746d0a9))


### BREAKING CHANGES

* this may change babel configuration loading, and is a
major change to the documentation.js approach to Babel.



<a name="9.3.1"></a>
## [9.3.1](https://github.com/documentationjs/documentation/compare/v9.3.0...v9.3.1) (2019-03-12)



<a name="9.3.0"></a>
# [9.3.0](https://github.com/documentationjs/documentation/compare/v9.2.1...v9.3.0) (2019-02-27)


### Features

* Add inner section ([#1212](https://github.com/documentationjs/documentation/issues/1212)) ([64c9ca6](https://github.com/documentationjs/documentation/commit/64c9ca6))



<a name="9.2.1"></a>
## [9.2.1](https://github.com/documentationjs/documentation/compare/v9.2.0...v9.2.1) (2019-02-26)



<a name="9.2.0"></a>
# [9.2.0](https://github.com/documentationjs/documentation/compare/v9.1.1...v9.2.0) (2019-02-22)


### Bug Fixes

* **default theme:** only render either note or section (fixes [#1113](https://github.com/documentationjs/documentation/issues/1113)) ([#1206](https://github.com/documentationjs/documentation/issues/1206)) ([fb0a27f](https://github.com/documentationjs/documentation/commit/fb0a27f))


### Features

* Add favicon option ([#1207](https://github.com/documentationjs/documentation/issues/1207)) ([5b045f2](https://github.com/documentationjs/documentation/commit/5b045f2))



<a name="9.1.1"></a>
## [9.1.1](https://github.com/documentationjs/documentation/compare/v9.1.0...v9.1.1) (2018-12-21)


### Bug Fixes

* inferred properties duplicating explicitly specified ones ([2d0bd0e](https://github.com/documentationjs/documentation/commit/2d0bd0e))



<a name="9.1.0"></a>
# [9.1.0](https://github.com/documentationjs/documentation/compare/v9.0.0...v9.1.0) (2018-12-17)


### Features

* support spead types ([ca5a681](https://github.com/documentationjs/documentation/commit/ca5a681))



<a name="9.0.0"></a>
# [9.0.0](https://github.com/documentationjs/documentation/compare/v9.0.0-alpha.1...v9.0.0) (2018-12-10)


### Features

* Support for the logical assignment operator ([58d2a2f](https://github.com/documentationjs/documentation/commit/58d2a2f)), closes [#1172](https://github.com/documentationjs/documentation/issues/1172)



<a name="9.0.0-alpha.1"></a>
# [9.0.0-alpha.1](https://github.com/documentationjs/documentation/compare/v9.0.0-alpha.0...v9.0.0-alpha.1) (2018-10-24)


### Bug Fixes

* **package:** update [@babel](https://github.com/babel)/parser to version 7.1.3 ([4dbb406](https://github.com/documentationjs/documentation/commit/4dbb406)), closes [#1145](https://github.com/documentationjs/documentation/issues/1145)
* add node-resolve to module-deps ([a033547](https://github.com/documentationjs/documentation/commit/a033547))
* add tests ([a4107dc](https://github.com/documentationjs/documentation/commit/a4107dc))


### Features

* add support for node resolve algo ([ddd675d](https://github.com/documentationjs/documentation/commit/ddd675d))



<a name="9.0.0-alpha.0"></a>
# [9.0.0-alpha.0](https://github.com/documentationjs/documentation/compare/v8.1.2...v9.0.0-alpha.0) (2018-09-21)


### Features

* Babel 7 support ([49c0f72](https://github.com/documentationjs/documentation/commit/49c0f72))


### BREAKING CHANGES

* This moves documentation.js to Babel 7. From now on,
documentation.js will only support Babel 7: please stick to older
releases if you need to support Babel 6. Additionally, this work
temporarily disables support for following dynamic imports.



<a name="8.1.2"></a>
## [8.1.2](https://github.com/documentationjs/documentation/compare/v8.1.1...v8.1.2) (2018-08-23)


### Bug Fixes

* membership infering for methods ([#1122](https://github.com/documentationjs/documentation/issues/1122)) ([40b1783](https://github.com/documentationjs/documentation/commit/40b1783))



<a name="8.1.1"></a>
## [8.1.1](https://github.com/documentationjs/documentation/compare/v8.1.0...v8.1.1) (2018-08-17)


### Bug Fixes

* Serve on correct port ([4d59f6f](https://github.com/documentationjs/documentation/commit/4d59f6f))



<a name="8.1.0"></a>
# [8.1.0](https://github.com/documentationjs/documentation/compare/v8.0.2...v8.1.0) (2018-08-03)


### Bug Fixes

* **package:** update get-port to version 4.0.0 ([9ca8c06](https://github.com/documentationjs/documentation/commit/9ca8c06))


### Features

* added project description ([45a9ea9](https://github.com/documentationjs/documentation/commit/45a9ea9))



<a name="8.0.2"></a>
## [8.0.2](https://github.com/documentationjs/documentation/compare/v8.0.1...v8.0.2) (2018-07-20)


### Bug Fixes

* **package:** update git-url-parse to version 10.0.1 ([91ade89](https://github.com/documentationjs/documentation/commit/91ade89))



<a name="8.0.1"></a>
## [8.0.1](https://github.com/documentationjs/documentation/compare/v8.0.0...v8.0.1) (2018-07-16)


### Bug Fixes

* **package:** update read-pkg-up to version 4.0.0 ([c700d3f](https://github.com/documentationjs/documentation/commit/c700d3f))



<a name="8.0.0"></a>
# [8.0.0](https://github.com/documentationjs/documentation/compare/v7.1.0...v8.0.0) (2018-06-04)


### Features

* Semantic markdown headings ([#1087](https://github.com/documentationjs/documentation/issues/1087)) ([ca6217f](https://github.com/documentationjs/documentation/commit/ca6217f))


### BREAKING CHANGES

* changes Markdown output



<a name="7.1.0"></a>
# [7.1.0](https://github.com/documentationjs/documentation/compare/v7.0.0...v7.1.0) (2018-05-26)


### Features

* support flow comment types ([85d50f9](https://github.com/documentationjs/documentation/commit/85d50f9))



<a name="7.0.0"></a>
# [7.0.0](https://github.com/documentationjs/documentation/compare/v6.3.3...v7.0.0) (2018-05-22)


### Features

* Auto-detect readme filename ([4fd776b](https://github.com/documentationjs/documentation/commit/4fd776b))


### BREAKING CHANGES

* the --readme-file option now has a smart default value



<a name="6.3.3"></a>
## [6.3.3](https://github.com/documentationjs/documentation/compare/v6.3.2...v6.3.3) (2018-05-14)



<a name="6.3.2"></a>
## [6.3.2](https://github.com/documentationjs/documentation/compare/v6.3.1...v6.3.2) (2018-04-24)


### Bug Fixes

* **vue:** Make vue parser tolerant of components that don't contain scripts ([#1061](https://github.com/documentationjs/documentation/issues/1061)) ([8f9bc7b](https://github.com/documentationjs/documentation/commit/8f9bc7b)), closes [#1060](https://github.com/documentationjs/documentation/issues/1060)



<a name="6.3.1"></a>
## [6.3.1](https://github.com/documentationjs/documentation/compare/v6.3.0...v6.3.1) (2018-04-23)


### Bug Fixes

* adding vue support broke tests that are not file based ([#1058](https://github.com/documentationjs/documentation/issues/1058)) ([9d7bd2e](https://github.com/documentationjs/documentation/commit/9d7bd2e)), closes [#1057](https://github.com/documentationjs/documentation/issues/1057)



<a name="6.3.0"></a>
# [6.3.0](https://github.com/documentationjs/documentation/compare/v6.2.0...v6.3.0) (2018-04-20)


### Bug Fixes

* **package:** update git-url-parse to version 9.0.0 ([94a1fb6](https://github.com/documentationjs/documentation/commit/94a1fb6))


### Features

* Vue Support ([f60d90c](https://github.com/documentationjs/documentation/commit/f60d90c))



<a name="6.2.0"></a>
# [6.2.0](https://github.com/documentationjs/documentation/compare/v6.1.0...v6.2.0) (2018-04-11)


### Bug Fixes

* get rid of shelljs dependency ([630625d](https://github.com/documentationjs/documentation/commit/630625d))


### Features

* **doctrine:** Support decorator syntax in examples ([b309d39](https://github.com/documentationjs/documentation/commit/b309d39)), closes [#1016](https://github.com/documentationjs/documentation/issues/1016)
* **inferTypes:** Support class properties ([22d8740](https://github.com/documentationjs/documentation/commit/22d8740)), closes [#1043](https://github.com/documentationjs/documentation/issues/1043)



<a name="6.1.0"></a>
# [6.1.0](https://github.com/documentationjs/documentation/compare/v6.0.0...v6.1.0) (2018-03-08)


### Bug Fixes

* lends with object property using literal key ([#1035](https://github.com/documentationjs/documentation/issues/1035)) ([99ad49b](https://github.com/documentationjs/documentation/commit/99ad49b))


### Features

* Support class property [@type](https://github.com/type) tag ([#1028](https://github.com/documentationjs/documentation/issues/1028)) ([4ed5edf](https://github.com/documentationjs/documentation/commit/4ed5edf))



<a name="6.0.0"></a>
# [6.0.0](https://github.com/documentationjs/documentation/compare/v5.5.0...v6.0.0) (2018-03-02)


### Features

* documentation.js now requires node v6 or newer. ([#1034](https://github.com/documentationjs/documentation/issues/1034)) ([ccce516](https://github.com/documentationjs/documentation/commit/ccce516))


### BREAKING CHANGES

* documentation.js requires node v6 or newer.



<a name="5.5.0"></a>
# [5.5.0](https://github.com/documentationjs/documentation/compare/v5.4.0...v5.5.0) (2018-03-02)


### Bug Fixes

* github links for [@typedef](https://github.com/typedef) comments should link to comment, not context ([#1024](https://github.com/documentationjs/documentation/issues/1024)) ([37a91b2](https://github.com/documentationjs/documentation/commit/37a91b2))
* Make documentation.js compatible with node 4.x for one more version ([#1033](https://github.com/documentationjs/documentation/issues/1033)) ([5067ee0](https://github.com/documentationjs/documentation/commit/5067ee0))


### Features

* Support `--shallow` argument for `lint` command. Closes [#956](https://github.com/documentationjs/documentation/issues/956) ([#995](https://github.com/documentationjs/documentation/issues/995)) ([64f660d](https://github.com/documentationjs/documentation/commit/64f660d))
* Support the .mjs extension by default. ([#1023](https://github.com/documentationjs/documentation/issues/1023)) ([b8a7e0d](https://github.com/documentationjs/documentation/commit/b8a7e0d))
* use reference links for Markdown output, improving brevity ([ab494dd](https://github.com/documentationjs/documentation/commit/ab494dd))



<a name="5.4.0"></a>
# [5.4.0](https://github.com/documentationjs/documentation/compare/v5.3.5...v5.4.0) (2018-02-10)


### Bug Fixes

* **package:** update remark-toc to version 5.0.0 ([0bb3d0d](https://github.com/documentationjs/documentation/commit/0bb3d0d))


### Features

* add support for class param declarations at the constructor ([#1013](https://github.com/documentationjs/documentation/issues/1013)) ([05c5279](https://github.com/documentationjs/documentation/commit/05c5279))



<a name="5.3.5"></a>
## [5.3.5](https://github.com/documentationjs/documentation/compare/v5.3.4...v5.3.5) (2017-12-12)


### Bug Fixes

* **globals-docs:** Remove en-US from MDN links. ([#973](https://github.com/documentationjs/documentation/issues/973)) ([aa661ff](https://github.com/documentationjs/documentation/commit/aa661ff)), closes [#964](https://github.com/documentationjs/documentation/issues/964)



<a name="5.3.4"></a>
## [5.3.4](https://github.com/documentationjs/documentation/compare/v5.3.3...v5.3.4) (2017-12-12)


### Bug Fixes

* **package:** update babelify to version 8.0.0 ([10dff6f](https://github.com/documentationjs/documentation/commit/10dff6f))
* **package:** update read-pkg-up to version 3.0.0 ([d8fbf2c](https://github.com/documentationjs/documentation/commit/d8fbf2c))
* **package:** update remark-html to version 7.0.0 ([9842814](https://github.com/documentationjs/documentation/commit/9842814))
* **package:** update vinyl-fs to version 3.0.0 ([#966](https://github.com/documentationjs/documentation/issues/966)) ([1d6fe80](https://github.com/documentationjs/documentation/commit/1d6fe80))



<a name="5.3.3"></a>
## [5.3.3](https://github.com/documentationjs/documentation/compare/v5.3.2...v5.3.3) (2017-10-12)


### Bug Fixes

* **html:** Display all levels of parameter properties. ([#933](https://github.com/documentationjs/documentation/issues/933)) ([7a548eb](https://github.com/documentationjs/documentation/commit/7a548eb))
* **package:** update github-slugger to version 1.2.0 ([2b74956](https://github.com/documentationjs/documentation/commit/2b74956))
* Fix the split in HTML at 33/67% instead of calculating percentages ([#939](https://github.com/documentationjs/documentation/issues/939)) ([e4781eb](https://github.com/documentationjs/documentation/commit/e4781eb)), closes [#927](https://github.com/documentationjs/documentation/issues/927)



<a name="5.3.2"></a>
## [5.3.2](https://github.com/documentationjs/documentation/compare/v5.3.1...v5.3.2) (2017-09-15)


### Bug Fixes

* special property names in flowtypes ([7fc6ca8](https://github.com/documentationjs/documentation/commit/7fc6ca8))



<a name="5.3.1"></a>
## [5.3.1](https://github.com/documentationjs/documentation/compare/v5.3.0...v5.3.1) (2017-09-07)


### Bug Fixes

* cover more hideconstructor cases ([5bdbf1f](https://github.com/documentationjs/documentation/commit/5bdbf1f))
* Enable dynamicImport plugin to support import() syntax ([#903](https://github.com/documentationjs/documentation/issues/903)) ([b97241f](https://github.com/documentationjs/documentation/commit/b97241f)), closes [#902](https://github.com/documentationjs/documentation/issues/902)
* regression in toc causing crash ([125a577](https://github.com/documentationjs/documentation/commit/125a577))



<a name="5.3.0"></a>
# [5.3.0](https://github.com/documentationjs/documentation/compare/v5.2.2...v5.3.0) (2017-09-04)


### Bug Fixes

* [@name](https://github.com/name) tag disconnects comment ([#897](https://github.com/documentationjs/documentation/issues/897)) ([a04b6fd](https://github.com/documentationjs/documentation/commit/a04b6fd))


### Features

* groups in toc ([#895](https://github.com/documentationjs/documentation/issues/895)) ([c94412a](https://github.com/documentationjs/documentation/commit/c94412a))
* implement [@hideconstructor](https://github.com/hideconstructor) ([#898](https://github.com/documentationjs/documentation/issues/898)) ([7a07d51](https://github.com/documentationjs/documentation/commit/7a07d51))



<a name="5.2.2"></a>
## [5.2.2](https://github.com/documentationjs/documentation/compare/v5.2.1...v5.2.2) (2017-08-22)


### Bug Fixes

* **$compile:** prevent babel from transpiling non-module scripts in default_theme's assets ([1286a1f](https://github.com/documentationjs/documentation/commit/1286a1f))



<a name="5.2.1"></a>
## [5.2.1](https://github.com/documentationjs/documentation/compare/v5.2.0...v5.2.1) (2017-08-12)



<a name="5.2.0"></a>
# [5.2.0](https://github.com/documentationjs/documentation/compare/v5.1.1...v5.2.0) (2017-08-09)


### Bug Fixes

* alphabetical sort and add flow notation to sort file ([#861](https://github.com/documentationjs/documentation/issues/861)) ([aa3496a](https://github.com/documentationjs/documentation/commit/aa3496a)), closes [#838](https://github.com/documentationjs/documentation/issues/838)
* make html and markdown second option optional ([#871](https://github.com/documentationjs/documentation/issues/871)) ([0324865](https://github.com/documentationjs/documentation/commit/0324865)), closes [#869](https://github.com/documentationjs/documentation/issues/869)


### Features

* convert Flow's ThisTypeAnnotation to a doctrine NameExpression ([#870](https://github.com/documentationjs/documentation/issues/870)) ([23aa981](https://github.com/documentationjs/documentation/commit/23aa981))



<a name="5.1.1"></a>
## [5.1.1](https://github.com/documentationjs/documentation/compare/v5.1.0...v5.1.1) (2017-08-04)


### Bug Fixes

* **theme:** Remove dead stepsibling navigation code ([dccb151](https://github.com/documentationjs/documentation/commit/dccb151))
* cli options should override package.json options ([ecf16bd](https://github.com/documentationjs/documentation/commit/ecf16bd)), closes [#845](https://github.com/documentationjs/documentation/issues/845)



<a name="5.1.0"></a>
# [5.1.0](https://github.com/documentationjs/documentation/compare/v5.0.1...v5.1.0) (2017-07-31)


### Bug Fixes

* **scripts:** Remove changelog package.json task ([dddac19](https://github.com/documentationjs/documentation/commit/dddac19))


### Features

* **theme:** Flexible sidebar for default theme ([6509ae8](https://github.com/documentationjs/documentation/commit/6509ae8))



<a name="5.0.1"></a>
## [5.0.1](https://github.com/documentationjs/documentation/compare/v5.0.0...v5.0.1) (2017-07-28)



<a name="5.0.0"></a>
# [5.0.0](https://github.com/documentationjs/documentation/compare/v4.0.0...v5.0.0) (2017-07-27)


### Reverts

* **polyglot:** Remove polyglot mode ([5b373ff](https://github.com/documentationjs/documentation/commit/5b373ff)), closes [#850](https://github.com/documentationjs/documentation/issues/850) [#731](https://github.com/documentationjs/documentation/issues/731) [#702](https://github.com/documentationjs/documentation/issues/702) [#132](https://github.com/documentationjs/documentation/issues/132)


### BREAKING CHANGES

* **polyglot:** I'd like to still support C++ and other languages in the future! But I'm much
happier doing so by separating the extraction & input phases to the degree that documentation.js can
read the output of another module that extracts JSDoc comments from C++ code, rather than having CPP
support in it.



<a name="4.0.0"></a>
# [4.0.0](https://github.com/documentationjs/documentation/compare/v4.0.0-rc.1...v4.0.0) (2017-07-27)


### Bug Fixes

* **html output:** Fix links between navigation and items in HTML documentation ([5fb77bc](https://github.com/documentationjs/documentation/commit/5fb77bc))
* **package:** update babel-generator to version 6.25.0 ([#804](https://github.com/documentationjs/documentation/issues/804)) ([65f5a37](https://github.com/documentationjs/documentation/commit/65f5a37))
* **package:** update chalk to version 2.0.0 ([#833](https://github.com/documentationjs/documentation/issues/833)) ([2329db4](https://github.com/documentationjs/documentation/commit/2329db4))
* **package:** update github-slugger to version 1.1.3 ([#793](https://github.com/documentationjs/documentation/issues/793)) ([74392cc](https://github.com/documentationjs/documentation/commit/74392cc))
* Show () for callbacks ([61968c7](https://github.com/documentationjs/documentation/commit/61968c7))
* **package:** update micromatch to version 3.0.0 ([#792](https://github.com/documentationjs/documentation/issues/792)) ([3f2bf90](https://github.com/documentationjs/documentation/commit/3f2bf90))
* **package:** update remark to version 8.0.0 ([1ae8136](https://github.com/documentationjs/documentation/commit/1ae8136))
* Fix filtering in the default theme ([473f317](https://github.com/documentationjs/documentation/commit/473f317))
* Report nesting errors instead of throwing them as errors ([ea69608](https://github.com/documentationjs/documentation/commit/ea69608)), closes [#832](https://github.com/documentationjs/documentation/issues/832)
* **package:** update remark-html to version 6.0.1 ([#815](https://github.com/documentationjs/documentation/issues/815)) ([e472550](https://github.com/documentationjs/documentation/commit/e472550))
* **package:** update vfile-reporter to version 4.0.0 ([a3e1fb8](https://github.com/documentationjs/documentation/commit/a3e1fb8))



<a name="4.0.0-rc.1"></a>
# [4.0.0-rc.1](https://github.com/documentationjs/documentation/compare/v4.0.0-rc.0...v4.0.0-rc.1) (2017-05-01)


### Bug Fixes

* Infer parameters for classes from constructors ([355038d](https://github.com/documentationjs/documentation/commit/355038d)), closes [#689](https://github.com/documentationjs/documentation/issues/689)
* **document-exported:** Ensure that document-exported does not document constructors separately ([96a6d13](https://github.com/documentationjs/documentation/commit/96a6d13))
* **flow:** Fix inference of Flow types with properties ([#751](https://github.com/documentationjs/documentation/issues/751)) ([7c00acc](https://github.com/documentationjs/documentation/commit/7c00acc)), closes [#749](https://github.com/documentationjs/documentation/issues/749)
* **params:** Parameters with default use = not ? ([3cc4426](https://github.com/documentationjs/documentation/commit/3cc4426)), closes [#737](https://github.com/documentationjs/documentation/issues/737)


### Features

* **lint:** Identify explicit tags that don't match inference in lint stage ([ed5c2a0](https://github.com/documentationjs/documentation/commit/ed5c2a0))



<a name="4.0.0-rc.0"></a>
# [4.0.0-rc.0](https://github.com/documentationjs/documentation/compare/v4.0.0-beta.19...v4.0.0-rc.0) (2017-04-21)


### Bug Fixes

* **html output:** Fix github links in HTML output ([#745](https://github.com/documentationjs/documentation/issues/745)) ([9554b2f](https://github.com/documentationjs/documentation/commit/9554b2f)), closes [#738](https://github.com/documentationjs/documentation/issues/738)
* **params:** added code path for type RestElement ([6961ee8](https://github.com/documentationjs/documentation/commit/6961ee8))


### Code Refactoring

* **nest:** Better nesting implementation ([#732](https://github.com/documentationjs/documentation/issues/732)) ([7374730](https://github.com/documentationjs/documentation/commit/7374730))


### BREAKING CHANGES

* **nest:** referencing inferred destructure params without
renaming them, like $0.x, from JSDoc comments will no longer
work. To reference them, instead add a param tag to name the
destructuring param, and then refer to members of that name.

Before:

```js
/**
 * @param {number} $0.x a member of x
 */
function a({ x }) {}
```

After:

```js
/**
 * @param {Object} options
 * @param {number} options.x a member of x
 */
function a({ x }) {}
```

* Address review comments

* Reduce testing node requirement back down to 4

* Don't output empty properties, reduce diff noise

* Rearrange and document params

* Simplify param inference, update test fixtures. This is focused around Array destructuring: documenting destructured array elements with indices instead of names, because the names are purely internal details

* Use temporary fork to get through blocker



<a name="4.0.0-beta.19"></a>
# [4.0.0-beta.19](https://github.com/documentationjs/documentation/compare/v4.0.0-beta.18...v4.0.0-beta.19) (2017-04-10)


### Bug Fixes

* **inference:** Refactor membership inference ([84c9215](https://github.com/documentationjs/documentation/commit/84c9215))
* **inference:** Robust parsing for shorthand object methods ([802dc4c](https://github.com/documentationjs/documentation/commit/802dc4c))
* **scopes:** Support inner scope ([#665](https://github.com/documentationjs/documentation/issues/665)) ([8cc34b6](https://github.com/documentationjs/documentation/commit/8cc34b6))


### Features

* **core:** Support Flow interface declarations ([e2915dc](https://github.com/documentationjs/documentation/commit/e2915dc))
* **core:** Switch to Promises everywhere. Adopt Node v4 ES6 ([#648](https://github.com/documentationjs/documentation/issues/648)) ([631c692](https://github.com/documentationjs/documentation/commit/631c692))
* **markdown:** Add `[@see](https://github.com/see)` tag output in Markdown ([#682](https://github.com/documentationjs/documentation/issues/682)) ([f07285a](https://github.com/documentationjs/documentation/commit/f07285a))



<a name="4.0.0-beta.18"></a>
# [4.0.0-beta.18](https://github.com/documentationjs/documentation/compare/v4.0.0-beta.17...v4.0.0-beta.18) (2016-12-29)


### Bug Fixes

* **cli:** Fix error reporting in the CLI ([88c8f9a](https://github.com/documentationjs/documentation/commit/88c8f9a))
* **markdown:** Start headings in Markdown at h2 (#644) ([2ae5d8f](https://github.com/documentationjs/documentation/commit/2ae5d8f))

### Features

* **bin:** Support globs on windows and use smarter recursion (#629) ([cb8fdfa](https://github.com/documentationjs/documentation/commit/cb8fdfa)), closes [#607](https://github.com/documentationjs/documentation/issues/607)
* **markdown:** Add table of contents support for Markdown mode (#645) ([4c66fb1](https://github.com/documentationjs/documentation/commit/4c66fb1))

### Performance Improvements

* **dependencies:** Move standard-changelog to devDependencies (#636) ([7a66b3f](https://github.com/documentationjs/documentation/commit/7a66b3f))



<a name="4.0.0-beta.17"></a>
# [4.0.0-beta.17](https://github.com/documentationjs/documentation/compare/v4.0.0-beta16...v4.0.0-beta.17) (2016-12-23)

This release also fixes a mistake I was making with semver: pre-v4 beta
releases will be called `beta.17` and `beta.18` and so on, rather than
non-standard `beta16` without the `.`.


### Bug Fixes

* **hierarchy:** collect events from static and instance members (#628) ([f1e0267](https://github.com/documentationjs/documentation/commit/f1e0267)), closes [#486](https://github.com/documentationjs/documentation/issues/486)



<a name="4.0.0-beta16"></a>
# [4.0.0-beta16](https://github.com/documentationjs/documentation/compare/v4.0.0-beta15...v4.0.0-beta16) (2016-12-07)


### Bug Fixes

* **bin:** Remove dead code in documentation.js command (#627) ([ab16a20](https://github.com/documentationjs/documentation/commit/ab16a20))
* **extractors:** Document export default value (#623) ([363a108](https://github.com/documentationjs/documentation/commit/363a108)), closes [#543](https://github.com/documentationjs/documentation/issues/543)
* **parser:** Avoid error about deoptimization on very large files (#621) ([846ab94](https://github.com/documentationjs/documentation/commit/846ab94))

### Features

* **build:** load passed in config option (#625) ([89fb67f](https://github.com/documentationjs/documentation/commit/89fb67f))
* **output:** Display type information for typedefs in Markdown and HTML ([8b04029](https://github.com/documentationjs/documentation/commit/8b04029))




<a name="4.0.0-beta15"></a>
# [4.0.0-beta15](https://github.com/documentationjs/documentation/compare/v4.0.0-beta14...v4.0.0-beta15) (2016-11-23)

### Fixes

* Infer class augments tag in cases like `Foo extends React.Component`

### Features

* **config:** add file property for notes ([#614](https://github.com/documentationjs/documentation/issues/614)) ([d96aa47](https://github.com/documentationjs/documentation/commit/d96aa47)), closes [#609](https://github.com/documentationjs/documentation/issues/609)



## 4.0.0-beta14

* Highlight all Markdown, not just examples. Fixes #610
* Fix for `--config` only strip comments on json files (#611)
* Merge inferred return type like we do for params. Refs #359 (#604)
* Support webpack's System.import with nice handy babel plugin (#603)
* Format optional types with ? instead of [] (#538)
* Fix membership assignment for old-fashioned prototype members (#599)
* Update Node API documentation to include only exposed API surface
* Add too-much-inference troubleshooting topic

## 4.0.0-beta13

* Fix linker null reference error

## 4.0.0-beta12

* Update Doctrine to handle more JSDoc types
* Fix ReferenceError in default theme
* Show GitHub link for nested elements in default theme
* Fix linking resolution order

## 4.0.0-beta11

* Improved support for Flow: function types, object types, mixed types, null,
  void, typedefs
* New option: [sort-order](https://github.com/documentationjs/documentation/pull/535)
* Updates to Babylon 6.10.x
* Updates to dependencies, including yargs.
* [`document-exported` now traverses only exported code](https://github.com/documentationjs/documentation/pull/533).

## 4.0.0-beta10

* Lower memory consumption when dealing with large codebases
* Better support for detecting names and kinds of ES6-exported values
* New `document-exported` flag allows you to automatically document
  ES6-exported values, without even a comment! [490](https://github.com/documentationjs/documentation/pull/490)

## 4.0.0-beta5

* Add decorator support (zacharygolba)
* Add support to infer whether functions are private based on their name,
  like starting with `_` (arv)
* Improve internal documentation

## 4.0.0-beta4

* Fix minor dependency mistake

## 4.0.0-beta3

* Updates theme to a much-improved design
* Fix augments tag display in HTML
* Improve name detection of ES6-exported methods and variables
* Allow documentation of Object.prototype methods

## 4.0.0-beta2

Minor fixes

* Fixes `export { foo } from './bar'` style export
* Fixed CLI usage examples to simply say `documentation` instead of `/usr/bin/documentation` or
  similar.

## 4.0.0-beta1

**Now using Babel 6!**

Much long-awaited upgrade makes documentation.js compatible with fresh
new Babel-using codebases.

And also:

* GitHub Enterprise support
* New tag support: abstract, override, readonly, interface, variation, see, todo
  (only in parsing phase, not yet in all outputs)
* Parses jsx and es6 extensions by default, as well as .js
* Fixes polyglot mode
* Now shows the `@throws` tag content in Markdown output
* Support for example captions

## 4.0.0-beta

**Revitalized documentation.js command line interface!**

The `documentation` utility now takes commands:

* `documentation build` extracts and formats documentation
* `documentation serve` provides an auto-reloading server ([#236](https://github.com/documentationjs/documentation/pull/236))
* `documentation lint` reviews files for inconsistencies
* `documentation readme` patches API documentation into a readme ([#313](https://github.com/documentationjs/documentation/pull/313) by @anandthakker)

This functionality was previously included in `dev-documentation` and has
been folded into `documentation` proper.

**Much more flexible themes**

Themes are now much more customizable. In documentation.js 3.x and before, themes
were required to use Handlebars templates and produce a single page. In
documentation.js 4.x and beyond, they are JavaScript modules that can use
any template engine and produce any number of files. See the
[new theme documentation](https://github.com/documentationjs/documentation/blob/master/docs/THEMING.md) for
details.

**More precise traversal**

Inference in 4.x is stricter than in 3.x: comments must be adjacent
to the statements they document. This should make documentation generation
much more predictable.

**Support for the revealing module pattern**

```js
/** Foo */
function Foo() {
  /** Test */
  function bar() {}
  return {
    bar: bar
  };
}
````

New support for the [JavaScript module pattern](http://www.macwright.org/2012/06/04/the-module-pattern.html)!
This was implemented in [#324](https://github.com/documentationjs/documentation/pull/324)
by [Charlie Brown](https://github.com/carbonrobot).

**Breaking changes**

* documentation.js now follows the [JSDoc standard's interpretation of the @name tag](http://usejsdoc.org/tags-name.html):
  specifying a name tag will turn off inference. If you still want inference
  but want to call code something else, use the [@alias tag](http://usejsdoc.org/tags-alias.html) instead.

## 3.0.4

* Allow parameter types to be mixed into explicit parameter documentation. (#239 and #232)
* Support GitHub links in Markdown output (#238)

## 3.0.3

* Infer typedefs from Flow type aliases. Fixes #227
* Fix type-annotated rest expressions, raised in #230

## 3.0.2

* Infer rest parameters. Fixes #223
* Avoid filtering comments in lint mode. Fixes #186
* Nest both properties and params. Fixes #164

## 3.0.1

* BUGFIX: Fix default theme resolution [#212](https://github.com/documentationjs/documentation/pull/212)

## 3.0.0

The largest change to documentation.js so far.

**Dropping streams**

This a major refactor of the documentation.js interface with a focus on
simplifying the system. Up until this point, documentation.js was built around
[node.js streams](https://nodejs.org/api/stream.html), which are low-level
representations of asynchronous series of data. While this abstraction was
appropriate for the input and github streams, which are asynchronous, the
majority of documentation.js's internals are simple and synchronous functions
for which basic functional composition makes more sense than stream
semantics.

Documentation 3.0.0 uses simple functional composition for operations like
parmameter inference, rather than streams.

**Stronger support for ES6, ES7, and Flow**

We've switched to [Babel](https://babeljs.io/) as our source code parser,
which means that we have much broader support of new JavaScript features,
including import/export syntax and new features in ES6.

Babel also parses [Flow type annotations](http://flowtype.org/docs/type-annotations.html),
and new inference code means that we can infer

* Parameter names & types
* Return types

Without any explicit JSDoc tags. This means that for many simple functions,
we can generate great documentation with less writing.

**Stronger module support**

Documentation.js now has much better inference for membership and names of symbols
exported via `exports` or `module.exports`.

**Support for nested symbols**

The parent/child relationship between symbols is now fully hierarchical, and
symbols can be nested to any depth. For instance:

```
/**
 * A global Parent class.
 */
var Parent = function () {};

/**
 * A Child class.
 */
Parent.Child = function () {};

/**
 * A Grandchild class.
 */
Parent.Child.Grandchild = function () {};
```

In addition, filtering by access is now applied to the entire hierarchy: if you
mark a class as `@private`, neither it nor its children will be included in the
output by default, regardless of the access specifiers of the children.

**mdast-based Markdown output**

We've switched from templating Markdown output with [Handlebars.js](http://handlebarsjs.com/)
to generating an [abstract syntax tree](https://en.wikipedia.org/wiki/Abstract_syntax_tree)
of desired output and stringifying it with [mdast](https://github.com/wooorm/mdast).
This lets documentation.js output complex Markdown without having to worry
about escaping and properly formatting certain elements.

**Test coverage 100%**

documentation.js returns to 100% test coverage, so every single line
of code is covered by our large library of text fixtures and specific tests.

**--lint mode**

Specifying the `--lint` flag makes documentation.js check for non-standard
types, like `String`, or missing namespaces. If the encountered files have
any problems, it pretty-prints helpful debug messages and exits with status 1,
and otherwise exits with no output and status 0.

**Breaking changes**

* The `--version` flag is now `--project-version`. `--version` now outputs
  documentation.js's version

## 2.0.1

* Fixes `@param` tags that refer to properties of unmentioned objects: these
  will warn instead of crashing. For instance, `/** @param {boolean} foo.bar */`.
* Expose `--shallow` option in CLI

## 2.0.0

* Breaking: Removes `docset` support from documentation.js: this will be supported
  by a 3rd party tool in the future. This removal means that we no longer have
  node-sqlite3 as a dependency, and documentation can be installed on systems
  without a compile toolchain.
* JSDoc parse errors are now printed to stderr.
* Parameter tags that document sub-parameters, such as `@param {Type} options.option`,
  are now nested under their parent parameter.
* HTML output now includes events.
* Error messages now include source file name and line number.
* @typedef names are now inferred correctly.

## 1.4.0

* Output for the `@throws` tag.
* Output in HTML for the `@properties` tag.

## 1.3.0

* Now infers `name` from `class` and `event` tags
* Support for documenting C++ code with the `polyglot` option and `--polyglot` CLI option
* Fixed github linking
* Support for [JSDoc3-style bracketed optional parameters](http://usejsdoc.org/tags-param.html#optional-parameters-and-default-values), like

```js
/**
 * @param {Type} [param=defaultValue]
 */
```

## 1.2.0

* Transforms in package.json `browserify.transform` fields are now applied to
  source code so that babel, etc can be supported.
* Fixes crash caused by requiring JSON files

## 1.1.0

* Add `external` option that allows the user to whitelist specific external
  modules to be included in with documentation.

## 1.0.7

* Fixes sorting order of documentation
* Switches order of static and instance members in output
