"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var jsbnLite_1 = require("./jsbnLite");
var sha256_1 = require("./sha256");
function verify(code, hash, nStrPubKey, ePubKey) {
    var x = new jsbnLite_1.BigInteger(jsbnLite_1.b64toHex(hash));
    var m = new jsbnLite_1.BigInteger(jsbnLite_1.b64toHex(nStrPubKey));
    var r = x.modPowInt(ePubKey, m);
    return jsbnLite_1.removeExtraSymbols(r.toHexString()) === sha256_1.Sha256.hash(code);
}
exports.verify = verify;
