import { Options, Capabilities } from '@wdio/types';
import SevereServiceErrorImport from './utils/SevereServiceError';
import type { Browser, MultiRemoteBrowser, AttachOptions } from './types';
export declare type RemoteOptions = Options.WebdriverIO & Omit<Options.Testrunner, 'capabilities'>;
/**
 * A method to create a new session with WebdriverIO
 *
 * @param  {Object} [params={}]       Options to create the session with
 * @param  {function} remoteModifier  Modifier function to change the monad object
 * @return {object}                   browser object with sessionId
 */
export declare const remote: (params: RemoteOptions, remoteModifier?: Function | undefined) => Promise<Browser<'async'>>;
export declare const attach: (attachOptions: AttachOptions) => Promise<Browser<'async'>>;
export declare const multiremote: (params: Capabilities.MultiRemoteCapabilities, { automationProtocol }?: {
    automationProtocol?: string | undefined;
}) => Promise<MultiRemoteBrowser<'async'>>;
export declare const SevereServiceError: typeof SevereServiceErrorImport;
export * from './types';
export * from './utils/interception/types';
//# sourceMappingURL=index.d.ts.map