"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const uuid_1 = require("uuid");
/**
 * The Get Window Handles command returns a list of window handles
 * for every open top-level browsing context.
 * The order in which the window handles are returned is arbitrary.
 *
 * @alias browser.getWindowHandles
 * @see https://w3c.github.io/webdriver/#dfn-get-window-handles
 * @return {string[]}  An array which is a list of window handles.
 */
async function getWindowHandles() {
    let newPages = await this.browser.pages();
    const stalePageIds = [];
    this.windows.forEach((page, id) => {
        if (newPages.includes(page)) {
            newPages = newPages.filter(newPage => page !== newPage);
        }
        else {
            stalePageIds.push(id);
        }
    });
    // remove stale pages that were closed with JavaScript
    stalePageIds.forEach(pageId => this.windows.delete(pageId));
    // add new pages that were created within another target
    newPages.forEach(page => this.windows.set(uuid_1.v4(), page));
    return Array.from(this.windows.keys());
}
exports.default = getWindowHandles;
