import type { Browser, Element } from 'webdriverio';
declare global {
    var WDIO_WORKER: boolean;
}
/**
 * wraps a function into a Fiber ready context to enable sync execution and hooks
 * @param  {Function}   fn             function to be executed
 * @param  {String}     commandName    name of that function
 * @param  {Function[]} beforeCommand  method to be executed before calling the actual function
 * @param  {Function[]} afterCommand   method to be executed after calling the actual function
 * @return {Function}   actual wrapped function
 */
export default function wrapCommand(commandName: string, fn: Function): (this: Browser<'async'> | Element<'async'>, ...args: any[]) => any;
//# sourceMappingURL=wrapCommand.d.ts.map